<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<jsp:useBean id="myBean" class="ibase.utility.training.ScheduledSFTP" scope="session"/>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Schedule SFTP Upload</title>
    <style>
        body {
            text-align: center;
        }

        /* Optional: Center the form specifically */
        form {
            display: inline-block;
            text-align: left;
        }
    </style>
</head>
<body>
    <h2>Schedule SFTP Upload</h2>
    
    <form action="ScheduledSFTP" method="post">
        <!-- Add any input fields or parameters needed for the SFTP uploader -->
        <!-- Example: -->
        <!-- <input type="text" name="parameterName" placeholder="Parameter Value" required> -->
        
        <br>
        
        <input type="submit" value="Schedule SFTP Upload">
    </form>

    <% 
        if (myBean != null) {
            out.println("<p>JavaBean is present in the session.</p>");
            out.println("<p>Executing SFTP upload...</p>");
            try {
                // Call the method scheduleSFTPUpload() of ScheduledSFTP
                myBean.scheduleSFTPUpload();
                
                out.println("<p>SFTP Upload Scheduled Successfully!</p>");
            } catch (Exception e) {
                e.printStackTrace();
                response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "Error scheduling SFTP upload.");
            }
        } else {
            // Handle the situation where the bean is not in the session
            // You might want to create a new instance or redirect the user to an error page
            response.sendRedirect("error.jsp");
        }
    %>
</body>
</html>
