package ibase.webitm.ejb.wsfa.transactions;

import java.lang.String;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.util.*;
import java.util.Date;
import java.sql.*;
import java.text.*;
import java.io.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*; 
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;

@Stateless
public class StrgSerRefreshPrc extends ProcessEJB //implements StrgSerRefreshPrcLocal,StrgSerRefreshPrcRemote
{
	File filePtr ;
	File logDir ;
	String logDirName = "";			
	static String logOnOffFlag = "Y";//For On-Off Log file.
	String err = "";
	E12GenericUtility genericUtility = new E12GenericUtility();

	static void writeLog(File f,String Msg,boolean flag)
	{
		try
		{  
			PrintWriter pw = new PrintWriter((new FileOutputStream(f,flag)),flag);				
			if(logOnOffFlag.trim().equals("Y"))
			{
				pw.println( Msg);		
			}
			pw.close();
		}
		catch(Exception exWm){exWm.printStackTrace();}		
	}
	static void writeLog(File f,Exception Msg,boolean flag)
	{
		try{
			PrintWriter pw = new PrintWriter((new FileOutputStream(f,flag)),flag);				
			pw.println(" "+Msg);		
			pw.close();		
		}
		catch(Exception exWm){exWm.printStackTrace();}
	}
	
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		
		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";
		
		try
		{	
			if(CommonConstants.J2EE_VERSION.equals("1"))
			{
				logDirName =  CommonConstants.JBOSSHOME  + File.separator + "log" ;
			}
			else if(CommonConstants.J2EE_VERSION.equals("2"))
			{
				logDirName =  CommonConstants.JBOSSHOME   + File.separator + "server"+ File.separator +"default"+ File.separator +"log" ;
			}
			logDir = new File(logDirName);
			filePtr = new File(logDirName+ File.separator + "StrgSerRefresh.log");
		/*	writeLog(filePtr,"*****************************************************",true);
			writeLog(filePtr,"xmlString-->"+xmlString,true);
			writeLog(filePtr,"xmlString2-->"+xmlString2,true);
			writeLog(filePtr,"windowName-->"+windowName,true);	*/		
			System.out.println("*****************************************************");
			System.out.println("xmlString-->"+xmlString);
			System.out.println("xmlString2-->"+xmlString2);
			System.out.println("xmlString-->"+xmlString);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("headerDom" + headerDom);
				writeLog(filePtr,"headerDom-->"+headerDom,true);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("detailDom" + detailDom);
				writeLog(filePtr,"detailDom-->"+detailDom,true);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{			
			System.out.println("Exception :StrgSerRefresh :process:" + e.getMessage() + ":");
			e.printStackTrace();
			writeLog(filePtr,"Exception in process-->"+e.getMessage(),true);
			retStr = e.getMessage();
		}
		writeLog(filePtr,"Return from process-->"+retStr,true);
		return retStr;
	}
	// END OF PROCESS ONE

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		Statement stmtTemp = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		String custCode = "";
		String salesPers = "";
		String routeIdExisting = "";
		String routeIdNew = "";
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
		String retString = "";
		String resLocalityCode = "";
		String sqlStr = "";
		String errCode = "";
		String errString = "";
		String itemSeries = "";
		String scCode = "";
		int updCnt = 0;

		System.out.println("Process screen");
		StringBuffer warningMsgBuf = new StringBuffer();
		java.sql.Date chgDate = new java.sql.Date(System.currentTimeMillis());
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]

		//ITMDBAccessLocal itmDBAccessLocal = null;

		try
		{
			System.out.println("Process screen try");
			InitialContext ctx = getInitialContext();
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();

			
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			stmt = conn.createStatement();
			stmtTemp = conn.createStatement();
			String spCode = genericUtility.getColumnValue("sp_code",headerDom);
			System.out.println("spCode ["+spCode+"]");
			int refOpt = Integer.parseInt(genericUtility.getColumnValue("ref_option",headerDom));
			System.out.println("refOpt ["+refOpt+"]");
			
			writeLog(filePtr,"Sales Person Code From Filter -->" + spCode,true);
			
			if((spCode != null || spCode.trim().length() > 0) && (refOpt > 0))
			{
				sqlStr = "SELECT STRG_CUSTOMER.SC_CODE, " +
						 "RTRIM(STRG_CUSTOMER.FIRST_NAME)||' '||RTRIM(STRG_CUSTOMER.MIDDLE_NAME)||' '||RTRIM(STRG_CUSTOMER.LAST_NAME) AS NAME, " +
						 "STRG_CUSTOMER.CITY,STRG_CUSTOMER.DISTRICT_OFF, " +
						 "STRG_CUSTOMER.QUALIFICATION,STRG_CUSTOMER.SEX,STRG_CUSTOMER.ADDED_DATE, " +
						 "STRG_CUSTOMER.RES_CITY,STRG_CUSTOMER.EMAIL_ADDR,STRG_SERIES.ITEM_SER, " +
						 "STRG_SERIES.CLASS_CODE,STRG_SERIES.NO_VISIT,STRG_SERIES.SHORT_ID, " +
						 "STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3,STRG_CUSTOMER.STAN_CODE, " +
						 "STRG_CUSTOMER.STATE_CODE,C.DESCR,STRG_CUSTOMER.PIN,STRG_CUSTOMER.COUNT_CODE, " +
						 "STRG_CUSTOMER.TELE1,STRG_CUSTOMER.TELE2,STRG_CUSTOMER.TELE3,STRG_CUSTOMER.FAX, " +
						 "STRG_CUSTOMER.MOBILE_NO,STRG_CUSTOMER.RES_ADDR1,STRG_CUSTOMER.RES_ADDR2, " +
						 "STRG_CUSTOMER.RES_ADDR3,STRG_CUSTOMER.RES_STAN_CODE,STRG_CUSTOMER.RES_STATE_CODE, " +
						 "STATE_A.DESCR,STRG_CUSTOMER.RES_PIN,STRG_CUSTOMER.RES_COUNT_CODE,STRG_CUSTOMER.DISTRICT_RES, " +
						 "STRG_CUSTOMER.RES_TELE1,STRG_CUSTOMER.RES_TELE2,STRG_SERIES.NO_PATIENT_DAY, " +
						 "STRG_CUSTOMER.BIRTH_DATE,STRG_CUSTOMER.WEDD_ANIV,ITEMSER.DESCR, " +
						 "SALES_PERS.SP_NAME,STRG_SERIES.SALES_PERS__OLD,STRG_SERIES.REASON, " +
						 "STRG_SERIES.EFF_DATE,STRG_SERIES.SALES_PERS,STRG_SERIES.SPL_CODE, " +
						 "STRG_SERIES.TOTAL_BUSINESS,STRG_SERIES.BUSINESS_TO_US,SPECIALITY.DESCR, " +
						 "STRG_CUSTOMER.LOCALITY_CODE,LOCALITY_A.DESCR,STRG_SERIES.STATUS, " +
						 "STRG_SERIES.REPLY_STATUS,STRG_SERIES.ROUTE_ID,STRG_CUSTOMER.RES_LOCALITY_CODE, " +
						 "B.DESCR,STRG_CUSTOMER.REG_NO,STRG_CUSTOMER.REG_DATE " +
						 "FROM STRG_CUSTOMER,STRG_SERIES,ITEMSER,SALES_PERS,SPECIALITY,LOCALITY LOCALITY_A, " +
						 "LOCALITY B,STATE STATE_A,STATE C " +
						 "WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND " +
						 "( STRG_CUSTOMER.RES_LOCALITY_CODE = B.LOCALITY_CODE (+)) AND " +
						 "( STRG_CUSTOMER.STATE_CODE = C.STATE_CODE (+)) AND " +
						 "( STRG_CUSTOMER.RES_STATE_CODE = STATE_A.STATE_CODE (+)) AND " +
						 "( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND " +
						 "( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND " +
						 "( STRG_CUSTOMER.LOCALITY_CODE = LOCALITY_A.LOCALITY_CODE ) AND " +
						 "( STRG_SERIES.SALES_PERS = '" + spCode + "') AND " +
						 "( STRG_SERIES.SPL_CODE = SPECIALITY.SPL_CODE(+) ) " ;
				System.out.println("sqlStr : " + sqlStr);
				//rs = stmt.executeQuery(sqlStr);
				pstmt = conn.prepareStatement(sqlStr);
				rs = pstmt.executeQuery();
				//- Same sqls are getting executed repetedly so putting if insted of while . it will be workfull for multiple sales person
				//while (rs.next())//Gulzar - 17/05/10
				if (rs.next())//Gulzar - 17/05/10 
				{
					if (refOpt == 1)
					{
						sqlStr = "UPDATE SPRS_ROUTE " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update STRG_SERIES : Update Count -->" + updCnt,true);
							retString = "Failed to update strg series for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ROUTE : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_ROUTE " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ROUTE : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ROUTE for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ROUTE : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001
					}
					else if (refOpt == 2)
					{
						sqlStr = "UPDATE SPRS_ITEM " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ITEM : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ITEM for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ITEM : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_ITEM " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ITEM : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ITEM for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ITEM : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001
					}
					else if (refOpt == 3)
					{
						sqlStr = "UPDATE STRG_SERIES " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update STRG_SERIES : Update Count -->" + updCnt,true);
							retString = "Failed to update strg series for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into STRG_SERIES : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE STRG_SERIES " +
								 "SET REPLY_STATUS = '2' " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update STRG_SERIES : Update Count -->" + updCnt,true);
							retString = "Failed to update strg series for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into STRG_SERIES : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001
					}
					else if (refOpt == 4)
					{
						sqlStr = "UPDATE SPRS_STOCKIST " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_STOCKIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS STOCKIST for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_STOCKIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_STOCKIST " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_STOCKIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS STOCKIST for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_STOCKIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001
					}
					else if (refOpt == 5)
					{
						sqlStr = "UPDATE SPRS_CHEMIST " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_CHEMIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS CHEMIST for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_CHEMIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_CHEMIST " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_CHEMIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS CHEMIST for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_CHEMIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001
					}
					else if (refOpt == 6)
					{
						sqlStr = "UPDATE SPRS_ACTIVITY " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ACTIVITY : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ACTIVITY for Sales Person [" + spCode + "] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ACTIVITY : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001
					}
					else if(refOpt == 7)
					{
						sqlStr = "UPDATE SPRS_ROUTE " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ROUTE : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ROUTE for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ROUTE : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_ROUTE " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ROUTE : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ROUTE for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ROUTE : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_ITEM " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ITEM : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ITEM for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ITEM : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_ITEM " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ITEM : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ITEM for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ITEM : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE STRG_SERIES " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update STRG_SERIES : Update Count -->" + updCnt,true);
							retString = "Failed to update strg series for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into STRG_SERIES : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE STRG_SERIES " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update STRG_SERIES : Update Count -->" + updCnt,true);
							retString = "Failed to update strg series for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into STRG_SERIES : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_STOCKIST " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_STOCKIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS STOCKIST for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_STOCKIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_STOCKIST " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_STOCKIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS STOCKIST for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_STOCKIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_CHEMIST " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='Y' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_CHEMIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS CHEMIST for Sales Person [" + spCode + "] AND Status [ 'Y' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_CHEMIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_CHEMIST " +
								 "SET REPLY_STATUS = '2'  " +
								 "WHERE SPRS_CODE = '" + spCode + "' " +
								 "AND STATUS ='N' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_CHEMIST : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS CHEMIST for Sales Person [" + spCode + "] AND Status [ 'N' ] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_CHEMIST : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001

						sqlStr = "UPDATE SPRS_ACTIVITY " +
								 "SET REPLY_STATUS = '0'  " +
								 "WHERE SALES_PERS = '" + spCode + "' " ;
						pstmt = conn.prepareStatement(sqlStr);
						updCnt = 0;
						updCnt = pstmt.executeUpdate();
						/*---Commented and Changes below By Gulzar - 21/08/08 Req ID :SY89SUN001
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update SPRS_ACTIVITY : Update Count -->" + updCnt,true);
							retString = "Failed to update SPRS ACTIVITY for Sales Person [" + spCode + "] ";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						if(pstmt != null)
						{
							pstmt.close();
							pstmt= null;
						}
						if ( updCnt > 0 ) 
						{
							writeLog(filePtr,"Update Successfully into SPRS_ACTIVITY : Update Count -->" + updCnt,true);
						}
						//End Changes - Gulzar 21/08/08 Req ID :SY89SUN001
					}
				}
				if(rs != null)
				{
					rs.close();
					rs= null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt= null;
				}
				if (retString == null || retString.trim().length() == 0)
				{
					conn.commit();
				}
				else
				{
					conn.rollback();
				}
			}
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (SQLException SQLE)
			{
				writeLog(filePtr,"Exception in process-->"+SQLE,true);
				throw new ITMException(SQLE);
			}
			writeLog(filePtr,"Exception in process-->"+e,true);
			System.out.println( e.getMessage());
			throw new ITMException(e);
		}  
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				writeLog(filePtr,"Exception in process-->"+e,true);
				System.out.println(e.getMessage());
			}
		}		
		if (retString == null || retString.trim().length() == 0)
		{
			retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS1\" type=\"P\" column_name=\"\"><message>Process Done Successfully</message><description>Process Done Successfully </description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
		}
		return retString;
	}	


	private String errMsg(String columnName,String msgNo,String userId,String errTrace)throws RemoteException,ITMException
	{
        Connection conn = null;
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
		StringBuffer errStringXml;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		String sqlQuery,sqlQuery1;
		String msgType = "";
		String msgString = "";
		String msgDescription = "";
		String lmsgString = "";
		String profileId = "";
		String errSource = "";
		String tempMsgType = "";
		String msgOption = "";		
		String msgTime = "";

		String redirerr = "" ;
		String soundPlay = "";
		FileOutputStream fos;
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
			/*stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlQuery);*/
			pstmt = conn.prepareStatement(sqlQuery);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
				msgString = rs.getString("MSG_STR");
				msgDescription = rs.getString("MSG_DESCR");
				errSource = rs.getString("ERR_SOURCE");
				msgOption = rs.getString("MSG_OPT");				
				msgTime = rs.getString("MSG_TIME");
				soundPlay = rs.getString("ALARM");
			}
			else
			{
				lmsgString = "Message Not Defined >>" + msgNo;
				msgDescription = "Message Id not found.";
				msgType = "";
				msgString = "";
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (msgType.equals("E") || msgType.trim().length() == 0) 
			{
				sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
				//rs1 = conn.createStatement().executeQuery(sqlQuery1);
				pstmt=conn.prepareStatement(sqlQuery1);
				rs1=pstmt.executeQuery();
				if (rs1.next())
				{
					profileId=rs1.getString("profile_id");
					if (profileId == null)
					{
						profileId= "";
					}
					sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND PROFILE_ID='" + profileId.trim() + "'";
					//rs2 = conn.createStatement().executeQuery(sqlQuery1);
					pstmt=conn.prepareStatement(sqlQuery1);
					rs2=pstmt.executeQuery();
					if (rs2.next())
					{
						tempMsgType = rs2.getString("msg_type");
					}
					if ( rs2 != null )
					{
						rs2.close();
						rs2 = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (tempMsgType!=null && tempMsgType.trim().length()>0)
				{
					msgType = tempMsgType;
				}
			}
			if (msgType.equals("W"))
			{
				msgString = "Warning : " + msgString;
			}
			else if (msgType.equals("P"))
			{
				msgString = "Prompt : " + msgString;
			}
			else
			{
				msgType = "E";
				msgString = "Error : " + msgString;
			}
			if (errSource!=null && errSource.trim().equals("D"))
			{
				msgDescription = msgDescription +  " * From Database ";
			}
			if (redirerr==null || redirerr.trim().length()==0)
			{
				redirerr = "1";
			}
			if (msgOption!=null && msgOption.trim().equals("M"))
			{
				if (redirerr.trim().equals("1"))
				{
					redirerr = "2";
				}
				else
				{
					redirerr = "1";
				}
			}
			/*if (rs != null)
			{
				rs.close();
			}
			if (rs1 != null)
			{
				rs1.close();			
			}*/
			if(conn != null)
			{
				conn.close();
				conn = null;
			}
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException : [ValidatorEJB][getErrorString] :==>\n"+itme.getMessage());
			throw itme;
		}
		catch(SQLException se)
		{
			lmsgString = "Database Error >>" + se.getErrorCode(); //msgNo;
			msgDescription = se.getMessage();
			msgType = "";
			msgString = "";
			System.out.println("Exception : [ValidatorEJB][getErrorString] :==>\n"+se.getMessage());
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ValidatorEJB][getErrorString] :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		errStringXml = new StringBuffer();
		errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		errStringXml.append("<error id=\"");
		errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
		errStringXml.append(columnName).append("\">\r\n").append("<message>").append(msgString);
		errStringXml.append("</message>\r\n<description>").append(msgDescription).append("</description>\r\n");
		errStringXml.append("<type>").append(msgType).append("</type>\r\n<option>").append(msgOption).append("</option>\r\n");		
		errStringXml.append("<time>").append(msgTime).append("</time>\r\n");

		errStringXml.append("<alarm>").append(soundPlay).append("</alarm>\r\n<source>");
		errStringXml.append(errSource).append("</source>\r\n<trace>").append(errTrace);
		errStringXml.append("</trace>\r\n<redirect>").append(redirerr).append("</redirect>\r\n</error>\r\n");
		errStringXml.append("</Errors></Root>\r\n");
/*		if (msgType.trim().equals("E"))
		{
			errStringXml = buildErrorString();
		}*/
		try 
		{
			fos = new FileOutputStream("C:" + File.separator + "ErrorXml.xml");
			byte convertStringToByte[] = errStringXml.toString().getBytes();
			fos.write(convertStringToByte);
			fos.close();
		}
		catch(Exception e)
		{ 
			System.out.println("Exception : [ValidatorEJB][getErrorString] \n:==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errStringXml.toString();

	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[ChgResLocalityPrc] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[ChgResLocalityPrc] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
}