package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.ejb.*;
import java.rmi.RemoteException;
import java.text.*;
import java.util.*;
import java.sql.*;
import java.io.File;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.ejb.*;
import javax.naming.InitialContext;

import ibase.system.config.*;
import ibase.webitm.utility.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].


public class DepthAndDisplayProcessItem extends ValidatorEJB implements DepthAndDisplayProcessItemRemote,DepthAndDisplayProcessItemLocal//implements SessionBean
{
   protected static String database = CommonConstants.DB_NAME;
   /*
   public void ejbCreate() throws RemoteException, CreateException
	{
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate()
	{
	}
	public void ejbPassivate()
	{
	}*/
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("[wfValData]xmlString ["+xmlString+"]");
		System.out.println("[wfValData]xmlString1["+xmlString1+"]");
		System.out.println("[wfValData]xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [DepthAndDisplayProcessItemEJB][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);

	}


	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentList = null;
		NodeList elementList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element arr = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String errString = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

	//	ITMDBAccessHome itmDBAccessHome = null;
	//	ITMDBAccess itmDBAccess = null;

		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;

		try
		{
			ConnDriver connDriver = null;
			String childNodeName=null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//itmDBAccessHome = (ITMDBAccessHome)ctx.lookup("ITMDBAccess");
			//itmDBAccess = itmDBAccessHome.create();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessRemote itmDBAccess = (ITMDBAccessRemote)ctx.lookup("ibase/ITMDBAccessEJB/remote");
			ITMDBAccessEJB  itmDBAccess = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			parentList = dom2.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				System.out.println("Parent is >> "+parentNode.getNodeName());
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();

					switch ( currentFormNo )
					{
						case 1:
						{
							if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if(childNode.getFirstChild() == null)
								{
									errString = itmDBAccess.getErrorString("sales_pers","NULLSPRSCD",userId);
									break;
								}
								else
								{
									String sprs = genericUtility.getColumnValue("sales_pers",dom1);
									String locality = genericUtility.getColumnValue("locality_code",dom1);
									String checkSQL = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ?";
									pstmt = connectionObject.prepareStatement(checkSQL);
									pstmt.setString(1,checkNull(sprs));
									rSet = pstmt.executeQuery();
									if(!rSet.next())
									{
										errString = itmDBAccess.getErrorString("sales_pers","WRGSPRSCD",userId);
										break;
									}

									checkSQL = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
									pstmt = connectionObject.prepareStatement(checkSQL);
									pstmt.setString(1,checkNull(sprs));
									pstmt.setString(2,checkNull(locality));
									rSet = pstmt.executeQuery();
									if(!rSet.next())
									{
										errString = itmDBAccess.getErrorString("sales_pers","WRGLOCCODE",userId);
										break;
									}

								}
							}
							if(childNodeName.equalsIgnoreCase("work_date"))
							{
								String workDate = checkNull(genericUtility.getColumnValue("work_date",dom1));
								//Changed By Pragyan 13/11/2009 To get the Date object as application format[WS89NOV585].start
								String sprs = genericUtility.getColumnValue("sales_pers",dom1);
								String locality = genericUtility.getColumnValue("locality_code",dom1);
								String custCode = genericUtility.getColumnValue("cust_code",dom1);
								//Changed By Pragyan 13/11/2009 To get the Date object as application format[WS89NOV585].END
								if( workDate.trim().length() > 0 )
								{
									try
									{
										String allowDays = getPropValue("MAX_ALLOW_DAYS_FOR_DND", connectionObject);
										allowDays = ( allowDays.trim().length() > 0 )? allowDays : "0";
										System.out.println("allowDays >> "+allowDays);

										//Changed By Pragyan 13/11/2009 To get the Date object as application format[WS89NOV585]
										/*Calendar domCalDate = Calendar.getInstance();
										domCalDate.setTime(new java.util.Date(workDate));*/
										java.util.Date eventDate= getDateObject(workDate);

										Calendar allowCalDate = Calendar.getInstance();
										allowCalDate.setTime(new java.util.Date());
										System.out.println("workDate >> "+eventDate.getDate()+"  allowCalDate >> "+allowCalDate.getTime());

										allowCalDate.add(allowCalDate.DATE, - Integer.parseInt(allowDays));

										//Changed By Pragyan 13/11/2009 To get the Date object as application format bug fixing[WS89NOV585]
										//if( domCalDate.before( allowCalDate ) )
										if( eventDate.before( allowCalDate.getTime() ) )
										{
											System.out.println("in date::::");
											errString = itmDBAccess.getErrorString("work_date","INVWRKDATE",userId);
											break;
										}
										//Changed By Pragyan 13/11/2009 To check  RCPA not done for that particular customer,workdate and locality[WS89NOV585].start
										else if(!getRCPAStatus(sprs,workDate,custCode,locality,connectionObject))
										{
											System.out.println("RCPA not done for that particular customer,workdate and locality");
											errString = itmDBAccess.getErrorString("work_date","NULLRCPAD",userId);
											break;
										}
										////Changed By Pragyan 13/11/2009 To check  RCPA not done for that particular customer,workdate and locality[WS89NOV585].end
									}
									catch( Exception exp )
									{
										System.out.println("Exception in calculating allow date");
										exp.printStackTrace();
									}

								}
							}
							//Changed By Pragyan 13/11/2009 To check  RCPA not done for that particular customer,workdate and locality[WS89NOV585].Start
							if(childNodeName.equalsIgnoreCase("cust_code"))
							{
								if(childNode.getFirstChild() == null)
								{
									errString = itmDBAccess.getErrorString("cust_code","NULLSTGCD",userId);
									break;
								}

							}
							//Changed By Pragyan 13/11/2009 To check  RCPA not done for that particular customer,workdate and locality[WS89NOV585].end
						}

						break;
						case 2 :
						{
							//Changed By Pragyan 13/11/09 as  item_units column change to a check box and char type [WS89NOV588].start
							/*if(childNodeName.equalsIgnoreCase("item_units"))
							{
								if(childNode.getFirstChild() != null)
								{

									int units = Integer.parseInt(getSelectedColValue(dom2, "2","item_units",prntCtr));
									System.out.println("units>>"+units+"<<");
									int stock = Integer.parseInt(getSelectedColValue(dom2, "2","stock_expc",prntCtr));
									System.out.println("stock>>"+stock+"<<");
									if(units > stock)
									{
										errString = itmDBAccess.getErrorString("item_units","INVALUNITS",userId);
										break;
									}

								}
							}*/
							//Changed By Pragyan 13/11/09 as  item_units column change to a check box and char type [WS89NOV588].end
						}
						break;
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
				}
				if (rSet !=null )
				{
					rSet.close();
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}

			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);//Ratikant 23/Mar/2005
		}
		catch(Exception e)
		{
			System.out.println("Exception :DepthAndDisplayProcessItemEJB :itemChanged(String,String) :==>\n"+e.getMessage());
		}
		return (valueXmlString);

	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		String columnName = "";
		String columnValue = "";
		String domId = "";
		String errCode = "";
		String resultString = "";
		String custCode = "";
		StringBuffer valueXmlString = null;

		Connection  conn = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;
		Statement stmt = null;

		String sql = "";

		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;

	    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	    //changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


		int currentFormNo = 0;
		try
		{
			System.out.println("\nDepthAndDisplayProcessItemEJB : itemChanged["+currentColumn+"] : xtraParams :"+xtraParams);
			conn = getConnection();

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			domId = getDomId(dom,objContext);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append("A").append("</editFlag>\r\n</Header>\r\n");

			switch(currentFormNo)
			{

				case 1:
					valueXmlString.append("<Detail1 domID='1'>\r\n");
					if (currentColumn.trim().equalsIgnoreCase("cust_code"))
					{
						sql = "SELECT CLASS_CODE, CLASS_CODE_DESCR FROM STRG_SERIES WHERE SC_CODE = ? AND SALES_PERS =? ";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,genericUtility.getColumnValue("cust_code",dom1));
						pstmt.setString(2,genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
						rSet = pstmt.executeQuery();
						if(rSet.next())
						{
							valueXmlString.append("<class_code><![CDATA[").append(checkNull(rSet.getString("CLASS_CODE"))).append("]]></class_code>\r\n");
							valueXmlString.append("<class_code_desc><![CDATA[").append(checkNull(rSet.getString("CLASS_CODE_DESCR"))).append("]]></class_code_desc>\r\n");

						}
						else
						{
							valueXmlString.append("<class_code><![CDATA[").append("").append("]]></class_code>\r\n");
							valueXmlString.append("<class_code_desc><![CDATA[").append("").append("]]></class_code_desc>\r\n");
						}

					}
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						valueXmlString.append("<sales_pers><![CDATA[").append( genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode")).append("]]></sales_pers>\r\n");
					}
					else if (currentColumn.trim().equalsIgnoreCase("sales_pers"))
					{
						valueXmlString.append("<locality_code><![CDATA[").append("").append("]]></locality_code>\r\n");
						valueXmlString.append("<cust_code><![CDATA[").append("").append("]]></cust_code>\r\n");

					}
					valueXmlString.append("</Detail1>\r\n");
					break;
			}

			valueXmlString.append("</Root>\r\n");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
				}
				if( rSet != null )
				{
					rSet.close();
				}
				if( conn != null )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		if (!errCode.equals(""))
		{
			resultString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
		}
		else
		{
			resultString = valueXmlString.toString();
		}

		return resultString;
	}


	private String getDomId(Document dom2,String objContext)
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String domId = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null)
				{
					domId = etlAttributes.getNamedItem("domID").getNodeValue();
				}
			}
		}
		return domId;
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	private String getPropValue( String propName, Connection conn )
	{
		PreparedStatement pstmt = null ;
		ResultSet rset = null;
		//Connection conn = null;
		System.out.println("propName : > "+propName);

		String propVal = "";
		try
		{
			String sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME=? ";

			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, propName );
			rset = pstmt.executeQuery();

			if ( rset.next() )
			{
				propVal = checkNull( rset.getString("PROP_VALUE") );
			}
		}
		catch ( Exception expPropVal )
		{
			System.out.println("Exception : DepthAndDisplayProcessEJB : getPropValue ==>");
			expPropVal.printStackTrace();
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					rset.close();
				}
			}
			catch ( Exception eRsc )
			{
				eRsc.printStackTrace();
			}
		}
		System.out.println("DepthAndDisplayProcessItemEJB:getPropValue:propVal ["+propVal+"]");
		return propVal;
	}

	private String getSelectedColValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{	NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			detailListLength = detailList.getLength();
			//System.out.println("PARENT>>"+rowNo+"<<");
			parentNode = detailList.item(rowNo);
			elementAttr = (Element)parentNode;
			System.out.println("DOMID >>"+elementAttr.getAttribute("domID"));
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();

			for (int ctr = 0; ctr < noOfChilds; ctr++)//for loop for row no in detail
			{
				//System.out.println("CHILDNODE >"+ctr+"<");
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				if(childNodeName.equals(colName) )//&& elementAttr.getAttribute("domID").equals(rowNo)
				{
					if(childNode.getFirstChild()!=null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
						break;
					}
				}
			}

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}
	return columnValue;
	}
	//Changed By Pragyan 13/11/2009 To check  RCPA not done for that particular customer,workdate and locality[WS89NOV585].start
	private boolean getRCPAStatus( String salesPerson,String workDate,String custCode,String localityCode, Connection conn )
	{
		PreparedStatement pstmt = null ;
		ResultSet rset = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		boolean isRCPAdone = false;
		int cnt = 0;

		try
		{
			String sql = "SELECT COUNT(*)  FROM STRG_MEET WHERE SALES_PERS =? AND EVENT_DATE =? AND  SC_CODE__REF= ? AND LOCALITY_CODE = ? ";

			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, salesPerson );
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(workDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pstmt.setString( 3, custCode );
			pstmt.setString( 4, localityCode );

			rset = pstmt.executeQuery();

			if ( rset.next() )
			{
				cnt = rset.getInt(1);
			}

			if(cnt > 0)
			{
				isRCPAdone = true;
			}
		}
		catch ( Exception e )
		{
			System.out.println("Exception : DepthAndDisplayProcessEJB : getRCPAStatus ==>");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					rset.close();
				}
			}
			catch ( Exception eRsc )
			{
				eRsc.printStackTrace();
			}
		}
		System.out.println("DepthAndDisplayProcessItemEJB:getRCPAStatus:isRCPAdone ["+isRCPAdone+"]");
		return isRCPAdone;
	}
	//Changed By Pragyan 13/11/2009 To check  RCPA not done for that particular customer,workdate and locality[WS89NOV585].end

}