/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility.training;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;

public class FollowUpActionGenerateTask
extends ValidatorEJB {
    public String generateTask(String tranID, String xtraParam, Connection conn) {
        String result;
        block5: {
            result = "";
            CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
            BaseLogger.log((String)"3", null, null, (Object)("Inside generateTask tranID [" + tranID + "]"));
            BaseLogger.log((String)"3", null, null, (Object)("Inside generateTask xtraParam [" + xtraParam + "]"));
            E12GenericUtility genericUtility = new E12GenericUtility();
            try {
                String userCode = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
                BaseLogger.log((String)"3", null, null, (Object)("Inside generateTask userCode [" + userCode + "]"));
                UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
                String objName = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "objName");
                BaseLogger.log((String)"3", null, null, (Object)("Inside generateTask objName [" + objName + "]"));
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                String refSer = "";
                String tranWindow = "w_" + objName;
                try {
                    refSer = E12GenericUtility.checkNull((String)dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", "TRAN_WINDOW  = '" + tranWindow + "'", userInfo.getTransDB()));
                    BaseLogger.log((String)"3", null, null, (Object)("Inside generateTask refSer [" + refSer + "]"));
                    if (E12GenericUtility.checkNull((String)refSer) == "") {
                        result = "REF-SER blank or null.";
                        break block5;
                    }
                    String getTaskDetailsFromTaskMstResult = this.getTaskDetailsFromTaskMst(refSer, userInfo);
                    BaseLogger.log((String)"3", null, null, (Object)("Inside generateTask getTaskDetailsFromTaskMstResult [" + getTaskDetailsFromTaskMstResult + "]"));
                    result = getTaskDetailsFromTaskMstResult;
                }
                catch (ITMException | RemoteException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        result = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + result + "]]></RESULT></ROOT>";
        return result;
    }

    public String getTaskDetailsFromTaskMst(String refSer, UserInfoBean userInfo) throws ITMException, SQLException {
        String result = "";
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getTaskDetailsFromTaskMstSQL = "SELECT * FROM TASK_MST WHERE REF_SER = ?";
                pstmt = connection.prepareStatement(getTaskDetailsFromTaskMstSQL);
                pstmt.setString(1, refSer);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String taskCode = rs.getString("TASK_CODE");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside createUserTask taskCode [" + taskCode + "]"));
                    String descr = rs.getString("DESCR");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside createUserTask descr [" + descr + "]"));
                    String refID = rs.getString("REF_ID");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside createUserTask refID [" + refID + "]"));
                    String expTat = rs.getString("EXP_TAT");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside createUserTask expTat [" + expTat + "]"));
                    String taskDet = rs.getString("TASK_DET");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside createUserTask taskDet [" + taskDet + "]"));
                    result = this.createUserTask(taskDet, taskCode, expTat, refSer, refID, "", userInfo);
                    BaseLogger.log((String)"3", null, null, (Object)("Inside getTaskDetailsFromTaskMst createUserTaskResult [" + result + "]"));
                } else {
                    result = "REF-SER not found in Task Master";
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                connection.close();
                connection = null;
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("FollowUpActionGenerateTask.getTaskDetailsFromTaskMst() Exception = [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return result;
    }

    public String createUserTask(String taskDescr, String taskCode, String expTat, String refSer, String refID, String ipAddress, UserInfoBean userInfo) throws ITMException, SQLException {
        String chgTerm;
        BaseLogger.log((String)"3", null, null, (Object)("Inside createUserTask loginCode [" + userInfo.getLoginCode() + "]"));
        String result = "";
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String tranID = "";
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        String addTerm = chgTerm = ipAddress;
        String chgUser = userInfo.getLoginCode();
        int expTatInt = Integer.parseInt(expTat);
        LocalDate todaysDate = LocalDate.now();
        LocalDate expCompDate = todaysDate.plusDays(expTatInt);
        if (userInfo != null) {
            tranID = commonDBAccessEJB.generateSeq("comm_log_seq", 10, userInfo.getTransDB());
        }
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String userTaskInsertSQL = "Insert into USER_TASKS (TRAN_ID,TRAN_DATE,USER_ID,TASK_DESCR,TASK_TYPE,TASK_DOMAIN,TASK_CODE,USER_ID__ASSIGNED,EXP_COMPL_DATE,CURR_STATUS,STATUS_DATE,COMPL_REMARKS,ADD_DATE,ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM,REF_SER,REF_ID) values \n(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                pstmt = connection.prepareStatement(userTaskInsertSQL);
                pstmt.setString(1, tranID);
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, userInfo.getLoginCode());
                pstmt.setString(4, taskDescr);
                pstmt.setString(5, "");
                pstmt.setString(6, "");
                pstmt.setString(7, taskCode);
                pstmt.setString(8, chgUser);
                pstmt.setDate(9, Date.valueOf(expCompDate));
                pstmt.setString(10, "");
                pstmt.setString(11, "");
                pstmt.setString(12, "");
                pstmt.setTimestamp(13, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(14, userInfo.getLoginCode());
                pstmt.setString(15, addTerm);
                pstmt.setTimestamp(16, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(17, userInfo.getLoginCode());
                pstmt.setString(18, chgTerm);
                pstmt.setString(19, refSer);
                pstmt.setString(20, refID);
                int insCnt = pstmt.executeUpdate();
                if (insCnt > 0) {
                    connection.commit();
                    result = "Task created";
                } else {
                    result = "Task not created";
                }
                rs = null;
                pstmt.close();
                pstmt = null;
                connection.close();
                connection = null;
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("FollowUpActionGenerateTask.createUserTask() Exception = [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return result;
    }
}

