/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.utility.EmpDeligationCommonLocal;
import ibase.wrkflw.utility.EmpDeligationCommonRemote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpDeligationCommon
extends ProcessEJB
implements EmpDeligationCommonLocal,
EmpDeligationCommonRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    String loginCode = "SYSTEM";
    String chgTerm = "SYSTEM";

    @Override
    public String process() throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException, ITMException {
        String rtrStr = "";
        Document headerDom = null;
        Document detailDom = null;
        try {
            if (xmlString != null && xmlString.trim().length() != 0) {
                headerDom = this.genericUtility.parseString(xmlString);
            }
            if (xmlString2 != null && xmlString2.trim().length() != 0) {
                detailDom = this.genericUtility.parseString(xmlString2);
            }
            rtrStr = this.getData(headerDom, detailDom, windowName, xtraParams);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :WFDeligationEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
            rtrStr = e.getMessage();
        }
        return rtrStr;
    }

    public String blanknull(String s) {
        if (s == null) {
            return " ";
        }
        return s;
    }

    @Override
    public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException, ITMException {
        String errString = "";
        String getDataSql = "";
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        StringBuffer retTabSepStrBuff = new StringBuffer();
        String empCode = null;
        String sql = "";
        int cnt = 0;
        int count = 0;
        ConnDriver connDriver = new ConnDriver();
        Connection conn = null;
        try {
            if (conn == null) {
                conn = connDriver.getConnectDB("Driver");
                conn.setAutoCommit(false);
            }
            DatabaseMetaData dbmd = conn.getMetaData();
            BaseLogger.log("3", null, null, "DriverName[" + dbmd.getDriverName() + "]");
            BaseLogger.log("3", null, null, "DriverURI[" + dbmd.getURL() + "]");
            BaseLogger.log("3", null, null, "DriverUSER[" + dbmd.getUserName() + "]");
            BaseLogger.log("3", null, null, "EmpDeligation : getData() Method Called");
            empCode = this.genericUtility.getColumnValue("emp_code", headerDom);
            empCode = this.blanknull(empCode).trim();
            BaseLogger.log("3", null, null, "emp_code =:[" + empCode + "]");
            if (empCode == null || empCode.trim().length() == 0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "EMPCODNULL", "", "", conn);
                return string;
            }
            sql = "select count(1) from employee where emp_code ='" + empCode + "'";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                cnt = rs.getInt(1);
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
            if (cnt == 0) {
                String string = errString = this.itmDBAccessEJB.getErrorString("", "EMPCODINV", "", "", conn);
                return string;
            }
            try {
                BaseLogger.log("3", null, null, "emp_code:::[" + empCode + "]");
                getDataSql = "SELECT  REF_SER,REF_ID,LINE_NO,SIGN_FOR,ROLE_CODE__SIGN,SIGN_STATUS,EMP_CODE,ENTITY_CODE FROM  OBJ_SIGN_TRANS where ENTITY_CODE= ?  and SIGN_STATUS ='U' order by REF_SER";
                if (getDataSql.trim().length() > 0) {
                    BaseLogger.log("3", null, null, "Sql Fired :::::" + getDataSql);
                    pstmt = conn.prepareStatement(getDataSql);
                    pstmt.setString(1, empCode);
                    BaseLogger.log("3", null, null, "QUERY IS IN PROCESS..........");
                    rs = pstmt.executeQuery();
                    BaseLogger.log("3", null, null, "QUERY  PROCESS FINISED.......");
                    while (rs.next()) {
                        retTabSepStrBuff.append(rs.getString(1) == null ? " " : rs.getString(1)).append("\t");
                        retTabSepStrBuff.append(rs.getString(2) == null ? " " : rs.getString(2)).append("\t");
                        retTabSepStrBuff.append(rs.getString(3) == null ? " " : rs.getString(3)).append("\t");
                        retTabSepStrBuff.append(rs.getString(4) == null ? " " : rs.getString(4)).append("\t");
                        retTabSepStrBuff.append(rs.getString(5) == null ? " " : rs.getString(5)).append("\t");
                        retTabSepStrBuff.append(rs.getString(6) == null ? " " : rs.getString(6)).append("\t");
                        retTabSepStrBuff.append(rs.getString(7) == null ? " " : rs.getString(7)).append("\t");
                        retTabSepStrBuff.append(rs.getString(8) == null ? " " : rs.getString(8)).append("\t");
                        retTabSepStrBuff.append("\n");
                        ++count;
                    }
                    rs.close();
                    pstmt.close();
                    rs = null;
                    pstmt = null;
                    if (count == 0) {
                        errString = this.itmDBAccessEJB.getErrorString("", "VTNOREC9", "", "", conn);
                    }
                } else {
                    errString = this.itmDBAccessEJB.getErrorString("", "VTNOREC9", "", "", conn);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "SQLException:Emp Workflow Delegation: " + e.getMessage() + ":");
                throw new ITMException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception: Emp Workflow Delegation: " + e.getMessage() + ":");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                conn.close();
                conn = null;
            }
            catch (Exception e) {
                errString = e.getMessage();
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        if (getDataSql.trim().length() > 0 && count > 0) {
            return retTabSepStrBuff.toString();
        }
        return errString;
    }

    @Override
    public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException, ITMException {
        Document detailDom = null;
        Document headerDom = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        String retStr = "";
        BaseLogger.log("2", null, null, "xmlString==" + xmlString);
        BaseLogger.log("2", null, null, "xmlString2==" + xmlString2);
        try {
            if (xmlString != null && xmlString.trim().length() != 0) {
                headerDom = genericUtility.parseString(xmlString);
            }
            if (xmlString2 != null && xmlString2.trim().length() != 0) {
                detailDom = genericUtility.parseString(xmlString2);
            }
            retStr = this.process(headerDom, detailDom, windowName, xtraParams);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :EmpDeligation :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
            e.printStackTrace();
            retStr = e.getMessage();
        }
        return retStr;
    }

    @Override
    public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException, ITMException {
        NodeList parentNodeList = null;
        NodeList childNodeList = null;
        String errString = " ";
        Node parentNode = null;
        Node childNode = null;
        ConnDriver connDriver = new ConnDriver();
        Connection conn = null;
        String empCode = "";
        String refId = "";
        String refSer = "";
        try {
            if (conn == null) {
                conn = connDriver.getConnectDB("Driver");
                conn.setAutoCommit(false);
            }
            BaseLogger.log("3", null, null, "EmpDeligation ejbCreate called.........");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :EmpDeligation :ejbCreate :==>" + e.getMessage());
        }
        try {
            try {
                parentNodeList = detailDom.getElementsByTagName("Detail1");
                parentNode = parentNodeList.item(0);
                childNodeList = parentNode.getChildNodes();
                int i = 0;
                while (i < childNodeList.getLength()) {
                    childNode = childNodeList.item(i);
                    if ("emp_code".equalsIgnoreCase(childNode.getNodeName())) {
                        empCode = childNode.getFirstChild() == null ? "" : childNode.getFirstChild().getNodeValue();
                    } else if ("ref_ser".equalsIgnoreCase(childNode.getNodeName())) {
                        refSer = childNode.getFirstChild() == null ? "" : childNode.getFirstChild().getNodeValue();
                    } else if ("ref_id".equalsIgnoreCase(childNode.getNodeName())) {
                        refId = childNode.getFirstChild() == null ? "" : childNode.getFirstChild().getNodeValue();
                    }
                    ++i;
                }
                if ("".equalsIgnoreCase(empCode)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "NULWFEMP", "", "", conn);
                } else if (this.isEmpCodeValid(conn, empCode)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "INVWFEMP", "", "", conn);
                } else if ("".equalsIgnoreCase(refSer)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "NULWFSER", "", "", conn);
                } else if ("".equalsIgnoreCase(refId)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "NULWFID", "", "", conn);
                } else {
                    this.loginCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
                    this.chgTerm = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
                    int status = this.EmpDeligetionUpdate(empCode, refSer, refId, conn);
                    errString = status > 0 ? this.itmDBAccessEJB.getErrorString("", "VPSUCC9", "", "", conn) : this.itmDBAccessEJB.getErrorString("", "VPFAIL9", "", "", conn);
                }
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                }
                catch (Exception d) {
                    BaseLogger.log("0", null, null, "Exception : EmpDeligationEJB =>" + d.toString());
                }
                BaseLogger.log("0", null, null, "Exception :EmpDeligationEJB :process(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
                e.printStackTrace();
                String string = errString = e.getMessage();
                BaseLogger.log("3", null, null, "Closing Connection....");
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    errString = e2.getMessage();
                    e2.printStackTrace();
                    return errString;
                }
                return string;
            }
        }
        finally {
            BaseLogger.log("3", null, null, "Closing Connection....");
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                errString = e.getMessage();
                e.printStackTrace();
                return errString;
            }
        }
        return errString;
    }

    private int EmpDeligetionUpdate(String empCode, String refSer, String refId, Connection conn) {
        int update = 0;
        Statement pstmt = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        String tranId = "";
        String empCodeAprv = "";
        String updateSql = null;
        String selectSql = null;
        Object sequenceSql = null;
        BaseLogger.log("2", null, null, "EmpDeligationUpdate() method Called");
        try {
            selectSql = " SELECT EMP_CODE from USERS WHERE CODE = ? ";
            pstmt1 = conn.prepareStatement(selectSql);
            pstmt1.setString(1, this.loginCode);
            rs = pstmt1.executeQuery();
            if (rs.next()) {
                String string = empCodeAprv = rs.getString(1) == null ? this.loginCode : rs.getString(1);
            }
            if (!"".equals(refId) && !"".equals(refSer)) {
                String transDB = this.getUserInfo().getTransDB();
                tranId = "" + this.genericUtility.getSeqNextVal(transDB, "EMP_DELIGATION_HIS_SEQ");
                updateSql = " insert into EMP_DELIGATION_HIS  ( TRAN_ID,EMP_CODE,REF_SER,REF_ID,CHG_DATE,CHG_USER,CHG_TERM) values ( ? , ? , ? , ? , ? , ? , ?)";
                pstmt = conn.prepareStatement(updateSql);
                pstmt.setString(1, tranId);
                pstmt.setString(2, empCode);
                pstmt.setString(3, refSer);
                pstmt.setString(4, refId);
                pstmt.setDate(5, new Date(System.currentTimeMillis()));
                pstmt.setString(6, this.loginCode);
                pstmt.setString(7, this.chgTerm);
                update = pstmt.executeUpdate();
                if (update > 0) {
                    update = 0;
                    updateSql = "UPDATE obj_sign_trans SET SIGN_STATUS= ?  WHERE REF_ID = ? and REF_SER = ? and SIGN_STATUS != ? ";
                    pstmt = conn.prepareStatement(updateSql);
                    pstmt.setString(1, "X");
                    pstmt.setString(2, refId);
                    pstmt.setString(3, refSer);
                    pstmt.setString(4, "X");
                    update = pstmt.executeUpdate();
                    if (update > 0) {
                        conn.commit();
                        BaseLogger.log("3", null, null, "Data SuccessFully Updated.");
                    } else {
                        conn.rollback();
                        BaseLogger.log("3", null, null, "roll back from obj_sign_trans");
                    }
                } else {
                    conn.rollback();
                    BaseLogger.log("3", null, null, "roll back from emp_deleg_his");
                }
                BaseLogger.log("3", null, null, "No Of Record Updated[" + update + "]");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (rs1 != null) {
                rs1.close();
                rs1 = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (pstmt1 != null) {
                pstmt1.close();
                pstmt1 = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return update;
    }

    public boolean isEmpCodeValid(Connection conn, String empCode) throws ITMException, RemoteException {
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String sql = "";
        boolean isExist = true;
        try {
            try {
                sql = " SELECT COUNT(EMP_CODE) FROM EMPLOYEE WHERE EMP_CODE = ?";
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, empCode);
                rs = pStmt.executeQuery();
                if (rs.next() && rs.getInt(1) >= 1) {
                    sql = " SELECT COUNT(EMP_CODE) FROM EMP_STATUSCHG WHERE EMP_CODE = ?";
                    pStmt = conn.prepareStatement(sql);
                    pStmt.setString(1, empCode);
                    rs = pStmt.executeQuery();
                    if (rs.next() && rs.getInt(1) >= 1) {
                        isExist = false;
                    }
                }
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, ":: [isEmpCodeValid () ] :: " + ex.getMessage());
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (SQLException ex) {
                System.out.println(":: [isEmpCodeValid ()] [Finally] :: " + ex.getMessage());
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        return isExist;
    }
}

