/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webService.RestAPIService;
import ibase.webitm.utility.DocumentHandlerServiceUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

@Path(value="/DocumentHandlerService")
public class DocumentHandlerService
extends RestAPIService {
    private static final String DUMP_DIR = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "dump/";

    @GET
    @Path(value="/getAttachConfigData")
    @Produces(value={"application/json"})
    public Response getAttachConfigData(@QueryParam(value="OBJ_NAME") String objName, @QueryParam(value="REF_SER") String refser, @QueryParam(value="REF_ID") String refId, @QueryParam(value="CHECK_OBJ_NAME") String checkObjName, @Context HttpServletRequest request, @HeaderParam(value="TOKEN_ID") String tokenIDfromHeader) throws BaseException, Exception {
        BaseLogger.log((String)"3", null, null, (Object)"getAttachConfigData Service Called");
        DocumentHandlerServiceUtility DocumentHandlerServiceUtility2 = new DocumentHandlerServiceUtility();
        byte[] response = DocumentHandlerServiceUtility2.getAttachConfigData(objName, refser, refId, checkObjName, request, tokenIDfromHeader);
        BaseLogger.log((String)"3", null, null, (Object)("response value  :" + response));
        return Response.status((int)200).entity((Object)response).build();
    }

    @GET
    @Path(value="/getFileConfigurationData")
    @Produces(value={"application/json"})
    public Response getFileConfigurationData(@QueryParam(value="OBJ_NAME") String objName, @Context HttpServletRequest request, @HeaderParam(value="TOKEN_ID") String tokenIDfromHeader) throws BaseException, Exception {
        BaseLogger.log((String)"3", null, null, (Object)"getAttachConfigData Service Called");
        DocumentHandlerServiceUtility DocumentHandlerServiceUtility2 = new DocumentHandlerServiceUtility();
        String response = DocumentHandlerServiceUtility2.getFileConfigurationData(objName, request, tokenIDfromHeader);
        BaseLogger.log((String)"3", null, null, (Object)("response value  :" + response));
        return Response.status((int)200).entity((Object)response).build();
    }

    @POST
    @Path(value="/uploadDocument")
    @Consumes(value={"multipart/form-data"})
    public Response uploadDocument(@Context HttpServletRequest request, @Context ServletContext servletContext, @HeaderParam(value="TOKEN_ID") String tokenIDfromHeader) {
        BaseLogger.log((String)"3", null, null, (Object)"uploadDocument Service Called");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Form must have enctype=multipart/form-data.").build();
        }
        try {
            Object fieldName;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setRepository((File)servletContext.getAttribute("javax.servlet.context.tempdir"));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            String captureImage = "false";
            String imgExist = "true";
            String refSer = "COPLST";
            String refId = "TRD";
            String objName = "content_library";
            String documentType = "Others";
            String fileType = "";
            String docLinkOpt = "DOC_CONTENT";
            String fileMetadata = "";
            String docMetaData = "";
            String refDescr = "";
            String expDate = "";
            String cacheOpt = "0";
            InputStream fileContent = null;
            String fileName = null;
            for (FileItem item : items) {
                if (item.isFormField()) {
                    fieldName = item.getFieldName();
                    String fieldValue = item.getString();
                    if ("CAPTURE_IMAGE".equals(fieldName)) {
                        captureImage = fieldValue;
                        continue;
                    }
                    if ("IMG_EXIST".equals(fieldName)) {
                        imgExist = fieldValue;
                        continue;
                    }
                    if ("FILE_NAME".equals(fieldName)) {
                        fileName = fieldValue;
                        continue;
                    }
                    if ("REF_SER".equals(fieldName)) {
                        refSer = fieldValue;
                        continue;
                    }
                    if ("REF_ID".equals(fieldName)) {
                        refId = fieldValue;
                        continue;
                    }
                    if ("OBJ_NAME".equals(fieldName)) {
                        objName = fieldValue;
                        continue;
                    }
                    if ("DOCUMENT_TYPE".equals(fieldName)) {
                        documentType = fieldValue;
                        continue;
                    }
                    if ("FILE_TYPE".equals(fieldName)) {
                        fileType = fieldValue;
                        continue;
                    }
                    if ("DOC_LINK_OPT".equals(fieldName)) {
                        docLinkOpt = fieldValue;
                        continue;
                    }
                    if ("FILE_METADATA".equals(fieldName)) {
                        fileMetadata = fieldValue;
                        continue;
                    }
                    if ("DOC_META_DATA".equals(fieldName)) {
                        docMetaData = fieldValue;
                        continue;
                    }
                    if ("REF_DESCR".equals(fieldName)) {
                        refDescr = fieldValue;
                        continue;
                    }
                    if ("EXP_DATE".equals(fieldName)) {
                        expDate = fieldValue;
                        continue;
                    }
                    if (!"CACHE_OPT".equals(fieldName)) continue;
                    cacheOpt = fieldValue;
                    continue;
                }
                fileName = new File(item.getName()).getName();
                fileContent = item.getInputStream();
            }
            File uploadDir = new File(DUMP_DIR);
            if (!uploadDir.exists()) {
                uploadDir.mkdirs();
            }
            if (fileContent != null && fileName != null) {
                File file = new File(String.valueOf(DUMP_DIR) + fileName);
                fieldName = null;
                Object var25_27 = null;
                try (FileOutputStream out = new FileOutputStream(file);){
                    int read;
                    byte[] bytes = new byte[1024];
                    while ((read = fileContent.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                }
                catch (Throwable throwable) {
                    if (fieldName == null) {
                        fieldName = throwable;
                    } else if (fieldName != throwable) {
                        ((Throwable)fieldName).addSuppressed(throwable);
                    }
                    throw fieldName;
                }
            }
            DocumentHandlerServiceUtility DocumentHandlerServiceUtility2 = new DocumentHandlerServiceUtility();
            String response = DocumentHandlerServiceUtility2.uploadDocument(captureImage, imgExist, fileName, refSer, refId, objName, documentType, fileType, docLinkOpt, fileMetadata, docMetaData, refDescr, expDate, cacheOpt, request, tokenIDfromHeader);
            BaseLogger.log((String)"3", null, null, (Object)("response value  :" + response));
            return Response.status((int)200).entity((Object)response).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"File upload failed").build();
        }
    }

    @GET
    @Path(value="/getDocumentData")
    @Produces(value={"application/json"})
    public Response getDocumentData(@QueryParam(value="OBJ_NAME") String objName, @QueryParam(value="REF_ID") String refId, @QueryParam(value="REF_SER") String refSer, @QueryParam(value="REF_COL") @DefaultValue(value="") String refCol, @Context HttpServletRequest request, @HeaderParam(value="TOKEN_ID") String tokenIDfromHeader) throws BaseException, Exception {
        BaseLogger.log((String)"3", null, null, (Object)"getDocumentData Service Called");
        DocumentHandlerServiceUtility DocumentHandlerServiceUtility2 = new DocumentHandlerServiceUtility();
        String response = DocumentHandlerServiceUtility2.getDocumentData(objName, refId, tokenIDfromHeader, refCol, refSer);
        BaseLogger.log((String)"3", null, null, (Object)("getDocumentData response value  :" + response));
        return Response.status((int)200).entity((Object)response).build();
    }
}

