package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.*;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.ejb.*;
import org.w3c.dom.*;

//@Stateless		commented by Sagar M [22 Nov 2018].

public class StrgClassMasterEJB extends ValidatorEJB implements StrgClassMasterEJBLocal,StrgClassMasterEJBRemote{
	E12GenericUtility genericUtility = new E12GenericUtility();
	// Code for Validation
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}


	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{


		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			System.out.println("StrgClassMasterEJB:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("StrgClassMasterEJB:wfValData value of xmlString1 ["+xmlString1+"]");
			System.out.println("StrgClassMasterEJB:wfValData value of xmlString2 ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ("ErrString: " + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception: StrgClassMasterEJB: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ("Returning from StrgClassMasterEJB wfValData");
		return (errString);
	}



	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0,cnt =0;

		String childNodeName = null,childNodeValue = null;
		String errString = "";
		String errCode = "";
		Connection conn = null;
		String userId = "";

		String loginSite = "";
		String code="",description = "",therapeutic_group= "",item_ser = "";
		String active ="";

		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			//Commented by vinayak on [11/07/2016] [end]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println(" ***********Validation for StrgClassMasterEJB Detail  "+currentFormNo);
			switch(currentFormNo)
			{
				case 1 :
					System.out.println("Validation for Detail 1 StrgClassMasterEJB..........");
					System.out.println("Validation for StrgClassMasterEJB.........."+dom.getElementsByTagName("Detail1"));
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
				    childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{

						childNode = childNodeList.item(ctr);
						System.out.println("childNode.........."+ctr+"       "+childNode);
						childNodeName = childNode.getNodeName();
						System.out.println("childNodeName.........."+ctr+"       "+childNodeName);
						if(childNode.getFirstChild()!= null)
						{
							childNodeValue = childNode.getFirstChild().getNodeValue();
						}




						if(childNodeName.equalsIgnoreCase("class_code"))
						{
							//columnValue = childNode.getFirstChild().getNodeValue().trim();
							if(childNode.getFirstChild() == null)
							{
								errCode = "VTCLASSNUL";
								errString =  getErrorString("class_code",errCode,userId);
								break ;
							}
							else
							{
								code = genericUtility.getColumnValue("class_code", dom);
								cnt =  isValueExist("STRG_CLASS","CLASS_CODE",code, conn);
								if("A".equalsIgnoreCase(editFlag))
								{
									if(cnt>0)
									{
										errCode = "VTDUPCLS";
										errString =  getErrorString("class_code",errCode,userId);
										break ;
									}
									else
									{
										Pattern p = Pattern.compile("[^A-Za-z0-9]");
									    Matcher m = p.matcher(code);
									     boolean b = m.find();
									     if (b == true)
									     {
									    	errCode = "VTINVCLS1";
									    	errString =  getErrorString("class_code",errCode,userId);
											break ;
									     }
									}
								}
							}
						}

						if(childNodeName.equalsIgnoreCase("active_yn"))
						{
							if(editFlag.equals("E"))
							{
								active = genericUtility.getColumnValue("active_yn", dom);
								code = genericUtility.getColumnValue("class_code", dom);
								System.out.println("active ::"+active);
								System.out.println("code ::"+code);
								if(active.equals("N"))
								{
									cnt =  isValueExist("STRG_SER_CLASS","CLASS_CODE",code, conn);
									if(cnt > 0)
									{
										errCode = "VTACTCLS";
										errString =  getErrorString("active_yn",errCode,userId);
										break ;
									}

								}
							}
						}

					}

			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
			System.out.println(" StrgClassMasterEJB Validation End and Connection is Closed");
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}//END OF VALIDATION



	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			System.out.println("StrgClassMasterEJB:itemChanged value of xmlString ["+xmlString+"]");
			System.out.println("StrgClassMasterEJB:itemChanged value of xmlString ["+xmlString1+"]");
			System.out.println("StrgClassMasterEJB:itemChanged value of xmlString ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception : StrgClassMasterEJB:itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from StrgClassMasterEJB  itemChanged");
		return errString;
	 }


	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		int currentFormNo = 0;
		StringBuffer valueXmlString =null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		String class_code="";
		String addDate="";
		String addUser="";
		String addTerm="";
		String chgDate = "";
		String chgUser = "";
		String chgTerm = "";
		Connection connection = null;
		ConnDriver connDriver = null;
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");*/
			//Commented by vinayak on [11/07/2016] [end]
			connection = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			addDate = sdf.format(new java.util.Date());
			addUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			addTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			chgDate = sdf.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");

			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n<Detail1>\r\n");
			switch (currentFormNo)
			{
				case 1:
					if (currentColumn.equalsIgnoreCase("itm_default"))
					{
						System.out.println("value of addDate"+addDate);
						System.out.println("value of addUser"+addUser);
						System.out.println("value of addterm"+addTerm);
						System.out.println("value of chgDate"+chgDate);
						System.out.println("value of chgUser"+chgUser);
						System.out.println("value of chgterm"+chgTerm);
						valueXmlString.append("<active_yn>").append("<![CDATA[Y]]>").append("</active_yn>\r\n");
						valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
					}

					else if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
					{
						class_code = genericUtility.getColumnValue("class_code", dom);
						valueXmlString.append("<class_code protect=\"1\"><![CDATA[").append(checkNull(class_code)).append("]]></class_code>\r\n");
					}


			break;
		}
	}
	catch (Exception e)
	{
		System.out.println ("Exception :StrgClassMasterEJB :itemChanged(Document,String):" + e.getMessage() + ":");
		valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		throw new ITMException(e); //added by Kailash on 11-04-2018.
	}
	finally
	{
		try
		{
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
			if(connection != null)
			{
				connection.close();
				connection = null;
			}
        }
		catch(Exception e)
		{
			System.out.println(e.getMessage());
		}
	}
	valueXmlString.append ("</Detail1>\r\n");
	valueXmlString.append("</Root>\r\n");
	System.out.println("BrandMAster :itemChanged(Document,String):return valueXmlString"+valueXmlString);
	return valueXmlString.toString();

}


	private int isValueExist(String tableName, String columnName, String columnValue,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
    {
    	PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = null;
        int cnt = 0 ;
        sql = " select count(1) as count from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
        try
        {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
            if(rs.next())
            {
            	cnt = rs.getInt("count");
            }
            rs.close();
            pstmt.close();
            System.out.println("cnt--------------"+cnt);
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            System.out.println("Exception ::" + exception.getMessage());
            throw new ITMException(exception); //added by Kailash on 11-04-2018.
        }
        return cnt;
    }


	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input =input.trim();
		}
		return input;
	}
}
