/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLtoJSONConverter {
    public String xmlToJSONString(String xmlString) throws Exception {
        String jsonString;
        block3: {
            jsonString = "";
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                xmlString = E12GenericUtility.checkNull(xmlString);
                if (xmlString.length() <= 0) break block3;
                if (genericUtility.isXMLString(xmlString)) {
                    xmlString = xmlString.replaceAll("\n", "").replaceAll("\r", "");
                    xmlString = xmlString.replaceAll("\t", "");
                    xmlString = xmlString.replaceAll("(?!>\\s+</)(>\\s+<)", "><");
                    Document document = genericUtility.parseString(xmlString);
                    document.getDocumentElement().normalize();
                    Element root = document.getDocumentElement();
                    BaseLogger.log("3", null, null, "rootNodeName - [" + root.getNodeName() + "]");
                    NodeList nList = document.getElementsByTagName(root.getNodeName());
                    JSONObject jsonObject = new JSONObject();
                    XMLtoJSONConverter.toJSONObject(nList, jsonObject);
                    jsonString = jsonObject.toString();
                    break block3;
                }
                throw new Exception("Invalid XMLString");
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "jsonString : [" + jsonString + "]");
        return jsonString;
    }

    private static void toJSONObject(NodeList nList, JSONObject context) {
        try {
            int temp = 0;
            while (temp < nList.getLength()) {
                Node node = nList.item(temp);
                if (node.getNodeType() == 1) {
                    Node tempNode;
                    int i;
                    NamedNodeMap nodeMap;
                    JSONObject attribJsonObj;
                    JSONObject jsonobject;
                    if (node.hasChildNodes()) {
                        if (node.getChildNodes().item(0).getNodeValue() != null) {
                            context.accumulate(node.getNodeName(), (Object)node.getTextContent());
                        } else {
                            jsonobject = new JSONObject();
                            context.accumulate(node.getNodeName(), (Object)jsonobject);
                            if (node.hasAttributes()) {
                                attribJsonObj = new JSONObject();
                                jsonobject.accumulate("attrib", (Object)attribJsonObj);
                                nodeMap = node.getAttributes();
                                i = 0;
                                while (i < nodeMap.getLength()) {
                                    tempNode = nodeMap.item(i);
                                    attribJsonObj.accumulate("@" + tempNode.getNodeName(), (Object)tempNode.getNodeValue());
                                    ++i;
                                }
                            }
                            XMLtoJSONConverter.toJSONObject(node.getChildNodes(), jsonobject);
                        }
                    } else if (node.hasAttributes()) {
                        jsonobject = new JSONObject();
                        context.accumulate(node.getNodeName(), (Object)jsonobject);
                        attribJsonObj = new JSONObject();
                        jsonobject.accumulate("attrib", (Object)attribJsonObj);
                        nodeMap = node.getAttributes();
                        i = 0;
                        while (i < nodeMap.getLength()) {
                            tempNode = nodeMap.item(i);
                            attribJsonObj.accumulate("@" + tempNode.getNodeName(), (Object)tempNode.getNodeValue());
                            ++i;
                        }
                        if (node.hasChildNodes()) {
                            XMLtoJSONConverter.toJSONObject(node.getChildNodes(), context);
                        }
                    }
                }
                ++temp;
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

