/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.bean;

import ibase.bi.ejb.session.Argument;
import ibase.bi.ejb.session.PopUpEJB;
import ibase.bi.utility.BIException;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArgumentBean
implements Serializable {
    private PopUpEJB popUp = new PopUpEJB();
    private HashMap popUpInfo = null;
    private String databaseParam = null;
    private String baName = null;

    public ArgumentBean(String baName) throws Exception {
        BaseLogger.log("1", null, null, "ArgumentBean Created");
        Properties props = null;
        InitialContext ctx = null;
        try {
            this.setBAName(baName);
            AppConnectParm appConnect = new AppConnectParm("BI");
            props = appConnect.getProperty();
            ctx = new InitialContext(props);
            this.popUp = new PopUpEJB();
            BaseLogger.log("1", null, null, "PopUpEJB created for BArea :" + this.databaseParam);
            this.popUp.createPopUpList(this.databaseParam);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void setDatabaseParam(String databaseParam) throws Exception {
        this.databaseParam = databaseParam;
    }

    private void setBAName(String baName) throws Exception {
        this.baName = baName;
        this.setDatabaseParam(baName);
    }

    public ArrayList getPopUpList(ArrayList argumentList) throws Exception {
        try {
            ArrayList<String> popUpList = new ArrayList<String>();
            this.getPopUpInfo(argumentList);
            if (this.popUpInfo != null) {
                for (String key : this.popUpInfo.keySet()) {
                    popUpList.add(key);
                }
            } else {
                popUpList = null;
            }
            return popUpList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList getPopUpList(ArrayList argumentList, String modName) throws Exception {
        try {
            ArrayList<String> popUpList = new ArrayList<String>();
            this.getPopUpInfo(argumentList, modName);
            if (this.popUpInfo != null) {
                for (String key : this.popUpInfo.keySet()) {
                    popUpList.add(key);
                }
            } else {
                popUpList = null;
            }
            return popUpList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private HashMap getPopUpInfo(ArrayList argumentList, String modName) throws Exception {
        this.popUpInfo = new HashMap();
        String popUpInfoString = this.getPopUpInfoString(argumentList, modName);
        if (popUpInfoString != null && popUpInfoString.length() > 0) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                ByteArrayInputStream bais = new ByteArrayInputStream(popUpInfoString.getBytes());
                Document doc = docBuilder.parse(bais);
                NodeList nodeList0 = doc.getElementsByTagName("POPUPINFO");
                NodeList nodeList = nodeList0.item(0).getChildNodes();
                int ctr = 0;
                while (ctr < nodeList.getLength()) {
                    String popID = nodeList.item(ctr).getNodeName();
                    NamedNodeMap attributeMap = nodeList.item(ctr).getAttributes();
                    ArrayList<String> popUpInfoList = new ArrayList<String>();
                    int ctr1 = 0;
                    while (ctr1 < attributeMap.getLength()) {
                        Node eachAttribute = attributeMap.item(ctr1);
                        String attributeName = eachAttribute.getNodeName().trim();
                        String attributeValue = eachAttribute.getNodeValue().trim();
                        if (attributeName.equalsIgnoreCase("dataSensitive") && attributeValue.equalsIgnoreCase("YES")) {
                            popUpInfoList.add(nodeList.item(ctr).getFirstChild().getNodeValue().trim());
                        } else if (attributeName.equalsIgnoreCase("dataSensitive") && attributeValue.equalsIgnoreCase("NO")) {
                            popUpInfoList.add(null);
                        } else if (attributeName.equalsIgnoreCase("width")) {
                            popUpInfoList.add(attributeValue);
                        } else if (attributeName.equalsIgnoreCase("height")) {
                            popUpInfoList.add(attributeValue);
                        }
                        this.popUpInfo.put(popID, popUpInfoList);
                        ++ctr1;
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception while parsing the returned popUpInfoString");
                e.printStackTrace();
                this.popUpInfo = null;
            }
        }
        return this.popUpInfo;
    }

    private String getPopUpInfoString(ArrayList argumentList, String modName) throws Exception {
        BaseLogger.log("1", null, null, "createPopUpList databaseParam getPopUpInfoString: argumentList " + argumentList + " modName " + modName);
        String popUpInfoString = null;
        ArrayList<String> columnList = new ArrayList<String>();
        try {
            int ctr = 0;
            while (ctr < argumentList.size()) {
                Argument argument = (Argument)argumentList.get(ctr);
                String colName = argument.getColName();
                if (colName.contains("WHERE")) {
                    if ((colName = colName.substring(colName.indexOf("WHERE") + 6)).contains(".")) {
                        colName = colName.substring(colName.lastIndexOf(".") + 1);
                    }
                } else if ((colName = colName.substring(colName.lastIndexOf(".") + 1)).contains("AND")) {
                    colName = colName.substring(colName.indexOf("AND") + 3);
                } else if (colName.contains("OR")) {
                    colName = colName.substring(colName.indexOf("OR") + 2);
                }
                if (colName.contains("DATE")) {
                    argument.setDataType("Date");
                    argument.setDisplayPattern(CommonConstants.DISPLAY_DATE_PATTERN);
                }
                columnList.add(colName);
                ++ctr;
            }
            String[] colNames = new String[columnList.size()];
            BaseLogger.log("3", null, null, "columnList :" + columnList);
            popUpInfoString = this.popUp.getCurrentPopUpInfo(columnList.toArray(colNames), this.databaseParam, modName);
            return popUpInfoString;
        }
        catch (Exception e) {
            BaseLogger.log("1", null, null, " getPopUpInfoString exception: " + e);
            throw e;
        }
    }

    private HashMap getPopUpInfo(ArrayList argumentList) throws Exception {
        this.popUpInfo = new HashMap();
        String popUpInfoString = this.getPopUpInfoString(argumentList);
        if (popUpInfoString != null && popUpInfoString.length() > 0) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                ByteArrayInputStream bais = new ByteArrayInputStream(popUpInfoString.getBytes());
                Document doc = docBuilder.parse(bais);
                NodeList nodeList0 = doc.getElementsByTagName("POPUPINFO");
                NodeList nodeList = nodeList0.item(0).getChildNodes();
                int ctr = 0;
                while (ctr < nodeList.getLength()) {
                    String popID = nodeList.item(ctr).getNodeName();
                    NamedNodeMap attributeMap = nodeList.item(ctr).getAttributes();
                    ArrayList<String> popUpInfoList = new ArrayList<String>();
                    int ctr1 = 0;
                    while (ctr1 < attributeMap.getLength()) {
                        Node eachAttribute = attributeMap.item(ctr1);
                        String attributeName = eachAttribute.getNodeName().trim();
                        String attributeValue = eachAttribute.getNodeValue().trim();
                        if (attributeName.equalsIgnoreCase("dataSensitive") && attributeValue.equalsIgnoreCase("YES")) {
                            popUpInfoList.add(nodeList.item(ctr).getFirstChild().getNodeValue().trim());
                        } else if (attributeName.equalsIgnoreCase("dataSensitive") && attributeValue.equalsIgnoreCase("NO")) {
                            popUpInfoList.add(null);
                        } else if (attributeName.equalsIgnoreCase("width")) {
                            popUpInfoList.add(attributeValue);
                        } else if (attributeName.equalsIgnoreCase("height")) {
                            popUpInfoList.add(attributeValue);
                        }
                        this.popUpInfo.put(popID, popUpInfoList);
                        ++ctr1;
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception while parsing the returned popUpInfoString");
                e.printStackTrace();
                this.popUpInfo = null;
            }
        }
        return this.popUpInfo;
    }

    private String getPopUpInfoString(ArrayList argumentList) throws Exception {
        String popUpInfoString = null;
        ArrayList<String> columnList = new ArrayList<String>();
        int ctr = 0;
        while (ctr < argumentList.size()) {
            Argument argument = (Argument)argumentList.get(ctr);
            String colName = argument.getColName().substring(argument.getColName().lastIndexOf(".") + 1);
            columnList.add(colName);
            ++ctr;
        }
        String[] colNames = new String[columnList.size()];
        BaseLogger.log("3", null, null, "columnList :" + columnList);
        popUpInfoString = this.popUp.getCurrentPopUpInfo(columnList.toArray(colNames), this.databaseParam);
        return popUpInfoString;
    }

    public String getDataSensitiveParameters(String colName) throws Exception {
        try {
            String dataSensitiveParameters = "";
            String key = colName;
            String sqlInputString = (String)((ArrayList)this.popUpInfo.get(key)).get(0);
            if (sqlInputString != null) {
                StringTokenizer st = new StringTokenizer(sqlInputString, ",");
                boolean ctr = false;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    dataSensitiveParameters = String.valueOf(dataSensitiveParameters) + token.substring(token.indexOf(".") + 1).trim() + "~";
                }
                dataSensitiveParameters = dataSensitiveParameters.substring(0, dataSensitiveParameters.length() - 1);
                return dataSensitiveParameters;
            }
            return null;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getWindowSize(String colName) throws Exception {
        try {
            String widthStr = (String)((ArrayList)this.popUpInfo.get(colName)).get(1);
            String heightStr = (String)((ArrayList)this.popUpInfo.get(colName)).get(2);
            return String.valueOf(widthStr) + "~" + heightStr;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getPopUpXML(String fieldName, String fieldType, String[] parameters, String userInfoStr) throws Exception {
        String xmlString = null;
        try {
            xmlString = this.popUp.getPopUpValues(fieldName, fieldType, parameters, this.databaseParam, userInfoStr);
            return xmlString;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getPopUpXML(String fieldName, String fieldType, String[] parameters, String userInfoStr, String modeName) throws Exception {
        String xmlString = null;
        try {
            xmlString = this.popUp.getPopUpValues(fieldName, fieldType, parameters, this.databaseParam, userInfoStr, modeName);
            return xmlString;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }
}

