/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.bean.ExtAuthAppAPIBean;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.E12ExtServiceUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.HttpHeaders;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class VisionOBJServiceUtility
extends RestAPIServiceUtility {
    VisionOBJServiceUtility() {
    }

    public UserInfoBean getUserInfoFromRequest(HttpServletRequest request) {
        UserInfoBean userInfo = null;
        String userInfoStr = "";
        try {
            HttpSession session = request.getSession();
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!((String)attributeNames.nextElement()).equals("USER_INFO")) continue;
                userInfoStr = session.getAttribute("USER_INFO").toString();
            }
            if (!userInfoStr.equals("")) {
                userInfo = new UserInfoBean(userInfoStr);
            }
            return userInfo;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Error in getting User info from Request [" + e.getMessage() + "]"));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPageDetails(HttpServletRequest request, HttpHeaders header, String appId, String objName, String pageNo) {
        String result = "";
        String params = "";
        String status = "error";
        String tokenId = "";
        E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                paramString.append("APP_ID=" + appId);
                paramString.append("&OBJ_NAME=" + objName);
                paramString.append("&PAGE_NO=" + pageNo);
                params = paramString.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("getPageDetails() params=" + params));
            tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageDetails");
            BaseLogger.log((String)"3", null, null, (Object)("getPageDetails() result=" + result));
            if ("valid".equalsIgnoreCase(result)) {
                objName = this.checkNull(objName);
                appId = this.checkNull(appId);
                pageNo = this.checkNull(pageNo);
                if (objName.length() == 0) {
                    result = "Please enter valid Object Name.";
                    status = "error";
                    return result;
                }
                DBAccessEJB dbAccess = new DBAccessEJB();
                UserInfoBean userInfo = this.getUserInfoFromRequest(request);
                String pageDetails = dbAccess.getPageDetails(objName, "1", null, userInfo, "T", pageNo);
                JSONObject jsonObject = XML.toJSONObject((String)pageDetails);
                BaseLogger.log((String)"3", null, null, (Object)("getPageDetails with pageno API works JSON=" + jsonObject.toString()));
                result = jsonObject.toString();
                status = "success";
                String string = result;
                return string;
            }
            status = "error";
            return result;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getPageDetails : " + e.getMessage()));
            status = "exception";
            result = this.getStackTrace(e, "JSON");
            return result;
        }
        finally {
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getListPageData(HttpServletRequest request, HttpHeaders header, String appId, String objName, String objContext, String pageContext, String currentRowNo, String upToRowNo) {
        E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
        String result = "";
        String params = "";
        String status = "error";
        String tokenId = "";
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                paramString.append("APP_ID=" + appId);
                paramString.append("&OBJ_CONTEXT=" + objContext);
                paramString.append("&PAGE_CONTEXT=" + pageContext);
                paramString.append("&CURR_ROW_NUM=" + currentRowNo);
                paramString.append("&UPTO_ROW_NUM=" + upToRowNo);
                params = paramString.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("getListPageData() params=" + params));
            tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
            BaseLogger.log((String)"3", null, null, (Object)("getListPageData() tokenId=" + tokenId));
            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageDetails");
            BaseLogger.log((String)"3", null, null, (Object)("getListPageData() result=" + result));
            if ("valid".equalsIgnoreCase(result)) {
                appId = this.checkNull(appId);
                objName = this.checkNull(objName);
                objContext = this.checkNull(objContext);
                pageContext = this.checkNull(pageContext);
                currentRowNo = this.checkNull(currentRowNo);
                upToRowNo = this.checkNull(upToRowNo);
                if (objName.length() == 0) {
                    result = "Please enter valid Object Name.";
                    status = "error";
                    return result;
                }
                MasterDataEJB masterDataEJB = new MasterDataEJB();
                HttpSession sess = request.getSession();
                String qryParam = "";
                String qryParamType = "";
                String advQuery = "";
                UserInfoBean userInfo = this.getUserInfoFromRequest(request);
                boolean isRCP = true;
                boolean isMaxBrowCheck = true;
                String globalFilterFlag = "";
                HashMap<String, String> incrementalSearchParam = new HashMap<String, String>();
                incrementalSearchParam.put("CURR_ROW_NUM", currentRowNo == null ? "0" : currentRowNo);
                incrementalSearchParam.put("UPTO_ROW_NUM", upToRowNo == null ? "0" : upToRowNo);
                String xmlData = masterDataEJB.getXMLFromDBForBrow(objName, "1", "1", qryParam, qryParamType, advQuery, userInfo, isRCP, globalFilterFlag, incrementalSearchParam, isMaxBrowCheck);
                JSONObject jsonObject = XML.toJSONObject((String)xmlData);
                result = jsonObject.toString();
                status = "success";
                String string = result;
                return string;
            }
            status = "error";
            return result;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getPageDetails : " + e.getMessage()));
            status = "exception";
            result = this.getStackTrace(e, "JSON");
            return result;
        }
        finally {
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
    }

    public Object getPageMetadata(HttpServletRequest request, HttpHeaders header, String appId, String objName, String formName, String objContext, String pageContext) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block16: {
            BaseLogger.log((String)"3", null, null, (Object)"Inside getPageMetadata : VisonObjServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            userInfo = null;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            try {
                try {
                    RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                    params = request.getQueryString();
                    BaseLogger.log((String)"3", null, null, (Object)("request.getQueryString() " + request.getQueryString()));
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("APP_ID=" + appId);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&FORMA_NAME=" + formName);
                        paramString.append("&OBJ_CONTEXT=" + objContext);
                        paramString.append("&PAGE_CONTEXT=" + pageContext);
                        params = paramString.toString();
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("getFormalArgs() params=" + params));
                    ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getFormalArgs", appId);
                    tokenId = this.checkNull(this.getTokenFromHeaders(header));
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                    } else if (authAppAPIBean == null) {
                        status = "Reject";
                        result = "This service not available";
                    } else {
                        APIUtility apiUtility = new APIUtility();
                        result = e12ExtServiceUtility.validateRequest(request, dataFormat, tokenId, true, appId, "getFormalArgs");
                        BaseLogger.log((String)"3", null, null, (Object)("getFormalArgs() validateRequest - [" + result + "]"));
                        if ("valid".equalsIgnoreCase(result)) {
                            userInfo = this.getUserInfoFromRequest(request);
                            if (userInfo == null) {
                                userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
                            }
                            if (apiUtility.checkDailyAPILimit(userInfo)) {
                                status = "Reject";
                                result = "Daily API call limit exceeded";
                            } else {
                                E12GenericUtility genericUtility = new E12GenericUtility();
                                String transDB = userInfo.getTransDB();
                                HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
                                if (userInfo != null) {
                                    propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                                    propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                                    propEditorInfoMap.put("USER_ID", this.checkNull(userInfo.getLoginCode()));
                                    propEditorInfoMap.put("PROFILE_ID", this.checkNull(userInfo.getProfileId()));
                                }
                                propEditorInfoMap.put("EDITOR", "WebEditor");
                                String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "", propEditorInfoMap, transDB);
                                BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() FilePath=" + filePath));
                                File metadataFile = new File(filePath);
                                String xmlString = this.readFile(metadataFile);
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("id", (Object)(String.valueOf(objName) + "_" + objContext + "_" + pageContext));
                                jsonObject.put("obj_name", (Object)objName);
                                jsonObject.put("form_title", (Object)formName);
                                jsonObject.put("form_no", (Object)objContext);
                                jsonObject.put("page_context", (Object)pageContext);
                                jsonObject.put("columns", (Object)this.getPageMetadataJSON(xmlString));
                                result = jsonObject.toString();
                                status = "success";
                            }
                        } else {
                            status = "error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"0", null, null, (Object)("Exception : getData : " + e.getMessage()));
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = e12ExtServiceUtility.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                result = e12ExtServiceUtility.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = e12ExtServiceUtility.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result);
        }
        e12ExtServiceUtility.writeAPICallLog("getFormalArgs ( /getFormalArgs )", status, result, appId, request, userInfo);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPageMeta(HttpServletRequest request, HttpHeaders header, String appId, String objName, String formName, String objContext, String pageContext) {
        E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
        String result = "";
        String params = "";
        String status = "error";
        String tokenId = "";
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                paramString.append("APP_ID=" + appId);
                paramString.append("&OBJ_NAME=" + objName);
                paramString.append("&FORMA_NAME=" + formName);
                paramString.append("&OBJ_CONTEXT=" + objContext);
                paramString.append("&PAGE_CONTEXT=" + pageContext);
                params = paramString.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() params=" + params));
            tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() tokenId=" + tokenId));
            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageMetadata");
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() result=" + result));
            if ("valid".equalsIgnoreCase(result)) {
                appId = this.checkNull(appId);
                objName = this.checkNull(objName);
                objContext = this.checkNull(objContext);
                pageContext = this.checkNull(pageContext);
                if (objName.length() == 0) {
                    result = "Please enter valid Object Name.";
                    status = "error";
                    return result;
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                UserInfoBean userInfo = this.getUserInfoFromRequest(request);
                String transDB = userInfo.getTransDB();
                HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
                if (userInfo != null) {
                    propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                    propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                    propEditorInfoMap.put("USER_ID", this.checkNull(userInfo.getLoginCode()));
                    propEditorInfoMap.put("PROFILE_ID", this.checkNull(userInfo.getProfileId()));
                }
                propEditorInfoMap.put("EDITOR", "WebEditor");
                String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "", propEditorInfoMap, transDB);
                BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() FilePath=" + filePath));
                File metadataFile = new File(filePath);
                String xmlString = this.readFile(metadataFile);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)(String.valueOf(objName) + "_" + objContext + "_" + pageContext));
                jsonObject.put("obj_name", (Object)objName);
                jsonObject.put("form_title", (Object)formName);
                jsonObject.put("form_no", (Object)objContext);
                jsonObject.put("page_context", (Object)pageContext);
                jsonObject.put("columns", (Object)this.getPageMetadataJSON(xmlString));
                result = jsonObject.toString();
                status = "success";
                String string = result;
                return string;
            }
            status = "error";
            return result;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getPageDetails : " + e.getMessage()));
            status = "exception";
            result = this.getStackTrace(e, "JSON");
            return result;
        }
        finally {
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
    }

    public String getFormalArgs(HttpServletRequest request, HttpHeaders header, String appId, String objName, String pageNo, String formName) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block15: {
            BaseLogger.log((String)"3", null, null, (Object)"Inside getFormalArgs : VisonObjServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            userInfo = null;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            try {
                try {
                    RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                    params = request.getQueryString();
                    BaseLogger.log((String)"3", null, null, (Object)("request.getQueryString() " + request.getQueryString()));
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("APP_ID=" + appId);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&PAGE_NO=" + pageNo);
                        params = paramString.toString();
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("getFormalArgs() params=" + params));
                    ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getFormalArgs", appId);
                    tokenId = this.checkNull(this.getTokenFromHeaders(header));
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                    } else if (authAppAPIBean == null) {
                        status = "Reject";
                        result = "This service not available";
                    } else {
                        APIUtility apiUtility = new APIUtility();
                        result = e12ExtServiceUtility.validateRequest(request, dataFormat, tokenId, true, appId, "getFormalArgs");
                        BaseLogger.log((String)"3", null, null, (Object)("getFormalArgs() validateRequest - [" + result + "]"));
                        if ("valid".equalsIgnoreCase(result)) {
                            userInfo = this.getUserInfoFromRequest(request);
                            if (userInfo == null) {
                                userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
                            }
                            if (apiUtility.checkDailyAPILimit(userInfo)) {
                                status = "Reject";
                                result = "Daily API call limit exceeded";
                            } else {
                                DBAccessEJB dbAccess = new DBAccessEJB();
                                String pageDetails = dbAccess.getPageDetails(objName, "1", null, userInfo, "T", pageNo);
                                BaseLogger.log((String)"3", null, null, (Object)("getFormalArgs with pageno API works XML=" + pageDetails));
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("columns", (Object)this.getFormalArgs(pageDetails));
                                jsonObject.put("form_title", (Object)("Search in " + formName));
                                jsonObject.put("form_no", (Object)"0");
                                jsonObject.put("obj_name", (Object)objName);
                                jsonObject.put("id", (Object)(String.valueOf(objName) + "_1_2"));
                                BaseLogger.log((String)"3", null, null, (Object)("getFormalArgs with pageno API works JSON=" + jsonObject.toString()));
                                result = jsonObject.toString();
                                status = "success";
                            }
                        } else {
                            status = "error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"0", null, null, (Object)("Exception : getData : " + e.getMessage()));
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = e12ExtServiceUtility.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                result = e12ExtServiceUtility.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = e12ExtServiceUtility.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result);
        }
        e12ExtServiceUtility.writeAPICallLog("getFormalArgs ( /getFormalArgs )", status, result, appId, request, userInfo);
        return result;
    }

    public String getData(HttpServletRequest request, HttpHeaders header, String objName, String refId, String dataFormat, String appId) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block16: {
            BaseLogger.log((String)"3", null, null, (Object)"Inside getData : VisonObjServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            userInfo = null;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            try {
                try {
                    tokenId = this.checkNull(this.getTokenFromHeaders(header));
                    RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                    params = request.getQueryString();
                    BaseLogger.log((String)"3", null, null, (Object)("request.getQueryString() " + request.getQueryString()));
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&REF_ID=" + refId);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("getData() params=" + params));
                    ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("VisionOBJService/getData", appId);
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                    } else if (authAppAPIBean == null) {
                        status = "Reject";
                        result = "This service not available";
                    } else {
                        APIUtility apiUtility = new APIUtility();
                        result = e12ExtServiceUtility.validateRequest(request, dataFormat, tokenId, true, appId, "VisionOBJService/getData");
                        BaseLogger.log((String)"3", null, null, (Object)("getData() validateRequest - [" + result + "]"));
                        if ("valid".equalsIgnoreCase(result)) {
                            userInfo = this.getUserInfoFromRequest(request);
                            if (userInfo == null) {
                                userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
                            }
                            if (apiUtility.checkDailyAPILimit(userInfo)) {
                                status = "Reject";
                                result = "Daily API call limit exceeded";
                            } else {
                                result = this.getDetailXMLDomString(objName, "1", "V", refId, null, userInfo);
                                BaseLogger.log((String)"3", null, null, (Object)(" variable: resultinXML length: [" + result.length() + "]" + "method: getData : class: VisionOBJService "));
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    JSONObject jsonObject = XML.toJSONObject((String)result);
                                    BaseLogger.log((String)"3", null, null, (Object)("getData  JSON=" + jsonObject.toString()));
                                    result = jsonObject.toString();
                                    status = "success";
                                }
                                status = "success";
                            }
                        } else {
                            status = "error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"0", null, null, (Object)("Exception : getData : " + e.getMessage()));
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = e12ExtServiceUtility.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                result = e12ExtServiceUtility.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = e12ExtServiceUtility.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
        }
        e12ExtServiceUtility.writeAPICallLog("getFormalArgs ( VisionOBJService/getData )", status, result, appId, request, userInfo);
        return result;
    }

    private String readFile(File fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        try {
            if (fileName.exists()) {
                FileInputStream fMainIn = new FileInputStream(fileName);
                bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
                String outTempStr = null;
                while ((outTempStr = bfr.readLine()) != null) {
                    fileContent.append(outTempStr);
                }
                bfr.close();
                bfr = null;
            }
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("Exception in releasing file resource :[" + fileName + "]"));
                e.printStackTrace();
            }
        }
        return fileContent.toString();
    }

    private JSONArray getPageMetadataJSON(String xmlData) {
        try {
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() xmlData=" + xmlData.length()));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlData.getBytes()));
            NodeList columnObjectList = doc.getElementsByTagName("ColumnObject");
            NodeList textObjectList = doc.getElementsByTagName("TextObject");
            Map<String, String> labelMap = this.getLabelMap(textObjectList);
            BaseLogger.log((String)"3", null, null, (Object)("label map " + labelMap));
            NodeList groupboxObjectList = doc.getElementsByTagName("GroupBox");
            JSONArray groupArray = this.getGroupBoxArray(groupboxObjectList);
            BaseLogger.log((String)"3", null, null, (Object)("group array = " + groupArray.toString()));
            NodeList tableColumnList = doc.getElementsByTagName("table_column");
            Map<String, JSONObject> tableColumnObjectWithValue = this.getValueTableColumn(tableColumnList);
            BaseLogger.log((String)"3", null, null, (Object)("table column size " + tableColumnList.getLength()));
            JSONArray columnArray = new JSONArray();
            int i = 0;
            while (i < columnObjectList.getLength()) {
                Element columnObject = (Element)columnObjectList.item(i);
                JSONObject column = new JSONObject();
                column.put("alignment", (Object)this.getElementValue(columnObject, "alignment"));
                column.put("tabsequence", (Object)this.getElementValue(columnObject, "tabsequence"));
                column.put("x", (Object)this.getElementValue(columnObject, "x"));
                column.put("y", (Object)this.getElementValue(columnObject, "y"));
                column.put("height", (Object)this.getElementValue(columnObject, "height"));
                column.put("width", (Object)this.getElementValue(columnObject, "width"));
                column.put("format", (Object)this.getElementValue(columnObject, "format"));
                column.put("name", (Object)this.getElementValue(columnObject, "name"));
                column.put("visible", (Object)this.getElementValue(columnObject, "visible"));
                column.put("tag", (Object)this.getElementValue(columnObject, "tag"));
                Element editStyle = (Element)columnObject.getElementsByTagName("EditStyle").item(0);
                String style = editStyle.getAttribute("style");
                column.put("edit_style", (Object)style);
                String limit = this.getElementValue(editStyle, "limit");
                column.put("limit", (Object)limit);
                String required = this.getElementValue(editStyle, "required");
                required = required.equals("") ? "false" : "true";
                column.put("required", (Object)required);
                String caseValue = this.getElementValue(editStyle, "case");
                column.put("case", (Object)caseValue);
                String mask = this.getElementValue(editStyle, "mask");
                column.put("mask", (Object)mask);
                String name = this.getElementValue(columnObject, "name");
                column.put("display_label", (Object)labelMap.get(name));
                String x = this.getElementValue(columnObject, "x");
                String y = this.getElementValue(columnObject, "y");
                String group = this.findGroup(x, y, groupArray);
                column.put("group", (Object)group);
                BaseLogger.log((String)"3", null, null, (Object)("Found groupbox name " + group));
                if (tableColumnObjectWithValue.containsKey(name)) {
                    column.put("initial", tableColumnObjectWithValue.get(name).get("initial"));
                    column.put("values", tableColumnObjectWithValue.get(name).get("values"));
                }
                columnArray.put((Object)column);
                ++i;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("column", (Object)columnArray);
            BaseLogger.log((String)"3", null, null, (Object)("column array=" + jsonObject.toString()));
            return columnArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", null, null, (Object)"Error in getting JSON");
            return new JSONArray();
        }
    }

    private String getElementValue(Element parentElement, String tagName) {
        NodeList nodeList = parentElement.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return "";
    }

    private String findGroup(String x, String y, JSONArray groupArray) {
        String groupName = "";
        try {
            int columnX = Integer.parseInt(x);
            int columnY = Integer.parseInt(y);
            int i = 0;
            while (i < groupArray.length()) {
                JSONObject groupBox = groupArray.getJSONObject(i);
                String name = groupBox.getString("name");
                int groupBoxX = groupBox.getInt("x");
                int groupBoxXMax = groupBox.getInt("x_max");
                int groupBoxY = groupBox.getInt("y");
                int groupBoxYMax = groupBox.getInt("y_max");
                if (columnX >= groupBoxX && columnX <= groupBoxXMax && columnY >= groupBoxY && columnY <= groupBoxYMax) {
                    groupName = name;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Error: " + e.getMessage()));
        }
        BaseLogger.log((String)"3", null, null, (Object)("Found Groups name " + groupName));
        return groupName;
    }

    Map<String, String> getLabelMap(NodeList textObjectList) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        int i = 0;
        while (i < textObjectList.getLength()) {
            Node node = textObjectList.item(i);
            if (node.getNodeType() == 1) {
                Element textObject = (Element)node;
                String name = this.getElementValue(textObject, "name");
                String text = this.getElementValue(textObject, "text");
                if (name != null && name.endsWith("_t")) {
                    name = name.substring(0, name.length() - 2);
                }
                if (name != null) {
                    labelMap.put(name, text);
                }
            }
            ++i;
        }
        return labelMap;
    }

    private JSONArray getGroupBoxArray(NodeList groupboxObjectList) {
        JSONArray gruopArray = new JSONArray();
        int i = 0;
        while (i < groupboxObjectList.getLength()) {
            Node node = groupboxObjectList.item(i);
            if (node.getNodeType() == 1) {
                Element textObject = (Element)node;
                String name = this.getElementValue(textObject, "text");
                String x = this.getElementValue(textObject, "x");
                String y = this.getElementValue(textObject, "y");
                String height = this.getElementValue(textObject, "height");
                String width = this.getElementValue(textObject, "width");
                try {
                    int xVal = Integer.parseInt(x);
                    int heightVal = Integer.parseInt(height);
                    int yVal = Integer.parseInt(y);
                    int widthVal = Integer.parseInt(width);
                    JSONObject group = new JSONObject();
                    group.put("x", xVal);
                    group.put("height", heightVal);
                    group.put("x_max", xVal + widthVal);
                    group.put("name", (Object)name);
                    group.put("y", yVal);
                    group.put("y_max", yVal + heightVal);
                    group.put("width", widthVal);
                    gruopArray.put((Object)group);
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Error" + e.getMessage()));
                }
            }
            ++i;
        }
        return gruopArray;
    }

    private Map<String, JSONObject> getValueTableColumn(NodeList tableColumnList) {
        HashMap<String, JSONObject> elementMap = new HashMap<String, JSONObject>();
        try {
            int i = 0;
            while (i < tableColumnList.getLength()) {
                Element tableColumnElement;
                NodeList valuesList;
                Node node = tableColumnList.item(i);
                if (node.getNodeType() == 1 && (valuesList = (tableColumnElement = (Element)node).getElementsByTagName("values")).getLength() > 0) {
                    String columnName = this.getElementValue(tableColumnElement, "name");
                    String initial = this.getElementValue(tableColumnElement, "initial");
                    Element valuesElement = (Element)valuesList.item(0);
                    NodeList itemList = valuesElement.getElementsByTagName("item");
                    JSONArray valueArray = new JSONArray();
                    int j = 0;
                    while (j < itemList.getLength()) {
                        Element itemElement = (Element)itemList.item(j);
                        String displayValue = itemElement.getAttribute("display");
                        String dataValue = itemElement.getAttribute("data");
                        JSONObject item = new JSONObject();
                        item.put("display", (Object)displayValue);
                        item.put("data", (Object)dataValue);
                        valueArray.put((Object)item);
                        ++j;
                    }
                    JSONObject values = new JSONObject();
                    values.put("values", (Object)valueArray);
                    values.put("initial", (Object)initial);
                    elementMap.put(columnName, values);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elementMap;
    }

    public String getTokenFromHeaders(HttpHeaders headers) {
        BaseLogger.log((String)"0", null, null, (Object)"Getting header info: ");
        String tokenId = null;
        List tokenIdList = headers.getRequestHeader("TOKEN_ID");
        if (tokenIdList != null && !tokenIdList.isEmpty()) {
            BaseLogger.log((String)"0", null, null, (Object)("GOt token list item=" + tokenIdList));
            tokenId = (String)tokenIdList.get(0);
        }
        return tokenId;
    }

    public JSONArray getFormalArgs(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlString.getBytes()));
            JSONArray formalArgsArray = new JSONArray();
            NodeList formalArgsList = doc.getElementsByTagName("FORMALARGS");
            if (formalArgsList.getLength() > 0) {
                Element formalArgs = (Element)formalArgsList.item(0);
                NodeList formalArgList = formalArgs.getElementsByTagName("FORMALARG");
                int xValue = 10;
                int yValue = 10;
                int tabSeq = 10;
                int i = 0;
                while (i < formalArgList.getLength()) {
                    Element formalArg = (Element)formalArgList.item(i);
                    String fieldName = formalArg.getAttribute("field_name");
                    String name = formalArg.getAttribute("name");
                    String javaType = formalArg.getAttribute("javatype");
                    String value = this.getElementValue(formalArg, "value");
                    JSONObject formaArgsObj = new JSONObject();
                    formaArgsObj.put("display_label", (Object)name);
                    formaArgsObj.put("group", (Object)"");
                    formaArgsObj.put("value", (Object)value);
                    formaArgsObj.put("alignment", (Object)"");
                    formaArgsObj.put("tabsequence", (Object)String.valueOf(tabSeq));
                    formaArgsObj.put("x", (Object)String.valueOf(xValue));
                    formaArgsObj.put("y", (Object)String.valueOf(yValue));
                    formaArgsObj.put("height", (Object)"16");
                    formaArgsObj.put("width", (Object)"66");
                    formaArgsObj.put("format", (Object)("[" + javaType + "]"));
                    formaArgsObj.put("name", (Object)fieldName);
                    formaArgsObj.put("tag", (Object)"");
                    formaArgsObj.put("visible", (Object)"1");
                    formaArgsObj.put("edit_style", (Object)"edit");
                    formaArgsObj.put("limit", (Object)"");
                    formaArgsObj.put("case", (Object)"");
                    formaArgsObj.put("mask", (Object)"");
                    yValue += 10;
                    tabSeq += 10;
                    formalArgsArray.put((Object)formaArgsObj);
                    ++i;
                }
                BaseLogger.log((String)"3", null, null, (Object)("getFormalArgs formalArgsArray=" + formalArgsArray.toString()));
                return formalArgsArray;
            }
            return new JSONArray();
        }
        catch (Exception e) {
            return new JSONArray();
        }
    }

    private String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues, UserInfoBean userInfo) throws RemoteException, ITMException {
        String resultString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(userInfo);
                resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log((String)"0", null, null, (Object)("NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage()));
                throw new ITMException((Exception)e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log((String)"0", null, null, (Object)("ITMException : getInitialContext : " + itme.getMessage()));
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getInitialContext : " + e.getMessage()));
            throw new ITMException(e);
        }
        return ctx;
    }
}

