
// Coding By Vidhya Prabhu on 10-12-09

package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.utility.CommonConstants;
import java.net.InetAddress;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class StrgSerStatusHist implements  StrgSerStatusHistRemote,StrgSerStatusHistLocal
{
	protected static String database = CommonConstants.DB_NAME;

	//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]
	//public String setDrStatusHistory(String salesPers, String strgCode, String custType, String routeId, String itemSer, String status,  String xtraParams, String editFlag, Connection conn) throws RemoteException,ITMException
	public String setDrStatusHistory(String salesPers, String strgCode, String custType, String routeId, String itemSer, String status, String effectiveDate, String dbEffDate, String xtraParams, String editFlag, Connection conn) throws RemoteException,ITMException
	{
		String effFrom = "";
		String validUpto = "";
		String errCode = "";
		String checkSQL = "";
		String insertQuery = "";
		String chgTerm = "";
		String userId = "";
		//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]Start
		String effDtDbfmt="";
		String validUptodt="";
		//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]end

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		PreparedStatement pStmt = null;
		try
		{
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( userId == null || userId.trim().length() == 0 )
			{
				userId = "SYSTEM";
			}
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			if( chgTerm == null || chgTerm.trim().length() == 0 )
			{
				chgTerm = "SYSTEM";
			}

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar cal = Calendar.getInstance();

			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]Start
			//String date =  genericUtility.getValidDateTimeString( cal.getTime(), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			//cal.add( Calendar.YEAR , 10 );
			//String validUptodt = genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

			String date =  genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

			if ( effectiveDate != null || effectiveDate.trim().length() >0 )
			{
				effDtDbfmt =  genericUtility.getValidDateTimeString( effectiveDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
				cal.setTime( sdf.parse(effectiveDate) );
				cal.add( Calendar.YEAR , 10 );
				validUptodt = genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			}
			else
			{
				effDtDbfmt =  genericUtility.getValidDateTimeString( sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
				cal.add( Calendar.YEAR , 10 );
				validUptodt = genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			}
			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]End


			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ] Start
			//errCode = updDrStatusHistory(salesPers, strgCode, custType, routeId, itemSer, status,  xtraParams, editFlag, conn);
			 if ( ( dbEffDate != null ) && (dbEffDate.trim().length() > 0 ))
			 {

				errCode = updDrStatusHistory( salesPers, strgCode, custType, routeId, itemSer, status, effectiveDate, dbEffDate, xtraParams, editFlag, conn);
			 }
            //Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ] .end

			if ( !editFlag.equalsIgnoreCase("D"))
			{
				String tranId = generateTransID( conn, userId ) ;
				if (tranId == null || tranId.trim().length() == 0)
				{
					errCode = "VTTRANID";
				}
				else
				{
					System.out.println("Inserting status history......");
					insertQuery ="INSERT INTO STRG_STATUS_HIST(TRAN_ID, TRAN_DATE, SALES_PERS, SC_CODE, CUST_TYPE, ITEM_SER, ROUTE_ID, EFF_FROM , VALID_UPTO, STATUS, CHG_DATE , CHG_USER, CHG_TERM, EDITFLAG) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
					pStmt = conn.prepareStatement(insertQuery);
					pStmt.setString(1, tranId);
					pStmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
					pStmt.setString(3, salesPers);
					pStmt.setString(4, strgCode);
					pStmt.setString(5, custType);
					pStmt.setString(6, itemSer);
					pStmt.setString(7, routeId);
					pStmt.setTimestamp(8, java.sql.Timestamp.valueOf( effDtDbfmt ));
					pStmt.setTimestamp(9, java.sql.Timestamp.valueOf(validUptodt));
					pStmt.setString(10, status);
					pStmt.setTimestamp(11, java.sql.Timestamp.valueOf( date ));
					pStmt.setString(12, userId);
					pStmt.setString(13, chgTerm);
					pStmt.setString(14, editFlag);
					int updtCnt = pStmt.executeUpdate();

					System.out.println(updtCnt +" Records Inserted !!!!");
					pStmt.close();
					pStmt = null;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgSerStatusHistBean : :==>\n"+e.getMessage());
			errCode = "SEREXCPERR";
		}
		finally
		{
			try
			{
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}


			}
			catch( Exception e)
			{
				System.out.println("Exception :StrgSerStatusHistBean : :==>\n"+e.getMessage());
				errCode = "SEREXCPERR";
			}
		}
		System.out.println("Return errCode :["+errCode+"]");
		return errCode;
	}

	//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]
	//public String updDrStatusHistory(String salesPers, String strgCode, String custType, String routeId, String itemSer, String status,  String xtraParams, String editFlag, Connection conn) throws ITMException
	public String updDrStatusHistory(String salesPers, String strgCode, String custType, String routeId, String itemSer, String status, String effectiveDate, String dbEffDateStr, String xtraParams, String editFlag, Connection conn) throws ITMException
	{
		String errCode = "";
		String updateSQL = "";
		//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]
		String effDtDbfmt="";

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		PreparedStatement pStmt = null;
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar cal = Calendar.getInstance();

			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ] Start
			//String date =  genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			java.util.Date dbEffDate = genericUtility.getDateObject( dbEffDateStr );
			java.util.Date curDate= new java.util.Date();

			if ((curDate.compareTo(dbEffDate)) > 0)
			{
				 effDtDbfmt =  genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			}
			else
			{
				 effDtDbfmt =  genericUtility.getValidDateTimeString( sdf.format( sdf.parse( dbEffDateStr )) , genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			}

			cal.setTime( sdf.parse( effectiveDate ) );
			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]End
			cal.add( Calendar.DATE , -1 );
			String validUptoExp = genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			System.out.println("expired to ["+validUptoExp+"] ");

			updateSQL = "UPDATE STRG_STATUS_HIST SET VALID_UPTO = ?, EDITFLAG = ? WHERE SALES_PERS = ? AND SC_CODE = ? AND CUST_TYPE = ? AND ITEM_SER = ? AND ROUTE_ID = ? AND EFF_FROM <= ? AND VALID_UPTO >= ?";
			pStmt = conn.prepareStatement(updateSQL);
			pStmt.setTimestamp(1, java.sql.Timestamp.valueOf( validUptoExp ));
			pStmt.setString(2, editFlag);
			pStmt.setString(3, salesPers);
			pStmt.setString(4, strgCode);
			pStmt.setString(5, custType);
			pStmt.setString(6, itemSer);
			pStmt.setString(7, routeId);
			pStmt.setTimestamp(8,  java.sql.Timestamp.valueOf(effDtDbfmt));
			pStmt.setTimestamp(9,  java.sql.Timestamp.valueOf(effDtDbfmt));
			int updtCnt = pStmt.executeUpdate();
			System.out.println(updtCnt+" Records updated !!!");

		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgSerStatusHistBean : :==>\n"+e.getMessage());
			errCode = "SEREXCPERR";
		}
		finally
		{
			try
			{
				if( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch( Exception e)
			{
				System.out.println("Exception :StrgSerStatusHistBean : :==>\n"+e.getMessage());
				errCode = "SEREXCPERR";
			}
		}
		System.out.println("Return errCode update:["+errCode+"]");
		return errCode;

	}

	//to check if input is null or "null"
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	// to generate Tran_id
	private String generateTransID( Connection connection, String loginCode ) throws ITMException
	{
		String uniqueKey = null;
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		String tranSer = null;
		String keyString = null;
		String keyCol = null;
		String errCode = null;

		try
		{

			System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 't_strg_series_st' ";
			//Commented & Below Changes Done By Shahu Mali on 04-10-13
			//stmt = connection.createStatement();
			//rs = stmt.executeQuery( keyStringQuery );
			pstmt = connection.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
				TransIDGenerator tg = new TransIDGenerator("<Root></Root>", loginCode, database);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, connection);
			}
			rs.close();	rs = null;
			//stmt.close();stmt = null;
			pstmt.close();pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				/*
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				*/
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
}