package ibase.webitm.ejb.wsfa.transactions;
//component created by prachi for realtime reporting view mode [W22DJOH003]
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wsfa.WSFACommon;

public class RealTimeReportingView extends StrgMeetDCRWizard
{
	E12GenericUtility genericUtility = new E12GenericUtility(); 
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			System.out.println("xmlString prachi ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2:::::: ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams, formName);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: RealTimeReportEJB: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		String errString = "";
		String parentFormNo ="1";
		PreparedStatement pstmtActivity = null;
		ResultSet rsActivity = null; 
		ResultSet rs = null;
		ResultSet rSet = null;
		Connection connectionObject = null;
		
		PreparedStatement pstmt = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList parentList =null;
		NodeList childList= null;
		String childNodeName = "";
		int parentNodeListLength =0;
		int noOfChilds = 0;
		int ctr = 0;
		ResultSet stpRs = null;
		String empCodeHO="";
		String stpStatus="";
		String usrTypeLogin = "";
		
		try
		{
			int currentFormNo = 0;
			String columnValue = "";
			connectionObject = getConnection();
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			userId = getEmpCode(userId, connectionObject);
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			DARCommonBean darCommonBean= new DARCommonBean();
			System.out.println("Inside wfvaldata formname::"+formName);
			if("doctor".equalsIgnoreCase(formName))
			{
				String updateFlag = ""; 
				String parmValue = "";
				String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
				pstmt = connectionObject.prepareStatement(sfaParmSql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					parmValue = checkNull(rs.getString("PARM_VALUE"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));  //added by mrunalini sinkar for member present
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);
				String dbName =CommonConstants.DB_NAME;
				
				String mgrCode = getMGREmployee(userId, connectionObject);
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						columnValue ="";
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						String actType = checkNull(genericUtility.getColumnValue( "activity_type" , dom2 ,objContext));
						String strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
						String cusType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
						childNodeName = childNode.getNodeName();
						
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						else if(childNodeName.equalsIgnoreCase("sales_person"))
						{
							String salesPerson = childNode.getFirstChild().getNodeValue();
							String sql="SELECT COUNT(*) AS COUNT FROM SALES_PERS  WHERE SALES_PERS IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE =? CONNECT BY PRIOR EMP_CODE = REPORT_TO ) and sales_pers=?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1,userId);
							pstmt.setString(2,salesPerson);
							int count=0;
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								count = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(count<1)
							{
								errString = itmDBAccessLocal.getErrorString( "sales_person" , "INVSALESPR" , userId );
								break;
							}	
						}
						else if(childNodeName.equalsIgnoreCase("oth_participant"))
						{
							//System.out.println("oth_participant remark");
							if(columnValue != null && columnValue.length() >120)
							{
								errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
								break;
							}
						}
						else if("FW".equalsIgnoreCase(actType))
						{
							if(!"LISTED".equalsIgnoreCase(strgType) && !isMemberPresnt.equalsIgnoreCase("Y")) //Added by mrunalini sinkar for member presnt
							{
								String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, objContext));
								String custName = checkNull(genericUtility.getColumnValue("strg_name", dom2, objContext));
								String routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));

								String addressAs = checkNull(genericUtility.getColumnValue("address_as", dom2, objContext));								
							
								if( locCode.trim().length() != 0 && custName.trim().length() != 0)//W22BGOC003 routetype M condition removed by prachi
								{

									if(childNodeName.equalsIgnoreCase("addr1") && addressAs.trim().length() != 0)
									{
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//System.out.println( "addr1 cannot be null:" +childNodeName);
											errString = itmDBAccessLocal.getErrorString( "addr1" , "NULLADDR" , userId );
											break;
										}
									}
									else if ( "mobile_no".equalsIgnoreCase(childNodeName))
									{
										//System.out.println("INSIDE mobile_no-.......>"+childNodeName);
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString( "mobile_no" , "NULPHONNO" , userId );
											break;
										}
										else
										{
											String phoneNo = checkNull(genericUtility.getColumnValue("mobile_no", dom2, objContext));
											phoneNo = (phoneNo == null) ?"":phoneNo.trim();
											//System.out.println("phone::::["+phoneNo+"]");
											if(phoneNo == null || phoneNo.trim().length() <= 0)
											{
												errString = itmDBAccessLocal.getErrorString( "mobile_no","NULPHONENO",userId );
												break;
											}
											else if(phoneNo.length() < 10 || phoneNo.length() > 10 || phoneNo.startsWith("0"))
											{
												//System.out.println("Invalid PHONE no.....");
												errString = itmDBAccessLocal.getErrorString("mobile_no","INVDPHNLNO",userId);
												break;
											}

										}
									}
									else if ( "email_addr".equalsIgnoreCase(childNodeName))
									{
										//System.out.println("INSIDE email_addr-.......>"+childNodeName);
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											
										}
										else
										{
											String emailAddr = checkNull(genericUtility.getColumnValue("email_addr", dom2, objContext));
											//System.out.println("email_addr ::::["+emailAddr+"]");
											boolean isEmail = true;
											String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
											if(emailAddr != null )
											{
												isEmail = emailAddr.matches(ePattern);
												if(!(isEmail))
												{
													errString = itmDBAccessLocal.getErrorString("email_addr","INVDEMAILD",userId);
													break;
												}
											}
										}
									}
									
									else if(childNodeName.equalsIgnoreCase("address_as"))
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString( "address_as" , "NULLADDAS" , userId );
											break;
										}
									}
									
									//Added by prachi on 26/04/2022 [ W22AGOC002 ] start
									else if(childNodeName.equalsIgnoreCase("strg_class_code"))
									{
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom2, objContext));

										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
											break;
										}
										else
										{
											int count = 0;
											String codeSql = "";
											String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
											String vistedWithTeam = checkNull((genericUtility.getColumnValue("visited_with_team", dom2, objContext)));

											String salesPerson="";
											if(mgrCode.trim().length()== 0)
											{
												salesPerson= userId;
											}
											else
											{
												salesPerson=vistedWithTeam;
											}
											String itemSer = checkNull(getItemSer(salesPerson,connectionObject));
											
											int classCount = getCountFromSerClass(itemSer,classCode,connectionObject); // added by mrunalini sinkar for class code pophelp on 31-jan-2019(start)
											if(classCount==0)
											{
												codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
												pstmt = connectionObject.prepareStatement(codeSql);
												pstmt.setString(1,custType);
												pstmt.setString(2,classCode);
												rs = pstmt.executeQuery();
												if(rs.next())
												{
													count = rs.getInt("COUNT");
												}
												if (rs != null)
												{
													rs.close();
													rs = null;
												}
												if (pstmt != null)
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
													break;
												}
											}


											
										}
									}
									else if(childNodeName.equalsIgnoreCase("subclass_code"))
									{
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											
										}
										else
										{
											int count = 0;
											String codeSql = "";
											String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code", dom2, objContext));
											String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom2, objContext));
											String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
											//System.out.println("classCode =["+classCode+"], custType = ["+custType+"]");
											codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_SUBCLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ? AND SUBCLASS_CODE = ? ";
											pstmt = connectionObject.prepareStatement(codeSql);
											pstmt.setString(1,custType);
											pstmt.setString(2,classCode);
											pstmt.setString(3,subClassCode);
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												count = rs.getInt("COUNT");
											}
											if (rs != null)
											{
												rs.close();
												rs = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("subclass_code","INVSUBCLS",userId);
												break;
											}
										}
									}
									
									else if ( "qualification".equalsIgnoreCase(childNodeName))
									{
										String qualification = checkNull(genericUtility.getColumnValue("qualification", dom2, objContext));
										String custType = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
										int cnt=0;
										if(custType=="UNLISTED-DOCTOR")
									    {
											if(qualification == null || qualification.trim().length() == 0)
											{
												errString = itmDBAccessLocal.getErrorString("qualification","QULINULL",userId);
												break;
											}
									    }
										if(qualification.trim().length()>0)
										{
											String sql2 = "SELECT COUNT(*) AS COUNT FROM QUALIFICATION WHERE QLF_CODE=?";
											pstmt = connectionObject.prepareStatement(sql2);
											pstmt.setString(1,qualification.trim());
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												cnt = rs.getInt("COUNT");
											}
											if (rs != null)
											{
												rs.close();
												rs = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(cnt == 0)
											{
												errString = itmDBAccessLocal.getErrorString("qualification","QULIINVLD",userId);
												break;
											}

										}	
									}
									//Added by prachi on 26/04/2022 [ W22AGOC002 ] end

									
									
									else if(childNodeName.equalsIgnoreCase("spl_code") && (strgType.equalsIgnoreCase("LISTED") || (!strgType.equalsIgnoreCase("LISTED") && !isMemberPresnt.equalsIgnoreCase("Y") )))
									{
										String routeTyp = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));

										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											if("D".equalsIgnoreCase(cusType))
											{
												errString = itmDBAccessLocal.getErrorString( "spl_code" , "NULLSPL" , userId );
												break;
											}
										}
										else
										{
											String splCode = checkNull(genericUtility.getColumnValue("spl_code", dom2, objContext));
											String splCodeSql = "";
											int cnt = 0;

											splCodeSql = "SELECT COUNT(*) AS COUNT FROM SPECIALITY WHERE SPL_CODE = ?";
											pstmt = connectionObject.prepareStatement(splCodeSql);
											pstmt.setString(1, splCode);
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												cnt = rs.getInt("COUNT");
											}
											if (rs != null)
											{
												rs.close();
												rs = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(cnt == 0)
											{
												errString = itmDBAccessLocal.getErrorString( "spl_code" , "SPLNOTPRE" , userId );
												break;
											}
										}
									}
									
								
								}
							}	
						}
						else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmValue) && (strgType.equalsIgnoreCase("LISTED") || (!strgType.equalsIgnoreCase("LISTED") && !isMemberPresnt.equalsIgnoreCase("Y"))))
						{
							if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println( "stockist code cannot be null:" +childNodeName);
								errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
								break;
							}
							else
							{
								String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom2, objContext)));
								int count = 0;
								String stockCodeSql = "";
								if(stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
								{
									stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE= ? AND CUST_TYPE = 'S'";
								}
								else
								{
									stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
								}
								pstmt = connectionObject.prepareStatement(stockCodeSql);
								pstmt.setString(1,stockCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								//System.out.println("count =["+count+"]");
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									//System.out.println("INVALID STOCK CODE::");
									errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("visited_with") && mgrCode.trim().length()== 0 )
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								int index ;
								String reportToSql = "";
								ArrayList teamList = new ArrayList();
								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom2 , objContext);
								//System.out.println("in visited_with salesPers:::: "+salesPers);
								if(dbName.equalsIgnoreCase("DB2"))
								{
									reportToSql ="select DISTINCT REPORT_TO from employee where fn_emp_hierarcy_up(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
								}
								else if(dbName.equalsIgnoreCase("ORACLE"))
								{
									reportToSql ="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
								}
								// added by rupali on 13/04/18 for org_structure related changes [start]
								String eventDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,objContext));
								String isOrgStrcture = getSfaParmValue(salesPers,"HIERARCY_FRM_ORG_STR",connectionObject);
								if("Y".equalsIgnoreCase(isOrgStrcture)) 
								{
									OrgStructure orgStructure = new OrgStructure();
									teamList = orgStructure.reportToUp(salesPers,eventDate,connectionObject);
								}
								if(teamList == null || teamList.isEmpty() || dbName.equalsIgnoreCase("DB2")) // added by rupali on 13/04/18 for org_structure related changes
								{
									pstmt = connectionObject.prepareStatement(reportToSql);
									pstmt.setString(1, salesPers);
									rSet =pstmt.executeQuery();
									while(rSet.next())
									{
										String teamMember = checkNull(rSet.getString("REPORT_TO"));
										teamList.add(teamMember);
									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
								}
								String visitedWith = checkNull(genericUtility.getColumnValue( "visited_with", dom2 ));
								String visitedWithCode = checkNull(genericUtility.getColumnValue( "visited_with_code", dom2 ));
								if( visitedWith.indexOf("(") != -1 && visitedWith.indexOf(")") != -1 )
								{
									String[] temp = visitedWith.split( "," );
									for ( int i = 0; i < temp.length; i++ )
									{
										String visitTeam = temp[i];
										if( visitTeam.indexOf("(") != -1 && visitTeam.indexOf(")") != -1 )
										{
											String selTeam = checkNull(visitTeam.substring(visitTeam.indexOf("(")+1, visitTeam.indexOf(")")));
											if(!teamList.contains(selTeam))
											{
												
												String division=getItemSer(userId, connectionObject);
												int rolCnt=0;
												String sql2="SELECT COUNT(*) AS CNT FROM EMPLOYEE EMP, GRADE G " + 
														"WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
														"WHERE ORG_UNIT=? CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE AND EMP.EMP_CODE=? ";
												pstmt = connectionObject.prepareStatement(sql2);
												pstmt.setString(1, division);
												pstmt.setString(2, selTeam);

												rSet =pstmt.executeQuery();
												if(rSet.next())
												{
													rolCnt=rSet.getInt("CNT");
												}
												if (rSet!= null)
												{
													rSet.close();
													rSet = null;
												}
												if(pstmt!=null)
												{
													pstmt.close();
													pstmt = null;
												}
												if(rolCnt==0)
												{
													errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
													return errString;
												}
												
												
												
												

											}
										}
										else
										{
											errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
											return errString;
										}
									}
								} 
								else
								{
									if( ! teamList.contains( visitedWithCode.trim() )  &&  ! teamList.contains( visitedWith.trim() ))
									{
										errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
										return errString;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("visited_with") && mgrCode.trim().length() != 0)
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println( "visited_with_team cannot be null:" );
								errString = itmDBAccessLocal.getErrorString( "visited_with" , "NULLTEAM" , userId );
								break;
							}
							else
							{
								int index ;
								String reportToSql = "";
								ArrayList teamList = new ArrayList();
								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom2 , objContext);
								//System.out.println("in visited_with salesPers:::: "+salesPers);
								if(dbName.equalsIgnoreCase("DB2"))
								{
									reportToSql ="select DISTINCT EMP_CODE AS SALES_TEAM from employee where fn_emp_hierarcy_dn(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
								}
								else if(dbName.equalsIgnoreCase("ORACLE"))
								{
									reportToSql ="SELECT EMP_CODE AS SALES_TEAM FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL ";
								}
								String eventDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,objContext));
								String resignEmp = checkNull(genericUtility.getColumnValue( "resign_emp" , dom2 ,objContext));
								String isOrgStrcture = getSfaParmValue(salesPers,"HIERARCY_FRM_ORG_STR",connectionObject);
								if("Y".equalsIgnoreCase(isOrgStrcture))
								{
									OrgStructure orgStructure = new OrgStructure();
									teamList = orgStructure.reportToDown(salesPers,eventDate,resignEmp,connectionObject);
								}

								if(teamList == null || teamList.isEmpty() || dbName.equalsIgnoreCase("DB2"))
								{
									pstmt = connectionObject.prepareStatement(reportToSql);
									pstmt.setString(1, salesPers);
									rSet =pstmt.executeQuery();
									while(rSet.next())
									{
										String teamMember = checkNull(rSet.getString("SALES_TEAM"));
										teamList.add(teamMember);
									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
								}
								String visitedWith = checkNull(genericUtility.getColumnValue( "visited_with", dom2 ));
								String visitedWithCode = checkNull(genericUtility.getColumnValue( "visited_with_code", dom2 ));
								if( visitedWith.indexOf("(") != -1 && visitedWith.indexOf(")") != -1 )
								{
									String [] temp = visitedWith.split( "," );
									for( int i = 0; i < temp.length; i++ )
									{
										String visitTeam = temp[i];
										if(visitTeam.indexOf("(") != -1 && visitTeam.indexOf(")") != -1)
										{
											String selTeam = checkNull(visitTeam.substring( visitTeam.indexOf("(")+1, visitTeam.indexOf(")") ) );
											if( ! teamList.contains( selTeam ) )
											{
												String division=getItemSer(userId, connectionObject);
												int rolCnt=0;
												String sql2="SELECT COUNT(*) AS CNT FROM EMPLOYEE EMP, GRADE G " + 
														"WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
														"WHERE ORG_UNIT=? CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE AND EMP.EMP_CODE=? ";
												pstmt = connectionObject.prepareStatement(sql2);
												pstmt.setString(1, division);
												pstmt.setString(2, selTeam);

												rSet =pstmt.executeQuery();
												if(rSet.next())
												{
													rolCnt=rSet.getInt("CNT");
												}
												if (rSet!= null)
												{
													rSet.close();
													rSet = null;
												}
												if(pstmt!=null)
												{
													pstmt.close();
													pstmt = null;
												}
												if(rolCnt==0)
												{
													errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALTEAM", userId );
													return errString;
												}
											}
										}
										else if(!"SELF".equalsIgnoreCase(visitedWith))
										{
											errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALTEAM", userId );
											return errString;
										}
									}
								}
								else
								{
									//Changed by Pooja S on [9-JAN-2020] - if visited_with without (emp_code) then pass code 
									if( ! "SELF".equalsIgnoreCase(visitedWith) && ! teamList.contains( visitedWithCode.trim() ) )
									{
										errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALTEAM", userId );
										return errString;
									}
								}
							}
						}
					}
					
				}
			}	
				
				
			else if("survey".equalsIgnoreCase(formName))
			{

				String surveyDescr = "", surveyCode = "";
				ArrayList surveyList = new ArrayList();
				ArrayList custTypeList = new ArrayList();
				String minRange = "" ;
	            String maxRange = "" ;
	            String result1 = "";
                String result3 = "";

				
				String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2));
				String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2));
				String strgType = checkNull(genericUtility.getColumnValue("strg_type", dom2));
				String surveyTemplate=checkNull(genericUtility.getColumnValue("survey_templ", dom2));
				String activityTempl=checkNull(genericUtility.getColumnValue("activity_templ", dom2));
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectBox = "";
					String updateFlag = "";
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						if(childNodeName.equalsIgnoreCase("strg_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString( "strg_code" , "NULSTRGCD" , userId );
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("survey_code"))
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVCD",userId);
								break;
							}
							else
							{
								surveyCode = checkNull(genericUtility.getColumnValueFromNode("survey_code", parentNode));
								surveyDescr = checkNull(genericUtility.getColumnValueFromNode("strgType", parentNode));
								surveyList.add(surveyCode);
							}
													}
						else if(childNodeName.equalsIgnoreCase("result1") || childNodeName.equalsIgnoreCase("result2") || childNodeName.equalsIgnoreCase("result3"))
						{
							String resultType = genericUtility.getColumnValueFromNode("result_type", parentNode);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if((childNodeName.equalsIgnoreCase("result1") && (resultType.equalsIgnoreCase("N"))) || (childNodeName.equalsIgnoreCase("result3") && (resultType.equalsIgnoreCase("T")))
										|| (childNodeName.equalsIgnoreCase("result2") && (resultType.equalsIgnoreCase("D") || resultType.equalsIgnoreCase("L"))))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVRES",userId);
									break;
								}
							}
							else
                            {
                                result1 = genericUtility.getColumnValueFromNode("result1", parentNode);
                                result3 = genericUtility.getColumnValueFromNode("result3", parentNode);
                            }
						}
						else if(childNodeName.equalsIgnoreCase("doc_id_2"))
						{
							String attachOPT = checkNull(genericUtility.getColumnValueFromNode("attach_opt", parentNode));
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if("1".equalsIgnoreCase(attachOPT))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULLATTACH",userId);
									break;
									
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("result_range_min"))
                        {
                            minRange = checkNull(genericUtility.getColumnValueFromNode("result_range_min", parentNode)); 

                       
                        }
                        else if(childNodeName.equalsIgnoreCase("result_range_max"))
                        {
                            maxRange = checkNull(genericUtility.getColumnValueFromNode("result_range_max", parentNode)); 
                           
                        }
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
					try
                    {
                    int minRangeValue = 0;
                    int maxRangeValue = 0;
                    if( !minRange.equals("") || !maxRange.equals("")) 
                    {
                        minRangeValue = Integer.parseInt(minRange);
                        maxRangeValue = Integer.parseInt(maxRange);
                    }


                    if(  maxRangeValue > 0 || minRangeValue > 0 )
		                {
		                    if( minRangeValue > 0 )
		                    {
		                       
		                            if(result1 != null && result1.length() > 0)
		                            {
		                                if(minRangeValue > result1.length())
		                                {
		                                   
                                            errString = itmDBAccessLocal.getErrorString("result_range_min","MINLENGTH",userId);
									        break;
		                                }
		                            }
		                            if(result3 != null && result3.length() > 0)
		                            {
		                                if(minRangeValue > result3.length())
		                                {
		                                    errString = itmDBAccessLocal.getErrorString("result_range_min","MINLENGTH",userId);
									        break;
		                                }
		                            }		
                            }
                            if( maxRangeValue > 0 )
		                    {
		                       
		                            if(result1 != null && result1.length() > 0)
		                            {
		                                if( maxRangeValue < result1.length())
		                                {
		                                 	
                                          errString = itmDBAccessLocal.getErrorString("result_range_max","MAXLENGTH",userId);
									        break;                                 
		                                }
		                            }
		                            if(result3 != null && result3.length() > 0)
		                            {
		                                if( maxRangeValue < result3.length())
		                                {
		                                  
                                           errString = itmDBAccessLocal.getErrorString("result_range_max","MAXLENGTH",userId);
									        break;                                  
		                                }
		                            }		
		                    }
					    }

                    }
                    catch(Exception e)
                    {
                        System.out.println(e);
                    }
				}
				if(errString == null ||  errString.trim().length() == 0)
				{
					custTypeList=getTemplateSurvey(connectionObject, userId);
					if(custTypeList.contains(strgType)  && parentNodeListLength > 0)
					{
							String surveySql = "SELECT B.SURVEY_CODE SURVEY_CODE, C.DESCR SURVEY_DESCR,C.MANDATORY FROM SURVEY_TEMPLATE A, SURVEY_TEMPL_DET B, SURVEY_MASTER C, SURVEY_GROUP G " + 
							           "WHERE A.SURVEY_TEMPL = B.SURVEY_TEMPL AND C.SURVEY_GROUP = G.SURVEY_GROUP AND A.SURVEY_TEMPL IN(SELECT SURVEY_TEMPL FROM SURVEY_TEMPLATE " + 
							           "WHERE SURVEY_TEMPL = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO AND CONFIRMED ='Y') AND B.SURVEY_CODE = C.SURVEY_CODE " + 
							           "AND C.ACTIVE='Y' AND C.MANDATORY = 'Y'";
							
							PreparedStatement pstmtSurvey =  connectionObject.prepareStatement(surveySql);
							if( eventType.equalsIgnoreCase("MI")  || eventType.equalsIgnoreCase("OT"))
							{
								pstmtSurvey.setString(1,activityTempl);
							}
							else
							{
							pstmtSurvey.setString(1,surveyTemplate);
							}
							pstmtSurvey.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
							ResultSet rsSurvey = pstmtSurvey.executeQuery();
							while (rsSurvey.next())
							{
								surveyCode = checkNull(rsSurvey.getString("SURVEY_CODE"));
								surveyDescr = checkNull(rsSurvey.getString("SURVEY_DESCR"));
								if(!surveyList.contains(surveyCode))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","SURVENTSEL",userId);
									break;
								}
							}
							if (rsSurvey != null)
							{
								rsSurvey.close();
								rsSurvey = null;
							}
							if (pstmtSurvey != null)
							{
								pstmtSurvey.close();
								pstmtSurvey = null;
							}
							if(errString != null && errString.trim().length() > 0)
							{
								errString = getModifiedErrorString(errString, surveyDescr);
							}
						}
				}
			
			}
			else if("coaching".equalsIgnoreCase(formName))
			{
				String surveyDescr = "", surveyCode = "";
				ArrayList surveyList = new ArrayList();
				ArrayList custTypeList = new ArrayList();
				
				String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2));
				String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2));
				String strgType = checkNull(genericUtility.getColumnValue("strg_type", dom2));
				String surveyTemplate=checkNull(genericUtility.getColumnValue("survey_templ", dom2));
				String activityTempl=checkNull(genericUtility.getColumnValue("activity_templ", dom2));
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectBox = "";
					String updateFlag = "";
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						if(childNodeName.equalsIgnoreCase("strg_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString( "strg_code" , "NULSTRGCD" , userId );
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("survey_code"))
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVCD",userId);
								break;
							}
							else
							{
								surveyCode = checkNull(genericUtility.getColumnValueFromNode("survey_code", parentNode));
								surveyDescr = checkNull(genericUtility.getColumnValueFromNode("strgType", parentNode));
								surveyList.add(surveyCode);
							}
						}
						else if(childNodeName.equalsIgnoreCase("result1") || childNodeName.equalsIgnoreCase("result2") || childNodeName.equalsIgnoreCase("result3"))
						{
							String resultType = genericUtility.getColumnValueFromNode("result_type", parentNode);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if((childNodeName.equalsIgnoreCase("result1") && (resultType.equalsIgnoreCase("N"))) || (childNodeName.equalsIgnoreCase("result3") && (resultType.equalsIgnoreCase("T")))
										|| (childNodeName.equalsIgnoreCase("result2") && (resultType.equalsIgnoreCase("D") || resultType.equalsIgnoreCase("L"))))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVRES",userId);
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("doc_id_2"))
						{
							String attachOPT = checkNull(genericUtility.getColumnValueFromNode("attach_opt", parentNode));
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if("1".equalsIgnoreCase(attachOPT))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULLATTACH",userId);
									break;
									
								}
							}
						}
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				if(errString == null ||  errString.trim().length() == 0)
				{
					custTypeList=getTemplateSurvey(connectionObject, userId);
					if(custTypeList.contains(strgType)  && parentNodeListLength > 0)
					{
							String surveySql = "SELECT B.SURVEY_CODE SURVEY_CODE, C.DESCR SURVEY_DESCR,C.MANDATORY FROM SURVEY_TEMPLATE A, SURVEY_TEMPL_DET B, SURVEY_MASTER C, SURVEY_GROUP G " + 
							           "WHERE A.SURVEY_TEMPL = B.SURVEY_TEMPL AND C.SURVEY_GROUP = G.SURVEY_GROUP AND A.SURVEY_TEMPL IN(SELECT SURVEY_TEMPL FROM SURVEY_TEMPLATE " + 
							           "WHERE SURVEY_TEMPL = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO AND CONFIRMED ='Y') AND B.SURVEY_CODE = C.SURVEY_CODE " + 
							           "AND C.ACTIVE='Y' AND C.MANDATORY = 'Y'";
							PreparedStatement pstmtSurvey =  connectionObject.prepareStatement(surveySql);
							if( eventType.equalsIgnoreCase("MI")  || eventType.equalsIgnoreCase("OT"))
							{
								pstmtSurvey.setString(1,activityTempl);
							}
							else
							{
							pstmtSurvey.setString(1,surveyTemplate);
							}
							pstmtSurvey.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
							ResultSet rsSurvey = pstmtSurvey.executeQuery();
							while (rsSurvey.next())
							{
								surveyCode = checkNull(rsSurvey.getString("SURVEY_CODE"));
								surveyDescr = checkNull(rsSurvey.getString("SURVEY_DESCR"));
								if(!surveyList.contains(surveyCode))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","SURVENTSEL",userId);
									break;
								}
							}
							if (rsSurvey != null)
							{
								rsSurvey.close();
								rsSurvey = null;
							}
							if (pstmtSurvey != null)
							{
								pstmtSurvey.close();
								pstmtSurvey = null;
							}
							if(errString != null && errString.trim().length() > 0)
							{
								errString = getModifiedErrorString(errString, surveyDescr);
							}
						}
				}
				
			}
			else if("team".equalsIgnoreCase(formName))
			{
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{

					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
								{
									break;
								}
							}
						}
						else if ( "member_name".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("Memeber_name inside is null");
								String memType = checkNull(genericUtility.getColumnValueFromNode("member_type", currDetail)).trim();
								if(memType.equalsIgnoreCase("R") ||memType.equalsIgnoreCase("O"))
								{
									errString = itmDBAccessLocal.getErrorString("member_name","NULMNAME",userId);
									break;
								}
								
							}
						}
						else if( "team_mobile_no".equalsIgnoreCase( childNodeName ) )
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								String mobileNo = checkNull(genericUtility.getColumnValueFromNode("team_mobile_no", currDetail)).trim();
								if(mobileNo.length() < 10 || mobileNo.length() > 15)
								{
									errString = itmDBAccessLocal.getErrorString("team_mobile_no","INVMOBLNO",userId);
									break;
								}
							}
						}
						
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				
				}
			}
			
			else if("collection".equalsIgnoreCase(formName))
			{
				System.out.println("Collection form Validation");
                
                errString = darCommonBean.collectionValidate(dom, currentFormNo, xtraParams, connectionObject);
            }	
			
			else if("sampleorder".equalsIgnoreCase(formName))
			{
				String salesPerson = checkNull(genericUtility.getColumnValue("sales_pers", dom2));
				String orderParam = checkNull(getSfaParmValue(salesPerson, "ORDER_QTY", connectionObject));
				String selectbox="";
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{

					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						if ( "selectbox".equalsIgnoreCase( childNodeName ) )
						{
							selectbox = childNode.getFirstChild().getNodeValue();
						}
						else if ( "quantity".equalsIgnoreCase( childNodeName ) )
						{
							    
							    String qty = checkNull(genericUtility.getColumnValueFromNode("quantity", currDetail)).trim();
								String remarks = checkNull(genericUtility.getColumnValueFromNode("remark_descr", currDetail)).trim();
								String stockQuan = checkNull(genericUtility.getColumnValueFromNode("stock_qty", currDetail)).trim();
								String minQuan = checkNull(genericUtility.getColumnValueFromNode("min_quantity", currDetail)).trim();
								String itemDescr = checkNull(genericUtility.getColumnValueFromNode("item_descr", currDetail)).trim();
								String selectboxCurr = checkNull(genericUtility.getColumnValueFromNode("selectbox", currDetail)).trim();
								 int minQuantity=0;
								
							if(selectboxCurr.equals("true"))
							{
								if((qty==null || qty.trim().length() == 0)&& orderParam.equals("Y"))
								{
									errString = itmDBAccessLocal.getErrorString("quantity","NULQUANTY",userId);
									if(errString != null && errString.trim().length() > 0)
									{
										errString = getModifiedErrorString(errString, itemDescr);
									}
									break;
								}
								
								if(qty!=null && qty.trim().length() >0)
								{
									int quantity = Integer.parseInt(qty);
									
									if(quantity<0)
									{
										errString = itmDBAccessLocal.getErrorString("quantity","INVQUATY",userId);
										if(errString != null && errString.trim().length() > 0)
										{
											errString = getModifiedErrorString(errString, itemDescr);
										}
										break;
									}
									if(quantity==0 && (remarks==null || remarks.trim().length() == 0))
									{
										errString = itmDBAccessLocal.getErrorString("quantity","QUANREMA",userId);
										if(errString != null && errString.trim().length() > 0)
										{
											errString = getModifiedErrorString(errString, itemDescr);
										}
										break;
									}
									if(minQuan!=null && minQuan.trim().length()>= 0)
									{	
									    minQuantity = Integer.parseInt(minQuan);
									}   
									
									if(quantity<minQuantity && (remarks==null || remarks.trim().length() == 0))
									{
										errString = itmDBAccessLocal.getErrorString("quantity","IVMINQUAN",userId);
										String err ="Item is "+itemDescr+" Minimum Quantity is "+minQuantity;
										if(errString != null && errString.trim().length() > 0)
										{
											errString = getModifiedErrorString(errString, err);
										}
										break;
									}
									/*
									if(isStockInfo.equals("Y"))
									{
										if(stockQuan ==null || stockQuan.trim().length() == 0)
										{
											errString = itmDBAccessLocal.getErrorString("quantity","INVALSTK",userId);
											if(errString != null && errString.trim().length() > 0)
											{
												errString = getModifiedErrorString(errString, itemDescr);
											}
											break;
										}
										else if(Integer.parseInt(stockQuan)<0)
										{
											errString = itmDBAccessLocal.getErrorString("quantity","INVALSTK",userId);
											if(errString != null && errString.trim().length() > 0)
											{
												errString = getModifiedErrorString(errString, itemDescr);
											}
											break;
										}
									}*/
									
								}
							}
						}
						else if( "rate".equalsIgnoreCase( childNodeName ) )
						{
							    String rate = checkNull(genericUtility.getColumnValueFromNode("rate", currDetail)).trim();
								String itemDescr = checkNull(genericUtility.getColumnValueFromNode("item_descr", currDetail)).trim();
								String selectboxCurr = checkNull(genericUtility.getColumnValueFromNode("selectbox", currDetail)).trim();
								
							if(selectboxCurr.equals("true"))
							{	
								if(rate ==null || rate.trim().length() == 0)
								{
									errString = itmDBAccessLocal.getErrorString("rate","NULRATE",userId);
									if(errString != null && errString.trim().length() > 0)
									{
										errString = getModifiedErrorString(errString, itemDescr);
									}
									break;
								}
								
								if(rate!=null && rate.trim().length()>0)
								{
									if(Double.parseDouble(rate)<0)
									{
										errString = itmDBAccessLocal.getErrorString("rate","INVRATE",userId);
										if(errString != null && errString.trim().length() > 0)
										{
											errString = getModifiedErrorString(errString, itemDescr);
										}
										break;
									}
								}
							}
						}
						/*
						else if( "disc_perc".equalsIgnoreCase( childNodeName ) )
						{
							    String discount = checkNull(genericUtility.getColumnValueFromNode("disc_perc", currDetail)).trim();
								String itemDescr = checkNull(genericUtility.getColumnValueFromNode("item_descr", currDetail)).trim();
								System.out.println("itemDescr =["+itemDescr+"]");
								
								if(discount!=null && discount.trim().length() > 0)
								{
									if(Double.parseDouble(discount)>100)
								    {
									  errString = itmDBAccessLocal.getErrorString("disc_perc","INVDISCO",userId);
									  if(errString != null && errString.trim().length() > 0)
										{
											errString = getModifiedErrorString(errString, itemDescr);
										}
									  break;
								    }
								}	
							
						}
						else if( "promo_perc".equalsIgnoreCase( childNodeName ) )
						{
							
								String promoPerc = checkNull(genericUtility.getColumnValueFromNode("promo_perc", currDetail)).trim();
								String itemDescr = checkNull(genericUtility.getColumnValueFromNode("item_descr", currDetail)).trim();
								System.out.println("itemDescr =["+itemDescr+"]");
								
								if(promoPerc !=null || promoPerc.trim().length()>0)
								{
									if(Double.parseDouble(promoPerc)>100)
								    {
									  errString = itmDBAccessLocal.getErrorString("promo_perc","INVPROPER",userId);
									  if(errString != null && errString.trim().length() > 0)
										{
											errString = getModifiedErrorString(errString, itemDescr);
										}
									  break;
								    }
								}	
						}*/
						
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				
				}
			
			}
			
			else if("invoice".equalsIgnoreCase(formName))
			{
				String salesPerson = checkNull(genericUtility.getColumnValue("sales_pers", dom2));
				String orderParam = checkNull(getSfaParmValue(salesPerson, "ORDER_QTY", connectionObject));
				
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength in team ["+parentNodeListLength+"]");
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{

					String selectedFlag = "";
					String updateFlag = "";
					String sampleDescr = "";
					Node currDetail = parentList.item(prntCtr);
					
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						else if ( "quantity".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
									break;
								
							}
							else
							{
								try
								{
									String quantity = genericUtility.getColumnValueFromNode("quantity", currDetail);
									int quan = Integer.parseInt(quantity);
									if( quan <= 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
								}
							}
						}
						else if ( "rate".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								errString = itmDBAccessLocal.getErrorString("rate","NULRATE",userId);
								break;
							}
							else
							{
								try
								{
									String rate = genericUtility.getColumnValueFromNode("rate", currDetail);
									int rateS = Integer.parseInt(rate);
									if( rateS <= 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("rate","INVLIDRATE",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
								}
							}
						}
						else if ( "curr_stock".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("dhdjkhsd stok quan");
								String currStock = genericUtility.getColumnValueFromNode("curr_stock", currDetail);
								//System.out.println("quantity stok quan["+quantity+"]");

								if(currStock == null && currStock.trim().length()<=0) 
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("curr_stock","NULLSTOCK",userId);
									break;
								}
								
							}
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									System.out.println("Inside Stock of Invoice val");
									String currStock = genericUtility.getColumnValueFromNode("curr_stock", currDetail);
									String quantity = genericUtility.getColumnValueFromNode("quantity", currDetail);
									
									int stock = Integer.parseInt(currStock);
									int quan = Integer.parseInt(quantity);
									System.out.println("Inside Stock stock::"+stock);
									System.out.println("Inside Stock quan::"+quan);
									if( stock < 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("curr_stock","INVLDSTOCK",userId);
										break;
									}
									else if(quan > stock)
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("curr_stock","LARGEQUAN ",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for stock");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("curr_stock","INVLDSTOCK",userId);
								}
							}
						}
						
						
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				
				}
			
			}
		}
		catch (Exception e)
		{
			System.out.println ( "Exception: real time reoprt: wfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if (rsActivity!= null)
				{
					rsActivity.close();
					rsActivity = null;
				}
				if(pstmtActivity!=null)
				{
					pstmtActivity.close();
					pstmtActivity = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :real Time report : wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);
	}
	
	public String defaultDataWiz(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("defaultDataWiz realtimeView xmlString:::: ["+xmlString+"]");
		System.out.println("defaultDataWiz realtimeView xmlString1::: ["+xmlString1+"]");
		System.out.println("defaultDataWiz realtimeView xmlString2::: ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = defaultDataWiz( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams, formName );
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :RealTimeReportEJB :defaultDataWiz(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		return errString;
	}
	
	public String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName ) throws RemoteException,ITMException
	{

		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
        ResultSet rs = null;
		ResultSet rs1 = null;
		
		String prvtranId ="";
		String tranId ="";
		String userId = "",empcode="";
		String columnValue = "";
		String editFlg = "";
		String spNameSql="",spName="",salesPerson="";
		String subSql = "";
		int currentFormNo = 0;
		
		StringBuffer valueXmlString = new StringBuffer();
		
		try
		{
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			empcode = userId;
			columnValue = genericUtility.getColumnValue( currentColumn, dom );
			//Added by Bhgayashri t for Summary of Call reporting status[start]
			DecimalFormat dFormatter = new DecimalFormat("#.##");
			DARCommonBean darCommonBean= new DARCommonBean();
			//Added by Bhgayashri t for Summary of Call reporting status[end]
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			String currDate = dtFormat.format( date );
			
			
			editFlg = checkNull(genericUtility.getColumnValue( "editFlag", dom )) ;
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlg).append("</editFlag>\r\n</Header>\r\n");
			
			if("doctor".equalsIgnoreCase(formName))
			{
				
					editFlg = checkNull(genericUtility.getColumnValue( "editFlag", dom )) ;
					
					/*
					 String eflag ="";
					if(editFlag!=null)
					{
						 System.out.println("e1 not null");
						if(editFlag.equalsIgnoreCase("E")) 
						{
						  System.out.println("e1 here");
						  tranId = genericUtility.getColumnValue( "tran_id", dom ) ;
						  System.out.println("inside e flag tran_id is:"+tranId);
						  eflag="E";
						}
					}
					else
					{}*/
					
				   prvtranId = checkNull(genericUtility.getColumnValue( "prv_tran_id", dom )) ;
				   String[] temp = prvtranId.split(":");
				   tranId = temp[0];
							
					
					spNameSql="SELECT SM.SALES_PERS AS SALES_PERS,SP.SP_NAME AS SP_NAME FROM STRG_MEET SM JOIN SALES_PERS SP ON SP.SALES_PERS = SM.SALES_PERS WHERE SM.TRAN_ID=?";
					pstmt =  conn.prepareStatement(spNameSql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						salesPerson = checkNull(rs.getString("SALES_PERS"));
						spName = checkNull(rs.getString("SP_NAME"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					String isMemberPresnt  = checkNull(getSfaParmValue(salesPerson,"HIDE_UNLIST_DET",conn)); 
					String displayTimeField  = checkNull(getSfaParmValue(salesPerson,"HIDE_EVENT_TIME_END",conn));
					String isFortuneActivity = checkNull(getSfaParmValue(salesPerson, "IS_FORTUNE_ACTIVITY", conn));
					String mgrCode = getMGREmployee(salesPerson, conn);
					
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					String doctorFormNo= checkNull(getFormNo(objName, "doctor", conn));
					String sampleOrder=checkNull(getFormNo(objName, "sampleorder", conn));
					String doctorTeam=checkNull(getFormNo(objName, "team", conn));
					String invoiceTeam=checkNull(getFormNo(objName, "invoice", conn));
					String collectionTeam=checkNull(getFormNo(objName, "collection", conn));

					if ((currentColumn.trim().equalsIgnoreCase("itm_default") && editFlg.equalsIgnoreCase("V")) || (currentColumn.trim().equalsIgnoreCase("itm_default") && editFlg.equalsIgnoreCase("E"))|| currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					{
						
						int cnt = 0;
						String empDesign = getDesignName(salesPerson, conn); 
						String grade = getGrade(salesPerson, conn);
						InetAddress ownIP=InetAddress.getLocalHost();
						String chgTerm = ownIP.getHostAddress();
						
						String allowChgTime="";
						String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						pstmt =  conn.prepareStatement(ACTIVITYSql);
						pstmt.setString(1, salesPerson);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						
						String stanCodeHQ="",headQaurter="";
						String hqSql="SELECT EMP.STAN_CODE__HQ AS STAN_CODE__HQ,ST.DESCR AS HEADQAURTER FROM EMPLOYEE EMP,STATION ST WHERE EMP.EMP_CODE=? AND EMP.STAN_CODE__HQ=ST.STAN_CODE";
						pstmt =  conn.prepareStatement(hqSql);
						pstmt.setString(1, salesPerson);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							stanCodeHQ = checkNull(rs.getString("STAN_CODE__HQ"));
							headQaurter = checkNull(rs.getString("HEADQAURTER"));
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						int count=0;
						String isPrExist = "N";

						String countPrSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.SALES_PERS = ? AND A.EVENT_DATE = ? AND B.ACTIVITY_TYPE='PR'";
						PreparedStatement prPstmt = conn.prepareStatement(countPrSql);
						prPstmt.setString(1,salesPerson);
						prPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						ResultSet prRs = prPstmt.executeQuery();
						if(prRs.next())
						{
							count = prRs.getInt("COUNT");
						}
						if(prRs != null)
						{
							prRs.close();
							prRs = null;
						}
						if(prPstmt != null)
						{
							prPstmt.close();
							prPstmt = null;
						}
						if(count > 0)
						{
							isPrExist = "Y";
						}
						if(tranId != null && tranId != "" && tranId.trim().length() != 0)
						{
							SimpleDateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
							SimpleDateFormat dbDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
							//Added by Bhagyashri T for CGST AND SGST[START]
							String totCgst ="";
							String totCgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTCGST FROM DUAL";
							pstmt = conn.prepareStatement( totCgstSql );
							pstmt.setString(1, "CGST");
							ResultSet rset = pstmt.executeQuery();
							if ( rset.next() )
							{
								totCgst = checkNull( rset.getString( "TOTCGST" ) );
							}
							if (rset !=null )
							{
								rset.close();
								rset = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							String totSgst="";
							String totSgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTSGST FROM DUAL";
							pstmt = conn.prepareStatement( totSgstSql );
							pstmt.setString(1, "SGST");
							rset = pstmt.executeQuery();
							if ( rset.next() )
							{
								totSgst = checkNull( rset.getString( "TOTSGST" ) );
							}
							if (rset !=null )
							{
								rset.close();
								rset = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							//Added by Bhagyashri T for CGST AND SGST[END]
							String editSql = "SELECT SM.*,SCS.SUBCLASS_DESCR,S.DESCR AS SPECIALITY_DESCR,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) AS LOCALITY_DESCR,ST.DESCR AS STATION_DESCR  "
									+ "FROM SPRS_ROUTE SR,STATION ST,STRG_MEET SM "+
									  "LEFT OUTER JOIN SPECIALITY S ON SM.SPL_CODE = S.SPL_CODE "
									+ "LEFT OUTER JOIN STRG_CUST_SUBCLASS SCS ON SM.STRG_TYPE = SCS.CUST_TYPE AND SM.STRG_CLASS_CODE= SCS.CLASS_CODE AND SM.SUBCLASS_CODE= SCS.SUBCLASS_CODE "
									+ "WHERE TRAN_ID = ? AND  SM.LOCALITY_CODE = SR.LOCALITY_CODE AND SR.ROUTE_ID=SM.ROUTE_ID AND SR.SPRS_CODE=SM.SALES_PERS AND ST.STAN_CODE=SR.STAN_CODE";

							pstmt =  conn.prepareStatement(editSql);
							pstmt.setString(1, tranId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								Date planDate=null;
								String showDate="";
								String actType = "";
								String actDescr = "";
								String stockistCode = "";
								String stockistName = "";
								String placeRequired="";
								String visitedwithTeam = ""; 
								String call_outcome_descr ="";
								currDate = rs.getString("EVENT_DATE");
								Date evntDate = dbFormat.parse(currDate);
								currDate = dtFormat.format(evntDate);
								String eventType = checkNull(rs.getString("EVENT_TYPE"));
								String classCode = checkNull(rs.getString("STRG_CLASS_CODE"));
								String cusType = checkNull(rs.getString("STRG_TYPE"));
								String strgCode = checkNull(rs.getString("STRG_CODE"));
								String copyPlan = checkNull(rs.getString("COPY_PLAN"));
								String callOutcome = checkNull(rs.getString("CALL_OUTCOME")); 
								String sprsCodeWW = checkNull(rs.getString("SPRS_CODE__WW"));
								String nextPlanDate=checkNull(rs.getString("NEXT_PLAN_DATE"));
								String pricels = checkNull(rs.getString("PRICE_LIST"));
								String strgType1 =  checkNull(rs.getString("STRG_TYPE")) ;
								String localityCode =  checkNull(rs.getString("LOCALITY_CODE")) ;
								String salesType =  checkNull(rs.getString("SALES_TYPE")) ;
								String totalamount =  checkNull(rs.getString("AMOUNT")) ;
								String taxAmount =  checkNull(rs.getString("TAX_AMOUNT")) ;
								String netAmount = checkNull(rs.getString("NET_AMT")) ;
								double amt =0d,totamt =0d,invamt =0d,invoiceAmount =0d,sgstamt =0d,sgstAmt =0d,rndOff =0d;
								String invoicAmount ="",sgstAmount ="",cgstAmount ="",roundOff ="",amtInWord="";
								if(totalamount!=null && totalamount.trim().length()>0)
								{
								  amt=Double.parseDouble(totalamount);
								  invoiceAmount=Math.round(amt);
								  invoicAmount=Double.toString(invoiceAmount);
								  invoicAmount=invoicAmount.replaceAll("\\.\\d+$", "");
								}
								if(invoicAmount!=null && invoicAmount.trim().length()>0 && totalamount!=null && totalamount.trim().length()>0)
								{
								  totamt=Double.parseDouble(totalamount);
								  invamt=Double.parseDouble(invoicAmount);
								  //System.out.println("inside the  totamt::::::["+totamt+"]");
								 // System.out.println("inside the invamt::::::["+invamt+"]");
								  rndOff=(invamt-totamt);
								  //System.out.println("inside rndOff11::::::["+rndOff+"]");
								  roundOff=dFormatter.format(rndOff);
								  //System.out.println("inside the after Format an ::::::["+roundOff+"]");
								  invoicAmount.replaceAll("\\.\\d+$", "");
								  //System.out.println("inside rounded in an::::::["+invoicAmount+"]");
								  long lngAmt=Long.parseLong(invoicAmount);
								 // System.out.println("inside the sql lngAmt::::::["+lngAmt+"]");
								  amtInWord = darCommonBean.convert(lngAmt);
								  //System.out.println("inside the Convert string to long and string AMT::::::["+amtInWord+"]");
								}
								if(taxAmount!=null && taxAmount.trim().length()>0)
								{
									sgstamt=Double.parseDouble(taxAmount);
									sgstAmt=(sgstamt/2);
									sgstAmount=Double.toString(sgstAmt);
									cgstAmount =sgstAmount;
								}
								 //Added by Bhgayashri t for Summary of Call reporting status[start]
				                String  strgState="";
				                String strgGstNo="";
			                    String strgCdsql = "SELECT ST.DESCR AS STRG_STATE,SC.GST_NO AS STRG_GST_NO FROM STRG_CUSTOMER SC,STATE ST WHERE TRIM(SC.SC_CODE)=TRIM(?) AND SC.STATE_CODE=ST.STATE_CODE";
			        			pstmt = conn.prepareStatement(strgCdsql);
			        			pstmt.setString(1, strgCode);
			        			ResultSet rSet = pstmt.executeQuery();
			        			if(rSet.next())
			        			{
			        				strgState = checkNull(rSet.getString("STRG_STATE"));
			        				strgGstNo = checkNull(rSet.getString("STRG_GST_NO"));
			        			}
			        			if(rSet!=null)
			        			{
			        				rSet.close();
			        				rSet=null;
			        			}
			        			if(pstmt!=null)
			        			{
			        				pstmt.close();
			        				pstmt = null;

			        			}
			        			//Added by Bhgayashri t for Summary of Call reporting status[end]
			        			//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (start)
			        			String eventDateDBFmt="";
			        			if(currDate != null && currDate.length() > 0) 
			        			{
			        				eventDateDBFmt = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			        			}
								String loadNo="",vehicleNo="";
								String daySummSql="SELECT SDA.LOAD_NO AS LOAD_NO,SDA.VEH_NO AS VEHICLE_NO FROM SPRS_DAY_SUMM SDA WHERE TRIM(SDA.SALES_PERS)=TRIM(?) AND SDA.EVENT_DATE=?";
								PreparedStatement pstmtS = conn.prepareStatement(daySummSql);
								pstmtS.setString(1, salesPerson);
								pstmtS.setTimestamp(2, java.sql.Timestamp.valueOf(eventDateDBFmt));
								ResultSet rSe  = pstmtS.executeQuery();
								if(rSe.next())
								{
									loadNo = checkNull(rSe.getString("LOAD_NO"));
									vehicleNo = checkNull(rSe.getString("VEHICLE_NO"));
								}
								if (rSe!= null)
								{
									rSe.close();
									rSe = null;
								}
								if(pstmtS!=null)
								{
									pstmtS.close();
									pstmtS = null;
								}

								//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (end)
								if(nextPlanDate!=null && nextPlanDate.trim().length()>0)
								{
									planDate=dbFormat.parse(nextPlanDate);
									showDate=applFormat.format(planDate);
								}
								
								if(callOutcome.equalsIgnoreCase("0"))
								{
									call_outcome_descr="Refused";
								}
								else if(callOutcome.equalsIgnoreCase("7"))
								{
									call_outcome_descr="Non Believer";
								}
								else if(callOutcome.equalsIgnoreCase("5"))
								{
									call_outcome_descr="Supporter";
								}
								else if(callOutcome.equalsIgnoreCase("6"))
								{
									call_outcome_descr="Believer";
								}
								String classCodeDescr = getClassCodeDesc(classCode,cusType,sprsCodeWW,conn);
								//String templateId=checkNull(getTemplateIdForUnlisted(salesPerson, cusType, conn));
								String actSql  = "SELECT DESCR, ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt1 = conn.prepareStatement(actSql);
								pstmt1.setString(1, eventType);
								rs1 = pstmt1.executeQuery();
								if(rs1.next())
								{
									actDescr = checkNull(rs1.getString("DESCR"));
									actType = checkNull(rs1.getString("ACTIVITY_TYPE"));
									placeRequired = checkNull(rs1.getString("PLACE_REQUIRED"));
								}
								if( rs1 !=null )
								{
									rs1.close();
									rs1 = null;
								}
								if( pstmt1 !=null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								String stockSql = "SELECT SMO.STOCKIST_CODE AS STOCKIST_CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS STOCKIST_NAME, DCR_ID "+
										"FROM STRG_MEET_ORDER SMO, STRG_CUSTOMER SC WHERE SMO.TRAN_ID = ? AND SC.SC_CODE = SMO.STOCKIST_CODE";
								pstmt1 =  conn.prepareStatement(stockSql);
								pstmt1.setString(1, tranId);
								rs1 = pstmt1.executeQuery();
								if(rs1.next())
								{
									stockistCode = checkNull(rs1.getString("STOCKIST_CODE"));
									stockistName = checkNull(rs1.getString("STOCKIST_NAME"));
								}
								if (rs1!= null)
								{
									rs1.close();
									rs1 = null;
								}
								if(pstmt1!=null)
								{
									pstmt1.close();
									pstmt1 = null;
								}
								String workWith = "";
								String teamDetail = getExistingTeam(userId,currDate,tranId,conn);
								if(teamDetail.length() > 0)
								{
									//System.out.println("Inside teamDeatils");
									workWith = getWorkWithList(teamDetail,"1");
								}
								//System.out.println("workWith :: ["+workWith+"]");

								String custSql  = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE = ?";
								pstmt1 = conn.prepareStatement(custSql);
								pstmt1.setString(1, strgCode);
								rs1 = pstmt1.executeQuery();
								if(rs1.next())
								{
									cnt = rs1.getInt("COUNT");
								}
								if( rs1 !=null )
								{
									rs1.close();
									rs1 = null;
								}
								if( pstmt1 !=null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								// added by rupali on 03/05/18 for single screen mgr reporting [start]
								custSql = "SELECT EMP_CODE AS TEAM, (CASE WHEN DDF_GET_EMPLOYEE_NAME(EMP_CODE) ||' (' || LTRIM(RTRIM(EMP_CODE)) || ') ' LIKE '%("+salesPerson+")%' THEN 'SELF' "+
										"ELSE DDF_GET_EMPLOYEE_NAME(EMP_CODE) ||' (' || LTRIM(RTRIM(EMP_CODE)) || ') ' END) AS VISITED_WITH FROM EMPLOYEE WHERE EMP_CODE = ?";
								pstmt1 = conn.prepareStatement(custSql);
								pstmt1.setString(1, sprsCodeWW);
								rs1 = pstmt1.executeQuery();
								if(rs1.next())
								{
									visitedwithTeam = rs1.getString("VISITED_WITH");
								}
								if( rs1 !=null )
								{
									rs1.close();
									rs1 = null;
								}
								if( pstmt1 !=null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								
								String qualifSql  = "select DESCR from qualification where qlf_code = ? ";
								pstmt1 = conn.prepareStatement(qualifSql);
								pstmt1.setString(1, checkNull(rs.getString("QUALIFICATION")));
								rs1 = pstmt1.executeQuery();
								String qualDescr="";
								if(rs1.next())
								{
									qualDescr = rs1.getString("DESCR");
								}
								if( rs1 !=null )
								{
									rs1.close();
									rs1 = null;
								}
								if( pstmt1 !=null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								
								String active="",parmVal="",formNo="";
								String subFormsql="SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_SUBFORM_PROTECT'";
								PreparedStatement subFormPstmt =conn.prepareStatement(subFormsql);
								ResultSet subFormRs = subFormPstmt.executeQuery();
								if(subFormRs.next())
								{
									active=checkNull(subFormRs.getString("ACTIVE"));
									parmVal=checkNull(subFormRs.getString("PARM_VALUE"));
								}
								if(subFormRs != null)
								{
									subFormRs.close();
									subFormRs = null;
								}
								if(subFormPstmt != null)
								{
									subFormPstmt.close();
									subFormPstmt = null;
								}
								if(active.equalsIgnoreCase("Y"))
								{

									String subFormName = "";
									String [] subForm = parmVal.split(",");
									for(int i = 0 ;i < subForm.length;i++)
									{
										if(subFormName == null || subFormName.trim().length() == 0)
										{
											subFormName = subForm[i];
										}
										else
										{
											subFormName = subFormName + "','" + subForm[i];
										}
									}
									subFormName = "'" + subFormName + "'";

									
									String objectName = getObjNameFromDom( dom, "objName" , 1);
									String objWinName = "w_"+objectName;
									String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN("+subFormName+") ";
									PreparedStatement objFormpstmt = conn.prepareStatement(objFormSql);
									objFormpstmt.setString(1, objWinName);
									ResultSet objFormrs = objFormpstmt.executeQuery();
									while(objFormrs.next())
									{
										String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
										if(formNo == null || formNo.trim().length() == 0)
										{
											formNo = objFormNo;
										}
										else
										{
											formNo = formNo + "," + objFormNo;
										}
									}
									if(objFormrs != null)
									{
										objFormrs.close();
										objFormrs = null;
									}
									if(objFormpstmt != null)
									{
										objFormpstmt.close();
										objFormpstmt = null;
									}
								}
								String templateId="";
								templateId= checkNull(rs.getString("SURVEY_TEMPL")) ;
								if(templateId.trim().length()==0)
								{	
								  templateId = checkNull(getTemplateIdForUnlisted(salesPerson, cusType, conn));
								} 
								valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"' selected = 'Y'>\r\n" );
								
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
								valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
								valueXmlString.append( "<event_date protect = '1'><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
								valueXmlString.append("<survey_templ>").append(templateId).append("</survey_templ>\r\n");
								valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
								valueXmlString.append( "<grade_code><![CDATA[" ).append( grade ).append( "]]></grade_code>\r\n" );
								valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TYPE")) ).append( "]]></event_type>\r\n" );
								valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append( actDescr ).append( "]]></activity_descr>\r\n" );
								valueXmlString.append( "<activity_type><![CDATA[" ).append( actType ).append( "]]></activity_type>\r\n" );
								valueXmlString.append( "<place_required><![CDATA[" ).append( placeRequired ).append( "]]></place_required>\r\n" );	// added by mrunalini sinkar on 09-sep-2018 for place required changes(start)
								valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
								valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
								valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(salesPerson).append( "]]></sales_pers>\r\n" );
								valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );
								valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
								valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
								valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_TYPE")) ).append( "]]></strg_type>\r\n" );
								valueXmlString.append( "<locality_code protect = '1'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );
								valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_DESCR")) ).append( "]]></locality_descr>\r\n" );
								valueXmlString.append( "<wf_status><![CDATA[" ).append( checkNull(rs.getString("WF_STATUS")) ).append( "]]></wf_status>\r\n" );
								valueXmlString.append( "<confirmed><![CDATA[" ).append( checkNull(rs.getString("CONFIRMED")) ).append( "]]></confirmed>\r\n" );
								valueXmlString.append( "<route_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("ROUTE_ID")) ).append( "]]></route_id>\r\n" ); // added by mrunalini sinka for route_id changes on 30-04-2019
								valueXmlString.append( "<station_type><![CDATA[" ).append( checkNull(rs.getString("STATION_TYPE")) ).append( "]]></station_type>\r\n" );//added by mrunalini sinka for route_id changes on 30-04-2019
								valueXmlString.append( "<station_descr><![CDATA[" ).append( checkNull(rs.getString("STATION_DESCR")) ).append( "]]></station_descr>\r\n" ); // added by mrunalini sinka for showing STATION_DESCR changes on 20-05-2019
								valueXmlString.append("<is_member_present><![CDATA[" ).append(checkNull(isMemberPresnt)).append( "]]></is_member_present>\r\n" );
								valueXmlString.append( "<gst_no visible = '0'><![CDATA[" ).append( strgGstNo).append( "]]></gst_no>\r\n" );
								valueXmlString.append( "<strg_gst_no><![CDATA[" ).append( strgGstNo).append( "]]></strg_gst_no>\r\n" ); 
								valueXmlString.append( "<strg_state><![CDATA[" ).append( strgState).append( "]]></strg_state>\r\n" );
								valueXmlString.append( "<sales_type><![CDATA[" ).append( salesType).append( "]]></sales_type>\r\n" );
								valueXmlString.append( "<amount><![CDATA[" ).append(totalamount).append( "]]></amount>\r\n" ); 
								valueXmlString.append( "<net_amt><![CDATA[" ).append( checkNull(rs.getString("NET_AMT")) ).append( "]]></net_amt>\r\n" ); 
								valueXmlString.append( "<tax_amount><![CDATA[" ).append( taxAmount ).append( "]]></tax_amount>\r\n" );
								valueXmlString.append("<basic_value><![CDATA[" ).append( "Basic:" + netAmount ).append( "]]></basic_value>\r\n" );
								valueXmlString.append("<total_gst><![CDATA[" ).append( "GST:" + taxAmount).append( "]]></total_gst>\r\n" );
								valueXmlString.append("<total_value><![CDATA[" ).append( "Total Amount:" + totalamount ).append( "]]></total_value>\r\n" );
								//Added by Bhagyashri T for details showing on summary
								valueXmlString.append( "<load_no><![CDATA[" ).append(loadNo).append( "]]></load_no>\r\n" );
								valueXmlString.append( "<vehicle_no><![CDATA[" ).append(vehicleNo).append( "]]></vehicle_no>\r\n" ); 
								valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
								valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
								valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
								valueXmlString.append( "<total_cgst><![CDATA[" ).append(totCgst).append( "]]></total_cgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
								valueXmlString.append( "<total_sgst><![CDATA[" ).append(totSgst).append( "]]></total_sgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
								valueXmlString.append( "<round_off><![CDATA[" ).append( roundOff).append( "]]></round_off>\r\n" );
								valueXmlString.append( "<amount_in_word><![CDATA[" ).append( amtInWord).append( "]]></amount_in_word>\r\n" );
								
								valueXmlString.append( "<price_list><![CDATA[" ).append( checkNull(rs.getString("PRICE_LIST")) ).append( "]]></price_list>\r\n" );
								valueXmlString.append( "<sku_value><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")) ).append( "]]></sku_value>\r\n" ); 
								valueXmlString.append( "<ev_flag><![CDATA[" ).append( checkNull(editFlg) ).append( "]]></ev_flag>\r\n" );
								
								String planChang  = "select descr as PLAN_DESCR from gencodes where mod_name='W_STRG_MEET_DCR_REALTIME_WIZ' AND fld_name='BEAT_CHG_REASON' and fld_value=? ";
								pstmt1 = conn.prepareStatement(planChang);
								pstmt1.setString(1, checkNull(rs.getString("PLAN_CHG_REAS")) );
								rs1 = pstmt1.executeQuery();
								String planChngVal="";
								if(rs1.next())
								{
									planChngVal = rs1.getString("PLAN_DESCR");
								}
								if( rs1 !=null )
								{
									rs1.close();
									rs1 = null;
								}
								if( pstmt1 !=null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								valueXmlString.append( "<plan_chg_reas protect='1'><![CDATA[" ).append(planChngVal).append( "]]></plan_chg_reas>\r\n" );
								
								
								valueXmlString.append( "<cust_conf visible = '0'><![CDATA[" ).append( checkNull(rs.getString("CUST_CONF")) ).append( "]]></cust_conf>\r\n" );
								valueXmlString.append( "<cust_conf_t visible = '0'><![CDATA[]]></cust_conf_t>\r\n" );
								valueXmlString.append( "<pob_item visible = '0'><![CDATA[" ).append( checkNull(rs.getString("POB_ITEM")) ).append( "]]></pob_item>\r\n" );
								valueXmlString.append( "<cust_conf_proof visible = '0'><![CDATA[" ).append( checkNull(rs.getString("CUST_CONF_PROOF")) ).append( "]]></cust_conf_proof>\r\n" );
								valueXmlString.append( "<contact_pers visible = '0'><![CDATA[" ).append( checkNull(rs.getString("CONTACT_PERS")) ).append( "]]></contact_pers>\r\n" );
								valueXmlString.append( "<contact_pers_t visible = '0'><![CDATA[]]></contact_pers_t>\r\n" );
								valueXmlString.append( "<contact_pers_name visible = '0'><![CDATA[" ).append("").append( "]]></contact_pers_name>\r\n" );
								valueXmlString.append( "<beat_plan visible = '0'><![CDATA[" ).append("").append( "]]></beat_plan>\r\n" );
								valueXmlString.append( "<beat_plan_t visible = '0'><![CDATA[]]></beat_plan_t>\r\n" );
								valueXmlString.append( "<last_meet_date_t visible = '0'><![CDATA[]]></last_meet_date_t>\r\n" );
								System.out.println("Inside 2216 line");
								String lastDate = checkNull(rs.getString("LAST_MEET_DATE"));
								if(lastDate!=null && lastDate.trim().length()>0)
								{
									lastDate = dtFormat.format(dbFormat.parse(lastDate));
								}	
								valueXmlString.append( "<last_meet_date visible = '0'><![CDATA[" ).append(lastDate).append( "]]></last_meet_date>\r\n" );
								
								String confDate = checkNull(rs.getString("CONF_DATE"));
								if(confDate!=null && confDate.trim().length()>0)
								{
									confDate = dtFormat.format(dbFormat.parse(confDate));
								}	
								valueXmlString.append( "<conf_date visible = '0'><![CDATA[" ).append(confDate).append( "]]></conf_date>\r\n" );
								
								String syncDate = checkNull(rs.getString("SYNC_DATE"));
								if(syncDate!=null && syncDate.trim().length()>0)
								{
									syncDate = dtFormat.format(dbFormat.parse(syncDate));
								}	
								valueXmlString.append( "<sync_date visible = '0'><![CDATA[" ).append(syncDate).append( "]]></sync_date>\r\n" );
								System.out.println("after 2216 line");
								valueXmlString.append( "<copy_plan_t visible = '0'><![CDATA[]]></copy_plan_t>\r\n" );
								valueXmlString.append( "<copy_plan visible = '0'><![CDATA[" ).append( checkNull(rs.getString("COPY_PLAN")) ).append( "]]></copy_plan>\r\n" );
								valueXmlString.append( "<chg_geopos_t visible = '0'><![CDATA[]]></chg_geopos_t>\r\n" );
								valueXmlString.append( "<chg_geopos visible = '0'><![CDATA[" ).append( checkNull(rs.getString("CHG_GEOPOS")) ).append( "]]></chg_geopos>\r\n" );
								valueXmlString.append( "<add_geopos_t visible = '0'><![CDATA[]]></add_geopos_t>\r\n" );
								valueXmlString.append( "<add_geopos visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADD_GEOPOS")) ).append( "]]></add_geopos>\r\n" );
								valueXmlString.append( "<tag_geopos_t visible = '0'><![CDATA[]]></tag_geopos_t>\r\n" );
								valueXmlString.append( "<tag_geopos visible = '0'><![CDATA[" ).append( checkNull(rs.getString("TAG_GEOPOS")) ).append( "]]></tag_geopos>\r\n" );
								valueXmlString.append( "<geo_distance_t visible = '0'><![CDATA[]]></geo_distance_t>\r\n" );
								valueXmlString.append( "<geo_distance visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GEO_DISTANCE")) ).append( "]]></geo_distance>\r\n" );
								
								String itemSer = checkNull(getItemSer(salesPerson,conn));
								
								String custClasssql = " SELECT COUNT(*) AS COUNT FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
										" where  c.class_code= cs.class_code AND c.active_yn='Y'  AND CS.ITEM_SER = ?   ";
								pstmt1 = conn.prepareStatement(custClasssql);
								pstmt1.setString(1,itemSer);
								rs1 = pstmt1.executeQuery();
								int count1=0;
								if(rs1.next())
								{
									count  = rs1.getInt("COUNT");
								}
								if( rs1 !=null )
								{
									rs1.close();
									rs1 = null;
								}
								if( pstmt1 !=null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								if(count > 0)
								{
									valueXmlString.append( "<cust_class_input><![CDATA[" ).append(itemSer).append( "]]></cust_class_input>" );
								}
								else
								{
									valueXmlString.append( "<cust_class_input><![CDATA[" ).append(strgType1).append( "]]></cust_class_input>" );

								}
									
								if(mgrCode.trim().length()!= 0)
								{
									valueXmlString.append( "<grade_type><![CDATA[" ).append("M").append( "]]></grade_type>\r\n" );
									valueXmlString.append( "<view_to><![CDATA[" ).append("MGR").append( "]]></view_to>\r\n" );
									
									String resgnSql  = "select count(*) AS COUNT from employee where emp_code=? AND relieve_date IS NOT NULL";
									pstmt1 = conn.prepareStatement(resgnSql);
									pstmt1.setString(1, checkNull(rs.getString("SPRS_CODE__WW")));
									rs1 = pstmt1.executeQuery();
									int countVal=0;
									if(rs1.next())
									{
										countVal = rs1.getInt("COUNT");
									}
									if( rs1 !=null )
									{
										rs1.close();
										rs1 = null;
									}
									if( pstmt1 !=null )
									{
										pstmt1.close();
										pstmt1 = null;
									}
									if(countVal>0)
									{
										valueXmlString.append( "<resign_emp protect='1'><![CDATA[" ).append("Y").append( "]]></resign_emp>\r\n" );
									}
									else
									{
										valueXmlString.append( "<resign_emp protect='1'><![CDATA[" ).append("N").append( "]]></resign_emp>\r\n" );
									}
								}
								else
								{
									valueXmlString.append( "<grade_type><![CDATA[" ).append("").append( "]]></grade_type>\r\n" );
									valueXmlString.append( "<view_to><![CDATA[" ).append("PSR").append( "]]></view_to>\r\n" );
									valueXmlString.append( "<resign_emp visible='0' protect='1'><![CDATA[" ).append("N").append( "]]></resign_emp>\r\n" );
								}
								
								if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
								{
									valueXmlString.append( "<event_time_start protect = '1'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect = '1'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								
									valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								
								}
								else
								{
									
									valueXmlString.append( "<event_time_start visible = '0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end visible = '0'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );
									valueXmlString.append( "<last_meet_summ visible = '0'><![CDATA[").append( checkNull(rs.getString("LAST_MEET_SUMM")) ).append( "]]></last_meet_summ>\r\n" );
									valueXmlString.append( "<meeting_status visible = '0'><![CDATA[").append("").append( "]]></meeting_status>\r\n" );
								}
								valueXmlString.append( "<visit_time_from visible = '0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></visit_time_from>\r\n" );//added by shraddha M[20/07/2020]
								valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
								valueXmlString.append( "<strg_no_visit protect='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NO_VISIT")) ).append( "]]></strg_no_visit>\r\n" );
								valueXmlString.append("<member_present visible='0'><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT")) ).append( "]]></member_present>\r\n" ); 
								valueXmlString.append("<member_present_t visible='0'><![CDATA[]]></member_present_t>\r\n" ); 
								
								valueXmlString.append("<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT")) ).append( "]]></strg_no_visit>\r\n" ); 


								if(callOutcome.equalsIgnoreCase("0"))
								{
									valueXmlString.append( "<meet_summ protect='1' visible='0'><![CDATA[" ).append("---NA---").append( "]]></meet_summ>\r\n" );
								}
								else
								{
									if(editFlg.equalsIgnoreCase("V"))
									{	
									  valueXmlString.append( "<meet_summ protect='1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("MEET_SUMM")) ).append( "]]></meet_summ>\r\n" );
									}
									else if(editFlg.equalsIgnoreCase("E"))
									{
										valueXmlString.append( "<meet_summ protect='0' visible='1'><![CDATA[" ).append( checkNull(rs.getString("MEET_SUMM")) ).append( "]]></meet_summ>\r\n" );
									}	
								}
								valueXmlString.append( "<subform_protect><![CDATA[" ).append(formNo).append( "]]></subform_protect>\r\n" );
								valueXmlString.append( "<short_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID")) ).append( "]]></short_id>\r\n" );
								valueXmlString.append( "<dcr_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("DCR_ID")) ).append( "]]></dcr_id>\r\n" );
								valueXmlString.append( "<pob_val protect='1'><![CDATA[" ).append( checkNull(rs.getString("POB_VAL")) ).append( "]]></pob_val>\r\n" );
								//valueXmlString.append( "<sku_value protect='1'><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")) ).append( "]]></sku_value>\r\n" );
								valueXmlString.append( "<add_geopos protect='1'><![CDATA[" ).append( checkNull(rs.getString("ADD_GEOPOS")) ).append( "]]></add_geopos>\r\n" );
								valueXmlString.append( "<chg_geopos protect='1'><![CDATA[" ).append( checkNull(rs.getString("CHG_GEOPOS")) ).append( "]]></chg_geopos>\r\n" );
								valueXmlString.append( "<geopos_accuracy protect='1'><![CDATA[" ).append( checkNull(rs.getString("GEOPOS_ACCURACY")) ).append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
								valueXmlString.append( "<geo_pos_name><![CDATA[" ).append( checkNull(rs.getString("GEO_POS_NAME")) ).append( "]]></geo_pos_name>\r\n" );
								valueXmlString.append( "<order_of_visit protect='1'><![CDATA[" ).append( checkNull(rs.getString("ORDER_OF_VISIT")) ).append( "]]></order_of_visit>\r\n" );
								valueXmlString.append( "<calloutcome_descr visible='1'><![CDATA[" ).append(call_outcome_descr ).append( "]]></calloutcome_descr>\r\n" );
								valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append(checkNull(getShDescr(cusType,conn))).append( "]]></sh_descr>\r\n" );
								valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append( checkNull(rs.getString("COPY_PLAN")) ).append( "]]></copy_plan>\r\n" );
								valueXmlString.append( "<visited_with_team><![CDATA[" ).append( checkNull(rs.getString("SPRS_CODE__WW")) ).append( "]]></visited_with_team>\r\n" );
								if(mgrCode.trim().length()!= 0)
								{
									valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append( checkNull(rs.getString("SPRS_CODE__WW")) ).append( "]]></sprs_code__ww>\r\n" );
									valueXmlString.append( "<visited_with protect = '1'><![CDATA[" ).append( visitedwithTeam ).append( "]]></visited_with>\r\n" );
								}
								else
								{
									valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append( checkNull(rs.getString("SPRS_CODE__WW")) ).append( "]]></sprs_code__ww>\r\n" );
									valueXmlString.append( "<visited_with protect = '1'><![CDATA[" ).append( teamDetail ).append( "]]></visited_with>\r\n" );
								}
								
								if(cnt > 0)
								{
									valueXmlString.append( "<strg_code protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
									valueXmlString.append( "<stockist_name protect = '1' visible='1'><![CDATA[" ).append( stockistName ).append( "]]></stockist_name>\r\n" );
									valueXmlString.append( "<call_outcome protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
									
									if(editFlg.equals("E"))
									{	
										valueXmlString.append( "<oth_participant visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
										valueXmlString.append( "<stockist_code visible='1'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );
										valueXmlString.append( "<remarks visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
									}
									else if(editFlg.equals("V"))
									{	
										valueXmlString.append( "<oth_participant protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
										valueXmlString.append( "<stockist_code protect = '1' visible='1'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );
										valueXmlString.append( "<remarks protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
									}
									valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append( "LISTED" ).append( "]]></cust_type>\r\n" );
									valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
									valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
									valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
									valueXmlString.append( "<address_as protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
									valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
									valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
									valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );
									valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
									valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
									valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
									valueXmlString.append( "<age protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
									valueXmlString.append( "<qualification protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
									valueXmlString.append( "<qualification_descr protect = '1' visible = '0'><![CDATA[" ).append(qualDescr).append( "]]></qualification_descr>\r\n" );
									
									valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
									valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append( classCodeDescr ).append( "]]></class_code_descr>\r\n" );
									valueXmlString.append( "<subclass_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_CODE")) ).append( "]]></subclass_code>\r\n" );
									valueXmlString.append( "<subclass_descr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_DESCR")) ).append( "]]></subclass_descr>\r\n" );
									
									valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );
								
									valueXmlString.append( "<pin protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("PIN")) ).append( "]]></pin>\r\n" );
									valueXmlString.append( "<strg_event_info protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_EVENT_INFO")) ).append( "]]></strg_event_info>\r\n" );
									valueXmlString.append( "<promoter_name_t visible = '0'><![CDATA[]]></promoter_name_t>\r\n" );
									valueXmlString.append( "<promoter_name visible = '0'><![CDATA[" ).append( checkNull(rs.getString("PROMOTER_NAME")) ).append( "]]></promoter_name>\r\n" );
									valueXmlString.append( "<gst_no_t visible = '0'><![CDATA[]]></gst_no_t>\r\n" );
									//valueXmlString.append( "<gst_no visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GST_NO")) ).append( "]]></gst_no>\r\n" );
									valueXmlString.append( "<image_id_t visible = '0'><![CDATA[]]></image_id_t>\r\n" );
									valueXmlString.append( "<image_id visible = '0'><![CDATA[" ).append( checkNull(rs.getString("IMAGE_ID")) ).append( "]]></image_id>\r\n" );
									valueXmlString.append( "<reg_no_t visible = '0'><![CDATA[]]></reg_no_t>\r\n" );
									valueXmlString.append( "<reg_no visible = '0'><![CDATA[" ).append( checkNull(rs.getString("REG_NO")) ).append( "]]></reg_no>\r\n" );
									valueXmlString.append( "<man_power_t visible = '0'><![CDATA[]]></man_power_t>\r\n" );
									valueXmlString.append( "<man_power visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MAN_POWER")) ).append( "]]></man_power>\r\n" );
									
								}
								else
								{
									if(!isMemberPresnt.equalsIgnoreCase("Y"))
									{
									  if(editFlg.equals("E"))
									  {	
										valueXmlString.append( "<strg_code protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
										valueXmlString.append( "<call_outcome protect = '0' visible='1'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
										valueXmlString.append( "<oth_participant visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
										valueXmlString.append( "<remarks visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
										valueXmlString.append( "<stockist_name protect = '1' visible='1'><![CDATA[" ).append( stockistName ).append( "]]></stockist_name>\r\n" );
										valueXmlString.append( "<stockist_code visible='1'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );
										valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
										valueXmlString.append( "<email_addr visible = '1'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
										valueXmlString.append( "<mobile_no visible = '1'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
										valueXmlString.append( "<address_as visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
										valueXmlString.append( "<gender visible = '1'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
										valueXmlString.append( "<addr1 visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
										valueXmlString.append( "<addr2 visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
										valueXmlString.append( "<addr3 visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
										valueXmlString.append( "<age visible = '1'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
										valueXmlString.append( "<qualification visible = '1'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
										valueXmlString.append( "<qualification_descr protect = '1' visible = '1'><![CDATA[" ).append(qualDescr).append( "]]></qualification_descr>\r\n" );
										
										valueXmlString.append( "<strg_class_code visible = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
										valueXmlString.append( "<class_code_descr visible = '1'><![CDATA[" ).append( classCodeDescr ).append( "]]></class_code_descr>\r\n" );
										valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append(checkNull(getCustTypeDesc(cusType, conn))).append( "]]></cust_type>\r\n" );
										valueXmlString.append( "<spl_code visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );
										valueXmlString.append( "<pin visible = '1'><![CDATA[" ).append( checkNull(rs.getString("PIN")) ).append( "]]></pin>\r\n" );
										valueXmlString.append( "<subclass_code visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_CODE")) ).append( "]]></subclass_code>\r\n" );
										valueXmlString.append( "<subclass_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_DESCR")) ).append( "]]></subclass_descr>\r\n" );
										valueXmlString.append( "<strg_event_info protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_EVENT_INFO")) ).append( "]]></strg_event_info>\r\n" );
										valueXmlString.append( "<gst_no visible = '1'><![CDATA[" ).append( checkNull(rs.getString("GST_NO")) ).append( "]]></gst_no>\r\n" );
										valueXmlString.append( "<image_id visible = '1'><![CDATA[" ).append( checkNull(rs.getString("IMAGE_ID")) ).append( "]]></image_id>\r\n" );
										valueXmlString.append( "<reg_no visible = '1'><![CDATA[" ).append( checkNull(rs.getString("REG_NO")) ).append( "]]></reg_no>\r\n" );
										valueXmlString.append( "<man_power visible = '1'><![CDATA[" ).append( checkNull(rs.getString("MAN_POWER")) ).append( "]]></man_power>\r\n" );
										
									  }
									  else if(editFlg.equals("V"))
									  {	
										valueXmlString.append( "<strg_code protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
										valueXmlString.append( "<call_outcome protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
										valueXmlString.append( "<oth_participant protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
										valueXmlString.append( "<remarks protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
										valueXmlString.append( "<stockist_name protect = '1' visible='1'><![CDATA[" ).append( stockistName ).append( "]]></stockist_name>\r\n" );
										valueXmlString.append( "<stockist_code protect = '1' visible='1'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );
										valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
										valueXmlString.append( "<email_addr visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
										valueXmlString.append( "<mobile_no visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
										valueXmlString.append( "<address_as visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
										valueXmlString.append( "<gender visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
										valueXmlString.append( "<addr1 visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
										valueXmlString.append( "<addr2 visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
										valueXmlString.append( "<addr3 visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
										valueXmlString.append( "<age visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
										valueXmlString.append( "<qualification visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
										valueXmlString.append( "<qualification_descr protect = '1' visible = '1'><![CDATA[" ).append(qualDescr).append( "]]></qualification_descr>\r\n" );
										
										valueXmlString.append( "<strg_class_code visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
										valueXmlString.append( "<class_code_descr visible = '1' protect = '1'><![CDATA[" ).append( classCodeDescr ).append( "]]></class_code_descr>\r\n" );
										valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append(checkNull(getCustTypeDesc(cusType, conn))).append( "]]></cust_type>\r\n" );
										valueXmlString.append( "<spl_code visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );
										valueXmlString.append( "<pin protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("PIN")) ).append( "]]></pin>\r\n" );
										valueXmlString.append( "<subclass_code protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_CODE")) ).append( "]]></subclass_code>\r\n" );
										valueXmlString.append( "<subclass_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_DESCR")) ).append( "]]></subclass_descr>\r\n" );
										valueXmlString.append( "<strg_event_info protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_EVENT_INFO")) ).append( "]]></strg_event_info>\r\n" );
										valueXmlString.append( "<promoter_name_t visible = '0'><![CDATA[]]></promoter_name_t>\r\n" );
										valueXmlString.append( "<promoter_name visible = '0'><![CDATA[" ).append( checkNull(rs.getString("PROMOTER_NAME")) ).append( "]]></promoter_name>\r\n" );
										valueXmlString.append( "<gst_no visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("GST_NO")) ).append( "]]></gst_no>\r\n" );
										valueXmlString.append( "<image_id visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("IMAGE_ID")) ).append( "]]></image_id>\r\n" );
										valueXmlString.append( "<reg_no visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("REG_NO")) ).append( "]]></reg_no>\r\n" );
										valueXmlString.append( "<man_power visible = '1' protect = '1'><![CDATA[" ).append( checkNull(rs.getString("MAN_POWER")) ).append( "]]></man_power>\r\n" );
										
									  }
										valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );

									}
									else
									{
										
										String strgName=checkNull(rs.getString("STRG_NAME"));
										valueXmlString.append("<strg_code visible='0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
										valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
										valueXmlString.append("<oth_participant visible='0'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
										valueXmlString.append("<remarks visible='0'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
										valueXmlString.append( "<stockist_name visible='0'><![CDATA[" ).append( stockistName ).append( "]]></stockist_name>\r\n" );
										valueXmlString.append( "<stockist_code visible='0'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );

										if(strgName!=null && strgName.trim().length() >0)
										{
											valueXmlString.append( "<strg_name visible='0'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
										}
										else
										{
											valueXmlString.append( "<strg_name visible='0'><![CDATA[" ).append(checkNull(getShDescr(cusType,conn))).append( "]]></strg_name>\r\n" );

										}
										valueXmlString.append( "<email_addr visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
										valueXmlString.append( "<mobile_no visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
										valueXmlString.append( "<address_as  visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
										valueXmlString.append( "<gender visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
										valueXmlString.append( "<addr1 visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
										valueXmlString.append( "<addr2 visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
										valueXmlString.append( "<addr3 visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
										valueXmlString.append( "<age visible = '0'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
										valueXmlString.append( "<qualification visible = '0'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
										valueXmlString.append( "<qualification_descr protect = '1' visible = '0'><![CDATA[" ).append(qualDescr).append( "]]></qualification_descr>\r\n" );
										
										valueXmlString.append( "<strg_class_code visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
										valueXmlString.append( "<class_code_descr visible = '0'><![CDATA[" ).append( classCodeDescr ).append( "]]></class_code_descr>\r\n" );
										valueXmlString.append( "<subclass_code visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_CODE")) ).append( "]]></subclass_code>\r\n" );
										valueXmlString.append( "<subclass_descr visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SUBCLASS_DESCR")) ).append( "]]></subclass_descr>\r\n" );
										
										
										valueXmlString.append( "<cust_type visible='0'><![CDATA[" ).append(checkNull(getCustTypeDesc(cusType, conn))).append( "]]></cust_type>\r\n" );
										valueXmlString.append( "<spl_code visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									    valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );

									    valueXmlString.append( "<pin protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("PIN")) ).append( "]]></pin>\r\n" );
									    valueXmlString.append( "<strg_event_info protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_EVENT_INFO")) ).append( "]]></strg_event_info>\r\n" );
										
									    valueXmlString.append( "<promoter_name_t visible = '0'><![CDATA[]]></promoter_name_t>\r\n" );
										valueXmlString.append( "<promoter_name visible = '0'><![CDATA[" ).append( checkNull(rs.getString("PROMOTER_NAME")) ).append( "]]></promoter_name>\r\n" );
										valueXmlString.append( "<gst_no_t visible = '0'><![CDATA[]]></gst_no_t>\r\n" );
										valueXmlString.append( "<gst_no visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GST_NO")) ).append( "]]></gst_no>\r\n" );
										valueXmlString.append( "<image_id_t visible = '0'><![CDATA[]]></image_id_t>\r\n" );
										valueXmlString.append( "<image_id visible = '0'><![CDATA[" ).append( checkNull(rs.getString("IMAGE_ID")) ).append( "]]></image_id>\r\n" );
										valueXmlString.append( "<reg_no_t visible = '0'><![CDATA[]]></reg_no_t>\r\n" );
										valueXmlString.append( "<reg_no visible = '0'><![CDATA[" ).append( checkNull(rs.getString("REG_NO")) ).append( "]]></reg_no>\r\n" );
										valueXmlString.append( "<man_power_t visible = '0'><![CDATA[]]></man_power_t>\r\n" );
										valueXmlString.append( "<man_power visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MAN_POWER")) ).append( "]]></man_power>\r\n" );
										
									 }

								}
								valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
								valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
								valueXmlString.append( "<invoice_form_no><![CDATA[" ).append( invoiceTeam ).append( "]]></invoice_form_no>\r\n" );
								valueXmlString.append( "<collection_form_no><![CDATA[" ).append( collectionTeam ).append( "]]></collection_form_no>\r\n" );

								valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
								valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displayTimeField ).append( "]]></display_time_fld>\r\n" );//addednby shraddha M[20/07/2020]

								valueXmlString.append( "</Detail1>\r\n" );

								HashMap<String,String> subFormsMap = getSubForms(objContext, objName, conn);
								strgCode = "'"+strgCode+"'";
								
								if(subFormsMap.containsKey("sampleitem"))
								{
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingItem = getSampleExistingItemsDetail(tranId, conn ,sampleitemFormNo,"sampleitem") ;
										if( existingItem !=null && existingItem.length() > 0 )
										{
											valueXmlString.append( existingItem);
										}
									}
								}
								
								if(subFormsMap.containsKey("sampleorder"))
								{
									String sampleorderFormNo = subFormsMap.get("sampleorder");
									if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingItem = getExistingItemsDetail(tranId, conn ,sampleorderFormNo,"sampleorder",salesPerson,pricels,strgCode,editFlg) ;
										if( existingItem !=null && existingItem.length() > 0 )
										{
											valueXmlString.append( existingItem);
										}
									}
								}
								
								if(subFormsMap.containsKey("brand"))
								{
									String brandFormNo = subFormsMap.get("brand");
									if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingBrand = getExistingPitchForDoctor(tranId, conn ,brandFormNo,"brand",salesPerson,localityCode,copyPlan,strgCode,currDate);
										if( existingBrand !=null && existingBrand.length() > 0 )
										{
											valueXmlString.append( existingBrand);
										}
									}
								}
								
								if(subFormsMap.containsKey("display"))
								{
									String displayFormNo = subFormsMap.get("display");
									if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingDnd = getExistingDndDetailDisplay(tranId, conn ,displayFormNo,"display",salesPerson,currDate,editFlg) ;
										if( existingDnd !=null && existingDnd.length() > 0 )
										{
											valueXmlString.append( existingDnd);
										}
									}
								}
								
								if(subFormsMap.containsKey("team"))
								{
									String teamFormNo = subFormsMap.get("team");
									if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingTeam = getSalesExistingTeamDetail(tranId, conn ,teamFormNo,"team");
										if( existingTeam !=null && existingTeam.length() > 0 )
										{
											valueXmlString.append( existingTeam);
										}
									}
								}
								
								if(subFormsMap.containsKey("survey"))
								{
									String surveyFormNo = subFormsMap.get("survey");
									if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingSurvey = getExistingSurveyDetail( tranId, conn , surveyFormNo,"survey");
										if( existingSurvey !=null && existingSurvey.length() > 0 )
										{
											valueXmlString.append( existingSurvey);
										}
									}
								}
								if(subFormsMap.containsKey("coaching"))
								{
									String surveyFormNo = subFormsMap.get("coaching");
									if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingSurvey = getExistingCoachingDetail( tranId, conn ,surveyFormNo,"coaching",visitedwithTeam );
										if( existingSurvey !=null && existingSurvey.length() > 0 )
										{
											valueXmlString.append( existingSurvey);
										}
									}
								}
								if(subFormsMap.containsKey("collection"))
								{
									String collectionFormNo = subFormsMap.get("collection");
								    if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingDnd = getExistingCollectionDetail(tranId, conn ,collectionFormNo,"collection",editFlg,totalamount) ;
										if( existingDnd !=null && existingDnd.length() > 0 )
										{
											valueXmlString.append( existingDnd);
										}
									}
								}
								if(subFormsMap.containsKey("invoice"))
								{
									String invoiceFormNo = subFormsMap.get("invoice");
								    if( !"".equalsIgnoreCase( strgCode ) )
									{
										String existingDnd = getExistingInvoiceDetail(tranId, conn ,invoiceFormNo,"invoice",salesPerson,dom2,strgCode,pricels,editFlg) ;
										if( existingDnd !=null && existingDnd.length() > 0 )
										{
											valueXmlString.append( existingDnd);
										}
									}
								}
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						
						}
					}
					else if(currentColumn.trim().equalsIgnoreCase("spl_code"))
					{
						String specialityCode = checkNull(genericUtility.getColumnValue("spl_code", dom2));
						String unlistedStrgType = checkNull(genericUtility.getColumnValue("cust_type", dom2));
						String specialityDescr="";
						String sql = "SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, specialityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							specialityDescr = checkNull(rs.getString("DESCR"));
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append(checkNull(specialityDescr)).append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<spl_code protect = '0'><![CDATA[" ).append(checkNull(specialityCode)).append( "]]></spl_code>\r\n" );
						
						valueXmlString.append( "</Detail"+objContext+">\r\n" );

					}
					/*
					else if( currentColumn.equalsIgnoreCase("stockist_code"))
					{
						//System.out.println("INSIDE stockist_code itemchange................");
						String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom2,"1"));
						//System.out.println("stockist code is  :"+stockistCode);
						String stockistName="";
						String sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME FROM STRG_CUSTOMER SC WHERE SC_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, stockistCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							stockistName = checkNull(rs.getString("STRG_NAME"));
							//System.out.println("stockistName"+stockistName);

						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<stockist_name protect = '1'><![CDATA[" ).append(checkNull(stockistName)).append( "]]></stockist_name>\r\n" );
						valueXmlString.append("<stockist_code protect = '0'><![CDATA[" ).append(checkNull(stockistCode)).append( "]]></stockist_code>\r\n" );
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					*/
					else if( currentColumn.equalsIgnoreCase("qualification"))
					{
						//System.out.println("INSIDE stockist_code itemchange................");
						String qualif_code = checkNull(genericUtility.getColumnValue("qualification", dom2,"1"));
						String qualiDescr="";
						String sql = "select DESCR from qualification where qlf_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, qualif_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							qualiDescr = checkNull(rs.getString("DESCR"));
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<qualification protect = '0'><![CDATA[" ).append(checkNull(qualif_code)).append( "]]></qualification>\r\n" );
						valueXmlString.append("<qualification_descr protect = '1'><![CDATA[" ).append(checkNull(qualiDescr)).append( "]]></qualification_descr>\r\n" );
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					else if( currentColumn.equalsIgnoreCase("strg_class_code"))
					{
						String strg_class_code = checkNull(genericUtility.getColumnValue("strg_class_code", dom2,"1"));
						String strgType = checkNull(genericUtility.getColumnValue("strg_type", dom2,"1"));
						String class_code_descr="";
						String sql = "select class_code_descr from strg_cust_class where CLASS_CODE  = ? AND CUST_TYPE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, strg_class_code);
						pstmt.setString(2, strgType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							class_code_descr = checkNull(rs.getString("class_code_descr"));
							
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<strg_class_code protect = '0'><![CDATA[" ).append(checkNull(strg_class_code)).append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<class_code_descr protect = '1'><![CDATA[" ).append(checkNull(class_code_descr)).append( "]]></class_code_descr>\r\n" );
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					else if( currentColumn.equalsIgnoreCase("subclass_code"))
					{
						String subclass_code = checkNull(genericUtility.getColumnValue("subclass_code", dom2,"1"));
						String subclass_descr="";
						String sql = "select SUBCLASS_DESCR from STRG_CUST_SUBCLASS where SUBCLASS_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, subclass_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							subclass_descr = checkNull(rs.getString("SUBCLASS_DESCR"));
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<subclass_code protect = '0'><![CDATA[" ).append(checkNull(subclass_code)).append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr protect = '1'><![CDATA[" ).append(checkNull(subclass_descr)).append( "]]></subclass_descr>\r\n" );
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
			}
			else if("sampleitem".equalsIgnoreCase(formName))
			{
				
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
				   String parentFormNo = "1";
				   String selectedItem = "";
				   tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
				   String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
					
				   
				   if(mode.equals("E"))
				   {
					   String salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					   String wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					   String scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					   String editScCode = checkNull(getSelectedYesRowValue(dom2, parentFormNo, "strg_code", 0));
					   if(editScCode==null || editScCode.trim().length()==0)
					   {
							editScCode="X";
						}
					   valueXmlString.append( getSampleItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,conn,objContext,editScCode,formName ));
				   }
				   else if(mode.equals("V"))
				   {
					   valueXmlString.append(getSampleExistingItemsDetail(tranId, conn ,objContext,"sampleitem")) ;
				   }
				}
			}
			else if("sampleorder".equalsIgnoreCase(formName))
			{
				
				String strgCode="";
				String itemCode ="";
				
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
				   String parentFormNo = "1";
				   tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
				   salesPerson = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
				   String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
				   String prcListTemp=getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
				   String wrkDate = "";
				   String scCode = "";
				   wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
				   scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
				   if(mode.equals("V"))
				   { 
				       valueXmlString.append(getExistingItemsDetail(tranId, conn ,objContext,formName,salesPerson,prcListTemp,scCode,mode)) ;
				   }
				   else if(mode.equals("E"))
				   {
					  valueXmlString.append( getItemDetails(dom, dom2 , salesPerson, wrkDate, scCode, xtraParams,conn,objContext,formName,prcListTemp,tranId,mode));
                   }
			    }
				else if( currentColumn.equalsIgnoreCase( "quantity" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					String parentFormDomId="";
					String qtyDom = checkNull(getSelectedRowValue(dom1, objContext, "quantity",0));
					String rateDom = checkNull(getSelectedRowValue(dom1, objContext, "landing_rate",0));
					String discnt  = checkNull(getSelectedRowValue(dom1, objContext, "disc_perc",0));
					String strgCodeDummy = checkNull(getSelectedRowValue(dom1, objContext, "strg_code_dummy",0));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					itemCode = checkNull(getSelectedRowValue(dom1, objContext, "item_code",0));
					
					double value = 0d;
					double totPOBVal=0.0;
					String parentFormNo ="1";


					parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					String pobValueParent=checkNull(genericUtility.getColumnValue("sku_value", dom2,""+parentFormNo, parentFormDomId));

					totPOBVal =  getTotalPOBValue( dom2, ""+currentFormNo, "value", strgCode);
					if(pobValueParent == null || pobValueParent.trim().length() == 0)
					{
						pobValueParent = "0";
					}

					
					try
					{
						DecimalFormat df = new DecimalFormat("###.##");
						if(qtyDom != null && qtyDom.trim().length() != 0)
						{
							//System.out.println("Inside qty loop");
							double qty = 0d;
							double rate = 0d;
							double discount =0d;
							
							qty = Double.parseDouble(qtyDom);
							rate = Double.parseDouble(rateDom);
							if(discnt!=null && discnt.trim().length()!=0)
							{
							  discount = Double.parseDouble(discnt);
							} 
							value = qty * rate;
							value= qty * rate - (discount * value /100);

							//System.out.println("value : ["+value+"]");
							valueXmlString.append("<value><![CDATA[" ).append(df.format(value)).append( "]]></value>\r\n" );
						}
						else
						{
							value = 0;
							valueXmlString.append("<value><![CDATA[" ).append("").append( "]]></value>\r\n" );
						}

						valueXmlString.append("<Detail"+parentFormNo+"."+parentFormDomId+".sku_value><![CDATA[" ).append(df.format(totPOBVal)).append( "]]></Detail"+parentFormNo+"."+parentFormDomId+".sku_value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}
					catch(NumberFormatException e)
					{
						valueXmlString.append("<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}

				}
				
				
			}
			else if("brand".equalsIgnoreCase(formName))
			{
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
				   String parentFormNo = "1";
				   tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
				   String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
				   String salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
				   String wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
				   String localityCode = getSelectedRowValue(dom2, parentFormNo, "locality_code", 0);
				   String scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
				   String copyPlan=getSelectedRowValue(dom2, parentFormNo, "copy_plan", 0);
				
				   if(mode.equalsIgnoreCase("E")) 
					{
							valueXmlString.append( getPitchDetails( salePersCode, wrkDate, copyPlan,scCode,localityCode, xtraParams, "", "", ""+currentFormNo, formName,conn,tranId));
					}
				   else if(mode.equalsIgnoreCase("V")) 
				   {
					   valueXmlString.append(getExistingPitchForDoctor(tranId, conn ,objContext,formName,salePersCode,wrkDate,copyPlan,scCode,localityCode)) ;
				   } 
				 }
			}
			else if("display".equalsIgnoreCase(formName))
			{
				
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					String parentFormNo = "1";
					String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
					tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
					salesPerson = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					currDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
				    String isSelected = getExistingDndDetailDisplay(tranId, conn ,objContext,"display",salesPerson,currDate,mode);
					valueXmlString.append(isSelected) ;
				}
				else if(currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					
					NodeList parentList = null;
				    NodeList childList = null;
				    Node parentNode = null,childNode = null;
					int	detailListLength = 0;
					String indexDom = "",childNodeName="",lineNo="";
					ArrayList<Integer> linelist= new ArrayList<Integer>();
					
					parentList = dom2.getElementsByTagName("Detail"+currentFormNo);
					int parentNodeListLength2 = parentList.getLength();
					String updateFlag="E";
					for (int prntCtr = 0; prntCtr < parentNodeListLength2; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						for (int ctr = 0; ctr < childList.getLength(); ctr++)
						{
							childNode = childList.item(ctr);
							childNodeName = childNode.getNodeName();
							if ( "line_no".equalsIgnoreCase(childNodeName))
							{
								if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
								{
									lineNo= childNode.getFirstChild().getNodeValue().trim();
									int lno = Integer.parseInt(lineNo);
									linelist.add(lno);
								}
							}
						}	
					}
					 String newLineNo="1";
					 int maxlineNo=0;
					if(!(linelist.isEmpty()))
					{	
			     	  maxlineNo	= Collections.max(linelist)+1;
				      //newLineNo = Integer.toString(maxlineNo);
					}
					else if(!(domIdList.isEmpty()))
					{
						maxlineNo=domID;
					}
					
					valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id visible='0'><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no visible='0'><![CDATA[").append(maxlineNo).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code visible='0'><![CDATA[").append("").append("]]></strg_code>\n");
					valueXmlString.append("<doc_id visible='1'><![CDATA[").append("").append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1 visible='1'><![CDATA[").append("").append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append("").append("]]></display_area>\r\n");
					valueXmlString.append("<brand_descr visible='0'><![CDATA[").append("").append("]]></brand_descr>\r\n");
					valueXmlString.append("<disp_type visible='0'><![CDATA[").append("").append("]]></disp_type>\r\n");
					valueXmlString.append("<brand_code visible='0'><![CDATA[").append("").append("]]></brand_code>\r\n");                                     
					valueXmlString.append("<quantity visible='0'><![CDATA[").append("").append("]]></quantity>\r\n");
					valueXmlString.append( "<tran_id visible='0'><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<target_qty visible='0'><![CDATA[" ).append("").append( "]]></target_qty>\r\n" );
			
					valueXmlString.append("</Detail"+objContext+">\r\n" );
				}
			}
			else if("team".equalsIgnoreCase(formName))
			{
				
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					
				   String parentFormNo = "1";
				   tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
				   String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
					if(mode.equals("E"))
					{
						String selectedTeam = "";
						 String salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
						String wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
						String scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
						valueXmlString.append( getSalesTeamDetails( dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,formName, conn, objContext,tranId ));
				   }
				   else if(mode.equals("V"))	
					{	
				      valueXmlString.append(getSalesExistingTeamDetail(tranId, conn ,objContext,"team")) ;
					}
				}
				else if(currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					String salePersCode = getSelectedRowValue(dom2,"1", "sales_pers", 0);
					String dcrId = getSelectedRowValue(dom2,"1", "dcr_id", 0);
					String tranId1 = getSelectedRowValue(dom2,"1", "tran_id", 0);
					String strgCode = getSelectedRowValue(dom2,"1", "strg_code", 0);
					
					NodeList parentList = null;
				    NodeList childList = null;
				    Node parentNode = null,childNode = null;
					String childNodeName="",lineNo="";
					ArrayList<Integer> linelist= new ArrayList<Integer>();
					
					parentList = dom2.getElementsByTagName("Detail"+currentFormNo);
					int parentNodeListLength2 = parentList.getLength();
					for (int prntCtr = 0; prntCtr < parentNodeListLength2; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						for (int ctr = 0; ctr < childList.getLength(); ctr++)
						{
							System.out.println("at 1063");
							childNode = childList.item(ctr);
							childNodeName = childNode.getNodeName();
							if ( "line_no".equalsIgnoreCase(childNodeName))
							{
								if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
								{
									lineNo= childNode.getFirstChild().getNodeValue().trim();
									int lno = Integer.parseInt(lineNo);
									linelist.add(lno);
								}
							}
						}	
					}
					int maxlineNo=2;
					if(!(linelist.isEmpty()))
					{	
			     	  maxlineNo	= Collections.max(linelist)+1;
					}
					else if(!(domIdList.isEmpty()))
					{
						maxlineNo=domID;
					}
					String dispName = checkNull(getEmpNameDesign(salePersCode,conn));
					String empDesign = getDesignName(salePersCode, conn); 
					
					/*
					valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrId).append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(maxlineNo).append("]]></line_no>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( tranId1 ).append("]]></tran_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<member_type><![CDATA[").append("").append("]]></member_type>\r\n");
					valueXmlString.append("<member_name visible ='1'><![CDATA[").append("").append("]]></member_name>\r\n");
					valueXmlString.append("<mem_code><![CDATA[").append(salePersCode).append("]]></mem_code>\r\n");
					valueXmlString.append("<team_mobile_no visible ='1'><![CDATA[" ).append("").append("]]></team_mobile_no>\r\n");					
					valueXmlString.append("<sales_pers><![CDATA[").append(salePersCode).append("]]></sales_pers>\r\n");
					valueXmlString.append("<disp_descr><![CDATA[" ).append(empDesign).append("]]></disp_descr>\r\n");
					
					valueXmlString.append("<sales_pers_sp_name><![CDATA[").append("").append("]]></sales_pers_sp_name>\r\n");
					valueXmlString.append("<design_code><![CDATA[").append(empDesign).append("]]></design_code>\r\n");
					valueXmlString.append("<employee_designation><![CDATA[").append(empDesign).append("]]></employee_designation>\r\n");
					valueXmlString.append("<name><![CDATA[").append("").append("]]></name>\r\n");
					valueXmlString.append("<visited_with_display><![CDATA[").append(dispName).append("]]></visited_with_display>\r\n");
					valueXmlString.append("<team_hierarchy_list><![CDATA[" ).append(salePersCode ).append("]]></team_hierarchy_list>\r\n");

					valueXmlString.append("</Detail"+objContext+">\r\n" );
					*/
					 double randomNo = Math.floor(1000000 + Math.random() * 9000000);
					 int memCode = (int) Math.round(randomNo);
					String nMemCode = "";
					nMemCode = "M"+memCode;
					valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(maxlineNo).append("]]></line_no>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\r\n");
					valueXmlString.append("<member_type><![CDATA[").append("").append("]]></member_type>\r\n");
					valueXmlString.append("<member_name visible ='1'><![CDATA[").append("").append("]]></member_name>\r\n");
					valueXmlString.append("<mem_code><![CDATA[").append("").append("]]></mem_code>\r\n");
					valueXmlString.append("<team_mobile_no visible ='1'><![CDATA[" ).append("").append("]]></team_mobile_no>\r\n");					
					valueXmlString.append("<sales_pers><![CDATA[").append(nMemCode).append("]]></sales_pers>\r\n");
					valueXmlString.append("<disp_descr visible='0'><![CDATA[" ).append("Customer Representative").append("]]></disp_descr>\r\n");
					
					valueXmlString.append("</Detail"+objContext+">\r\n" );
				}
				
			}
			else if("survey".equalsIgnoreCase(formName))
			{
				
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					String parentFormNo ="1";
					String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
					if(mode.equals("E"))
					{	
					    String salePersCode = "";
					    String wrkDate = "";
					    String scCode = "";
					    salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					    wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					    scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
                    
					    String surveyTemplate=getSelectedRowValue(dom2, parentFormNo, "survey_templ", 0);
					    valueXmlString.append( getSurveyDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,conn,objContext,formName,surveyTemplate ));
					}
					else if(mode.equals("V"))
					{
						tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
						valueXmlString.append(getExistingSurveyDetail( tranId, conn , objContext,"survey")) ;
					}	
				}
			}
			else if("coaching".equalsIgnoreCase(formName))
			{
				
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
				   String parentFormNo = "1";
				   String sprsCodeWW="",visitedwithTeam="";
				   tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
				   String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
				   
				   salesPerson = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
				   visitedwithTeam = getSelectedRowValue(dom2, parentFormNo, "visited_with", 0);
				   sprsCodeWW = getSelectedRowValue(dom2, parentFormNo, "sprs_code__ww", 0);
				   
				   if(mode.equalsIgnoreCase("E"))
				   {
					    String salePersCode = "";
						String wrkDate = "";
						String vistedWith = "";
						String scCode = "",sprsCodeWrkWith ="";
						
						wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
						scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
						String shDescr = getSelectedRowValue(dom2, parentFormNo, "sh_descr", 0);
						String eventType = getSelectedRowValue(dom2, parentFormNo, "event_type", 0);
					    String empDesign = getDesignName(salesPerson, conn);
						String grade = getGrade(salesPerson, conn);
						String coachingTemplate = getSfaParmValueCoaching( eventType, shDescr, conn, "COACHING_TEMPL", empDesign, grade );
						valueXmlString.append( getCoachingDetails(dom, dom2 , salesPerson, wrkDate, scCode, xtraParams,conn,objContext,formName,coachingTemplate,eventType,shDescr,empDesign,grade,sprsCodeWW,visitedwithTeam ));
					 
				   }
				   else
				   {
				     valueXmlString.append(getExistingCoachingDetail( tranId, conn ,objContext,"coaching",visitedwithTeam )) ;
				   }
				 }
			}
			else if("collection".equalsIgnoreCase(formName))
			{
				
				String parentFormNo = "1";
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					 int domID=1;
					 tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
					 String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
					 String billamount = getSelectedRowValue(dom2, parentFormNo, "amount", 0);
					 String isSelected = getExistingCollectionDetail( tranId, conn , objContext,"collection",mode,billamount);
					 System.out.println("isSelected:: "+isSelected+" mode:"+mode);
					 if(isSelected.trim().length()==0 && mode.equals("E"))
					 {
						 
						 valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
						 valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						 valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
						 valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
						 valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
						 valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
						 valueXmlString.append("<bill_amt><![CDATA[").append(billamount).append("]]></bill_amt>\r\n");
						 valueXmlString.append("<bill_date><![CDATA[").append(currDate).append("]]></bill_date>\r\n");
						 valueXmlString.append("<pay_mode><![CDATA[").append( "" ).append("]]></pay_mode>\r\n");
						 valueXmlString.append("<ref_no><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
						 valueXmlString.append("<ref_date><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
						 valueXmlString.append("<amount><![CDATA[").append( "" ).append("]]></amount>\r\n");
						 valueXmlString.append("<ref_bank><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
						 valueXmlString.append("<remarks_collect><![CDATA[").append( "" ).append("]]></remarks_collect>\r\n");
						 valueXmlString.append("</Detail"+objContext+">\r\n" );
					}
					else
					{
						valueXmlString.append(isSelected) ;
					}
                }
				else if(currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					String billamount = getSelectedRowValue(dom2, parentFormNo, "amount", 0);
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					

					   NodeList parentList = null;
					    NodeList childList = null;
					    Node parentNode = null,childNode = null;
						int	detailListLength = 0;
						String indexDom = "",childNodeName="",lineNo="";
						ArrayList<Integer> linelist= new ArrayList<Integer>();
						
						parentList = dom2.getElementsByTagName("Detail"+currentFormNo);
						int parentNodeListLength2 = parentList.getLength();
						for (int prntCtr = 0; prntCtr < parentNodeListLength2; prntCtr++ )
						{
							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							for (int ctr = 0; ctr < childList.getLength(); ctr++)
							{
								childNode = childList.item(ctr);
								childNodeName = childNode.getNodeName();
								if ( "line_no".equalsIgnoreCase(childNodeName))
								{
									if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
									{
										lineNo= childNode.getFirstChild().getNodeValue().trim();
										int lno = Integer.parseInt(lineNo);
										linelist.add(lno);
									}
								}
							}	
						}
					
					int maxlineNo	= 2;
					if(!(linelist.isEmpty()))
					{	
			     	  maxlineNo	= Collections.max(linelist)+1;
					}
					else if(!(domIdList.isEmpty()))
					{
						maxlineNo=domID;
					}
					
					valueXmlString.append("<Detail"+currentFormNo+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(maxlineNo).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<bill_amt><![CDATA[").append(billamount).append("]]></bill_amt>\r\n");
					valueXmlString.append("<bill_date><![CDATA[").append(currDate).append("]]></bill_date>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( "" ).append("]]></pay_mode>\r\n");
					valueXmlString.append("<ref_no><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
					valueXmlString.append("<ref_date><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
					valueXmlString.append("<amount><![CDATA[").append( "" ).append("]]></amount>\r\n");
					valueXmlString.append("<ref_bank><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
					valueXmlString.append("<remarks_collect><![CDATA[").append( "" ).append("]]></remarks_collect>\r\n");
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
										
				}
				else if(currentColumn.equalsIgnoreCase("pay_mode"))
				{
					
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					
					valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					
					if(columnValue.equalsIgnoreCase("C"))
					{
						valueXmlString.append("<ref_no visible='0'><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
						valueXmlString.append("<ref_date visible='0'><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
						valueXmlString.append("<ref_bank visible='0'><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
					}
					else
					{
						valueXmlString.append("<ref_no visible='1'><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
						valueXmlString.append("<ref_date visible='1'><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
						valueXmlString.append("<ref_bank visible='1'><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
					}
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					
					
				}
			}
			else if("invoice".equalsIgnoreCase(formName))
			{
				
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
				   String parentFormNo = "1";
				   tranId = getSelectedRowValue(dom2, parentFormNo, "tran_id", 0);
				   String mode = getSelectedRowValue(dom2, parentFormNo, "ev_flag", 0);
				   salesPerson = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
				   String strgCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
				   String prcListTemplate=getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
					  
				   if(mode.equalsIgnoreCase("E"))
				   {
					   //System.out.println("Inside Edit mode of Invoice form");
					   String wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					    valueXmlString.append( getInvoiceItemDetails(dom, dom2 , salesPerson, wrkDate, strgCode, xtraParams,conn,objContext,formName,prcListTemplate,tranId,mode));

				   }
				   else if(mode.equalsIgnoreCase("V"))
				   {
				     valueXmlString.append(getExistingInvoiceDetail( tranId, conn , objContext,"invoice",salesPerson,dom2,strgCode,prcListTemplate,mode)) ;
				   }
				   
				}
				/*else if( currentColumn.equalsIgnoreCase( "quantity" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					String parentFormDomId="";
					
					String qtyDom = checkNull(getSelectedRowValue(dom1, objContext, "quantity",0));
					String rateDom = checkNull(getSelectedRowValue(dom1, objContext, "rate",0));
					String taxAmt  = checkNull(getSelectedRowValue(dom1, objContext, "tax_amt_inv",0));
					String strgCode = checkNull(getSelectedRowValue(dom1, objContext, "strg_code",0));
					
					double value = 0d;
					double totBasicVal=0.0;
					double totGSTVal=0.0;
					double totAmountVal=0.0;
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, conn));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					
					totBasicVal =  getBasicValue( dom, ""+currentFormNo, "value", strgCode);
					totGSTVal =  getGSTValue( dom, ""+currentFormNo, "value", strgCode);
					totAmountVal =  getAmountValue( dom, ""+currentFormNo, "value", strgCode);
					try
					{
						DecimalFormat df = new DecimalFormat("###.##");
						if(qtyDom != null && qtyDom.trim().length() != 0)
						{
							double qty = 0d;
							double rate = 0d;
							double taxAmount = 0.d;
							qty = Double.parseDouble(qtyDom);
							rate = Double.parseDouble(rateDom);
							taxAmount = Double.parseDouble(taxAmt);
							taxAmount=(taxAmount/100);
							value = ((qty * rate)+taxAmount);
							valueXmlString.append("<value><![CDATA[" ).append(df.format(value)).append( "]]></value>\r\n" );
							
						}
						else
						{
							value = 0;
							valueXmlString.append("<value><![CDATA[" ).append("").append( "]]></value>\r\n" );
						}
						valueXmlString.append("<basic_value><![CDATA[" ).append(df.format(totBasicVal)).append( "]]></basic_value>\r\n" );
						valueXmlString.append("<total_gst><![CDATA[" ).append(df.format(totGSTVal)).append( "]]></total_gst>\r\n" );
						valueXmlString.append("<total_value><![CDATA[" ).append(df.format(totAmountVal)).append( "]]></total_value>\r\n" );
						valueXmlString.append("<Detail"+parentFormNo+".1.net_amt><![CDATA[" ).append(df.format(totBasicVal)).append( "]]></Detail"+parentFormNo+".1.net_amt>\r\n" );
						valueXmlString.append("<Detail"+parentFormNo+".1.tax_amount><![CDATA[" ).append(df.format(totGSTVal)).append( "]]></Detail"+parentFormNo+".1.tax_amount>\r\n" );
						valueXmlString.append("<Detail"+parentFormNo+".1.amount><![CDATA[" ).append(df.format(totAmountVal)).append( "]]></Detail"+parentFormNo+".1.amount>\r\n" );
						
						
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}
					catch(NumberFormatException e)
					{
						valueXmlString.append("<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}

				
				}*/
			}
			
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :RealtimeView :defaultData(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
			//valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :::::::::::" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	
	}
	
	public String getExistingTeam( String salePersCode, String eventDate, String tranId, Connection conn ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID= 1;

		String teamData = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String smtQuery = "SELECT DISTINCT ST.SALES_PERS,UPPER(EMP.EMP_FNAME) ||' ' ||UPPER(EMP.EMP_MNAME) ||' '|| "+
					"UPPER(EMP.EMP_LNAME) AS EMP_NAME, EMP.DESIGNATION DESIGNATION FROM STRG_MEET_TEAM ST LEFT OUTER "+
					"JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE WHERE ST.TRAN_ID = ?";

			pstmt = conn.prepareStatement(smtQuery);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				teamData = teamData + checkNull(rs.getString("EMP_NAME")) +" ("+checkNull(rs.getString("SALES_PERS"))+")," ;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			if(teamData.lastIndexOf(",")!= -1)
			{
				teamData = teamData.substring(0, teamData.length()-1);
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		//System.out.println("teamData ::"+teamData);
		return teamData;
	}
	
	private String getWorkWithList(String teamDetail,String formNo)
	{
		String workWith = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			Document preFormDom =  genericUtility.parseString("<Root>"+teamDetail+"</Root>");
			NodeList preDomList = preFormDom.getElementsByTagName("Detail"+formNo);
			for (int prntCtr = 0; prntCtr < preDomList.getLength(); prntCtr++ )
			{
				Node det3Nod = preDomList.item(prntCtr);
				NodeList teamList = det3Nod.getChildNodes();
				int teamLen = teamList.getLength();

				for(int tCtr = 0;tCtr < teamLen;tCtr++)
				{
					Node teamNode = teamList.item(tCtr);
					if(teamNode != null && teamNode.getNodeType() == Node.ELEMENT_NODE)
					{

						if(teamNode.getNodeName().equalsIgnoreCase("sales_pers"))
						{
							workWith = workWith + "("+teamNode.getFirstChild().getNodeValue() + ")";
						}
						else if(teamNode.getNodeName().equalsIgnoreCase("name"))
						{
							workWith = workWith + teamNode.getFirstChild().getNodeValue() + ",";
						}
					}

				}

			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		return workWith;
	}
	
	private String getDesignName(String empCode,Connection conn) throws ITMException
	{
		String designation="";
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE= ? ";
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				designation = checkNull(rs.getString("DESIGN_CODE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return designation;
	}
	
	public String getShDescr(String type,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String shDescr = "";
		try
		{

			String sql  = "SELECT SH_DESCR FROM STRG_CUST_TYPE WHERE TYPE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, type);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				shDescr = checkNull(rs.getString("SH_DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return shDescr;
	}
	
	public String getExistingItemsDetail(String tranId,Connection conn,String formNo,String formName,String salesPerson,String prcListTemp,String strgCode,String mode) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		ResultSet rs1 = null;
		ResultSet rs0 = null;
		PreparedStatement pstmt1 = null;
		int domID=1;
		int strgCustCnt = 0;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		String smiQuery="";
		DARCommonBean darCommonBean= new DARCommonBean();
		String bindValue = salesPerson;
		String sql="";
		try
		{
			/*
			smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.SCHEME_CODE,SMO.QUANTITY, SMO.VALUE, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID,SMO.PROMO_PERC, "
					+" SMO.STOCKIST_CODE, SMO.RATE, SMO.DISC_PERC, SMO.LOT_NO, SMO.STOCK_QTY, SMO.STOCK_INFO,SMO.PROMO_CODE,SMO.LOT_NO,SMO.TRAN_ID "
					+" FROM STRG_MEET_ORDER SMO, ITEM ITEM"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.TRAN_ID=?";
					
					*/
			
			String itemSizeCol = getSfaParmValue(salesPerson,"ITEM_ATTRIB_SIZE",conn);
			if(itemSizeCol.trim().length() == 0)
			{
				itemSizeCol = "PHY_ATTRIB_1";
			}
			String itemUSage="";
			String parmItemUsage = getSfaParmValue(salesPerson,"SAMPLE_ITEM_USAGE",conn);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}
			int sprsCnt=0;
			/*
			String sprsCntSql="SELECT COUNT(*) AS COUNT " +
					" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " +
					" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE " +
					" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
					" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS " +
					" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y'  AND SI.STATUS='Y' " +
					" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") " +
					" ORDER BY P.SORT_ORDER,V.SORT_ORDER";
			*/
			String sprsCntSql="SELECT COUNT(*) AS COUNT " +
					" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE " +
					" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE " +
					//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
					" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
					" WHERE PM.PRICE_LIST= ? AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS " +
					" AND SP.SALES_PERS = ? AND ITEM.ACTIVE = 'Y'  AND SI.STATUS='Y' " +
					" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") " +
					" ORDER BY P.SORT_ORDER,V.SORT_ORDER";
			PreparedStatement pstmtCnt = conn.prepareStatement(sprsCntSql);
			pstmtCnt.setString(1, prcListTemp);
			if(bindValue != null && bindValue.trim().length() > 0)
			{
				pstmtCnt.setString(2, salesPerson);
			}
			rs0 = pstmtCnt.executeQuery();
			if(rs0.next())
			{
				sprsCnt = rs0.getInt("COUNT");
			}
			if(rs0 != null)
			{
				rs0.close(); 
				rs0 = null;
			}
			if(pstmtCnt != null)
			{
				pstmtCnt.close(); 
				pstmtCnt = null;
			}
			
			if(sprsCnt > 0)
			{
                 /*
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS "+
						" AND SP.SALES_PERS = ?  AND ITEM.ACTIVE = 'Y' AND SI.STATUS='Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
				*/
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID,SPRS_ITEM SI " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID,SPRS_ITEM SI " +
						" WHERE PM.PRICE_LIST= ? AND SI.ITEM_CODE= ITEM.ITEM_CODE AND SP.SALES_PERS=SI.SALES_PERS "+
						" AND SP.SALES_PERS = ?  AND ITEM.ACTIVE = 'Y' AND SI.STATUS='Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";

			}
			// added by mrunalini sinkar for adding sprs_item condition to geeting item on  25-April-2019(end)
			else
			{
				/*
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,S.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
						" WHERE SP.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
				*/
				
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,PM.PRICE_LIST AS PRICE_LIST " +
						" ,P.PRODUCT_CODE AS PRODUCT_CODE, P.DESCR AS PRODUCT_DESCR, P.PRODUCT_TYPE, P.SORT_ORDER, V.SORT_ORDER  "+
						" FROM SALES_PERS SP, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE "+
						" LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "+
						//" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM.PHY_ATTRIB_1=V.ATTRIB_ID " + // changes made by rupali on 03/05/19 for mapping og physical attribute
						" LEFT OUTER JOIN ITM_ATTRIB_VAL V ON ITEM."+itemSizeCol+"=V.ATTRIB_ID " +
						" WHERE PM.PRICE_LIST= ? "+
						" AND SP.SALES_PERS = ? AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" ORDER BY P.SORT_ORDER,V.SORT_ORDER ";
			}
			
			String codeSql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE=?";
			pstmt1=conn.prepareStatement(codeSql);
			pstmt1.setString(1,strgCode);
			rs1  = pstmt1.executeQuery();
			if(rs1.next())
			{
				strgCustCnt = rs1.getInt("COUNT");

			}
			if(rs1!=null)
			{
				rs1.close();
				rs1 = null;
			}
			if(pstmt1!=null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			HashMap itemAttribMap = darCommonBean.getItemAttributeDetails(conn,sql,bindValue, strgCustCnt, "'"+strgCode+"'",prcListTemp, sprsCnt);
			/*
			smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.SCHEME_CODE,SMO.QUANTITY, SMO.VALUE,ITEM.UNIT AS ITEM_UNIT,ITEM.PRODUCT_CODE AS PRODUCT_CODE,P.DESCR AS PRODUCT_DESCR,P.PRODUCT_TYPE,ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID,SMO.PROMO_PERC, "
					+" SMO.STOCKIST_CODE, SMO.RATE,SMO.REMARKS_ORD ,SMO.DISC_PERC, SMO.LOT_NO, SMO.STOCK_QTY, SMO.STOCK_INFO,SMO.PROMO_CODE,SMO.LOT_NO,SMO.TRAN_ID "
					+" FROM STRG_MEET_ORDER SMO, ITEM ITEM"
					+ " LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE=P.PRODUCT_CODE"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.TRAN_ID=?";
					*/
			
			smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.SCHEME_CODE,SMO.QUANTITY, SMO.VALUE,ITEM.UNIT AS ITEM_UNIT,ITEM.PRODUCT_CODE AS PRODUCT_CODE,P.DESCR AS PRODUCT_DESCR,P.PRODUCT_TYPE,ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID,SMO.PROMO_PERC,SM.EVENT_DATE AS WORKDATE, "
					+" SMO.STOCKIST_CODE, SMO.RATE,SMO.REMARKS_ORD ,SMO.DISC_PERC, SMO.LOT_NO, SMO.STOCK_QTY, SMO.STOCK_INFO,SMO.PROMO_CODE,SMO.LOT_NO,SMO.TRAN_ID "
					+" FROM STRG_MEET_ORDER SMO LEFT OUTER JOIN STRG_MEET SM ON SM.TRAN_ID= SMO.TRAN_ID, ITEM ITEM"
					+ " LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE=P.PRODUCT_CODE"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.TRAN_ID=?";
			
			pstmt = conn.prepareStatement(smiQuery);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String item = checkNull(rs.getString("ITEMDESCR"));
				String productCode = checkNull(rs.getString("PRODUCT_CODE"));
				String scCode =  checkNull(rs.getString("STRG_CODE"));
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				String quantity = checkNull(rs.getString("QUANTITY"));
				String rate = checkNull(rs.getString("RATE"));
				String discount = checkNull(rs.getString("DISC_PERC"));
				String stock = checkNull(rs.getString("STOCK_QTY"));
				String workdate = checkNull(rs.getString("WORKDATE"));
				int minQunt=0;
				int proDiffDays=0;
				double value = 0d;
				double stockValue = 0d;
				double rate1 = 0d;
				DecimalFormat df = new DecimalFormat("###.##"); 
				

				DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
				DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
				Date evntDate = dbFormat.parse(workdate);
				workdate = dtFormat.format(evntDate);
				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				if( !item.equals("") )
				{
					valueXmlString.append("<item_descr><![CDATA[").append(item).append("]]></item_descr>\n");
                }
				
				
			String minQuansql="SELECT MIN_QTY AS MIN_QTY FROM STRG_PRODUCT WHERE PRODUCT_CODE=? AND ITEM_CODE =? AND SC_CODE=?";
			PreparedStatement minQuanPstmt = conn.prepareStatement(minQuansql);
			minQuanPstmt.setString(1,productCode);
			minQuanPstmt.setString(2,itemCode);
			minQuanPstmt.setString(3,strgCode);
			ResultSet minQuanRS = minQuanPstmt.executeQuery();
			if( minQuanRS.next() )
			{
				minQunt=minQuanRS.getInt("MIN_QTY");
			}
			if (minQuanRS!= null)
			{
				minQuanRS.close();
				minQuanRS = null;
			}
			if(minQuanPstmt!=null)
			{
				minQuanPstmt.close();
				minQuanPstmt = null;
			}	
			
			String mrpPriceList = checkNull(getSfaParmValue(salesPerson, "MRP_PRICELIST", conn)); 
			double mrprate = 0d;
			mrprate = darCommonBean.getLandingRate( strgCode, itemCode, workdate, salesPerson,mrpPriceList, conn);				
			valueXmlString.append("<mrp_rate visible='0'><![CDATA[" ).append(df.format(mrprate)).append( "]]></mrp_rate>\r\n" );
			valueXmlString.append("<mrp_rate_t visible='0'><![CDATA[]]></mrp_rate_t>\r\n" );
			
			String maxTwoOrder=darCommonBean.getPreviousTwoOrderDetails(itemCode,workdate,strgCode,salesPerson,conn);
			valueXmlString.append("<prev_two_order><![CDATA[").append(maxTwoOrder).append("]]></prev_two_order>\r\n");
			 
			 
			if(quantity != null && quantity.trim().length()!= 0)
			 {
				 double value1= 0d;
				 double qty1 = 0d;
				 double discPerc = 0d;
				 qty1= Double.parseDouble(quantity);
				 rate1=Double.parseDouble(rate);
				 if(discount != null && discount.trim().length()!= 0)
				 {
					 discPerc= Double.parseDouble(discount);
				 }
				 value1 = qty1 * rate1;
				 if(discount != null && discount.trim().length()!= 0)
				 {
					 value1 = qty1 * rate1 - (discPerc * value1 /100);
				 }
				 valueXmlString.append("<value><![CDATA[" ).append(df.format(value1)).append( "]]></value>\r\n" );
			 }
			 else
			 {
				 //System.out.println(" Else if>::::==["+ value+"]");
				 valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
			 }
			if(stock != null && stock.trim().length()!= 0)
			 {
				 //System.out.println(" rate>::::==["+ rate+"],stock["+stock+"]");
				 double stkValue= 0d;
				 double stockVal = 0d;
				 rate1=Double.parseDouble(rate);
				 stockVal= Double.parseDouble(stock);
				 stkValue = stockVal * rate1;
				 valueXmlString.append("<stock_value><![CDATA[" ).append(df.format(stkValue)).append( "]]></stock_value>\r\n" );
			 }
			 else
			 {
				 valueXmlString.append("<stock_value><![CDATA[" ).append(stockValue).append( "]]></stock_value>\r\n" );
			 }
				/*
				String codeSql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ?";
				pstmt1=conn.prepareStatement(codeSql);
				pstmt1.setString(1,strgCode);
				rs1  = pstmt1.executeQuery();
				if(rs1.next())
				{
					strgCustCnt = rs1.getInt("COUNT");

				}
				if(rs1!=null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//HashMap itemAttribMap = darCommonBean.getItemAttributeDetails(conn,sql,bindValue, strgCustCnt, "'"+strgCode+"'", paramValue, sprsCnt);
				*/
				String itemSize = "";
				String itemAttribute = "";
				String itemUnit = "";
				String shortDescrFromUom= "";
				if(itemAttribMap != null && !itemAttribMap.isEmpty() && itemAttribMap.size() > 0 && itemAttribMap.containsKey(itemCode))
				{
					HashMap attribMap = (HashMap)itemAttribMap.get(itemCode);
					if(attribMap != null && !attribMap.isEmpty() && attribMap.size() > 0)
					{
						itemSize = (String)attribMap.get("ITEM_SIZE");
						itemAttribute = (String)attribMap.get("ITEM_ATTRIBUTE");
						itemUnit = checkNull(rs.getString("ITEM_UNIT"));
						shortDescrFromUom = getShortDescrFromUom(itemUnit,conn);
					}
				}
				ArrayList<String> nonEcoProductList=getNonEcoProductCustomer(productCode,conn);
				ArrayList<String> nonEcoItemList=getNonEcoItemCustomer(itemCode,productCode,conn);

				ArrayList<String> focusProductList=getFocusProductCustomer(productCode,conn);
				ArrayList<String> focusItemList=getFocusItemCustomer(itemCode,productCode,conn);

				if(mode.equals("V"))
				{
				valueXmlString.append("<quantity protect='1'>").append(rs.getInt("QUANTITY")).append("</quantity>\n");
				valueXmlString.append( "<disc_perc protect='1'><![CDATA[" ).append(checkNull(rs.getString("DISC_PERC"))).append( "]]></disc_perc>\r\n" );
				valueXmlString.append( "<promo_perc protect='1'><![CDATA[" ).append(checkNull(rs.getString("PROMO_PERC"))).append( "]]></promo_perc>\r\n" );
				valueXmlString.append( "<remarks_ord protect='1'><![CDATA[" ).append(checkNull(rs.getString("REMARKS_ORD"))).append( "]]></remarks_ord>\r\n" );
				valueXmlString.append( "<rate protect='1'><![CDATA[" ).append(checkNull(rs.getString("RATE"))).append( "]]></rate>\r\n" );
				}
				else if(mode.equals("E"))
				{	
				valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");
				valueXmlString.append( "<disc_perc><![CDATA[" ).append(checkNull(rs.getString("DISC_PERC"))).append( "]]></disc_perc>\r\n" );
				valueXmlString.append( "<promo_perc><![CDATA[" ).append(checkNull(rs.getString("PROMO_PERC"))).append( "]]></promo_perc>\r\n" );
				valueXmlString.append( "<remarks_ord><![CDATA[" ).append(checkNull(rs.getString("REMARKS_ORD"))).append( "]]></remarks_ord>\r\n" );
				valueXmlString.append( "<rate><![CDATA[" ).append(checkNull(rs.getString("RATE"))).append( "]]></rate>\r\n" );
				}
				valueXmlString.append("<item_code visible='0' ><![CDATA[").append(itemCode).append("]]></item_code>\n");
				valueXmlString.append("<strg_code visible='0'><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no visible='0'><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
				valueXmlString.append("<scheme_code visible='0'><![CDATA[").append(checkNull(rs.getString("SCHEME_CODE"))).append("]]></scheme_code>\n");
				//valueXmlString.append("<value>").append(checkNull(rs.getString("VALUE"))).append("</value>\n");
				valueXmlString.append("<stockist_code visible='0'><![CDATA[").append(checkNull(rs.getString("STOCKIST_CODE"))).append("]]></stockist_code>\n");
				valueXmlString.append( "<dcr_id visible='0'><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<landing_rate><![CDATA[" ).append(checkNull(rs.getString("RATE"))).append( "]]></landing_rate>\r\n" );
				valueXmlString.append( "<disc_perc><![CDATA[" ).append(checkNull(rs.getString("DISC_PERC"))).append( "]]></disc_perc>\r\n" );
				
				valueXmlString.append("<lot_no visible='0'><![CDATA[").append(checkNull(rs.getString("LOT_NO"))).append( "]]></lot_no>\r\n" );
				valueXmlString.append("<stock_value><![CDATA[" ).append("").append( "]]></stock_value>\r\n" );
				valueXmlString.append("<tooltip_descr><![CDATA[").append(item).append("]]></tooltip_descr>\r\n");
				valueXmlString.append("<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
				valueXmlString.append("<sales_pers><![CDATA[").append(salesPerson).append("]]></sales_pers>\r\n");
				valueXmlString.append("<product_code><![CDATA[").append(checkNull(rs.getString("PRODUCT_CODE"))).append("]]></product_code>\r\n");
				valueXmlString.append("<product_descr><![CDATA[").append( checkNull(rs.getString("PRODUCT_DESCR")) ).append("]]></product_descr>\r\n");
				valueXmlString.append("<is_product_eco><![CDATA[").append(nonEcoProductList).append("]]></is_product_eco>\r\n");
				valueXmlString.append("<is_item_eco><![CDATA[").append(nonEcoItemList).append("]]></is_item_eco>\r\n");
				valueXmlString.append("<is_focus_product><![CDATA[").append(focusProductList).append("]]></is_focus_product>\r\n");
				valueXmlString.append("<is_focus_item><![CDATA[").append(focusItemList).append("]]></is_focus_item>\r\n");
				valueXmlString.append("<item_size><![CDATA[").append( itemSize +"#"+ shortDescrFromUom ).append("]]></item_size>\r\n");
				valueXmlString.append("<item_attrib_descr><![CDATA[").append( itemAttribute ).append("]]></item_attrib_descr>\r\n");
				
				valueXmlString.append( "<stock_qty protect='1'><![CDATA[" ).append(checkNull(rs.getString("STOCK_QTY"))).append( "]]></stock_qty>\r\n" );
				valueXmlString.append( "<stock_info visible='0'><![CDATA[" ).append(checkNull(rs.getString("STOCK_INFO"))).append( "]]></stock_info>\r\n" ); 
				valueXmlString.append( "<promo_code visible='0'><![CDATA[" ).append(checkNull(rs.getString("PROMO_CODE"))).append( "]]></promo_code>\r\n" );
				valueXmlString.append("<min_quantity><![CDATA[").append(minQunt).append("]]></min_quantity>\r\n");
				valueXmlString.append("<description visible='0'><![CDATA[").append("").append("]]></description>\r\n");
				valueXmlString.append("<focus_devi_reas visible='0'><![CDATA[").append("").append("]]></focus_devi_reas>\r\n");
				valueXmlString.append("<description_t visible='0'><![CDATA[]]></description_t>\r\n");
				valueXmlString.append("<focus_devi_reas_t visible='0'><![CDATA[]]></focus_devi_reas_t>\r\n");
				valueXmlString.append( "<stock_info_t visible='0'><![CDATA[]]></stock_info_t>\r\n" ); 
				valueXmlString.append( "<promo_code_t visible='0'><![CDATA[]]></promo_code_t>\r\n" );
				valueXmlString.append( "<lot_no_t visible='0'><![CDATA[]]></lot_no_t>\r\n" );
				valueXmlString.append( "<expiry_date visible='0'><![CDATA[]]></expiry_date>\r\n" );
				valueXmlString.append( "<expiry_date_t visible='0'><![CDATA[]]></expiry_date_t>\r\n" );
				
				
				 
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :Realtime View :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}

	private String getSalesExistingTeamDetail(String tranId,Connection conn,String formNo,String formName) throws ITMException
	{

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		String memberName="",memberCode="";
		try
		{
			String smiQuery = "";

			smiQuery= "SELECT DISTINCT ST.TRAN_ID AS TRAN_ID,ST.DCR_ID AS DCR_ID, ST.SALES_PERS AS SALES_PERS ,ST.STRG_CODE AS STRG_CODE , UPPER(EMP.EMP_FNAME) ||' ' ||UPPER(EMP.EMP_MNAME) ||' '|| UPPER(EMP.EMP_LNAME) AS EMP_NAME, " +
					"EMP.DESIGNATION DESIGNATION,ST.LINE_NO,ST.MEMBER_TYPE AS MEMBER_TYPE,ST.MEMBER_NAME AS MEMBER_NAME,ST.MEM_CODE,ST.TEAM_MOBILE_NO FROM STRG_MEET_TEAM ST LEFT OUTER JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE " +
					"WHERE ST.TRAN_ID=?";

            pstmt = conn.prepareStatement(smiQuery);
            pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String salesPers = checkNull(rs.getString("SALES_PERS"));
				String dispName = checkNull(getEmpNameDesign(salesPers,conn));
				String empDesign = getDesignName(salesPers, conn); 
				memberName = checkNull(rs.getString("MEMBER_NAME"));
				memberCode = checkNull(rs.getString("MEM_CODE"));
				String name =checkNull(rs.getString("EMP_NAME"));
				if(memberName==null || memberName.trim().length()==0)
				{
					memberName=getEmpName(salesPers, conn);
				}
				if(name==null || name.trim().length()==0)
				{
					name=memberName;
				}
				
				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<name>").append(name).append("</name>\n");
				valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(rs.getString("SALES_PERS"))).append("]]></sales_pers>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<line_no><![CDATA[" ).append(checkNull(rs.getString("LINE_NO"))).append( "]]></line_no>\r\n" );
				valueXmlString.append( "<member_type visible='0'><![CDATA[" ).append(checkNull(rs.getString("MEMBER_TYPE"))).append( "]]></member_type>\r\n" );
				valueXmlString.append( "<member_name visible='0' protect='1'><![CDATA[" ).append(memberName).append( "]]></member_name>\r\n" );
				valueXmlString.append( "<mem_code visible='0'><![CDATA[" ).append(memberCode).append( "]]></mem_code>\r\n" );
				valueXmlString.append("<team_mobile_no protect='1'><![CDATA[").append( checkNull(rs.getString("TEAM_MOBILE_NO")) ).append("]]></team_mobile_no>\r\n");
				valueXmlString.append("<sales_pers_sp_name><![CDATA[").append(name).append("]]></sales_pers_sp_name>\r\n");
				valueXmlString.append("<employee_designation><![CDATA[").append( empDesign ).append("]]></employee_designation>\r\n");
				valueXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
				valueXmlString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
				valueXmlString.append("<visited_with_display><![CDATA[" ).append(checkNull(dispName)).append( "]]></visited_with_display>\r\n" );
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	
	public String getSampleExistingItemsDetail( String tranId,Connection conn,String formNo,String formName)throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String subSql = "";
		
		HashMap<String, String> itemUsageMap = new HashMap<String, String>();
		DARCommonBean dcb = new DARCommonBean();
		itemUsageMap = dcb.getItemUsageData(conn);
		
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			
		
		subSql="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.QUANTITY, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID,ITEM.UNIT, SMO.TRAN_ID AS TRAN_ID,ITEM_USAGE AS ITEM_USAGE "
				+ "FROM STRG_MEET_ITEMS SMO, ITEM ITEM WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE AND SMO.TRAN_ID =?";
		
		pstmt = conn.prepareStatement(subSql);
		pstmt.setString(1,tranId);
		rs = pstmt.executeQuery();
		
		while(rs.next())
		{


			String item = checkNull(rs.getString("ITEMDESCR"));
			String itemUnit = checkNull(rs.getString("UNIT"));
			String descr="";
			if ( itemUsageMap.get( (rs.getString("ITEM_USAGE")).trim()) != null )
			{
				descr=itemUsageMap.get((rs.getString("ITEM_USAGE")).trim());
			}
			

			valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
			valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
			if( !item.equals("") )
			{
				valueXmlString.append("<item_descr><![CDATA[").append(item).append("]]></item_descr>\n");
			}

			valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
			valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
			valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
			valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
			valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
			valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
			valueXmlString.append( "<item_unit><![CDATA[" ).append(itemUnit).append( "]]></item_unit>\r\n" );
			valueXmlString.append( "<item_usage><![CDATA[" ).append(descr).append( "]]></item_usage>\r\n" );//added by prachi

			valueXmlString.append( "</Detail"+formNo+">\r\n" );
			domID++;
		
		}
		if (rs!= null)
		{
			rs.close();
			rs = null;
		}
		if(pstmt!=null)
		{
			pstmt.close();
			pstmt = null;
		}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
       		}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
		
	}
	
	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			//System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			//System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			//System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}
	
	public String getExistingPitchForDoctor(String tranId,Connection conn,String formNo,String formName,String salePersCode,String localityCode,String copyPlan,String scCode,String wrkDate) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "", sdQuery = "", pitchDetData ="";
		ResultSet rs1 = null;
		PreparedStatement pstmt1 = null;
		String attachment="";
		
		try
		{
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
			if(localityCode != null)
			{
				localityCode="'"+localityCode+"'";
				if(localityCode.indexOf(",")!= -1)
				{
					localityCode = localityCode.replaceAll(",", "','");
				}
			}
			else
			{
				localityCode="''";
			}
			HashMap<String, String> documentMap=new HashMap<String, String>();
			documentMap=getDocumentList(salePersCode,localityCode,copyPlan,scCode,wrkDate,conn);
			

			sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SB.TRAN_ID=?";
			
			pstmt = conn.prepareStatement(sdQuery);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String brand = checkNull(rs.getString("BRAND_DESCR"));
				String brandCode = checkNull(rs.getString("BRAND_CODE"));
				String pitchDet = checkNull(rs.getString("PITCH_DETAIL"));
				String custCode = checkNull( rs.getString("SC_CODE") );
				String workDate = rs.getString("WORK_DATE");
				Date evntDate = dbFormat.parse(workDate);
				workDate = dtFormat.format(evntDate);
				String pitchDetDescr ="";
								String pitchDetSql = "SELECT FLD_VALUE AS PITCH_DETAIL, DESCR AS PITCH_DETAIL_DESCR FROM GENCODES WHERE FLD_NAME = 'PITCH_DETAIL' AND MOD_NAME = 'W_WSFA_FORTUNE' "
						+ "AND ACTIVE = 'Y' AND FLD_VALUE=?";
				pstmt1 = conn.prepareStatement(pitchDetSql);
				pstmt1.setString(1,pitchDet);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					pitchDetDescr = checkNull(rs1.getString("PITCH_DETAIL_DESCR"));

				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}

				
				valueXmlString.append( "<Detail"+formNo+" dbID='' domID='"+ domID +"' objContext='"+formNo+"' objName='' selected='Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
				valueXmlString.append("<selectbox><![CDATA[").append(true).append("]]></selectbox>\r\n");
				valueXmlString.append( "<work_date><![CDATA[" ).append(checkNull(workDate)).append( "]]></work_date>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[").append( checkNull( rs.getString("SALES_PERS") ) ).append("]]></sales_pers>\n");
				valueXmlString.append( "<sc_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></sc_code>\r\n");
				valueXmlString.append( "<strg_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></strg_code>\r\n");

				valueXmlString.append( "<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
				valueXmlString.append( "<pitch_detail><![CDATA[").append(checkNull(rs.getString("PITCH_DETAIL"))).append("]]></pitch_detail>\r\n" );
				valueXmlString.append( "<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
				valueXmlString.append( "<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
				valueXmlString.append( "<remarks><![CDATA[]]></remarks>\r\n" );
				valueXmlString.append( "<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

				valueXmlString.append( "<pitch_sequence><![CDATA[").append(checkNull(rs.getString("PITCH_SEQUENCE"))).append("]]></pitch_sequence>\n");

				valueXmlString.append( "<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				valueXmlString.append( "<item_descr protect =\"1\"><![CDATA[").append("").append("]]></item_descr>\n");
				valueXmlString.append( "<brand_descr protect =\"1\"><![CDATA[").append(brand).append("]]></brand_descr>\n");
				valueXmlString.append( "<brand_type><![CDATA[]]></brand_type>\r\n" );
				valueXmlString.append( "<cur_val><![CDATA[]]></cur_val>\r\n" );
				valueXmlString.append( "<cur_nos><![CDATA[]]></cur_nos>\r\n" );
				valueXmlString.append( "<source><![CDATA[]]></source>\r\n" );
				valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull(rs.getString("TRAN_ID")) ).append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[" ).append( checkNull(rs.getString("DCR_ID")) ).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<call_outcome_data><![CDATA[" ).append("").append( "]]></call_outcome_data>\r\n" );
				valueXmlString.append( "<call_outcome><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
				valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( pitchDetDescr ).append( "]]></pitch_detail_descr>\r\n" );
				valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( checkNull( rs.getString("SC_CODE") ) ).append( "]]></sc_code_pitch>\r\n" );
				
				if(documentMap!=null && !documentMap.isEmpty() && (documentMap.containsValue(brandCode) || documentMap.containsValue("STRG_CODE")))
				{
					for (Entry<String, String> documentEntry: documentMap.entrySet())
					{
						
						if(brandCode.equals(documentEntry.getValue()) || "STRG_CODE".equalsIgnoreCase(documentEntry.getValue()))
						{
							String documentKey=documentEntry.getKey();
							String docPageInfo = "";
							String [] splitMapKey=documentKey.split("@");
							
							String docId=checkNull(splitMapKey[0]);
							String docName=checkNull(splitMapKey[1]);
							if(splitMapKey[3].trim().length()>0)
							{
								docPageInfo = checkNull(splitMapKey[3]); //commented and added by rupali on 30/07/18 for adding page_info in contents
							}
							String docRefId=checkNull(splitMapKey[4]);
							
							if(attachment==null || attachment.trim().length()==0)
							{
								
								attachment = docId + "::" + docName + "::" + docPageInfo + "~SEP~";
							}
							else
							{
								//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
								//attachment=attachment+docId + "::" +docName + ",";
								// attachment=attachment+docId + "::" +docName + "::" +docPageInfo +",";
								attachment = attachment + docId + "::" + docName + "::" + docPageInfo + "~SEP~";
								//commented and added by rupali on 30/07/18 for adding page_info in contents [end]

							}
							//System.out.println("Attachment iss:"+attachment);

						}

					}
					
					// if(attachment != null && attachment.length() > 0 && attachment.charAt(attachment.length() - 1) == ',')
					if(attachment != null && attachment.length() > 0 && attachment.endsWith("~SEP~"))
					{
						attachment = attachment.substring(0, attachment.length() - 5);
					}

					valueXmlString.append("<contents><![CDATA[").append(attachment).append("]]></contents>\n");
				}
				else
				{
					
					valueXmlString.append("<contents><![CDATA[").append("").append("]]></contents>\n");
				}

				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :RealtimeView :getExistingPitchForDoctor :" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealtimeView :getExistingPitchForDoctor :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	
	public String getExistingDndDetailDisplay(String tranId,Connection conn,String formNo,String formName,String spCode,String eventDate,String editflag) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			
			
			if ( eventDate != null )
			{
				eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}
			
			String displaySql = "SELECT STD.DCR_ID, STD.LINE_NO, STD.STRG_CODE, STD.DOC_ID, STD.DOC_ID_1, STD.DISPLAY_AREA ," +
					"STD.TRAN_ID,STD.DISP_TYPE, STD.BRAND_CODE,STD.QUANTITY, DT.ITEM_OPTION, DET.REMARKS, DET.TARGET_QTY,B.DESCRIPTION " +
					"FROM STRG_ITEM_DISPLAY STD LEFT OUTER JOIN DISPLAY_TYPE DT ON STD.DISP_TYPE = DT.DISP_TYPE " +
					"LEFT OUTER JOIN DND_DEAL DEAL ON STD.STRG_CODE = DEAL.STRG_CODE AND DEAL.SALES_PERS = ? AND DEAL.EFF_FROM <= ? AND DEAL.VALID_UPTO >= ? " +
					"LEFT OUTER JOIN DND_DEAL_DET DET ON STD.BRAND_CODE = DET.BRAND_CODE AND DEAL.TRAN_ID = DET.TRAN_ID " +
					"LEFT OUTER JOIN BRAND B ON B.BRAND_CODE = STD.BRAND_CODE WHERE STD.TRAN_ID=?";

			pstmt = conn.prepareStatement(displaySql);
			pstmt.setString(1, spCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(4,tranId);
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String lineno= checkNull(rs.getString("LINE_NO"));
				valueXmlString.append("<Detail"+formNo+" domID='" + lineno + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<selectbox><![CDATA[").append(true).append("]]></selectbox>\r\n");
				
				valueXmlString.append("<dcr_id visible='0'><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no visible='0'><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code visible='0'><![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]></strg_code>\n");
				
				if(editflag.equals("V"))
				{
					valueXmlString.append("<doc_id protect='1' visible='1'><![CDATA[").append(checkNull(rs.getString("DOC_ID"))).append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1 visible='1'><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area protect='1'><![CDATA[").append( checkNull(rs.getString("DISPLAY_AREA")) ).append("]]></display_area>\r\n");
				}
				else if(editflag.equals("E"))
				{
					valueXmlString.append("<doc_id visible='1'><![CDATA[").append(checkNull(rs.getString("DOC_ID"))).append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1 visible='1'><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append( checkNull(rs.getString("DISPLAY_AREA")) ).append("]]></display_area>\r\n");
				}
				valueXmlString.append("<brand_descr visible='0'><![CDATA[").append("").append("]]></brand_descr>\r\n");
				valueXmlString.append("<disp_type visible='0'><![CDATA[").append( checkNull(rs.getString("DISP_TYPE")) ).append("]]></disp_type>\r\n");
				valueXmlString.append("<brand_code visible='0'><![CDATA[").append( checkNull(rs.getString("BRAND_CODE")) ).append("]]></brand_code>\r\n");                                       //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form
				valueXmlString.append("<quantity visible='0'><![CDATA[").append( checkNull(rs.getString("QUANTITY")) ).append("]]></quantity>\r\n");
				valueXmlString.append( "<tran_id visible='0'><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );//GULZAR ON 04/07/17
				valueXmlString.append( "<target_qty visible='0'><![CDATA[" ).append(checkNull(rs.getString("TARGET_QTY"))).append( "]]></target_qty>\r\n" ); // commentted and added by rupali on 19/01/19 for edit mode of display subform
				valueXmlString.append("</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(valueXmlString.toString().trim().length()==0 && editflag.equals("E"))
			{
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<dcr_id visible='0'><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no visible='0'><![CDATA[").append(domID).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code visible='0'><![CDATA[").append("").append("]]></strg_code>\n");
				valueXmlString.append("<doc_id visible='1'><![CDATA[").append("").append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1 visible='1'><![CDATA[").append("").append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append("").append("]]></display_area>\r\n");
				valueXmlString.append("<brand_descr visible='0'><![CDATA[").append("").append("]]></brand_descr>\r\n");
				valueXmlString.append("<disp_type visible='0'><![CDATA[").append("").append("]]></disp_type>\r\n");
				valueXmlString.append("<brand_code visible='0'><![CDATA[").append("").append("]]></brand_code>\r\n");                                     
				valueXmlString.append("<quantity visible='0'><![CDATA[").append("").append("]]></quantity>\r\n");
				valueXmlString.append( "<tran_id visible='0'><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<target_qty visible='0'><![CDATA[" ).append("").append( "]]></target_qty>\r\n" );
		
				valueXmlString.append("</Detail"+formNo+">\r\n" );
			}	
		}
		catch(Exception e)
		{
			System.out.println( "Exception :Realtime View :getExistingDndDetailDisplay :" + e.getMessage() + ":" );
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealtimeView :getExistingDndDetailDisplay :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	
	public String getExistingSurveyDetail(String tranId,Connection conn,String formNo,String formName) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		String surveyQuery="";
		String resultType = "";
		String result = "";
		StringBuffer valueXmlString = new StringBuffer();

		try
		{
			int lineNo = 0;
			surveyQuery="SELECT SSR.LINE_NO,SSR.STRG_CODE,SSR.SURVEY_CODE,SSR.CONTEXT,SSR.RESULT, ITEM.DESCR AS CONTEXT_DESCR, ITEM.SH_DESCR AS CONTEXT_SH_DESCR, SM.DESCR AS SURVEY_DESCR, SM.RESULT_TYPE RESULT_TYPE, SM.SURVEY_METADATA SURVEY_METADATA,SM.RESULT_FORMAT RESULT_FORMAT"
					+" ,SSR.DOC_ID_2,SSR.DCR_ID,SG.SH_DESCR AS SH_DESCR"
					+" FROM STRG_SURV_RES SSR,ITEM ITEM, SURVEY_MASTER SM,SURVEY_GROUP SG"
					+" WHERE SSR.CONTEXT = ITEM.ITEM_CODE(+) "
					+" AND SSR.SURVEY_CODE = SM.SURVEY_CODE(+) AND SM.SURVEY_GROUP = SG.SURVEY_GROUP(+) "
					+" AND SSR.TRAN_ID = ? order by SG.SH_DESCR,SM.DESCR";

			pstmt = conn.prepareStatement(surveyQuery);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				lineNo = rs.getInt("LINE_NO");
				String surveyMetadata = checkNull(rs.getString("SURVEY_METADATA"));
				String resultFormat  = checkNull(rs.getString("RESULT_FORMAT"));
				resultType = checkNull(rs.getString("RESULT_TYPE"));
				result = checkNull(rs.getString("RESULT"));


				valueXmlString.append("<Detail"+formNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
				valueXmlString.append("<selectbox><![CDATA[").append(true).append("]]></selectbox>\r\n");
				
				valueXmlString.append("<survey_code><![CDATA[").append(checkNull(rs.getString("SURVEY_CODE"))).append("]]></survey_code>\n");
				valueXmlString.append("<survey_descr><![CDATA[").append(checkNull(rs.getString("SURVEY_DESCR"))).append("]]></survey_descr>\n");
				valueXmlString.append("<context><![CDATA[").append(checkNull(rs.getString("CONTEXT"))).append("]]></context>\n");
				valueXmlString.append("<context_descr><![CDATA[").append(checkNull(rs.getString("CONTEXT_SH_DESCR"))).append("]]></context_descr>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<result protect='1'><![CDATA[").append(result).append("]]></result>\r\n");
				valueXmlString.append("<result_type><![CDATA[").append(resultType).append("]]></result_type>\r\n");
				valueXmlString.append("<meta_data><![CDATA[").append(checkNull(rs.getString("SURVEY_METADATA"))).append("]]></meta_data>\r\n");
				valueXmlString.append("<survey_group_descr><![CDATA[").append(checkNull(rs.getString("SH_DESCR"))).append("]]></survey_group_descr>\r\n");
				
				if("N".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");    //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '1' protect='1' ddlblist='"+surveyMetadata+"'><![CDATA[").append(result).append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("L".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0' protect='1'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0' protect='1'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("T".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("D".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("A".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result5>\r\n");
				}
				else
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				valueXmlString.append("<line_no><![CDATA[").append( lineNo).append("]]></line_no>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[").append(checkNull(rs.getString("DCR_ID"))).append("]]></dcr_id>\r\n");
				valueXmlString.append("<doc_id_2><![CDATA[").append(checkNull(rs.getString("DOC_ID_2"))).append("]]></doc_id_2>\r\n");//Added by kailash on 11-12-18.
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getExistingSurveyDetail :getExistingSurveyDetail(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getExistingSurveyDetail :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	
	public String getExistingCoachingDetail(String tranId,Connection conn,String formNo,String formName,String visitedWith) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		String surveyQuery="";
		String resultType = "";
		String result = "",sprsCodeWrkWith="";
		StringBuffer valueXmlString = new StringBuffer();

		try
		{
			int lineNo = 0;

			surveyQuery="SELECT SCR.LINE_NO,SCR.STRG_CODE,SCR.SURVEY_CODE,SCR.CONTEXT,SCR.RESULT, ITEM.DESCR AS CONTEXT_DESCR, ITEM.SH_DESCR AS CONTEXT_SH_DESCR, SM.DESCR AS SURVEY_DESCR, SM.RESULT_TYPE RESULT_TYPE, SM.SURVEY_METADATA SURVEY_METADATA,SM.RESULT_FORMAT,"
					+" SCR.DOC_ID_1,SCR.DCR_ID,SCR.SPRS_CODE__WW "
					+" FROM SPRS_COACHING SCR,ITEM ITEM, SURVEY_MASTER SM "
					+" WHERE SCR.CONTEXT = ITEM.ITEM_CODE(+) "
					+" AND SCR.SURVEY_CODE = SM.SURVEY_CODE(+) "
					+" AND SCR.TRAN_ID = ? ";

			pstmt = conn.prepareStatement(surveyQuery);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				lineNo = rs.getInt("LINE_NO");
				String surveyMetadata = checkNull(rs.getString("SURVEY_METADATA"));
				resultType = checkNull(rs.getString("RESULT_TYPE"));
				result = checkNull(rs.getString("RESULT"));
				sprsCodeWrkWith = checkNull(rs.getString("SPRS_CODE__WW"));
				String resultFormat = checkNull(rs.getString("RESULT_FORMAT"));

				valueXmlString.append("<Detail"+formNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
				valueXmlString.append("<visited_with><![CDATA[").append( visitedWith ).append("]]></visited_with>\n");
				valueXmlString.append("<survey_code><![CDATA[").append(checkNull(rs.getString("SURVEY_CODE"))).append("]]></survey_code>\n");
				valueXmlString.append("<survey_descr><![CDATA[").append(checkNull(rs.getString("SURVEY_DESCR"))).append("]]></survey_descr>\n");
				valueXmlString.append("<context><![CDATA[").append(checkNull(rs.getString("CONTEXT"))).append("]]></context>\n");
				valueXmlString.append("<context_descr><![CDATA[").append(checkNull(rs.getString("CONTEXT_SH_DESCR"))).append("]]></context_descr>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<result><![CDATA[").append(result).append("]]></result>\r\n");
				valueXmlString.append("<result_type><![CDATA[").append(resultType).append("]]></result_type>\r\n");
				valueXmlString.append("<meta_data><![CDATA[").append(checkNull(rs.getString("SURVEY_METADATA"))).append("]]></meta_data>\r\n");
				if("N".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");    //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '1' protect='1' ddlblist='"+surveyMetadata+"'><![CDATA[").append(result).append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("L".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("T".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("D".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '1' protect='1' ><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("A".equalsIgnoreCase(resultType))
				{
					if(result.contains("task_descr"))
					{
						JSONObject jsOBj = new JSONObject(result);
						result = jsOBj.getString("task_descr");
						System.out.println("result 5 value is:"+result);
					}
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result5>\r\n");
				}
				else
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '1' protect='1'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				valueXmlString.append("<line_no><![CDATA[").append( lineNo).append("]]></line_no>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[").append(checkNull(rs.getString("DCR_ID"))).append("]]></dcr_id>\r\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\r\n");//Added by kailash on 11-12-18.
				valueXmlString.append("<sprs_code__ww><![CDATA[").append(checkNull( sprsCodeWrkWith )).append("]]></sprs_code__ww>\r\n");
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :Realtime View  :getExistingCoachingDetail(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :Realtime View :getExistingCoachingDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	private String getEmpName(String empCode,Connection conn) throws ITMException
	{
		String name=null;
		String employeCode = null;
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT UPPER(EMP_FNAME) ||' ' ||UPPER(EMP_MNAME) ||' '|| UPPER(EMP_LNAME) AS EMP_NAME,EMP_CODE from employee 	WHERE EMP_CODE= ? ";
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				name = checkNull(rs.getString("EMP_NAME"));
				employeCode = checkNull(rs.getString("EMP_CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return name +"("+employeCode+")";
	}
	
	private ArrayList<String> getNonEcoProductCustomer(String productCode,Connection connectionObject) throws Exception
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		ArrayList<String> nonEcoProScCode=new ArrayList<String>();
		try
		{

			sql="SELECT DISTINCT(STRG_CUST_EXCP.SC_CODE) AS NO_ECO,(CASE WHEN STRG_PROD.LAST_ORDER_DATE IS NOT NULL THEN (TRUNC(SYSDATE) - NVL(TRUNC(STRG_PROD.LAST_ORDER_DATE), SYSDATE+1)) else -1 end )AS DIFF " + 
					" FROM STRG_CUST_EXCEPTION STRG_CUST_EXCP, STRG_PRODUCT STRG_PROD, PRODUCT PROD " + 
					" WHERE STRG_CUST_EXCP.SC_CODE = STRG_PROD.SC_CODE " + 
					" AND STRG_CUST_EXCP.PRODUCT_CODE = STRG_PROD.PRODUCT_CODE " + 
					" AND PROD.PRODUCT_CODE = STRG_PROD.PRODUCT_CODE " + 
					" AND STRG_CUST_EXCP.PRODUCT_CODE =? " +
					" AND (STRG_CUST_EXCP.ITEM_CODE IS NULL OR UPPER(STRG_CUST_EXCP.ITEM_CODE) = 'NULL') " +
					" AND (STRG_PROD.ITEM_CODE IS NULL OR UPPER(STRG_PROD.ITEM_CODE) = 'NULL') " +
					" AND EXCEP_FLAG = '1'";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,productCode);
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				String customerCodes=checkNull(rs.getString("NO_ECO"));
				int days = rs.getInt("DIFF"); 
				nonEcoProScCode.add(customerCodes+"@"+days);

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return nonEcoProScCode;
	}

	private ArrayList<String> getNonEcoItemCustomer(String itemCode,String productCode,Connection connectionObject) throws Exception
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		ArrayList<String> nonEcoItemScCode=new ArrayList<String>();
		try
		{
			sql="SELECT DISTINCT(STRG_CUST_EXCP.SC_CODE) AS NO_ECO,(CASE WHEN STRG_PROD.LAST_ORDER_DATE IS NOT NULL THEN (TRUNC(SYSDATE) - NVL(TRUNC(STRG_PROD.LAST_ORDER_DATE), SYSDATE+1)) else -1 end )AS DIFF, "+
					" STRG_PROD.MIN_QTY AS MIN_QTY " + 
					" FROM STRG_CUST_EXCEPTION STRG_CUST_EXCP, STRG_PRODUCT STRG_PROD, ITEM ITEM " + 
					" WHERE STRG_CUST_EXCP.SC_CODE = STRG_PROD.SC_CODE " + 
					" AND STRG_CUST_EXCP.PRODUCT_CODE = STRG_PROD.PRODUCT_CODE  "+
					" AND STRG_CUST_EXCP.ITEM_CODE = STRG_PROD.ITEM_CODE "+
					" AND ITEM.ITEM_CODE = STRG_PROD.ITEM_CODE " + 
					" AND STRG_CUST_EXCP.PRODUCT_CODE =? AND STRG_CUST_EXCP.ITEM_CODE =? " +
					" AND (STRG_PROD.ITEM_CODE IS NOT NULL OR UPPER(STRG_PROD.ITEM_CODE) != 'NULL') " +						
					" AND EXCEP_FLAG = '1'";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,productCode);
			pstmt.setString(2,itemCode);
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				String customerCodes=checkNull(rs.getString("NO_ECO"));
				int days = rs.getInt("DIFF"); 
				int minQuan = rs.getInt("MIN_QTY"); 
				nonEcoItemScCode.add(customerCodes+"@"+days+"@"+minQuan);
			}
			//added by mrnunalini sinkar on 11-04-2018(start)
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return nonEcoItemScCode;
	}
	private ArrayList<String> getFocusProductCustomer(String productCode,Connection connectionObject) throws Exception
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		ArrayList<String> focusProductCustomerList=new ArrayList<String>();
		try
		{
			sql="SELECT DISTINCT(SC_CODE) AS FOCUS_SC_CODE FROM STRG_PRODUCT WHERE PRODUCT_CODE=? AND ITEM_CODE IS NOT NULL";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,productCode);
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				String customerCodes=checkNull(rs.getString("FOCUS_SC_CODE"));
				focusProductCustomerList.add(customerCodes);

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return focusProductCustomerList;
	}
	private ArrayList<String> getFocusItemCustomer(String itemCode,String productCode,Connection connectionObject) throws Exception
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		ArrayList<String> focusItemCustomerList=new ArrayList<String>();
		try
		{

			sql="SELECT DISTINCT(SC_CODE) AS FOCUS_SC_CODE, MIN_QTY AS MIN_QTY FROM STRG_PRODUCT WHERE PRODUCT_CODE=? AND ITEM_CODE =?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,productCode);
			pstmt.setString(2,itemCode);

			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				String customerCodes = checkNull(rs.getString("FOCUS_SC_CODE"));
				int minQuan = rs.getInt("MIN_QTY");
				focusItemCustomerList.add(customerCodes+"@"+minQuan);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return focusItemCustomerList;
	}
	
	private String getShortDescrFromUom(String itemUnit,Connection connectionObject) throws Exception
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String shortDescrFromUom= "";
		try
		{

			sql=" SELECT unit,sh_descr,descr FROM uom where unit = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,itemUnit);
			

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				shortDescrFromUom = checkNull(rs.getString("descr"));
				
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return shortDescrFromUom;
	}
   
	public String getExistingCollectionDetail(String tranId,Connection conn,String formNo,String formName,String mode,String billAmount) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		
		try
		{
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
			String smiQuery = "";

			smiQuery="SELECT * FROM STRG_MEET_COLLECT WHERE TRAN_ID=?";
			pstmt = conn.prepareStatement(smiQuery);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String billdate = rs.getString("BILL_DATE");
				String refDate = rs.getString("REF_DATE");
				Date evntDate = dbFormat.parse(billdate);
				billdate = dtFormat.format(evntDate);
				
				if(refDate!=null && (refDate.trim().length())>0)
				{	
			    	Date refDat = dbFormat.parse(refDate);
				    refDate = dtFormat.format(refDat);
				}
				String payMode= checkNull(rs.getString("PAY_MODE")) ;
				String line_no=checkNull(rs.getString("LINE_NO"));
				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<selectbox><![CDATA[").append(true).append("]]></selectbox>\r\n");
				
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<tran_id><![CDATA[").append( checkNull(rs.getString("TRAN_ID")) ).append("]]></tran_id>\r\n");
				
				valueXmlString.append("<bill_amt><![CDATA[").append(billAmount).append("]]></bill_amt>\r\n");
				valueXmlString.append("<bill_date><![CDATA[").append(billdate).append("]]></bill_date>\r\n");
				
				if(mode.equals("E"))
				{	
				  valueXmlString.append("<pay_mode><![CDATA[").append( checkNull(rs.getString("PAY_MODE")) ).append("]]></pay_mode>\r\n");
				
				  if(payMode.equals("C"))
				  {
				    valueXmlString.append("<ref_no visible='0'><![CDATA[").append( checkNull(rs.getString("REF_NO")) ).append("]]></ref_no>\r\n");
				    valueXmlString.append("<ref_date visible='0'><![CDATA[").append(refDate).append("]]></ref_date>\r\n");
				    valueXmlString.append("<ref_bank visible='0'><![CDATA[").append( checkNull(rs.getString("REF_BANK")) ).append("]]></ref_bank>\r\n");
				  }
				  else
				  {
				    valueXmlString.append("<ref_no><![CDATA[").append( checkNull(rs.getString("REF_NO")) ).append("]]></ref_no>\r\n");
				    valueXmlString.append("<ref_date><![CDATA[").append(refDate).append("]]></ref_date>\r\n");
				    valueXmlString.append("<ref_bank><![CDATA[").append( checkNull(rs.getString("REF_BANK")) ).append("]]></ref_bank>\r\n");
				  }	
				  valueXmlString.append("<amount><![CDATA[").append( checkNull(rs.getString("AMOUNT")) ).append("]]></amount>\r\n");
				  valueXmlString.append("<remarks_collect><![CDATA[").append( checkNull(rs.getString("REMARKS_COLLECT")) ).append("]]></remarks_collect>\r\n");
				}
				else
				{	
				  valueXmlString.append("<pay_mode protect='1'><![CDATA[").append( checkNull(rs.getString("PAY_MODE")) ).append("]]></pay_mode>\r\n");
				
				  if(payMode.equals("C"))
				  {
				    valueXmlString.append("<ref_no protect='1' visible='0'><![CDATA[").append( checkNull(rs.getString("REF_NO")) ).append("]]></ref_no>\r\n");
				    valueXmlString.append("<ref_bank protect='1' visible='0'><![CDATA[").append( checkNull(rs.getString("REF_BANK")) ).append("]]></ref_bank>\r\n");
				    valueXmlString.append("<ref_date protect='1' visible='0'><![CDATA[").append(refDate).append("]]></ref_date>\r\n");
				    
				  }
				  else
				  {
				    valueXmlString.append("<ref_no protect='1'><![CDATA[").append( checkNull(rs.getString("REF_NO")) ).append("]]></ref_no>\r\n");
				    valueXmlString.append("<ref_bank protect='1'><![CDATA[").append( checkNull(rs.getString("REF_BANK")) ).append("]]></ref_bank>\r\n");
				    valueXmlString.append("<ref_date protect='1'><![CDATA[").append(refDate).append("]]></ref_date>\r\n");
				  }	
				  valueXmlString.append("<amount protect='1'><![CDATA[").append( checkNull(rs.getString("AMOUNT")) ).append("]]></amount>\r\n");
				  valueXmlString.append("<remarks_collect protect='1'><![CDATA[").append( checkNull(rs.getString("REMARKS_COLLECT")) ).append("]]></remarks_collect>\r\n");
				}
					
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
		}
		catch(Exception e)
		{
			System.out.println( "Exception :Collection edit mode detials :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :Collection edit mode detials in catch :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	
	public String getExistingInvoiceDetail(String tranId,Connection conn,String formNo,String formName,String salesPers,Document dom2,String strgCode,String pricelist,String mode) throws ITMException
	{
		
		//System.out.println("Inside getExistingInvoiceDetail of Edit mode Invoice:;"+pricelist);
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		PreparedStatement custPrcList =null;
		ResultSet rsCustPrc=null;
		String pricelist2=null;
		String sql="",paramValue="";
		int strgCustCnt = 0;
		try
		{
			
			
			String basicValue = getSelectedRowValue(dom2, "1", "net_amt", 0);
			String gstValue = getSelectedRowValue(dom2, "1", "tax_amount", 0);
			String totalValue = getSelectedRowValue(dom2, "1", "amount", 0);
			
			DecimalFormat df = new DecimalFormat("###.##");
			String smiQuery = "";

			smiQuery="SELECT SMI.LINE_NO,SMI.STRG_CODE,SMI.ITEM_CODE,SMI.QUANTITY, ITEM.DESCR AS ITEMDESCR,ITEM.HSN_NO AS HSN_NO,SMI.DCR_ID, " 
					+" SMI.RATE, SMI.DISC_PERC, SMI.LOT_NO, SMI.TAX_AMT_INV,SMI.NET_AMT,SMI.CURR_STOCK,SMI.REMARKS_INV,SMI.TRAN_ID, ITEM.PRODUCT_CODE AS PRODUCT_CODE,P.DESCR AS PRODUCT_DESCR,ITEM.UNIT AS ITEM_UNIT " 
					+" FROM STRG_MEET_INVOICE SMI, ITEM ITEM "
					+ "LEFT OUTER JOIN PRODUCT P ON ITEM.PRODUCT_CODE = P.PRODUCT_CODE "
					+" WHERE SMI.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMI.TRAN_ID=?";
			pstmt = conn.prepareStatement(smiQuery);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String item = checkNull(rs.getString("ITEMDESCR"));
				String quantity = checkNull(rs.getString("QUANTITY"));
				String rate = checkNull(rs.getString("RATE"));
				String taxAmt = checkNull(rs.getString("TAX_AMT_INV"));
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				String taxAmount = checkNull(rs.getString("TAX_AMT_INV"));
				String hsnNo = checkNull(rs.getString("HSN_NO"));
				
				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				if( !item.equals("") )
				{
					valueXmlString.append("<item_descr><![CDATA[").append(item).append("]]></item_descr>\n");
                }
				else 
				{
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
				}
				valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<rate><![CDATA[" ).append(checkNull(rs.getString("RATE"))).append( "]]></rate>\r\n" );
				valueXmlString.append( "<curr_stock><![CDATA[" ).append(checkNull(rs.getString("CURR_STOCK"))).append( "]]></curr_stock>\r\n" );
				valueXmlString.append( "<net_amt><![CDATA[" ).append(checkNull(rs.getString("NET_AMT"))).append( "]]></net_amt>\r\n" );
				valueXmlString.append( "<tax_amt_inv><![CDATA[" ).append(checkNull(rs.getString("TAX_AMT_INV"))).append( "]]></tax_amt_inv>\r\n" );
				
				if(mode.equals("V"))
				{
					valueXmlString.append( "<quantity protect='1'><![CDATA[" ).append(checkNull(rs.getString("QUANTITY"))).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<remarks_inv protect='1'><![CDATA[" ).append(checkNull(rs.getString("REMARKS_INV"))).append( "]]></remarks_inv>\r\n" );
				}
				else if(mode.equals("E"))
				{
					valueXmlString.append( "<quantity><![CDATA[" ).append(checkNull(rs.getString("QUANTITY"))).append( "]]></quantity>\r\n" );
					valueXmlString.append( "<remarks_inv><![CDATA[" ).append(checkNull(rs.getString("REMARKS_INV"))).append( "]]></remarks_inv>\r\n" );
				}
				if( rate.trim().length()>0 && quantity.trim().length()>0 && taxAmount.trim().length()>0 && quantity != null )
				{
					double tempQuantity = 0d;
					double tempTaxAmt= 0d;
					double tempTotalGst= 0d;
					double selSgstAmt=0d;
					double selCgstAmt=0d;
					double selValueTotal=0d;
					double temprate =0d;
					try
					{
						tempQuantity =Double.parseDouble(quantity);
						temprate =Double.parseDouble(rate);
						tempTaxAmt =Double.parseDouble(taxAmount);
						tempTotalGst=(temprate * tempQuantity);
						selSgstAmt=(temprate * tempQuantity * (tempTaxAmt/200));
						selCgstAmt = selSgstAmt;
						selValueTotal = (tempTotalGst + selCgstAmt + selSgstAmt );
						valueXmlString.append("<value>").append(df.format(tempTotalGst)).append("</value>\n");
						valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(df.format(selSgstAmt)).append( "]]></total_sgst_amount>\r\n" );
						valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(df.format(selCgstAmt)).append( "]]></total_cgst_amount>\r\n" );
						valueXmlString.append("<total_amount><![CDATA[" ).append(df.format(selValueTotal)).append( "]]></total_amount>\r\n" );
						
					}
					catch(NumberFormatException e)
					{
						tempTotalGst=0;
						valueXmlString.append("<value><![CDATA[" ).append(tempTotalGst).append( "]]></value>\r\n" );
						valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_sgst_amount>\r\n" );
						valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_cgst_amount>\r\n" );
						valueXmlString.append("<total_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_amount>\r\n" );
					}
				}
				else
				{
					valueXmlString.append("<value>").append("").append("</value>\n");
					valueXmlString.append("<total_sgst_amount>").append("").append("</total_sgst_amount>\n");
					valueXmlString.append("<total_cgst_amount>").append("").append("</total_cgst_amount>\n");
					valueXmlString.append("<total_amount>").append("").append("</total_amount>\n");
				}
				valueXmlString.append("<basic_value><![CDATA[" ).append( basicValue ).append( "]]></basic_value>\r\n" );
				valueXmlString.append("<total_gst><![CDATA[" ).append( gstValue ).append( "]]></total_gst>\r\n" );
				valueXmlString.append("<total_value><![CDATA[" ).append( totalValue ).append( "]]></total_value>\r\n" );
				valueXmlString.append("<sales_pers><![CDATA[").append(salesPers).append("]]></sales_pers>\r\n");
				valueXmlString.append("<price_list><![CDATA[" ).append( pricelist ).append( "]]></price_list>\r\n" );
				valueXmlString.append("<hsn_number><![CDATA[" ).append( hsnNo ).append( "]]></hsn_number>\r\n" );
				
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :Invoice edit mode detials :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println( "Exception :Invoice edit mode detials in catch :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	
	}
	private ArrayList getMaxDomIdListFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String domID = "";
		ArrayList allSelectedDomIdList = new ArrayList();
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;
			String indexDom = "";

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				domID = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();


				if ( domID.indexOf(":") > 0 )
				{
					String temp [] = domID.split(":");
					if ( temp != null && temp.length > 0 )
					{
						for ( int i=0; i<temp.length; i++)
						{
							indexDom = temp[i];
						}
						indexDom= temp[0];
					}
				}
				else
				{
					indexDom = domID;
				}

				int intDomID = Integer.parseInt(indexDom);
				allSelectedDomIdList.add(intDomID);

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("allSelected Donm id on previous:- "+allSelectedDomIdList);
		return allSelectedDomIdList;
	}
	private String getDomID(Document dom2,String objContext)
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null)
				{
					objName = etlAttributes.getNamedItem("domID").getNodeValue();
				}
			}
		}
		return objName;
	}
	
	private double getBasicValue(Document dom2,String currentFormNo, String value, String strgCode)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
		int parentNodeListLength = parentList.getLength();
		double totalValue = 0d;
		try
		{
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				String Rate = "0";
				String quantity = "0";
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = checkNull(childNode.getNodeName());
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}
					if(childNodeName.equalsIgnoreCase("quantity"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							quantity = checkNull(childNode.getFirstChild().getNodeValue());
							if(quantity.length() == 0)
							{
								quantity = "0";
							}
						}
						else
						{
							quantity = "0";
						}
					}
					else if(childNodeName.equalsIgnoreCase("rate"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							Rate = checkNull(childNode.getFirstChild().getNodeValue());
							if(Rate.length() == 0)
							{
								Rate = "0";
							}
						}
						else
						{
							Rate = "0";
						}
					}
				}
				if(updateFlag != null && updateFlag.trim().length() > 0 && !("D".equalsIgnoreCase(updateFlag)))
				{
					if(quantity != null && quantity.length()> 0 && Rate != null && Rate.length() > 0)
					{
						totalValue = totalValue + (Double.parseDouble(quantity)* Double.parseDouble(Rate));
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("getBasicValue for strgCode "+strgCode+":::["+totalValue+"]");
		return totalValue;
	}
	/*private double getGSTValue(Document dom2,String currentFormNo, String value, String strgCode)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
		int parentNodeListLength = parentList.getLength();
		double totalValue = 0d;
		try
		{
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}
				
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				String Rate = "0";
				String taxAmount="0";
				String quantity = "0";
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = checkNull(childNode.getNodeName());
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}
					if(childNodeName.equalsIgnoreCase("quantity"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							quantity = checkNull(childNode.getFirstChild().getNodeValue());
							if(quantity.length() == 0)
							{
								quantity = "0";
							}
						}
						else
						{
							quantity = "0";
						}
					}
					else if(childNodeName.equalsIgnoreCase("rate"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							Rate = checkNull(childNode.getFirstChild().getNodeValue());
							if(Rate.length() == 0)
							{
								Rate = "0";
							}
						}
						else
						{
							Rate = "0";
						}
					}
					if(childNodeName.equalsIgnoreCase(checkNull("tax_amt_inv")))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{

							taxAmount = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
				}
				if(updateFlag != null && updateFlag.trim().length() > 0 && !("D".equalsIgnoreCase(updateFlag)))
				{
					if(quantity != null && quantity.length()> 0 && Rate != null && Rate.length() > 0)
					{
						totalValue = totalValue + (Double.parseDouble(taxAmount)/100);
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return totalValue;
	}*/
	private double getAmountValue(Document dom2,String currentFormNo, String value, String strgCode)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
		int parentNodeListLength = parentList.getLength();
		double totalValue = 0d;
		try
		{
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}
				
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				String Rate = "0";
				String quantity = "0";
				String taxAmount ="0";
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = checkNull(childNode.getNodeName());
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}
					if(childNodeName.equalsIgnoreCase("quantity"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							quantity = checkNull(childNode.getFirstChild().getNodeValue());
							if(quantity.length() == 0)
							{
								quantity = "0";
							}
						}
						else
						{
							quantity = "0";
						}
					}
					else if(childNodeName.equalsIgnoreCase("rate"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							Rate = checkNull(childNode.getFirstChild().getNodeValue());
							if(Rate.length() == 0)
							{
								Rate = "0";
							}
						}
						else
						{
							Rate = "0";
						}
					}
					if(childNodeName.equalsIgnoreCase(checkNull("tax_amt_inv")))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{

							taxAmount = checkNull(childNode.getFirstChild().getNodeValue());
							System.out.println("tax is ::::["+taxAmount+"]");
							
						}
					}
				}
				if(updateFlag != null && updateFlag.trim().length() > 0 && !("D".equalsIgnoreCase(updateFlag)))
				{
					if(quantity != null && quantity.length()> 0 && Rate != null && Rate.length() > 0)
					{
						totalValue = totalValue + ((Double.parseDouble(quantity)* Double.parseDouble(Rate)) +((Double.parseDouble(quantity)* Double.parseDouble(Rate)) * (Double.parseDouble(taxAmount)/100)));
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("getAmountValue for strgCode "+strgCode+":::["+totalValue+"]");
		return totalValue;
	}
	
	
	/*
	public String getSalesPersTeamList(Document dom,Document dom2, String sprsCode, String strgCode, String selectedTeam, String eventDate, String formNo, String formName ) throws ITMException
	{

		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer selectedXmlString = new StringBuffer();
		StringBuffer unselectedString = new StringBuffer();
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String name = "";
		int maxLineNo = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		String custTranID = null;
		int modeCounter = 0;
		String workWith = "";
		boolean isLocal = false ;
		int num=1;

		//String objName = checkNull(getObjNameFromDom(dom2, "objName",formNo));
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocal = true;
			}
			String objName = "strg_meet_dcr_realtime_wiz"; //added by rupali on 15/09/17 for worked with field
			String parentFormNo = checkNull(getParentformNo(formNo, objName, connectionObject ));
			//	workWith = checkNull(genericUtility.getColumnValue("select_team", dom2, parentFormNo)); //commented by rupali on 18/09/17 for worked with field
			workWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, parentFormNo)); //added by rupali on 15/09/17 for worked with field
			//	System.out.println("Visited with value is +="+workWith);
			List workWithListForm = null;
			String workWithCodeList = "";
			if(workWith != null && workWith.trim().length() > 0)
			{
				String workWithCode[] = workWith.split(",");

				int totalFieldNo = workWithCode.length;

				//System.out.println("totalFieldNo ::"+totalFieldNo);

				for ( int i = 0; i < totalFieldNo; i++ )
				{
					String code = workWithCode[i];
					if(code.indexOf("(") != -1)
					{
						code = code.substring(code.indexOf("(")+1,code.indexOf(")")).trim();
					}

					workWithCodeList = workWithCodeList + code + ",";
				}
				workWithCodeList = workWithCodeList.substring(0, workWithCodeList.lastIndexOf(","));

				//System.out.println( "workWithCodeList ::::: "+ workWithCodeList);
				String wrkWith = workWithCodeList;
				workWithListForm = Arrays.asList(wrkWith.split(","));
				//System.out.println("value in workWithListForm is:- "+workWithListForm);
			}
			//System.out.println("Printing getDrSalesPersTeamList DOM + "+genericUtility.serializeDom(dom)+"+++++++++++++++");
			//System.out.println("Printing getDrSalesPersTeamList DOM222 + "+genericUtility.serializeDom(dom2)+"+++++++++++++++");
			valueXmlString.append( "<Root>\r\n" );
			// added by rupali on 13/04/18 for org_structure related changes [start]
			ArrayList salesPersList = new ArrayList();
			String salesPersTemp="";
			String isOrgStrcture = getSfaParmValue(sprsCode,"HIERARCY_FRM_ORG_STR",connectionObject);
			OrgStructure orgStructure = new OrgStructure();
			String itemSer=checkNull(getItemSer(sprsCode, connectionObject));
			String isFortuneAct = getSfaParmValue(sprsCode,"IS_FORTUNE_ACTIVITY",connectionObject);
			//System.out.println("isFortuneAct is in realtime::::"+isFortuneAct);
			DARCommonBean darCommonBean= new DARCommonBean();
			HashMap<String, String> employeeDesignationMap=darCommonBean.getEmployeeDesignationMap(itemSer,connectionObject);
			//System.out.println("employeeDesignationMap is["+employeeDesignationMap+"]");

			if("Y".equalsIgnoreCase(isOrgStrcture))
			{
				salesPersList = orgStructure.reportToUp(sprsCode,eventDate,connectionObject);
				salesPersTemp = orgStructure.getFormattedList(salesPersList);
			}
			
			//Changed & Added By Vikas Lagad on 23-12-2019 [Changed logic for JNJ_coaching manager in team detail form ]Start
			String teamGradeLevel = "";
			sql = "select parm_value from sfaparm WHERE parm_name = ? and active = ? ";
			PreparedStatement pstmt1= connectionObject.prepareStatement(sql);
			pstmt1.setString(1, "TEAM_GRADE_LEV");
			pstmt1.setString(2, "Y");
			ResultSet rs1= pstmt1.executeQuery();
			
			if(rs1.next())
			{
				teamGradeLevel = checkNull(rs1.getString(1));
			}
			else
			{
				teamGradeLevel = "4";
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			

			String scCodeteam =strgCode.trim();
			if(salesPersList != null && !salesPersList.isEmpty())
			{
				if("Y".equalsIgnoreCase(isFortuneAct))
				{
					sql = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY LEVEL_NO DESC";
				}
				else
				{
					sql = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' " +
							"UNION "+
							"SELECT DISTINCT '3' AS SR_NO,EC.ENTITY_CODE AS STRG_CODE,EC.CONTACT_PERS AS REPORT_TO,'' AS DESIGNATION , " + 
							"EC.CONTACT_PERS_NAME AS NAME , 0 AS LEVEL_NO, EC.MOBILE_NO " + 
							"FROM ENTITY_CONTACT EC, STRG_SERIES SS WHERE EC.ENTITY_TYPE='C' " + 
							"AND EC.ENTITY_CODE=SS.SC_CODE AND SS.SALES_PERS=? AND SS.STATUS='Y' " + 
							"ORDER BY SR_NO,LEVEL_NO DESC";
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
                
				sql1 = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
						"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
						"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
						"UNION "+
						"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
						"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ";	
			}
			else
			{
				ArrayList teamList = new ArrayList();

				String teamSql="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR  REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
				PreparedStatement teamPstmt= connectionObject.prepareStatement(teamSql);
				teamPstmt.setString(1, sprsCode);
				ResultSet teamRs= teamPstmt.executeQuery();
				while(teamRs.next())
				{
					String reportTo=checkNull(teamRs.getString("REPORT_TO"));
					teamList.add(reportTo);
				}
				if(teamPstmt != null)
				{
					teamPstmt.close();
					teamPstmt = null;
				}
				if(teamRs != null)
				{
					teamRs.close();
					teamRs = null;
				}
				
				System.out.println("teamList is:"+teamList);
				
				String salesPersEmp=orgStructure.getFormattedList(teamList);
				if("Y".equalsIgnoreCase(isFortuneAct))
				{
					sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY LEVEL_NO DESC";
				}
				else
				{
					sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+ 
							 "UNION "+
							 "SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							 "FROM ENTITY_CONTACT WHERE ENTITY_TYPE='C' AND ENTITY_CODE ='"+scCodeteam+"' " +
							 "ORDER BY SR_NO,LEVEL_NO DESC";
				}
				
				sql1 = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
						"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
						"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
						"UNION "+
						"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
						"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ";

				
			}
			String teamHierarchy = getTeamFormHierarchy(sql1, connectionObject);
			pstmt = connectionObject.prepareStatement(sql);
			if(!("Y".equalsIgnoreCase(isFortuneAct)))
			{
				pstmt.setString(1,sprsCode);
			}
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String teamCode = checkNull(rs.getString("REPORT_TO"));
				String empDesign = getDesignName(teamCode, connectionObject);
				String mobileNo = checkNull(rs.getString("MOBILE_NO"));
				String stCode = checkNull(rs.getString("STRG_CODE")).trim();
				String empNameDesign = getEmpNameDesign(teamCode, connectionObject);
				String srNo = checkNull(rs.getString("SR_NO")).trim();
				String designation="";
				String empName ="";
				if("2".equalsIgnoreCase(srNo) && !employeeDesignationMap.isEmpty())
				{
					if(employeeDesignationMap.containsKey(teamCode))
					{
						designation=employeeDesignationMap.get(teamCode);

					}
					else
					{
						designation=empDesign;

					}
				}
				else
				{
					designation=empDesign;
				}
				if("3".equalsIgnoreCase(srNo))
				{
					empName = checkNull(rs.getString("NAME")).trim();
				}
				else
				{
					empName = getEmpName(teamCode, connectionObject);
				}
				if(empNameDesign!=null && empNameDesign.trim().length()>0)
				{
					empNameDesign=empNameDesign.substring(0, empNameDesign.lastIndexOf("("));
					empNameDesign=empNameDesign +"("+designation+")";

				}
				if("3".equalsIgnoreCase(srNo))
				{
					empNameDesign = checkNull(rs.getString("NAME")).trim();
				}
				else
				{
					empNameDesign = empNameDesign;
				}
				
				valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
				valueXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[").append( "" ).append("]]></dcr_id>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append( stCode ).append("]]></strg_code>\r\n");
				valueXmlString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
				valueXmlString.append("<member_name visible='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
				valueXmlString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
				valueXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
				valueXmlString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
				valueXmlString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
				valueXmlString.append("<disp_descr visible='0'><![CDATA[" ).append( empDesign ).append("]]></disp_descr>\r\n");
				valueXmlString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
				valueXmlString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");
				valueXmlString.append("<team_mobile_no visible='0'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
				valueXmlString.append("<team_hierarchy_list><![CDATA[" ).append( teamHierarchy ).append("]]></team_hierarchy_list>\r\n");

				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				num++;
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(connectionObject != null && isLocal)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		//System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	
	}
	*/
	
	public String getSalesPersTeamList(Document dom,Document dom2, String sprsCode, String strgCode, String selectedTeam, String eventDate, String formNo, String formName ) throws ITMException
	{

		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer selectedXmlString = new StringBuffer();
		StringBuffer unselectedString = new StringBuffer();
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String name = "";
		int maxLineNo = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		String custTranID = null;
		int modeCounter = 0;
		String workWith = "";
		boolean isLocal = false ;

		//String objName = checkNull(getObjNameFromDom(dom2, "objName",formNo));
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocal = true;
			}
			String objName = "strg_meet_dcr_realtime_wiz"; //added by rupali on 15/09/17 for worked with field
			String parentFormNo = checkNull(getParentformNo(formNo, objName, connectionObject ));
			//	workWith = checkNull(genericUtility.getColumnValue("select_team", dom2, parentFormNo)); //commented by rupali on 18/09/17 for worked with field
			workWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, parentFormNo)); //added by rupali on 15/09/17 for worked with field
			//	System.out.println("Visited with value is +="+workWith);
			List workWithListForm = null;
			String workWithCodeList = "";
			if(workWith != null && workWith.trim().length() > 0)
			{
				String workWithCode[] = workWith.split(",");

				int totalFieldNo = workWithCode.length;

				//System.out.println("totalFieldNo ::"+totalFieldNo);

				for ( int i = 0; i < totalFieldNo; i++ )
				{
					String code = workWithCode[i];
					if(code.indexOf("(") != -1)
					{
						code = code.substring(code.indexOf("(")+1,code.indexOf(")")).trim();
					}

					workWithCodeList = workWithCodeList + code + ",";
				}
				workWithCodeList = workWithCodeList.substring(0, workWithCodeList.lastIndexOf(","));

				//System.out.println( "workWithCodeList ::::: "+ workWithCodeList);
				String wrkWith = workWithCodeList;
				workWithListForm = Arrays.asList(wrkWith.split(","));
				//System.out.println("value in workWithListForm is:- "+workWithListForm);
			}
			//System.out.println("Printing getDrSalesPersTeamList DOM + "+genericUtility.serializeDom(dom)+"+++++++++++++++");
			//System.out.println("Printing getDrSalesPersTeamList DOM222 + "+genericUtility.serializeDom(dom2)+"+++++++++++++++");
			valueXmlString.append( "<Root>\r\n" );
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			/*
			sql1 =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ," +
					"PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";
			 */
			// added by rupali on 13/04/18 for org_structure related changes [start]
			ArrayList salesPersList = new ArrayList();
			String salesPersTemp="";
			String isOrgStrcture = getSfaParmValue(sprsCode,"HIERARCY_FRM_ORG_STR",connectionObject);
			OrgStructure orgStructure = new OrgStructure();
			String itemSer=checkNull(getItemSer(sprsCode, connectionObject));
			String isFortuneAct = getSfaParmValue(sprsCode,"IS_FORTUNE_ACTIVITY",connectionObject);
			//System.out.println("isFortuneAct is in realtime::::"+isFortuneAct);
			DARCommonBean darCommonBean= new DARCommonBean();
			HashMap<String, String> employeeDesignationMap=darCommonBean.getEmployeeDesignationMap(itemSer,connectionObject);
			//System.out.println("employeeDesignationMap is["+employeeDesignationMap+"]");

			if("Y".equalsIgnoreCase(isOrgStrcture))
			{
				salesPersList = orgStructure.reportToUp(sprsCode,eventDate,connectionObject);
				salesPersTemp = orgStructure.getFormattedList(salesPersList);
			}
			
			//Changed & Added By Vikas Lagad on 23-12-2019 [Changed logic for JNJ_coaching manager in team detail form ]Start
			String teamGradeLevel = "";
			sql = "select parm_value from sfaparm WHERE parm_name = ? and active = ? ";
			PreparedStatement pstmt1= connectionObject.prepareStatement(sql);
			pstmt1.setString(1, "TEAM_GRADE_LEV");
			pstmt1.setString(2, "Y");
			ResultSet rs1= pstmt1.executeQuery();
			
			if(rs1.next())
			{
				teamGradeLevel = checkNull(rs1.getString(1));
			}
			else
			{
				teamGradeLevel = "4";
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			

			String scCodeteam =strgCode.trim();
			if(salesPersList != null && !salesPersList.isEmpty())
			{
				//sql1 ="SELECT EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO <='"+teamGradeLevel+"' ORDER BY GRADE.LEVEL_NO DESC";
				/*sql = "SELECT DISTINCT '2' AS SR_NO,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO " + 
						"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
						"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
						"UNION "+
						"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO "+
						 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY SR_NO,LEVEL_NO DESC";*/
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("Y".equalsIgnoreCase(isFortuneAct))
				{
					sql1 = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY LEVEL_NO DESC";
				}
				else
				{	
					//Changes made by Rahul P. on 27-Sep-2023 [Start] set ENTITY_TYPE='R'
					/*sql1 = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+ 
							 "UNION "+
							 "SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							 "FROM ENTITY_CONTACT WHERE ENTITY_TYPE='C' AND ENTITY_CODE ='"+scCodeteam+"' " +
							 "ORDER BY SR_NO,LEVEL_NO DESC";*/
					sql1 = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+ 
							 "UNION "+
							 "SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							 "FROM ENTITY_CONTACT WHERE ENTITY_TYPE='R' AND ENTITY_CODE ='"+scCodeteam+"' " +
							 "ORDER BY SR_NO,LEVEL_NO DESC";
					//Changes made by Rahul P. on 26-Sep-2023 [End]

				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]

			}
			else
			{
				ArrayList teamList = new ArrayList();

				String teamSql="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR  REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
				PreparedStatement teamPstmt= connectionObject.prepareStatement(teamSql);
				teamPstmt.setString(1, sprsCode);
				ResultSet teamRs= teamPstmt.executeQuery();
				while(teamRs.next())
				{
					String reportTo=checkNull(teamRs.getString("REPORT_TO"));
					teamList.add(reportTo);
				}
				if(teamPstmt != null)
				{
					teamPstmt.close();
					teamPstmt = null;
				}
				if(teamRs != null)
				{
					teamRs.close();
					teamRs = null;
				}
				
				System.out.println("teamList is:"+teamList);
				
				String salesPersEmp=orgStructure.getFormattedList(teamList);
				//sql1 ="SELECT EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+teamGradeLevel+"' ORDER BY GRADE.LEVEL_NO DESC";
				/*sql1 = "SELECT DISTINCT '2' AS SR_NO,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO " + 
						"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
						"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
						"UNION "+
						"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO "+
						 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY SR_NO,LEVEL_NO DESC";*/
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("Y".equalsIgnoreCase(isFortuneAct))
				{
					sql1 = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY LEVEL_NO DESC";
				}
				else
				{	//Changes made by Rahul P. on 26-Sep-2023 [Start] set ENTITY_TYPE='R'
					/*sql1 = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+
							"UNION "+
							"SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							"FROM ENTITY_CONTACT WHERE ENTITY_TYPE='C' AND ENTITY_CODE='"+scCodeteam+"' " +
							"ORDER BY SR_NO,LEVEL_NO DESC";*/
					sql1 = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+
							"UNION "+
							"SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							"FROM ENTITY_CONTACT WHERE ENTITY_TYPE='R' AND ENTITY_CODE='"+scCodeteam+"' " +
							"ORDER BY SR_NO,LEVEL_NO DESC";
					//Changes made by Rahul P. on 26-Sep-2023 [End]
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
			}
			//Changed & Added By Vikas Lagad on 18-12-2019 [Changed logic for JNJ_coaching manager in team detail form]END
			// added by rupali on 13/04/18 for org_structure related changes [end]
			//System.out.println(" selectedTeam in dom vala parametr["+selectedTeam+"]");
			HashMap teamMap = new HashMap();

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			//System.out.println("Value of dcr id is:- -"+dcrID);

			if ( selectedTeam != null && selectedTeam.trim().length() > 0 )
			{
				//System.out.println(" selectedTeam in dom vala parametrtest lenghth["+selectedTeam.length()+"]");
				NodeList teamNodeList = ( genericUtility.parseString( selectedTeam ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = teamNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					int x =1;
					NodeList innerNodeList = teamNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String selTeam = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						//System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "sales_pers".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								selTeam = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						if ( "name".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								name = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
					}
					//System.out.println("selectTeam details["+selTeam+"] [");
					teamMap.put( selTeam, selTeam);

					//System.out.println(" teamMap ["+teamMap+"]");
					x++;
				}
			}

			if(dcrID != null)
			{
				String checkModeSql = " SELECT MAX(LINE_NO) AS MAXLINENO,MAX(TRAN_ID) AS TRAN_ID  FROM STRG_MEET_TEAM WHERE DCR_ID= ?  AND STRG_CODE = ?";
				pstmt = connectionObject.prepareStatement(checkModeSql);
				pstmt.setString(1,dcrID);
				pstmt.setString(2,strgCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxLineNo = rs.getInt("MAXLINENO");
					custTranID = checkNull(rs.getString("TRAN_ID"));
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(custTranID != null)
				{
					if(custTranID.length()>0)
						modeCounter++;
				}
			}

			int num = 1;
			int lineNo=1;
			pstmt =  connectionObject.prepareStatement( sql1 );
			// added by rupali on 13/04/18 for org_structure related changes
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String teamCode = checkNull(rs.getString("REPORT_TO"));
				//String empName = getEmpName(teamCode, connectionObject);
				String empDesign = getDesignName(teamCode, connectionObject);
				//System.out.println("test check report: - "+teamCode);
				//String designation = checkNull(rs.getString("DESIGNATION"));
				String empNameDesign = getEmpNameDesign(teamCode, connectionObject);
				System.out.println("empNameDesign::"+empNameDesign);
				String srNo = checkNull(rs.getString("SR_NO"));
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				String mobileNo = checkNull(rs.getString("MOBILE_NO"));
				String strCode = checkNull(rs.getString("STRG_CODE"));
				//System.out.println("Mobile no is::"+mobileNo);
				String empName="";
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
				String designation="";
				if("2".equalsIgnoreCase(srNo) && !employeeDesignationMap.isEmpty())
				{
					if(employeeDesignationMap.containsKey(teamCode))
					{
						designation=employeeDesignationMap.get(teamCode);

					}
					else
					{
						designation=empDesign;

					}
				}
				else
				{
					designation=empDesign;
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("3".equalsIgnoreCase(srNo))
				{
					empName = checkNull(rs.getString("NAME")).trim();
				}
				else
				{
					empName = getEmpName(teamCode, connectionObject);
				}
				System.out.println("empName is in realtime for team data:"+empName);
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
				if(empNameDesign!=null && empNameDesign.trim().length()>0)
				{
					empNameDesign=empNameDesign.substring(0, empNameDesign.lastIndexOf("("));
					System.out.println("empNameDesign before add designation : - "+empNameDesign);
					empNameDesign=empNameDesign +"("+designation+")";

				}
				System.out.println("empNameDesign after add designation : - "+empNameDesign);
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("3".equalsIgnoreCase(srNo))
				{
					empNameDesign = checkNull(rs.getString("NAME")).trim();
				}
				else
				{
					empNameDesign = empNameDesign;
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
				if ( teamMap.get( teamCode.trim() ) != null )
				{
					String data = ( String ) teamMap.get( teamCode.trim() );
					//System.out.println("value of data is inside if:- "+data);
					selectedXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					selectedXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					selectedXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					selectedXmlString.append("<sales_pers><![CDATA[").append( data ).append("]]></sales_pers>\r\n");
					selectedXmlString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
					selectedXmlString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
					selectedXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
					selectedXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n");
					selectedXmlString.append("<tran_id><![CDATA["+custTranID+"]]></tran_id>\r\n");
					selectedXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					selectedXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					selectedXmlString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
					selectedXmlString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
					selectedXmlString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
					selectedXmlString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
					selectedXmlString.append("<mem_code visible='0'><![CDATA[").append( data ).append("]]></mem_code>\r\n");
					selectedXmlString.append("<team_mobile_no visible='1'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
					selectedXmlString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
					
					selectedXmlString.append( "</Detail"+formNo+">\r\n" );
					num++;
				}
				else
				{

					maxLineNo = maxLineNo +1;
					//System.out.println("Value of mode counter is = "+modeCounter);
					if(modeCounter == 0)
					{
						//System.out.println("Value in ifff workWithListForm{"+workWithListForm+"}teamcode value is :- {"+teamCode);

						if((workWithListForm != null) && (workWithListForm.contains(teamCode)))
						{
							unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							unselectedString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							unselectedString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
							unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
							unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
							unselectedString.append("<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
							unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
							unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
							unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
							unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
							unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
							unselectedString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
							unselectedString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
							unselectedString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");					
							unselectedString.append("<team_mobile_no visible='1'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
							unselectedString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
							unselectedString.append("</Detail"+formNo+">\r\n" );
						}
						else
						{
							unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
							unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
							unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
							unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
							//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<strg_code><![CDATA[").append( strCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
							unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
							unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
							unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
							unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
							unselectedString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
							unselectedString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
							unselectedString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");					
							unselectedString.append("<team_mobile_no visible='1'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
							unselectedString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
							unselectedString.append( "</Detail"+formNo+">\r\n" );
						}
					}

					else
					{
						//System.out.println("value of data is inside else:- ");
						unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
						unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
						unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
						unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
						unselectedString.append("<strg_code><![CDATA[").append(strCode).append("]]></strg_code>\r\n");
						unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
						unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
						unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
						unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
						unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
						unselectedString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
						unselectedString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
						unselectedString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");					
						unselectedString.append("<team_mobile_no visible='1'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
						unselectedString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
						unselectedString.append( "</Detail"+formNo+">\r\n" );
					}
				}

			}//end of while

			valueXmlString.append(selectedXmlString);
			valueXmlString.append(unselectedString);
			//System.out.println("outside detail:- "+valueXmlString);
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(connectionObject != null && isLocal)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		//System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	
	}
	public String getSalesTeamDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams,String formName, Connection connectionObject,String formNo,String tranId ) throws ITMException
	{

		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedTeam = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			//System.out.println("Printing DOM + "+genericUtility.serializeDom(dom)+"+++++++++++++++");
			//System.out.println("Printing DOM222 + "+genericUtility.serializeDom(dom2)+"+++++++++++++++");
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}


			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedTeam = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
				//System.out.println("previous form values for team : - "+selectedTeam);
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				selectedTeam = getSalesExistingTeamDetail(tranId, connectionObject ,formNo,formName) ;
			}
			selectedTeam = "<Root>" + selectedTeam + "</Root>";
			//System.out.println("selectedTeam>>>"+selectedTeam);
			String itemDetails = getSalesPersTeamList(dom,dom2, salePersCode, scCode, selectedTeam, wrkDate,formNo,formName);
			//TODO


			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}	*/
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	
	}
	
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return errString;
	}
	
	private String getParentDomID(Document dom2,String parentFormNo, String strgCode)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String prntdomId = "";
		String domId = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;

		double totalValue = 0d;
		try
		{
			//System.out.println("getParentDomID strgCode["+strgCode+"]");
			parentList = dom2.getElementsByTagName("Detail"+ parentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("getParentDomID parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}

				if(currDetail.getAttributes().getNamedItem("domID") != null)
				{
					domId = currDetail.getAttributes().getNamedItem("domID").getNodeValue();
					//System.out.println("domId :::["+domId+"]");
				}
				if(domId != null && domId.trim().length() > 0 && domId.contains(strgCode))
				{
					prntdomId = domId;
					//System.out.println("prntdomId ::::::["+prntdomId+"]");
					break;
				}

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				//System.out.println("noOfChilds["+noOfChilds+"]");
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					//System.out.println("childNodeName =["+childNodeName+"] columnValue =["+columnValue+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							//System.out.println("getParentDomID updateFlag["+updateFlag+"]");
							if(updateFlag != null && updateFlag.trim().length() > 0 && "D".equalsIgnoreCase(updateFlag) )
							{
								break;
							}
						}
					}

				}

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getParentDomID :::["+prntdomId+"]");
		return prntdomId;
	}
	
	public String getSalesPersInvItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo, String formName,Document dom2,String prcListTemplate ) throws ITMException
	{

		//System.out.println("Inside getSalesPersInvItemList of edit invoice::"+prcListTemplate);
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		PreparedStatement custPrcList =null;
		ResultSet rsCustPrc = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;

		int strgCustCnt = 0;
		String bindValue = sprsCode;

		try
		{
			DARCommonBean darCommonBean= new DARCommonBean();

			valueXmlString.append( "<Root>\r\n" );
			connectionObject = getConnection();
			String paramValue="";
			String custCode="";
			String codeSql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ?";
			pstmt=connectionObject.prepareStatement(codeSql);
			pstmt.setString(1, strgCode);
			rs  = pstmt.executeQuery();
			if(rs.next())
			{
				strgCustCnt = rs.getInt("COUNT");
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			String itemSizeCol = getSfaParmValue(sprsCode,"ITEM_ATTRIB_SIZE",connectionObject);
			if(itemSizeCol.trim().length() == 0)
			{
				itemSizeCol = "PHY_ATTRIB_1";
			}
			String itemUSage="";
			String parmItemUsage = getSfaParmValue(sprsCode,"SAMPLE_ITEM_USAGE",connectionObject);
			if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
			{
				itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
			}
			else
			{
				itemUSage="'G','S'";
			}
			
			sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT,"+
					" ITEM.HSN_NO,S.QUANTITY AS QUANTITY,PM.PRICE_LIST AS PRICE_LIST,ITEM.PKG_SIZE AS PKG_SIZE " +
					" FROM SALES_PERS SP,ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE,STOCK S  "+
					" WHERE PM.PRICE_LIST= ? "+
					" AND ITEM.ACTIVE = 'Y' "+
					" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
					" AND S.ITEM_CODE=ITEM.ITEM_CODE AND S.SITE_CODE =(SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE= ? ) " + 
					" AND S.LOC_CODE=? AND S.ITEM_SER='FG' AND S.INV_STAT='SALE' " ;

			String sqlStr = "";

			HashMap itemMap = new HashMap();
			HashMap rateMap = new HashMap(); 
			HashMap remarkMap = new HashMap();
			HashMap tranIDMap = new HashMap();
			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				//System.out.println("Inside selected item in add");
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String qty = "";
					String columnValue = "";
					String chgRate = "";
					String remarksInv ="";
					String tranID ="";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "rate".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								chgRate = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "remarks_inv".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								remarksInv = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								tranID = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
					}
					itemMap.put( itemCode,qty);
					rateMap.put(itemCode,chgRate); 
					remarkMap.put(itemCode, remarksInv);
					tranIDMap.put(itemCode, tranID);

				}
			}
			String qty = "";
			String chgRate = "";
			int num = 1;
			int lineNo=1;

			double value = 0d;
			double stockValue = 0d;
			double rate = 0d;
			String stock = "";
			String taxAmount="";
			String taxAmtSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TAXAMT FROM DUAL";
			PreparedStatement  pstmtCnt = connectionObject.prepareStatement( taxAmtSql );
			pstmtCnt.setString(1, "IGST");
			ResultSet rset = pstmtCnt.executeQuery();
			if ( rset.next() )
			{
				taxAmount = checkNull( rset.getString( "TAXAMT" ) );
			}
			if (rset !=null )
			{
				rset.close();
				rset = null;
			}
			if(pstmtCnt != null)
			{
				pstmtCnt.close();
				pstmtCnt = null;
			}
			
			int currFormNo = Integer.parseInt(formNo);
			String objName = checkNull(getObjNameFromDom(dom2, "objName",currFormNo));
			String parentFormNo = checkNull(getParentformNo(formNo, objName, connectionObject ));
			String basicValue = getSelectedRowValue(dom2, "1", "net_amt", 0);
			String gstValue = getSelectedRowValue(dom2, "1", "tax_amount", 0);
			String totalValue = getSelectedRowValue(dom2, "1", "amount", 0);
			String itemSer=checkNull(getItemSer(sprsCode, connectionObject));
			
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, prcListTemplate);
			pstmt.setString(2, sprsCode);
			pstmt.setString(3, sprsCode);
			
			String priceTemplate="'"+prcListTemplate+"'";
			HashMap<String, String> childItemMap = childItemMapFunction(priceTemplate,itemSer,eventDate, sprsCode,connectionObject);

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String stockInfoData = "";
				String remark="";
				String tranID = "";
				int minQunt=0;
				int proDiffDays=0;
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));
				String priceList = checkNull(rs.getString("PRICE_LIST"));
				String quantity = checkNull(rs.getString("QUANTITY"));
				String hsnNo= checkNull(rs.getString("HSN_NO"));
				String pkgSize= checkNull(rs.getString("PKG_SIZE"));

				String expDate = "";
				String key=itemCode+"@"+priceList;
				String childItemDescr="",childhsnNoValue="",childPriceList="",childItemCode="",childPackageSize="";
				String subItemDescr="",subhsnNoValue="",subPriceList="",subItemCode="",subPacakgeSize="";
				if(childItemMap.containsKey(key))
				{
					String childItemValue=childItemMap.get(key);
					
					String allValue[]=childItemValue.split("@");
					childItemDescr=allValue[0];
					childhsnNoValue=allValue[1];
					childPriceList=allValue[2];
					childItemCode=allValue[3];
					childPackageSize=allValue[4];
					String childKey=childItemCode+"@"+childPriceList;

					if(childItemMap.containsKey(childKey))
					{
						String subchildItemValue=childItemMap.get(childKey);

						String SuballValue[]=subchildItemValue.split("@");
						subItemDescr=SuballValue[0];
						subhsnNoValue=SuballValue[1];
						subPriceList=SuballValue[2];
						subItemCode=SuballValue[3];
						subPacakgeSize=SuballValue[4];
					}
				}
				double childItemrate  = darCommonBean.getLandingRate( "", childItemCode, eventDate, sprsCode,childPriceList, connectionObject);
				double subItemrate  = darCommonBean.getLandingRate( "", subItemCode, eventDate, sprsCode,subPriceList, connectionObject);
				
				rate = darCommonBean.getLandingRate( strgCode, itemCode, eventDate, sprsCode,priceList, connectionObject);
				//System.out.println("Rate is as in invoice:"+rate);
				DecimalFormat df = new DecimalFormat("###.##");
				if ( itemMap.get( itemCode.trim() ) != null || rateMap.get( itemCode.trim() ) != null )
				{
					qty = ( String ) itemMap.get( itemCode.trim() );
					rate = Double.parseDouble(( String ) rateMap.get( itemCode.trim() ));
					//System.out.println("Rate is as in invoice at selected:"+rate);
					if(remarkMap != null && !remarkMap.isEmpty())
					{
						remark = ( String ) remarkMap.get( itemCode.trim() );
					}	
					if(tranIDMap.containsKey(itemCode))
					{
						tranID = (String)tranIDMap.get(itemCode);
					}
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
					valueXmlString.append("<rate><![CDATA[" ).append(df.format(rate)).append( "]]></rate>\r\n" );
					valueXmlString.append("<remarks_inv><![CDATA[" ).append(remark).append( "]]></remarks_inv>\r\n" );
				}
				else
				{
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
					valueXmlString.append("<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
					valueXmlString.append("<rate><![CDATA[" ).append(df.format(rate)).append( "]]></rate>\r\n" );
					valueXmlString.append("<remarks_inv><![CDATA[" ).append("").append( "]]></remarks_inv>\r\n" );
				}
				
				if( rate> 0 && qty.trim().length()>0 && taxAmount.trim().length()>0 && qty != null )
				{
					double tempQuantity = 0d;
					double tempTaxAmt= 0d;
					double tempTotalGst= 0d;
					double selSgstAmt=0d;
					double selCgstAmt=0d;
					double selValueTotal=0d;
					try
					{
						tempQuantity =Double.parseDouble(qty);
						tempTaxAmt =Double.parseDouble(taxAmount);
						tempTotalGst=(rate * tempQuantity);
						selSgstAmt=(rate * tempQuantity * (tempTaxAmt/200));
						selCgstAmt = selSgstAmt;
						selValueTotal = (tempTotalGst + selCgstAmt + selSgstAmt );
						valueXmlString.append("<value>").append(df.format(tempTotalGst)).append("</value>\n");
						valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(df.format(selSgstAmt)).append( "]]></total_sgst_amount>\r\n" );
						valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(df.format(selCgstAmt)).append( "]]></total_cgst_amount>\r\n" );
						valueXmlString.append("<total_amount><![CDATA[" ).append(df.format(selValueTotal)).append( "]]></total_amount>\r\n" );
						
					}
					catch(NumberFormatException e)
					{
						tempTotalGst=0;
						valueXmlString.append("<value><![CDATA[" ).append(tempTotalGst).append( "]]></value>\r\n" );
						valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_sgst_amount>\r\n" );
						valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_cgst_amount>\r\n" );
						valueXmlString.append("<total_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_amount>\r\n" );
					}
				}
				else
				{
					valueXmlString.append("<value>").append("").append("</value>\n");
					valueXmlString.append("<total_sgst_amount>").append("").append("</total_sgst_amount>\n");
					valueXmlString.append("<total_cgst_amount>").append("").append("</total_cgst_amount>\n");
					valueXmlString.append("<total_amount>").append("").append("</total_amount>\n");
				}
				valueXmlString.append("<basic_value><![CDATA[" ).append( basicValue ).append( "]]></basic_value>\r\n" );
				valueXmlString.append("<total_gst><![CDATA[" ).append( gstValue ).append( "]]></total_gst>\r\n" );
				valueXmlString.append("<total_value><![CDATA[" ).append( totalValue ).append( "]]></total_value>\r\n" );
				valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append( rs.getString("DESCR") ).append("]]></item_descr>\r\n");
				valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
				valueXmlString.append("<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
				valueXmlString.append("<curr_stock><![CDATA[").append( rs.getString("QUANTITY") ).append("]]></curr_stock>\r\n" );
				valueXmlString.append("<org_stock><![CDATA[").append( rs.getString("QUANTITY") ).append("]]></org_stock>\r\n" );

				valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
				valueXmlString.append("<tax_amt_inv><![CDATA[").append(taxAmount).append("]]></tax_amt_inv>\r\n");
				valueXmlString.append("<hsn_number><![CDATA[" ).append(hsnNo).append( "]]></hsn_number>\r\n" );
				valueXmlString.append("<pkg_size><![CDATA[" ).append(pkgSize).append( "]]></pkg_size>\r\n" );
				valueXmlString.append("<itm_child><![CDATA[" ).append(childItemCode).append( "]]></itm_child>\r\n" );
				valueXmlString.append("<itm_child_descr><![CDATA[" ).append(childItemDescr).append( "]]></itm_child_descr>\r\n" );
				valueXmlString.append("<child_price_list><![CDATA[" ).append(childPriceList).append( "]]></child_price_list>\r\n" );
				valueXmlString.append("<itm_child_rate><![CDATA[" ).append(childItemrate).append( "]]></itm_child_rate>\r\n" );
				valueXmlString.append("<child_hsn_number><![CDATA[" ).append(childhsnNoValue).append( "]]></child_hsn_number>\r\n" );
				valueXmlString.append("<child_pack_size><![CDATA[" ).append(childPackageSize).append( "]]></child_pack_size>\r\n" );
				valueXmlString.append("<sub_itm_child><![CDATA[" ).append(subItemCode).append( "]]></sub_itm_child>\r\n" );
				valueXmlString.append("<sub_child_descr><![CDATA[" ).append(subItemDescr).append( "]]></sub_child_descr>\r\n" );
				valueXmlString.append("<sub_price_list><![CDATA[" ).append(subPriceList).append( "]]></sub_price_list>\r\n" );
				valueXmlString.append("<sub_child_rate><![CDATA[" ).append(subItemrate).append( "]]></sub_child_rate>\r\n" );
				valueXmlString.append("<sub_hsn_number><![CDATA[" ).append(subhsnNoValue).append( "]]></sub_hsn_number>\r\n" );
				valueXmlString.append("<sub_pack_size><![CDATA[" ).append(subPacakgeSize).append( "]]></sub_pack_size>\r\n" );
				valueXmlString.append("</Detail"+formNo+">\r\n" );

				qty = "";
				num++;
				lineNo++;
			}//end of while
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersInvItemList(String):" + e.getMessage() + ":");
			throw new ITMException(e);

		}
		finally
		{
			try {
					if (connectionObject != null && !connectionObject.isClosed())
					{
						connectionObject.close();
						connectionObject = null;
					}
				} 
			catch (Exception e) 
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n" + e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :"+valueXmlString.toString()+":********");
		return valueXmlString.toString();
	}
	
	public String getInvoiceItemDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject, String formNo,String formName,String prcListTemplate,String tranId,String mode) throws ITMException
	{
		//System.out.println("Inside getInvoiceItemDetails of Edit mode");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}

			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				if(newScCode == null || newScCode.trim().length() == 0)
				{
					newScCode = "''";
				}
				//System.out.println("getItemDetails >> newScCode=["+newScCode+"]");
				//System.out.println("lo 5633");
				selectedItem = getExistingInvoiceDetail( tranId, connectionObject , formNo,formName,salePersCode,dom2,scCode,prcListTemplate,mode);
			}
			selectedItem = "<Root>" + selectedItem + "</Root>";
			//System.out.println("selectedItem in edit mode invoice>>>"+selectedItem);
			String itemDetails = getSalesPersInvItemList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName,dom2,prcListTemplate);

			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getInvoiceItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getInvoiceItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();
	
	}
	
	public String getItemDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject, String formNo,String formName,String pricelist,String tranId,String mode ) throws ITMException
	{

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}

			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				System.out.println("line 7895");
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				if(newScCode == null || newScCode.trim().length() == 0)
				{
					newScCode = "''";
				}
				//System.out.println("getItemDetails >> newScCode=["+newScCode+"]");
				selectedItem = getExistingItemsDetail(tranId, connectionObject ,formNo,formName,salePersCode,pricelist,scCode,mode);//getExistingItemsDetail( salePersCode, wrkDate , newScCode, formNo,formName,connectionObject) ;
			}
			selectedItem = "<Root>" + selectedItem + "</Root>";
			//System.out.println("scCode value befor item method::"+scCode);
			//System.out.println("selectedItem in sampleordre>>>"+selectedItem);
			String itemDetails = getSalesPersItemList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName,dom2,pricelist );

			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	
	}
	
	private double getTotalPOBValue(Document dom2,String currentFormNo, String value, String strgCode)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
		int parentNodeListLength = parentList.getLength();
		String discount="";
		//System.out.println("getTotalPOBValue parentNodeListLength--["+parentNodeListLength+"] strgCode [ "+strgCode+"], currentFormNo=["+currentFormNo+"]");
		double totalValue = 0d;
		try
		{
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				//System.out.println("noOfChilds =["+noOfChilds+"]");
				String landingRate = "0";
				String quantity = "0";
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = checkNull(childNode.getNodeName());
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					
					if(childNodeName.equalsIgnoreCase("quantity"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							quantity = checkNull(childNode.getFirstChild().getNodeValue());
							if(quantity.length() == 0)
							{
								quantity = "0";
							}
						}
						else
						{
							quantity = "0";
						}
					}
					else if(childNodeName.equalsIgnoreCase("landing_rate"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							landingRate = checkNull(childNode.getFirstChild().getNodeValue());
							if(landingRate.length() == 0)
							{
								landingRate = "0";
							}
						}
						else
						{
							landingRate = "0";
						}
					}
					else if(childNodeName.equalsIgnoreCase("disc_perc"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							discount = checkNull(childNode.getFirstChild().getNodeValue());
							if(discount.length() == 0)
							{
								discount = "0";
							}
						}
						else
						{
							discount = "0";
						}
					}
					
				}
				if(quantity != null && quantity.length()> 0 && landingRate != null && landingRate.length() > 0)
				{
					double qty = Double.parseDouble(quantity);
					double rate = Double.parseDouble(landingRate);
					double disCnt = Double.parseDouble(discount);
					
					totalValue = totalValue + (qty * rate - (disCnt * (qty * rate) /100));
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("getTotalPOBValue for strgCode "+strgCode+":::["+totalValue+"]");
		return totalValue;
	}
	
	private String getTeamFormHierarchy(String sql,Connection connectionObject ) throws ITMException
	{
		ResultSet rs=null;
		PreparedStatement pstmt =null;
		String selLocSql = "";
		String  teamHierarchy = "";
		try
		{
			
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String teamCode = checkNull(rs.getString("REPORT_TO"));
				if(teamHierarchy.trim().length() > 0 )
				{
					teamHierarchy = teamHierarchy +","+teamCode;
				}
				else
				{
					teamHierarchy = teamCode;
				}			
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return teamHierarchy;
	}
	
	public String postSave(String tranId, String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException, ITMException
	{
		String resString="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		Document dom = null;
		int updCnt = 0;
		String updateFlag = "";
		
		try
		{
			String actType="",salesPers="",eventDate="",dcrID="";
			String formNo = "",scCode="";
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			DARCommonBean darCommonBean= new DARCommonBean();

			System.out.println("xmlStringAll::"+domString);
			dom = genericUtility.parseString(domString);
			
			actType = checkNull(genericUtility.getColumnValue("activity_type", dom, "1"));
			salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom, "1" ));
			scCode = checkNull(genericUtility.getColumnValue( "strg_code", dom, "1" ));
			eventDate = checkNull(genericUtility.getColumnValue( "event_date", dom, "1" ));
			dcrID = checkNull(genericUtility.getColumnValue( "dcr_id", dom, "1" ));
			String totalAmount = checkNull(genericUtility.getColumnValue( "amount", dom, "1" ));
			String gradeType = checkNull(genericUtility.getColumnValue( "grade_type", dom, "1" ));
			String callOutcome = checkNull(genericUtility.getColumnValue("call_outcome", dom, "1"));
			
			String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom, "1"));
			String eventType = checkNull(genericUtility.getColumnValue("event_type", dom, "1"));
			
			System.out.println("actType:"+actType+" dcrID:"+dcrID+" scCode:"+scCode);
			if ( "FW".equalsIgnoreCase( actType.trim() ) )
			{
				String objName = getObjNameFromDom( dom, "objName" , 1);
				String winName = "w_"+objName;
				
				if((resString==null || resString.trim().length()==0) && !"0".equalsIgnoreCase(callOutcome))
				{

					String parmAct = "",paramActMandatory="";
					String parmVal = "",parmValMandatory = "";
					String [] actTempArr = null;
					String sfaParmSql;
					if( "M".equalsIgnoreCase(gradeType))
					{
						if( "SELF".equalsIgnoreCase(visitedWith) )
						{
							sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='MGR_FORM_MANDATORY' AND ORG_UNIT = 'SELF' ";
						}
						else
						{
							sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='MGR_FORM_MANDATORY' AND ORG_UNIT = 'ALL' ";
						}
					}
					else
					{
						sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_FORM_MANDATORY' ";
					}

					pstmt = conn.prepareStatement(sfaParmSql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						parmAct = checkNull(rs.getString("ACTIVE"));
						parmVal = checkNull(rs.getString("PARM_VALUE"));
					}
					else
					{
						sfaParmSql = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_FORM_MANDATORY' ";
						pstmt1 = conn.prepareStatement(sfaParmSql);
						rs1 = pstmt1.executeQuery();
						if (rs1.next())
						{
							parmAct = checkNull(rs1.getString("ACTIVE"));
							parmVal = checkNull(rs1.getString("PARM_VALUE"));
						}
						if(rs1 != null)
						{
							rs1.close();
							rs1 = null;
						}
						if(pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					String sfaParmSqlQuery = "SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='ACTWISE_FORM_NOT_MANDATORY' AND ORG_UNIT = ? ";
					pstmt = conn.prepareStatement(sfaParmSqlQuery);
					pstmt.setString(1, eventType);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						paramActMandatory = checkNull(rs.getString("ACTIVE"));
						parmValMandatory = checkNull(rs.getString("PARM_VALUE"));
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if( !"".equalsIgnoreCase(parmValMandatory) && parmValMandatory.length() > 0)
					{
						actTempArr = parmValMandatory.split(",");
					}
					if("Y".equalsIgnoreCase(parmAct))
					{
						String subFormName = "";
						String [] temp = parmVal.split(",");
						List<String> list = new ArrayList<String>();
						if( actTempArr != null && actTempArr.length > 0)
						{
							list = new ArrayList<String>(Arrays.asList(actTempArr));
						}
						for(int i = 0 ;i < temp.length;i++)
						{
							if(!list.contains(temp[i]) )
							{
								if(subFormName == null || subFormName.trim().length() == 0)
								{
									subFormName = temp[i];
								}
								else
								{
									subFormName = subFormName + "','" + temp[i];
								}
							}
						}
						subFormName = "'" + subFormName + "'";

						String objFormSql= "SELECT FORM_NAME, FORM_NO, TITLE FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN("+subFormName+") ";
						pstmt = conn.prepareStatement(objFormSql);
						pstmt.setString(1, winName);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							String formName = checkNull(rs.getString("FORM_NAME"));
							String formNoM = checkNull(rs.getString("FORM_NO"));
							String formTitle = checkNull(rs.getString("TITLE"));
							try
							{
								NodeList parentNodeList = dom.getElementsByTagName("Detail"+formNoM);
								int nodeListLen = parentNodeList.getLength();
								System.out.println("nodeListLen:::::: =["+nodeListLen+"]");
								if(nodeListLen == 0)
								{
									System.out.println("formName  for validation is :::::: =["+formName+"]");
									if(formName.trim().equalsIgnoreCase("invoice"))
									{
										resString = itmDBAccessLocal.getErrorString( "item_code", "MANFORMSEL", "" );
										resString = getModifiedErrorString(resString, formTitle);
										System.out.println("resString n:::::: =["+resString+"]");
										//return resString;
									}
									else if(formName.trim().equalsIgnoreCase("collection"))
									{
										resString = itmDBAccessLocal.getErrorString( "pay_mode", "MANFORMSEL", "" );
										resString = getModifiedErrorString(resString, formTitle);
										System.out.println("resString n:::::: =["+resString+"]");
										//return resString;
									}
								}
								else
								{
									Node childNode = null;
									Node parentNode=null;
									NodeList childList =null;
									boolean flg=true;
									for (int prntCtr = 0; prntCtr < nodeListLen; prntCtr++ )
									{
										String updateFlag1 = "";

										parentNode = parentNodeList.item(prntCtr);
										childList = parentNode.getChildNodes();
										int noOfChilds = childList.getLength();
										for(int ctr = 0; ctr < noOfChilds; ctr++)
										{
											childNode = childList.item(ctr);
											if( childNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String childNodeName = childNode.getNodeName();
											if(childNodeName.equalsIgnoreCase("attribute"))
											{
												if(childNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													updateFlag1 = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
												}
											}
											if(!updateFlag1.equalsIgnoreCase("D"))
											{
												childNode = childList.item(ctr);
												if(childNode.getFirstChild() != null)
												{
													flg=false;
													break;
												}

											}
										}


									}
									if(flg==true)
									{
										System.out.println("formName  for validation in flg :::::: =["+flg+"]");
										if(formName.trim().equalsIgnoreCase("invoice"))
										{
											resString = itmDBAccessLocal.getErrorString( "item_code", "MANFORMSEL", "" );
											resString = getModifiedErrorString(resString, formTitle);
											//return resString;
										}
										if(formName.trim().equalsIgnoreCase("collection"))
										{
											resString = itmDBAccessLocal.getErrorString( "pay_mode", "MANFORMSEL", "" );
											resString = getModifiedErrorString(resString, formTitle);
											//return resString;
										}
									}


								}
								
							}
							catch(Exception e)
							{
								System.out.println("Exception  :==>\n" + e.getMessage());
								throw new ITMException(e);
							}
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					
				}
				if(resString==null || resString.trim().length()==0)
				{
				  resString = darCommonBean.collectionValidateAmount(dom, conn, winName, totalAmount,"collection");
				}
				if(resString==null || resString.trim().length()==0)
				{
                  updateStrgSurveyRes( dom, dcrID.trim(),scCode, conn);
				  updateCoachingDetail( dom, dcrID.trim(),scCode, conn);
				} 
			}
			

		}
		catch(Exception e) {
			throw new ITMException(e);
		}
		
		System.out.println("Return string :" + resString);
		return resString;
	}
	
	private void updateStrgSurveyRes( Document dom, String dcrId,String scCode, Connection conn ) throws Exception
	{
		int updCnt = 0;
		PreparedStatement pstmt = null;
		String formNo = "";
		String updateFlag = "";
		try
		{
			String updSurveySql = " UPDATE STRG_SURV_RES SET RESULT = ?, SURV_STATUS = 'Y' WHERE DCR_ID = ? AND STRG_CODE = ? AND SURVEY_CODE = ? ";
			pstmt = conn.prepareStatement( updSurveySql );

			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;

			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('survey') ";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}
			//Getting the survey detail list and update the result value :START
			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();

			boolean isSurveyStatUpdated = false;
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				String surveyCode = "";
				String resultType = "";
				String result1 = "";
				String result2 = "";
				String result3 = "";
				String result4 = "";		//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
				String result5 = "";
				String strgCode = "";
				String surveyTempl = "";//added by prachi on 11-07-22 [W22DJOH004]
				String resultFormat = "";	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]

				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String childNodeName = childNode.getNodeName();
					System.out.println("childNodeName :: ["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							//System.out.println("updateFlag :: ["+updateFlag+"]");
						}
					}
					else if (childNodeName.equalsIgnoreCase("survey_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							surveyCode = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("surveyCode::::===="+surveyCode);
						}
					}
					else if (childNodeName.equalsIgnoreCase("survey_templ"))
					{
						if(childNode.getFirstChild() != null)
						{
							surveyTempl = childNode.getFirstChild().getNodeValue().trim();
							System.out.println("surveyTempl::::===="+surveyTempl);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_type"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultType = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("resultType::::===="+resultType);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_format"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultFormat = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result1"))
					{
						if(childNode.getFirstChild() != null)
						{
							result1 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result2"))
					{
						if(childNode.getFirstChild() != null)
						{
							result2 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result3"))
					{
						if(childNode.getFirstChild() != null)
						{
							result3 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result3::::===="+result3);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result4"))
					{
						if(childNode.getFirstChild() != null)
						{
							result4 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result4::::===="+result4);
						}
					}
					else if (childNodeName.equalsIgnoreCase("result5"))
					{
						if(childNode.getFirstChild() != null)
						{
							result5 = childNode.getFirstChild().getNodeValue().trim();
							//System.out.println("result5::::===="+result5);
						}
					}
					else if (childNodeName.equalsIgnoreCase("strg_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							if(scCode!=null && scCode.trim().length()>0)
							{
								strgCode=scCode.trim();
							}
							else
							{
								strgCode = childNode.getFirstChild().getNodeValue().trim();

							}
							//System.out.println("strgCode::::===="+strgCode);
						}
					}
					
				}
				System.out.println("updateFlag:"+updateFlag+" surveyCode:"+surveyCode+" surveyTempl:"+surveyTempl+" resultType:"+resultType+" result1:"+result1+" result2:"+result2+" result3:"+result3+" result4:"+result4+" result5:"+result5+" strgCode:"+strgCode);
				if(!updateFlag.equalsIgnoreCase("D") && !"A".equalsIgnoreCase(resultType))
				{
					
					if ( ! isSurveyStatUpdated )
					{
						String updateSurveyStatSql = "UPDATE STRG_SURV_RES SET SURV_STATUS = 'N' WHERE STRG_CODE = ? AND SURV_STATUS = 'Y' AND DCR_ID IN (SELECT DCR_ID FROM STRG_MEET WHERE STRG_CODE = ? AND SURVEY_TEMPL=? AND DCR_ID<>?) ";
						
						PreparedStatement pstmt1 = conn.prepareStatement( updateSurveyStatSql );
						pstmt1.setString( 1, strgCode );
						pstmt1.setString( 2, strgCode );
						pstmt1.setString( 3, surveyTempl );
						pstmt1.setString( 4, dcrId );
						
						int surveyStatCnt = pstmt1.executeUpdate();
						System.out.println( "updateSurveySql :: surveyStatCnt : ["+ surveyStatCnt +"]" );
						if ( pstmt1 != null )
						{
							pstmt1.close();
							pstmt1 = null;
						}
						isSurveyStatUpdated = true;
					}
					
					if("N".equalsIgnoreCase(resultType))
					{
						if(result1 == null || result1.trim().length() == 0)
						{
							result1 = "NA";
						}
						pstmt.setString(1, result1);
					}
					else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
					{
						if(result4 == null || result4.trim().length() == 0)
						{
							result4 = "NA";
						}
						pstmt.setString(1, result4);
					}
					else if("D".equalsIgnoreCase(resultType) || "L".equalsIgnoreCase(resultType))
					{
						if(result2 == null || result2.trim().length() == 0)
						{
							result2 = "NA";
						}
						pstmt.setString(1, result2);
					}
					else if("T".equalsIgnoreCase(resultType))
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					else
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					pstmt.setString(2, dcrId);
					pstmt.setString(3, strgCode);
					pstmt.setString(4, surveyCode);

					updCnt = pstmt.executeUpdate();
					pstmt.clearParameters();
					//System.out.println("updateresultType ::: updCnt =["+updCnt+"]");
				}
			}
			//}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
	}
	private void updateCoachingDetail( Document dom, String dcrId, String scCode, Connection conn ) throws Exception
	{
		int updCnt = 0;
		PreparedStatement pstmt = null;
		String formNo = "";
		String updateFlag = "";
		try
		{
			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;

			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('coaching')";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}

			String updCoachingSql = "UPDATE SPRS_COACHING SET RESULT = ? WHERE DCR_ID = ? AND STRG_CODE = ? AND SURVEY_CODE = ?";
			pstmt = conn.prepareStatement( updCoachingSql );

			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();

			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				String surveyCode = "";
				String resultType = "";
				String result1 = "";
				String result2 = "";
				String result3 = "";
				String result4 = "";
				String result5 = "";
				String strgCode = "";
				String resultFormat = "";

				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String childNodeName = childNode.getNodeName();
					System.out.println("childNodeName :: ["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}
					else if (childNodeName.equalsIgnoreCase("survey_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							surveyCode = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_type"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultType = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result_format"))
					{
						if(childNode.getFirstChild() != null)
						{
							resultFormat = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result1"))
					{
						if(childNode.getFirstChild() != null)
						{
							result1 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result2"))
					{
						if(childNode.getFirstChild() != null)
						{
							result2 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result3"))
					{
						if(childNode.getFirstChild() != null)
						{
							result3 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result4"))
					{
						if(childNode.getFirstChild() != null)
						{
							result4 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("result5"))
					{
						if(childNode.getFirstChild() != null)
						{
							result5 = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					else if (childNodeName.equalsIgnoreCase("strg_code"))
					{
						if(childNode.getFirstChild() != null)
						{
							if(scCode!=null && scCode.trim().length()>0)
							{
								strgCode=scCode.trim();
							}
							else
							{
								strgCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
				}
				if(!updateFlag.equalsIgnoreCase("D"))
				{
					if("N".equalsIgnoreCase(resultType))
					{
						if(result1 == null || result1.trim().length() == 0)
						{
							result1 = "NA";
						}
						pstmt.setString(1, result1);
					}
					else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
					{
						if(result4 == null || result4.trim().length() == 0)
						{
							result4 = "NA";
						}
						pstmt.setString(1, result4);
					}
					else if("D".equalsIgnoreCase(resultType) || "L".equalsIgnoreCase(resultType))
					{
						if(result2 == null || result2.trim().length() == 0)
						{
							result2 = "NA";
						}
						pstmt.setString(1, result2);
					}
					else if("T".equalsIgnoreCase(resultType))
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					else if("A".equalsIgnoreCase(resultType))
					{
						if(result5 == null || result5.trim().length() == 0)
						{
							result5 = "NA";
						}
						pstmt.setString(1, result5);
					}
					else
					{
						if(result3 == null || result3.trim().length() == 0)
						{
							result3 = "NA";
						}
						pstmt.setString(1, result3);
					}
					pstmt.setString(2, dcrId);
					pstmt.setString(3, strgCode);
					pstmt.setString(4, surveyCode);

					updCnt = pstmt.executeUpdate();
					System.out.println("updCnt = "+updCnt);
					pstmt.clearParameters();
				}
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(SQLException e)
		{
			System.out.println("SQLException :: updateCoachingDetail() EXCEPTION ==>"+e);
			//throw new ITMException(e);
		}
		catch(Exception e)
		{
			System.out.println("updateCoachingDetail() EXCEPTION ==>"+e);
			throw new ITMException(e);
		}
	}
	
	public String getPitchDetails( String salePersCode, String wrkDate , String copyPlan,String scCode, String localityCode,String xtraParams,String objNameDefault, String callOutcome, String currentFormNo,String formName, Connection connectionObject,String tranId ) throws ITMException
	{

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "", pitchDetData ="", brandSql = "";
		//GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			System.out.println("inside pitch detail method::"+localityCode);
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			//added by mrunalini sinkar for Edetaling changes of real time report(adding contents tag)(start)
			HashMap<String, String> documentMap=new HashMap<String, String>();
			try
			{

				System.out.println("inside pitch detail localitycode::"+localityCode);

				if(localityCode != null)
				{
					localityCode="'"+localityCode+"'";
					if(localityCode.indexOf(",")!= -1)
					{
						localityCode = localityCode.replaceAll(",", "','");
						System.out.println("localityCode is:"+localityCode);
					}
				}
				else
				{
					localityCode="''";
				}
				//Modified by mrunalini sinkar on 27-07-2018 for document list(start)
				//documentMap=getDocumentList(salePersCode,localityCode,connectionObject);
				System.out.println("before methodcall");
				documentMap=getDocumentList(salePersCode,localityCode,copyPlan,scCode,wrkDate,connectionObject);
				//Modified by mrunalini sinkar on 27-07-2018 for document list(end)
			}
			//added by mrunalini sinkar for Edetaling changes of real time report(end)
			catch(Exception e)
			{

			}
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}
			//	System.out.println("In getPitchDetails:: salePersCode : [" + salePersCode + "] scCode :[" + scCode +"] wrkDate:["+wrkDate+"]");

			if ( wrkDate != null )
			{
				wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat()  , getDBDateFormat() );
			}

			//System.out.println("wrkDateInDbFmt:["+wrkDateInDbFmt+"]");
			String wrkDBDate =  genericUtility.getValidDateTimeString( wrkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			//System.out.println("wrkDBDate:["+wrkDBDate+"]");
			int rsRowCnt = 0;
			boolean isbrandAct = false;
			boolean isbrandPrd = false;
			String brandActCnt = "SELECT COUNT(*) AS COUNT " +
					"FROM STRG_BRAND_ACT SBA, STRG_BRAND_ACT_DET SBD, BRAND BR , PERIOD PR  " +
					"WHERE SBA.TRAN_ID = SBD.TRAN_ID AND SBD.BRAND_CODE = BR.BRAND_CODE  AND SBA.PRD_CODE = PR.CODE " +
					"AND SBA.SALES_PERS = ?  AND SBD.SC_CODE = '"+scCode+"'  " +
					"AND SBA.CONFIRMED = 'Y' AND  ?  BETWEEN PR.FR_DATE AND PR.TO_DATE ";
			// "ORDER BY BR.DESCRIPTION "; commented by prathamesh for db2

			pstmt = connectionObject.prepareStatement(brandActCnt);
			pstmt.setString(1,salePersCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rsRowCnt = rs.getInt(1);
				//System.out.println("STRG_BRAND_ACT rsRowCnt:["+rsRowCnt+"]");
				if(rsRowCnt > 0)
				{
					isbrandAct = true;
				}
			}
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			String brandPrdCnt = "SELECT COUNT(*) AS COUNT " +
					"FROM  STRG_PRODUCT SPR , BRAND BR  WHERE SPR.BRAND_CODE = BR.BRAND_CODE " +
					"AND SPR.SALES_PERS = ? AND SPR.SC_CODE = '"+scCode+"'  " +
					"AND ?  BETWEEN SPR.VALID_FROM AND SPR.VALID_TO";
			//ORDER BY BR.DESCRIPTION ";//COMMENTED BY PRATHAMESH JANGAM FOR DB2 TESTING

			pstmt = connectionObject.prepareStatement(brandPrdCnt);
			pstmt.setString(1,salePersCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rsRowCnt = rs.getInt(1);
				//System.out.println("STRG_PRODUCT rsRowCnt:["+rsRowCnt+"]");
				if(rsRowCnt > 0)
				{
					isbrandPrd = true;
				}
			}
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("isbrandAct:["+isbrandAct+"] isbrandPrd:["+isbrandPrd+"]");
			//
			if(isbrandAct)
			{
				brandSql = "SELECT BR.BRAND_CODE, BR.DESCRIPTION ,BR.TAG_LINE,BR.SH_DESCR,SBD.PITCH_PRIORITY " +
						"FROM STRG_BRAND_ACT SBA, STRG_BRAND_ACT_DET SBD, BRAND BR , PERIOD PR  " +
						"WHERE SBA.TRAN_ID = SBD.TRAN_ID AND SBD.BRAND_CODE = BR.BRAND_CODE  AND SBA.PRD_CODE = PR.CODE " +
						"AND SBA.SALES_PERS = ?  AND SBD.SC_CODE = '"+scCode+"'  " +
						"AND SBA.CONFIRMED = 'Y' AND  ?  BETWEEN PR.FR_DATE AND PR.TO_DATE " +
						"ORDER BY BR.PITCH_PRIORITY, BR.DESCRIPTION ";// Changes by Harion S for order sequence as per PITCH_PRIORITY -- 01-Aug-2022
				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			}
			else if(isbrandPrd)
			{

				brandSql = "SELECT BR.BRAND_CODE, BR.DESCRIPTION,BR.TAG_LINE,BR.SH_DESCR , SPR.PITCH_PRIORITY " +
						"FROM  STRG_PRODUCT SPR , BRAND BR  WHERE SPR.BRAND_CODE = BR.BRAND_CODE " +
						"AND SPR.SALES_PERS = ? AND SPR.SC_CODE = '"+scCode+"'  " +
						"AND  ?  BETWEEN SPR.VALID_FROM AND SPR.VALID_TO ORDER BY BR.PITCH_PRIORITY, BR.DESCRIPTION ";// Changes by Harion S for order sequence as per PITCH_PRIORITY -- 01-Aug-2022

				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			}
			else
			{
				System.out.println(" getpitchdetails ::::[]");
				brandSql = " SELECT BRAND.BRAND_CODE, BRAND.DESCRIPTION ,BRAND.TAG_LINE,BRAND.SH_DESCR , BRAND.PITCH_PRIORITY " +
						" FROM BRAND BRAND, SALES_PERS SALES_PERS "+
						" WHERE SALES_PERS.ITEM_SER = BRAND.ITEM_SER AND SALES_PERS.SALES_PERS = ? ORDER BY BRAND.PITCH_PRIORITY, BRAND.DESCRIPTION ";// Changes by Harion S for order sequence as per PITCH_PRIORITY -- 01-Aug-2022
				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
			}
			//Added by kailash on 01-10-18 [start]
			String dcrID = getDCRId(connectionObject,salePersCode, wrkDate);
			//Added by kailash on 01-10-18 [end]
			//System.out.println("getPitchDetails :: brandSql::::=["+brandSql+"]");
			valueXmlString.append( "<Root>\r\n" );

			List<String> brandCodeList = new ArrayList<String>();
			List<String> pitchDetailList = new ArrayList<String>();

			//System.out.println("callOutcome ::["+callOutcome+"]");
			//pitchDetData = getCallOutcomePitch(callOutcome, connectionObject);
			//System.out.println("pitchDetData ::["+pitchDetData+"]");
			String brandCodeVals = "" , pitchDetailVals = "";
			String scCodeExt = "'"+scCode+"'";
			String existingBrand = getExistingPitchForDoctor( salePersCode, wrkDate, scCodeExt, objNameDefault, callOutcome, currentFormNo,formName, connectionObject );

			//System.out.println("existingBrand ::["+existingBrand+"]");
			//Added By Bhushan on 28-11-16 :START
			String brandCodeExt = "", pitchSeqExt="", currDet = "",
					pitchSeq="", pitchDetDescr="", tranIdExt ="", tranIdBrd ="", dcrIdExt ="", dcrIdBrd ="" ,pitchDetExt="",pitchDetDataExt="";//
			HashMap pitchMap = new HashMap();
			HashMap pitchMapTranId = new HashMap();
			HashMap pitchDetailMap = new HashMap();
			HashMap PitchDetailDescriptionMap = new HashMap();
			if( existingBrand != null && existingBrand.length() > 0 )
			{
				existingBrand = "<Root>" + existingBrand + "</Root>";
				currDet = "Detail"+currentFormNo;
				//System.out.println(" currDet ::::["+currDet+"]");
				NodeList itemNodeList = ( genericUtility.parseString( existingBrand ) ).getElementsByTagName(currDet);
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemTypeSel = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );

						//System.out.println("COLUMN NAME ["+ currNode.getNodeName()+"] COLUMN VALUE["+currNode.getFirstChild()+"] ");

						if("brand_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								brandCodeExt = currNode.getFirstChild().getNodeValue().trim();
								brandCodeList.add( brandCodeExt );
							}
						}
						else if ( "pitch_sequence".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								pitchSeqExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								tranIdExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "dcr_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								dcrIdExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "pitch_detail".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								pitchDetExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "pitch_detail_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								pitchDetDataExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}

					}
					System.out.println(" brandCode["+brandCodeExt+"] pitch_sequence["+pitchSeqExt+"] dcrIdExt["+dcrIdExt+"]" );
					pitchMap.put( brandCodeExt, pitchSeqExt);
					pitchMapTranId.put( brandCodeExt, dcrIdExt);
					pitchDetailMap.put( brandCodeExt, pitchDetExt);
					PitchDetailDescriptionMap.put( brandCodeExt, pitchDetDataExt);




				}
				//System.out.println("existingBrand  pitchMap ::::["+pitchMap+"]");
				//System.out.println("existingBrand  pitchMapTranId :::: "+pitchMapTranId);
			}
			//tranId = getPitchTranId(connectionObject);
			System.out.println("PitchDetails tranId ::::["+tranId+"]");
			//Added By Bhushan on 28-11-16 :END


			rs = pstmt.executeQuery();

			while(rs.next())
			{
				//String item = checkNull(rs.getString("DESCR"));
				String brand = checkNull(rs.getString("DESCRIPTION"));
				String brandCode = checkNull( rs.getString("BRAND_CODE") );
				//added by mrunalini sinkar for show the tag_line into brand sub form
				String tagLine = checkNull(rs.getString("TAG_LINE"));
				String shDescr = checkNull(rs.getString("SH_DESCR"));

				//String itemCode = checkNull( rs.getString("ITEM_CODE") );
				System.out.println("brandCode :: ["+brandCode+"]" + " Exist brandCodeList :: " + brandCodeList+"");
				pitchSeq="";
				pitchDetDescr="";
				tranIdBrd="";
				dcrIdBrd="";
				String pitchDetBrd="";
				String pitchDetDataBrd="";

				String attachment="";
				if ( brandCodeList.contains( brandCode ) )
				{
					int pos = brandCodeList.indexOf(brandCode);
					//System.out.println("if :: pos["+pos+"]\n");

					if( pitchMap.get( brandCode.trim() ) != null )
					{
						pitchSeq = ( String ) pitchMap.get( brandCode.trim() );
						//System.out.println(" pitchSeq ::::["+pitchSeq+"]");
					}

					if( pitchMapTranId.get( brandCode.trim() ) != null )
					{
						dcrIdBrd = ( String ) pitchMapTranId.get( brandCode.trim() );
						//System.out.println("existing dcrIdBrd ::::["+dcrIdBrd+"]");
					}
										if( pitchDetailMap.get( brandCode.trim() ) != null )
					{
						pitchDetBrd = ( String ) pitchDetailMap.get( brandCode.trim() );
						//System.out.println("existing dcrIdBrd ::::["+dcrIdBrd+"]");
					}
					if( PitchDetailDescriptionMap.get( brandCode.trim() ) != null )
					{
						pitchDetDataBrd = ( String ) PitchDetailDescriptionMap.get( brandCode.trim() );
						//System.out.println("existing dcrIdBrd ::::["+dcrIdBrd+"]");
					}	
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='Y' formName='"+formName+"'>\r\n" );
					//Changed By Bhushan on 06-10-16
					valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
					//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
					valueXmlString.append("<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull( scCode ) ).append("]]></strg_code>\r\n");

					valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
					//valueXmlString.append("<pitch_detail><![CDATA[").append( checkNull( pos, pitchDetailList ) ).append("]]></pitch_detail>\r\n" );
					valueXmlString.append("<pitch_detail><![CDATA[").append( checkNull(pitchDetBrd) ).append("]]></pitch_detail>\r\n" );

					valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
					valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
					valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

					valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");
					valueXmlString.append("<pitch_sequence><![CDATA[").append(pitchSeq).append("]]></pitch_sequence>\n");

					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
					valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
					valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
					valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
					valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
					valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
					//Added By Bhushan on 17-11-16
					valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[start]
					//valueXmlString.append( "<dcr_id><![CDATA[" ).append( dcrIdBrd ).append( "]]></dcr_id>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[" ).append( dcrID ).append( "]]></dcr_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[ens]
					valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
					valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
					valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( checkNull(pitchDetDataBrd )).append( "]]></pitch_detail_descr>\r\n" );
					valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( scCode ).append( "]]></sc_code_pitch>\r\n" );
					//added by mrunalini sinkar for show the tag_line into brand sub form

					valueXmlString.append("<brand_tag_line><![CDATA[").append(tagLine).append("]]></brand_tag_line>\n");
					valueXmlString.append("<brand_sh_descr><![CDATA[").append(shDescr).append("]]></brand_sh_descr>\n");

					System.out.println("documentMap 9029::"+documentMap);
					if(documentMap!=null && !documentMap.isEmpty() && (documentMap.containsValue(brandCode) || documentMap.containsValue("STRG_CODE")))
					{
						System.out.println("14107");
						
						for (Entry<String, String> documentEntry: documentMap.entrySet())
						{
							System.out.println("documentEntry.getValue()::"+documentEntry.getValue()+" brandCode:"+brandCode);
							
							if(brandCode.equals(documentEntry.getValue()) || "STRG_CODE".equalsIgnoreCase(documentEntry.getValue()))
							{
								String documentKey=documentEntry.getKey();
								System.out.println("docuemnet key:"+documentKey);
								String docPageInfo = "";
								String [] splitMapKey=documentKey.split("@");
								System.out.println("splitMapKey:"+splitMapKey);
								
								String docId=checkNull(splitMapKey[0]);
								String docName=checkNull(splitMapKey[1]);
								//String docRefId=checkNull(splitMapKey[3]);
								if(splitMapKey[3].trim().length()>0)
								{
									docPageInfo = checkNull(splitMapKey[3]); //commented and added by rupali on 30/07/18 for adding page_info in contents
								}
								String docRefId=checkNull(splitMapKey[4]);
								
								System.out.println("brandCode is:"+brandCode+"Attachment is:"+attachment);
								if(attachment==null || attachment.trim().length()==0)
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=docId + "::" +docName + ",";
									// attachment=docId + "::" +docName + "::" +docPageInfo +",";
									System.out.println("lin2 9059: "+attachment);
									
									attachment = docId + "::" + docName + "::" + docPageInfo + "~SEP~";
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]
								}
								else
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=attachment+docId + "::" +docName + ",";
									// attachment=attachment+docId + "::" +docName + "::" +docPageInfo +",";
									attachment = attachment + docId + "::" + docName + "::" + docPageInfo + "~SEP~";
									System.out.println("lin2 9073: "+attachment);
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]

								}
								//System.out.println("Attachment iss:"+attachment);

							}

						}
						System.out.println("line 9080::"+attachment);
						
						// if(attachment != null && attachment.length() > 0 && attachment.charAt(attachment.length() - 1) == ',')
						if(attachment != null && attachment.length() > 0 && attachment.endsWith("~SEP~"))
						{
							attachment = attachment.substring(0, attachment.length() - 5);
							System.out.println("Attachment scCode is:"+attachment+"sccode is:"+scCode);
						}

						valueXmlString.append("<contents><![CDATA[").append(attachment).append("]]></contents>\n");
					}
					else
					{
						System.out.println("line 9094");
						
						valueXmlString.append("<contents><![CDATA[").append("").append("]]></contents>\n");
					}

					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
				}
				else
				{
					int pos = brandCodeList.indexOf(brandCode);

					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
					valueXmlString.append("<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
					//Commented By Bhushan on 01-12-16 For All selection issues on previous condition  in Mobile DAR
					//valueXmlString.append("<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
					valueXmlString.append("<sc_code><![CDATA[").append( scCode ).append("]]></sc_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");

					valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
					valueXmlString.append("<pitch_detail><![CDATA[]]></pitch_detail>\r\n" );
					valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
					valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
					valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

					valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");
					valueXmlString.append("<pitch_sequence><![CDATA[").append("").append("]]></pitch_sequence>\n");

					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
					valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
					valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
					valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
					valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
					valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
					//Added By Bhushan on 17-11-16
					valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[start]
					//valueXmlString.append( "<dcr_id><![CDATA[" ).append( "" ).append( "]]></dcr_id>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
					//Commented and modified by kailash on 01-10-18[end]
					valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
					valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
					valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( "" ).append( "]]></pitch_detail_descr>\r\n" );
					valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( scCode ).append( "]]></sc_code_pitch>\r\n" );
					//added by mrunalini sinkar for show the tag_line into brand sub form

					valueXmlString.append("<brand_tag_line><![CDATA[").append(tagLine).append("]]></brand_tag_line>\n");
					valueXmlString.append("<brand_sh_descr><![CDATA[").append(shDescr).append("]]></brand_sh_descr>\n");

					//added by mrunalini sinkar for Edetaling changes of real time report(adding contents tag)(start)
					//if(documentMap!=null && !documentMap.isEmpty() && documentMap.containsValue(brandCode))
					System.out.println("documentMap::"+documentMap);
					if(documentMap!=null && !documentMap.isEmpty() && (documentMap.containsValue(brandCode) || documentMap.containsValue("STRG_CODE")))
					{
						System.out.println("14107");
						
						for (Entry<String, String> documentEntry: documentMap.entrySet())
						{
							System.out.println("documentEntry.getValue()::"+documentEntry.getValue()+" brandCode:"+brandCode);
							
							if(brandCode.equals(documentEntry.getValue()) || "STRG_CODE".equalsIgnoreCase(documentEntry.getValue()))
							{
								String documentKey=documentEntry.getKey();
								System.out.println("docuemnet key:"+documentKey);
								String docPageInfo = "";
								String [] splitMapKey=documentKey.split("@");
								System.out.println("splitMapKey:"+splitMapKey);
								
								String docId=checkNull(splitMapKey[0]);
								String docName=checkNull(splitMapKey[1]);
								//String docRefId=checkNull(splitMapKey[3]);
								if(splitMapKey[3].trim().length()>0)
								{
									docPageInfo = checkNull(splitMapKey[3]); //commented and added by rupali on 30/07/18 for adding page_info in contents
								}
								String docRefId=checkNull(splitMapKey[4]);
								
								System.out.println("brandCode is:"+brandCode+"Attachment is:"+attachment);
								if(attachment==null || attachment.trim().length()==0)
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=docId + "::" +docName + ",";
									// attachment=docId + "::" +docName + "::" +docPageInfo +",";
									System.out.println("lin2 14136: "+attachment);
									
									attachment = docId + "::" + docName + "::" + docPageInfo + "~SEP~";
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]
								}
								else
								{
									//commented and added by rupali on 30/07/18 for adding page_info in contents [start]
									//attachment=attachment+docId + "::" +docName + ",";
									// attachment=attachment+docId + "::" +docName + "::" +docPageInfo +",";
									attachment = attachment + docId + "::" + docName + "::" + docPageInfo + "~SEP~";
									System.out.println("lin2 14148: "+attachment);
									//commented and added by rupali on 30/07/18 for adding page_info in contents [end]

								}
								//System.out.println("Attachment iss:"+attachment);

							}

						}
						System.out.println("line 14158::"+attachment);
						
						// if(attachment != null && attachment.length() > 0 && attachment.charAt(attachment.length() - 1) == ',')
						if(attachment != null && attachment.length() > 0 && attachment.endsWith("~SEP~"))
						{
							attachment = attachment.substring(0, attachment.length() - 5);
							System.out.println("Attachment scCode is:"+attachment+"sccode is:"+scCode);
						}

						valueXmlString.append("<contents><![CDATA[").append(attachment).append("]]></contents>\n");
					}
					else
					{
						System.out.println("line 14170");
						
						valueXmlString.append("<contents><![CDATA[").append("").append("]]></contents>\n");
					}
					//added by mrunalini sinkar for Edetaling changes of real time report(adding contents tag)(end)
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );

				}
				domID++;
			}
			valueXmlString.append( "</Root>\r\n" );
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :SavexWizardEJB :defaultDataDAR(Document,String):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :SavexWizardEJB :defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	
	}
	
	
}