package ibase.webitm.ejb.wsfa.masters;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ejb.Stateless;

import org.apache.poi.util.SystemOutLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

@Stateless
public class SmsParam extends ValidatorEJB {
	
	PreparedStatement pStmt = null;
	ResultSet rs = null;
	GenericUtility genericUtility = GenericUtility.getInstance();

	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try {
			BaseLogger.log("3",null,null,"xmlString:::" + xmlString);

			if (xmlString != null && xmlString.length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		} catch (Exception e) {
			BaseLogger.log("3",null,null,"Exception : HealthProfile : wfValData(String xmlString) : ==>\n " + e.getMessage());
		}
		return errString;
	}

	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		BaseLogger.log("3",null,null,"wfValData.....called.[abu]"+objContext);
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String columnValue = "";
		String userId="";
		int ctr = 0, currentFormNo = 1, childNodeListLength = 0, cnt = 0;
		String errString = "", errCode = "";
		String hrProfile = "", descr = "", shortDescr = "", profType = "", mesuremType = "", recordfreq = "";
		String msrType = "";
	    PreparedStatement pstmt = null;
	    ResultSet rs = null;
	    Connection connectionObject = null;
		try {
			//ConnDriver connDriver = new ConnDriver();
			connectionObject = getConnection();
//			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			BaseLogger.log("3",null,null,"wdom:::::::::: : " + genericUtility.serializeDom(dom));
			BaseLogger.log("3",null,null,"wdom11111111111111:::::::::: : " + genericUtility.serializeDom(dom1));
			BaseLogger.log("3",null,null,"wdom666666666:::::::::: : " + genericUtility.serializeDom(dom2));
			switch (currentFormNo) {
			case 1:// First Form
				parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				BaseLogger.log("3",null,null,"child node list length=" + childNodeListLength);
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					BaseLogger.log("3",null,null,"idchildNodeName.editFlag." + childNodeName + ".." + editFlag);
					BaseLogger.log("3",null,null,"Horaira-columnValue::" + columnValue);
					if (childNodeName.equalsIgnoreCase("PARAM_NAME")) 
					{

						BaseLogger.log("3",null,null,"Abu--FirstChild::" + childNode.getFirstChild());
						
						if (childNode.getFirstChild() == null) 
						{
						
							errString = getErrorString("param_name", "PRMNN", userId);
							break;
				
						}
						else if(childNode.getFirstChild() != null && editFlag.equalsIgnoreCase("A") )
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue());
							BaseLogger.log("3",null,null,"Abu-columnValue::" + columnValue);
							if( columnValue != null )
                            {
								System.out.println("Inside columnValue abu Hora"+columnValue);
                               String sql = "select  param_name  from smsparam  where param_name=?";
                           	System.out.println("Inside conn abu Hora"+connectionObject);
                                pstmt= connectionObject.prepareStatement(sql);
                                pstmt.setString(1, columnValue);
                                rs=pstmt.executeQuery();
                                if ( rs.next() )
                                {
                                	System.out.println("nested if block"+ errString);
                                    errString = getErrorString("param_name", "PRMNNDUP", userId);
                                    System.out.println("nested if block"+ errString);
                                	break;
                                }
                                if(rs != null)
                                {
                                    rs.close();
                                    rs = null;
                                }
                            }
						}
					}
					
					else if (childNodeName.equalsIgnoreCase("PARAM_VALUE"))
					{
						BaseLogger.log("3",null,null,"--ABU-- FirstChild::" + childNode.getFirstChild());
						if (childNode.getFirstChild() == null) 
						{
							errString = getErrorString("param_value", "PMVNN", userId);
							break;
						}
						if (childNode.getFirstChild() != null) 
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue());
							BaseLogger.log("3",null,null,"----descr--- columnValue::" + columnValue);
							if (columnValue.length() == 0) 
							{
								errString = getErrorString("param_value", "PMVNN", userId);
								break;
							}
						}
					}

					
					else if (childNodeName.equalsIgnoreCase("DESCR"))
					{
						BaseLogger.log("3",null,null,"--ABU-- FirstChild::" + childNode.getFirstChild());
						if (childNode.getFirstChild() == null) 
						{
							errString = getErrorString("descr", "DSRNN", userId);
							break;
						}
						if (childNode.getFirstChild() != null) 
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue());
							BaseLogger.log("3",null,null,"----descr--- columnValue::" + columnValue);
							if (columnValue.length() == 0) 
							{
								errString = getErrorString("descr", "DSRNN", userId);
								break;
							}
						}
					}

				}
				break;
			}
		}
		catch (Exception e) {
			BaseLogger.log("3",null,null,"Exception ::" + e);
			e.printStackTrace();
			errString = e.getMessage();
			
		} finally {
			try {
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if (connectionObject != null) {
					connectionObject.close();
					connectionObject=null;
				}
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		BaseLogger.log("3",null,null,"ErrString ::" + errString);
		return errString;

	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext,
			String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				BaseLogger.log("3",null,null,"xmlString>>>>" + xmlString);
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				BaseLogger.log("3",null,null,"xmlString1>>>>" + xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				BaseLogger.log("3",null,null,"xmlString2>>>>" + xmlString2);
				dom2 = genericUtility.parseString(xmlString2);
				BaseLogger.log("3",null,null,"dom2:::-" + genericUtility.serializeDom(dom2));
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			BaseLogger.log("3",null,null,"Exception :HealthProfile:itemChanged::::" + e.getMessage() + ":");
			e.printStackTrace();
		}
		BaseLogger.log("3",null,null,"returning from HealthProfile:itemChanged itemChanged");

		return valueXmlString;
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException, ITMException {
		BaseLogger.log("3",null,null,"Itemchanged Called[HealthProfile]-------");
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		NodeList parentNodeList = null;
		Node childNode = null;
		String userId = "";
		
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		Statement stmt = null;
		ResultSet rs = null;
		ResultSet rSet = null;
		String childNodeName = null;
		String chgDate = "", chgUser = "", chgTerm = "", addDate = "", addUser = "", addTerm = "";
		SimpleDateFormat sdf;
		Timestamp timestamp;
		try {
			BaseLogger.log("3",null,null,"dom:::::::::: : " + genericUtility.serializeDom(dom));
			BaseLogger.log("3",null,null,"dom11111111111111:::::::::: : " + genericUtility.serializeDom(dom1));
			BaseLogger.log("3",null,null,"dom222222222222222:::::::::: : " + genericUtility.serializeDom(dom2));
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());
			chgDate = (sdf.format(timestamp).toString()).trim();
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			BaseLogger.log("3",null,null,"Change Date :::-[" + chgDate + "]\n Change User:::-[" + chgUser
					+ "] \n Change Term:::-[" + chgTerm + "]");
			addDate = chgDate;
			addUser = chgUser;
			addTerm = chgTerm;
		//	ConnDriver conndriver = new ConnDriver();
//			conn = conndriver.getConnectDB("DriverITM");
			if (objContext != null && objContext.trim().length() > 0)
				currentFormNo = Integer.parseInt(objContext);
			BaseLogger.log("3",null,null,"current form no: " + currentFormNo);
			currentColumn = currentColumn == null ? "" : currentColumn.trim();
			BaseLogger.log("3",null,null,"currentColumn : " + currentColumn);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo) {
			case 1:// first From
				valueXmlString.append("<Detail1>");
				String getGradeCodeSql = "SELECT (UPPER (EMP_FNAME )|| '  ' || UPPER(EMP_MNAME) || '  ' || UPPER(EMP_LNAME) )AS EMP_NAME,EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
				pstmt = connectionObject.prepareStatement(getGradeCodeSql);
				pstmt.setString(1,loginEmpCode);
				rSet = pstmt.executeQuery();
				String empName ="";
				if( rSet.next())
				{
					empName =rSet.getString("EMP_NAME");
				}
				if(rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if ("itm_default".equalsIgnoreCase(currentColumn)) 
				{					 
					userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
					SimpleDateFormat formatter = new SimpleDateFormat(genericUtility.getApplDateFormat()); 
					Date dte = new Date();
					String currentDate = "";
					BaseLogger.log("3",null,null,"current Date::" + dte);
					try 
					{
						currentDate = formatter.format(dte);
						BaseLogger.log("3",null,null,"String current Date::" + currentDate);
					} 
					catch (Exception ae) {
					}
					valueXmlString.append("<add_user>").append("<![CDATA[" + addUser + "]]>").append("</add_user>");
					valueXmlString.append("<add_term>").append("<![CDATA[" + addTerm+ "]]>").append("</add_term>");
					valueXmlString.append("<chg_date>").append("<![CDATA[" +chgDate+ "]]>").append("</chg_date>");
					valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>");
					valueXmlString.append("<chg_term>").append("<![CDATA[" + chgTerm+ "]]>").append("</chg_term>");
					valueXmlString.append("<add_date>").append("<![CDATA[" + addDate+ "]]>").append("</add_date>");

				 } 
				else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit")) 
				{
					//valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>");
				}
				valueXmlString.append("</Detail1 >");
				break;

	

			}// End Switch
			valueXmlString.append("</Root>");
		} // End Try

		catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("3",null,null,"Exception ::" + e.getMessage());
			throw new ITMException(e);
		} finally {
			try {
				if (connectionObject != null) {
					connectionObject.close();
				}
				connectionObject = null;
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		BaseLogger.log("3",null,null,"\n HealthProfile:ValueXmlString :" + valueXmlString + ":*******");
		return valueXmlString.toString();

	}

	public static String checkNull(String input) {
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
			input = "";
		}
		return input.trim();
	}
}