/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.utility;

import ibase.bi.ejb.session.Column;
import ibase.bi.utility.BIContentWriter;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jxl.Cell;
import jxl.HeaderFooter;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.UnderlineStyle;
import jxl.write.Border;
import jxl.write.BorderLineStyle;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class BISpreadSheetWriter
implements BIContentWriter {
    Cell[] cellarray = null;
    WritableWorkbook ww = null;
    WritableSheet ws = null;
    WritableSheet ws1 = null;
    String grpInfo = null;
    int totColumns = 0;
    int totRows = 0;
    int colCnt = 0;
    int rowCnt = 1;
    int[] maxColumnWidth = null;
    int headerCount = 1;
    int alignment = 3;
    StringBuffer titleStr = new StringBuffer("");
    int wfHeaderfontSize = 10;
    Colour wfHeaderFGColour = Colour.BLACK;
    Colour wfHeaderBGColour = Colour.WHITE;
    WritableFont.FontName fntName = WritableFont.ARIAL;
    boolean wfHeaderitalic = false;
    UnderlineStyle wfHeaderUnderline = UnderlineStyle.NO_UNDERLINE;
    boolean wfHeaderBold = false;
    boolean isFirstP = true;
    String timeStampInfo = null;
    int counter = 1;
    String doc = null;
    String imgPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "bi" + File.separator + "resource" + File.separator + "common" + File.separator + "images";
    String headerData = "";
    boolean isheaderExist = false;

    public BISpreadSheetWriter(String docFile) throws Exception {
        this.doc = docFile;
        BaseLogger.log("1", null, null, "******inside********" + this.counter);
        WorkbookSettings wst = new WorkbookSettings();
        wst.setEncoding(CommonConstants.XLS_ENCODING);
        wst.setSuppressWarnings(true);
        wst.setPropertySets(true);
        this.ww = Workbook.createWorkbook((File)new File(docFile), (WorkbookSettings)wst);
        this.ww.setColourRGB(Colour.DARK_BLUE, 0, 0, 0);
        this.ws = this.ww.createSheet("Sheet1", 0);
    }

    @Override
    public void setCSSFile(String cssFile) throws Exception {
    }

    @Override
    public void setReportHeader(String repHeader) throws Exception {
        Label label = this.getFormattedHeader(repHeader == null ? "" : repHeader, this.alignment);
        this.ws.addCell((WritableCell)label);
    }

    @Override
    public void setGroupInfo(String grpInfo) throws Exception {
        if (grpInfo != null) {
            ++this.headerCount;
            this.rowCnt = 2;
        }
        this.grpInfo = grpInfo;
    }

    @Override
    public void setPageSize(String pageSize, boolean isPotrate) throws Exception {
        if (pageSize.equalsIgnoreCase("A4")) {
            if (isPotrate) {
                this.ws.setPageSetup(PageOrientation.PORTRAIT, PaperSize.A4, 0.5, 0.5);
            } else {
                this.ws.setPageSetup(PageOrientation.LANDSCAPE, PaperSize.A4, 0.5, 0.5);
            }
        }
    }

    @Override
    public void setPageSize(float pageWidth, float pageHeight) throws Exception {
    }

    @Override
    public void setPageMargin(float marginLeft, float marginRight, float marginTop, float marginBottom) throws Exception {
        this.ws.getSettings().setLeftMargin((double)marginLeft);
        this.ws.getSettings().setRightMargin((double)marginRight);
        this.ws.getSettings().setTopMargin((double)marginTop);
        this.ws.getSettings().setBottomMargin((double)marginBottom);
        this.ws.getSettings().setHeaderMargin((double)marginTop < 0.5 ? (double)marginTop : 0.5);
        this.ws.getSettings().setFooterMargin((double)marginBottom < 0.5 ? (double)marginBottom : 0.5);
    }

    @Override
    public void setPageHeader(String pageHeader, int alignment, boolean showPageNo) throws Exception {
        this.headerData = pageHeader;
        BaseLogger.log("3", null, null, "headerData[" + this.headerData + "]");
        if (this.headerData != null && this.headerData.length() > 0) {
            this.isheaderExist = true;
        }
        HeaderFooter header = new HeaderFooter();
        Label label = this.getFormattedHeader(pageHeader == null ? "" : pageHeader, alignment);
        this.ws.addCell((WritableCell)label);
        switch (alignment) {
            case 1: {
                if (!showPageNo) break;
                header.getLeft().appendPageNumber();
                break;
            }
            case 2: {
                if (!showPageNo) break;
                header.getRight().appendPageNumber();
                break;
            }
            case 3: {
                if (!showPageNo) break;
                header.getCentre().appendPageNumber();
            }
        }
        this.ws.getSettings().setHeader(header);
    }

    @Override
    public void setPageFooter(String pageFooter, int alignment, boolean showPageNo) throws Exception {
        HeaderFooter footer = new HeaderFooter();
        switch (alignment) {
            case 1: {
                footer.getLeft().append(pageFooter);
                if (!showPageNo) break;
                footer.getLeft().appendPageNumber();
                break;
            }
            case 2: {
                footer.getRight().append(pageFooter);
                if (!showPageNo) break;
                footer.getRight().appendPageNumber();
                break;
            }
            case 3: {
                footer.getCentre().append(pageFooter);
                if (!showPageNo) break;
                footer.getCentre().appendPageNumber();
            }
        }
        this.ws.getSettings().setFooter(footer);
    }

    @Override
    public void setReportFooter(String repFooter) throws Exception {
    }

    @Override
    public void setHeaderCount(int headerCount) throws Exception {
        this.headerCount = headerCount;
        if (this.grpInfo != null) {
            ++this.headerCount;
        }
    }

    @Override
    public boolean createTable(float[] defaultColWidthArr, boolean fittowidth) throws Exception {
        BaseLogger.log("2", null, null, "******inside createTable*******");
        boolean created = false;
        this.totColumns = defaultColWidthArr.length;
        int i = 0;
        while (i < this.totColumns) {
            this.ws.setColumnView(i, (int)defaultColWidthArr[i]);
            ++i;
        }
        this.maxColumnWidth = new int[this.totColumns];
        created = true;
        return created;
    }

    @Override
    public void setTableWidthPercentage(float percentage) throws Exception {
    }

    @Override
    public boolean addDataCell(String data, int colspan, Column formatingObj) throws Exception {
        String path;
        int excelMaxRows;
        boolean created = false;
        int mergeCell = 0;
        boolean isheaderCell = false;
        WritableCellFormat wcf = null;
        WritableCell wc = null;
        String addataType = formatingObj.getDataType();
        String oldData = data;
        StringBuffer sbData = new StringBuffer(data);
        int pipeIndex = data.indexOf("|");
        while (pipeIndex != -1) {
            sbData.replace(pipeIndex, pipeIndex + 1, "\n");
            data = sbData.toString();
            pipeIndex = data.indexOf("|");
        }
        wcf = this.getCellFormat(formatingObj, true);
        if (this.colCnt >= this.totColumns) {
            ++this.rowCnt;
            this.colCnt = 0;
        }
        if (colspan > 1) {
            if (addataType.equalsIgnoreCase("IMAGE")) {
                if (new File(String.valueOf(this.imgPath) + File.separator + data).isDirectory()) {
                    wc = this.getWritableCell(this.colCnt, this.rowCnt, "", wcf, formatingObj.getDataType(), formatingObj.getDisplayPattern());
                    wc.setCellFormat((CellFormat)wcf);
                    this.ws.addCell(wc);
                } else {
                    String path2 = !new File(String.valueOf(this.imgPath) + File.separator + data).exists() ? String.valueOf(this.imgPath) + File.separator + "default.jpg" : String.valueOf(this.imgPath) + File.separator + data;
                    File imgfile = new File(path2);
                    WritableImage wi = new WritableImage((double)this.colCnt, (double)this.rowCnt, 1.0, 1.0, imgfile);
                    this.ws.addImage(wi);
                }
            } else {
                wc = this.getWritableCell(this.colCnt, this.rowCnt, data, wcf, formatingObj.getDataType(), formatingObj.getDisplayPattern());
                wc.setCellFormat((CellFormat)wcf);
                this.ws.addCell(wc);
                mergeCell = this.colCnt + (colspan - 1);
                this.ws.mergeCells(this.colCnt, this.rowCnt, mergeCell, this.rowCnt);
                this.colCnt = mergeCell;
            }
        }
        if (this.rowCnt > this.headerCount) {
            data = oldData;
            wcf.uninitialize();
            wcf = null;
            wcf = this.getCellFormat(formatingObj, false);
        }
        int colWidth = 0;
        if (formatingObj.getWidth() != null && formatingObj.getWidth().trim().length() > 0) {
            colWidth = Integer.parseInt(formatingObj.getWidth());
        }
        if (this.maxColumnWidth[this.colCnt] < colWidth) {
            this.maxColumnWidth[this.colCnt] = colWidth;
        }
        if (this.rowCnt < (excelMaxRows = Integer.parseInt(CommonConstants.SPREADSHEET_MAX_ROWS)) + (this.headerCount + 1)) {
            if (addataType.equalsIgnoreCase("IMAGE")) {
                if (new File(String.valueOf(this.imgPath) + File.separator + data).isDirectory()) {
                    wc = this.getWritableCell(this.colCnt++, this.rowCnt, "", wcf, formatingObj.getDataType(), formatingObj.getDisplayPattern());
                    this.ws.addCell(wc);
                } else {
                    path = !new File(String.valueOf(this.imgPath) + File.separator + data).exists() ? String.valueOf(this.imgPath) + File.separator + "default.jpg" : String.valueOf(this.imgPath) + File.separator + data;
                    File imgfile = new File(path);
                    WritableImage wi = new WritableImage((double)this.colCnt++, (double)this.rowCnt, 1.0, 1.0, imgfile);
                    this.ws.addImage(wi);
                }
            } else {
                wc = this.getWritableCell(this.colCnt++, this.rowCnt, data, wcf, formatingObj.getDataType(), formatingObj.getDisplayPattern());
                this.ws.addCell(wc);
            }
        } else {
            this.totRows = this.totRows + this.rowCnt - (this.headerCount + 1);
            this.rowCnt = this.headerCount + 1;
            ++this.counter;
            this.ws1 = this.ww.createSheet("Sheet" + this.counter, this.counter);
            if (addataType.equalsIgnoreCase("IMAGE")) {
                if (new File(String.valueOf(this.imgPath) + File.separator + data).isDirectory()) {
                    wc = this.getWritableCell(this.colCnt++, this.rowCnt, "", wcf, formatingObj.getDataType(), formatingObj.getDisplayPattern());
                    this.ws1.addCell(wc);
                } else {
                    path = !new File(String.valueOf(this.imgPath) + File.separator + data).exists() ? String.valueOf(this.imgPath) + File.separator + "default.jpg" : String.valueOf(this.imgPath) + File.separator + data;
                    File imgfile = new File(path);
                    WritableImage wi = new WritableImage((double)this.colCnt++, (double)this.rowCnt, 1.0, 1.0, imgfile);
                    this.ws1.addImage(wi);
                }
            } else {
                wc = this.getWritableCell(this.colCnt++, this.rowCnt, data, wcf, formatingObj.getDataType(), formatingObj.getDisplayPattern());
                this.ws1.addCell(wc);
            }
            int i = 1;
            while (i <= this.headerCount) {
                this.cellarray = this.ws.getRow(i);
                int j = 0;
                while (j < this.cellarray.length) {
                    Cell c1 = this.cellarray[j];
                    WritableCell wc1 = ((WritableCell)c1).copyTo(c1.getColumn(), c1.getRow());
                    this.ws1.addCell(wc1);
                    ++j;
                }
                ++i;
            }
            this.ws = this.ws1;
        }
        created = true;
        return created;
    }

    private WritableCell getWritableCell(int col, int row, String data, WritableCellFormat writableCellFormat, String datatype, String displayPattern) {
        Label writableCell = null;
        try {
            if (this.getDataType(datatype).equalsIgnoreCase("DATE")) {
                if (data != null) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(displayPattern);
                        sdf.setLenient(true);
                        writableCell = new Label(col, row, data, (CellFormat)writableCellFormat);
                    }
                    catch (NullPointerException npe) {
                        writableCell = new Label(col, row, data, (CellFormat)writableCellFormat);
                    }
                }
            } else if (this.getDataType(datatype).equalsIgnoreCase("NUMBER")) {
                try {
                    StringBuffer sbData = new StringBuffer(data);
                    int indx = 0;
                    while ((indx = sbData.toString().indexOf(",")) != -1) {
                        sbData = sbData.replace(indx, indx + 1, "");
                    }
                    double numberData = Double.parseDouble(sbData.toString());
                    writableCell = new Number(col, row, numberData, (CellFormat)writableCellFormat);
                }
                catch (NumberFormatException nfe) {
                    writableCell = new Label(col, row, data, (CellFormat)writableCellFormat);
                }
            } else {
                writableCell = new Label(col, row, data, (CellFormat)writableCellFormat);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : BISpreadSheetWriter: getCellValue: " + e);
        }
        return writableCell;
    }

    private String getDataType(String datatype) {
        if (datatype.toUpperCase().indexOf("DATETIME") != -1 || datatype.toUpperCase().indexOf("DATE") != -1 || datatype.toUpperCase().indexOf("TIMESTAMP") != -1) {
            return "DATE";
        }
        if (datatype.toUpperCase().indexOf("DECIMAL") != -1 || datatype.toUpperCase().indexOf("DOUBLE") != -1 || datatype.toUpperCase().indexOf("NUMBER") != -1 || datatype.toUpperCase().indexOf("LONG") != -1) {
            return "NUMBER";
        }
        return "STRING";
    }

    private WritableCellFormat getCellFormat(Column formatingObj, boolean isHeaderCell) throws Exception {
        WritableCellFormat wcf = null;
        if (formatingObj != null) {
            WritableFont wf = this.getFontForColumn(formatingObj);
            wcf = new WritableCellFormat(wf);
            if (isHeaderCell) {
                wf.setColour(Colour.WHITE);
                wcf.setBackground(Colour.DARK_BLUE);
            } else {
                Object displayFormat = null;
                String displayPattern = formatingObj.getDisplayPattern();
                String datatype = formatingObj.getDataType();
                if (this.getDataType(datatype).equalsIgnoreCase("DATE")) {
                    displayFormat = displayPattern != null && displayPattern.trim().length() > 0 ? new DateFormat(displayPattern) : DateFormats.DEFAULT;
                } else if (this.getDataType(datatype).equalsIgnoreCase("NUMBER")) {
                    displayFormat = displayPattern != null && displayPattern.trim().length() > 0 ? new NumberFormat(displayPattern) : NumberFormats.DEFAULT;
                }
                wcf = displayFormat == null ? new WritableCellFormat() : new WritableCellFormat(displayFormat);
                wcf.setFont((FontRecord)wf);
            }
            wcf.setWrap(true);
            if (formatingObj.getBGColor() != null && formatingObj.getBGColor().trim().length() >= 6) {
                wcf.setBackground(this.getColor(formatingObj.getBGColor(), "CellDataBG"));
            }
            switch (Integer.parseInt(formatingObj.getAlignment())) {
                case 1: {
                    wcf.setAlignment(Alignment.LEFT);
                    break;
                }
                case 2: {
                    wcf.setAlignment(Alignment.RIGHT);
                    break;
                }
                case 3: {
                    wcf.setAlignment(Alignment.CENTRE);
                    break;
                }
                default: {
                    wcf.setAlignment(Alignment.GENERAL);
                }
            }
        }
        return wcf;
    }

    private Colour getColor(String color, String type) throws Exception {
        int hexVal = 0;
        Colour colour = Colour.AUTOMATIC;
        color = color.trim();
        color = color.substring(1);
        hexVal = Integer.parseInt(color, 16);
        Color clr = new Color(hexVal);
        if (type.equals("CellDataBG")) {
            this.ww.setColourRGB(Colour.PLUM, clr.getRed(), clr.getGreen(), clr.getBlue());
            colour = Colour.PLUM;
        } else if (type.equals("CellDataFG")) {
            this.ww.setColourRGB(Colour.PINK, clr.getRed(), clr.getGreen(), clr.getBlue());
            colour = Colour.PINK;
        } else if (type.equals("PageHeaderFG")) {
            this.ww.setColourRGB(Colour.LIME, clr.getRed(), clr.getGreen(), clr.getBlue());
            colour = Colour.LIME;
        } else if (type.equals("PageHeaderBG")) {
            this.ww.setColourRGB(Colour.ORANGE, clr.getRed(), clr.getGreen(), clr.getBlue());
            colour = Colour.ORANGE;
        }
        return colour;
    }

    private WritableFont getFontForColumn(Column formatingObj) throws Exception {
        WritableFont fontObj = null;
        if (formatingObj != null) {
            if (formatingObj.getFont() != null) {
                String fontStr = formatingObj.getFont();
                fontObj = fontStr.equalsIgnoreCase("Courier") ? new WritableFont(WritableFont.COURIER) : (fontStr.equalsIgnoreCase("Arial") ? new WritableFont(WritableFont.ARIAL) : (fontStr.startsWith("Times") ? new WritableFont(WritableFont.TIMES) : new WritableFont(WritableFont.createFont((String)fontStr))));
            }
            fontObj.setPointSize(formatingObj.getFontSize());
            if (formatingObj.getBold() == 1) {
                fontObj.setBoldStyle(WritableFont.BOLD);
            }
            fontObj.setItalic(formatingObj.getItalic() == 1);
            if (formatingObj.getUnderline() == 1) {
                fontObj.setUnderlineStyle(UnderlineStyle.SINGLE);
            }
            if (formatingObj.getFGColor() != null && formatingObj.getFGColor().trim().length() >= 6) {
                fontObj.setColour(this.getColor(formatingObj.getFGColor(), "CellDataFG"));
            }
        }
        return fontObj == null ? new WritableFont(WritableFont.TIMES) : fontObj;
    }

    @Override
    public void setNewPageForGroup(boolean isNewPageForGroup) throws Exception {
        BaseLogger.log("3", null, null, "*****newpage**********");
    }

    @Override
    public void setTimeStampInfo(String timeStampInfo) throws Exception {
        this.timeStampInfo = timeStampInfo;
    }

    @Override
    public boolean writeDocument() throws Exception {
        boolean created = false;
        if (this.grpInfo != null) {
            Label label = new Label(0, 1, this.grpInfo);
            this.ws.addCell((WritableCell)label);
            this.ws.mergeCells(0, 1, this.totColumns - 1, 1);
        }
        if (this.ww != null) {
            if (this.alignment > 1) {
                this.ws.mergeCells(0, 0, this.totColumns - 1, 0);
            }
            if (this.headerData.equals("")) {
                BaseLogger.log("3", null, null, "Inside BISpreadSheetWritter line no  797");
                this.ws.removeRow(0);
            }
            WritableSheet[] wss = null;
            wss = this.ww.getSheets();
            int j = 0;
            while (j < wss.length) {
                WritableSheet ws2 = this.ww.getSheet(j);
                BaseLogger.log("3", null, null, "isheaderExist[" + this.isheaderExist + "]");
                if (this.isheaderExist) {
                    ws2.getSettings().setVerticalFreeze(this.headerCount + 1);
                } else {
                    ws2.getSettings().setVerticalFreeze(this.headerCount);
                }
                int i = 0;
                while (i < this.maxColumnWidth.length) {
                    float columnWidth = this.maxColumnWidth[i] * 100 / 746;
                    ws2.setColumnView(i, (int)columnWidth);
                    ++i;
                }
                ++j;
            }
            this.totRows += this.rowCnt;
            int recs = this.totRows - this.headerCount;
            this.ww.write();
        }
        created = true;
        return created;
    }

    @Override
    public boolean closeDocument() throws Exception {
        boolean closed = false;
        if (this.ww != null) {
            this.ww.close();
        }
        closed = true;
        return closed;
    }

    private Label getFormattedHeader(String pageHeader, int alignment) throws Exception {
        DocumentBuilder parser;
        Document dom;
        NodeList htmlNodeList;
        Label lbl = new Label(0, 0, pageHeader);
        String align = "";
        this.alignment = alignment;
        while (pageHeader.indexOf("&nbsp") != -1) {
            int index = pageHeader.indexOf("&nbsp");
            String beforeNbsp = pageHeader.substring(0, index);
            String afterNbsp = pageHeader.substring(index + 6, pageHeader.length());
            pageHeader = String.valueOf(beforeNbsp) + " " + afterNbsp;
        }
        while (pageHeader.indexOf("~<img") != -1) {
            int startIndex = pageHeader.indexOf("~<img");
            int endIndex = pageHeader.indexOf("/>", startIndex);
            String beforeImg = pageHeader.substring(0, startIndex);
            String afterImg = pageHeader.substring(endIndex + 2, pageHeader.length());
            pageHeader = String.valueOf(beforeImg) + afterImg;
        }
        if (pageHeader.indexOf("~") != -1) {
            pageHeader = pageHeader.replace('~', ' ');
        }
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("<html>");
        strbuf.append(pageHeader);
        strbuf.append("</html>");
        pageHeader = strbuf.toString();
        if (pageHeader.indexOf("align") != -1) {
            String headerLignment = pageHeader.replace('\"', ':');
            align = headerLignment.substring(headerLignment.indexOf(":") + 1, headerLignment.length());
            if ((align = align.substring(0, align.indexOf(":"))).equalsIgnoreCase("left")) {
                this.alignment = 1;
            } else if (align.equalsIgnoreCase("right")) {
                this.alignment = 2;
            }
            BaseLogger.log("3", null, null, "alignment[" + alignment + "]");
        }
        if ((htmlNodeList = (dom = (parser = DocumentBuilderFactory.newInstance().newDocumentBuilder()).parse(new ByteArrayInputStream(pageHeader.getBytes(CommonConstants.ENCODING)))).getElementsByTagName("html")).getLength() != 0) {
            this.recursion(htmlNodeList.item(0));
        }
        WritableFont wf = new WritableFont(this.fntName);
        wf = this.wfHeaderBold ? new WritableFont(this.fntName, this.wfHeaderfontSize, WritableFont.NO_BOLD, this.wfHeaderitalic, this.wfHeaderUnderline, this.wfHeaderFGColour) : new WritableFont(this.fntName, this.wfHeaderfontSize, WritableFont.BOLD, this.wfHeaderitalic, this.wfHeaderUnderline, this.wfHeaderFGColour);
        WritableCellFormat wcfHeader = new WritableCellFormat(wf);
        wcfHeader.setBorder(Border.ALL, BorderLineStyle.THIN);
        wcfHeader.setBackground(this.wfHeaderBGColour);
        switch (this.alignment) {
            case 1: {
                wcfHeader.setAlignment(Alignment.LEFT);
                break;
            }
            case 2: {
                wcfHeader.setAlignment(Alignment.RIGHT);
                break;
            }
            case 3: {
                wcfHeader.setAlignment(Alignment.CENTRE);
                break;
            }
            default: {
                wcfHeader.setAlignment(Alignment.GENERAL);
            }
        }
        lbl = new Label(0, 0, this.titleStr.toString(), (CellFormat)wcfHeader);
        return lbl;
    }

    private void recursion(Node node) throws Exception {
        this.titleStr.append(this.nodDetail(node));
        if (node.hasChildNodes()) {
            NodeList nodeClist = node.getChildNodes();
            int i = 0;
            while (i < nodeClist.getLength()) {
                Node childnode = nodeClist.item(i);
                this.recursion(childnode);
                ++i;
            }
        }
    }

    private String nodDetail(Node nd) throws Exception {
        String text;
        String titleStr = "";
        if (nd.getNodeType() == 1) {
            if ("font".equalsIgnoreCase(nd.getNodeName())) {
                NamedNodeMap attriBMap = nd.getAttributes();
                int j = 0;
                while (j < attriBMap.getLength()) {
                    String styleName;
                    String fontStyle;
                    int index;
                    Node attriBNode = attriBMap.item(j);
                    if ("size".equalsIgnoreCase(attriBNode.getNodeName())) {
                        String fontSize = attriBNode.getNodeValue();
                        this.wfHeaderfontSize = Integer.parseInt(fontSize) * 5;
                    }
                    if ("color".equalsIgnoreCase(attriBNode.getNodeName())) {
                        String fontColor = attriBNode.getNodeValue();
                        this.wfHeaderFGColour = this.getColor(fontColor, "PageHeaderFG");
                    }
                    if ("face".equalsIgnoreCase(attriBNode.getNodeName())) {
                        String fontFace = attriBNode.getNodeName();
                        this.fntName = WritableFont.createFont((String)fontFace);
                    }
                    if ("style".equalsIgnoreCase(attriBNode.getNodeName()) && (index = (fontStyle = attriBNode.getNodeValue().toUpperCase()).indexOf(":")) != -1 && ("BGCOLOR".equalsIgnoreCase(styleName = fontStyle.substring(0, index)) || "background-color".equalsIgnoreCase(styleName))) {
                        String bgColor = fontStyle.substring(index + 1, fontStyle.length());
                        this.wfHeaderBGColour = this.getColor(bgColor, "PageHeaderBG");
                    }
                    ++j;
                }
            } else if ("b".equalsIgnoreCase(nd.getNodeName()) || "strong".equalsIgnoreCase(nd.getNodeName())) {
                this.wfHeaderBold = true;
            } else if ("u".equalsIgnoreCase(nd.getNodeName())) {
                this.wfHeaderUnderline = UnderlineStyle.SINGLE;
            } else if ("i".equalsIgnoreCase(nd.getNodeName()) || "em".equalsIgnoreCase(nd.getNodeName())) {
                this.wfHeaderitalic = true;
            } else if (!"strike".equalsIgnoreCase(nd.getNodeName()) && "p".equalsIgnoreCase(nd.getNodeName())) {
                if (!this.isFirstP) {
                    titleStr = String.valueOf(titleStr) + "\n";
                } else {
                    this.isFirstP = false;
                }
            }
        } else if (nd.getNodeType() == 3 && (text = nd.getNodeValue()) != null) {
            titleStr = text;
        }
        return titleStr;
    }

    @Override
    public void setSuppressGrid(boolean isSuppressGrid) throws Exception {
    }
}

