/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.wrkflw.WorkflowEngineEJB;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.naming.InitialContext;

public class AbortWorkflow {
    WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor;

    public String abortWrkflw(String processInstanceId) throws BaseException, Exception {
        Object pStmtAbortWrkflw = null;
        Object rsWfPrcStatus = null;
        boolean isError = false;
        String retString = "";
        Connection conn = null;
        try {
            retString = this.abortWrkflw(processInstanceId, conn);
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "@@@@ Ashish BaseException :" + be.getMessage());
            be.printStackTrace();
            isError = true;
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "@@@@ Ashish Exception :" + e.getMessage());
            e.printStackTrace();
            isError = true;
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
        }
        return retString;
    }

    public String abortWrkflw(String processInstanceId, Connection conn) throws BaseException, Exception {
        Statement pStmtAbortWrkflw = null;
        ResultSet rsWfPrcStatus = null;
        boolean isError = false;
        String retString = "";
        boolean isLocalConn = false;
        try {
            try {
                this.workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
                WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitorLocal = new WorkflowProcessInstanceMonitorEJB();
                WorkflowLogger.info("[AbortWorkflow] Aborting workflow for processInstanceId [ " + processInstanceId + " ] ");
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                if (conn == null) {
                    conn = this.getConnection();
                    conn.setAutoCommit(false);
                    isLocalConn = true;
                }
                String sqlAbortWrkflw = "UPDATE WF_PRC_STATUS SET WF_ABORT = 'Y' WHERE PROCESS_ID = ? AND INSTANCE_ID =? ";
                pStmtAbortWrkflw = conn.prepareStatement(sqlAbortWrkflw);
                pStmtAbortWrkflw.setString(1, processId);
                pStmtAbortWrkflw.setInt(2, Integer.parseInt(instanceId));
                int updateCnt = pStmtAbortWrkflw.executeUpdate();
                if (updateCnt > 0) {
                    BaseLogger.log("3", null, null, "Workflow Abort status updated...");
                    WorkflowEngineEJB workflowEngineEJB = new WorkflowEngineEJB();
                    workflowEngineEJB.updateTransWfStatus(processId, instanceId, "Worklow Aborted for instance id :" + instanceId, conn);
                    retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Completing : " + processInstanceId + "]]></RESULT></ROOT>";
                    BaseLogger.log("3", null, null, "@@@@ retString :[ " + retString + " ]");
                    BaseLogger.log("3", null, null, "workflowProcessInstanceMonitorLocal : [ " + workflowProcessInstanceMonitorLocal.toString() + " ]");
                    isError = workflowProcessInstanceMonitorLocal.updateActivityStatus(processInstanceId, "2", "", "", "", "", "E", retString, conn);
                    BaseLogger.log("3", null, null, "@@@@ isError :[ " + isError + " ]");
                } else {
                    BaseLogger.log("3", null, null, "Workflow Abort Fail...");
                }
                pStmtAbortWrkflw.close();
                pStmtAbortWrkflw = null;
            }
            catch (BaseException be) {
                BaseLogger.log("0", null, null, "@@@@ Ashish BaseException :" + be.getMessage());
                be.printStackTrace();
                isError = true;
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
                retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                try {
                    if (pStmtAbortWrkflw != null) {
                        pStmtAbortWrkflw.close();
                        pStmtAbortWrkflw = null;
                    }
                    if (rsWfPrcStatus != null) {
                        rsWfPrcStatus.close();
                        rsWfPrcStatus = null;
                    }
                    if (conn != null && isLocalConn) {
                        if (isError) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :AbortWorkflow :abortWrkflw :==>finally\n" + e.getMessage());
                    WorkflowLogger.info("Exception occured : abortWrkflw : finally : [" + e.getMessage() + "]");
                    String workflowErrDirectory2 = this.sendErrMail(processInstanceId, "");
                    retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory2 + " for detail ]]></RESULT></ROOT>";
                    throw new BaseException(e);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "@@@@ Ashish Exception :" + e.getMessage());
                e.printStackTrace();
                isError = true;
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
                retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                try {
                    if (pStmtAbortWrkflw != null) {
                        pStmtAbortWrkflw.close();
                        pStmtAbortWrkflw = null;
                    }
                    if (rsWfPrcStatus != null) {
                        rsWfPrcStatus.close();
                        rsWfPrcStatus = null;
                    }
                    if (conn != null && isLocalConn) {
                        if (isError) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    System.err.println("Exception :AbortWorkflow :abortWrkflw :==>finally\n" + e2.getMessage());
                    WorkflowLogger.info("Exception occured : abortWrkflw : finally : [" + e2.getMessage() + "]");
                    String workflowErrDirectory3 = this.sendErrMail(processInstanceId, "");
                    retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory3 + " for detail ]]></RESULT></ROOT>";
                    throw new BaseException(e2);
                }
            }
        }
        finally {
            try {
                if (pStmtAbortWrkflw != null) {
                    pStmtAbortWrkflw.close();
                    pStmtAbortWrkflw = null;
                }
                if (rsWfPrcStatus != null) {
                    rsWfPrcStatus.close();
                    rsWfPrcStatus = null;
                }
                if (conn != null && isLocalConn) {
                    if (isError) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :AbortWorkflow :abortWrkflw :==>finally\n" + e.getMessage());
                WorkflowLogger.info("Exception occured : abortWrkflw : finally : [" + e.getMessage() + "]");
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
                retString = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                throw new BaseException(e);
            }
        }
        return retString;
    }

    private Connection getConnection() throws BaseException {
        Connection con = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return con;
    }

    private String sendErrMail(String processInstanceId, String resultStr) {
        String wrkflwErrDirectory = "";
        try {
            wrkflwErrDirectory = this.workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, resultStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrkflwErrDirectory;
    }

    private InitialContext getInitialContext() throws BaseException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return ctx;
    }
}

