/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.common.system.config.DBInfo;
import ibase.bi.ejb.session.DBAccessEJB;
import ibase.bi.ejb.session.TableInfoBean;
import ibase.bi.ejb.session.XMLExplorer;
import ibase.bi.utility.BIException;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BIRowSecurity {
    int baID;
    String userID;
    String profileID;
    String baName;
    private ArrayList selectedTables = new ArrayList();
    XMLExplorer xe = null;

    public BIRowSecurity() {
        BaseLogger.log("2", null, null, "BIRowSecurity Obj Created");
    }

    public BIRowSecurity(int baID, String userID, String profileID, String baName) throws Exception {
        try {
            BaseLogger.log("1", null, null, "BIRowSecurity Obj Created");
            this.baID = baID;
            this.userID = userID;
            this.profileID = profileID;
            this.baName = baName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getRowSecurityQuery(String query, XMLExplorer xe) throws Exception {
        try {
            this.xe = xe;
            String tempQuery = query.toUpperCase();
            int fromIndex = tempQuery.indexOf(" FROM ");
            int whereIndex = tempQuery.indexOf(" WHERE ");
            int groupByIndex = tempQuery.indexOf(" GROUP BY ");
            int havingIndex = tempQuery.indexOf(" HAVING ");
            StringBuffer finalQuery = new StringBuffer();
            String selectPart = query.substring(0, fromIndex);
            BaseLogger.log("3", null, null, "SELECT Part :" + selectPart);
            String fromPart = null;
            String wherePart = "";
            String joinPredicates = this.readJoinInfo();
            if (fromIndex != -1) {
                fromPart = query.substring(fromIndex + " FROM ".length());
            }
            if (whereIndex != -1) {
                fromPart = query.substring(fromIndex + " FROM ".length(), whereIndex);
                BaseLogger.log("3", null, null, "FROM Part[with where] :" + fromPart);
                wherePart = query.substring(whereIndex);
                BaseLogger.log("3", null, null, "WHERE Part[with where] :" + wherePart);
            } else if (groupByIndex != -1) {
                fromPart = query.substring(fromIndex + " FROM ".length(), groupByIndex);
                BaseLogger.log("3", null, null, "FROM Part[without WHERE and with GROUP BY] :" + fromPart);
                wherePart = query.substring(groupByIndex);
                BaseLogger.log("3", null, null, "WHERE Part[without WHERE and with GROUP BY] :" + wherePart);
            } else if (havingIndex != -1) {
                fromPart = query.substring(fromIndex + " FROM ".length(), havingIndex);
                BaseLogger.log("3", null, null, "FROM Part[without WHERE and with HAVING] :" + fromPart);
                wherePart = query.substring(havingIndex);
                BaseLogger.log("3", null, null, "WHERE Part[without WHERE and with HAVING] :" + wherePart);
            }
            fromPart = this.buildFrom(fromPart);
            String rowSecurityWhere = this.readRowSecurity();
            wherePart = this.buildWhere(wherePart, rowSecurityWhere, joinPredicates);
            finalQuery.append(selectPart);
            finalQuery.append(fromPart);
            finalQuery.append(wherePart);
            return finalQuery.toString();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private String readRowSecurity() throws Exception {
        StringBuffer securityBuffer = new StringBuffer();
        HashMap rowSecurityInfo = this.getBIRowSecurity();
        String isForced = null;
        String temp2 = null;
        String tableName = null;
        if (rowSecurityInfo != null) {
            for (String temp2 : rowSecurityInfo.keySet()) {
                int index = temp2.indexOf(46);
                isForced = temp2.substring(0, index);
                tableName = temp2.substring(index + 1);
                if (this.selectedTables.contains(tableName)) {
                    securityBuffer.append(rowSecurityInfo.get(temp2) + " AND ");
                    continue;
                }
                if (isForced == null || !isForced.equalsIgnoreCase("F")) continue;
                securityBuffer.append(rowSecurityInfo.get(temp2) + " AND ");
                this.selectedTables.add(tableName);
            }
        }
        if (securityBuffer != null && securityBuffer.length() > 0) {
            int index = securityBuffer.toString().lastIndexOf(" AND ");
            if (index != -1) {
                securityBuffer.replace(index, index + 5, " ");
            }
            return securityBuffer.toString().trim();
        }
        return null;
    }

    private HashMap getBIRowSecurity() throws Exception {
        try {
            String driverInfo = this.xe.driverInfo;
            String driverUsed = null;
            AppConnectParm appConnect = new AppConnectParm("bi");
            Properties props = appConnect.getProperty();
            InitialContext ctx = new InitialContext(props);
            DBAccessEJB mDBAccessRemote = new DBAccessEJB();
            driverUsed = driverInfo != null ? driverInfo : this.baName;
            String xml = mDBAccessRemote.getRowSecurity(this.baID, this.userID, this.profileID, driverUsed);
            if (!xml.equals("")) {
                HashMap<String, String> rowSecurityInfo = new HashMap<String, String>();
                ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.parse(new InputSource(bais));
                NodeList nl = doc.getElementsByTagName("TABLE");
                int ctr = 0;
                while (ctr < nl.getLength()) {
                    String lineNo = nl.item(ctr).getAttributes().getNamedItem("LINE_NO").getNodeValue();
                    String tableName = nl.item(ctr).getAttributes().getNamedItem("NAME").getNodeValue();
                    String condition = nl.item(ctr).getFirstChild().getNodeValue();
                    rowSecurityInfo.put(tableName, condition);
                    ++ctr;
                }
                return rowSecurityInfo;
            }
            return null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BIRowSecurity :getBIRowSecurity()");
            throw e;
        }
    }

    private String readJoinInfo() throws Exception {
        try {
            this.addViaTables();
            DBInfo dbInfo = DBInfo.newInstance(this.xe.dbName);
            StringBuffer joinWhere = new StringBuffer();
            Iterator iter = this.xe.joinOrder.keySet().iterator();
            while (iter.hasNext()) {
                String curTableName = ((String)this.xe.joinOrder.get(iter.next())).trim();
                if (!this.selectedTables.contains(curTableName) || !this.xe.joinInfo.containsKey(curTableName)) continue;
                TableInfoBean currInfo = (TableInfoBean)this.xe.joinInfo.get(curTableName);
                ArrayList forKey = currInfo.getForeignKeys();
                int ctr = 0;
                while (ctr < forKey.size()) {
                    StringTokenizer tokens = new StringTokenizer((String)forKey.get(ctr), "#");
                    String lhsKeyID = tokens.nextToken();
                    String refTableName = tokens.nextToken();
                    String forKeyName = tokens.nextToken();
                    String joinType = tokens.nextToken();
                    if (this.selectedTables.contains(refTableName) || refTableName.equalsIgnoreCase(currInfo.getViaTableName())) {
                        TableInfoBean refInfo = (TableInfoBean)this.xe.joinInfo.get(refTableName);
                        ArrayList priKey = refInfo.getPrimaryKeys();
                        BaseLogger.log("3", null, null, "priKey :" + priKey);
                        int ctr1 = 0;
                        while (ctr1 < priKey.size()) {
                            String arrValue = (String)priKey.get(ctr1);
                            String pK = arrValue.substring(arrValue.lastIndexOf("#") + 1);
                            String rhsKeyID = refInfo.getID(arrValue);
                            BaseLogger.log("3", null, null, "rhsKeyID-lhsKeyID :" + rhsKeyID + ":" + lhsKeyID);
                            if (rhsKeyID.equalsIgnoreCase(lhsKeyID)) {
                                if (joinType.equalsIgnoreCase("I")) {
                                    joinWhere.append(String.valueOf(curTableName) + "." + forKeyName + " = " + refTableName + "." + pK + " AND ");
                                } else if (joinType.equalsIgnoreCase("RO")) {
                                    if (DBInfo.OUTER_JOIN != null) {
                                        joinWhere.append(String.valueOf(curTableName) + "." + forKeyName + " = " + refTableName + "." + pK + DBInfo.OUTER_JOIN + " AND ");
                                    }
                                } else if (joinType.equalsIgnoreCase("LO") && DBInfo.OUTER_JOIN != null) {
                                    joinWhere.append(String.valueOf(curTableName) + "." + forKeyName + DBInfo.OUTER_JOIN + " = " + refTableName + "." + pK + " AND ");
                                }
                            }
                            ++ctr1;
                        }
                        refInfo = null;
                    }
                    ++ctr;
                }
                currInfo = null;
            }
            if (joinWhere != null && joinWhere.length() > 0) {
                int index = joinWhere.toString().lastIndexOf(" AND ");
                if (index != -1) {
                    joinWhere.replace(index, index + 5, " ");
                }
                return "(" + joinWhere.toString().trim() + ")";
            }
            return null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BIRowSecurity :readJoinInfo :==>");
            throw e;
        }
    }

    private void addViaTables() throws Exception {
        try {
            int size = this.selectedTables.size();
            int ctr = 0;
            while (ctr < size) {
                String viaTableName;
                TableInfoBean tabInfoObj = (TableInfoBean)this.xe.joinInfo.get((String)this.selectedTables.get(ctr));
                if (tabInfoObj != null && (viaTableName = tabInfoObj.getViaTableName()) != null && !this.selectedTables.contains(viaTableName)) {
                    this.selectedTables.add(viaTableName);
                }
                Object var3_4 = null;
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : BIRowSecurity :addViaTables :==>");
            throw e;
        }
    }

    private String buildFrom(String fromPart) throws Exception {
        StringBuffer fromBuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(fromPart, ",");
        ArrayList<String> existingTables = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            existingTables.add(st.nextToken().trim());
        }
        int ctr = 0;
        while (ctr < this.selectedTables.size()) {
            if (!existingTables.contains(this.selectedTables.get(ctr))) {
                fromBuffer.append(this.selectedTables.get(ctr) + ",");
            }
            ++ctr;
        }
        ctr = 0;
        while (ctr < existingTables.size()) {
            if (!this.selectedTables.contains(existingTables.get(ctr))) {
                this.selectedTables.add(existingTables.get(ctr));
            }
            ++ctr;
        }
        if (fromBuffer != null && fromBuffer.length() > 0) {
            int index = fromBuffer.toString().lastIndexOf(44);
            if (index != -1) {
                fromBuffer.replace(index, index + 1, " ");
            }
            return " FROM " + fromPart + "," + fromBuffer.toString();
        }
        return " FROM " + fromPart;
    }

    private String buildWhere(String wherePart, String rowSecurityWhere, String joinPredicates) throws Exception {
        StringBuffer whereBuf = new StringBuffer();
        Object groupPart = null;
        int whereIndex = -1;
        int groupIndex = -1;
        int havingIndex = -1;
        boolean isExist = true;
        String tmpWherePart = wherePart.toUpperCase();
        whereIndex = tmpWherePart.indexOf(" WHERE ");
        groupIndex = tmpWherePart.indexOf(" GROUP BY ");
        havingIndex = tmpWherePart.indexOf(" HAVING ");
        if (whereIndex == -1) {
            isExist = false;
        }
        if (groupIndex != -1) {
            whereBuf.append(wherePart.substring(0, groupIndex));
        } else if (havingIndex != -1) {
            whereBuf.append(wherePart.substring(0, havingIndex));
        } else {
            whereBuf.append(wherePart.substring(0));
        }
        BaseLogger.log("3", null, null, "????????????????????????? isExist :[" + isExist + "]");
        BaseLogger.log("3", null, null, "[BEFORE ROW SECURITY WHERE] whereBuf :[" + whereBuf + "]");
        if (rowSecurityWhere != null && whereBuf.toString().indexOf(rowSecurityWhere) == -1) {
            if (!isExist) {
                whereBuf.append(" WHERE ");
            } else {
                whereBuf.append(" AND ");
            }
            whereBuf.append("(" + rowSecurityWhere + ")");
        }
        BaseLogger.log("3", null, null, "[BEFORE JOIN PREDICATES] whereBuf :[" + whereBuf + "]");
        if (joinPredicates != null) {
            if (!isExist) {
                whereBuf.append(" WHERE ");
            } else {
                whereBuf.append(" AND ");
            }
            whereBuf.append(joinPredicates);
        }
        if (groupIndex != -1) {
            whereBuf.append(wherePart.substring(groupIndex));
        } else if (havingIndex != -1) {
            whereBuf.append(wherePart.substring(havingIndex));
        }
        BaseLogger.log("2", null, null, "?????????????????????????whereBuf :" + whereBuf.toString());
        return whereBuf.toString();
    }
}

