/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean.wiz;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.RIAWizardStatefulEJB;
import ibase.webitm.ejb.RIAWizardStatefulRemote;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RIAWizardBean
implements Serializable {
    private UserInfoBean userInfo = null;
    RIAWizardStatefulRemote riaWizardRemote = null;
    private String objName = "";
    private String editorID = "";
    private String editFlag = "";
    private String user_lang = "en";
    private String user_country = "US";
    private HashMap beanXmlDataMap = null;
    private double classId = 0.0;
    private String hostName = "";
    private String hostIP = "";

    public RIAWizardBean() throws ITMException {
    }

    public RIAWizardBean(String objName, UserInfoBean userInfo) throws ITMException {
        this(objName, userInfo, "");
    }

    public RIAWizardBean(String objName, UserInfoBean userInfo, String formName) throws ITMException {
        try {
            BaseLogger.log("3", userInfo, null, "XXXXXXXXXXX RIAWizardBean XXXXXXXXXXX");
            this.objName = objName;
            this.userInfo = userInfo;
            this.hostName = this.userInfo.getHostName();
            this.hostIP = this.userInfo.getHostIP();
            if (this.riaWizardRemote == null) {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                this.riaWizardRemote = (RIAWizardStatefulRemote)ctx.lookup("ibase/RIAWizardStatefulEJB/remote");
                this.riaWizardRemote.setUserInfo(this.userInfo);
                String metadataName = String.valueOf(this.objName) + "21";
                if (formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName)) {
                    metadataName = String.valueOf(this.objName) + "2" + formName;
                }
                BaseLogger.log("3", this.userInfo, null, "RIAWizardBean >> metadataName =[" + metadataName + "]");
                this.riaWizardRemote.loadFormsMetaData(this.objName, "1", metadataName, this.userInfo.getEmpCode(), this.userInfo.getProfileId());
                this.beanXmlDataMap = new HashMap();
                this.classId = Math.random();
                new E12GenericUtility().writeFile("RIAWizardComp", " \n RIAWizardBean has been created : UserId [," + userInfo.getLoginCode() + ",] objName[," + this.objName + ",] Time [," + new Date() + ",] ClassId [" + this.classId + ",] hostName[," + this.hostName + ",] hostIP[," + this.hostIP + ",]");
            }
        }
        catch (ITMException itmException) {
            this.riaWizardRemote.remove();
            this.riaWizardRemote = null;
            throw itmException;
        }
        catch (Exception e) {
            this.riaWizardRemote.remove();
            this.riaWizardRemote = null;
            throw new ITMException(e);
        }
    }

    public String callEventManager(String eventCode, String objContext, String domId, ArrayList dataArrayList, String action, String formType, String forceSave) throws ITMException {
        String retHTMLStr = "";
        try {
            ArrayList xmlDataList = this.riaWizardRemote.callEventManager(this.userInfo.getLoginCode(), this.objName, eventCode, objContext, domId, dataArrayList, action, formType, forceSave);
            String xmlData = (String)xmlDataList.get(0);
            if (xmlData != null && xmlData.length() > 0) {
                String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
                if (xmlData.indexOf("<error") == -1) {
                    int objCtxInt = Integer.parseInt(objContext);
                    if (eventCode.startsWith("pre_navigate") && "next".equalsIgnoreCase(action)) {
                        objCtxInt = formType != null && formType.indexOf("MP") != -1 ? (objCtxInt += 2) : ++objCtxInt;
                    } else if (eventCode.startsWith("pre_navigate") && "previous".equalsIgnoreCase(action)) {
                        objCtxInt = formType != null && formType.indexOf("MP") != -1 ? Integer.parseInt(formType.substring(0, 1)) : --objCtxInt;
                    } else if (xmlData.indexOf("Detail1") != -1) {
                        objCtxInt = 1;
                    }
                    objContext = "" + objCtxInt;
                } else {
                    BaseLogger.log("3", this.userInfo, null, "Getting data from  Appending Error Node ");
                    if (dataArrayList != null && dataArrayList.size() > 0) {
                        xmlData = this.appendErrorNode((String)dataArrayList.get(0), xmlData);
                    }
                }
                retHTMLStr = xmlData;
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    public void remove() {
        try {
            if (this.riaWizardRemote != null) {
                new E12GenericUtility().writeFile("RIAWizardComp", " \n RIAWizardBean has been removed : UserId [," + this.userInfo.getLoginCode() + ",] objName[," + this.objName + ",] Time[," + new Date() + ",] ClassId[," + this.classId + ",] hostName[," + this.hostName + ",] hostIP[," + this.hostIP + ",]");
                this.riaWizardRemote.remove();
                this.riaWizardRemote = null;
            }
        }
        catch (Throwable e) {
            new E12GenericUtility().writeFile("RIAWizardCompException", " \n RIAWizardBean :: Exception has been coming while removing ejb component  :  [" + e.getMessage() + "] UserId [," + this.userInfo.getLoginCode() + ",] objName[," + this.objName + ",] Time[," + new Date() + ",] ClassId[," + this.classId + ",] hostName[," + this.hostName + ",] hostIP[," + this.hostIP + ",]");
            BaseLogger.log("0", this.userInfo, null, "RIAWizardBean :: Exception has been coming while removing ejb component");
            e.printStackTrace();
        }
    }

    public HashMap getBeanMap() throws ITMException {
        try {
            return this.beanXmlDataMap;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private String appendErrorNode(String prevXMLData, String currXmlData) throws ITMException {
        String retUpdXMLData = "";
        try {
            retUpdXMLData = prevXMLData.replace("<Errors></Errors>", currXmlData.substring(currXmlData.indexOf("<Errors>"), currXmlData.lastIndexOf("</Errors>") + 9));
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retUpdXMLData;
    }

    private String getXSLFileName(String xslFileName) throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = null;
            defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            File xslPath = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
            if (!xslPath.exists()) {
                xslPath.mkdir();
            }
            BaseLogger.log("3", this.userInfo, null, " xslPath [" + xslPath + "] xslFileName [" + xslFileName + "]");
            File xslFile = new File(xslPath, xslFileName);
            if (!xslFile.exists()) {
                throw new ITMException(new Exception(String.valueOf(retFileName) + " Wizard XSL file Not Found"));
            }
            retFileName = xslFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retFileName;
    }

    public ArrayList getMessageDetailList(String objName) throws ITMException {
        ArrayList<String> msgColdataList = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        String fieldValue = "";
        String descr = "";
        RIAWizardStatefulRemote riaWizardRemoteTemp = null;
        try {
            try {
                msgColdataList = new ArrayList<String>();
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                riaWizardRemoteTemp = (RIAWizardStatefulRemote)ctx.lookup("ibase/RIAWizardStatefulEJB/remote");
                String messageArgStr = riaWizardRemoteTemp.getSuccessMsgDetailList(objName);
                riaWizardRemoteTemp.remove();
                riaWizardRemoteTemp = null;
                if (messageArgStr != null && messageArgStr.length() > 0 && messageArgStr.indexOf("prefix") != -1) {
                    Document dom = genericUtility.parseString(messageArgStr);
                    NodeList prfixNodList = dom.getElementsByTagName("prefix").item(0).getChildNodes();
                    int pFxNodListLen = prfixNodList.getLength();
                    int pCtr = 0;
                    while (pCtr < pFxNodListLen) {
                        Node pfxChildNode = prfixNodList.item(pCtr);
                        if (pfxChildNode != null && pfxChildNode.getNodeType() == 1 && pfxChildNode.getNodeName().equalsIgnoreCase("fld_value")) {
                            if (pfxChildNode.getFirstChild() != null) {
                                fieldValue = String.valueOf(fieldValue) + pfxChildNode.getFirstChild().getNodeValue();
                                BaseLogger.log("3", this.userInfo, null, " getting fieldValue from srv[" + fieldValue + "]");
                            }
                        } else if (pfxChildNode != null && pfxChildNode.getNodeType() == 1 && pfxChildNode.getNodeName().equalsIgnoreCase("descr") && pfxChildNode.getFirstChild() != null) {
                            descr = String.valueOf(descr) + pfxChildNode.getFirstChild().getNodeValue();
                            BaseLogger.log("3", this.userInfo, null, " getting descr from srv[" + descr + "]");
                        }
                        ++pCtr;
                    }
                }
                if (fieldValue != null && fieldValue.length() > 0) {
                    if (fieldValue.indexOf(",") != -1) {
                        StringTokenizer strTokenz = new StringTokenizer(fieldValue, ",");
                        while (strTokenz.hasMoreElements()) {
                            String strToken = strTokenz.nextToken();
                            msgColdataList.add(strToken);
                        }
                    } else {
                        msgColdataList.add(fieldValue);
                    }
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            if (riaWizardRemoteTemp != null) {
                riaWizardRemoteTemp.remove();
                riaWizardRemoteTemp = null;
            }
        }
        return msgColdataList;
    }

    public String getFormXmlData(String formNo) throws ITMException {
        String xmlData = "";
        try {
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
            xmlData = this.riaWizardRemote.getFormData(formNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return xmlData;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setEditorID(String editorID) {
        this.editorID = editorID;
        if (this.riaWizardRemote != null) {
            this.riaWizardRemote.setEditorId(editorID);
        }
    }

    public String getEditorID() {
        return this.editorID;
    }

    public void setEditFlag(String editFlag) {
        this.editFlag = editFlag;
        if (this.riaWizardRemote != null) {
            this.riaWizardRemote.setEditFlag(editFlag);
        }
    }

    public String getEditFlag() {
        return this.editFlag;
    }

    public double getClassId() {
        return this.classId;
    }

    public void setClassId(double classId) {
        this.classId = classId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public void setAllDefaultDataAfterSync(String allFormXml, int noOfForms) {
        try {
            if (this.riaWizardRemote != null) {
                this.riaWizardRemote.setObjName(this.objName);
                this.riaWizardRemote.setEditorId(this.editorID);
                this.riaWizardRemote.setLoginCode(this.userInfo.getLoginCode());
                this.riaWizardRemote.setDefaultFormDataMap("" + noOfForms, allFormXml);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception inside setAllDefaultDataAfterSync ===> [" + e.toString() + "]");
            e.printStackTrace();
        }
    }

    public String getReportingTo(String usrId, String empCode, String tranDb, UserInfoBean userInfo, String geoPos) {
        String xmlData = "";
        try {
            RIAWizardStatefulEJB riaWizardRemote = new RIAWizardStatefulEJB();
            xmlData = riaWizardRemote.getReportingTo(usrId, empCode, tranDb, userInfo, geoPos);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", userInfo, null, "Exception inside getReportingTo ===> [" + e.toString() + "]");
        }
        return xmlData;
    }

    public void replaceRecordDetail(String formNo, String chgStr) {
        this.riaWizardRemote.replaceRecordDetail(formNo, chgStr);
    }

    public String getSelectedFormXML(String objCtx, String detailFormXML) throws ITMException {
        return this.riaWizardRemote.getSelectedFormXML(objCtx, detailFormXML);
    }

    public void addDetailDataInCache() {
        this.riaWizardRemote.addDetailDataInCache();
    }

    public void setItmDefaultFormDataMap(String formDataXmlStr) {
        this.riaWizardRemote.setItmDefaultFormDataMap(formDataXmlStr);
    }
}

