
package ibase.webitm.utility.wsfa;

/**
  * Class SavexException - <br>
  * The SavexException is thrown when there some data problems like 
  - No Towns in the territory of the MR
  - No Doctors in the territory of the MR
  *					
  * @author Avinash Deshmukh
  * @version 1.0
  * @since Feb 22, 2002
  * History of change
  */

public class SavexException extends RuntimeException{

    /**
     * Constructs an SavexException with no detail message.
     */
    public SavexException() {
		super("There is no proper data in the database");
    }

    /**
     * Constructs an SavexException with the specified detail message.
     * @param message the detail message.
     * 
     */
    public SavexException(String message) {
	  super(message);
    }

}