/*
Button name : Change Status
Auther		: Gulzar
Created On  : 08/05/08
*/

package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.system.config.ConnDriver;
import java.rmi.RemoteException;
import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.DOMException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.ejb.Stateless;
import javax.ejb.CreateException;
import java.util.*;

//Modified by Ramchandra on [03/10/2012][To get errorString method][Start]
import javax.naming.InitialContext;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
//Modified by Ramchandra on [03/10/2012][To get errorString method][End]

@Stateless
public class SprsStockistCopyPrc extends ProcessEJB implements SprsStockistCopyPrcLocal,SprsStockistCopyPrcRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility(); 
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document headerDom = null;
		Document detailDom = null;
		System.out.println("windowName:::::::::::::"+ windowName);
		String  rtrStr ="";
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :SprsStockistCopyPrc :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = e.getMessage();
		}
		return rtrStr; 
	}//END OF GETDATA(1)
	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String salesPersonFr = "";
		String salesPersonTo = "";
		String resultString = "";
		String selectSql = "";
		String errString = "";

		int cnt = 0;

		ResultSet rs = null, rs1 = null;
		Statement stmt = null, stmt1 = null;
		PreparedStatement pstmt = null;
		Connection conn = null;

		try
		{
//			ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
//			conn = connDriver.getConnectDB("DriverITM"); //Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
		}
		catch (Exception e)
		{
			System.out.println("Exception :SprsStockistCopyPrc :getData :Connection Creation Error :==>"+e);
		} 
		try
		{
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
			//StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			salesPersonFr = genericUtility.getColumnValue("sales_pers__from",headerDom);
			salesPersonTo = genericUtility.getColumnValue("sales_pers__to",headerDom);
			
			selectSql = "SELECT SPRS_STOCKIST.SPRS_CODE, SPRS_STOCKIST.CUST_CODE, CUSTOMER.SH_NAME, SPRS_STOCKIST.ROUTE_ID, " +
						"SPRS_STOCKIST.STATUS, LOCALITY.LOCALITY_CODE, LOCALITY.DESCR, SPRS_STOCKIST.SHORT_ID " +
						"FROM SPRS_STOCKIST, CUSTOMER, LOCALITY " +
						"WHERE ( SPRS_STOCKIST.CUST_CODE = CUSTOMER.CUST_CODE ) " +
						"AND ( CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE ) " +
						"AND ( SPRS_STOCKIST.CUST_CODE NOT IN ( SELECT CUST_CODE FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPersonTo+"' )) " +
						"AND ( SPRS_STOCKIST.SPRS_CODE = '"+salesPersonFr+"' ) " +
						"AND SPRS_STOCKIST.STATUS = 'Y' " +
						"ORDER BY LOCALITY.LOCALITY_CODE ASC ";

			System.out.println("selectSql :: "+selectSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selectSql);
			int domID = 2;
			while (rs.next())
			{
				valueXmlString.append("<Detail2 domID='"+domID+"' >\r\n");
				valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
				valueXmlString.append("<is_selected><![CDATA[").append("").append("]]></is_selected>\r\n");
				valueXmlString.append("<sprs_code><![CDATA[").append(checkNull(rs.getString("SPRS_CODE"))).append("]]></sprs_code>\r\n");
				valueXmlString.append("<cust_code><![CDATA[").append(checkNull(rs.getString("CUST_CODE"))).append("]]></cust_code>\r\n");
				valueXmlString.append("<sh_name><![CDATA[").append(checkNull(rs.getString("SH_NAME"))).append("]]></sh_name>\r\n");
				valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("STATUS"))).append("]]></status>\r\n");
				valueXmlString.append("<route_id><![CDATA[").append(checkNull(rs.getString("ROUTE_ID"))).append("]]></route_id>\r\n");
				valueXmlString.append("<locality_code><![CDATA[").append(checkNull(rs.getString("LOCALITY_CODE"))).append("]]></locality_code>\r\n");
				valueXmlString.append("<locality_descr><![CDATA[").append(checkNull(rs.getString("DESCR"))).append("]]></locality_descr>\r\n");
				valueXmlString.append("<short_id><![CDATA[").append(checkNull(rs.getString("SHORT_ID"))).append("]]></short_id>\r\n");
				valueXmlString.append("</Detail2>\r\n");	
				domID++;
			}
			rs.close();rs = null;
			stmt.close();stmt = null;
			valueXmlString.append("</Header0>\r\n");
			valueXmlString.append("</group0>\r\n");	
			valueXmlString.append("</DocumentRoot>\r\n");
			System.out.println("valueXmlString:::::::::::::"+valueXmlString);
			resultString = valueXmlString.toString();
		}
		catch (SQLException se)
		{
			System.out.println("SQLException :SprsStockistCopyPrc :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + se.getMessage() + ":");
			throw new ITMException(se);
		}
		catch (Exception e)
		{
			System.out.println("Exception :SprsStockistCopyPrc :getData(Document headerDom, Document detailDom, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection..............");
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(conn != null)
				{					
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return resultString;	
	}//END OF GETDATA
	//PROCESS
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
			String retStr = "";
			Document detailDom = null;
			Document headerDom = null;
			try
			{	
				if(xmlString != null && xmlString.trim().length()!=0)
				{
					headerDom = genericUtility.parseString(xmlString); 
					System.out.println("headerDom" + headerDom);
				}
				if(xmlString2 != null && xmlString2.trim().length()!=0)
				{
					detailDom = genericUtility.parseString(xmlString2); 
					System.out.println("detailDom" + detailDom);
				}
										
			    retStr = process(headerDom, detailDom, windowName, xtraParams);
			}
			catch (Exception e)
			{
				System.out.println("Exception :SprsStockistCopyPrc :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
				e.printStackTrace();
				retStr = e.getMessage();
			}
			return retStr;
		
	}//END OF PROCESS (1)
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String addChangePrs = "";
		String salesPersonFr = "";
		String salesPersonTo = "";
		String sprsCode = "";
		String custCode = "";
		String shName = "";
		String routeID = "";

		String status = "";
		String localityCode = "";
		String localityDescr = "";
		String updateSql = "";
		String selectSql = "";
		String insertSql = "";
		String errorCode = "";
		String userId = "";
		String chgTerm = "";
		String isSelected = "";
		String routeIDFr = "";//Gulzar - 23/03/09

		int shortID = 0;
		int insCnt = 0;
		int updCnt = 0;
		int count = 0;
		int noOfRecSelect = 0;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		int parentNodeListLength =0;
		int childNodeListLength = 0;
		String childNodeName = "";
		Node parentNode = null;
		Node childNode = null;

		Connection conn = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rsTemp = null;
		Statement stmt = null;
		Statement stmt1 = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtIns = null;
		String errString = "";

		try
		{
			//Commented by vinayak on [11/07/2016] [strat]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			//Commented by vinayak on [11/07/2016][end]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);

			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength(); 

			//Modified by Ramchandra on [03/10/2012][To get errorString method][Start]
			//commented by saiprasad G. 
			/*InitialContext ctx = getInitialContext();
			ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );*/
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			//Modified by Ramchandra on [03/10/2012][To get errorString method][End]
			
			//Added By Gulzar - 21/08/08 Req ID : SY89SUN001
			System.out.println("Total No Of Record Selected for Process [parentNodeListLength]:: "+parentNodeListLength);
			if ( parentNodeListLength == 0 )
			{
				errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>No Data Found For Process</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
				return errString;
			}
			//End Changes - Gulzar - 21/08/08 Req ID : SY89SUN001
			
			addChangePrs	= genericUtility.getColumnValue("copy_opt",headerDom);
			salesPersonFr	= genericUtility.getColumnValue("sales_pers__from",headerDom);
			salesPersonTo	= genericUtility.getColumnValue("sales_pers__to",headerDom);

			System.out.println("Copy Option is [copy_opt]:: "+addChangePrs); //Gulzar - 18/09/08

			userId	= genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");

			selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPersonTo+"'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selectSql);
			if ( rs.next() )
			{
				count = rs.getInt("COUNT");
			}
			rs.close();
			rs = null;
			if ( count > 0 )
			{
				selectSql = "SELECT CASE WHEN MAX(SHORT_ID) IS NULL THEN 0 ELSE MAX(SHORT_ID) END "+
							"FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPersonTo+"' ";
				System.out.println("selectSql:: "+selectSql);
				rs = stmt.executeQuery(selectSql);
				if ( rs.next() )
				{
					shortID = rs.getInt(1);
				}
				//shortID = shortID + 1; //Gulzar - 18/09/08
				rs.close();
				rs = null;
			}
			else
			{
				shortID = 1;
			}
			stmt.close();
			stmt = null;

			// Modified by Ramchandran [20/07/2012] [To get non coverage route type].Start
			String [] propValueArr = null;
			String propValues = "";
			Vector vector = new Vector();
			Boolean isNonCoverageRTypeDefined = false;
			propValues = getAllowedRouteType( salesPersonTo, conn );
			if (propValues.trim().length() > 0)
			{
				if(propValues.indexOf(',')>0)
				{
					propValueArr = propValues.split(",");
				}
				else 
				{
					propValueArr = new String[1];
					propValueArr[0] = propValues;
				}
				for(int k=0 ; k<propValueArr.length ; k++)
				{
					vector.add(propValueArr[k]);
				}
				System.out.println("vector::"+vector);
				isNonCoverageRTypeDefined = true;
			}
			// Modified by Ramchandran [20/07/2012] [To get non coverage route type].End


			insertSql = "INSERT INTO SPRS_STOCKIST ( SPRS_CODE, CUST_CODE, REPLY_STATUS, ROUTE_ID, CHG_DATE, CHG_USER, CHG_TERM, STATUS, SHORT_ID ) " +
						"VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? ) ";
			pstmtIns = conn.prepareStatement(insertSql);

			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				parentNode = parentNodeList.item(selectedRow);
				System.out.println("parentNode:::::::::::::: "+ parentNode);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::: "+ childNodeListLength);

				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName(); 
					System.out.println("childNodeName::::::::"+childNodeName);
					if (childNodeName.equals("sprs_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							sprsCode = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("sprsCode ::"+sprsCode);
					}
					if (childNodeName.equals("cust_code"))
					{
						if (childNode.getFirstChild()!=null)
						{
							custCode = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("custCode ::"+custCode);
					}
					if (childNodeName.equals("is_selected")) 
					{
						if (childNode.getFirstChild()!=null)
						{
							if (childNode.getFirstChild().getNodeValue()!=null)
							{
								isSelected = childNode.getFirstChild().getNodeValue();
							}
						}
						System.out.println("isSelected ::"+isSelected);
					}
					if (childNodeName.equals("route_id"))
					{
						if (childNode.getFirstChild()!=null)
						{
							if (childNode.getFirstChild().getNodeValue()!=null)
							{
								routeIDFr = childNode.getFirstChild().getNodeValue();
							}
						}
						System.out.println("routeID ::"+routeIDFr);
					}
					/*
					if (childNodeName.equals("status"))
					{
						if (childNode.getFirstChild()!=null)
						{
							status = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("status ::"+status);
					}
					if (childNodeName.equals("locality_code"))
					{
						if (childNode.getFirstChild()!=null)
						{
							localityCode = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("localityCode ::"+localityCode);
					}
					if (childNodeName.equals("locality_descr"))
					{
						if (childNode.getFirstChild()!=null)
						{
							localityDescr = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("localityDescr ::"+localityDescr);
					}
					if (childNodeName.equals("short_id"))
					{
						if (childNode.getFirstChild()!=null)
						{
							shortID = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("shortID ::"+shortID);
					}
					*/
				}//End Of for (int childRow = 0; childRow < childNodeListLength; childRow++)
				//commented by saiprasad G.
				//if ( isSelected != null && isSelected.trim().equalsIgnoreCase("true") )
				if ( isSelected != null && isSelected.trim().equalsIgnoreCase("Y") )
				{
					noOfRecSelect++;
					selectSql = "SELECT LOCALITY_CODE FROM CUSTOMER WHERE CUST_CODE = '"+custCode+"'";
					stmt = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
					rs = stmt.executeQuery(selectSql);
					System.out.println("SQL  FOR LOCALITY::"+selectSql);
					rs.last();
					int rowCount = rs.getRow();
					if ( rowCount > 1 )
					{
						errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>More Than One Locality Found for Customer ["+custCode+"]</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
						break;
					}
					rs.beforeFirst();
					System.out.println("Locality Count ::"+rowCount);
					if ( rs.next() )
					{
						localityCode = rs.getString("LOCALITY_CODE");						
						//Added - Gulzar - 23/03/09
						
						//Modified by Ramchandra on [14/07/2012] [To change message for selected stockists are deactivated in place of Work and check validation for route type also][Start]
						
						//selectSql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+localityCode+"' AND SPRS_CODE = '"+salesPersonTo+"' ";
						selectSql = "SELECT ROUTE_ID, STATUS , ROUTE_TYPE FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+localityCode+"' AND SPRS_CODE = '"+salesPersonTo+"' ";	
						String routeStatus = "";
						//Modified by Ramchandra on [14/07/2012] [To change message for selected stockists are deactivated in place of Work and check validation for route type also] [End]

						stmt1 = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE); //Added statement by jaimin on 04/06/2008 (SY89SUN001)
						rs1 = stmt1.executeQuery(selectSql);
						System.out.println("SQL for Route and Status::"+selectSql);
						rs1.last();
						rowCount = rs1.getRow();
						if ( rowCount > 1 )
						{
							errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>More Than One Route ID Found for the Locality ["+localityCode+"] and Sales Person  ["+salesPersonTo+"]</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
							break;
						}
						rs1.beforeFirst();
						if ( rs1.next() )
						{
							routeID = rs1.getString("ROUTE_ID");
							//Modified by Ramchandra on [06/07/2012] [To change message for selected stockists are deactivated in place of Work] [Start]
							routeStatus =  rs1.getString("STATUS");
							if(routeStatus.equalsIgnoreCase("N"))
							{
								
								//Modified by Ramchandra on [03/10/2012] [To change message type for Inactive Status]
								//errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>Locality ["+localityCode+"] of selected Stockist is deactivated in Place of work List, First activate the same</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
								System.out.println("[SprsStockistCopyPrc][process()][Inactive Status]");
								errString = itmDBAccessLocal.getErrorString( "", "VDINACTSTA", userId );
								break;
							}
							else if (isNonCoverageRTypeDefined)
							{
								String routeType = rs1.getString("ROUTE_TYPE");
								if(vector.contains(routeType))
								{
									//Modified by Ramchandra on [03/10/2012] [To change message type for Noncoverage routetype]
									//errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>Locality ["+localityCode+"] is not under coverage area, you can not add stockist from this place</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
									System.out.println("[SprsStockistCopyPrc][process()][Noncoverage routetype]");
									errString = itmDBAccessLocal.getErrorString( "", "VNONCVRGRT", userId );
									break;
								}
							}
							//Modified by Ramchandra on [06/07/2012] [To change message for selected stockists are deactivated in place of Work] [End]
						}
						else
						{
							
							//Modified by Ramchandra on [06/07/2012] [To change message for selected stockists are not available in place of Work]
							
							//errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>No Route ID Found for the Locality ["+localityCode+"] and Sales Person  ["+salesPersonTo+"]</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";	
							
							//Modifie by Ramchandra on [03/10/2012][To change message type for Locality_Code]
							//errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>Locality ["+localityCode+"] is not available in place of work, First update the same</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
							System.out.println("[SprsStockistCopyPrc][process()][LocalityCode does not exist ]");
							errString = itmDBAccessLocal.getErrorString( "", "VDLOCCODE", userId );
							break;
						}
						rs1.close();rs1 = null;
						stmt1.close();stmt1 = null;
						//end Added - Gulzar - 23/03/09

						if ( addChangePrs != null && addChangePrs.trim().length() > 0 && addChangePrs.trim().equals("CSP_STOCKIST") )
						{
							updateSql = "UPDATE SPRS_STOCKIST SET STATUS = 'N', CHG_USER = '"+userId+"' , CHG_DATE = ?, CHG_TERM = '"+chgTerm+"' " +
										"WHERE CUST_CODE = '"+custCode+"' AND SPRS_CODE = '"+salesPersonFr+"'";

							pstmt = conn.prepareStatement(updateSql);
							pstmt.setTimestamp(1, new java.sql.Timestamp(System.currentTimeMillis()));
							updCnt = pstmt.executeUpdate();
							if ( updCnt > 0 )
							{
								System.out.println("Updated into SPRS_STOCKIST Successfully [updCnt] ::"+updCnt);
								//conn.commit();
							}
							pstmt.close();
							pstmt = null;
							
							//Added - Gulzar - 23/03/09 Req ID : 
							selectSql = "SELECT COUNT(1) AS COUNT FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+ salesPersonFr +"'  " +
										"AND ROUTE_ID = '"+routeIDFr+"' AND STATUS = 'Y' ";
							System.out.println("Select Sql  :: "+selectSql);
							stmt1 = conn.createStatement();
							rs1 = stmt1.executeQuery(selectSql);
							if ( rs1.next() )
							{
								count = rs1.getInt("COUNT");
							}
							rs1.close();rs1 = null;
							if ( count == 0 )
							{
								selectSql = "SELECT COUNT(1) AS COUNT FROM STRG_SERIES WHERE SALES_PERS = '"+ salesPersonFr +"'  " +
											"AND ROUTE_ID = '"+routeIDFr+"' AND STATUS = 'Y' ";
								System.out.println("Select Sql  :: "+selectSql);
								rs1 = stmt1.executeQuery(selectSql);
								if ( rs1.next() )
								{
									count = rs1.getInt("COUNT");
								}
								rs1.close();rs1 = null;
								if ( count == 0 )
								{
									updateSql = "UPDATE SPRS_ROUTE SET STATUS = 'N' " +
												"WHERE SPRS_CODE = '"+salesPersonFr+"' AND LOCALITY_CODE = '"+localityCode+"'";
									pstmt = conn.prepareStatement(updateSql);
									updCnt = pstmt.executeUpdate();
									if ( updCnt > 0 )
									{
										System.out.println("Updated into SPRS_ROUTE Successfully [updCnt] ::"+updCnt);
									}
									pstmt.close();
									pstmt = null;
								}
							}
							stmt1.close();stmt1 = null;

							//End changes Gulzar - 23/03/09
						}
						/* ---- Commented  and moved above by Gulzar - 23/03/09
						selectSql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+localityCode+"' AND SPRS_CODE = '"+salesPersonTo+"' ";
						stmt1 = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE); //Added statement by jaimin on 04/06/2008 (SY89SUN001)
						rs1 = stmt1.executeQuery(selectSql);
						rs1.last();
						rowCount = rs1.getRow();
						if ( rowCount > 1 )
						{
							errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"P\" column_name=\"\"><message>Process Not Done</message><description>More Than One Route ID Found for the Locality ["+localityCode+"] and Sales Person  ["+salesPersonTo+"]</description><type>P</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
							break;
						}
						rs1.beforeFirst();
						if ( rs1.next() )
						{
							routeID = rs1.getString("ROUTE_ID");
						}
						else
						{
							errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"P\" column_name=\"\"><message>Process Not Done</message><description>No Route ID Found for the Locality ["+localityCode+"] and Sales Person  ["+salesPersonTo+"]</description><type>P</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
							break;
						}
						rs1.close();rs1 = null;
						stmt1.close();stmt1 = null;
						*/
						//End - Comment  - Gulzar - 23/03/09
					}
					else
					{
						errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>No Data Found for the Customer Code ["+custCode+"]</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
						break;
					}
					rs.close();
					rs = null;
					stmt.close();
					stmt = null;
					shortID = shortID + 1; // Gulzar - 18/09/08
					pstmtIns.setString(1, salesPersonTo);
					pstmtIns.setString(2, custCode);
					pstmtIns.setString(3, "0");
					pstmtIns.setString(4, routeID);
					pstmtIns.setTimestamp(5, new java.sql.Timestamp(System.currentTimeMillis()));
					pstmtIns.setString(6, userId);
					pstmtIns.setString(7, chgTerm);
					pstmtIns.setString(8, "Y");
					pstmtIns.setInt(9, shortID);
					insCnt = pstmtIns.executeUpdate();
					pstmtIns.clearParameters();
					if ( insCnt > 0 )
					{
						System.out.println("Inserted into SPRS_STOCKIST Successfully [insCnt] ::"+insCnt);
						//conn.commit();
					}
				}//if ( isSelected != null && isSelected.trim().equals("Y") )

			}//End Of for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			//Added by Gulzar - 22/08/08 Req ID : 
			System.out.println("noOfRecSelect for Process ::"+noOfRecSelect);
			if ( noOfRecSelect == 0 )
			{
				errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>No Data Found For Process</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
			}
			else if ( errString == null || errString.trim().length() == 0 )
			{
				//Added by Ganesh [29/06/2013] [To change message for process][Start]
				//errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"E\" column_name=\"\"><message>Process Done</message><description>Process Completed Successfully </description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
				errString = itmDBAccessLocal.getErrorString( "status", "VPROCESS", userId );
				//Added by Ganesh [29/06/2013] [To change message for process][End]
			}
			//End Changes by Gulzar - 22/08/08 Req ID : 
		}//try end	
		catch(SQLException se)
		{
			System.out.println("Exception : SprsStockistCopyPrc : process():" +se.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception :SprsStockistCopyPrc :process():"+e.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("Closing Connection....");
			try
			{
				if(stmt != null)
				{ 
					stmt.close();
					stmt = null;
				}
				if(stmt1 != null)
				{ 
					stmt1.close();
					stmt1 = null;
				}
				if(pstmt != null)
				{ 
					pstmt.close();
					pstmt = null;
				}
				if(pstmtIns != null)
				{ 
					pstmtIns.close();
					pstmtIns = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
			}
		}
		System.out.println("errString...:: "+errString);
		/*--- Commented as the same changes made above - Gulzar - 22/08/08 Req ID : 
		if ( errString != null && errString.trim().length() > 0 )
		{
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
		}
		else
		{
			try
			{
				conn.commit();
				errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"P\" column_name=\"\"><message>Process Done</message><description>Process Done Successfully </description><type>P</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";	//Added by jaimin on 04/06/2008 (SY89SUN001)
			}
			catch(Exception e1){}
		}*/
		//End Changes  - Gulzar - 22/08/08 Req ID : 

		return errString;
	}//END OF PROCESS(2)
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	//Modified by Ramchandra on [17/07/2012] [To check validation for Route Type] [Start]
	private String getAllowedRouteType( String loginEmpCode, Connection conn ) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String propValue = "";
		String propSql = "";
		Statement stmt1 = null;
		ResultSet rs1 = null;
		String propSql1 = "";
		Boolean isPropFound = false;
		try
		{		
			propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER = (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+loginEmpCode+"') "  ;
			stmt = conn.createStatement();
			rs = stmt.executeQuery(propSql);	
			System.out.println("QUERY::"+propSql);
			if(rs.next())
			{
				propValue = rs.getString("PROP_VALUE");	
				isPropFound = true;
			}
			System.out.println("propValue:::"+propValue);
			if(isPropFound == false)
			{
				propSql1 = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER ='ALL' "  ;
				stmt1 = conn.createStatement();
				rs1 = stmt1.executeQuery(propSql1);	
				System.out.println("QUERY@IF::"+propSql1);
				if(rs1.next())
				{
					propValue = rs1.getString("PROP_VALUE");	
				}
				System.out.println("propValue@IF:::"+propValue);
			}
			
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
			if (rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if ( stmt1 != null )
			{
				stmt1.close();
				stmt1 = null;
			}
			if (propValue == null)
			{
				propValue = "";
			}

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if ( stmt1 != null )
				{
					stmt1.close();
					stmt1 = null;
				}
			}
			catch(Exception e1){}
		}
		return propValue;
	}
	//Modified by Ramchandra on [17/07/2012] [To check validation for Route Type] [End]


	//Modified by Ramchandra on [03/10/2012] [To get errorString method] [Start]
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[SprsStockistCopyPrc][getInitialContext() :==>]");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[SprsStockistCopyPrc][getInitialContext()  :==>]");
			throw new ITMException(e);
		}
		return ctx;
	}
	//Modified by Ramchandra on [03/10/2012] [To get errorString method]  [End]

}//END OF EJB
