/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration;

import ibase.bankIntegration.PaymentCancellation;
import ibase.bankIntegration.UpdatePaymentStatus;
import ibase.bankIntegration.UpdateUTR;
import ibase.bankIntegration.unsHsbc.SFTPFileDownloader;
import ibase.bankIntegration.unsHsbc.SFTPFileUploader;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonMethods {
    static boolean isUTRPresent = false;
    private static String UTRFileName = null;

    public static Document readXML(String filePath) throws ITMException {
        try {
            System.out.println("Inside CommonMethods readXML");
            File xmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            return dBuilder.parse(xmlFile);
        }
        catch (Exception e) {
            String result = E12GenericUtility.getStackTrace((Exception)e);
            BaseLogger.log((String)"3", null, null, (Object)("Exception in uploadSingleFile. [" + result + "]"));
            throw new ITMException(e);
        }
    }

    public static void modifyElementValue(Element root, String parentElementName, String elementName, String newValue) throws ITMException {
        System.out.println("Inside CommonMethods modifyElementValue");
        try {
            NodeList parentList = root.getElementsByTagName(parentElementName);
            if (parentList.getLength() > 0) {
                Element parentElement = (Element)parentList.item(0);
                NodeList nodeList = parentElement.getElementsByTagName(elementName);
                if (nodeList.getLength() > 0) {
                    Node elementNode = nodeList.item(0);
                    elementNode.setTextContent(newValue);
                } else {
                    System.out.println("Element not found: " + elementName);
                }
            } else {
                System.out.println("Parent element not found: " + parentElementName);
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            throw new ITMException(e);
        }
    }

    public static void saveChanges(Document doc, String filePath) throws Exception {
        System.out.println("Inside CommonMethods saveChanges filePath: [" + filePath + "]");
        System.out.println("Inside CommonMethods saveChanges doc: [" + doc.toString() + "]");
        File file = new File(filePath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    public static String generateRandomString(int length) {
        String characters = "0123456789";
        StringBuilder randomString = new StringBuilder();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            int index = random.nextInt(characters.length());
            randomString.append(characters.charAt(index));
            ++i;
        }
        return randomString.toString();
    }

    public static JsonObject parseJsonString(String jsonString) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));
        return jsonReader.readObject();
    }

    public static String getValueFromJson(JsonObject jsonObject, String key) {
        if (jsonObject.containsKey((Object)key)) {
            return jsonObject.getString(key);
        }
        return null;
    }

    public static String getPayIntArgsFromBankMaster(String tranID, UserInfoBean userInfo) throws SQLException, ITMException {
        String payIntArgs = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getPayIntArgsSQL = "SELECT B.PAY_INT_ARGS\nFROM BANK B\nINNER JOIN MISC_PAYMENT M ON B.BANK_CODE = M.BANK_CODE\nWHERE M.TRAN_ID = ?";
                pstmt = connection.prepareStatement(getPayIntArgsSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    payIntArgs = rs.getString("PAY_INT_ARGS");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class PAY_INT_ARGS [" + payIntArgs + "]"));
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return payIntArgs;
    }

    public static String getEventNotifyEmailFromBankMaster(String tranID, UserInfoBean userInfo) throws SQLException {
        String eventNotifyEmail = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getEventNotifyEmailSQL = "SELECT B.EVENT_NOTIFY_EMAIL\nFROM BANK B\nINNER JOIN MISC_PAYMENT M ON B.BANK_CODE = M.BANK_CODE\nWHERE M.TRAN_ID = ?";
                pstmt = connection.prepareStatement(getEventNotifyEmailSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    eventNotifyEmail = rs.getString("EVENT_NOTIFY_EMAIL");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class eventNotifyEmail [" + eventNotifyEmail + "]"));
                }
            }
            catch (Exception exp) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception in uploadSingleFile. [" + E12GenericUtility.getStackTrace((Exception)exp) + "]"));
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return eventNotifyEmail;
    }

    public static String getBillNo(String tranID, UserInfoBean userInfo) throws ITMException {
        StringBuffer bufferbillnumber;
        block27: {
            BaseLogger.log((String)"2", null, null, (Object)"getBillNo calling rsk------------------");
            Connection connection = null;
            Statement pstmt = null;
            ResultSet rs = null;
            String billno = "";
            bufferbillnumber = new StringBuffer();
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    String voucherTableNameOfNum = "";
                    DBAccessEJB dbAccessEJB = new DBAccessEJB();
                    connection = connDriver.getConnectDB(userInfo.getTransDB());
                    String tranSerNumber = "";
                    tranSerNumber = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                    BaseLogger.log((String)"3", null, null, (Object)("Value of refserfor billnumber... [" + tranSerNumber + "]"));
                    if (tranSerNumber.equalsIgnoreCase("M-VOUC")) {
                        voucherTableNameOfNum = "MISC_VOUCHER";
                    } else if (tranSerNumber.equalsIgnoreCase("VOUCH")) {
                        voucherTableNameOfNum = "VOUCHER";
                    }
                    String result = "SELECT BILL_NO FROM " + voucherTableNameOfNum + " WHERE TRAN_ID in (select VOUCH_NO from MISC_PAYDET where tran_id = ?)";
                    BaseLogger.log((String)"3", null, null, (Object)"getBillNo calling inside Confirm tan_id-----------");
                    pstmt = connection.prepareStatement(result);
                    pstmt.setString(1, tranID);
                    rs = pstmt.executeQuery();
                    StringBuilder resultLine = new StringBuilder();
                    while (rs.next()) {
                        billno = rs.getString("BILL_NO");
                        resultLine.append(billno).append(",");
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(tranID);
                        buffer.append(bufferbillnumber);
                    }
                    if (resultLine.length() > 0) {
                        resultLine.deleteCharAt(resultLine.length() - 1);
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("****BILL_NO = " + resultLine.toString()));
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    bufferbillnumber.append(billno);
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillNo. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                        break block27;
                    }
                    catch (Exception e2) {
                        BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillNo. [" + E12GenericUtility.getStackTrace((Exception)e2) + "]"));
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillNo. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillNo. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            }
        }
        return bufferbillnumber.toString();
    }

    public static String getBillDate(String tranID, UserInfoBean userInfo) throws ITMException {
        StringBuffer bufferbilldate;
        block27: {
            BaseLogger.log((String)"2", null, null, (Object)"getBillDate calling rsk--------------------");
            Connection connection = null;
            Statement pstmt = null;
            ResultSet rs = null;
            String billdate = "";
            bufferbilldate = new StringBuffer();
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    String voucherTableNameOfDate = "";
                    DBAccessEJB dbAccessEJB = new DBAccessEJB();
                    connection = connDriver.getConnectDB(userInfo.getTransDB());
                    String tranSer = "";
                    tranSer = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                    BaseLogger.log((String)"3", null, null, (Object)("Value of tranSer... [" + tranSer + "]"));
                    if (tranSer.equalsIgnoreCase("M-VOUC")) {
                        voucherTableNameOfDate = "MISC_VOUCHER";
                    } else if (tranSer.equalsIgnoreCase("VOUCH")) {
                        voucherTableNameOfDate = "VOUCHER";
                    }
                    String result = "SELECT BILL_DATE FROM " + voucherTableNameOfDate + " WHERE TRAN_ID in (select VOUCH_NO from MISC_PAYDET where tran_id = ?)";
                    BaseLogger.log((String)"3", null, null, (Object)"getBillDate calling inside Confirm tan_id-----------");
                    pstmt = connection.prepareStatement(result);
                    pstmt.setString(1, tranID);
                    rs = pstmt.executeQuery();
                    StringBuilder resultLineOfDate = new StringBuilder();
                    while (rs.next()) {
                        billdate = rs.getString("BILL_DATE");
                        billdate = CommonMethods.extractDate(billdate);
                        resultLineOfDate.append(billdate).append(",");
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(tranID);
                        buffer.append(bufferbilldate);
                    }
                    if (resultLineOfDate.length() > 0) {
                        resultLineOfDate.deleteCharAt(resultLineOfDate.length() - 1);
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("****BILL_Date = " + resultLineOfDate.toString()));
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    bufferbilldate.append(billdate);
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillDate. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                        break block27;
                    }
                    catch (Exception e2) {
                        BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillDate. [" + E12GenericUtility.getStackTrace((Exception)e2) + "]"));
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillDate. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillDate. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            }
        }
        return bufferbilldate.toString();
    }

    public static HashMap<String, String> getBillNoAndBillDate(String tranID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)"getBillNoAndBillDate calling rsk------------------");
        HashMap<String, String> billNoAndBillDate = new HashMap<String, String>();
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String billNo = "";
        String billDate = "";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                String tranSer = "";
                String refNo = "";
                tranSer = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "TRAN_SER", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refserfor billnumber... [" + tranSer + "]"));
                refNo = dbAccessEJB.getDBColumnValue("MISC_PAYDET", "VOUCH_NO", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refNo billnumber... [" + refNo + "]"));
                String sql = "SELECT MISC_PAYABLES.BILL_NO, MISC_PAYABLES.BILL_DATE FROM MISC_PAYABLES WHERE REF_NO = ? AND TRAN_SER = ?";
                BaseLogger.log((String)"3", null, null, (Object)"");
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, refNo);
                pstmt.setString(2, tranSer);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    billNo = E12GenericUtility.checkNull((String)rs.getString("BILL_NO"));
                    billDate = E12GenericUtility.checkNull((String)rs.getString("BILL_DATE"));
                    billDate = CommonMethods.extractDate(billDate);
                    billNoAndBillDate.put("BILL_NO", billNo);
                    billNoAndBillDate.put("BILL_DATE", billDate);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillNoAndBillDate. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillNoAndBillDate. [" + E12GenericUtility.getStackTrace((Exception)e2) + "]"));
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception in getBillNoAndBillDate. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            }
        }
        return billNoAndBillDate;
    }

    public static String getCurrentDate() {
        BaseLogger.log((String)"3", null, null, (Object)"inside getCurrentDate .. ");
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yy HH:mm:ss");
        BaseLogger.log((String)"3", null, null, (Object)("currentDateTime is .. [" + currentDateTime.format(formatter) + "]"));
        return currentDateTime.format(formatter);
    }

    public static String generateBankXMLName(String tranId) {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyHHmmss");
        String formattedDate = dateFormat.format(currentDate);
        String formattedTranId = String.valueOf(tranId) + formattedDate;
        BaseLogger.log((String)"3", null, null, (Object)(" value of formattedTranId [" + formattedTranId + "]"));
        return formattedTranId;
    }

    public static String extractDate(String dateTimeString) {
        if (dateTimeString.equalsIgnoreCase("")) {
            return "";
        }
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeString, inputFormatter);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String datePart = dateTime.format(outputFormatter);
        return datePart;
    }

    public static String UTRFileDateToSQLDate(String inputDate) {
        SimpleDateFormat inputFormat = new SimpleDateFormat("dd-MMM-yyyy");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = inputFormat.parse(inputDate);
            return outputFormat.format(date);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in UTRFileDateToSQLDate. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            return null;
        }
    }

    public static String dateFormatter(String inputDateString) {
        String result = "";
        String inputFormat = "yyyy-MM-dd HH:mm:ss";
        String outputFormat = "dd/MM/yy HH:mm:ss";
        try {
            SimpleDateFormat inputFormatter = new SimpleDateFormat(inputFormat);
            Date date = inputFormatter.parse(inputDateString);
            SimpleDateFormat outputFormatter = new SimpleDateFormat(outputFormat);
            String outputDateString = outputFormatter.format(date);
            System.out.println("Input Date: " + inputDateString);
            System.out.println("Formatted Date: " + outputDateString);
            result = outputDateString;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in dateFormatter. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        return result;
    }

    public static void modifyElementValue(Element element, String parentTagName, String tagName, String newValue, int occurrence) {
        Element parentElement;
        NodeList nodeList;
        NodeList parentList = element.getElementsByTagName(parentTagName);
        if (parentList.getLength() > 0 && (nodeList = (parentElement = (Element)parentList.item(0)).getElementsByTagName(tagName)).getLength() > occurrence) {
            Element childElement = (Element)nodeList.item(occurrence);
            childElement.setTextContent(newValue);
        }
    }

    public static void modifyIdValue(Element root, String newValue, int occurrence) {
        NodeList cdtrAcctList = root.getElementsByTagName("CdtrAcct");
        if (cdtrAcctList.getLength() > 0) {
            Element cdtrAcctElement = (Element)cdtrAcctList.item(0);
            NodeList idList = cdtrAcctElement.getElementsByTagName("Id");
            if (idList.getLength() > occurrence) {
                Element idElement = (Element)idList.item(occurrence);
                NodeList othrList = idElement.getElementsByTagName("Othr");
                if (othrList.getLength() > 0) {
                    Element othrElement = (Element)othrList.item(0);
                    NodeList idValueList = othrElement.getElementsByTagName("Id");
                    if (idValueList.getLength() > 0) {
                        Element idValueElement = (Element)idValueList.item(0);
                        idValueElement.setTextContent(newValue);
                    } else {
                        System.out.println("Id value element not found inside <Othr>");
                    }
                } else {
                    System.out.println("Othr element not found inside <Id>");
                }
            } else {
                System.out.println("Id element not found inside <CdtrAcct>");
            }
        } else {
            System.out.println("CdtrAcct element not found");
        }
    }

    public static void modifyCdtrAgtValues(Element root, String mmbIdValue, String nmValue) {
        NodeList cdtrAgtList = root.getElementsByTagName("CdtrAgt");
        if (cdtrAgtList.getLength() > 0) {
            Element cdtrAgtElement = (Element)cdtrAgtList.item(0);
            NodeList finInstnIdList = cdtrAgtElement.getElementsByTagName("FinInstnId");
            if (finInstnIdList.getLength() > 0) {
                Element finInstnIdElement = (Element)finInstnIdList.item(0);
                NodeList mmbIdList = finInstnIdElement.getElementsByTagName("MmbId");
                if (mmbIdList.getLength() > 0) {
                    Element mmbIdElement = (Element)mmbIdList.item(0);
                    mmbIdElement.setTextContent(mmbIdValue);
                } else {
                    System.out.println("MmbId element not found inside <ClrSysMmbId>");
                }
                NodeList nmList = finInstnIdElement.getElementsByTagName("Nm");
                if (nmList.getLength() > 0) {
                    Element nmElement = (Element)nmList.item(0);
                    nmElement.setTextContent(nmValue);
                } else {
                    System.out.println("Nm element not found inside <FinInstnId>");
                }
            } else {
                System.out.println("FinInstnId element not found inside <CdtrAgt>");
            }
        } else {
            System.out.println("CdtrAgt element not found");
        }
    }

    public static String consolidateXMLs(String inputFolderPath, String outputFilePath, String customMsgId, String customPmtInfId) throws IOException {
        String consolidateXMLsResult = "";
        try {
            System.out.println("inputFolderPath: [" + inputFolderPath + "]");
            System.out.println("outputFilePath: [" + outputFilePath + "]");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document consolidatedDocument = dBuilder.newDocument();
            Element rootElement = consolidatedDocument.createElementNS("urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "Document");
            rootElement.setAttribute("xmlns", "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
            rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            consolidatedDocument.appendChild(rootElement);
            int totalTransactions = 0;
            double totalCtrlSum = 0.0;
            File firstFile = new File(inputFolderPath);
            if (firstFile.isDirectory()) {
                File[] xmlFiles = firstFile.listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));
                String filenameToRemove = "UNS_HSBC_XML_Template.xml";
                ArrayList<File> filteredFiles = new ArrayList<File>();
                File[] fileArray = xmlFiles;
                int n = xmlFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.getName().equalsIgnoreCase(filenameToRemove)) {
                        filteredFiles.add(file);
                    }
                    ++n2;
                }
                xmlFiles = filteredFiles.toArray(new File[0]);
                if (xmlFiles == null || xmlFiles.length == 0) {
                    String errString = "No XML files found in the specified directory.";
                    System.err.println(errString);
                    return errString;
                }
                if (xmlFiles != null && xmlFiles.length > 0) {
                    Document firstDoc = dBuilder.parse(xmlFiles[0]);
                    Node cstmrCdtTrfInitnNode = firstDoc.getElementsByTagName("CstmrCdtTrfInitn").item(0);
                    Node importedCstmrCdtTrfInitnNode = consolidatedDocument.importNode(cstmrCdtTrfInitnNode, true);
                    rootElement.appendChild(importedCstmrCdtTrfInitnNode);
                    Element pmtInfNode = (Element)((Element)importedCstmrCdtTrfInitnNode).getElementsByTagName("PmtInf").item(0);
                    File[] fileArray2 = xmlFiles;
                    int n3 = xmlFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File xmlFile = fileArray2[n4];
                        Document doc = dBuilder.parse(xmlFile);
                        NodeList cdtTrfTxInfNodes = doc.getElementsByTagName("CdtTrfTxInf");
                        totalTransactions += cdtTrfTxInfNodes.getLength();
                        NodeList ctrlSumNodes = doc.getElementsByTagName("CtrlSum");
                        if (ctrlSumNodes.getLength() > 0) {
                            Element ctrlSumElement = (Element)ctrlSumNodes.item(0);
                            totalCtrlSum += Double.parseDouble(ctrlSumElement.getTextContent());
                        }
                        int j = 0;
                        while (j < cdtTrfTxInfNodes.getLength()) {
                            Node node;
                            if (!(j == 0 && xmlFile.equals(xmlFiles[0]) || (node = cdtTrfTxInfNodes.item(j)).getNodeType() != 1)) {
                                Node copiedNode = consolidatedDocument.importNode(node, true);
                                pmtInfNode.appendChild(copiedNode);
                            }
                            ++j;
                        }
                        ++n4;
                    }
                    Element grpHdrNode = (Element)((Element)importedCstmrCdtTrfInitnNode).getElementsByTagName("GrpHdr").item(0);
                    Element ctrlSumNode = (Element)grpHdrNode.getElementsByTagName("CtrlSum").item(0);
                    DecimalFormat decimalFormat = new DecimalFormat("#.##");
                    String formattedTotalCtrlSum = decimalFormat.format(totalCtrlSum);
                    System.out.println("Total CtrlSum: [" + formattedTotalCtrlSum + "]");
                    ctrlSumNode.setTextContent(String.valueOf(formattedTotalCtrlSum));
                    Element nbOfTxsNode = (Element)grpHdrNode.getElementsByTagName("NbOfTxs").item(0);
                    nbOfTxsNode.setTextContent(String.valueOf(totalTransactions));
                    Element nbOfTxsPmtInfNode = (Element)pmtInfNode.getElementsByTagName("NbOfTxs").item(0);
                    nbOfTxsPmtInfNode.setTextContent(String.valueOf(totalTransactions));
                    Element ctrlSumPmtInfNode = (Element)pmtInfNode.getElementsByTagName("CtrlSum").item(0);
                    ctrlSumPmtInfNode.setTextContent(String.valueOf(formattedTotalCtrlSum));
                    Element msgIdNode = (Element)grpHdrNode.getElementsByTagName("MsgId").item(0);
                    msgIdNode.setTextContent(customMsgId);
                    Element pmtInfIdNode = (Element)pmtInfNode.getElementsByTagName("PmtInfId").item(0);
                    pmtInfIdNode.setTextContent(customPmtInfId);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(consolidatedDocument);
            StreamResult result = new StreamResult(new File(outputFilePath));
            transformer.transform(source, result);
            System.out.println("Consolidated XML file has been created successfully!");
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in consolidateXMLs. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        CommonMethods.moveFilesToArchive(inputFolderPath, CommonMethods.generateArchiveFolderNameForScheduler(), String.valueOf(customMsgId) + ".xml");
        return consolidateXMLsResult;
    }

    private static String generateConsolidatedXMLFileName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmm");
        String formattedDate = dateFormat.format(new Date());
        return String.valueOf(formattedDate) + ".xml";
    }

    private static String getFileNameWithoutExtension(String formattedDate) {
        int lastDotIndex = formattedDate.lastIndexOf(".");
        if (lastDotIndex != -1) {
            return formattedDate.substring(0, lastDotIndex);
        }
        return formattedDate;
    }

    private static void moveFilesToArchive(String filePath, String archiveFolderName, String consolidateXMLFileName) throws IOException {
        File archiveDir = new File(String.valueOf(filePath) + File.separator + archiveFolderName);
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        System.out.println("consolidateXMLFileName[" + consolidateXMLFileName + "]");
        String[] filenamesToRemove = new String[]{"UNS_HSBC_XML_Template.xml", consolidateXMLFileName};
        File[] xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));
        List<String> filenamesToRemoveList = Arrays.asList(filenamesToRemove);
        ArrayList<File> filteredFiles = new ArrayList<File>();
        File[] fileArray = xmlFiles;
        int n = xmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!filenamesToRemoveList.contains(file.getName())) {
                filteredFiles.add(file);
            }
            ++n2;
        }
        xmlFiles = filteredFiles.toArray(new File[0]);
        if (xmlFiles != null) {
            fileArray = xmlFiles;
            n = xmlFiles.length;
            n2 = 0;
            while (n2 < n) {
                File xmlFile = fileArray[n2];
                Path sourcePath = Paths.get(xmlFile.getAbsolutePath(), new String[0]);
                Path destinationPath = Paths.get(String.valueOf(archiveDir.getAbsolutePath()) + File.separator + xmlFile.getName(), new String[0]);
                Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                ++n2;
            }
        }
    }

    private static String generateArchiveFolderNameForScheduler() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH");
        return dateFormat.format(new Date());
    }

    public static void deleteOldFiles(String directoryPath, String[] filesToIgnore) {
        File directory = new File(directoryPath);
        if (!directory.exists() || !directory.isDirectory()) {
            System.err.println("Invalid directory path: " + directoryPath);
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long twoWeeksInMillis = TimeUnit.DAYS.toMillis(14L);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            long fileLastModified;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                CommonMethods.deleteOldFiles(file.getAbsolutePath(), filesToIgnore);
            } else if (!CommonMethods.shouldIgnore(file.getName(), filesToIgnore) && currentTime - (fileLastModified = file.lastModified()) > twoWeeksInMillis) {
                System.out.println("Deleting file: " + file.getAbsolutePath());
                file.delete();
            }
            ++n2;
        }
    }

    private static boolean shouldIgnore(String fileName, String[] filesToIgnore) {
        String[] stringArray = filesToIgnore;
        int n = filesToIgnore.length;
        int n2 = 0;
        while (n2 < n) {
            String ignore = stringArray[n2];
            if (fileName.equals(ignore)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String uploadFileToSFTP(String bankCode, UserInfoBean userInfo) throws ITMException {
        String result = "";
        String tranID = "";
        String consolidatedXMLFileName = "";
        boolean fileCount = false;
        try {
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + bankCode + "'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]"));
            JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
            String localFolderPath = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
            localFolderPath = String.valueOf(localFolderPath) + File.separator + "XML_files";
            BaseLogger.log((String)"3", null, null, (Object)("Inside localFolderPath[ " + localFolderPath + "]"));
            String[] filesToIgnore = new String[]{"UNS_HSBC_XML_Template.xml"};
            CommonMethods.deleteOldFiles(localFolderPath, filesToIgnore);
            consolidatedXMLFileName = CommonMethods.generateConsolidatedXMLFileName();
            String consolidatedXMLPath = CommonConstants.TEMP_FOLDER;
            String consolidateXMLsResult = CommonMethods.consolidateXMLs(localFolderPath, String.valueOf(consolidatedXMLPath) + File.separator + consolidatedXMLFileName, CommonMethods.getFileNameWithoutExtension(consolidatedXMLFileName), CommonMethods.getFileNameWithoutExtension(consolidatedXMLFileName));
            BaseLogger.log((String)"3", null, null, (Object)("consolidatedXMLFileName[ " + consolidatedXMLFileName + "]"));
            if (consolidateXMLsResult.equalsIgnoreCase("No XML files found in the specified directory.")) {
                String string = result = "No XML files found in the specified directory.";
                return string;
            }
            try {
                BaseLogger.log((String)"3", null, null, (Object)("consolidatedXMLFileName + path[ " + consolidatedXMLPath + File.separator + consolidatedXMLFileName + "]"));
                String[] transactionIds = new String[]{};
                try {
                    String[] stringArray = transactionIds = CommonMethods.parseXmlForInstrIds(String.valueOf(consolidatedXMLPath) + File.separator + consolidatedXMLFileName);
                    int n = transactionIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String transactionId;
                        tranID = transactionId = stringArray[n2];
                        System.out.println("transactionId: " + transactionId);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Exception in uploadSingleFile. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                }
                this.updateBankTransferID(consolidatedXMLFileName, transactionIds, userInfo);
                SFTPFileUploader sftpFileUploader = new SFTPFileUploader(payIntArgsJSON);
                result = String.valueOf(result) + ", File Name: " + consolidatedXMLFileName;
                BaseLogger.log((String)"3", null, null, (Object)("result from sftpFileUploader.uploadSingleFile [ " + result + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception in uploadSingleFile. [" + result + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            UpdatePaymentStatus updatePaymentStatus = new UpdatePaymentStatus();
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            String paymentTransXML1stStage = "";
            try {
                String refSer = dbAccessEJB.getDBColumnValue("BANKTRAN_LOG", "TRAN_SER", "TRAN_NO  = '" + tranID + "'", userInfo.getTransDB());
                BaseLogger.log((String)"3", null, null, (Object)("Value of refSer... [" + refSer + "]"));
                paymentTransXML1stStage = result.contains("File uploaded successfully") ? updatePaymentStatus.getTransXML(consolidatedXMLFileName, refSer, "Payment Initiated", "File Uploaded to Bank's SFTP Server", "") : updatePaymentStatus.getTransXML(consolidatedXMLFileName, refSer, "Payment Initiated", "Error" + result, "");
                updatePaymentStatus.updatePaymentStatus(paymentTransXML1stStage, userInfo);
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception in uploadFileToSFTP. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            }
        }
        return result;
    }

    public void updateBankTransferID(String bankTransferId, String[] transactionIds, UserInfoBean userInfo) throws SQLException {
        Connection connection = null;
        PreparedStatement psmt = null;
        ConnDriver connDriver = new ConnDriver();
        String transDB = userInfo.getTransDB();
        try {
            connection = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in uploadFileToSFTP. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        String sql = "UPDATE misc_payment SET bank_transfer_id = ? WHERE TRAN_ID IN (";
        int i = 0;
        while (i < transactionIds.length) {
            sql = String.valueOf(sql) + (i == 0 ? "?" : ", ?");
            ++i;
        }
        sql = String.valueOf(sql) + ")";
        try {
            try {
                psmt = connection.prepareStatement(sql);
                psmt.setString(1, bankTransferId);
                i = 0;
                while (i < transactionIds.length) {
                    psmt.setString(i + 2, transactionIds[i]);
                    ++i;
                }
                int rowsAffected = psmt.executeUpdate();
                System.out.println("Rows affected: " + rowsAffected);
                connection.commit();
            }
            catch (SQLException e) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
                e.printStackTrace();
                try {
                    if (psmt != null) {
                        psmt.close();
                        psmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (psmt != null) {
                    psmt.close();
                    psmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] parseXmlForInstrIds(String filePath) throws Exception {
        ArrayList<String> instrIdsList = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(filePath));
        NodeList nodeList = document.getElementsByTagNameNS("*", "InstrId");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            String instrId = element.getTextContent();
            instrIdsList.add(instrId);
            ++i;
        }
        String[] instrIdsArray = instrIdsList.toArray(new String[0]);
        return instrIdsArray;
    }

    public static HashMap<String, String> Acknowledgement2Reader(String filePath) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            File xmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList txInfAndStsList = doc.getElementsByTagName("TxInfAndSts");
            int i = 0;
            while (i < txInfAndStsList.getLength()) {
                Node txInfAndStsNode = txInfAndStsList.item(i);
                if (txInfAndStsNode.getNodeType() == 1) {
                    Element txInfAndStsElement = (Element)txInfAndStsNode;
                    String endToEndId = txInfAndStsElement.getElementsByTagName("OrgnlEndToEndId").item(0).getTextContent();
                    String status = txInfAndStsElement.getElementsByTagName("TxSts").item(0).getTextContent();
                    StringBuilder valueBuilder = new StringBuilder();
                    valueBuilder.append("Status: ").append(status).append("\n");
                    NodeList rsnInfList = txInfAndStsElement.getElementsByTagName("StsRsnInf");
                    int j = 0;
                    while (j < rsnInfList.getLength()) {
                        Node rsnInfNode = rsnInfList.item(j);
                        if (rsnInfNode.getNodeType() == 1) {
                            Element rsnInfElement = (Element)rsnInfNode;
                            String rsnCd = rsnInfElement.getElementsByTagName("Cd").item(0).getTextContent();
                            NodeList addtlInfList = rsnInfElement.getElementsByTagName("AddtlInf");
                            valueBuilder.append("\nStatus Information ").append(j + 1).append("\n");
                            valueBuilder.append("Reason Code: ").append(rsnCd).append("\n");
                            valueBuilder.append("Additional Information: ");
                            int k = 0;
                            while (k < addtlInfList.getLength()) {
                                valueBuilder.append(addtlInfList.item(k).getTextContent()).append(" ");
                                ++k;
                            }
                            valueBuilder.append("\n");
                        }
                        ++j;
                    }
                    valueBuilder.append("--");
                    dataMap.put(endToEndId, valueBuilder.toString());
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in Acknowledgement2Reader. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        return dataMap;
    }

    public static String getErrorStrFromRetString(String returnXML, String calledFrom) {
        StringBuilder errorStr = new StringBuilder();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(returnXML.getBytes()));
            NodeList errorList = document.getElementsByTagName("error");
            int i = 0;
            while (i < errorList.getLength()) {
                Node errorNode = errorList.item(i);
                if (errorNode.getNodeType() != 1) {
                    return String.valueOf(calledFrom) + " Transaction is Saved.";
                }
                Element errorElement = (Element)errorNode;
                String message = errorElement.getElementsByTagName("message").item(0).getTextContent();
                String description = errorElement.getElementsByTagName("description").item(0).getTextContent();
                errorStr.append("Message From " + calledFrom + ":").append(message).append("\n");
                errorStr.append("Description: ").append(description).append("\n");
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in getErrorStrFromRetString. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        return errorStr.toString();
    }

    public void downloadFileFromSFTPandProcess(String bankCode, UserInfoBean userInfo) throws Exception {
        try {
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + bankCode + "'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]"));
            JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
            String localFolderPath = CommonConstants.TEMP_FOLDER;
            localFolderPath = String.valueOf(localFolderPath) + File.separator + "From HSBC";
            BaseLogger.log((String)"3", null, null, (Object)("Inside downloadFile localFolderPathsss [" + localFolderPath + "]"));
            String isLocalFolder = CommonMethods.getValueFromJson(payIntArgsJSON, "local_folder");
            BaseLogger.log((String)"3", null, null, (Object)("Inside downloadFile isLocalFolder [" + isLocalFolder + "]"));
            if (isLocalFolder.equalsIgnoreCase("N")) {
                BaseLogger.log((String)"3", null, null, (Object)"Inside local folder = N");
                SFTPFileDownloader sftpFileReader = new SFTPFileDownloader(payIntArgsJSON);
                sftpFileReader.downloadFolder("/", localFolderPath);
            }
            CommonMethods.moveFiles(localFolderPath);
            String acknowledgmentFolderPath = String.valueOf(localFolderPath) + File.separator + "Acknowledgement Files";
            this.processAcknowledgementFiles(acknowledgmentFolderPath, userInfo);
            if (isUTRPresent) {
                System.out.println("Inside yes UTR is present");
                String csvFilePath = String.valueOf(localFolderPath) + File.separator + "UTR" + File.separator + UTRFileName;
                System.out.println("CSV FILE PATH: [" + csvFilePath + "]");
                UpdateUTR updateUTR = new UpdateUTR();
                updateUTR.readUTRCsvAndUpdateUTR(csvFilePath, "Customer Reference Number", "Bank Ref no", "Value Date", userInfo);
                CommonMethods.moveFileToArchive(csvFilePath, String.valueOf(localFolderPath) + File.separator + "UTR" + File.separator + "Archive");
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            throw new ITMException(e);
        }
    }

    public static void moveFiles(String filePath) throws ITMException {
        System.out.println("Inside moveFile method: [" + filePath + "]");
        try {
            File directory = new File(filePath);
            if (!directory.isDirectory()) {
                System.out.println("Invalid directory path.");
                return;
            }
            File utrDirectory = new File(directory, "UTR");
            CommonMethods.createDirectoryIfNotExists(utrDirectory);
            File ackDirectory = new File(directory, "Acknowledgement Files");
            CommonMethods.createDirectoryIfNotExists(ackDirectory);
            File[] files = directory.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        if (file.getName().toLowerCase().endsWith(".csv")) {
                            isUTRPresent = true;
                            UTRFileName = file.getName();
                            CommonMethods.moveFile(file, utrDirectory);
                        } else {
                            CommonMethods.moveFile(file, ackDirectory);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            throw new ITMException(e);
        }
    }

    private static void moveFile(File sourceFile, File destinationDirectory) {
        try {
            Path destinationPath = new File(destinationDirectory, sourceFile.getName()).toPath();
            Files.move(sourceFile.toPath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Moved " + sourceFile.getName() + " to " + destinationPath);
        }
        catch (FileAlreadyExistsException e) {
            System.out.println("File already exists in the destination directory: " + sourceFile.getName());
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        catch (IOException e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
    }

    private static void createDirectoryIfNotExists(File directory) {
        if (!directory.exists()) {
            try {
                Files.createDirectory(directory.toPath(), new FileAttribute[0]);
                System.out.println(String.valueOf(directory.getName()) + " directory created.");
            }
            catch (IOException e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception createDirectoryIfNotExists. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception createDirectoryIfNotExists. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            }
        }
    }

    public void processAcknowledgementFiles(String ackDirectoryPath, UserInfoBean userInfo) throws Exception {
        System.out.println("Inside processAcknowledgementFiles [" + ackDirectoryPath + "]");
        try {
            File ackDirectory = new File(ackDirectoryPath);
            if (!ackDirectory.isDirectory()) {
                System.out.println("Invalid Acknowledgement Files directory path.");
                return;
            }
            File archiveDirectory = new File(ackDirectory, "Archive");
            CommonMethods.createDirectoryIfNotExists(archiveDirectory);
            File[] files = ackDirectory.listFiles();
            if (files != null) {
                System.out.println("Inside files gsb [" + files.toString() + "]");
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    System.out.println("Inside for loop gsb [" + file.getAbsolutePath() + "]");
                    if (file.isFile()) {
                        System.out.println("Inside file.isFile() gsb [" + file.getAbsolutePath() + "]");
                        this.processAcknowledgementFile(file, archiveDirectory, userInfo);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
    }

    private void processAcknowledgementFile(File file, File archiveDirectory, UserInfoBean userInfo) throws Exception {
        System.out.println("Inside processAcknowledgementFile file[" + file.getAbsolutePath() + "]");
        String fileName = file.getName();
        String ackType = CommonMethods.getAckType(fileName).trim();
        String paymentId = CommonMethods.getPaymentId(fileName);
        if ("ACK1".equals(ackType)) {
            String idFrom1stAcknowledgement = CommonMethods.getAcknowledgmentTagValue(file.getAbsolutePath(), "OrgnlMsgId", "");
            BaseLogger.log((String)"3", null, null, (Object)("idFrom1stAcknowledgement[" + idFrom1stAcknowledgement + "]"));
            String grpStsFrom1stAcknowledgement = CommonMethods.getAcknowledgmentTagValue(file.getAbsolutePath(), "GrpSts", "");
            BaseLogger.log((String)"3", null, null, (Object)("grpStsFrom1stAcknowledgement[" + grpStsFrom1stAcknowledgement + "]"));
            String addlInfFrom1stAcknowledgement = "";
            String transResult = "";
            if (grpStsFrom1stAcknowledgement.equalsIgnoreCase("RJCT")) {
                try {
                    BaseLogger.log((String)"3", null, null, (Object)("Inside reject [" + grpStsFrom1stAcknowledgement + "]"));
                    addlInfFrom1stAcknowledgement = CommonMethods.getAcknowledgmentTagValue(file.getAbsolutePath(), "AddtlInf", "");
                    BaseLogger.log((String)"3", null, null, (Object)("addlInfFrom1stAcknowledgement[" + addlInfFrom1stAcknowledgement + "]"));
                    PaymentCancellation paymentCancellation = new PaymentCancellation();
                    String transXMLHeader = paymentCancellation.generateTransXMLForHeader(idFrom1stAcknowledgement, userInfo);
                    String transXMLDetail = paymentCancellation.generateTransXMLForDetail(idFrom1stAcknowledgement, userInfo);
                    transResult = paymentCancellation.paymentCancellation(transXMLHeader, transXMLDetail, userInfo);
                    DBAccessEJB dbAccessEJB = new DBAccessEJB();
                    String bankTransferID22 = String.valueOf(idFrom1stAcknowledgement) + ".xml";
                    String tranID = dbAccessEJB.getDBColumnValue("MISC_PAYMENT", "TRAN_ID", "BANK_TRANSFER_ID  = '" + bankTransferID22 + "'", userInfo.getTransDB());
                    BaseLogger.log((String)"3", null, null, (Object)("tranID gsb[" + tranID + "]"));
                    String bankEmailID = CommonMethods.getEventNotifyEmailFromBankMaster(tranID, userInfo);
                    System.out.println("bankEmailID gsb[" + bankEmailID + "]");
                    HashMap<String, Object> mailFormatDetails = new HashMap<String, Object>();
                    mailFormatDetails.put("SEND_TO", bankEmailID);
                    mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
                    mailFormatDetails.put("SUBJECT", "Payment Cancellation for Payment ID:" + idFrom1stAcknowledgement);
                    mailFormatDetails.put("BODY", "This mail is to inform that payment has been cancelled for Payment ID: " + idFrom1stAcknowledgement + "\nReason: " + addlInfFrom1stAcknowledgement);
                    EMail email = new EMail();
                    email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
                    System.out.println("getMailFrom1....::" + email.getMailFrom());
                    String mailXMLStr = this.buildMailXMLStr(mailFormatDetails, userInfo);
                    String emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
                    System.out.println("emailStatus....::" + emailStatus);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BaseLogger.log((String)"3", null, null, (Object)("Exception in processAcknowledgementFile. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                    File ackFailLogDirectory = new File(file.getParent(), "ackFailLog");
                    CommonMethods.createDirectoryIfNotExists(ackFailLogDirectory);
                    File logFile = new File(ackFailLogDirectory, "ACK1_parseFail.log");
                    Throwable dbAccessEJB = null;
                    Object bankTransferID22 = null;
                    try (FileWriter logWriter = new FileWriter(logFile, true);){
                        logWriter.write("File Name: " + file.getName() + System.lineSeparator());
                        logWriter.write("Exception occurred: " + e.toString() + System.lineSeparator());
                        logWriter.write(String.valueOf(E12GenericUtility.getStackTrace((Exception)e)) + System.lineSeparator());
                    }
                    catch (Throwable bankTransferID22) {
                        if (dbAccessEJB == null) {
                            dbAccessEJB = bankTransferID22;
                        } else if (dbAccessEJB != bankTransferID22) {
                            dbAccessEJB.addSuppressed(bankTransferID22);
                        }
                        throw dbAccessEJB;
                    }
                    File destinationFile = new File(ackFailLogDirectory, file.getName());
                    if (file.renameTo(destinationFile)) {
                        System.out.println("File moved to: " + destinationFile.getAbsolutePath());
                    }
                    System.err.println("Failed to move the file to: " + ackFailLogDirectory.getAbsolutePath());
                }
            }
            this.updatePaymentStatus1stAck(idFrom1stAcknowledgement, grpStsFrom1stAcknowledgement, addlInfFrom1stAcknowledgement, "", userInfo);
        } else if ("ACK2".equals(ackType)) {
            String idFrom2ndAcknowledgement = "";
            String txstsFrom2ndAcknowledgement = "";
            String transResult = "";
            String addlInfFrom2ndAcknowledgement = "";
            HashMap<String, String> dataMap = CommonMethods.Acknowledgement2Reader(file.getAbsolutePath());
            BaseLogger.log((String)"3", null, null, (Object)("dataMap gsb[" + dataMap + "]"));
            Iterator<String> iterator = dataMap.keySet().iterator();
            while (iterator.hasNext()) {
                String endToEndId;
                idFrom2ndAcknowledgement = endToEndId = iterator.next();
                System.out.println("End to End ID: " + endToEndId);
                String value = dataMap.get(endToEndId);
                txstsFrom2ndAcknowledgement = value.split("\n")[0].split(": ")[1].trim();
                System.out.println("TxSts: " + txstsFrom2ndAcknowledgement);
                String[] lines = value.split("\n");
                int i = 0;
                while (i < lines.length) {
                    if (lines[i].startsWith("Additional Information: ")) {
                        addlInfFrom2ndAcknowledgement = String.valueOf(addlInfFrom2ndAcknowledgement) + lines[i].substring("Additional Information: ".length()) + "\n";
                    }
                    ++i;
                }
                if (txstsFrom2ndAcknowledgement.equalsIgnoreCase("RJCT") || txstsFrom2ndAcknowledgement.equalsIgnoreCase("PDNG") || txstsFrom2ndAcknowledgement.equalsIgnoreCase("PART")) {
                    BaseLogger.log((String)"3", null, null, (Object)("Ack2 RJCT Case[" + addlInfFrom2ndAcknowledgement + "]"));
                    try {
                        PaymentCancellation paymentCancellation = new PaymentCancellation();
                        String transXMLHeader = paymentCancellation.generateTransXMLForHeader(idFrom2ndAcknowledgement, userInfo);
                        String transXMLDetail = paymentCancellation.generateTransXMLForDetail(idFrom2ndAcknowledgement, userInfo);
                        transResult = paymentCancellation.paymentCancellation(transXMLHeader, transXMLDetail, userInfo);
                        String bankEmailID = CommonMethods.getEventNotifyEmailFromBankMaster(idFrom2ndAcknowledgement, userInfo);
                        System.out.println("bankEmailID gsb[" + bankEmailID + "]");
                        HashMap<String, Object> mailFormatDetails = new HashMap<String, Object>();
                        mailFormatDetails.put("SEND_TO", bankEmailID);
                        mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
                        mailFormatDetails.put("SUBJECT", "Payment Cancellation for Payment ID:" + idFrom2ndAcknowledgement);
                        mailFormatDetails.put("BODY", "This mail is to inform that payment has been cancelled for Payment ID: " + idFrom2ndAcknowledgement + "\nReason: " + addlInfFrom2ndAcknowledgement);
                        EMail email = new EMail();
                        email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
                        System.out.println("getMailFrom1....::" + email.getMailFrom());
                        String mailXMLStr = this.buildMailXMLStr(mailFormatDetails, userInfo);
                        String emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
                        System.out.println("emailStatus....::" + emailStatus);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                    }
                    this.updatePaymentStatus2ndAck(paymentId.trim(), idFrom2ndAcknowledgement.trim(), txstsFrom2ndAcknowledgement.trim(), addlInfFrom2ndAcknowledgement.trim(), transResult.trim(), userInfo);
                    addlInfFrom2ndAcknowledgement = "";
                    continue;
                }
                if (txstsFrom2ndAcknowledgement.equalsIgnoreCase("ACCP") || txstsFrom2ndAcknowledgement.equalsIgnoreCase("ACTC") || txstsFrom2ndAcknowledgement.equalsIgnoreCase("ACSP") || txstsFrom2ndAcknowledgement.equalsIgnoreCase("ACSC") || txstsFrom2ndAcknowledgement.equalsIgnoreCase("ACWC")) {
                    this.updatePaymentStatus2ndAck(paymentId.trim(), idFrom2ndAcknowledgement.trim(), txstsFrom2ndAcknowledgement.trim(), "", "", userInfo);
                    continue;
                }
                System.out.println("Unsupported acknowledgement type:[" + ackType + "]");
                return;
            }
        }
        CommonMethods.moveFileToArchive(file, archiveDirectory);
    }

    private static String getAckType(String fileName) {
        String[] parts = fileName.split("\\.");
        if (parts.length > 0) {
            return parts[0].substring(0, Math.min(4, parts[0].length()));
        }
        return "";
    }

    private static String getPaymentId(String fileName) {
        System.out.println("Inside getPaymentId fileName:[" + fileName + "]");
        String[] parts = fileName.split("\\.");
        if (parts.length >= 3) {
            return parts[2];
        }
        return null;
    }

    private void updatePaymentStatus1stAck(String IDFromAck1, String stsFromAck1, String addlInfAck1, String transResult, UserInfoBean userInfo) {
        stsFromAck1 = String.valueOf(stsFromAck1) + " " + transResult;
        System.out.println("Inside updatePaymentStatus1stAck[: " + IDFromAck1 + "] stsFromAck1 [" + stsFromAck1 + "] addlInfAck2 [" + addlInfAck1 + "]");
        UpdatePaymentStatus updatePaymentStatus = new UpdatePaymentStatus();
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        String refSer = "";
        try {
            refSer = dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", "TRAN_WINDOW  = 'w_misc_pay'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Value of refser... [" + refSer + "]"));
            String transXMLFor1stAcknowldgement = updatePaymentStatus.getTransXML(IDFromAck1, refSer, "1st Acknowledgement Received", stsFromAck1, addlInfAck1);
            updatePaymentStatus.updatePaymentStatus(transXMLFor1stAcknowldgement, userInfo);
        }
        catch (ITMException | RemoteException e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in updatePaymentStatus1stAck. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in updatePaymentStatus1stAck. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
    }

    private void updatePaymentStatus2ndAck(String paymentId, String IDFromAck2, String stsFromAck2, String addlInfAck2, String transResult, UserInfoBean userInfo) {
        stsFromAck2 = String.valueOf(stsFromAck2) + " " + transResult;
        System.out.println("Updating payment status for ACK2 with paymentId: " + paymentId);
        System.out.println("Inside updatePaymentStatus2ndAck IDFromAck2[: " + IDFromAck2 + "] stsFromAck2 [" + stsFromAck2 + "] addlInfAck2 [" + addlInfAck2 + "]");
        UpdatePaymentStatus updatePaymentStatus = new UpdatePaymentStatus();
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        String refSer = "";
        try {
            refSer = dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", "TRAN_WINDOW  = 'w_misc_pay'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Value of refser... [" + refSer + "]"));
            String transXMLFor2ndAcknowldgement = updatePaymentStatus.getTransXML(IDFromAck2, refSer, "2nd Acknowledgement Received", stsFromAck2, addlInfAck2);
            updatePaymentStatus.updatePaymentStatus(transXMLFor2ndAcknowldgement, userInfo);
        }
        catch (ITMException | RemoteException e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in updatePaymentStatus2ndAck. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in updatePaymentStatus2ndAck. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
    }

    public static String getAcknowledgmentTagValue(String filePath, String tagName, String parentTagName) {
        String result = "";
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method filePath [" + filePath + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method tagName [" + tagName + "]"));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(filePath));
            BaseLogger.log((String)"3", null, null, (Object)("Acknowledgement document:[" + E12GenericUtility.documentToString((Document)document) + "]"));
            if (parentTagName.equalsIgnoreCase("")) {
                result = CommonMethods.getElementValueByTagName(document, tagName);
            } else {
                Element rootElement = document.getDocumentElement();
                System.out.println("Root Element gsb: " + document.getDocumentElement().getTagName());
                result = CommonMethods.getElementValue(rootElement, parentTagName, tagName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        BaseLogger.log((String)"3", null, null, (Object)("result from getAcknowledgmentTagValue:[" + result + "]"));
        return result;
    }

    private static String getElementValueByTagName(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            return element.getTextContent();
        }
        return null;
    }

    private static String getElementValue(Element parentElement, String parentTagName, String tagName) {
        NodeList parentNodes = parentElement.getElementsByTagName(parentTagName);
        int i = 0;
        while (i < parentNodes.getLength()) {
            int j = 0;
            Element parent = (Element)parentNodes.item(i);
            NodeList nodeList = parent.getElementsByTagName(tagName);
            if (j < nodeList.getLength()) {
                Element element = (Element)nodeList.item(j);
                return element.getTextContent();
            }
            ++i;
        }
        return null;
    }

    private static void moveFileToArchive(File sourceFile, File archiveDirectory) {
        System.out.println("Inside moveFileToArchive sourceFile [" + sourceFile.getAbsolutePath() + "]  archiveDirectory [" + archiveDirectory.getAbsolutePath() + "]");
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
            String dateFolderName = dateFormat.format(new Date());
            File dateFolder = new File(archiveDirectory, dateFolderName);
            CommonMethods.createDirectoryIfNotExists(dateFolder);
            Path destinationPath = new File(dateFolder, sourceFile.getName()).toPath();
            Files.move(sourceFile.toPath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Moved " + sourceFile.getName() + " to " + destinationPath);
        }
        catch (IOException e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in moveFileToArchive. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
    }

    public static String findUTRFileForDate(String utrFolderPath, String date) {
        System.out.println("Inside findUTRFileForDate [" + utrFolderPath + "]  Date [" + date + "]");
        File utrDirectory = new File(utrFolderPath);
        if (!utrDirectory.isDirectory()) {
            System.out.println("Invalid UTR directory path.");
            return null;
        }
        File[] files = utrDirectory.listFiles();
        if (files != null) {
            return Arrays.stream(files).filter(file -> file.isFile() && file.getName().contains(date)).max(Comparator.comparing(File::lastModified)).map(File::getName).orElse(null);
        }
        return null;
    }

    public static void moveFileToArchive(String sourceFilePath, String archiveFolderPath) {
        System.out.println("Inside moveFileToArchive [" + sourceFilePath + "]  archiveFolderPath [" + archiveFolderPath + "]");
        try {
            Path sourcePath = Paths.get(sourceFilePath, new String[0]);
            Path archivePath = Paths.get(archiveFolderPath, sourcePath.getFileName().toString());
            CommonMethods.createDirectoryIfNotExists(new File(archiveFolderPath));
            Files.move(sourcePath, archivePath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Moved " + sourcePath.getFileName() + " to " + archivePath);
        }
        catch (FileAlreadyExistsException e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in moveFileToArchive. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            System.out.println("File already exists in the destination directory: " + e.getFile());
        }
        catch (IOException e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in moveFileToArchive. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            e.printStackTrace();
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in moveFileToArchive. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            e.printStackTrace();
        }
    }

    private String buildMailXMLStr(HashMap<String, Object> mailFormatDetails, UserInfoBean userInfo) {
        BaseLogger.log((String)"2", null, null, (Object)"Emailscheduler buildMailXMLStr calling-----------------");
        String mailXMLStr = "";
        String emailID = mailFormatDetails.get("SEND_TO").toString();
        BaseLogger.log((String)"3", null, null, (Object)("emailID [" + emailID + "]"));
        String body = mailFormatDetails.get("BODY").toString();
        BaseLogger.log((String)"3", null, null, (Object)("body [" + body + "]"));
        String formatCode = "";
        String system = mailFormatDetails.get("SUBJECT").toString();
        BaseLogger.log((String)"3", null, null, (Object)("system [" + system + "]"));
        String objName = "";
        String workDateApp = "";
        try {
            BaseLogger.log((String)"2", null, null, (Object)"Inside try block method: buildMailXMLStr ---");
            mailXMLStr = "<ROOT><TRANS_INFO><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_SER></REF_SER><REF_ID>" + workDateApp + "</REF_ID>" + "<LINE_NO>1</LINE_NO></TRANS_INFO>" + "<EMAIL_TYPE></EMAIL_TYPE><ENTITY_CODE></ENTITY_CODE>" + "<FORMAT_CODE>" + formatCode + "</FORMAT_CODE>" + "<LINK_ADDR></LINK_ADDR>" + "<TO_ADD>" + emailID + " </TO_ADD>" + "<CC_ADD>" + mailFormatDetails.get("COPY_TO") + "</CC_ADD>" + "<BCC_ADD>" + mailFormatDetails.get("BLIND_COPY") + "</BCC_ADD>" + "<BODY_TEXT>" + body + "</BODY_TEXT>" + "<SUBJECT>" + mailFormatDetails.get("SUBJECT") + "</SUBJECT>" + "</ROOT>";
            System.out.println("mailXMLStr....::" + mailXMLStr);
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception from buildMailXMLStr [" + system + "]"));
            e.printStackTrace();
        }
        return mailXMLStr;
    }

    public List<String> getFileNames(String filePath) throws IOException {
        ArrayList<String> fileNames;
        block11: {
            System.out.println("Inside getFileNames method filePath: [" + filePath + "]");
            fileNames = new ArrayList<String>();
            Path path = Paths.get(filePath, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                    for (Path p : directoryStream) {
                        if (!p.toString().endsWith(".csv")) continue;
                        fileNames.add(p.getFileName().toString());
                    }
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            throw new IllegalArgumentException("The provided file path does not exist or is not a directory.");
        }
        return fileNames;
    }
}

