/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.utility;

import ibase.scheduler.ejb.ScheduleInfoEJB;
import ibase.scheduler.utility.ScheduleModel;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduleInfoProvider {
    static HashMap scheduleinfoMap = new HashMap();
    private String filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "ScheduleProperties.xml";

    public ScheduleModel getSchedule(String scheduleId) throws BaseException {
        ScheduleModel schModel = null;
        try {
            if (scheduleinfoMap.get(scheduleId) != null) {
                schModel = (ScheduleModel)scheduleinfoMap.get(scheduleId);
            } else {
                schModel = this.parseForSchedule(scheduleId);
                scheduleinfoMap.put(scheduleId, schModel);
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schModel;
    }

    private ScheduleModel parseForSchedule(String scheduleId) throws BaseException {
        ScheduleModel schModel = null;
        try {
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            StringBuffer schedulePropBuff = new StringBuffer();
            BaseLogger.log("3", null, null, "filePath >>>" + this.filePath);
            File file = new File(this.filePath);
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            ScheduleInfoEJB sEJB = new ScheduleInfoEJB();
            String schXMLString = sEJB.getScheduledFromDB(scheduleId);
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document scheduleDom = genericUtility.parseString(schXMLString);
            NodeList scheduleList = scheduleDom.getElementsByTagName("SCHEDULE");
            int noOfSchedules = scheduleList.getLength();
            int scheduleCtr = 0;
            while (scheduleCtr <= noOfSchedules) {
                String currScheduleId;
                Node currSchedule = scheduleList.item(scheduleCtr);
                if (currSchedule != null && currSchedule.getAttributes().getNamedItem("id") != null && scheduleId.equals(currScheduleId = currSchedule.getAttributes().getNamedItem("id").getNodeValue())) {
                    schModel = new ScheduleModel(genericUtility.serializeDom(currSchedule));
                    break;
                }
                ++scheduleCtr;
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schModel;
    }
}

