
package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.*;
import java.util.HashMap;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.w3c.dom.*;

import ibase.ejb.CommonDBAccessEJB;
import ibase.ejb.CommonDBAccessRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistStkUpd;
import ibase.webitm.ejb.fieldsales.ReceiptBackflushWizConfirm;
import ibase.webitm.ejb.mfg.adv.RcpBackflushConfirm;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class RealTimeReportPreSaveEJB extends ValidatorEJB  implements RealTimeReportPreSaveLocal, RealTimeReportPreSaveRemote
{
	E12GenericUtility genericUtility= new  E12GenericUtility();
	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String retString = "";
		String sql = "";
		String custGeoPos = "";
		String varDistance = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Document preSaveXmlDom = null;
		try
		{
			
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			GenericUtility genericUtility = GenericUtility.getInstance();
			preSaveXmlDom = genericUtility.parseString(domString);
			System.out.println("Hariom Changes ---------------- ");
			System.out.println("domString RealTimeReportPreSaveEJB ["+domString+"]");
			String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println("loginCode::"+loginCode);
			
			String currentGeoPos = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"currentGeoPos");
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String strgCode = genericUtility.getColumnValue("strg_code", preSaveXmlDom, "1");
			String localityCode = genericUtility.getColumnValue("locality_code", preSaveXmlDom, "1");
			String activityType = genericUtility.getColumnValue("activity_type", preSaveXmlDom, "1");
			String eventDate = genericUtility.getColumnValue("event_date", preSaveXmlDom, "1");
			String salesPers = genericUtility.getColumnValue("sales_pers", preSaveXmlDom, "1");

			//varDistance = getSfaParmValue(userId,"VARIANCE_DISTANCE_LMT",conn);
			varDistance = getSfaParmValue(userId,"VARIANCE_DISTANC_LMT",conn);

			/*if(varDistance.trim().length() > 0 && "FW".equalsIgnoreCase(activityType))
			{
				sql = "SELECT GEO_POS FROM PLACE_TIME_ENT WHERE ENTITY_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					custGeoPos = (rs.getString("GEO_POS") == null) ?"":rs.getString("GEO_POS");
				}
				else
				{
					sql = "SELECT GEO_POS FROM STRG_CUSTOMER WHERE SC_CODE = ? AND LOCALITY_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,strgCode);
					pstmt.setString(2,localityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						custGeoPos = (rs.getString("GEO_POS") == null) ?"":rs.getString("GEO_POS");
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt=null;
					}
					if(rs!=null)
					{
						rs.close();
						rs = null;
					}
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				System.out.println("currentGeoPos::::::"+currentGeoPos+":::::custGeoPos:::::::"+custGeoPos);
				if( custGeoPos.trim().length() == 0)
				{
					retString = itmDBAccessLocal.getErrorString( "strg_code", "CUSTNOTTAG", userId );
					return retString;
				}

				if( custGeoPos.trim().length() > 0 && currentGeoPos.trim().length() > 0 )
				{
					double lat1 = Double.parseDouble( custGeoPos.split(",")[0] );
					double lng1 = Double.parseDouble( custGeoPos.split(",")[1] );
					double lat2 = Double.parseDouble( currentGeoPos.split(",")[0] );
					double lng2 = Double.parseDouble( currentGeoPos.split(",")[1] );
					long distanceInMtrs = (long) getLatLngInMtr( lat1, lng1, lat2, lng2 );

					if( distanceInMtrs > Double.parseDouble( varDistance ) )
					{
						retString = itmDBAccessLocal.getErrorString( "strg_code", "RPTDISTLMT", userId );
						return retString;
					}
				}
			}*/
			retString=getReceiptBackflush(preSaveXmlDom, salesPers, eventDate,xtraParams,userId, conn);
			System.out.println("getReceiptBackflush : :==gffg "+retString);
			//String acb=updAllocTrace1(preSaveXmlDom, salesPers, eventDate,xtraParams,userId, conn);
			//System.out.println("acbeReportPreSaveEJB : :==gffg "+acb);
			
			String acb=updAllocTrace( preSaveXmlDom, salesPers, eventDate,xtraParams,userId, conn);
			System.out.println("acbeReportPreSaveEJB : :==gffg "+acb);
			
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :RealTimeReportPreSaveEJB : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :RealTimeReportPreSaveEJB : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	private double getLatLngInMtr( double lat1, double lon1, double lat2, double lon2 )
	{
		double R = 6371; // Radius of the earth in km
		double dLat = deg2rad(lat2-lat1);  // deg2rad below
		double dLon = deg2rad(lon2-lon1);
		double a =
				Math.sin(dLat/2) * Math.sin(dLat/2) +
				Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) *
				Math.sin(dLon/2) * Math.sin(dLon/2)
				;
		double c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
		double d = R * c; // Distance in km
		System.out.println("In getAddress()...distanceinMtrs:::"+d*1000);
		return d*1000;
	}

	private double deg2rad( double deg )
	{
		return deg * (Math.PI/180);
	}

	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				System.out.println("inside else");
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of parm name is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	public String updAllocTrace(Document dom, String salesPers,String dcrDate, String xtraParams,String userId, Connection conn) throws ITMException
	{
		System.out.println("userId ======="+userId);
		HashMap hashMap = new HashMap(); 
		String errCode = "", errString = "";
		String lineNo = "";
		String dcrId = "";
		String tranSer = "S-DISS";
		String line = "";
		String siteCode = "", itemCode = "", quantity = "", locCode = "", lotNo = "", lotSl = "";
		double allocQty = 0d;
		int cnt = 0;
		DistStkUpd distStkUpd = null; // for ejb3 
		String updateStatus = "",tranId = "";
		NodeList hdrDom = null;
		ResultSet rs = null; 
		PreparedStatement pstmt = null;
		String sql = "";
		String updateFlag="";
		String formNo="";
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null; 
		try
		{
			
			String loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");
			/*String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;

			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('invoice') ";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}
			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();*/

			/*for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String childNodeName = childNode.getNodeName();
					System.out.println("childNodeName :: ["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
						else if (childNodeName.equalsIgnoreCase("site_code"))
						{
							if(childNode.getFirstChild() != null)
							{
								siteCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("tran_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								tranId = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("item_code"))
						{
							if(childNode.getFirstChild() != null)
							{
								itemCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("quantity"))
						{
							if(childNode.getFirstChild() != null)
							{
								quantity = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("line_no"))
						{
							if(childNode.getFirstChild() != null)
							{
								lineNo = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("dcr_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								dcrId = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						
					}
				}
				
				if (currDetail != null && !updateStatus.equalsIgnoreCase("A") && !updateStatus.equalsIgnoreCase("N")) //&& !updateStatus.equalsIgnoreCase("N") CONDITION ADDED BY NANDKUMAR GADKARI ON 10/01/18
				{					
					itemCode	= genericUtility.getColumnValueFromNode("item_code",currDetail);
					locCode		= genericUtility.getColumnValueFromNode("loc_code",currDetail);
					lotNo		= genericUtility.getColumnValueFromNode("lot_no",currDetail);
					lotSl		= genericUtility.getColumnValueFromNode("lot_sl",currDetail);
					quantity	= genericUtility.getColumnValueFromNode("quantity",currDetail);
					lineNo		= genericUtility.getColumnValueFromNode("line_no",currDetail);
					
					if (updateStatus.equalsIgnoreCase("E") || updateStatus.equalsIgnoreCase("D"))
					{
						sql = "select item_code, quantity from strg_meet_invoice WHERE TRAN_ID = ? AND LINE_NO = ?";						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,dcrId);
						pstmt.setString(2,lineNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							itemCode	= checkNull(rs.getString("item_code"));
							locCode		= rs.getString("LOC_CODE");
							lotNo		= rs.getString("LOT_NO"); 
							lotSl		= rs.getString("LOT_SL");
							quantity	= checkNull(rs.getString("quantity"));
						}
						if (rs != null)
						{
							rs.close();
							rs = null ;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null ;
						}
						
					}
					BaseLogger.log("3", getUserInfo(), null,  "lineNo :"+lineNo+" itemCode :"+itemCode+" locCode :"+locCode+" lotNo :"+lotNo+" lotSl :"+lotSl+" quantity :"+quantity); //Gulzar 15/05/07
					allocQty = -1 * Double.parseDouble(quantity);
					
					BaseLogger.log("3", getUserInfo(), null,  "lineNo: "+lineNo);
					line = "    " + lineNo;
					hashMap.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
					hashMap.put("ref_ser",tranSer);
					hashMap.put("ref_id", tranId);
					hashMap.put("ref_line", line.substring(line.length()-4));
					hashMap.put("item_code", itemCode);
					hashMap.put("site_code", siteCode);
					hashMap.put("loc_code","FRSH");
					hashMap.put("lot_no"," ");
					hashMap.put("lot_sl"," ");
					hashMap.put("alloc_qty", new Double(allocQty));
					hashMap.put("chg_win","w_strg_meet_dcr_realtime_wiz");
					
					hashMap.put("chg_user", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
					hashMap.put("chg_term", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

					BaseLogger.log("3", getUserInfo(), null,  "Calling DistStkUpdEJB.....");
					distStkUpd = new DistStkUpd();
					if (distStkUpd.updAllocTrace(hashMap, conn) > 0)
					{
						distStkUpd= null;
						BaseLogger.log("3", getUserInfo(), null,  "distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
					}
				}
			}*/
			
			String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom, "1"));
			String tranID = checkNull(genericUtility.getColumnValue("tran_id", dom, "1"));
			
			System.out.println("preSave >> updAllocTrace >> strgCode =["+strgCode+"], tranID=["+tranID+"]");
			
			String siteSql="SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
			pstmt = conn.prepareStatement(siteSql);
			pstmt.setString(1,userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				loginSite=checkNull(rs.getString("EMP_SITE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null ;
			}
			sql = "select item_code, quantity,line_no, TRAN_ID from strg_meet_invoice WHERE DCR_ID "
					+ "IN (SELECT DCR_ID FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?) AND TRAN_ID = ? AND STRG_CODE = ? AND QUANTITY > 0 ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(3,tranID);
			pstmt.setString(4,strgCode);
			//pstmt.setString(2,lineNo);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				itemCode	= checkNull(rs.getString("item_code"));
				/*locCode		= rs.getString("LOC_CODE");
				lotNo		= rs.getString("LOT_NO"); 
				lotSl		= rs.getString("LOT_SL");*/
				quantity	= checkNull(rs.getString("quantity"));
				lineNo	= checkNull(rs.getString("line_no"));
				tranId	= checkNull(rs.getString("TRAN_ID"));
				if(quantity==null || quantity.trim().length()==0)
				{
					quantity="0";
				}
				
				String stockSql="SELECT LOT_NO,LOT_SL FROM STOCK WHERE SITE_CODE= ? AND ITEM_CODE= ? AND LOC_CODE = ?";
				pstmt1 = conn.prepareStatement(stockSql);
				pstmt1.setString(1,loginSite);
				pstmt1.setString(2,itemCode);
				pstmt1.setString(3,salesPers);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					lotNo=rs1.getString("LOT_NO");
					lotSl=rs1.getString("LOT_SL");
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null ;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null ;
				}
				if(lotNo.trim().length() == 0)
				{
					lotNo=" ";
				}
				if(lotSl.trim().length() == 0)
				{
					lotSl=" ";
				}	
				
				BaseLogger.log("3", getUserInfo(), null,  "lineNo :"+lineNo+" itemCode :"+itemCode+" locCode :"+locCode+" lotNo :"+lotNo+" lotSl :"+lotSl+" quantity :"+quantity); //Gulzar 15/05/07
				allocQty = -1 * Double.parseDouble(quantity);
				
				BaseLogger.log("3", getUserInfo(), null,  "lineNo: "+lineNo);
				line = "    " + lineNo;
				hashMap.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
				hashMap.put("ref_ser",tranSer);
				hashMap.put("ref_id", tranId);
				hashMap.put("ref_line", line.substring(line.length()-4));
				hashMap.put("item_code", itemCode);
				hashMap.put("site_code", loginSite);
				hashMap.put("loc_code",salesPers.trim());
				hashMap.put("lot_no",lotNo);
				hashMap.put("lot_sl",lotSl);
				hashMap.put("alloc_qty", new Double(allocQty));
				hashMap.put("chg_win","w_strg_meet_dcr_realtime_wiz");
				
				hashMap.put("chg_user", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
				hashMap.put("chg_term", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

				BaseLogger.log("3", getUserInfo(), null,  "Calling DistStkUpdEJB.....");
				System.out.println("hashMap ==========="+hashMap);
				distStkUpd = new DistStkUpd();
				if (distStkUpd.updAllocTrace(hashMap, conn) > 0)
				{
					distStkUpd= null;
					BaseLogger.log("3", getUserInfo(), null,  "distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
				}
				
			}
			if (rs != null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null ;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return "";
	}
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
	public String updAllocTrace1(Document dom,String salesPers,String dcrDate, String xtraParams,String userId, Connection conn) throws ITMException
	{
		System.out.println("userId ======="+userId);
		HashMap hashMap = new HashMap(); 
		String errCode = "", errString = "";
		String lineNo = "";
		String dcrId = "";
		String tranSer = "S-DISS";
		String line = "";
		String siteCode = "", itemCode = "", quantity = "", locCode = "", lotNo = "", lotSl = "";
		double allocQty = 0d;
		int cnt = 0;
		DistStkUpd distStkUpd = null; // for ejb3 
		String updateStatus = "",tranId = "";
		NodeList hdrDom = null;
		ResultSet rs = null; 
		PreparedStatement pstmt = null;
		String sql = "";
		String updateFlag="";
		String formNo="";
		String isBroken="",brokenQty="",loadQty="",breakItemRef="",stockBreak="",currStock="",sales_pers="",unit="",childUnit="",PkgSize="";
		double qty = 0.0, rate = 0.0, amt = 0.0, conv = 0, convqty = 0, convrate = 0,ingralQy=0;
		StringBuffer valuevaluevalueXmlString = new StringBuffer();
		String retStr="";
		boolean isConn= false;
		try
		{
			RcpBackflushConfirm rcpBackflushConfirm=new RcpBackflushConfirm();
			String loginCode=checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
			userId      = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
			CommonDBAccessRemote dbAccessRemote = new CommonDBAccessEJB();
			UserInfoBean userInfo = dbAccessRemote.createUserInfo(loginCode);
			XML2DBEJB xml2DBLocal = new XML2DBEJB();
			
			String loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");
			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;
			
			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('invoice') ";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}
			
			String siteSql="SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
			pstmt = conn.prepareStatement(siteSql);
			pstmt.setString(1,userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				loginSite=checkNull(rs.getString("EMP_SITE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null ;
			}
			System.out.println("formNo ====="+formNo);
			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				System.out.println("inside first form loop");

				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();
				String selectedRecords = checkNull(currDetail.getAttributes().getNamedItem("selected").getNodeValue());

				System.out.println("selectedRecords ::=="+selectedRecords);

				if(selectedRecords.trim().equalsIgnoreCase("Y"))
				{
					for ( int i=0; i< currDetailListLength; i++ )
					{

						System.out.println("inside second form loop");

						Node childNode = currDetailList.item(i);
						String childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName :: ["+childNodeName+"]");
						//if(childNodeName.equalsIgnoreCase("attribute"))
						//{
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}							
						else if (childNodeName.equalsIgnoreCase("site_code"))
						{
							if(childNode.getFirstChild() != null)
							{
								siteCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}

						else if (childNodeName.equalsIgnoreCase("tran_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								tranId = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("item_code"))
						{
							if(childNode.getFirstChild() != null)
							{
								itemCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("quantity"))
						{
							if(childNode.getFirstChild() != null)
							{
								quantity = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("line_no"))
						{
							if(childNode.getFirstChild() != null)
							{
								lineNo = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("dcr_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								dcrId = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("curr_stock"))
						{
							if(childNode.getFirstChild() != null)
							{
								currStock = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("is_broken"))
						{
							if(childNode.getFirstChild() != null)
							{
								isBroken = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("load_qty"))
						{
							if(childNode.getFirstChild() != null)
							{
								loadQty = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("stock_break"))
						{
							if(childNode.getFirstChild() != null)
							{
								stockBreak = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("broken_qty"))
						{
							if(childNode.getFirstChild() != null)
							{
								brokenQty = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("break_item__ref"))
						{
							if(childNode.getFirstChild() != null)
							{
								breakItemRef = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if(childNode.getFirstChild() != null)
							{
								salesPers = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						/*else if (childNodeName.equalsIgnoreCase("broken_qty"))
							{
								if(childNode.getFirstChild() != null)
								{
									dcrId = childNode.getFirstChild().getNodeValue().trim();
								}
							}*/



					}
					System.out.println("itemCode ::"+itemCode);
					System.out.println("salesPers ::"+salesPers);
					System.out.println("itemCode ::"+itemCode);
					System.out.println("dcrId ::"+dcrId);
					System.out.println("lineNo ::"+lineNo);
					System.out.println("quantity ::"+quantity);
					System.out.println("breakItemRef ::"+breakItemRef);
					System.out.println("brokenQty ::"+brokenQty);
					System.out.println("stockBreak ::"+stockBreak);
					System.out.println("isBroken ::"+isBroken);
					System.out.println("loadQty ::"+loadQty);
					System.out.println("siteCode ::"+siteCode);
					System.out.println("updateFlag ::"+updateFlag);
					
					String stockSql="SELECT LOT_NO,LOT_SL FROM STOCK WHERE SITE_CODE= ? AND ITEM_CODE= ? AND LOC_CODE = ?";
					pstmt = conn.prepareStatement(stockSql);
					pstmt.setString(1,loginSite);
					pstmt.setString(2,itemCode);
					pstmt.setString(3,salesPers);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lotNo=rs.getString("LOT_NO");
						lotSl=rs.getString("LOT_SL");
					}
					if (rs != null)
					{
						rs.close();
						rs = null ;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null ;
					}
					if(lotNo.trim().length() == 0)
					{
						lotNo=" ";
					}
					if(lotSl.trim().length() == 0)
					{
						lotSl=" ";
					}	
					
					if(quantity==null || quantity.trim().length()==0)
					{
						quantity="0";
					}
					BaseLogger.log("3", getUserInfo(), null,  "lineNo :"+lineNo+" itemCode :"+itemCode+" locCode :"+locCode+" lotNo :"+lotNo+" lotSl :"+lotSl+" quantity :"+quantity); //Gulzar 15/05/07
					allocQty = -1 * Double.parseDouble(quantity);
					
					BaseLogger.log("3", getUserInfo(), null,  "lineNo: "+lineNo);
					line = "    " + lineNo;
					hashMap.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
					hashMap.put("ref_ser",tranSer);
					hashMap.put("ref_id", tranId);
					hashMap.put("ref_line", line.substring(line.length()-4));
					hashMap.put("item_code", itemCode);
					hashMap.put("site_code", loginSite);
					hashMap.put("loc_code",userId);
					hashMap.put("lot_no",lotNo);
					hashMap.put("lot_sl",lotSl);
					hashMap.put("alloc_qty", new Double(allocQty));
					hashMap.put("chg_win","w_strg_meet_dcr_realtime_wiz");
					
					hashMap.put("chg_user", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
					hashMap.put("chg_term", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

					BaseLogger.log("3", getUserInfo(), null,  "Calling DistStkUpdEJB.....");
					System.out.println("hashMap ==========="+hashMap);
					distStkUpd = new DistStkUpd();
					if (distStkUpd.updAllocTrace(hashMap, conn) > 0)
					{
						distStkUpd= null;
						BaseLogger.log("3", getUserInfo(), null,  "distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
					}
					
					
					
				}
			}
			
			sql = "select item_code, quantity,line_no, TRAN_ID from strg_meet_invoice WHERE DCR_ID "
					+ "IN (SELECT DCR_ID FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			//pstmt.setString(2,lineNo);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				itemCode	= checkNull(rs.getString("item_code"));
				/*locCode		= rs.getString("LOC_CODE");
				lotNo		= rs.getString("LOT_NO"); 
				lotSl		= rs.getString("LOT_SL");*/
				quantity	= checkNull(rs.getString("quantity"));
				lineNo	= checkNull(rs.getString("line_no"));
				tranId	= checkNull(rs.getString("TRAN_ID"));
				if(quantity==null || quantity.trim().length()==0)
				{
					quantity="0";
				}
				BaseLogger.log("3", getUserInfo(), null,  "lineNo :"+lineNo+" itemCode :"+itemCode+" locCode :"+locCode+" lotNo :"+lotNo+" lotSl :"+lotSl+" quantity :"+quantity); //Gulzar 15/05/07
				allocQty = -1 * Double.parseDouble(quantity);
				
				BaseLogger.log("3", getUserInfo(), null,  "lineNo: "+lineNo);
				line = "    " + lineNo;
				hashMap.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
				hashMap.put("ref_ser",tranSer);
				hashMap.put("ref_id", tranId);
				hashMap.put("ref_line", line.substring(line.length()-4));
				hashMap.put("item_code", itemCode);
				hashMap.put("site_code", loginSite);
				hashMap.put("loc_code",userId);
				hashMap.put("lot_no"," ");
				hashMap.put("lot_sl"," ");
				hashMap.put("alloc_qty", new Double(allocQty));
				hashMap.put("chg_win","w_strg_meet_dcr_realtime_wiz");
				
				hashMap.put("chg_user", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
				hashMap.put("chg_term", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

				BaseLogger.log("3", getUserInfo(), null,  "Calling DistStkUpdEJB.....");
				System.out.println("hashMap ==========="+hashMap);
				distStkUpd = new DistStkUpd();
				if (distStkUpd.updAllocTrace(hashMap, conn) > 0)
				{
					distStkUpd= null;
					BaseLogger.log("3", getUserInfo(), null,  "distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
				}
				
			}
			if (rs != null)
			{
				rs.close();
				rs = null ;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null ;
			}

		}
		catch (Exception e)
		{
			// TODO: handle exception

			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return retStr;
	}
	public String getReceiptBackflush(Document dom,String salesPers,String dcrDate, String xtraParams,String userId, Connection conn) throws ITMException
	{
		System.out.println("userId ======="+userId);
		System.out.println("INSIDE getReceiptBackflush METHOD ..!");
		HashMap hashMap = new HashMap(); 
		String errCode = "", errString = "";
		String lineNo = "";
		String dcrId = "";
		String tranSer = "S-DISS";
		String line = "";
		String siteCode = "", itemCode = "", quantity = "", locCode = "", lotNo = "", lotSl = "";
		double allocQty = 0d;
		int cnt = 0;
		DistStkUpd distStkUpd = null; // for ejb3 
		String updateStatus = "",tranId = "";
		NodeList hdrDom = null;
		ResultSet rs = null; 
		PreparedStatement pstmt = null;
		String sql = "";
		String updateFlag="";
		String formNo="";
		String loadQty="",currStock="",sales_pers="",unit="",childUnit="",PkgSize="";
		double qty = 0.0, rate = 0.0, amt = 0.0, conv = 0, convqty = 0, convrate = 0,ingralQy=0;		
		String retStr="";
		boolean isConn= false;
		String chieldLotNo = "", chieldLotSl = "";
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null; 
		try
		{
			RcpBackflushConfirm rcpBackflushConfirm=new RcpBackflushConfirm();
			ReceiptBackflushWizConfirm receiptBackflushWizConfirm=new ReceiptBackflushWizConfirm();
			String loginCode=checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
			userId      = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
			CommonDBAccessRemote dbAccessRemote = new CommonDBAccessEJB();
			UserInfoBean userInfo = dbAccessRemote.createUserInfo(loginCode);
			XML2DBEJB xml2DBLocal = new XML2DBEJB();
			
			String loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");
			String objName = getObjNameFromDom( dom, "objName" , 1);
			String winName = "w_"+objName;
			
			String objFormSql= "SELECT FORM_NAME, FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN('invoice') ";
			PreparedStatement pstmtForm = conn.prepareStatement(objFormSql);
			pstmtForm.setString(1, winName);
			ResultSet rsForm = pstmtForm.executeQuery();
			while(rsForm.next())
			{
				formNo = checkNull(rsForm.getString("FORM_NO"));
			}
			if(rsForm != null)
			{
				rsForm.close();
				rsForm = null;
			}
			if(pstmtForm != null)
			{
				pstmtForm.close();
				pstmtForm = null;
			}
			System.out.println("formNo ====="+formNo);
			Node currDetail = null;
			NodeList detail8List = null;
			NodeList currDetailList = null;
			detail8List = dom.getElementsByTagName("Detail"+formNo);
			int detailListLength = detail8List.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				System.out.println("inside first form loop");

				currDetail = detail8List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				int currDetailListLength = currDetailList.getLength();
				String selectedRecords = checkNull(currDetail.getAttributes().getNamedItem("selected").getNodeValue());

				System.out.println("selectedRecords ::=="+selectedRecords);
				String isBroken="",brokenQty="",breakItemRef="",stockBreak="";

				if(selectedRecords.trim().equalsIgnoreCase("Y"))
				{
					for ( int i=0; i< currDetailListLength; i++ )
					{

						System.out.println("inside second form loop");

						Node childNode = currDetailList.item(i);
						String childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName :: ["+childNodeName+"]");
						//if(childNodeName.equalsIgnoreCase("attribute"))
						//{
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}							
						else if (childNodeName.equalsIgnoreCase("site_code"))
						{
							if(childNode.getFirstChild() != null)
							{
								siteCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}

						else if (childNodeName.equalsIgnoreCase("tran_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								tranId = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("item_code"))
						{
							if(childNode.getFirstChild() != null)
							{
								itemCode = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("quantity"))
						{
							if(childNode.getFirstChild() != null)
							{
								quantity = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("line_no"))
						{
							if(childNode.getFirstChild() != null)
							{
								lineNo = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("dcr_id"))
						{
							if(childNode.getFirstChild() != null)
							{
								dcrId = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("curr_stock"))
						{
							if(childNode.getFirstChild() != null)
							{
								currStock = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("is_broken"))
						{
							if(childNode.getFirstChild() != null)
							{
								isBroken = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("load_qty"))
						{
							if(childNode.getFirstChild() != null)
							{
								loadQty = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("stock_break"))
						{
							if(childNode.getFirstChild() != null)
							{
								stockBreak = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("broken_qty"))
						{
							if(childNode.getFirstChild() != null)
							{
								brokenQty = checkNull(childNode.getFirstChild().getNodeValue()).trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("break_item__ref"))
						{
							if(childNode.getFirstChild() != null)
							{
								breakItemRef = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if (childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if(childNode.getFirstChild() != null)
							{
								salesPers = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						/*else if (childNodeName.equalsIgnoreCase("broken_qty"))
							{
								if(childNode.getFirstChild() != null)
								{
									dcrId = childNode.getFirstChild().getNodeValue().trim();
								}
							}*/



					}
					System.out.println("brokenQty ::"+brokenQty);
					System.out.println("breakItemRef ::"+breakItemRef);
					if(brokenQty.trim().length() > 0)
					{
						StringBuffer valuevaluevalueXmlString = new StringBuffer();
						String Sql="SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
						pstmt=conn.prepareStatement(Sql);
						pstmt.setString(1,salesPers);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							siteCode=checkNull(rs.getString("EMP_SITE"));
						}
						if (rs != null)
						{
							rs.close();
							rs = null ;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null ;
						}

						String Sql1="SELECT UNIT, PKG_SIZE FROM ITEM WHERE ITEM_CODE = ?";
						pstmt=conn.prepareStatement(Sql1);
						pstmt.setString(1,breakItemRef);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							unit=checkNull(rs.getString("UNIT"));
							PkgSize=checkNull(rs.getString("PKG_SIZE"));
						}
						if (rs != null)
						{
							rs.close();
							rs = null ;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null ;
						}

						String sql2 = " select unit from item where item_code = ? ";
						pstmt = conn.prepareStatement(sql2);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							childUnit = rs.getString("unit");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						String stockSql="SELECT LOT_NO,LOT_SL FROM STOCK WHERE SITE_CODE= ? AND ITEM_CODE= ? AND LOC_CODE = ?";
						pstmt1 = conn.prepareStatement(stockSql);
						pstmt1.setString(1,siteCode);
						pstmt1.setString(2,breakItemRef);
						pstmt1.setString(3,salesPers);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							lotNo=rs1.getString("LOT_NO");
							lotSl=rs1.getString("LOT_SL");
						}
						if (rs1 != null)
						{
							rs1.close();
							rs1 = null ;
						}
						if (pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null ;
						}
						
						
						String stockSql1="SELECT LOT_NO,LOT_SL FROM STOCK WHERE SITE_CODE= ? AND ITEM_CODE= ? AND LOC_CODE = ?";
						pstmt1 = conn.prepareStatement(stockSql1);
						pstmt1.setString(1,siteCode);
						pstmt1.setString(2,itemCode);
						pstmt1.setString(3,salesPers);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							chieldLotNo=rs1.getString("LOT_NO");
							chieldLotSl=rs1.getString("LOT_SL");
						}
						else
						{
							chieldLotNo=lotNo;
							chieldLotSl=lotSl;
						}
						if (rs1 != null)
						{
							rs1.close();
							rs1 = null ;
						}
						if (pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null ;
						}
						if(lotNo.trim().length() == 0)
						{
							lotNo=" ";
						}
						if(lotSl.trim().length() == 0)
						{
							lotSl=" ";
						}						
						if(chieldLotNo.trim().length() == 0)
						{
							chieldLotNo=" ";
						}						
						if(chieldLotSl.trim().length() == 0)
						{
							chieldLotSl=" ";
						}
						
						

						double noArt=0;
						sql = " select no_art from stock " + " where item_code = ? " + " and site_code = ? "
								+ " and loc_code  = ? " + " and lot_no = ? " + " and lot_sl = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, itemCode);
						pstmt.setString(2, siteCode);
						pstmt.setString(3, locCode);
						pstmt.setString(4, lotNo);
						pstmt.setString(5, lotSl);

						rs = pstmt.executeQuery();
						if (rs.next()) {
							noArt = rs.getDouble("no_art");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						int currStockQty=0;
						String PkgSizeSql="select QUANTITY from stock where item_code = ? and site_code = ? and loc_code = ?" + 
								"and lot_no = ? and lot_sl = ?";
						pstmt=conn.prepareStatement(PkgSizeSql);
						pstmt.setString(1,itemCode);
						pstmt.setString(2,siteCode);
						pstmt.setString(3,salesPers);
						pstmt.setString(4, lotNo);
						pstmt.setString(5, lotSl);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							currStockQty=rs.getInt("QUANTITY");
						}
						if (rs != null)
						{
							rs.close();
							rs = null ;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null ;
						}

						if(noArt == 0)
						{
							noArt = 1;
						}

						int PkgSizeNum=0;
						if(PkgSize != null )
						{
							PkgSizeNum=Integer.parseInt(PkgSize);
						}
						int childQty=0;
						int parentQty=1;
						
						if(brokenQty != null )
						{
							childQty=Integer.parseInt(brokenQty);
						}
						/*if(childQty != 0)
						{
							childQty=childQty-currStockQty;
							parentQty=childQty/PkgSizeNum;
						}*/
						 System.out.println("childQty.toString() =="+childQty);
						 System.out.println("parentQty.toString() =="+parentQty);
						 System.out.println("lotNo.toString() =="+lotNo);
						 System.out.println("lotSl.toString() =="+lotSl);
						 System.out.println("chieldLotNo.toString() =="+chieldLotNo);
						 System.out.println("chieldLotSl.toString() =="+chieldLotSl);

						//valuevaluevalueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
						//valuevaluevalueXmlString.append(updateFlag).append("</editFlag> </header>");
						
						
						/*valuevaluevalueXmlString.append("<Root>\r\n");
						valuevaluevalueXmlString.append("<Header0>\r\n");
						valuevaluevalueXmlString.append("<objName><![CDATA[receipt_backflush]]></objName>\r\n");
						valuevaluevalueXmlString.append("<pageContext><![CDATA[1]]></pageContext>\r\n");
						valuevaluevalueXmlString.append("<editFlag><![CDATA[A]]></editFlag>\r\n");
						valuevaluevalueXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>\r\n");
						valuevaluevalueXmlString.append("<action><![CDATA[SAVE]]></action>\r\n");
						valuevaluevalueXmlString.append("<elementName><![CDATA[]]></elementName>\r\n");
						valuevaluevalueXmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>\r\n");
						valuevaluevalueXmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>\r\n");
						valuevaluevalueXmlString.append("<objContext><![CDATA[1]]></objContext>\r\n");
						valuevaluevalueXmlString.append("<forcedSave><![CDATA[true]]></forcedSave>\r\n");
						valuevaluevalueXmlString.append("<keyValue><![CDATA[1]]></keyValue>\r\n");
						valuevaluevalueXmlString.append("<pkValues><![CDATA[]]></pkValues>\r\n");
						valuevaluevalueXmlString.append("<description>Header0 members</description>\r\n");
						valuevaluevalueXmlString.append("</Header0>\r\n");
						valuevaluevalueXmlString.append("<description>Header0 members</description>\r\n");
						valuevaluevalueXmlString.append("<Detail1 objContext=\"1\" objName=\"receipt_backflush\" domID=\"1\" dbID=\"\" selected=\"Y\">\r\n");
						valuevaluevalueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					*/
						
						valuevaluevalueXmlString.append("<?xml version=\"1.0\" encoding='UTF-8'?><DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><description>Header0 members</description>");
						valuevaluevalueXmlString.append("<Detail1 dbID='' domID='1' objContext='1' objName='strg_customer'>");
						valuevaluevalueXmlString.append("<attribute pkNames='' selected='N' status='N' updateFlag='A'/>");
					
						
						
						
						valuevaluevalueXmlString.append("<tran_id ><![CDATA[" + ""+ "]]></tran_id>");
						valuevaluevalueXmlString.append("<tran_date ><![CDATA[" + dcrDate+ "]]></tran_date>");
						valuevaluevalueXmlString.append("<tran_type>").append("<![CDATA[" + "J" + "]]>").append("</tran_type>");
						valuevaluevalueXmlString.append("<backflush_type>").append("<![CDATA[" + "J" + "]]>").append("</backflush_type>");
							valuevaluevalueXmlString.append("<item_code>").append("<![CDATA[" + itemCode + "]]>").append("</item_code>");
						valuevaluevalueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");

						valuevaluevalueXmlString.append("<quantity>").append("<![CDATA[" + childQty + "]]>").append("</quantity>");
						valuevaluevalueXmlString.append("<no_art>").append("<![CDATA[" + noArt + "]]>").append("</no_art>");
						valuevaluevalueXmlString.append("<item_ser>").append("<![CDATA[" + "FG" + "]]>").append("</item_ser>");

						valuevaluevalueXmlString.append("<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
						//valuevaluevalueXmlString.append("<site_code__mfg>").append("<![CDATA[" + loginSite + "]]>").append("</site_code__mfg>");

						valuevaluevalueXmlString.append("<lot_sl>").append("<![CDATA[" +chieldLotSl+ "]]>").append("</lot_sl>");
						valuevaluevalueXmlString.append("<lot_no>").append("<![CDATA[" + chieldLotNo + "]]>").append("</lot_no>");
						valuevaluevalueXmlString.append("<loc_code>").append("<![CDATA[" + salesPers + "]]>").append("</loc_code>");

						//valuevaluevalueXmlString.append("<pack_code>").append("<![CDATA[" + "DUMMY" + "]]>").append("</pack_code>");
						//valuevaluevalueXmlString.append("<proj_code>").append("<![CDATA[" + "BASSDC001 " + "]]>").append("</proj_code>");
						valuevaluevalueXmlString.append("<gross_weight>").append("<![CDATA[" + "0" + "]]>").append("</gross_weight>");
						valuevaluevalueXmlString.append("<tare_weight>").append("<![CDATA[" + "0" + "]]>").append("</tare_weight>");
						valuevaluevalueXmlString.append("<net_weight>").append("<![CDATA[" + "0" + "]]>").append("</net_weight>");
						valuevaluevalueXmlString.append("<mfg_date>").append("<![CDATA[" + dcrDate + "]]>").append("</mfg_date>");
						valuevaluevalueXmlString.append("<grade>").append("<![CDATA[" + "   " + "]]>").append("</grade>");
						valuevaluevalueXmlString.append("<acct_code__conv_gl>").append("<![CDATA[" + "13400016" + "]]>").append("</acct_code__conv_gl>");
						valuevaluevalueXmlString.append("<qc_reqd>").append("<![CDATA[" + "N" + "]]>").append("</qc_reqd>");

						valuevaluevalueXmlString.append("</Detail1>");
						
						/*valuevaluevalueXmlString.append("<Detail2 objContext=\"1\" objName=\"receipt_backflush\" domID=\"1\" dbID=\"\" selected=\"Y\">\r\n");
						valuevaluevalueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					
						*/
						valuevaluevalueXmlString.append("<Detail2 dbID='' domID='1' objContext='1' objName='strg_customer'>");
						valuevaluevalueXmlString.append("<attribute pkNames='' selected='N' status='N' updateFlag='A'/>");
						
						valuevaluevalueXmlString.append("<tran_id ><![CDATA[" + ""+ "]]></tran_id>");
						valuevaluevalueXmlString.append("<line_no ><![CDATA[" + "1"+ "]]></line_no>");
						valuevaluevalueXmlString.append("<item_code>").append("<![CDATA[" + breakItemRef + "]]>").append("</item_code>");
						valuevaluevalueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");

						valuevaluevalueXmlString.append("<quantity>").append("<![CDATA[" + parentQty + "]]>").append("</quantity>");
						//valuevaluevalueXmlString.append("<no_art>").append("<![CDATA[" + parentQty + "]]>").append("</no_art>");
					
						valuevaluevalueXmlString.append("<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");

						//	valuevaluevalueXmlString.append("<amount>").append("<![CDATA[" + 0 + "]]>").append("</amount>");
						/*valuevaluevalueXmlString.append("<rate>").append("<![CDATA[" + 0 + "]]>").append("</rate>");
						valuevaluevalueXmlString.append("<tax_amt>").append("<![CDATA[" + 0 + "]]>").append("</tax_amt>");
						valuevaluevalueXmlString.append("<discount>").append("<![CDATA[" + 0 + "]]>").append("</discount>");
						valuevaluevalueXmlString.append("<net_amt>").append("<![CDATA[" + 0 + "]]>").append("</net_amt>");
					*/	valuevaluevalueXmlString.append("<lot_sl>").append("<![CDATA[" + lotSl + "]]>").append("</lot_sl>");
						valuevaluevalueXmlString.append("<lot_no>").append("<![CDATA[" + lotNo + "]]>").append("</lot_no>");
						valuevaluevalueXmlString.append("<loc_code>").append("<![CDATA[" + salesPers + "]]>").append("</loc_code>");

						//valuevaluevalueXmlString.append("<unit__doc>").append("<![CDATA[" + childUnit + "]]>").append("</unit__doc>");
						//valuevaluevalueXmlString.append("<rate  protect = \"1\"><![CDATA[" + rate + "]]></rate>");
						valuevaluevalueXmlString.append("</Detail2>");
						//valuevaluevalueXmlString.append("</Root>");
						valuevaluevalueXmlString.append("</Header0></group0></DocumentRoot>");
						
						
						System.out.println("valuevaluevalueXmlString.toString() =="+valuevaluevalueXmlString.toString());

						String receiptTranId = xml2DBLocal.saveXML2DB("R-BFS", valuevaluevalueXmlString.toString(), "receipt_backflush", "A", 2, true, salesPers, "", false, xtraParams, null, "0", false, "0", null, "", "P000000032", false, conn, false,userInfo );
						System.out.println("receiptTranId == ::"+receiptTranId);
						//retStr=callProcessRequest( valuevaluevalueXmlString.toString(), conn );
					//System.out.println("retStr====.toString() =="+retStr);
					
					   String confirmed =receiptBackflushWizConfirm.confirmRcpBackflush(receiptTranId,xtraParams, "A",conn,isConn);
					   System.out.println("confirm.toString() =="+confirmed);
					   if(confirmed.trim().length() > 0 && ! confirmed.contains("<type>P</type>"))
					   {
						   retStr=confirmed;
						   //detail3Varified = false;
						  // retStr = itmDBAccessLocal.getErrorString( "", "VPINVDSTMD", userId );
						  return retStr;
					   }
					   System.out.println("AFTER CONFIRM CALLLLLLLLLLL");
					   
						
					}
				}
			}

		}
		catch (Exception e)
		{
			// TODO: handle exception

			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			System.out.println("FINALLY BLOCK FOR RECEUPT_BACKFLUSH UPDATE");
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return retStr;
	}
	private String callProcessRequest( String xmlString, Connection conn ) throws ITMException
	{
		String retStr = "";
		try 
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext( appConnect.getProperty() );
			MasterStatefulLocal masterStateful = ( MasterStatefulLocal )ctx.lookup( "ibase/MasterStatefulEJB/local" );
			retStr = masterStateful.processRequest( getUserInfo(), xmlString.toString(), false, conn );
			System.out.println("retStr ==========@@@@@@@ "+retStr);
			masterStateful.remove();
			masterStateful = null;
		}
		catch (RemoteException e) 
		{
			throw new ITMException(e);
		}
		catch (ITMException e) 
		{
			throw e;
		}
		catch (NamingException e) 
		{
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return retStr;
	}
}
