/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.utility.XMLtoJSONConverter;
import ibase.webitm.bean.TemplateDetails;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class APISampleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    UserInfoBean userInfoGlobal = new UserInfoBean();
    E12GenericUtility genericUtility = new E12GenericUtility();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Inside doGet method :: APISampleServlet Ankushs");
        this.genericUtility = new E12GenericUtility();
        String action = request.getParameter("action");
        BaseLogger.log("3", null, null, "action with file Type: APISample.jsp => ANKUSHS[ " + action + " ] ");
        BaseLogger.log("3", null, null, "Calling Ankushs");
        if (action != null && action.equals("downloadSampleData")) {
            BaseLogger.log("3", null, null, "action: APISample.jsp => [ " + action + " ] ");
            String result = "";
            String objName = request.getParameter("objName");
            String fileType = request.getParameter("fileType");
            String refId = request.getParameter("reffId");
            BaseLogger.log("3", null, null, "refId: APISample.jsp => [ " + refId + " ] ");
            BaseLogger.log("3", null, null, "fileType: APISample.jsp ==> [ " + fileType + " ] ");
            BaseLogger.log("3", null, null, "userInfoGlobal.getLoginCode(): APISample.jsp => [ " + this.userInfoGlobal.getLoginCode() + " ] ");
            if (fileType != null && fileType.equalsIgnoreCase("xml")) {
                result = this.downloadSampleDataXML(objName, refId, request, response);
            } else if (fileType != null && fileType.equalsIgnoreCase("json")) {
                result = this.downloadJSONSampleData(objName, refId, request, response);
                BaseLogger.log("3", null, null, "JSON Data: APISample.jsp ==> [ " + result + " ] ");
            } else if (fileType != null && fileType.equalsIgnoreCase("xmlWithAttrib")) {
                result = this.downloadSampleDataWithAttributes(objName, refId, request, response);
                BaseLogger.log("3", null, null, "XML Data with Attribute: APISample.jsp ==> [ " + result + " ] ");
            }
            BaseLogger.log("3", null, null, "result: APISample.jsp => [ " + result + " ] ");
            return;
        }
        String userCode = request.getParameter("userCode");
        BaseLogger.log("3", null, null, "userCode in APISampleCode from APISampleServlet : [" + userCode + "]");
        String appId = request.getParameter("appId");
        BaseLogger.log("3", null, null, "appId in APISampleCode from APISampleServlet : [" + appId + "]");
        Map<Object, Object> endpoint_objectMap = new HashMap();
        endpoint_objectMap = this.APISampleDropDown(userCode, appId);
        BaseLogger.log("3", null, null, "endpoint_objectMaps: APISample.jssp => [ " + endpoint_objectMap + " ] ");
        PrintWriter out = response.getWriter();
        JSONObject endpointObjectJSON = new JSONObject(endpoint_objectMap);
        response.setContentType("application/json");
        out.print(endpointObjectJSON);
        BaseLogger.log("3", null, null, "endpointObjectJSON: APISample.jsp => [ " + endpointObjectJSON + " ] ");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        super.service(arg0, arg1);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    public Map<String, List<String>> APISampleDropDown(String userCode, String appId) {
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        HashMap<String, List<String>> endpoint_objectMap = new HashMap<String, List<String>>();
        try {
            UserInfoBean userInfo;
            this.userInfoGlobal = userInfo = commonDBAccessEJB.createUserInfo(userCode);
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            ConnDriver connDriver = new ConnDriver();
            String sqlEndpointandObjectList = "SELECT ENDPOINT, OBJ_NAME FROM AUTH_APPS_API WHERE APP_ID = ?";
            try {
                try {
                    if (userInfo != null) {
                        BaseLogger.log("3", null, null, "userInfo: APISample.jsp => [ " + userInfo + " ] ");
                    }
                    conn = connDriver.getConnectDB(userInfo);
                    pstmt = conn.prepareStatement(sqlEndpointandObjectList);
                    pstmt.setString(1, appId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (endpoint_objectMap.containsKey(rs.getString("OBJ_NAME"))) {
                            ((List)endpoint_objectMap.get(rs.getString("OBJ_NAME"))).add(rs.getString("ENDPOINT"));
                            continue;
                        }
                        ArrayList<String> endpointList = new ArrayList<String>();
                        endpointList.add(rs.getString("ENDPOINT"));
                        endpoint_objectMap.put(rs.getString("OBJ_NAME"), endpointList);
                    }
                    BaseLogger.log("3", null, null, "endpoint_objectMap: APISample.jsp => [ " + endpoint_objectMap + " ] ");
                }
                catch (SQLException e) {
                    throw new ibase.planner.utility.ITMException(e);
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return endpoint_objectMap;
    }

    public String downloadSampleDataWithAttributes(String objName, String refId, HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log("3", null, null, "Inside downloadSampleData() ");
        String result = "";
        Document valueDom = null;
        ArrayList<Node> domList = new ArrayList<Node>();
        ArrayList<NodeList> columnObjList = new ArrayList<NodeList>();
        ArrayList<NodeList> textObjList = new ArrayList<NodeList>();
        try {
            UploadFileEJB uploadFileEJB = new UploadFileEJB();
            result = this.getDetailXMLDomString(objName, "1", "V", refId, null);
            TreeMap<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, this.userInfoGlobal);
            int mapIndex = 1;
            while (mapIndex <= formDetailInfo.size()) {
                domList.add(this.getTableDefinitionaNode(objName, mapIndex));
                columnObjList.add(this.getColumnObjectNodeList(objName, mapIndex, "ColumnObject"));
                textObjList.add(this.getColumnObjectNodeList(objName, mapIndex, "TextObject"));
                ++mapIndex;
            }
            valueDom = this.convertStringToDocument(result);
            BaseLogger.log("3", this.userInfoGlobal, null, "DomList size=[" + domList.size() + "]");
            BaseLogger.log("3", this.userInfoGlobal, null, "columnObjList size=[" + columnObjList.size() + "]");
            BaseLogger.log("3", this.userInfoGlobal, null, "textObjList size=[" + textObjList.size() + "]");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        catch (ibase.planner.utility.ITMException e) {
            e.printStackTrace();
        }
        String resultXMLWithAttributes = this.getXMLWithAttribute(valueDom, domList, columnObjList, textObjList);
        BaseLogger.log("3", null, null, "result: downloadSampleData() = [ " + resultXMLWithAttributes + " ] ");
        byte[] byteArrray = resultXMLWithAttributes.getBytes();
        BaseLogger.log("3", null, null, "byteArrray: downloadSampleData() =[ " + Arrays.asList(new byte[][]{byteArrray}) + " ] ");
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "attachment;filename=SampleData.xml");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(byteArrray);
            BaseLogger.log("3", null, null, "Writting done to response ");
        }
        catch (IOException e) {
            BaseLogger.log("3", null, null, "catch: downloadSampleData() => [ " + e.getMessage() + " ] ");
            e.printStackTrace();
        }
        return resultXMLWithAttributes;
    }

    private String getXMLWithAttribute(Document valueDom, List<Node> nodeList, List<NodeList> columnObjList, List<NodeList> textObjList) {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root>");
        try {
            int detail = 0;
            while (detail < nodeList.size()) {
                NodeList detailNodeList = valueDom.getElementsByTagName("Detail" + (detail + 1));
                BaseLogger.log("3", null, null, "Detail Node Name =[ " + detailNodeList.getLength() + "]");
                String detailWithAttrib = this.getDetailAttributes(detailNodeList, nodeList.get(detail), columnObjList.get(detail), textObjList.get(detail));
                xml.append(detailWithAttrib);
                ++detail;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        xml.append("</Root>");
        BaseLogger.log("3", null, null, "xml stinrg with Attributes String if not size====> [ " + xml.toString());
        return xml.toString();
    }

    private String getDetailAttributes(NodeList detailNodeList, Node attribNode, NodeList colNodeList, NodeList textNodeList) {
        StringBuilder detailString = new StringBuilder("");
        BaseLogger.log("3", null, null, "AttribNode name => [ " + attribNode.getNodeName());
        BaseLogger.log("3", null, null, "Detail Node List size => [ " + detailNodeList.getLength());
        BaseLogger.log("3", null, null, "col Node List size => [ " + colNodeList.getLength());
        BaseLogger.log("3", null, null, "text Node List size => [ " + textNodeList.getLength());
        try {
            int detailIndex = 0;
            while (detailIndex < detailNodeList.getLength()) {
                String pkName = "";
                Node detailNode = detailNodeList.item(detailIndex);
                detailString.append("<" + detailNode.getNodeName());
                detailString.append(" objName=\"" + detailNode.getAttributes().getNamedItem("objName").getNodeValue() + "\"");
                NodeList detailChailds = detailNode.getChildNodes();
                int childIndex = 0;
                while (childIndex < detailChailds.getLength()) {
                    Node childNode = detailChailds.item(childIndex);
                    String columnWithAttribute = "";
                    String isRequired = "";
                    if (!childNode.getNodeName().contains("#")) {
                        BaseLogger.log("3", null, null, "child node to check=======>" + childNode.getNodeName());
                        if (childNode.getNodeName().equalsIgnoreCase("attribute")) {
                            columnWithAttribute = String.valueOf(columnWithAttribute) + "<" + childNode.getNodeName() + " " + childNode.getAttributes().getNamedItem("pkNames") + " " + childNode.getAttributes().getNamedItem("selected") + " " + childNode.getAttributes().getNamedItem("status") + " " + childNode.getAttributes().getNamedItem("updateFlag") + " />";
                            pkName = childNode.getAttributes().getNamedItem("pkNames").toString();
                            detailString.append(" " + pkName + " ");
                            detailString.append(">");
                        } else {
                            columnWithAttribute = "<" + childNode.getNodeName() + " " + this.getLabelName(childNode.getNodeName(), textNodeList);
                            if ((columnWithAttribute = String.valueOf(columnWithAttribute) + this.getColumnAttributes(attribNode, childNode.getNodeName())).length() != 0) {
                                isRequired = this.getIsRequired(childNode.getNodeName(), colNodeList);
                                columnWithAttribute = isRequired.equalsIgnoreCase("Yes") ? String.valueOf(columnWithAttribute) + " required=\"" + isRequired + "\">" : String.valueOf(columnWithAttribute) + ">";
                                columnWithAttribute = String.valueOf(columnWithAttribute) + "<![CDATA[" + childNode.getTextContent() + "]]></" + childNode.getNodeName() + ">";
                                detailString.append(columnWithAttribute);
                            }
                        }
                    }
                    ++childIndex;
                }
                detailString.append("</" + detailNode.getNodeName() + ">");
                ++detailIndex;
            }
            BaseLogger.log("3", null, null, "Detail String [ " + detailString.toString());
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getDetailAttributes() [ " + e.getMessage());
        }
        return detailString.toString();
    }

    private String getColumnAttributes(Node attribNode, String nodeName) {
        StringBuilder attribute = new StringBuilder("");
        try {
            BaseLogger.log("3", null, null, "Find Attributes for column===> [ " + nodeName);
            NodeList tableDefinitionList = attribNode.getChildNodes();
            Node attributeNode = null;
            int index = 0;
            while (index < tableDefinitionList.getLength()) {
                if (attributeNode != null) break;
                Node tableColNode = tableDefinitionList.item(index);
                if (!tableColNode.getNodeName().contains("#") && !tableColNode.getNodeName().equalsIgnoreCase("attribute")) {
                    NodeList tableColumnChilds = tableColNode.getChildNodes();
                    int childIndex = 0;
                    while (childIndex < tableColumnChilds.getLength()) {
                        Node child = tableColumnChilds.item(childIndex);
                        child.getNodeName().contains("#");
                        if (child.getNodeName().equalsIgnoreCase("name") && child.getTextContent().equalsIgnoreCase(nodeName)) {
                            attributeNode = tableColNode;
                            break;
                        }
                        ++childIndex;
                    }
                }
                ++index;
            }
            if (attributeNode != null) {
                NodeList attribNodes = attributeNode.getChildNodes();
                String attributeStr = " ";
                int index2 = 0;
                while (index2 < attribNodes.getLength()) {
                    Node attrNode = attribNodes.item(index2);
                    if (attrNode != null && !attrNode.getNodeName().contains("#") && !attrNode.getNodeName().equalsIgnoreCase("retrieve")) {
                        BaseLogger.log("3", null, null, "Attrib Node name=" + attrNode.getNodeName());
                        if (attrNode.getNodeName().equalsIgnoreCase("type")) {
                            attributeStr = String.valueOf(attributeStr) + attrNode.getNodeName() + "=\"" + attrNode.getTextContent() + "\" ";
                            if (attrNode.getAttributes().getNamedItem("size") != null) {
                                attributeStr = String.valueOf(attributeStr) + "size=\"" + attrNode.getAttributes().getNamedItem("size").getNodeValue() + "\" ";
                            }
                            if (attrNode.getAttributes().getNamedItem("precision") != null) {
                                attributeStr = String.valueOf(attributeStr) + "precision=\"" + attrNode.getAttributes().getNamedItem("precision").getNodeValue() + "\" ";
                            }
                        } else {
                            attrNode.getNodeName().equalsIgnoreCase("values");
                        }
                    }
                    ++index2;
                }
                attribute.append(attributeStr);
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getColumnAttributes() for  ===> [ " + nodeName + e.getMessage());
            e.printStackTrace();
        }
        return attribute.toString();
    }

    private String getIsRequired(String columnName, NodeList colNodeList) {
        String isRequired = "N";
        try {
            int nodeIndex = 0;
            while (nodeIndex < colNodeList.getLength()) {
                Node node = colNodeList.item(nodeIndex);
                NodeList colObjList = node.getChildNodes();
                boolean flag = false;
                int colObjIndex = 0;
                while (colObjIndex < colObjList.getLength()) {
                    Node childNode = colObjList.item(colObjIndex);
                    if (childNode.getNodeName().equalsIgnoreCase("name") && childNode.getTextContent().equals(columnName)) {
                        flag = true;
                    }
                    if (flag && childNode.getNodeName().equalsIgnoreCase("EditStyle")) {
                        NodeList editChildList = childNode.getChildNodes();
                        int index = 0;
                        while (index < editChildList.getLength()) {
                            if (editChildList.item(index).getNodeName().equals("required")) {
                                isRequired = editChildList.item(index).getTextContent();
                                BaseLogger.log("3", null, null, "column Name to check=" + columnName + " Required=" + isRequired);
                                return isRequired;
                            }
                            ++index;
                        }
                    }
                    ++colObjIndex;
                }
                ++nodeIndex;
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getIsRequired() [ " + e.getMessage());
        }
        return isRequired;
    }

    private String getLabelName(String columnName, NodeList textNodeList) {
        try {
            Node textObjNode = null;
            String label = "";
            int textNodeIndex = 0;
            while (textNodeIndex < textNodeList.getLength()) {
                Node textNode = textNodeList.item(textNodeIndex);
                int index = 0;
                while (index < textNode.getChildNodes().getLength()) {
                    Node childNode = textNode.getChildNodes().item(index);
                    if (childNode.getNodeName().equalsIgnoreCase("name") && childNode.getTextContent().equalsIgnoreCase(String.valueOf(columnName) + "_t")) {
                        textObjNode = textNode;
                        break;
                    }
                    ++index;
                }
                ++textNodeIndex;
            }
            if (textObjNode != null) {
                int index = 0;
                while (index < textObjNode.getChildNodes().getLength()) {
                    if (textObjNode.getChildNodes().item(index).getNodeName().equalsIgnoreCase("text")) {
                        label = textObjNode.getChildNodes().item(index).getTextContent();
                    }
                    ++index;
                }
            }
            label = label.length() > 0 ? label.substring(0, label.length() - 1) : "";
            return "label=\"" + label.trim() + "\" ";
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getLabelName() [ " + e.getMessage());
            return "";
        }
    }

    public String downloadSampleDataXML(String objName, String refId, HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log("3", null, null, "Inside downloadSampleData() ");
        String result = "";
        try {
            result = this.getDetailXMLDomString(objName, "1", "V", refId, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        catch (ibase.planner.utility.ITMException e) {
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "result: downloadSampleData() => [ " + result + " ] ");
        byte[] byteArrray = result.getBytes();
        BaseLogger.log("3", null, null, "byteArrray: downloadSampleData() => [ " + byteArrray + " ] ");
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "attachment;filename=SampleData.xml");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(byteArrray);
        }
        catch (IOException e) {
            BaseLogger.log("3", null, null, "catch: downloadSampleData() => [ " + e.getMessage() + " ] ");
            e.printStackTrace();
        }
        return result;
    }

    public String downloadJSONSampleData(String objName, String refId, HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log("3", null, null, "JSON Inside downloadSampleData() ");
        String result = "";
        String JSONString = "";
        try {
            result = this.getDetailXMLDomString(objName, "1", "V", refId, null);
            XMLtoJSONConverter converter = new XMLtoJSONConverter();
            BaseLogger.log("3", null, null, "result: downloadJSONSampleData() => [ " + result + " ] ");
            String formattedXML = this.getFormattedXML(result, objName);
            BaseLogger.log("3", null, null, "formattedXML string output=" + formattedXML);
            JSONString = this.getSortedJson(formattedXML, objName);
            BaseLogger.log("3", null, null, "json string output=" + JSONString);
        }
        catch (Exception e) {
            System.out.println("Error=====>" + e.getMessage());
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "result: downloadSampleData() => [ " + JSONString + " ] ");
        byte[] byteArrray = JSONString.getBytes();
        BaseLogger.log("3", null, null, "byteArrray: downloadSampleData() => [ " + byteArrray + " ] ");
        response.setContentType("application/text");
        response.setHeader("Content-Disposition", "attachment;filename=SampleData.json");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(byteArrray);
        }
        catch (IOException e) {
            BaseLogger.log("3", null, null, "catch: downloadSampleData() => [ " + e.getMessage() + " ] ");
            e.printStackTrace();
        }
        return result;
    }

    private String getFormattedXML2(String result, String objName) {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root>");
        try {
            UploadFileEJB uploadFileEJB = new UploadFileEJB();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(result.getBytes()));
            TreeMap<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, this.userInfoGlobal);
            BaseLogger.log("3", null, null, "formDetailInfoMAP=[" + formDetailInfo + "]");
            int mapIndex = 1;
            while (mapIndex <= formDetailInfo.size()) {
                NodeList nodes = document.getElementsByTagName("Detail" + mapIndex);
                BaseLogger.log("3", null, null, "Detail node count=" + nodes.getLength());
                int i = 0;
                while (i < nodes.getLength()) {
                    BaseLogger.log("3", null, null, "detailNodeName===>" + nodes.item(i).getNodeName());
                    NodeList detailList = nodes.item(i).getChildNodes();
                    if (xml.indexOf("<" + nodes.item(i).getNodeName() + ">") == -1) {
                        BaseLogger.log("3", null, null, "detail not exist=======><" + nodes.item(i).getNodeName() + ">");
                        xml.append("<" + nodes.item(i).getNodeName() + ">");
                        int dindex = 0;
                        while (dindex < detailList.getLength()) {
                            Node colNode = detailList.item(dindex);
                            if (!colNode.getNodeName().contains("#") && !colNode.getNodeName().equals("attribute")) {
                                BaseLogger.log("3", null, null, "NodeName===>" + detailList.item(dindex).getNodeName());
                                String data = "\"\"";
                                if (colNode.hasChildNodes()) {
                                    data = colNode.getFirstChild().getTextContent();
                                }
                                xml.append("<" + colNode.getNodeName() + "><![CDATA[" + data + "]]>");
                                xml.append("</" + colNode.getNodeName() + ">");
                            }
                            ++dindex;
                        }
                        xml.append("</" + nodes.item(i).getNodeName() + ">");
                    }
                    ++i;
                }
                ++mapIndex;
            }
            xml.append("</Root>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml.toString();
    }

    private String getFormattedXML(String result, String objName) {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root>");
        try {
            UploadFileEJB uploadFileEJB = new UploadFileEJB();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(result.getBytes()));
            TreeMap<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, this.userInfoGlobal);
            BaseLogger.log("3", null, null, "formDetailInfoMAP=[" + formDetailInfo + "]");
            int mapIndex = 1;
            while (mapIndex <= formDetailInfo.size()) {
                NodeList detailNodeList = document.getElementsByTagName("Detail" + mapIndex);
                BaseLogger.log("3", null, null, "Detail node count=" + detailNodeList.getLength());
                int detailIndex = 0;
                while (detailIndex < detailNodeList.getLength()) {
                    if (!detailNodeList.item(detailIndex).getNodeName().contains("#")) {
                        Node detailNode = detailNodeList.item(detailIndex);
                        xml.append("<" + detailNode.getNodeName() + ">");
                        NodeList detailChildList = detailNode.getChildNodes();
                        int childIndex = 0;
                        while (childIndex < detailChildList.getLength()) {
                            Node childNode = detailChildList.item(childIndex);
                            if (!childNode.getNodeName().contains("#") && !childNode.getNodeName().equalsIgnoreCase("attribute")) {
                                String data = "\"\"";
                                if (childNode.hasChildNodes()) {
                                    data = childNode.getFirstChild().getTextContent();
                                }
                                xml.append("<" + childNode.getNodeName() + "><![CDATA[" + data + "]]>");
                                xml.append("</" + childNode.getNodeName() + ">");
                            }
                            ++childIndex;
                        }
                        xml.append("</" + detailNode.getNodeName() + ">");
                    }
                    ++detailIndex;
                }
                ++mapIndex;
            }
            xml.append("</Root>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "xml String output=" + xml.toString());
        return xml.toString();
    }

    private String getSortedJson(String xmlStr, String objName) {
        StringBuilder json = new StringBuilder("{\"Root\":{");
        Document document = this.convertStringToDocument(xmlStr);
        try {
            UploadFileEJB uploadFileEJB = new UploadFileEJB();
            TreeMap<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, this.userInfoGlobal);
            TreeMap<String, List> detailDataMap = new TreeMap<String, List>();
            int mapIndex = 1;
            while (mapIndex <= formDetailInfo.size()) {
                NodeList detailNodeList = document.getElementsByTagName("Detail" + mapIndex);
                int detailIndex = 0;
                while (detailIndex < detailNodeList.getLength()) {
                    List<String> list;
                    Node detailNode = detailNodeList.item(detailIndex);
                    BaseLogger.log("3", null, null, "DetailNode=" + detailNode.getNodeName());
                    NodeList detailList = detailNode.getChildNodes();
                    String data = "";
                    int index = 0;
                    while (index < detailList.getLength()) {
                        Node child = detailList.item(index);
                        if (child.getTextContent().contains("{") && child.getTextContent().contains("}")) {
                            BaseLogger.log("3", null, null, "Found Json obj" + child.getTextContent());
                            String jsonData = "\"" + child.getTextContent().replace("\"", "\\\"") + "\"";
                            BaseLogger.log("3", null, null, "Found Json obj" + jsonData);
                            data = String.valueOf(data) + "\"" + child.getNodeName() + "\":" + jsonData + ",";
                        } else {
                            data = child.getTextContent().equals("\"\"") ? String.valueOf(data) + "\"" + child.getNodeName() + "\":" + child.getTextContent() + "," : String.valueOf(data) + "\"" + child.getNodeName() + "\":\"" + child.getTextContent() + "\",";
                        }
                        ++index;
                    }
                    if (!data.equals("")) {
                        data = "{" + data.substring(0, data.length() - 1) + "}";
                    }
                    if (!detailDataMap.containsKey(detailNode.getNodeName())) {
                        list = new ArrayList<String>();
                        list.add(data);
                        detailDataMap.put(detailNode.getNodeName(), list);
                    } else {
                        list = (List)detailDataMap.get(detailNode.getNodeName());
                        list.add(data);
                        detailDataMap.put(detailNode.getNodeName(), list);
                    }
                    ++detailIndex;
                }
                ++mapIndex;
            }
            detailDataMap.forEach((key, value) -> {
                json.append("\"" + key + "\":");
                json.append(value + ",");
            });
            json.append("}}");
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getSortedJson()" + e.getMessage());
        }
        return json.toString().replace("],}", "]}");
    }

    public String getFormattedJSON(String jsonString) {
        try {
            JSONObject jsonObj = new JSONObject(jsonString);
            Iterator keys = jsonObj.keys();
            ArrayList<String> objList = new ArrayList<String>();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                JSONObject rootJson = jsonObj.getJSONObject(key);
                Iterator rootKeys = rootJson.keys();
                while (rootKeys.hasNext()) {
                    String childKey = rootKeys.next().toString();
                    JSONObject detail = rootJson.getJSONObject(childKey);
                    objList.add("\"" + childKey + "\":[" + detail + "]");
                }
            }
            Collections.sort(objList);
            StringBuffer finalJsonString = new StringBuffer("{\"Root\":{");
            for (String string : objList) {
                if (objList.indexOf(string) != objList.size() - 1) {
                    finalJsonString.append(string.replace("\"\\\"\\\"\"", "\"\""));
                    finalJsonString.append(",");
                    continue;
                }
                finalJsonString.append(string.replace("\"\\\"\\\"\"", "\"\""));
            }
            finalJsonString.append("}}");
            System.out.println(finalJsonString.toString());
            return finalJsonString.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues) throws RemoteException, ITMException, ibase.planner.utility.ITMException {
        String resultString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(this.userInfoGlobal);
                resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log("0", null, null, "NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage());
                throw new ibase.planner.utility.ITMException(e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    private InitialContext getInitialContext() throws ibase.planner.utility.ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ibase.planner.utility.ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : getInitialContext : " + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getInitialContext : " + e.getMessage());
            throw new ibase.planner.utility.ITMException(e);
        }
        return ctx;
    }

    private List<String> getTableAndPrimaryKey(String objName, String userCode) {
        ArrayList<String> dataList = new ArrayList<String>();
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                ConnDriver connDriver = new ConnDriver();
                UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
                String sql = "SELECT TABLE_NAME,TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName + "'";
                conn = connDriver.getConnectDB(userInfo);
                pstmt = conn.createStatement();
                ResultSet rs = pstmt.executeQuery(sql);
                if (rs.next()) {
                    dataList.add(rs.getString("TABLE_NAME"));
                    dataList.add(rs.getString("TRAN_ID_COL"));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (dataList.size() > 0) {
                    System.out.println("Query=" + (String)dataList.get(1));
                    if ("null".equals(dataList.get(1)) || dataList.get(1) == null || ((String)dataList.get(1)).equals("")) {
                        String query = "SELECT cols.column_name FROM all_constraints cons, all_cons_columns cols WHERE cols.table_name = '" + ((String)dataList.get(0)).toUpperCase() + "' " + "AND cons.constraint_type = 'P' " + "AND cons.constraint_name = cols.constraint_name " + "AND cons.owner = cols.owner " + "AND POSITION='1' " + "ORDER BY cols.table_name, cols.position";
                        System.out.println("Query=" + query);
                        pstmt = conn.createStatement();
                        rs = pstmt.executeQuery(query);
                        if (rs.next()) {
                            dataList.add(1, rs.getString("column_name"));
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        return dataList;
    }

    public String getRandomPrimaryKeyValue(String primaryKey, String tableName, String userCode) {
        String randomValue = "";
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                ConnDriver connDriver = new ConnDriver();
                UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
                String sql = "SELECT " + primaryKey + " FROM " + tableName + " ORDER BY DBMS_RANDOM.value FETCH NEXT 1 ROWS ONLY";
                conn = connDriver.getConnectDB(userInfo);
                pstmt = conn.createStatement();
                ResultSet rs = pstmt.executeQuery(sql);
                if (rs.next()) {
                    randomValue = rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        return randomValue;
    }

    public FileOutputStream writeFile(String fileContent) {
        String fileName = "SampleData.txt";
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(fileName);
            byte[] strToBytes = fileContent.getBytes();
            outputStream.write(strToBytes);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream;
    }

    private Node getTableDefinitionaNode(String objName, int tabNo) {
        Document document = null;
        Node node = null;
        try {
            document = this.getMetaDocument(objName, tabNo, "1");
            node = document.getElementsByTagName("TableDefinition").item(0);
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception reading sample=[ " + e.getMessage() + "]");
        }
        return node;
    }

    private NodeList getColumnObjectNodeList(String objName, int tabNo, String tagName) {
        NodeList objList = null;
        try {
            objList = this.getMetaDocument(objName, tabNo, "2").getElementsByTagName(tagName);
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Erorr in getTextObjectNodeList " + e.getMessage());
        }
        return objList;
    }

    private Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Document getMetaDocument(String objName, int tabNo, String pageContext) {
        Document document = null;
        try {
            String objContext = String.valueOf(tabNo);
            String editor = "WebEditor";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfoGlobal != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfoGlobal.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", "");
                propEditorInfoMap.put("USER_ID", this.checkNull(this.userInfoGlobal.getLoginCode()));
            }
            propEditorInfoMap.put("EDITOR", editor);
            String formName = this.checkNull(TemplateDetails.get(objName).getFormName(objContext));
            String metadataFilePath = this.genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, this.userInfoGlobal.getTransDB());
            BaseLogger.log("3", null, null, "metadataFilePath === [" + metadataFilePath + "]");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(metadataFilePath);
            return document;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String checkNull(String nullStr) {
        return E12GenericUtility.checkNull(nullStr);
    }
}

