package ibase.e12ria.client;
import ibase.e12ria.client.resources.Resources;
import ibase.e12ria.e12widgets.client.E12DateBox;
import ibase.e12ria.e12widgets.client.EntryWrapper;
import ibase.e12ria.e12widgets.client.PophelpSuggestOracle;
import ibase.e12ria.e12widgets.client.TouchWidget;
import ibase.gwt.client.calendar.client.E12DataProviderComponent;
import ibase.e12ria.e12widgets.client.E12PopupPanel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import com.google.gwt.core.client.Callback;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestBox.DefaultSuggestionDisplay;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;

/**
 * @author basedev1
 *
 */
public class ME12DataProvider extends Widget 
{
	private Label viewCalendarBtn = null;
	private String objName = "";
	private AbsolutePanel absPanel = new AbsolutePanel();
	public  E12PopupPanel popupPanel = null;
	private VerticalPanel calPanel = new VerticalPanel();
	private int popupWidth = 0;
	private String browDataDef = "";
	private Image popupImg = null;
	private String e12CalendarID = "";
	private ME12Calender parent;
	private ClickHandler clickHandler = null;
	private String providerKey = "";
	private String calendarFor = "";
	private String dispalyText = "";
//	private E12Calendar e12Calendar = null;
	//Changed by Pooja S on 18-oct-2019 [To open the Calendar Transaction from BROWSER]
	E12DataProviderComponent e12DataProviderComponent = null;
	
	public ME12DataProvider(ME12Calender parent)
	{
		this.parent = parent;
	}
	
	/**
	 * 
	 */
	public AbsolutePanel createArgumentPage( final EntryWrapper entry ) 
	{
		if( E12Constants.userID != null )
		{
			try
			{
				objName = entry.getObjName();
				//Changed by Pooja S on 18-oct-2019 [To open the Calendar Transaction from BROWSER]
				e12DataProviderComponent = E12DataProviderComponent.getInstance( objName );
				E12CommonUtils.printOnConsole("Inside create argument page of ME12 objName ["+objName+"]");
//				E12CommonUtils.setObjName(objName);
				
				e12CalendarID = "calendarContainer_" + entry.getId();
				AbsolutePanel parentAbsPnl = new AbsolutePanel();
				parentAbsPnl.setStyleName( "calendarAbsPnl" );
				HorizontalPanel contentHeaderPanel = new HorizontalPanel();
				contentHeaderPanel.getElement().setAttribute("style", "padding:10px;");
				FlowPanel flPanel = new FlowPanel();
				popupImg = new Image();
				//popupImg.setResource( Resources.INSTANCE.popupImg() );
				if( getDataProviderType() == DataProviderType.CALENDAR )
				{
					popupImg.setResource( Resources.INSTANCE.calendarView() );
				}
				else //if( getDataProviderType() == DataProviderType.MAP )
				{
					popupImg.setResource( Resources.INSTANCE.mapView() );
				}
				popupImg.setStyleName("cal-downArrow");
				popupImg.getElement().setAttribute("id", "cal-downArrow");
				
				flPanel.getElement().setAttribute("style", "padding: 10px;");
				flPanel.getElement().setAttribute("style", "float: right;");
				TouchWidget touchWidget  = new TouchWidget(popupImg);
				flPanel.add(touchWidget);
				
				contentHeaderPanel.add(flPanel);
				
				parentAbsPnl.add(contentHeaderPanel);
				
				parent.setHeader(parentAbsPnl);
				
				calPanel = new VerticalPanel();
				
				
				clickHandler = new ClickHandler() 
				{
					@Override
					public void onClick(ClickEvent event) 
					{
						popupPanel = new E12PopupPanel(true, true, "top", false){
							@Override
							public void onClick(ClickEvent event) 
							{
								super.onClick(event);
							}
						};
						popupPanel.addStyleName("searchOptionPopup");
						popupPanel.addStyleNameToContainer("searchOptionPnlContainer");
						popupPanel.getElement().setAttribute("style", "z-index: 1");
						popupPanel.clear();
						popupPanel.add(calPanel);
						popupPanel.setPopupPositionAndShow(new E12PopupPanel.PositionCallback() 
						{
							public void setPosition(int offsetWidth, int offsetHeight) 
							{
								int left = popupImg.getAbsoluteLeft();
								popupWidth = offsetWidth;
								left = left - offsetWidth;
								popupPanel.setPopupPosition( ( left + 50 ), popupImg.getAbsoluteTop() + 15 );	
								popupPanel.show();
							}
						});
					}
				};
				
				popupImg.addClickHandler(clickHandler);
				
				HashMap<String, String> paramMap = new HashMap<String, String>();
				paramMap.put("calObjName", objName);
				paramMap.put("user", E12Constants.userID.trim());
				paramMap.put("ACTION", "DATA_PROVIDER_DOC" );
				paramMap.put("VIEW_MODE", "G");
				
				String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
				String url = E12Global.getHostUrl() + "/ibase/CalenderContolServlet?"+paramString;
				E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.GET, url);
				requestBuilder.sendRequest( "", new RequestCallback() 
				{
					@Override
					public void onResponseReceived(Request request, Response response) 
					{
						String responseStr = response.getText();
						//E12CommonUtils.printOnConsole("DATA_PROVIDER_DOC["+responseStr+"]");
						if( responseStr != null &&  E12Global.getInstance().checkErrorException(response, 1) )
						{
							e12DataProviderComponent.requestParamMap.clear();
							Document dataProviderDoc = XMLParser.parse(responseStr);
							com.google.gwt.xml.client.NodeList calendarForNodeList = dataProviderDoc.getElementsByTagName("CALENDAR_FOR");
							if( calendarForNodeList != null && calendarForNodeList.getLength() > 0 )
							{
								E12CommonUtils.printOnConsole("calendarFor ["+calendarFor+"]");
								if(calendarForNodeList.item(0).getFirstChild()!=null)
								{
									calendarFor = calendarForNodeList.item(0).getFirstChild().getNodeValue();
								}
								E12CommonUtils.printOnConsole("calendarFor ["+calendarFor+"]");
							}
							@SuppressWarnings("rawtypes")
							ArrayList dataProvdrsNameArrList = new ArrayList();
							com.google.gwt.xml.client.NodeList dpNameNodeList = dataProviderDoc.getElementsByTagName("DATA_PROVIDER");
							int dpNameLen = dpNameNodeList.getLength();
							for (int ctr = 0; ctr < dpNameLen; ctr++ )
							{
								String dpName = dpNameNodeList.item(ctr).getAttributes().getNamedItem("DISPLAY_NAME").getNodeValue();
								dataProvdrsNameArrList.add( dpName );
							}
							
							@SuppressWarnings("rawtypes")
							ArrayList dataProvdrsIdArrList = new ArrayList();
							com.google.gwt.xml.client.NodeList providerIdNodeList = dataProviderDoc.getElementsByTagName("DATA_PROVIDER");
							int providerIdLen = providerIdNodeList.getLength();
							for (int ctr = 0; ctr < providerIdLen; ctr++ )
							{
								String dpName = providerIdNodeList.item(ctr).getAttributes().getNamedItem("PROVIDER_ID").getNodeValue();
								dataProvdrsIdArrList.add( dpName );
							}
							for ( int dpCtr = 0; dpCtr < dataProvdrsNameArrList.size(); dpCtr++ )
							{
								int rowCounter = 0;
								String dataProvider = (String) dataProvdrsNameArrList.get(dpCtr);
								String dataProviderId = (String) dataProvdrsIdArrList.get(dpCtr);
								System.out.println("dataProvider ["+dataProvider+"]");

//								ArrayList dataProvdrArrList = dataProvAdminBean.getDataProviderInfo( dataProviderDoc, dataProviderId );

								ArrayList dataProvdrArrList = new ArrayList();
								HashMap dataProviderKeyName = new HashMap();
								HashMap dataProviderKeyValue = new HashMap();
								HashMap dataProviderDataType = new HashMap();

								//Document dataProvider = getDataProviderDoc( user, calObjName );

								com.google.gwt.xml.client.NodeList dataProviderNodeList = dataProviderDoc.getElementsByTagName("DATA_PROVIDER");
								int dataProviderLen = dataProviderNodeList.getLength();
								for (int ctr = 0; ctr < dataProviderLen; ctr++ )
								{
									String provID = dataProviderNodeList.item(ctr).getAttributes().getNamedItem("PROVIDER_ID").getNodeValue();
									String active = "";
									if ( dataProviderId.equalsIgnoreCase( provID ) )
									{
										com.google.gwt.xml.client.NodeList activeNodeList = dataProviderDoc.getElementsByTagName("ACTIVE");
										for(int i = 0; i < activeNodeList.getLength(); i++ )
										{
											String activeValue = activeNodeList.item(i).getAttributes().getNamedItem("NODE_ID").getNodeValue();
											if(activeValue != null && activeValue.equalsIgnoreCase(provID + "_DS_ACTIVE"))
											{
												active = activeValue;
												break;
											}
										}
										dataProviderKeyName.put(provID+"_DS_ACTIVE", "STATUS");
										dataProviderKeyValue.put(provID+"_DS_ACTIVE", active);
										
										com.google.gwt.xml.client.NodeList userArgsList = dataProviderDoc.getElementsByTagName("USER_ARGUMENTS");
										for(int i = 0; i < userArgsList.getLength(); i++ )
										{
											String argValue = userArgsList.item(i).getAttributes().getNamedItem("NODE_ID").getNodeValue();
											if(argValue != null && argValue.equalsIgnoreCase(provID + "_DS_UA"))
											{
												com.google.gwt.xml.client.NodeList userArgsNodeList = userArgsList.item(i).getChildNodes();
												int userArgsNodeListLen = userArgsNodeList.getLength();
												for (int innerCtr = 0; innerCtr < userArgsNodeListLen; innerCtr++ )
												{
													com.google.gwt.xml.client.Node innerNode = userArgsNodeList.item( innerCtr );
													if ( innerNode.getNodeType() == com.google.gwt.xml.client.Node.ELEMENT_NODE )
													{
														String usrArgName = innerNode.getAttributes().getNamedItem("DISPLAY_NAME").getNodeValue();
														String usrArgId = innerNode.getAttributes().getNamedItem("NODE_ID").getNodeValue();
														String dbType = innerNode.getAttributes().getNamedItem("DB_TYPE").getNodeValue();
														String usrArgVal = "";
														com.google.gwt.xml.client.NodeList childList = innerNode.getChildNodes();
														int noOfChilds = childList.getLength();
														for(int colCtr = 0; colCtr < noOfChilds; colCtr++)
														{
															com.google.gwt.xml.client.Node colNode = childList.item(colCtr);
															if(colNode != null && colNode.getNodeType() == com.google.gwt.xml.client.Node.ELEMENT_NODE)
															{
																if(colNode.getNodeName().equals("VALUE"))
																{
																	if(colNode.getFirstChild() != null)
																	{
																		usrArgVal = colNode.getFirstChild().getNodeValue();
																	}
																	break;
																}
															}
														}
														dataProviderKeyName.put(usrArgId, usrArgName);
														dataProviderKeyValue.put(usrArgId, usrArgVal);
														dataProviderDataType.put(usrArgId, dbType);
													}
												}
											}
										}
									}
								}
							//	E12CommonUtils.printOnConsole("dataProviderKeyName.size()="+dataProviderKeyName.size());
							//	E12CommonUtils.printOnConsole("dataProviderKeyValue.size()="+dataProviderKeyValue.size());
								dataProvdrArrList.add( dataProviderKeyName );
								dataProvdrArrList.add( dataProviderKeyValue );
								dataProvdrArrList.add(dataProviderDataType);
							//	E12CommonUtils.printOnConsole("dataProvdrArrList.size()="+dataProvdrArrList.size());
								
								HashMap dataPrvdrKeyNameMap = ( HashMap ) dataProvdrArrList.get( 0 );
								HashMap dataPrvdrKeyValMap = ( HashMap ) dataProvdrArrList.get( 1 );
								HashMap dataPrvdrdbTypeMap = ( HashMap ) dataProvdrArrList.get( 2 );
								Iterator iterator = dataPrvdrKeyNameMap.keySet().iterator();
								String dataPrvdrKeyCheckValue="";
								
								while(iterator.hasNext())
								{	
									String dataPrvdrKeyName = (String) iterator.next();
									String dataPrvdrName = e12DataProviderComponent.toInitCase(( String ) dataPrvdrKeyNameMap.get( dataPrvdrKeyName ));
									dataPrvdrKeyCheckValue = ( String ) dataPrvdrKeyValMap.get( dataPrvdrKeyName );
								//	E12CommonUtils.printOnConsole("dataPrvdrKeyName ["+dataPrvdrKeyName+"] dataPrvdrName ["+dataPrvdrName+"] dataPrvdrKeyCheckValue ["+dataPrvdrKeyCheckValue+"]");
									String dataPrvdrNameId = dataProvider+"_"+dataPrvdrName+"_chk";
								//	E12CommonUtils.printOnConsole("dataPrvdrNameId [ "+dataPrvdrNameId+" ]");
									if( dataPrvdrKeyName.indexOf("_DS_UA") > 0 )
									{
										String isUserArgument="present";														
									}
									String checkType = "text";
									String checkedStatus = "unChecked";
									
									if(dataPrvdrNameId.toUpperCase().indexOf("STATUS_CHK")!=-1)
									{
										checkType = "checkbox";
										if(dataPrvdrKeyCheckValue.equals("Y"))
										{
											checkedStatus = "checked";
										}
										else if(dataPrvdrKeyCheckValue.equals("N"))
										{	
											checkedStatus = "unChecked";
										}
										dataPrvdrName = "";
										//E12CommonUtils.printOnConsole("*****************checkedStatus [ "+checkedStatus+" ]");
									}
								}
								
								Iterator iter = dataPrvdrKeyNameMap.keySet().iterator();
								while(iter.hasNext())
								{
									final String dataPrvdrKeyName = (String) iter.next();
									String dataPrvdrName = e12DataProviderComponent.toInitCase(( String ) dataPrvdrKeyNameMap.get( dataPrvdrKeyName ));
									String dataPrvdrKeyVal = ( String ) dataPrvdrKeyValMap.get( dataPrvdrKeyName);
									String dataPrvdrdbType = ( String ) dataPrvdrdbTypeMap.get( dataPrvdrKeyName );
									//E12CommonUtils.printOnConsole("dataPrvdrKeyName ["+dataPrvdrKeyName+"] dataPrvdrName ["+dataPrvdrName+"] dataPrvdrdbType ["+dataPrvdrdbType+"]");
									
									String dataPrvdrNameId =dataProvider+"_"+dataPrvdrName+"_inp";
									
									if(dataPrvdrNameId.toUpperCase().indexOf("STATUS_INP")==-1)
									{
										boolean isDateField = dataPrvdrdbType.equalsIgnoreCase("DATE");
										FlowPanel flowPanel = new FlowPanel();
										String txtBoxStyleName = "e12-TextBox";
										String txtBoxROStyleName = "e12-TextBox-readonly";
										
										Label dataPrvdrNameLbl = new Label(dataPrvdrName);
										dataPrvdrNameLbl.setStyleName("argLabel");
										
										//final E12TextBox dataProviderNameTxtbox = new E12TextBox();
										final E12MultiSelectTextBox dataProviderNameTxtbox = new E12MultiSelectTextBox();
										final E12DateBox dataProviderNameDatebox = new E12DateBox();

										DateTimeFormat dateFormat = DateTimeFormat.getFormat( E12Constants.dispDate );
										dataProviderNameDatebox.setStyleName("dateBox");
										dataProviderNameDatebox.setFormat( dateFormat );
										dataProviderNameDatebox.setValue( new Date() );

										final Label readOnlyTxtbox = new Label();
										String[] strArr = dataPrvdrKeyName.split("UA_");
										final String fieldName = E12CommonUtils.checkNull( strArr[1] );
										E12CommonUtils.printOnConsole("fieldName="+fieldName);
										//final PophelpSuggestOracle pophelpSuggest = new PophelpSuggestOracle( fieldName );
										final PophelpSuggestOracle pophelpSuggest = new PophelpSuggestOracle( fieldName )
										{
											@Override
											public void requestSuggestions( Request request, Callback callback) 
											{
												setQueryPath( e12DataProviderComponent.buildAutoCompleteURL( fieldName, objName ) );
												setSearchQuery( null );
												super.requestSuggestions(request, callback);
											}
										};
										pophelpSuggest.setAutoFillLen(2);
										//pophelpSuggest.setQueryPath( buildAutoCompleteURL( fieldName ) );
										final SuggestBox suggestBox = new SuggestBox(pophelpSuggest, dataProviderNameTxtbox);
										((DefaultSuggestionDisplay)suggestBox.getSuggestionDisplay()).setSuggestionListHiddenWhenEmpty(true);
										((DefaultSuggestionDisplay)suggestBox.getSuggestionDisplay()).setPopupStyleName("e12-SuggestBoxPopup");
										
										suggestBox.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>() {
											@Override
											public void onSelection(SelectionEvent<Suggestion> event) {
												E12CommonUtils.printOnConsole("Display String[" + event.getSelectedItem().getDisplayString() + "]" +
												" Replacement String[" + event.getSelectedItem().getReplacementString() + "]");
												
												if(calendarFor != null && !"".equalsIgnoreCase( calendarFor ) )
												{
													dispalyText = event.getSelectedItem().getDisplayString();
													String[] calendarForArr = calendarFor.split(","); 
													int size = calendarForArr.length;
													E12CommonUtils.printOnConsole("SIZE ["+size+"]");
													if( dispalyText != null && !"".equalsIgnoreCase( dispalyText ) )
													{
														String[] textArr = dispalyText.split("-");
														if( textArr.length > size )
														{
															dispalyText = "";
															for(int i = 1; i <= size; i++ )
															{
																dispalyText = dispalyText + " "+ textArr[i];
															}
															E12CommonUtils.printOnConsole("dispalyText ["+dispalyText+"]");
															readOnlyTxtbox.setText(dispalyText.trim());
														}
													}
												}
												else
												{
													dispalyText = "";
													readOnlyTxtbox.setText(dispalyText.trim());
												}
											}
										});										
										suggestBox.getTextBox().addFocusHandler(new FocusHandler() {
											@Override
											public void onFocus(FocusEvent event) {
												suggestBox.showSuggestionList();
											}
										});
										
										dataProviderNameTxtbox.addStyleName("cal-txtBox-valid");
										dataProviderNameTxtbox.setStylePrimaryName(txtBoxStyleName);
										final String tempdataPrvdrKeyName = "Detail1.1."+fieldName.toLowerCase();
										dataProviderNameTxtbox.getElement().setAttribute("id", tempdataPrvdrKeyName);
										dataProviderNameTxtbox.getElement().setAttribute("name", tempdataPrvdrKeyName);
										
										dataProviderNameDatebox.getElement().setAttribute("id", tempdataPrvdrKeyName);
										dataProviderNameDatebox.getElement().setAttribute("name", tempdataPrvdrKeyName);
										
										dataProviderNameTxtbox.setValue(E12Constants.userID.trim());
										dataProviderNameTxtbox.addStyleName("cal-txtBox");
										
										readOnlyTxtbox.getElement().setAttribute("name", tempdataPrvdrKeyName+"_hidden");
										dispalyText = E12Constants.empName.trim();
										// readOnlyTxtbox.setText(E12Constants.empName.trim()); commented and added changes as suggested by gulzar -01-SEP-2023
										readOnlyTxtbox.setText(E12Constants.empCode.trim());
										readOnlyTxtbox.setStylePrimaryName( txtBoxROStyleName );
										readOnlyTxtbox.addStyleName( "disabled-field" );
										//textboxList.add(dataProviderNameTxtbox);										
//										Label popUpLabel = getBrowPopUpLabel(tempdataPrvdrKeyName, 1, dataProviderNameTxtbox, readOnlyTxtbox, dataProviderId);
										if( isDateField )
										{
											e12DataProviderComponent.textboxList.add(dataProviderNameDatebox);
										}
										else
										{
											e12DataProviderComponent.textboxList.add(dataProviderNameTxtbox);
										}

										dataProviderNameTxtbox.addBlurHandler(new BlurHandler() 
										{
											@Override
											public void onBlur(BlurEvent event) 
											{
												String val = dataProviderNameTxtbox.getValue();
												e12DataProviderComponent.requestParamMap.put(dataPrvdrKeyName, val);
												if( val== null || "".equalsIgnoreCase( val ) )
												{
													dataProviderNameTxtbox.removeStyleName("cal-txtBox-valid");
												}
												else
												{
													dataProviderNameTxtbox.removeStyleName("cal-txtBox-valid");
													dataProviderNameTxtbox.addStyleName("cal-txtBox-valid");
												}
											}
										});
									//	E12CommonUtils.printOnConsole("dataPrvdrKeyName = "+dataPrvdrKeyName+"*******Value = "+dataProviderNameTxtbox.getValue());
										//requestParamMap.put(dataPrvdrKeyName, dataProviderNameTxtbox.getValue());
										if( isDateField )
										{
											e12DataProviderComponent.requestParamMap.put(dataPrvdrKeyName, dataProviderNameDatebox.getValue());
										}
										else
										{
											e12DataProviderComponent.requestParamMap.put(dataPrvdrKeyName, dataProviderNameTxtbox.getValue());
										}
										dataPrvdrNameLbl.addStyleName("floatLeft");
										readOnlyTxtbox.addStyleName("floatLeft");
//										HorizontalPanel panel = new HorizontalPanel();
//										//panel.add(suggestBox);
//										if( isDateField )
//										{
//											panel.add(dataProviderNameDatebox);
//										}
//										else
//										{
//											panel.add(suggestBox);
//										}
//										panel.addStyleName("floatLeft");
//										flowPanel.add(dataPrvdrNameLbl);
//										flowPanel.add(panel);
										HorizontalPanel hpanel = new HorizontalPanel();
										if( isDateField )
										{
											hpanel.add(dataProviderNameDatebox);
										}
										else
										{
											hpanel.add(suggestBox);
										}
										hpanel.addStyleName("floatLeft");
										if(getDataProviderType() == DataProviderType.CALENDAR)
										{
											flowPanel.add(dataPrvdrNameLbl);
											flowPanel.add(hpanel);
										}
										else
										{
											e12DataProviderComponent.argFlxTbl.setWidget( rowCounter, 0, dataPrvdrNameLbl );
											e12DataProviderComponent.argFlxTbl.setWidget( rowCounter, 1, hpanel );
											rowCounter++; 
										}
										FlowPanel flowPanel2 = new FlowPanel();
										readOnlyTxtbox.getElement().setAttribute("style", "margin-left: 102px;border: none; background: transparent;");
										if(! isDateField)
										{
											flowPanel2.add(readOnlyTxtbox);
										}

										flowPanel2.add(readOnlyTxtbox);
										//Do not add holiday argument
										if(getDataProviderType() == DataProviderType.CALENDAR)
										{
											if( calPanel.getWidgetCount() <= 1 )
											{
												providerKey = dataPrvdrKeyName;
												E12CommonUtils.printOnConsole("providerKey==="+providerKey);
												calPanel.add(flowPanel);
												calPanel.add(flowPanel2);
											}
											break;
										}
									}
								}
							}
							
							//Added By Suraj on 08/02/2016 [W15HSUN005 - To get objNames from data provider as per Danish Sir]Start 
							if (dataProviderDoc.getElementsByTagName("CURR_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.currentAppObjName = dataProviderDoc.getElementsByTagName("CURR_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}
							if (dataProviderDoc.getElementsByTagName("PREV_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.pastAppObjName = dataProviderDoc.getElementsByTagName("PREV_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}
							if (dataProviderDoc.getElementsByTagName("AFTER_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.futureAppObjName = dataProviderDoc.getElementsByTagName("AFTER_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}
							if (dataProviderDoc.getElementsByTagName("SINGLE_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.singleAppObjName = dataProviderDoc.getElementsByTagName("SINGLE_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}							
							//Added By Suraj on 08/02/2016 [W15HSUN005 - To get objNames from data provider as per Danish Sir]End
							if (dataProviderDoc.getElementsByTagName("plan_objType").getLength() > 0) 
							{
								e12DataProviderComponent.plan_objType = dataProviderDoc.getElementsByTagName("plan_objType").item(0).getFirstChild().getNodeValue();
							}
							
							
							if(getDataProviderType() == DataProviderType.MAP)
							{
								calPanel.add( e12DataProviderComponent.argFlxTbl );
							}
							calPanel.getElement().setAttribute("id", "calendarPanel");
							absPanel.setStyleName("calendarContainer");
							absPanel.getElement().setAttribute("id", e12CalendarID);
							//Suraj 20MAY
							//absPanel.setHeight("99%");
							absPanel.setHeight("100%");
							absPanel.setWidth("99%");
							//Changes by Prajyot on 24AUG2015 - for Map View DataProvider
							if(getDataProviderType() == DataProviderType.CALENDAR)
							{
								e12DataProviderComponent.getUserRights( objName , new Callback<String, String>() {
									@Override
									public void onSuccess(String result) {
										createViewDataButton(result);
									}
									
									@Override
									public void onFailure(String reason) {}
								});							
							}
							else
							{
								viewCalendarBtn = new Label("View");
								viewCalendarBtn.addStyleName("large");
								viewCalendarBtn.addStyleName("blue");
								viewCalendarBtn.addStyleName("awesome");
								viewCalendarBtn.addStyleName("e12SearchOption-footer-btns");
								viewCalendarBtn.getElement().setAttribute("style", "margin-top: 10px;");
								calPanel.add(viewCalendarBtn);
								viewCalendarBtn.addClickHandler(new ClickHandler() 
								{
									@Override
									public void onClick(ClickEvent event) 
									{
										String mapId = entry.getId();
										e12DataProviderComponent.drawMap(popupPanel, absPanel, mapId, objName, clickHandler);
										DOM.getElementById("Suraj123").setAttribute("style", "height:100% !important;");
									}
								});
								clickHandler.onClick(null);
							}
						}
					}
					
					@Override
					public void onError(Request request, Throwable exception) 
					{
						Window.alert("Exception:"+exception.getMessage());
					}
				});
			}
			catch (Exception e) 
			{
				Window.alert("Exception: "+e.getMessage());
			}
		}
		return absPanel;
	}
	
	public void createViewDataButton(String title)
	{
		viewCalendarBtn = new Label(title);
		TouchWidget touchWidget = new TouchWidget(viewCalendarBtn);
		viewCalendarBtn.addStyleName("large");
		viewCalendarBtn.addStyleName("blue");
		viewCalendarBtn.addStyleName("awesome");
		viewCalendarBtn.addStyleName("e12SearchOption-footer-btns");
		viewCalendarBtn.getElement().setAttribute("style", "margin-top: 10px;");
		calPanel.add(touchWidget);
		viewCalendarBtn.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) 
			{
				//DOM.getElementById("Suraj123").setAttribute("style", "height:100% !important;");
				//DOM.getElementById("Suraj123").setClassName("calendarMobileH");
				e12DataProviderComponent.drawCalendar( popupPanel, absPanel, objName, calPanel, e12CalendarID );
			}
		});
		
		try
		{
			HashMap<String, String> pMap = new HashMap<String, String>();
			pMap.put("calObjName", objName);
			pMap.put("ACTION", "GET_BROW_DATA_DEF" );
			pMap.put("VIEW_MODE", "G");
			
			String pString = E12CommonUtils.getInstance().getEncodedParamString(pMap);
			String url1 = E12Global.getHostUrl() + "/ibase/CalenderContolServlet?"+pString;
			E12RequestBuilder requestBuilder1 = new E12RequestBuilder( E12RequestBuilder.GET, url1);
			requestBuilder1.sendRequest( "", new RequestCallback() 
			{
				@Override
				public void onResponseReceived(Request request, Response response) 
				{
					String responseStr = response.getText();
					if( responseStr != null &&  E12Global.getInstance().checkErrorException(response, 1) )
					{
						browDataDef = responseStr;
					}
					if( browDataDef != null && browDataDef.equalsIgnoreCase("Y"))
					{
						e12DataProviderComponent.drawCalendar( popupPanel, absPanel, objName, calPanel, e12CalendarID );
					}
					else
					{
						E12CommonUtils.printOnConsole("browDataDef = "+browDataDef);
						clickHandler.onClick(null);
					}
				}

				@Override
				public void onError(Request request, Throwable exception) 
				{
					Window.alert("Exception:"+exception.getMessage());
				}
			});
		}
		catch (Exception e) 
		{
			Window.alert( "Error while getting object details: " + e.getMessage());
		}
	}
	
//	//Added by Prajyot on 24AUG2015 - for Map View DataProvider : Start
	/**
	 * @author base71
	 * set enum to check DataProviderType
	 */
	
	public DataProviderType dataProviderType;
	public static enum DataProviderType
	{
		CALENDAR,
		MAP
	}
	/**
	 *  set DataProvider Type 
	 * @param dataProviderType
	 */
	public void setDataProviderType(DataProviderType dataProviderType) {
		this.dataProviderType = dataProviderType;
	}
	
	/**
	 * get type of data provider
	 * @return dataProviderType
	 */
	public DataProviderType getDataProviderType() {
		return dataProviderType;
	}

	
}
