/**
 * Calendar Argument Page and Container for Calendar Widget
 */
package ibase.e12ria.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.google.gwt.core.client.Callback;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestBox.DefaultSuggestionDisplay;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;

import ibase.e12ria.e12table.client.E12CustomTextCell;
import ibase.e12ria.e12table.client.E12CustomTextCell.CellData;
import ibase.e12ria.e12widgets.client.E12DateBox;
import ibase.e12ria.e12widgets.client.E12PopUp;
import ibase.e12ria.e12widgets.client.E12PopupPanel;
import ibase.e12ria.e12widgets.client.PophelpSuggestOracle;
import ibase.gwt.client.calendar.client.E12Calendar;
import ibase.gwt.client.calendar.client.E12CalendarUtility;
import ibase.gwt.client.calendar.client.E12DataProviderComponent;

/**
 * @author basedev1
 *
 */
public class E12DataProvider extends Widget 
{
	AbsolutePanel parentAbsPnl = null;
	VerticalPanel mainVerticalPanel = null;
	private Button viewCalendarBtn = null;
	private String objName = "";
	private AbsolutePanel absPanel = new AbsolutePanel();
	private E12PopupPanel popupPanel = null;
	private VerticalPanel calPanel = new VerticalPanel();
	private int popupWidth = 0;
	private String browDataDef = "";
	private String e12CalendarID = "";
	private String dispalyText = "";
	private Label downArrow = null;
	private String calendarFor = "";
	private ClickHandler clickHandler = null;
	private E12Calendar e12Calendar = null;
	//Changed by Pooja S on 18-oct-2019 [To open the Calendar Transaction from BROWSER]
	E12DataProviderComponent e12DataProviderComponent = null;
	private boolean chkBoxValue = false;
	
	/**
	 * 
	 */
	public VerticalPanel createArgumentPage( final E12TransInfoObj e12TransInfoObj ) 
	{
		if( E12Constants.userID != null )
		{
			try
			{
				objName = e12TransInfoObj.getObjName();
				//Changed by Pooja S on 18-oct-2019 [To open the Calendar Transaction from BROWSER]
				e12DataProviderComponent = E12DataProviderComponent.getInstance( objName );
				E12CommonUtils.printOnConsole("Inside create argument page objName ["+objName+"]");
				//calendarWidget.setIdObjName(objName);
				mainVerticalPanel = new VerticalPanel();
				
				String objTitle = e12TransInfoObj.getTitle();
				String objIcon = e12TransInfoObj.getIcon();
				final String menuIdStr = e12TransInfoObj.getId().trim();
				e12CalendarID = "calendarContainer_" + e12TransInfoObj.getId();
				parentAbsPnl = new AbsolutePanel();
				parentAbsPnl.getElement().setId("e12DataProvider-parentAbsPnl");
				parentAbsPnl.setStyleName( "calendarAbsPnl" );
				HorizontalPanel contentHeaderPanel = new HorizontalPanel();
				if( E12Global.isGalaxy() )
				{
					contentHeaderPanel.setStyleName("contentHeader");
					HTML contentHeaderHtml = new HTML( getHeaderTitle(objIcon, objTitle) );
					contentHeaderHtml.setStyleName("contentHeaderLbl");
					//Added by Nikita.S on 12-April-17[set theme color for Title of homescreen]Start
			        contentHeaderHtml.getElement().setId("contentHeaderLbl-"+objName);
			      //Added by Nikita.S on 12-April-17[set theme color for Title of homescreen]end
			        contentHeaderPanel.add(contentHeaderHtml);
				}
				else
				{
					contentHeaderPanel.getElement().setAttribute("style", "padding:10px;");
				}
				
				FlowPanel flPanel = new FlowPanel();
				flPanel.getElement().setId("sperNamePnl");
				Label dataForLbl;
				if(dataProviderType == DataProviderType.CALENDAR)
				{
					dataForLbl = new Label(E12Constants.constants.setShowCalFor());
				}
				else
				{
					dataForLbl = new Label(E12Constants.constants.setShowMapFor());
				}			
				dataForLbl.setStyleName("dataForLbl");
				
				Label dataFor = new Label();
				dataFor.setStyleName("dataFor");
				dataFor.getElement().setAttribute("id", "dataFor");
				dataFor.setVisible(true);
				
				downArrow = new Label("");
				clickHandler = new ClickHandler() 
				{
					@Override
					public void onClick(ClickEvent event) 
					{
						popupPanel = new E12PopupPanel(){
							@Override
							public void onClick(ClickEvent event) 
							{
								super.onClick(event);
								downArrow.setStyleName("cal-downArrow");
							}
						};
						popupPanel.clear();
						popupPanel.add(calPanel);
						popupPanel.setPopupPositionAndShow(new E12PopupPanel.PositionCallback() 
						{
							public void setPosition(int offsetWidth, int offsetHeight) 
							{
								int left = downArrow.getAbsoluteLeft();
								popupWidth = offsetWidth;
								left = left - offsetWidth - 18;
								//Change by Sandeep S. [To apply matellarize css] Start
								//popupPanel.setPopupPosition( ( left + 45 ), downArrow.getAbsoluteTop() + 7 );
								popupPanel.setPopupPosition( ( left + 38 ), downArrow.getAbsoluteTop() + 7 );
								popupPanel.show();
								downArrow.removeStyleName("cal-downArrow");
								downArrow.setStyleName("cal-downArrow-wht");
							}
						});
					}
				};

				if(popupPanel != null)
				{
					E12CommonUtils.printOnConsole("Pop pnl is not null in e12Data pro");
				}
				
				downArrow.addClickHandler(clickHandler);
				downArrow.setStyleName("cal-downArrow");
				downArrow.getElement().setAttribute("id", "cal-downArrow");
				
				if( !E12Global.isGalaxy() )
				{
					flPanel.getElement().setAttribute("style", "padding: 10px;");
				}
				flPanel.getElement().setAttribute("style", "float: right;");
				flPanel.add(dataForLbl);
				flPanel.add(dataFor);
				flPanel.add(downArrow);
				contentHeaderPanel.add(flPanel);
				
				parentAbsPnl.add(contentHeaderPanel);
				
				calPanel = new VerticalPanel();
				
				downArrow.getElement().setId("e12dataProvider-down");
				Window.addResizeHandler(new ResizeHandler() 
				{
					@Override
					public void onResize(ResizeEvent event) 
					{
						E12CommonUtils.printOnConsole("Resizing...");
						BaseE12.e12TransBrow.e12TabPanel.onResize();
						if( popupPanel != null && popupPanel.isShowing() )
						{
							popupPanel.removeFromParent();
							clickHandler.onClick(null);
						}
					}
				});
				
				HashMap<String, String> paramMap = new HashMap<String, String>();
				paramMap.put("calObjName", objName);
				paramMap.put("user", E12Constants.userID.trim());
				paramMap.put("ACTION", "DATA_PROVIDER_DOC" );
				paramMap.put("VIEW_MODE", "G");
				
				String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
				String url = E12Global.getHostUrl() + "/ibase/CalenderContolServlet?"+paramString;
				E12RequestBuilder requestBuilder = new E12RequestBuilder( E12RequestBuilder.GET, url);
				requestBuilder.sendRequest( "", new RequestCallback() 
				{
					@Override
					public void onResponseReceived(Request request, Response response) 
					{
						String responseStr = response.getText();
						if( responseStr != null &&  E12Global.getInstance().checkErrorException(response, 1) )
						{
							e12DataProviderComponent.requestParamMap.clear();
							e12DataProviderComponent.textboxList.clear();  //Added by Sagar B.
							Document dataProviderDoc = XMLParser.parse(responseStr);
							@SuppressWarnings("rawtypes")
							ArrayList dataProvdrsNameArrList = new ArrayList();
							com.google.gwt.xml.client.NodeList calendarForNodeList = dataProviderDoc.getElementsByTagName("CALENDAR_FOR");
							if( calendarForNodeList != null && calendarForNodeList.getLength() > 0 )
							{
								E12CommonUtils.printOnConsole("calendarFor ["+calendarFor+"]");
								if(calendarForNodeList.item(0).getFirstChild()!=null)
								{
									calendarFor = calendarForNodeList.item(0).getFirstChild().getNodeValue();
								}
								E12CommonUtils.printOnConsole("calendarFor ["+calendarFor+"]");
							}
									//.item(0).getFirstChild().getNodeValue();
							com.google.gwt.xml.client.NodeList dpNameNodeList = dataProviderDoc.getElementsByTagName("DATA_PROVIDER");
							int dpNameLen = dpNameNodeList.getLength();
							for (int ctr = 0; ctr < dpNameLen; ctr++ )
							{
								String dpName = dpNameNodeList.item(ctr).getAttributes().getNamedItem("DISPLAY_NAME").getNodeValue();
								dataProvdrsNameArrList.add( dpName );
							}
							
							@SuppressWarnings("rawtypes")
							ArrayList dataProvdrsIdArrList = new ArrayList();
							com.google.gwt.xml.client.NodeList providerIdNodeList = dataProviderDoc.getElementsByTagName("DATA_PROVIDER");
							int providerIdLen = providerIdNodeList.getLength();
							for (int ctr = 0; ctr < providerIdLen; ctr++ )
							{
								String dpName = providerIdNodeList.item(ctr).getAttributes().getNamedItem("PROVIDER_ID").getNodeValue();
								dataProvdrsIdArrList.add( dpName );
							}
							for ( int dpCtr = 0; dpCtr < dataProvdrsNameArrList.size(); dpCtr++ )
							{
								int rowCounter = 0;
								String dataProvider = (String) dataProvdrsNameArrList.get(dpCtr);
								String dataProviderId = (String) dataProvdrsIdArrList.get(dpCtr);

								ArrayList dataProvdrArrList = new ArrayList();
								HashMap dataProviderKeyName = new HashMap();
								HashMap dataProviderKeyValue = new HashMap();
								HashMap dataProviderDataType = new HashMap();

								com.google.gwt.xml.client.NodeList dataProviderNodeList = dataProviderDoc.getElementsByTagName("DATA_PROVIDER");
								int dataProviderLen = dataProviderNodeList.getLength();
								for (int ctr = 0; ctr < dataProviderLen; ctr++ )
								{
									String provID = dataProviderNodeList.item(ctr).getAttributes().getNamedItem("PROVIDER_ID").getNodeValue();
									String active = "";
									if ( dataProviderId.equalsIgnoreCase( provID ) )
									{
										com.google.gwt.xml.client.NodeList activeNodeList = dataProviderDoc.getElementsByTagName("ACTIVE");
										for(int i = 0; i < activeNodeList.getLength(); i++ )
										{
											String activeValue = activeNodeList.item(i).getAttributes().getNamedItem("NODE_ID").getNodeValue();
											if(activeValue != null && activeValue.equalsIgnoreCase(provID + "_DS_ACTIVE"))
											{
												active = activeValue;
												break;
											}
										}
										dataProviderKeyName.put(provID+"_DS_ACTIVE", "STATUS");
										dataProviderKeyValue.put(provID+"_DS_ACTIVE", active);
										
										com.google.gwt.xml.client.NodeList userArgsList = dataProviderDoc.getElementsByTagName("USER_ARGUMENTS");
										for(int i = 0; i < userArgsList.getLength(); i++ )
										{
											String argValue = userArgsList.item(i).getAttributes().getNamedItem("NODE_ID").getNodeValue();
											if(argValue != null && argValue.equalsIgnoreCase(provID + "_DS_UA"))
											{
												com.google.gwt.xml.client.NodeList userArgsNodeList = userArgsList.item(i).getChildNodes();
												int userArgsNodeListLen = userArgsNodeList.getLength();
												for (int innerCtr = 0; innerCtr < userArgsNodeListLen; innerCtr++ )
												{
													com.google.gwt.xml.client.Node innerNode = userArgsNodeList.item( innerCtr );
													if ( innerNode.getNodeType() == com.google.gwt.xml.client.Node.ELEMENT_NODE )
													{
														String usrArgName = innerNode.getAttributes().getNamedItem("DISPLAY_NAME").getNodeValue();
														String usrArgId = innerNode.getAttributes().getNamedItem("NODE_ID").getNodeValue();
														String dbType = innerNode.getAttributes().getNamedItem("DB_TYPE").getNodeValue();
														String usrArgVal = "";
														com.google.gwt.xml.client.NodeList childList = innerNode.getChildNodes();
														int noOfChilds = childList.getLength();
														for(int colCtr = 0; colCtr < noOfChilds; colCtr++)
														{
															com.google.gwt.xml.client.Node colNode = childList.item(colCtr);
															if(colNode != null && colNode.getNodeType() == com.google.gwt.xml.client.Node.ELEMENT_NODE)
															{
																if(colNode.getNodeName().equals("VALUE"))
																{
																	if(colNode.getFirstChild() != null)
																	{
																		usrArgVal = colNode.getFirstChild().getNodeValue();
																	}
																	break;
																}
															}
														}
														E12CommonUtils.printOnConsole("usrArgId: ["+usrArgId+"]\nusrArgName: ["+usrArgName+"]\nusrArgVal: ["+usrArgVal+"]");
														dataProviderKeyName.put(usrArgId, usrArgName);
														dataProviderKeyValue.put(usrArgId, usrArgVal);
														dataProviderDataType.put(usrArgId, dbType);
													}
												}
											}
										}
									}
									
								}
								E12CommonUtils.printOnConsole("dataProviderKeyName.size()="+dataProviderKeyName.size());
								E12CommonUtils.printOnConsole("dataProviderKeyValue.size()="+dataProviderKeyValue.size());
								dataProvdrArrList.add( dataProviderKeyName );
								dataProvdrArrList.add( dataProviderKeyValue );
								dataProvdrArrList.add(dataProviderDataType);
								E12CommonUtils.printOnConsole("dataProvdrArrList.size()="+dataProvdrArrList.size());
								
								HashMap dataPrvdrKeyNameMap = ( HashMap ) dataProvdrArrList.get( 0 );
								HashMap dataPrvdrKeyValMap = ( HashMap ) dataProvdrArrList.get( 1 );
								HashMap dataPrvdrdbTypeMap = ( HashMap ) dataProvdrArrList.get( 2 );
								Iterator iterator = dataPrvdrKeyNameMap.keySet().iterator();
								String dataPrvdrKeyCheckValue="";
								
								while(iterator.hasNext())
								{	
									String dataPrvdrKeyName = (String) iterator.next();
									String dataPrvdrName = e12DataProviderComponent.toInitCase(( String ) dataPrvdrKeyNameMap.get( dataPrvdrKeyName ));
									dataPrvdrKeyCheckValue = ( String ) dataPrvdrKeyValMap.get( dataPrvdrKeyName );
									E12CommonUtils.printOnConsole("dataPrvdrKeyName ["+dataPrvdrKeyName+"] dataPrvdrName ["+dataPrvdrName+"] dataPrvdrKeyCheckValue ["+dataPrvdrKeyCheckValue+"]");
									String dataPrvdrNameId = dataProvider+"_"+dataPrvdrName+"_chk";
									E12CommonUtils.printOnConsole("dataPrvdrNameId [ "+dataPrvdrNameId+" ]");
									if( dataPrvdrKeyName.indexOf("_DS_UA") > 0 )
									{
										String isUserArgument="present";														
									}
									String checkType = "text";
									String checkedStatus = "unChecked";
									
									if(dataPrvdrNameId.toUpperCase().indexOf("STATUS_CHK")!=-1)
									{
										checkType = "checkbox";
										if(dataPrvdrKeyCheckValue.equals("Y"))
										{
											checkedStatus = "checked";
										}
										else if(dataPrvdrKeyCheckValue.equals("N"))
										{	
											checkedStatus = "unChecked";
										}
										dataPrvdrName = "";
										E12CommonUtils.printOnConsole("*****************checkedStatus [ "+checkedStatus+" ]");
									}
								}
								
								Iterator iter = dataPrvdrKeyNameMap.keySet().iterator();
								while(iter.hasNext())
								{
									final String dataPrvdrKeyName = (String) iter.next();
									String dataPrvdrName = e12DataProviderComponent.toInitCase(( String ) dataPrvdrKeyNameMap.get( dataPrvdrKeyName ));
									String dataPrvdrdbType = ( String ) dataPrvdrdbTypeMap.get( dataPrvdrKeyName );
									E12CommonUtils.printOnConsole("dataPrvdrKeyName ["+dataPrvdrKeyName+"] dataPrvdrName ["+dataPrvdrName+"] dataPrvdrdbType ["+dataPrvdrdbType+"]");
									String dataPrvdrNameId =dataProvider+"_"+dataPrvdrName+"_inp";
									
									if(dataPrvdrNameId.toUpperCase().indexOf("STATUS_INP")==-1)
									{
										String[] strArr = dataPrvdrKeyName.split("UA_");
										final String fieldName = E12CommonUtils.checkNull( strArr[1] );
										String tempdataPrvdrKeyId = "Detail1.1."+ fieldName.toLowerCase();
										
										boolean isDateField = dataPrvdrdbType.equalsIgnoreCase("DATE");
										//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]Start
										boolean chkBoxFlag = dataPrvdrdbType.equalsIgnoreCase("CHKBOX");
										FlowPanel flowPanel = new FlowPanel();
										String txtBoxStyleName = "e12-TextBox";
										String txtBoxROStyleName = "e12-TextBox-readonly";
										
										final Label dataPrvdrNameLbl = new Label(dataPrvdrName);
										final Label dataPrvdrNameLbl2 = new Label("Member ID");
										dataPrvdrNameLbl2.getElement().setAttribute("style","padding-top:12px;");
										
										//dataPrvdrNameLbl.getElement().setAttribute("style","font-size:14px;padding-left:40px;margin-bottom:10px;");
										
										dataPrvdrNameLbl.setStyleName("argLabel");
										dataPrvdrNameLbl.addStyleName("header-label");
										//final E12TextBox dataProviderNameTxtbox = new E12TextBox();
										final E12MultiSelectTextBox dataProviderNameTxtbox = new E12MultiSelectTextBox();
										final E12DateBox dataProviderNameDatebox = new E12DateBox();

										DateTimeFormat dateFormat = DateTimeFormat.getFormat( E12Constants.dispDate );
										dataProviderNameDatebox.setStyleName("dateBoxStyle");
										dataProviderNameDatebox.addStyleName("responsivePnlWidth-map");
										dataProviderNameDatebox.addStyleName("gwtDateFieldEditor-map");
										
									//	dataProviderNameDatebox.getElement().setAttribute("style", "margin-top:30px;");
										dataProviderNameDatebox.setFormat( dateFormat );
										dataProviderNameDatebox.setValue( new Date() );
										dataProviderNameDatebox.getElement().setAttribute("id", tempdataPrvdrKeyId);
										dataProviderNameDatebox.getElement().setAttribute("name", tempdataPrvdrKeyId);
										//Added by Sagar B. to show only range date in date field[20-Jul-18]START
										/*if( fieldName.toLowerCase().contains("from_date") )
										{
											dataProviderNameDatebox.getDateBox().addValueChangeHandler(new ValueChangeHandler<Date>() 
											{
												@Override
												public void onValueChange(ValueChangeEvent<Date> event) 
												{
													setFromDate( event.getValue() );
												}
											});
										}
										
										if( fieldName.toLowerCase().contains("to_date") )
										{
											dataProviderNameDatebox.getDateBox().getDatePicker().addShowRangeHandler(new ShowRangeHandler<Date>() 
											{
												@Override
												public void onShowRange(ShowRangeEvent<Date> event) 
												{
													final Date fromDate = getFromDate();
													E12CommonUtils.printOnConsole("fromDate::["+fromDate+"]");
													if( fromDate != null )
													{
														Date d = zeroTime(event.getStart());
														while (d.before(fromDate))
														{
															dataProviderNameDatebox.getDateBox().getDatePicker().setTransientEnabledOnDates(false, d);
															d = nextDay(d);
														}
														
														final Date weekGap = oneWeek(fromDate);
														E12CommonUtils.printOnConsole("weekGap::["+weekGap+"]");
														Date d1 = zeroTime(event.getEnd());
														while( d1.after(weekGap) )
														{
															dataProviderNameDatebox.getDateBox().getDatePicker().setTransientEnabledOnDates(false, d1);
															d1 = previousDay(d1);
														}
													}
												}
											});
										}*/
										//Added by Sagar B. to show only range date in date field[20-Jul-18]END
										final Label readOnlyTxtbox = new Label();
										final Label readOnlyTxtboxLbl = new Label("Member Name");
										dataProviderNameTxtbox.setStylePrimaryName(txtBoxStyleName);
										//Added by Sagar B. on[26-Apr-18]START
										final Label popUpLbl = new Label();
										popUpLbl.getElement().setId("e12AdvSrch-popup");
										popUpLbl.setTitle(tempdataPrvdrKeyId );
										popUpLbl.setVisible(true);
									
										popUpLbl.setStyleName("pophelpImg");
										popUpLbl.addStyleName("icon-pophelp");
										popUpLbl.addClickHandler(new ClickHandler()
										{
											String popUpResStr = "";
											@Override
											public void onClick(ClickEvent event) 
											{
												StringBuilder reqParamStr1 =  buildRequestParams( 1 );
												E12CommonUtils.printOnConsole("E12DataProvider : objName["+objName+"]\n popUpBtn.getTitle()["+popUpLbl.getElement().getId()+"]\n dataProviderNameTxtbox.getValue()["+dataProviderNameTxtbox.getValue()+"]");
												popUpResStr = new E12PopUp().drawPopup(objName, 1, popUpLbl.getTitle(), dataProviderNameTxtbox.getValue(), reqParamStr1.toString(),dataProviderNameTxtbox);

											}
										});
										//Added by Sagar B. on[26-Apr-18]END
										final PophelpSuggestOracle pophelpSuggest = new PophelpSuggestOracle( fieldName )
										{
											@Override
											public void requestSuggestions( Request request, Callback callback) 
											{
												setQueryPath( e12DataProviderComponent.buildAutoCompleteURL( fieldName, objName ) );
												setSearchQuery( null );
												super.requestSuggestions(request, callback);
											}
										};
										pophelpSuggest.setAutoFillLen(2);
										//pophelpSuggest.setQueryPath( buildAutoCompleteURL( fieldName ) );
										final SuggestBox suggestBox = new SuggestBox(pophelpSuggest, dataProviderNameTxtbox);
										((DefaultSuggestionDisplay)suggestBox.getSuggestionDisplay()).setSuggestionListHiddenWhenEmpty(true);
										((DefaultSuggestionDisplay)suggestBox.getSuggestionDisplay()).setPopupStyleName("e12-SuggestBoxPopup");
										
										suggestBox.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>() {
											@Override
											public void onSelection(SelectionEvent<Suggestion> event) {
												E12CommonUtils.printOnConsole("Display String[" + event.getSelectedItem().getDisplayString() + "]" +
												" Replacement String[" + event.getSelectedItem().getReplacementString() + "] calendarFor["+calendarFor+"]");
												
												if(calendarFor != null && !"".equalsIgnoreCase( calendarFor ) )
												{
													dispalyText = event.getSelectedItem().getDisplayString();
													//Added by Sagar B. on[25-Apr-18]START
													E12CommonUtils.printOnConsole("DisplayText:::["+dispalyText+"]");
													if( dispalyText != null && dispalyText.indexOf(">") > 0 )
													{
														dispalyText = dispalyText.substring(dispalyText.indexOf(">")+1);
													}
													E12CommonUtils.printOnConsole(" DisplayText:::["+dispalyText+"]");
													//Added by Sagar B. on[25-Apr-18]END
													String[] calendarForArr = calendarFor.split(","); 
													int size = calendarForArr.length;
													E12CommonUtils.printOnConsole("SIZE ["+size+"]");
													if( dispalyText != null && !"".equalsIgnoreCase( dispalyText ) )
													{
														//Added By Nilesh Start for Campm track suggestion Start :: 04-07-19
														if(dispalyText.indexOf("BoxValue\">") !=-1)
														{	
															String check ="BoxValue\">";
															int lenght = check.length();
															dispalyText=dispalyText.substring(dispalyText.lastIndexOf("BoxValue\">")+lenght, dispalyText.lastIndexOf("</span>"));
														}
														E12CommonUtils.printOnConsole(" NIL **** dispalyText ["+dispalyText+"]");
														//Added By Nilesh Start for Campm track suggestion End :: 04-07-19
														
														String[] textArr = dispalyText.split("-");
														if( textArr.length > size )
														{
															dispalyText = "";
															if(dataProviderType == DataProviderType.CALENDAR)
															{
																for(int i = 1; i <= size; i++ )
																{
																	dispalyText = dispalyText + " "+ textArr[i];
																}
															}
															else
															{
																for(int i = 0; i <= size+1; i++ )
																{
																	if(i%2 != 0)continue;
																	if(!textArr[i+2].trim().equals(""))
																	if(dispalyText.equals(""))
																		dispalyText = dispalyText +textArr[i+2].trim();
																	else
																		dispalyText = dispalyText +","+textArr[i+2].trim();																	
																}
															}
															E12CommonUtils.printOnConsole("dispalyText ["+dispalyText+"]");
															readOnlyTxtbox.setText(dispalyText.trim());
														}
													}
												}
												else
												{
													dispalyText = "";
													readOnlyTxtbox.setText(dispalyText.trim());
												}
											}
										});										
										suggestBox.getTextBox().addFocusHandler(new FocusHandler() {
											@Override
											public void onFocus(FocusEvent event) {
												suggestBox.showSuggestionList();
											}
										});
										
										dataProviderNameTxtbox.getElement().setAttribute("id", tempdataPrvdrKeyId);
										dataProviderNameTxtbox.getElement().setAttribute("name", tempdataPrvdrKeyId);
										// dataProviderNameTxtbox.setValue(E12Constants.userID.trim()); commented & added changes as suggested by gulzar 01-SEP-2023 
										dataProviderNameTxtbox.setValue(E12Constants.empCode.trim());
										dataProviderNameTxtbox.addStyleName("cal-txtBox");
										
										readOnlyTxtbox.getElement().setAttribute("name", tempdataPrvdrKeyId+"_name");
										readOnlyTxtbox.getElement().setAttribute("id", tempdataPrvdrKeyId+"_name");
										dispalyText = E12Constants.empName.trim();
										readOnlyTxtbox.setText(E12Constants.empName.trim());
										
										E12CommonUtils.printOnConsole(" *** tempdataPrvdrKeyId Name  "+tempdataPrvdrKeyId+"_name");
										//Added By Nilesh for showing Name from pophelp Start :: 23-12-19
										if ( ! dataPrvdrName.equalsIgnoreCase("Holiday") )
										{	 
											e12DataProviderComponent.showingArgumentName = tempdataPrvdrKeyId+"_name";
										}
										//Added By Nilesh for showing Name from pophelp End :: 23-12-19
										//readOnlyTxtbox.setStylePrimaryName( txtBoxROStyleName );
										//readOnlyTxtbox.addStyleName( "disabled-field" );
										//readOnlyTxtbox.addStyleName("gwtTextFieldEditor");
										//readOnlyTxtbox.getElement().setAttribute("style", "padding: 27px 5px 0 0 !important; line-height: 1 !important;");
										//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]Start
										final CheckBox chkBox = new CheckBox();
										chkBox.getElement().setAttribute("id", tempdataPrvdrKeyId);		//Added by Sagar B. on[17-Apr-19]
										setCheckBoxValueInJS(false, chkBox.getElement().getId());		//Added by Sagar B. on[17-Apr-19]
										{
											chkBox.addDomHandler(new ClickHandler() {

												@Override
												public void onClick(ClickEvent event) {
													E12CommonUtils.printOnConsole("------- 333 ----Click of date----");
													
													boolean flag = chkBox.getValue();
													E12CommonUtils.printOnConsole("flag123["+flag+"]");
													//setCheckBoxValue( flag );
													setCheckBoxValueInJS(flag, chkBox.getElement().getId());		//Added by Sagar B. on[17-Apr-19]
														//event.preventDefault();
												}

											}, ClickEvent.getType());
										}
										
										//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]End
										
										if( isDateField )
										{
											e12DataProviderComponent.textboxList.add(dataProviderNameDatebox);
										}
										else if( chkBoxFlag )
										{
											e12DataProviderComponent.textboxList.add(chkBox);
										}
										else
										{
											e12DataProviderComponent.textboxList.add(dataProviderNameTxtbox);
										}

										dataProviderNameTxtbox.addBlurHandler(new BlurHandler() 
										{
											@Override
											public void onBlur(BlurEvent event) 
											{
												String val = dataProviderNameTxtbox.getValue();
												if( val== null || "".equalsIgnoreCase( val ) )
												{
//													dataProviderNameTxtbox.removeStyleName("cal-txtBox-valid");
													//dataPrvdrNameLbl.removeStyleName("labelflickerFixPosition");
													dataPrvdrNameLbl2.removeStyleName("labelflickerFixPosition");
												}
												else
												{
//													dataProviderNameTxtbox.removeStyleName("cal-txtBox-valid");
//													dataProviderNameTxtbox.addStyleName("cal-txtBox-valid");
													/*dataPrvdrNameLbl.removeStyleName("labelflickerFixPosition");
													dataPrvdrNameLbl.addStyleName("labelflickerFixPosition");*/
													dataPrvdrNameLbl2.removeStyleName("labelflickerFixPosition");
													dataPrvdrNameLbl2.addStyleName("labelflickerFixPosition");
												}
											}
										});
										
										
										String value = E12CommonUtils.checkNull( dataProviderNameTxtbox.getValue() );
										if( value== null || "".equalsIgnoreCase( value ) )
										{
//											dataProviderNameTxtbox.removeStyleName("cal-txtBox-valid");
											//dataPrvdrNameLbl.removeStyleName("labelflickerFixPosition");
											dataPrvdrNameLbl2.removeStyleName("labelflickerFixPosition");
										}
										else
										{
//											dataProviderNameTxtbox.removeStyleName("cal-txtBox-valid");
//											dataProviderNameTxtbox.addStyleName("cal-txtBox-valid");
											/*dataPrvdrNameLbl.removeStyleName("labelflickerFixPosition");
											dataPrvdrNameLbl.addStyleName("labelflickerFixPosition");*/
											dataPrvdrNameLbl2.removeStyleName("labelflickerFixPosition");
											dataPrvdrNameLbl2.addStyleName("labelflickerFixPosition");
											
										}
										
										
										dataProviderNameTxtbox.addFocusHandler(new FocusHandler() {
											
											@Override
											public void onFocus(FocusEvent event) {
												E12CommonUtils.printOnConsole("=== inside focusHandler of dataProviderNameTxtbox === ");
												//dataPrvdrNameLbl.addStyleName("labelflickerFixPosition");
												dataPrvdrNameLbl2.addStyleName("labelflickerFixPosition");
											}
										});
										
										E12CommonUtils.printOnConsole("dataPrvdrKeyName=== "+dataPrvdrKeyName);
										//requestParamMap.put(dataPrvdrKeyName, dataProviderNameTxtbox.getValue());
										//Changed By Suraj for materiliased css
										//dataPrvdrNameLbl.addStyleName("floatLeft");
										//readOnlyTxtbox.addStyleName("floatLeft");
										HorizontalPanel hpanel = new HorizontalPanel();
										if( isDateField )
										{
											e12DataProviderComponent.requestParamMap.put(dataPrvdrKeyName, dataProviderNameDatebox.getValue());
											dataProviderNameDatebox.setStyleName("dateBoxStyle");
											dataProviderNameDatebox.addStyleName("responsivePnlWidth-map");
											dataProviderNameDatebox.addStyleName("gwtDateFieldEditor-map");
											hpanel.add(dataProviderNameDatebox);
										}//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]
										else if( chkBoxFlag )
										{
											chkBox.addStyleName("responsivePnlWidth-map");
											hpanel.add(chkBox);
										}
										else
										{
											e12DataProviderComponent.requestParamMap.put(dataPrvdrKeyName, dataProviderNameTxtbox.getValue());
											suggestBox.setStyleName("gwtTextFieldEditor");
											suggestBox.getElement().setAttribute("style", "padding: 19px 5px 0 0 !important;");
											hpanel.add(suggestBox);
											//Added by Sagar B. on[26-Apr-18]START
											hpanel.add(popUpLbl);
											hpanel.setCellVerticalAlignment(popUpLbl, HasVerticalAlignment.ALIGN_BOTTOM);
											//Added by Sagar B. on[26-Apr-18]END
										}
										
										if(getDataProviderType() == DataProviderType.CALENDAR)
										{
											suggestBox.setStyleName("gwtTextFieldEditor");
											suggestBox.getElement().setAttribute("style", "padding: 16px 5px 0 0 !important;");
											//hpanel.add(suggestBox);
										}
										//Changed By Suraj for materiliased css
//										hpanel.addStyleName("floatLeft");
										if(getDataProviderType() == DataProviderType.CALENDAR)
										{
											/*dataPrvdrNameLbl.setStyleName("gwtLabelflickerEditor");
											dataPrvdrNameLbl.addStyleName("labelflickerFixPosition");*/
											dataPrvdrNameLbl2.setStyleName("gwtLabelflickerEditor");
											dataPrvdrNameLbl2.addStyleName("labelflickerFixPosition");
											//dataPrvdrNameLbl.getElement().setAttribute("style","margin-top: 8px !important;");
											dataPrvdrNameLbl2.getElement().setAttribute("style","margin-top: 13px !important;");
											flowPanel.add(dataPrvdrNameLbl);
											flowPanel.add(dataPrvdrNameLbl2);
											flowPanel.add(hpanel);
										}
										else
										{
											e12DataProviderComponent.argFlxTbl.setWidget( rowCounter, 0, dataPrvdrNameLbl );
											dataPrvdrNameLbl.setStyleName("gwtLabelflickerEditor-map");
											dataPrvdrNameLbl.addStyleName("labelflickerFixPosition");
											//nikita
											//e12DataProviderComponent.argFlxTbl.setWidget( rowCounter, 1, dataPrvdrNameLbl2 );
											e12DataProviderComponent.argFlxTbl.setWidget( rowCounter, 1, hpanel );
											rowCounter++; 
										}
										//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]Start
										if( chkBoxFlag )
										{
											dataPrvdrNameLbl.getElement().setAttribute("style", "padding-left: 24px; padding-top: 10px;");
										}
										//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]End
										FlowPanel flowPanel2 = new FlowPanel();
										//Changed By Suraj for materilized css
										//readOnlyTxtbox.getElement().setAttribute("style", "margin-left: 102px;");
										//readOnlyTxtbox.getElement().setAttribute("style", "margin-left: 102px;");
										if(! isDateField)
										{  
											readOnlyTxtboxLbl.setStyleName("gwtLabelflickerEditor");
											readOnlyTxtboxLbl.addStyleName("labelflickerFixPosition");
											readOnlyTxtboxLbl.getElement().setAttribute("style","margin-top: 21px !important;");
											flowPanel2.add(readOnlyTxtboxLbl);
											flowPanel2.add(readOnlyTxtbox);
										}
										
											flowPanel2.add(readOnlyTxtbox);
											readOnlyTxtbox.setStylePrimaryName( txtBoxROStyleName );
											readOnlyTxtbox.addStyleName( "disabled-field" );
											readOnlyTxtbox.addStyleName("gwtTextFieldEditor");
											readOnlyTxtbox.getElement().setAttribute("style", "padding: 27px 5px 0 0 !important; line-height: 1 !important;");
										
										if(getDataProviderType() == DataProviderType.CALENDAR)
										{
											if( calPanel.getWidgetCount() <= 1 )
											{
												calPanel.add(flowPanel);
												calPanel.setSpacing(6);
												calPanel.add(flowPanel2);
											}
											break;
										}
									}
								}
							}
							
							//Added By Suraj on 08/02/2016 [W15HSUN005 - To get objNames from data provider as per Danish Sir]Start 
							if (dataProviderDoc.getElementsByTagName("CURR_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.currentAppObjName = dataProviderDoc.getElementsByTagName("CURR_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}
							if (dataProviderDoc.getElementsByTagName("PREV_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.pastAppObjName = dataProviderDoc.getElementsByTagName("PREV_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}
							if (dataProviderDoc.getElementsByTagName("AFTER_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.futureAppObjName = dataProviderDoc.getElementsByTagName("AFTER_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}
							if (dataProviderDoc.getElementsByTagName("SINGLE_APPOINMENT_DP").getLength() > 0) 
							{
								e12DataProviderComponent.singleAppObjName = dataProviderDoc.getElementsByTagName("SINGLE_APPOINMENT_DP").item(0).getFirstChild().getNodeValue();
							}							
							//Added By Suraj on 08/02/2016 [W15HSUN005 - To get objNames from data provider as per Danish Sir]End
							if (dataProviderDoc.getElementsByTagName("plan_objType").getLength() > 0) 
							{
								e12DataProviderComponent.plan_objType = dataProviderDoc.getElementsByTagName("plan_objType").item(0).getFirstChild().getNodeValue();
							}
							//Added by Pooja S on 16-oct-2019 [To open calendar transaction form browser] Start
							if (dataProviderDoc.getElementsByTagName("DEF_COL_NAME").getLength() > 0) 
							{
								e12DataProviderComponent.defaultColumnName = dataProviderDoc.getElementsByTagName("DEF_COL_NAME").item(0).getFirstChild().getNodeValue();
							}
							//Added by Pooja S on 16-oct-2019 [To open calendar transaction form browser] End
							//Added by Suraj on 19-01-2017 [To read Calendar DBR metadata name]Start
							if (dataProviderDoc.getElementsByTagName("FLOATING_DB").getLength() > 0) 
							{
								E12Constants.calDBRName = dataProviderDoc.getElementsByTagName("FLOATING_DB").item(0).getFirstChild().getNodeValue();
							}
							else
							{
								E12Constants.calDBRName = "";
							}
							//Added by Suraj on 19-01-2017 [To read Calendar DBR metadata name]End
							
							if(getDataProviderType() == DataProviderType.MAP)
							{
								calPanel.add( e12DataProviderComponent.argFlxTbl );
							}
							calPanel.getElement().setAttribute("id", "calendarPanel");
							absPanel.setStyleName("calendarContainer");
							absPanel.getElement().setAttribute("id", e12CalendarID);
							absPanel.setHeight("100%");

							parentAbsPnl.add(absPanel);
							//Changed By Suraj for Calendar DBR floating area
							E12CommonUtils.getInstance().setParentAbsPnl(parentAbsPnl);
							mainVerticalPanel.add(parentAbsPnl);
							TextBox tabIdTxtBx = new TextBox();
							tabIdTxtBx.setText(menuIdStr);
							tabIdTxtBx.setVisible( false );
							tabIdTxtBx.setHeight("0px");

							mainVerticalPanel.add( tabIdTxtBx );
							if(dataProviderType == DataProviderType.CALENDAR)
							{
								e12DataProviderComponent.getUserRights( objName , new Callback<String, String>() {
									@Override
									public void onSuccess(String result) {
										createViewDataButton(result);
									}
									
									@Override
									public void onFailure(String reason) {}
								});
							}
							else
							{
								viewCalendarBtn = new Button("View");
								if( E12Global.isGalaxy() )
								{
									viewCalendarBtn.setStyleName("galaxyButton-map");
									
									//viewCalendarBtn.addStyleName("galaxyButton");
								}
								else
								{
									viewCalendarBtn.setStyleName("button green-Btn e12SearchOption-footer-btns");
								}
								//viewCalendarBtn.getElement().setAttribute("style", "margin-top: 10px;");
								//viewCalendarBtn.getElement().setAttribute("style", "margin-top: 22px; background-color:#FF7F50; color:#fff");
								//viewCalendarBtn.getElement().setAttribute("style", "margin-left:48px;width:76px");
								viewCalendarBtn.addStyleName("CalendarBtn");
								//viewCalendarBtn.getElement().setAttribute("style", "background-color:#FF8000;color:#fff;");
								calPanel.add(viewCalendarBtn);
								if(dataProviderType == DataProviderType.CALENDAR)
								{
									viewCalendarBtn.setStyleName("galaxyButton-map");
								}
								else if(getDataProviderType() == DataProviderType.MAP)
								{
									viewCalendarBtn.setStyleName("galaxyButton-map");
									viewCalendarBtn.addStyleName("MapBtn");
								}
								viewCalendarBtn.addClickHandler(new ClickHandler() 
								{
									@Override
									public void onClick(ClickEvent event) 
									{
										E12CommonUtils.printOnConsole("calling draw MAP method");
										String mapId = e12TransInfoObj.getId();
										DOM.getElementById("dataFor").setInnerHTML(dispalyText);
										//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]
										//setCheckBoxValueInJS( getCheckBoxValue() );		//Commented by Sagar B. on[17-Apr-19]
										e12DataProviderComponent.drawMap( popupPanel, absPanel, mapId, objName, clickHandler );
									}
								});
								clickHandler.onClick(null);
							}
						}
					}
					
					@Override
					public void onError(Request request, Throwable exception) 
					{
						Window.alert("Exception:"+exception.getMessage());
					}
				});
			}
			catch (Exception e) 
			{
				Window.alert("Exception: "+e.getMessage());
			}
		}
		E12CommonUtils.printOnConsole("Returning mainVerticalPanel");
		return mainVerticalPanel;
	}
	
	public void createViewDataButton( String title )
	{
		E12CommonUtils.printOnConsole("Called new method create viewData button");
		 viewCalendarBtn = new Button(title);
			if( E12Global.isGalaxy() )
			{
				viewCalendarBtn.setStyleName("galaxyButton-map");
			}
			else
			{
				viewCalendarBtn.setStyleName("button green-Btn e12SearchOption-footer-btns");
			}
			//viewCalendarBtn.getElement().setAttribute("style", "margin-top: 10px; float: none;");
			viewCalendarBtn.getElement().setAttribute("style", "margin-top: 21px; float: none;");
			viewCalendarBtn.addStyleName("CalendarBtn");
			//viewCalendarBtn.getElement().setAttribute("style", "background-color:#FF7F50;color:#fff;");
			calPanel.add(viewCalendarBtn);
			//calPanel.setCellVerticalAlignment(viewCalendarBtn, HasVerticalAlignment.ALIGN_MIDDLE);
			calPanel.setCellHorizontalAlignment(viewCalendarBtn, HasHorizontalAlignment.ALIGN_CENTER);

			viewCalendarBtn.getElement().setId("e12dataProvider-calendar");
			viewCalendarBtn.addClickHandler(new ClickHandler() 
			{
				@Override
				public void onClick(ClickEvent event) 
				{
					E12CalendarUtility.printOnConsole("319 drwaing calendar");
					//Added By Nilesh for showing Name from pophelp Start :: 23-12-19
					String showingArgumentName = E12CalendarUtility.checkNull(E12DataProviderComponent.getInstance( objName ).showingArgumentName);
					
					E12CalendarUtility.printOnConsole("e12dataProvider showingArgumentName browser -- ["+showingArgumentName+"]+["+showingArgumentName+"]");
					if( ! E12UserInfo.getCallerInterface().equalsIgnoreCase("MOBILE") )
					{
						E12CalendarUtility.printOnConsole("showingName e12dataProvider ------ "+DOM.getElementById(showingArgumentName) );
						if ( DOM.getElementById(showingArgumentName)  == null )
						{
							E12CalendarUtility.printOnConsole("showingName ");
							DOM.getElementById("dataFor").setInnerHTML(dispalyText);
						}
						else
						{
							String argumentValueName = DOM.getElementById(showingArgumentName).getInnerText();
							E12CalendarUtility.printOnConsole("showingName Tab is pressed before broswser argumentValueName "+argumentValueName);
							DOM.getElementById("dataFor").setInnerHTML(argumentValueName);
						}
						
					}
					else
					{	
						E12CalendarUtility.printOnConsole("e12dataProvider nilesh else  -- ["+showingArgumentName+"]+["+showingArgumentName+"]");
						DOM.getElementById("dataFor").setInnerHTML(dispalyText);
					}
					//Added By Nilesh for showing Name from pophelp End :: 23-12-19
					//calendarWidget.setIdObjName(objName);
					e12DataProviderComponent.drawCalendar( popupPanel, absPanel, objName, calPanel, e12CalendarID );
				}
			});
			
			try
			{
				HashMap<String, String> pMap = new HashMap<String, String>();
				pMap.put("calObjName", objName);
				pMap.put("ACTION", "GET_BROW_DATA_DEF" );
				pMap.put("VIEW_MODE", "G");
				
				String pString = E12CommonUtils.getInstance().getEncodedParamString(pMap);
				String url1 = E12Global.getHostUrl() + "/ibase/CalenderContolServlet?"+pString;
				E12RequestBuilder requestBuilder1 = new E12RequestBuilder( E12RequestBuilder.GET, url1);
				//Added by pooja on 3-11-2019
				requestBuilder1.setLoadingRequired(false);
				requestBuilder1.sendRequest( "", new RequestCallback() 
				{
					@Override
					public void onResponseReceived(Request request, Response response) 
					{
						String responseStr = response.getText();
						E12CalendarUtility.printOnConsole("340 responseStr ["+responseStr+"] browDataDef ["+browDataDef+"]");
						if( responseStr != null &&  E12Global.getInstance().checkErrorException(response, 1) )
						{
							browDataDef = responseStr;
						}
						if( browDataDef != null && browDataDef.equalsIgnoreCase("Y"))
						{
							E12CalendarUtility.printOnConsole("346 GET_BROW_DATA_DEF");
							DOM.getElementById("dataFor").setInnerHTML(dispalyText);
							e12DataProviderComponent.drawCalendar( popupPanel, absPanel, objName, calPanel, e12CalendarID );
						}
						else
						{
							E12CommonUtils.printOnConsole("browDataDef = "+browDataDef);
							clickHandler.onClick(null);
						}
					}

					@Override
					public void onError(Request request, Throwable exception) 
					{
						Window.alert("Exception:"+exception.getMessage());
					}
				});
			}
			catch (Exception e) 
			{
				Window.alert( "Error while getting object details: " + e.getMessage());
			}
	}
	
	/**
	 * 
	 * @param menuImage
	 * @param menuTitle
	 * @return
	 */
	private String getHeaderTitle(String menuImage, String menuTitle)
	{
		StringBuilder htmlString = new StringBuilder();
		if(menuImage != null && menuImage.indexOf("/") == -1 ) //menuImage with no specific path
		{
			// Added by Pankaj R on 17-Sep to show white icon on homePage.[START]
			/*if(menuImage.indexOf(".png") > 0)
			{
				menuImage = menuImage.substring(0, menuImage.indexOf(".png"));
				System.out.println(menuImage);
				menuImage = menuImage+"wht.png";
			}*/
			// Added by Pankaj R on 17-Sep to show white icon on homePage.[END]
		    //changed by vishal pathare on 13.10.16[for Adding interface in menuImages]Start
			String uxInterface=E12Constants.uxInterface;
			menuImage = "/ibase/images/menuImages/web/" + uxInterface+ "/" +menuImage; 
			//menuImage = "/ibase/images/menuImages/web/" + menuImage; 
			//changed by vishal pathare on 13.10.16[for Adding interface in menuImages]End
		}
		E12CommonUtils.printOnConsole("MenuImage Path::[ "+menuImage+" ]");
		//htmlString.append( "<img src='" + menuImage + "' onerror=\" this.src= '/ibase/images/menuImages/errMenu.png' \" style='position: absolute; margin-left: -16px; height: 20px; width: 20px;'> ");
		//Change by Sandeep S. [To apply matellarize css] End
		//htmlString.append( "&nbsp;&nbsp;" + menuTitle );
		//htmlString.append( "<div style = 'height: 24px; width: 24px;'><img class = 'contentHeaderImg-"+E12Constants.applicationColor+"' src='" + menuImage + "' onerror=\" this.src= 'images/errMenu.png' \" style='position: absolute; height: 16px; width: 16px; border-radius: 6px; padding: 3px; '></div> ");
		htmlString.append( "<div style = 'height: 24px; width: 24px;'><img class = 'contentHeaderImg' src='" + menuImage + "' onerror=\" this.src= 'images/errMenu.png' \" ></div> ");
		htmlString.append( "<div class = 'contentHeaderLbl-default'>" + menuTitle +"</div>");
		return htmlString.toString();
	}

	/**
	 * @author base71
	 * set enum to check DataProviderType
	 */
	public static enum DataProviderType
	{
		CALENDAR,
		MAP
	}
	protected DataProviderType dataProviderType;
	
	/**
	 *  set DataProvider Type 
	 * @param dataProviderType
	 */
	public void setDataProviderType(DataProviderType dataProviderType) {
		this.dataProviderType = dataProviderType;
	}
	
	/**
	 * get type of data provider
	 * @return dataProviderType
	 */
	public DataProviderType getDataProviderType() {
		return dataProviderType;
	}
	//Added by Sagar B. on[26-Apr-18]START
	/**
	 * It is used to build the xml and send to the server in http request.
	 * @param formNo
	 * @return reqParamStr.
	 */
	private StringBuilder buildRequestParams(int formNo)
	{
		StringBuilder reqParamStr = new StringBuilder("");
		
		List<Widget> txtBoxList = e12DataProviderComponent.textboxList;
		int count =  txtBoxList.size();
		
		final StringBuilder xmlStrgToServ = new StringBuilder("");
		StringBuffer xmlStringBufHeader = new StringBuffer( "<?xml version='1.0' encoding='UTF-8'?>" );
		xmlStringBufHeader.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><description>Header0 members</description>");

		StringBuffer xmlStringBufFooter = new StringBuffer( "</Header0>" );
		xmlStringBufFooter.append("</group0>").append("</DocumentRoot>");
		xmlStrgToServ.append("<Detail" + formNo +" objContext=\"" + formNo + "\" objName=\"" + objName + "\" domID=\"" + ( /*currDomID*/ 1 )   + "\" dbID=\"\" selected=\"Y\" >");
		xmlStrgToServ.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
		
		for( int ctr = 0 ; ctr < count ; ctr++ )
		{
			if (txtBoxList.get( ctr ) instanceof TextBox )
			{
				E12CommonUtils.printOnConsole("This is TextBox");
				TextBox txtBox = (TextBox)txtBoxList.get( ctr );;
				xmlStrgToServ.append("<"+txtBox.getElement().getId().substring(txtBox.getElement().getId().lastIndexOf(".")+1)+">");
				xmlStrgToServ.append("<![CDATA[");
				xmlStrgToServ.append(txtBox.getText());
				xmlStrgToServ.append("]]>");
				xmlStrgToServ.append("</"+txtBox.getElement().getId().substring(txtBox.getElement().getId().lastIndexOf(".")+1)+">");
			}
			else if (txtBoxList.get( ctr ) instanceof SuggestBox )
			{
				E12CommonUtils.printOnConsole("This is SuggestBox");
				SuggestBox suggesttxtBox = (SuggestBox)txtBoxList.get( ctr );;
				TextBox txtBox = (TextBox) suggesttxtBox.getTextBox();
				xmlStrgToServ.append("<"+txtBox.getElement().getId().substring(txtBox.getElement().getId().lastIndexOf(".")+1)+">");
				xmlStrgToServ.append("<![CDATA[");
				xmlStrgToServ.append(txtBox.getText());
				xmlStrgToServ.append("]]>");
				xmlStrgToServ.append("</"+txtBox.getElement().getId().substring(txtBox.getElement().getId().lastIndexOf(".")+1)+">");
			}
			else if (txtBoxList.get( ctr ) instanceof E12MultiSelectTextBox )
			{
				E12CommonUtils.printOnConsole("This is E12MultiSelectTextBox");
				E12MultiSelectTextBox txtBox = (E12MultiSelectTextBox)txtBoxList.get( ctr );;
				xmlStrgToServ.append("<"+txtBox.getElement().getId().substring(txtBox.getElement().getId().lastIndexOf(".")+1)+">");
				xmlStrgToServ.append("<![CDATA[");
				xmlStrgToServ.append(txtBox.getValue());
				xmlStrgToServ.append("]]>");
				xmlStrgToServ.append("</"+txtBox.getElement().getId().substring(txtBox.getElement().getId().lastIndexOf(".")+1)+">");
			}
		}
		xmlStrgToServ.append("</Detail" + formNo + ">");
		reqParamStr.append(xmlStringBufHeader).append(xmlStrgToServ).append(xmlStringBufFooter);
		return reqParamStr;
	}
	//Added by Sagar B. on[26-Apr-18]END
	//Added by Sagar B. to show only range date in date field[20-Jul-18]START
	/*private static Date fromDate = null; 
	public static Date getFromDate() {
		return fromDate;
	}

	public static void setFromDate(Date fromDate) {
		E12DataProvider.fromDate = fromDate;
	}

	private static Date zeroTime(final Date date)
	{
	    return DateTimeFormat.getFormat("yyyyMMdd").parse(DateTimeFormat.getFormat("yyyyMMdd").format(date));
	}

	private static Date nextDay(final Date date)
	{
	    return zeroTime(new Date(date.getTime() + (24 * 60 * 60 * 1000)));
	}
	
	private static Date previousDay(final Date date)
	{
	    return zeroTime(new Date(date.getTime() - (24 * 60 * 60 * 1000)));
	}
	
	private static Date oneWeek(final Date date)
	{
	    return zeroTime(new Date(date.getTime() + (7 * 24 * 60 * 60 * 1000)));
	}*/
	//Added by Sagar B. to show only range date in date field[20-Jul-18]END
	
	//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]Start
	private void setCheckBoxValue(boolean flag)
	{
		this.chkBoxValue = flag;
	}
	
	private boolean getCheckBoxValue()
	{
		return this.chkBoxValue;
	}
	
	public native void setCheckBoxValueInJS(boolean flag, String id)
	/*-{
		try
		{
			$wnd.customLog("Hi setCheckBoxValueInJS called");
			if( id == "Detail1.1.order_of_visit" )
			{
				$wnd.orderOfVisitFlag = flag;
			}
			else if( id == "Detail1.1.show_travel_path" )
			{
				$wnd.showTravelPathFlag = flag;
			}
		}
		catch(e)
		{
			$wnd.customLog("E12DataProvider : setCheckBoxValueInJS :: Exception in native method ["+e.message+"]");
		}
	}-*/;
	//added by vishal pathare on 18.9.18 for[order of visit wise marker should display]End
	
}
