package ibase.webitm.bean.wsfa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import ibase.webitm.utility.wsfa.Utilities; 
import ibase.webitm.utility.wsfa.encry_decry;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.wsfa.DBOperations;
import ibase.webitm.utility.wsfa.DateObject;
import ibase.webitm.utility.wsfa.PermissionDeniedException;

/**
 * This class is handles all the Login related Queries like checking password and 
   the random number issues

 * @author 	Avinash Deshmukh
 * @version 	1.0
 * @since March 2,2002
 * History OF change
 * Date           Person       Change  
 * March 7,2002   Avinash      The name of the table from "SUN_USER" TO "USERS" 
 */

public class LoginManager 
{
	private String salesCode;
	private UserInfoBean userInfo;
	private Connection con = null;

	/** 
	 * This method authenticates the user.It checks the password . If password is correct then it returns
	   the sales code of the employee.It throws the PermissionDeniedException if password does not match 
	   or user does not exist 
	 *
	 * @param   connection   
	 * @param   String LoginID 
	 * @param   String password 
	 *
	 *@return String sales code
	 */
	public LoginManager( UserInfoBean userInfo ) throws Exception
	{
		this.userInfo = userInfo;
		/*try
		{
			//con = connect;
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB( userInfo.getTransDB() );
		}
		catch(Exception e)
		{
			throw e;
		}*/
	}

	/*public LoginManager() throws Exception
	{
		try
		{
			if ( con == null )
			{
				DBConnection dbCon = new DBConnection();
				con = dbCon.getConnection();
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}*/
	
	public String checkPassword (String loginID,String passwd) throws PermissionDeniedException,Exception
	{	
		//System.out.println("LoginManager : Entering into checkpassword..");
		ResultSet rs = null;
		ResultSet rs1=null;
		Statement stmt = null;
		Statement stmt1=null;
		Connection con = getConnection();
		String dbPassword = "",dbpwd = "",encpwd = "",decpwd = "";
		String dbdecrypt = "";
		String selectPassWdQuery = " SELECT PASS_WD FROM USERS WHERE CODE='"+ loginID +"'";
		
		encry_decry obj = new encry_decry();
		//MLogger.writeToLog("selectPassWdQuery Query" + selectPassWdQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","selectPassWdQuery()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectPassWdQuery);
			obj =new encry_decry();
			while(rs.next())
			{
				dbPassword = Utilities.checkNull(rs.getString("PASS_WD"));
				dbpwd=rs.getString("PASS_WD");
			}	
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try 
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		if(passwd.equalsIgnoreCase(dbpwd))
		{
			encpwd=obj.encrypt(passwd);
			String s="UPDATE USERS SET PASS_WD='"+encpwd+"' WHERE CODE ='"+loginID +"'";
			stmt1=con.createStatement();
			int i=	stmt1.executeUpdate(s);
			rs1=stmt1.executeQuery("SELECT PASS_WD FROM USERS WHERE CODE='"+loginID +"'");
			if(rs1.next())
			{
				encpwd=rs1.getString("PASS_WD");
			}
			if (rs1!=null)
			{
				rs1.close();
				rs1 = null;
			}
			if (stmt1!=null)
			{
				stmt1.close();
				stmt1 = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
			salesCode = selectSalesCode(loginID);
		}
		else
		{
			decpwd=obj.decrypt(dbpwd);
			if(passwd.equalsIgnoreCase(decpwd))
			{
				salesCode = selectSalesCode(loginID);
			}
			else
			{
				//System.out.println("Invalid password");
				throw new PermissionDeniedException("Invalid Password");
			}
		}
		return salesCode;
	}
	public String getEmployeeCode(String loginID)throws Exception
	{
		//System.out.println("LoginManager : getting employee code");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String userCode = "";
		String userQ =	" SELECT CODE FROM USERS "+
							" WHERE "+
						" EMP_CODE ='"+ loginID +"'";
		//MLogger.writeToLog("getEmployeeCode Query" + userQ,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","getEmployeeCode()");
	
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(userQ);
			while(rs.next())
			{
				userCode = Utilities.checkNull(rs.getString(1));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return userCode;
	}

	// get Grade Type
	public String getEmployeeGrade(String loginID)throws Exception
	{
		//System.out.println("LoginManager : getting employee Grade :");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String desig = "";
		String gradeQ = " SELECT A.GRADE_TYPE FROM GRADE A ,EMPLOYEE B "+
											" WHERE A.GRADE_CODE = B.GRADE  "+
											" AND B.EMP_CODE ='"+ loginID +"'";
		//MLogger.writeToLog("selectEmployee Grade Query" + gradeQ,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","getEmployeeGrade()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(gradeQ);
			while(rs.next())
			{
				desig = Utilities.checkNull(rs.getString(1));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		return desig;
	}

	//get designation of LOGIN PSR.
	public String getDesignation(String loginID) throws Exception
	{
		//System.out.println("LoginManager : getting employee designation");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String desig = "";
		String selectSelCdQuery = " SELECT A.DESIGNATION FROM EMPLOYEE A, GRADE B "+
							      "  WHERE A.EMP_CODE ='"+ loginID +"'"+
						          "  AND  A.GRADE = B.GRADE_CODE "+
						          "  AND   B.GRADE_TYPE = 'M' ";
		//MLogger.writeToLog("selectEmployee Designation Query" + selectSelCdQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","getDesignation()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectSelCdQuery);
			while(rs.next())
			{
				desig = Utilities.checkNull(rs.getString(1));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}			
		}
		return desig;
	}
	/**
	  * This Method Validates PSR.
	  * 
	**/
	public boolean ValidatePSRCode(String LoginID,String selectedPSRCode) throws Exception
	{
		//System.out.println("LoginManager : getting report_to of psr (Validating PSRCode) ");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();

		String dbCode = "";
		String query = "SELECT REPORT_TO FROM EMPLOYEE WHERE EMP_CODE ='"+selectedPSRCode+"'";
		//MLogger.writeToLog("ValidatePSRCode Query" + query,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","ValidatePSRCode()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(query);
			while(rs.next())
			{
				dbCode= Utilities.checkNull(rs.getString(1));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		if(dbCode.equals("LoginID"));
		else
		throw new PermissionDeniedException("PSR not belongs to Manager");
		return true;
	}


	/** 
	 * This method authenticates other privileges of  user.
	 * It checks the .
	 * - whether employee is PSR ?
	 * - whether he has resigned ?
	 * - whether he is on held
	  
	 *
	 * @param   connection   
	 * @param   String LoginID 
	 * @param   String password 
	 *
	 *@return String sales code
	 */

	public boolean checkPrev(String salesCode) throws PermissionDeniedException,Exception
	{	
		//System.out.println("LoginManager : Checking Priviledges ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String empSite = "";
		String resiDate = "";
		String withHeld = "";
		String strStatus ="";
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]
		String fldStaffSiteString = "";
		List fldStaffSiteList = null;
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

		String selectPrevQuery = " SELECT EMP_SITE, RESI_DATE, WITH_HELD, STATUS FROM EMPLOYEE WHERE EMP_CODE='"+ salesCode +"'";
		//MLogger.writeToLog("Check PSR Previledge Query" + selectPrevQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","checkPrev()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectPrevQuery);
			while(rs.next())
			{
				empSite = Utilities.checkNull(rs.getString("EMP_SITE"));
				resiDate = Utilities.checkNull(rs.getString("RESI_DATE"));
				withHeld = Utilities.checkNull(rs.getString("WITH_HELD"));
				strStatus = Utilities.checkNull(rs.getString("STATUS"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

			fldStaffSiteString = getFldStaffSiteList();
			System.out.println("Inside [LoginManager][checkPrev]fldStaffSiteString::["+fldStaffSiteString+"]");

			//Retreieving the site code List
			fldStaffSiteList = getSiteList(fldStaffSiteString);
			System.out.println("Inside [LoginManager][checkPrev]List::["+fldStaffSiteList+"]");
			System.out.println("Inside [LoginManager][checkPrev]empSite::["+empSite+"]");
			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try {
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code]
		//if(empSite.equals("SP876")||empSite.equals("ST876")||empSite.equals("SP878")|| empSite.equals("MP876") || empSite.equals("SP895"))
		if(fldStaffSiteList.contains(empSite))
		; 
		else
		throw new PermissionDeniedException("Employee is not PSR");


		if(strStatus.equals("S"))
		throw new PermissionDeniedException("Employee has resigned");
		return true;
	}

	//Changed by nazia on 07-05-09[Allow sales person add report only if  MODE_REPO FROM SALES_PERS is 'N' or 'BOTH' WS89SUN098]Start
	public boolean isModeRepAllowed(String salesCode) throws PermissionDeniedException,Exception
	{			
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();	
		boolean isModeRepAllowed = true;
		String checkModRep = "";
		try
		{
			stmt = con.createStatement();
			String checkModRepSql = "SELECT MODE_REPO FROM SALES_PERS WHERE SALES_PERS='"+salesCode+"'";	
			System.out.println("LoginManager : : checkModRepSql ["+checkModRepSql+"] ");
			rs = stmt.executeQuery(checkModRepSql);
			if(rs.next())
			{	
				checkModRep = Utilities.checkNull(rs.getString("MODE_REPO"));
			}
			if (rs!=null)
			{
				rs.close();
				rs= null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null; 
			}
			System.out.println("LoginManager : : checkModRep ["+checkModRep+"]");
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}		
		//if ( ! checkModRep.equalsIgnoreCase("N") || ! checkModRep.equalsIgnoreCase("BOTH"))
		if ( ! (checkModRep.equalsIgnoreCase("N")|| checkModRep.equalsIgnoreCase("B") ) )
		{		
			isModeRepAllowed = false;
		}
		return isModeRepAllowed;
	}
	//Changed by nazia on 07-05-09[Allow sales person add report only if  MODE_REPO FROM SALES_PERS is 'N' or BOTH WS89SUN098]End
	/** 
	 * This method returns the sales code if 
	 *
	 * @param   connection   
	 * @param   String loginID
	 * @return  String salesCode
	 */
	public String selectSalesCode (String loginID) throws Exception
	{	
		//System.out.println("LoginManager : getting sales code");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String salesCd = "";

		String selectSelCdQuery = " SELECT EMP_CODE FROM USERS WHERE CODE='"+ loginID +"'";
		//MLogger.writeToLog("selectSalesCode Query" + selectSelCdQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","selectSalesCode()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectSelCdQuery);
			while(rs.next())
			{
				salesCd = Utilities.checkNull(rs.getString("EMP_CODE"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		return salesCd;
	}

	/** 
	 * This method generates random number inserts or updates in the ACCESS_CONTROL 
	 * This random number is then passed to every page
	 *
	 * @param   connection   
	 * @return  String salesCode
	 */
	public String setRandom (String salesCode) throws Exception
	{	
		//System.out.println("LoginManager : setting Random");
		
		Connection con = getConnection();
		
		DBOperations dbOpr = new DBOperations( con );
		String salesCd = "";

		//before inserting delete the previous record
		HashMap whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		int result = dbOpr.delete("ACCESS_CONTROL", whereHm);

		//generating the random number
		Random r = new Random();        
		int intRand = r.nextInt();
		//to limit the random number to max 10 digits
		intRand = intRand %  100000000;
		String rand = ""+intRand;
		java.util.Date date = new java.util.Date();
		long time = date.getTime();

		// insering into ACCESS_CONTROL 
		HashMap hm;
		hm = new HashMap();
		hm.put("SALES_PERS", salesCode);
		hm.put("ACCESS_TIME", ""+time);
		hm.put("RANDOM", rand);
		result = dbOpr.insert("ACCESS_CONTROL", hm);
		hm = null;
		dbOpr.removeCon();

		return rand;	
	}
	
	/** 
	 * This method returns the sales code in the table ACCESS_CONTROL for given random number.
	   It throws PermissionDeniedException if there is no entry in the ACCESS_CONTROL TABLE
	 *
	 * @param   connection   
	 * @param   String random number
	 */
	public String checkAccess (String rand) throws PermissionDeniedException,Exception
	{	
		System.out.println("LoginManager : Checking access rand["+rand+"]");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String salesCd = "";

		String randomToSalesQuery = " SELECT SALES_PERS FROM ACCESS_CONTROL WHERE RANDOM='"+ rand +"'";
		//MLogger.writeToLog("checkAccessFor PSR Query" + randomToSalesQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","checkAccess()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(randomToSalesQuery);
			while(rs.next())
			{
				salesCd = Utilities.checkNull(rs.getString("SALES_PERS"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try 
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch (Exception e) 
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (salesCd.equals(""))
		{
			throw new PermissionDeniedException("Random Number Problem");
		}
		System.out.println(" checkAccess salesCd ["+salesCd+"]");
		return salesCd;

	}

	/** 
	 * This method DELETES random number from the ACCESS_CONTROL for particular salesCode
	 * This method is called during the logout
	 *
	 * @param   connection   
	 * @return  
	 */
	public void deleteRandom (String salesCode) throws Exception
	{
		//System.out.println("LoginManager : deleting random ....");
		Connection con = getConnection();
		DBOperations dbOpr = new DBOperations(  con  );
		String salesCd = "";
		HashMap whereHm = new HashMap();
		whereHm.put("SALES_PERS", salesCode);
		int result = dbOpr.delete("ACCESS_CONTROL", whereHm);
		dbOpr.removeCon();
	 }

	/** 
	 * This method updates the password of the MedRep
	 * @param   connection   
	 * @param   String salesCode , new password
	 */	
	public void updatePassword (String salesCode,String newPassword,String login) throws Exception
	{
 		//System.out.println("LoginManager : updating password .....");
		try
		{
			Connection con = getConnection();
			DBOperations dbOpr = new DBOperations( con );
			HashMap whereHm = new HashMap();
			whereHm.put("CODE", login.toUpperCase());
			HashMap setHm = new HashMap();
			setHm.put("PASS_WD", newPassword);
			int result = dbOpr.update("USERS", setHm,whereHm);
			dbOpr.removeCon();
		}
		catch(Exception e)
		{
			//System.out.println("Exception :"+e);
		}
	 }

	 /**  
	 * This method returns the password of the employee 
	 *
	 * @param   connection   
	 * @param   String LoginID 
	 * 
	 *
	 *@return String sales code
	 */
	public String getPassword (String salesCode) throws Exception
	{	
		//System.out.println("LoginManager : getting password ....");

		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String dbPassword = "",decpwd="";
		String selectPassWdQuery = " SELECT PASS_WD FROM USERS WHERE CODE='"+ salesCode +"'";
		//MLogger.writeToLog("getPassword query" + selectPassWdQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","getPassword()");
		try
		{
			encry_decry obj=new encry_decry();
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectPassWdQuery);
			while(rs.next())
			{
				dbPassword = Utilities.checkNull(rs.getString("PASS_WD"));
				decpwd=obj.decrypt(rs.getString("PASS_WD"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			//throw e;
			e.printStackTrace();
		}
		finally
		{
			try {
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
	
		return decpwd;
	}
	public boolean checkReport(String salesCode,String workDate) throws Exception
	{
		//System.out.println("LoginManager : Checking Report ....");

		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();

		int no =-1;
		String query = "SELECT COUNT(*) FROM  DR_MAIN WHERE SALES_PERS ='"+salesCode+"' AND WORK_DATE='"+workDate+"'";
		//MLogger.writeToLog("checkReport query" + query,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","checkReport()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(query);
			while(rs.next())
			{
				no= rs.getInt(1);
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try 
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		if(no==0)
		{
				return true;
		}
		else
		{
			return false;
		}
	}
	public static void main(String[] args)	throws Exception
	{
		//	testing random
		Random r = new Random();        
		int rand = r.nextInt();

		rand = rand %  100000000;
	}

	public boolean isHOUser(String salesCode) throws PermissionDeniedException,Exception
	{
		//System.out.println("LoginManager : checking for HOUser ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String retValue = "";
		//Query for checking whether this HO User has rights
		String sqlString = "SELECT CODE FROM USERS A, USER_RIGHTS B " + 
							   "WHERE A.CODE ='"+salesCode+"' " + 
							   "AND A.PROFILE_ID = B.PROFILE_ID " +
							   "AND B.APPLICATION = 'MRO' " +
							   "AND B.MENU_ROW = 1 " +       
							   "AND B.MENU_COL = 1 " +       
							   "AND B.MENU_SUBCOL = 1 " +
							   "AND B.LEVEL_4 = 1 " +        
							   "AND B.LEVEL_5 = 1 " +        
							   "AND B.MENU_NAME = 'MR Online Application' ";

		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(sqlString);
			if(rs.next())
			{
				retValue = Utilities.checkNull(rs.getString(1));
			}
			else
			{
				retValue = "";
			}
			System.out.println(" LoginManager:: retValue["+retValue+"] salesCode["+salesCode+"]");
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try {
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		if(!retValue.equals(""))
		{
			if(retValue.equalsIgnoreCase(salesCode))
			;
			else
			{
				throw new PermissionDeniedException("Employee doesn't have rights to view the mennu option");
			}
		}
		else
		{
			return false;	
		}
		return true;
	}
	public int checkUserName (String loginID) throws PermissionDeniedException,Exception
	{
		//System.out.println("LoginManager : Checking user Name");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		int iNoUser=0;

		String selectUserQuery = " SELECT COUNT(CODE) NOOFUSER FROM USERS WHERE CODE='"+ loginID +"'";

		//MLogger.writeToLog("selectUserQuery Query" + selectUserQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","selectPassWdQuery()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectUserQuery);
			while(rs.next())
			iNoUser = Utilities.stringToInt(rs.getString("NOOFUSER"));
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		return iNoUser;
	
	}
	//Addded By Danish 8/8/2005
	public boolean getEmpRegStatus(String salesCode) throws PermissionDeniedException,Exception
	{	
		boolean status = false;
		//System.out.println("LoginManager : Checking Priviledges ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String strStatus ="";

		String selectPrevQuery = " SELECT STATUS FROM EMPLOYEE WHERE EMP_CODE='"+ salesCode +"'";
		//MLogger.writeToLog("getEmpStatuse Query" + selectPrevQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","checkPrev()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectPrevQuery);
			while(rs.next())
			{
				strStatus = Utilities.checkNull(rs.getString("STATUS"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try 
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if(strStatus.equals("S"))
		{
			status = true;
		}
		return status;
	}
	//Added By Danish 8/8/2005
	public boolean checkPrevResg(String salesCode) throws PermissionDeniedException,Exception
	{	
		//System.out.println("LoginManager : Checking Priviledges ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String empSite = "";
		boolean strStatus =false;

		String selectPrevQuery = " SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE='"+ salesCode +"'";
		//MLogger.writeToLog("Check PSR Previledge Query" + selectPrevQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","checkPrev()");

		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]
		String fldStaffSiteString = "";
		List fldStaffSiteList = null;
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectPrevQuery);
			while(rs.next())
			{
				empSite = Utilities.checkNull(rs.getString("EMP_SITE"));
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

			fldStaffSiteString = getFldStaffSiteList();
			System.out.println("Inside [LoginManager][checkPrev]fldStaffSiteString::["+fldStaffSiteString+"]");

			//Retreieving the site code List
			fldStaffSiteList = getSiteList(fldStaffSiteString);
			System.out.println("Inside [LoginManager][checkPrev]List::["+fldStaffSiteList+"]");
			System.out.println("Inside [LoginManager][checkPrev]empSite::["+empSite+"]");

			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		//System.out.println("Check PSR Previledge :LoginManager:checkPrevResg :empSite:"+empSite);
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code]
		//if(empSite.equals("SP876")||empSite.equals("ST876")||empSite.equals("SP878")|| empSite.equals("MP876") || empSite.equals("SP895"))
		if(fldStaffSiteList.contains(empSite))
		; 
		else
		
		{
			strStatus =true;
		}
		return strStatus;
	}
	
	//snehasish 05/09/2006 to get resigned employees information about the workingdate before or after releaving date.
	public boolean checkResgEmp(String salesCode,String workDate) throws PermissionDeniedException,Exception
	{	
		//System.out.println("LoginManager : Checking Priviledges ....");
		ResultSet rs = null;
		Statement stmt = null;
		Connection con = getConnection();
		String relieveDate = "";
		boolean strStatus =false;
		Calendar  relieveDateUtil=null;
		Calendar  workDateUtil=null;
		DateObject dateObj =new DateObject();

		dateObj.setDate(workDate); 
		workDateUtil = dateObj.getDate();
		String selectPrevQuery = " SELECT TO_CHAR(RELIEVE_DATE,'DD-MON-YYYY') RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE='"+ salesCode +"'";
		//MLogger.writeToLog("Check PSR Previledge Query" + selectPrevQuery,Logger.LOG_LEVEL_DEBUG,"LoginManager.java","checkPrev()");
		try
		{
			stmt = con.createStatement();
			rs = stmt.executeQuery(selectPrevQuery);
			
			while(rs.next())
			{
				relieveDate = Utilities.checkNull(rs.getString("RELIEVE_DATE"));
				//System.out.println("relieveDate"+relieveDate);
				if (relieveDate != null && relieveDate.length() > 0)
				{
					dateObj.setDate(relieveDate); 
					relieveDateUtil=dateObj.getDate();

					if(workDateUtil.after(relieveDateUtil))
					{
						strStatus =true;
					}
				}
			}
			if (rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if(con !=null)
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try {
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if(con !=null)
				{
					con.close();
					con = null;
				}
			} catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		//System.out.println("Check PSR checkResgEmp :LoginManager:checkResgEmp :relieveDateUtil:"+relieveDateUtil);
		
		//System.out.println("Check PSR checkResgEmp :LoginManager:checkResgEmp :strStatus:"+strStatus);
		return strStatus;
	}//snehasish ends

	
	public void removeCon() throws Exception
	{
		try
		{
			if ( con != null )
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

	private String getFldStaffSiteList()
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		Connection conn = getConnection();
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			 pstmt = conn.prepareStatement(sql);
			 rs = pstmt.executeQuery();
			System.out.println("Inside [LoginManager][getFldStaffSiteList]sql::>"+sql);

			 if (rs.next())
			 {
				fldStaffSiteString = rs.getString("PROP_VALUE");
				fldStaffSiteString = (fldStaffSiteString == null)? "" : fldStaffSiteString.trim();
				System.out.println("Inside [LoginManager][getFldStaffSiteList]fldStaffSiteString::["+fldStaffSiteString+"]");
			 }
			 if (rs!=null)
			 {
				 rs.close();
				 rs = null;
			 }
			 if (pstmt!=null)
			 {
				 pstmt.close();
				 pstmt = null;
			 }
			 if(conn !=null)
			 {
				 conn.close();
				 conn = null;
			 }
			
		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [LoginManager][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				 {
					 rs.close();
					 rs = null;
				 }
				 if (pstmt!=null)
				 {
					 pstmt.close();
					 pstmt = null;
				 }
				 if(conn !=null)
				 {
					 conn.close();
					 conn = null;
				 }				
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [LoginManager][getFldStaffSiteList]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		System.out.println("Returning from [MedRep][getFldStaffSiteList]["+fldStaffSiteString+"]");
		return fldStaffSiteString;
	}

	private List getSiteList( String data )
	{
		System.out.println("Inside [LoginManager][getSiteList]::data["+data+"]");	
		List flStaffList = null;
		try
		{
			//flStaffList = new List();
			
			String[] dataArr = null;
			
			if ( data != null && data.trim().length() > 0 && data.indexOf(",") != -1 )
			{
				dataArr = data.split(",");
				System.out.println("Inside [LoginManager][getSiteList]::Arrays length["+dataArr.length+"]");

				flStaffList = Arrays.asList(dataArr);
				System.out.println("Inside [LoginManager][getSiteList]::List["+flStaffList+"]");
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return flStaffList;
	}
	
	private Connection getConnection()
	{
		Connection con = null;
		ConnDriver connDriver = new ConnDriver();

		if( userInfo !=null )
		{
			try 
			{
				con = connDriver.getConnectDB(userInfo.getTransDB());
			}
			catch (Exception e) 
			{
				e.printStackTrace();
				System.out.println("In DailyVisit GetConnetion Exception : ["+ e.getMessage() +"]");
			}
		}
		return con;
	}

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
}