/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import bsh.Interpreter;
import bsh.InterpreterError;
import ibase.bi.bean.DateBean;
import ibase.bi.ejb.session.Application;
import ibase.bi.ejb.session.Argument;
import ibase.bi.ejb.session.Calculation;
import ibase.bi.ejb.session.Column;
import ibase.bi.ejb.session.DrillParser;
import ibase.bi.ejb.session.GenaralProp;
import ibase.bi.ejb.session.Total;
import ibase.bi.ejb.session.TotalManager;
import ibase.bi.utility.BIContentManager;
import ibase.bi.utility.BIException;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BISaxTransformer
extends DefaultHandler {
    int Records = 0;
    private String exception = "";
    private String exceptionStyle = "";
    private String sortInfoString = null;
    private String drillAcrossString = null;
    private TotalManager totalManager = null;
    private String baName;
    private int baID;
    private String groupData;
    private String tempAppMaxRows = "";
    private boolean isAppMaxRows = false;
    private Column[] columns;
    private ArrayList allElementNameList = null;
    private ArrayList grElementNameList = null;
    private ArrayList fxElementNameList = null;
    private ArrayList ctElementNameList = null;
    private ArrayList vlElementNameList = null;
    private ArrayList grElementList;
    private ArrayList fxElementList;
    private ArrayList ctElementList;
    private ArrayList vlElementList;
    private ArrayList grElementTypeList;
    private ArrayList fxElementTypeList;
    private ArrayList ctElementTypeList;
    private ArrayList vlElementTypeList;
    private ArrayList curFixedColVal;
    private ArrayList prevFixedColVal;
    private ArrayList curCrossTabColVal;
    private ArrayList curValueColVal;
    Interpreter interpreter;
    private ArrayList calObjList;
    private ArrayList totalObjList;
    private ArrayList totalGroupNames;
    private ArrayList curTotalGroupVal;
    private ArrayList prevTotalGroupVal;
    private ArrayList totalValueList;
    private double prevTotalResult;
    private double curTotalResult;
    private ArrayList crossTabMap;
    int crossTabPosition = 0;
    private GenaralProp genProp;
    private String outputFileName;
    private String dataOutputFileName;
    private String groupFileName;
    String selectedValues = "";
    String tempGroupString = "";
    String tempCrossTabString = "";
    String crossTabValue = null;
    String tempGroupColString = "";
    String tempFixedColString = "";
    String tempCrossTabColString = "";
    String tempValueColString = "";
    int posOfGroupColumn = 0;
    int posOfFixedColumn = 0;
    int posOfCrossTabColumn = 0;
    int posOfValueColumn = 0;
    private int noOfGroupColumns = 0;
    private int noOfFixedColumns = 0;
    private int noOfCrossTabColumns = 0;
    private int noOfValueColumns = 0;
    private int noOfCalculations = 0;
    private int noOfTotals = 0;
    private int noOfCrossTabTotal = 0;
    private boolean isCrossTabTotal = false;
    private boolean isFirst = true;
    private StringBuffer groupBuffer;
    private StringBuffer colDefBuffer;
    private StringBuffer rowBuffer;
    boolean isCalculationPresent = false;
    boolean isTotalPresent = false;
    boolean isGroup = false;
    boolean isCrossTabTag = false;
    boolean readCrossTabValue = false;
    boolean isDataTag = false;
    boolean isDetail = false;
    boolean isGroupColumn = false;
    boolean isFixedColumn = false;
    boolean isCrossTabColumn = false;
    boolean isValueColumn = false;
    Object[][] rowDataArray = null;
    Object[][] rowTotalDataArray = null;
    ArrayList totalDataArrayList = null;
    BufferedWriter fWriter = null;
    BufferedWriter dataWriter = null;
    private int noOfVisibleFixedColumns = 0;
    private int noOfVisibleValueColumns = 0;
    private ArrayList invisibleFxColsPosList = null;
    private ArrayList invisibleValColsPosList = null;
    private String whereStmt = null;
    HashMap recordMap = new HashMap();
    Object rowDataArrayCopy = null;
    private ArrayList groupColVal;
    ArrayList ctTotList = null;
    int noOfCtTotals = 0;
    int noOfRows = 0;
    private HashMap whereCondition = new HashMap();
    private ArrayList argumentList;
    int rowCount = 0;
    boolean isLocVar = false;
    boolean isLocVarName = false;
    String tempLocVarValue = "";
    String onChgkeys = null;
    HashMap locVarMap = null;
    ArrayList locVarNamesList = null;
    HashMap locVarNameExpr = null;
    HashMap locVarNameGroupMap = null;
    int changedFixedColCtr = -1;
    private String xmlHeadingStr = "";
    ArrayList applicationList = null;
    BIContentManager contentManager = null;
    ArrayList colDefList = null;
    private boolean suppressDuplicateRow = false;

    public BISaxTransformer(BIContentManager contentManager) throws Exception {
        try {
            this.contentManager = contentManager;
            this.crossTabMap = new ArrayList();
            this.groupBuffer = new StringBuffer();
            this.rowBuffer = new StringBuffer();
            this.totalDataArrayList = new ArrayList();
            String absFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "SaxTransformed" + Math.random() + ".xml";
            String suffix = "SaxTransformed_" + Math.random();
            String prefix = ".xml";
            File tempDirectory = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles");
            File absTempFileName = File.createTempFile(suffix, prefix, tempDirectory);
            absFileName = absTempFileName.getAbsolutePath();
            this.setOutputFileName(absFileName);
            FileOutputStream fout = new FileOutputStream(this.getOutputFileName());
            this.fWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, CommonConstants.ENCODING));
            this.fWriter.write("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
            this.fWriter.write("<rows>\n");
            try {
                this.suppressDuplicateRow = CommonConstants.SUPPRESS_DUPLICATE_ROW;
            }
            catch (NoSuchFieldError nsfe) {
                BaseLogger.log("0", null, null, "Exception :BIController :ejbCreate :==>\n" + nsfe);
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setBAName(String baName) throws Exception {
        try {
            this.baName = baName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setBAId(int baID) throws Exception {
        try {
            this.baID = baID;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setGenProp(GenaralProp genProp) throws Exception {
        try {
            this.genProp = genProp;
            String absFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "SaxTransformedData" + Math.random() + ".xml";
            String suffix = "SaxTransformedData_" + Math.random();
            String prefix = ".xml";
            File tempDirectory = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles");
            File absTempFileName = File.createTempFile(suffix, prefix, tempDirectory);
            this.dataOutputFileName = absFileName = absTempFileName.getAbsolutePath();
            FileOutputStream fout = new FileOutputStream(absFileName);
            if (this.genProp.getOutputType().equalsIgnoreCase("ITM BI")) {
                this.dataWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, CommonConstants.ENCODING));
                this.dataWriter.write("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
                this.dataWriter.write("<rows>\n");
            } else {
                this.dataWriter = this.fWriter;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void setOutputFileName(String fileName) throws Exception {
        this.outputFileName = fileName;
    }

    public String getOutputFileName() throws Exception {
        try {
            return this.outputFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getDataOutputFileName() throws Exception {
        try {
            return this.dataOutputFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public int getReportRowCount() {
        return this.rowCount;
    }

    public void setAllElementNameList(ArrayList allColumnNameList) throws Exception {
        try {
            BaseLogger.log("3", null, null, "All Columns List(BISaxTransforemr) :" + allColumnNameList);
            this.allElementNameList = new ArrayList(allColumnNameList);
            this.setGroupElementNameList((ArrayList)this.allElementNameList.get(0));
            this.setFixedElementNameList((ArrayList)this.allElementNameList.get(1));
            this.setCrossTabElementNameList((ArrayList)this.allElementNameList.get(2));
            this.setValueElementNameList((ArrayList)this.allElementNameList.get(3));
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void setGroupElementNameList(ArrayList groupElementNameList) throws Exception {
        this.grElementNameList = new ArrayList(groupElementNameList);
    }

    private void setFixedElementNameList(ArrayList fixedElementNameList) throws Exception {
        this.fxElementNameList = new ArrayList(fixedElementNameList);
    }

    private void setCrossTabElementNameList(ArrayList crossTabElementNameList) throws Exception {
        this.ctElementNameList = new ArrayList(crossTabElementNameList);
    }

    private void setValueElementNameList(ArrayList valueElementNameList) throws Exception {
        this.vlElementNameList = new ArrayList(valueElementNameList);
    }

    public void setNameValueMap(HashMap locVarNameExpr) throws Exception {
        try {
            this.locVarNameExpr = locVarNameExpr;
            Iterator iter = this.locVarNameExpr.keySet().iterator();
            this.locVarNamesList = new ArrayList();
            while (iter.hasNext()) {
                this.locVarNamesList.add((String)iter.next());
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setNameGroupMap(HashMap locVarNameGroupMap) throws Exception {
        try {
            this.locVarNameGroupMap = locVarNameGroupMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setColumns(Column[] cols) throws Exception {
        try {
            this.invisibleFxColsPosList = new ArrayList();
            this.invisibleValColsPosList = new ArrayList();
            this.columns = cols;
            int size = 0;
            size = this.columns.length;
            this.noOfGroupColumns = this.grElementNameList.size();
            this.grElementList = new ArrayList();
            this.grElementTypeList = new ArrayList();
            int ctr = 0;
            while (ctr < this.noOfGroupColumns) {
                this.grElementList.add(null);
                this.grElementTypeList.add(null);
                ++ctr;
            }
            this.noOfFixedColumns = this.fxElementNameList.size();
            this.fxElementList = new ArrayList();
            this.fxElementTypeList = new ArrayList();
            ctr = 0;
            while (ctr < this.noOfFixedColumns) {
                this.fxElementList.add(null);
                this.fxElementTypeList.add(null);
                ++ctr;
            }
            this.noOfCrossTabColumns = this.ctElementNameList.size();
            this.ctElementList = new ArrayList();
            this.ctElementTypeList = new ArrayList();
            ctr = 0;
            while (ctr < this.noOfCrossTabColumns) {
                this.ctElementList.add(null);
                this.ctElementTypeList.add(null);
                ++ctr;
            }
            this.noOfValueColumns = this.vlElementNameList.size();
            this.vlElementList = new ArrayList();
            this.vlElementTypeList = new ArrayList();
            ctr = 0;
            while (ctr < this.noOfValueColumns) {
                this.vlElementList.add(null);
                this.vlElementTypeList.add(null);
                ++ctr;
            }
            ctr = 0;
            while (ctr < size) {
                String type;
                if (this.columns[ctr].getPlacement() == 1 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 || type.indexOf("Decimal") != -1 ? "NUMBER" : type;
                    this.grElementList.set(this.grElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.grElementTypeList.set(this.grElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                } else if (this.columns[ctr].getPlacement() == 2 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 || type.indexOf("Decimal") != -1 ? "NUMBER" : type;
                    this.fxElementList.set(this.fxElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.fxElementTypeList.set(this.fxElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                    if (this.columns[ctr].isVisible()) {
                        ++this.noOfVisibleFixedColumns;
                    } else {
                        this.invisibleFxColsPosList.add(Integer.toString(this.columns[ctr].getPosition()));
                    }
                } else if (this.columns[ctr].getPlacement() == 3 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 || type.indexOf("Decimal") != -1 ? "NUMBER" : type;
                    this.ctElementList.set(this.ctElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.ctElementTypeList.set(this.ctElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                } else if (this.columns[ctr].getPlacement() == 4 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 || type.indexOf("Decimal") != -1 ? "NUMBER" : type;
                    this.vlElementList.set(this.vlElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.vlElementTypeList.set(this.vlElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                    if (this.columns[ctr].isVisible()) {
                        ++this.noOfVisibleValueColumns;
                    } else {
                        this.invisibleValColsPosList.add(Integer.toString(this.columns[ctr].getPosition()));
                    }
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setCalculations(ArrayList calculations) throws Exception {
        try {
            this.isCalculationPresent = true;
            this.noOfCalculations = calculations.size();
            this.calObjList = new ArrayList(calculations);
            int ctr = 0;
            while (ctr < this.noOfCalculations) {
                String type;
                Calculation calObj = (Calculation)this.calObjList.get(ctr);
                if (this.fxElementNameList.indexOf(calObj.getCalId()) != -1) {
                    calObj.setPlacement(2);
                    if (calObj.isVisible() && calObj.isValid()) {
                        ++this.noOfVisibleFixedColumns;
                    }
                    type = (type = calObj.getResultType()).indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 ? "NUMBER" : type;
                    this.fxElementList.set(this.fxElementNameList.indexOf(calObj.getCalId()), calObj);
                    this.fxElementTypeList.set(this.fxElementNameList.indexOf(calObj.getCalId()), type);
                }
                if (this.vlElementNameList.indexOf(calObj.getCalId()) != -1) {
                    calObj.setPlacement(4);
                    if (calObj.isVisible() && calObj.isValid()) {
                        ++this.noOfVisibleValueColumns;
                    }
                    type = (type = calObj.getResultType()).indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 ? "NUMBER" : type;
                    this.vlElementList.set(this.vlElementNameList.indexOf(calObj.getCalId()), calObj);
                    this.vlElementTypeList.set(this.vlElementNameList.indexOf(calObj.getCalId()), type);
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setTotalManager(TotalManager totalManager) throws Exception {
        try {
            this.totalManager = totalManager;
            this.totalManager.setlocVarNamesList(this.locVarNamesList);
            this.totalManager.setlocVarNameGroupMap(this.locVarNameGroupMap);
            this.totalManager.updateTotalPosition(this.fxElementNameList, this.fxElementList, this.ctElementNameList, this.ctElementList, this.vlElementNameList, this.vlElementList);
            this.getUpdatedTotals();
            this.totalManager.setlocVarMap(this.locVarMap);
            this.noOfCrossTabTotal = this.totalManager.noOfCrossTabTotal;
            this.isCrossTabTotal = this.totalManager.isCrossTabTotal;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void getUpdatedTotals() throws Exception {
        this.isTotalPresent = true;
        this.totalObjList = new ArrayList(this.totalManager.getTotalList());
        this.noOfTotals = this.totalObjList.size();
    }

    public void setExceptionString(String exception, String exceptionStyle) throws Exception {
        try {
            this.exception = exception;
            this.exceptionStyle = exceptionStyle;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void parseXML(String xmlFileName) throws Exception {
        try {
            if (this.groupData != null) {
                this.fWriter.write(this.groupData);
            }
            String colInfo = this.getColumnInfo();
            this.fWriter.write(colInfo);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(xmlFileName, (DefaultHandler)this);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            BaseLogger.log("3", null, null, "Parsing Document: Started");
            BaseLogger.log("3", null, null, "grElementList: " + this.grElementList);
            BaseLogger.log("3", null, null, "grElementNameList: " + this.grElementNameList);
            BaseLogger.log("3", null, null, "grElementTypeList: " + this.grElementTypeList);
            BaseLogger.log("3", null, null, "fxElementList: " + this.fxElementList);
            BaseLogger.log("3", null, null, "fxElementNameList: " + this.fxElementNameList);
            BaseLogger.log("3", null, null, "fxElementTypeList: " + this.fxElementTypeList);
            BaseLogger.log("3", null, null, "ctElementList: " + this.ctElementList);
            BaseLogger.log("3", null, null, "ctElementNameList: " + this.ctElementNameList);
            BaseLogger.log("3", null, null, "ctElementTypeList: " + this.ctElementTypeList);
            BaseLogger.log("3", null, null, "vlElementList: " + this.vlElementList);
            BaseLogger.log("3", null, null, "vlElementNameList: " + this.vlElementNameList);
            BaseLogger.log("3", null, null, "vlElementTypeList: " + this.vlElementTypeList);
            if (this.totalObjList != null) {
                BaseLogger.log("3", null, null, "Setting Column Details in TotalManager ..");
                this.totalManager.setGrDetails(this.grElementNameList, this.grElementTypeList);
                this.totalManager.setFxDetails(this.fxElementNameList, this.fxElementTypeList);
                this.totalManager.setCtDetails(this.ctElementNameList, this.ctElementTypeList);
                this.totalManager.setVlDetails(this.vlElementNameList, this.vlElementTypeList);
                this.totalManager.setCalDetails(this.calObjList);
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String tagName, Attributes atts) throws SAXException {
        try {
            if (tagName.equalsIgnoreCase("groups")) {
                this.isGroup = true;
            } else if (tagName.equalsIgnoreCase("DESCRIPTION")) {
                this.isAppMaxRows = true;
            } else if (tagName.equalsIgnoreCase("data")) {
                this.isDataTag = true;
                this.curFixedColVal = new ArrayList(this.noOfFixedColumns);
                this.curCrossTabColVal = new ArrayList(this.noOfCrossTabColumns);
                this.curValueColVal = new ArrayList(this.noOfValueColumns);
                this.groupColVal = new ArrayList(this.noOfGroupColumns);
                int i = 0;
                while (i < this.noOfFixedColumns) {
                    this.curFixedColVal.add(null);
                    ++i;
                }
                i = 0;
                while (i < this.noOfCrossTabColumns) {
                    this.curCrossTabColVal.add(null);
                    ++i;
                }
                i = 0;
                while (i < this.noOfValueColumns) {
                    this.curValueColVal.add(null);
                    ++i;
                }
                i = 0;
                while (i < this.noOfGroupColumns) {
                    this.groupColVal.add(null);
                    ++i;
                }
                if (this.isTotalPresent) {
                    this.totalManager.initializeTotJEP();
                }
                if (this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") || this.genProp.getOutputType().equalsIgnoreCase("HTML") || this.genProp.getOutputType().equalsIgnoreCase("Excel") || this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth")) {
                    this.buildColDefPart();
                    this.fWriter.write(this.getBIProperties());
                    BaseLogger.log("3", null, null, "colDefList >>>>" + this.colDefList);
                    this.contentManager.setCrossTabProperties(this.ctElementList);
                    this.contentManager.setColDefList(this.colDefList);
                }
            }
            if (this.isGroup) {
                StringBuffer attBuffer = new StringBuffer();
                int ctr = 0;
                while (ctr < atts.getLength()) {
                    attBuffer.append(String.valueOf(atts.getQName(ctr)) + "=\"" + atts.getValue(ctr) + "\" ");
                    ++ctr;
                }
                this.dataWriter.write("<" + tagName.trim() + " " + attBuffer.toString().trim() + ">");
            }
            if (this.isAppMaxRows) {
                this.fWriter.write("<" + tagName.trim() + ">");
            }
            if (tagName.equalsIgnoreCase("CrossTab")) {
                this.isCrossTabTag = true;
            }
            if (this.isCrossTabTag && tagName.equalsIgnoreCase("value")) {
                this.readCrossTabValue = true;
            }
            if (tagName.equalsIgnoreCase("Detail")) {
                this.isDetail = true;
                this.interpreter = new Interpreter();
                this.recordMap.clear();
            }
            if (this.isDetail) {
                if (this.grElementNameList.indexOf(tagName) != -1) {
                    this.isGroupColumn = true;
                    this.posOfGroupColumn = this.grElementNameList.indexOf(tagName);
                } else if (this.fxElementNameList.indexOf(tagName) != -1) {
                    this.isFixedColumn = true;
                    this.posOfFixedColumn = this.fxElementNameList.indexOf(tagName);
                } else if (this.ctElementNameList.indexOf(tagName) != -1) {
                    this.isCrossTabColumn = true;
                    this.posOfCrossTabColumn = this.ctElementNameList.indexOf(tagName);
                } else if (this.vlElementNameList.indexOf(tagName) != -1) {
                    this.isValueColumn = true;
                    this.posOfValueColumn = this.vlElementNameList.indexOf(tagName);
                }
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String tagContent = new String(ch, start, length);
            if (this.isGroup) {
                this.tempGroupString = String.valueOf(this.tempGroupString) + tagContent;
            } else if (this.isAppMaxRows) {
                this.tempAppMaxRows = String.valueOf(this.tempAppMaxRows) + tagContent;
            } else if (this.readCrossTabValue) {
                this.tempCrossTabString = String.valueOf(this.tempCrossTabString) + tagContent;
            } else if (this.isGroupColumn) {
                this.tempGroupColString = String.valueOf(this.tempGroupColString) + tagContent;
            } else if (this.isFixedColumn) {
                this.tempFixedColString = String.valueOf(this.tempFixedColString) + tagContent;
            } else if (this.isCrossTabColumn) {
                this.tempCrossTabColString = String.valueOf(this.tempCrossTabColString) + tagContent;
            } else if (this.isValueColumn) {
                this.tempValueColString = String.valueOf(this.tempValueColString) + tagContent;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String tagName) throws SAXException {
        try {
            if (tagName.equalsIgnoreCase("groups")) {
                this.isGroup = false;
                this.fWriter.write("</" + tagName.trim() + ">");
            }
            if (this.isGroup) {
                if (tagName.equalsIgnoreCase("value")) {
                    this.fWriter.write("<![CDATA[" + this.tempGroupString + "]]></" + tagName + ">");
                    this.tempGroupString = "";
                } else if (tagName.equalsIgnoreCase("group")) {
                    this.fWriter.write("</" + tagName.trim() + ">");
                }
            }
            if (this.isCrossTabTag) {
                if (tagName.equalsIgnoreCase("value")) {
                    this.crossTabMap.add(this.tempCrossTabString.trim());
                    this.tempCrossTabString = "";
                    this.readCrossTabValue = false;
                }
                if (this.isTotalPresent) {
                    this.totalManager.setCrossTabMap(this.crossTabMap);
                }
            } else if (this.isTotalPresent) {
                this.totalManager.setCrossTabMap(this.crossTabMap);
            }
            if (tagName.equalsIgnoreCase("CrossTab")) {
                this.isCrossTabTag = false;
                if (this.isTotalPresent) {
                    this.crossTabMap = this.totalManager.includeCrossTabTotalHeadings();
                }
                BaseLogger.log("3", null, null, "Updated CrossTabMap :" + this.crossTabMap);
                this.rowDataArray = new Object[this.noOfValueColumns][this.crossTabMap.size()];
            }
            if (this.isGroupColumn) {
                this.groupColVal.set(this.posOfGroupColumn, this.tempGroupColString);
                this.addVariableToExpressions(tagName, this.tempGroupColString, this.grElementNameList, this.grElementTypeList);
                this.recordMap.put(tagName, this.tempGroupColString);
                this.isGroupColumn = false;
                this.tempGroupColString = "";
            }
            if (this.isFixedColumn) {
                this.curFixedColVal.set(this.posOfFixedColumn, this.tempFixedColString);
                this.addVariableToExpressions(tagName, this.tempFixedColString, this.fxElementNameList, this.fxElementTypeList);
                this.recordMap.put(tagName, this.tempFixedColString);
                this.isFixedColumn = false;
                this.tempFixedColString = "";
            }
            if (this.isCrossTabColumn) {
                this.addVariableToExpressions(tagName, this.tempCrossTabColString, this.ctElementNameList, this.ctElementTypeList);
                this.curCrossTabColVal.set(this.posOfCrossTabColumn, this.tempCrossTabColString);
                this.recordMap.put(tagName, this.tempCrossTabColString);
                this.tempCrossTabColString = "";
                this.isCrossTabColumn = false;
            }
            if (this.isValueColumn) {
                this.curValueColVal.set(this.posOfValueColumn, this.tempValueColString);
                this.addVariableToExpressions(tagName, this.tempValueColString, this.vlElementNameList, this.vlElementTypeList);
                this.recordMap.put(tagName, this.tempValueColString);
                this.tempValueColString = "";
                this.isValueColumn = false;
            }
            if (tagName.equalsIgnoreCase("detail")) {
                StringBuffer crossTabValueBuff = new StringBuffer();
                int ctr = 0;
                while (ctr < this.curCrossTabColVal.size()) {
                    crossTabValueBuff.append((String)this.curCrossTabColVal.get(ctr)).append("~");
                    ++ctr;
                }
                this.crossTabValue = crossTabValueBuff.toString();
                crossTabValueBuff = null;
                if (this.calObjList != null && this.calObjList.size() > 0) {
                    this.doCalculations();
                }
                if (this.isTotalPresent) {
                    this.totalManager.setCrossTabValue(this.crossTabValue);
                }
                this.compareData();
                this.crossTabValue = null;
                this.interpreter = null;
            }
            if (tagName.equalsIgnoreCase("data")) {
                this.fixedColumnChanged(0);
                if (this.isTotalPresent) {
                    ArrayList totList = this.totalManager.getTotals(null, this.noOfRows);
                    ArrayList titleList = this.totalManager.getTitleList();
                    this.writeTotals(totList, titleList, this.totalManager.getTitlePos());
                    this.totalManager.cleanUp();
                    this.noOfRows = 0;
                }
                if (this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") || this.genProp.getOutputType().equalsIgnoreCase("HTML") || this.genProp.getOutputType().equalsIgnoreCase("Excel") || this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth")) {
                    this.contentManager.writeDocument();
                }
            }
            if (tagName.equalsIgnoreCase("DESCRIPTION")) {
                this.fWriter.write(this.tempAppMaxRows.trim());
                this.fWriter.write("</" + tagName.trim() + ">");
                this.isAppMaxRows = false;
                this.tempAppMaxRows = "";
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (!(this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") && this.genProp.getOutputType().equalsIgnoreCase("HTML") && this.genProp.getOutputType().equalsIgnoreCase("Excel") && this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth"))) {
                this.buildColDefPart();
            }
            this.writeToFile();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public void setLocVarMap(HashMap locVarMap) throws Exception {
        try {
            this.locVarMap = locVarMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    private void addVariableToExpressions(String tagName, String data, ArrayList elementNameList, ArrayList elementTypeList) throws Exception {
        String string = data = data.length() <= 0 ? "0" : data;
        if (((String)elementTypeList.get(elementNameList.indexOf(tagName))).indexOf("NUMBER") != -1) {
            int ctr = 0;
            while (ctr < this.noOfCalculations) {
                this.interpreter.set(tagName, Double.parseDouble(data));
                ++ctr;
            }
        } else {
            int ctr = 0;
            while (ctr < this.noOfCalculations) {
                this.interpreter.set(tagName, (Object)data);
                ++ctr;
            }
        }
    }

    private void doCalculations() throws Exception {
        boolean fc = false;
        boolean vc = false;
        boolean isLocVarLoaded = false;
        int ctr = 0;
        while (ctr < this.noOfCalculations) {
            Calculation calObj = (Calculation)this.calObjList.get(ctr);
            if (!calObj.isAggregate()) {
                if (ctr > 0 && ((Calculation)this.calObjList.get(ctr - 1)).getResult() != null) {
                    Object dataobj = ((Calculation)this.calObjList.get(ctr - 1)).getResult();
                    if (dataobj instanceof String) {
                        String calstr = (String)dataobj;
                        this.interpreter.set(((Calculation)this.calObjList.get(ctr - 1)).getCalId(), (Object)calstr);
                    } else if (dataobj instanceof Double) {
                        double caldouble = (Double)dataobj;
                        this.interpreter.set(((Calculation)this.calObjList.get(ctr - 1)).getCalId(), caldouble);
                    } else {
                        this.interpreter.set(((Calculation)this.calObjList.get(ctr - 1)).getCalId(), dataobj);
                    }
                }
                if (!isLocVarLoaded) {
                    int i = 0;
                    while (this.locVarNamesList != null && i < this.locVarNamesList.size()) {
                        isLocVarLoaded = true;
                        Double value = this.getCurrValueForLocVar(this.locVarNamesList.get(i).toString());
                        this.interpreter.set(this.locVarNamesList.get(i).toString(), (Object)value);
                        ++i;
                    }
                }
                boolean isEvelSucceeded = false;
                String beanErrorString = null;
                Object resObject = null;
                try {
                    resObject = this.interpreter.eval(calObj.getExpression());
                    isEvelSucceeded = true;
                }
                catch (InterpreterError inte) {
                    System.out.println(" BISaxTrasformer--Interpreter Bean Exception: ==>\n" + (Object)((Object)inte));
                    beanErrorString = inte.getMessage();
                }
                if (isEvelSucceeded) {
                    calObj.setResult(resObject);
                    calObj.setValid(true);
                } else {
                    resObject = beanErrorString;
                    calObj.setResult("ERROR");
                    calObj.setValid(false);
                }
                if (calObj.getPlacement() == 2) {
                    this.curFixedColVal.set(this.fxElementNameList.indexOf(calObj.getCalId()), resObject);
                    this.recordMap.put(calObj.getCalId(), resObject);
                    if (this.vlElementNameList.indexOf(calObj.getCalId()) != -1) {
                        this.curValueColVal.set(this.vlElementNameList.indexOf(calObj.getCalId()), resObject);
                        this.recordMap.put(calObj.getCalId(), resObject);
                    }
                } else if (calObj.getPlacement() == 4) {
                    this.curValueColVal.set(this.vlElementNameList.indexOf(calObj.getCalId()), resObject);
                    this.recordMap.put(calObj.getCalId(), resObject);
                    if (this.fxElementNameList.indexOf(calObj.getCalId()) != -1) {
                        this.curFixedColVal.set(this.fxElementNameList.indexOf(calObj.getCalId()), resObject);
                        this.recordMap.put(calObj.getCalId(), resObject);
                    }
                }
            }
            ++ctr;
        }
    }

    private Double getCurrValueForLocVar(String locVarName) throws Exception {
        Double value = null;
        ArrayList groupedOnList = (ArrayList)this.locVarNameGroupMap.get(locVarName);
        StringBuffer keyStrBuff = new StringBuffer();
        value = new Double("0.0d");
        int i = 0;
        while (i < groupedOnList.size()) {
            keyStrBuff.append(this.recordMap.get(groupedOnList.get(i).toString()) + "~");
            ++i;
        }
        if (keyStrBuff.length() > 0) {
            keyStrBuff.deleteCharAt(keyStrBuff.length() - 1);
        }
        HashMap tmpMap = (HashMap)this.locVarMap.get(locVarName);
        value = new Double(tmpMap.get(keyStrBuff.toString()).toString());
        return value;
    }

    private void doAggCalculations() throws Exception {
        boolean isLocVarLoaded = false;
        boolean isColumn = false;
        int ctr = 0;
        while (ctr < this.noOfCalculations) {
            Calculation calObj = (Calculation)this.calObjList.get(ctr);
            if (calObj.isAggregate()) {
                if (ctr > 0 && ((Calculation)this.calObjList.get(ctr - 1)).getResult() != null) {
                    Object dataobj = ((Calculation)this.calObjList.get(ctr - 1)).getResult();
                    if (dataobj instanceof String) {
                        String calstr = (String)dataobj;
                        this.interpreter.set(((Calculation)this.calObjList.get(ctr - 1)).getCalId(), (Object)calstr);
                    } else if (dataobj instanceof Double) {
                        double caldouble = (Double)dataobj;
                        this.interpreter.set(((Calculation)this.calObjList.get(ctr - 1)).getCalId(), caldouble);
                    } else {
                        this.interpreter.set(((Calculation)this.calObjList.get(ctr - 1)).getCalId(), dataobj);
                    }
                }
                int cnt = 0;
                while (cnt < this.fxElementList.size()) {
                    String prevVal;
                    isColumn = this.fxElementList.get(cnt).getClass().toString().indexOf("Column") != -1;
                    String string = prevVal = this.prevFixedColVal.get(cnt) != null ? this.prevFixedColVal.get(cnt).toString() : null;
                    if (isColumn) {
                        if (prevVal != null && prevVal.length() > 0) {
                            if (((Column)this.fxElementList.get(cnt)).getDataType().indexOf("String") != -1) {
                                this.interpreter.set(((Column)this.fxElementList.get(cnt)).getLogicalName(), (Object)prevVal);
                            } else {
                                this.interpreter.set(((Column)this.fxElementList.get(cnt)).getLogicalName(), (Object)Double.valueOf(prevVal));
                            }
                        }
                    } else if (!(prevVal == null || prevVal.length() <= 0 || prevVal.equals("Infinity") || prevVal.equals("-Infinity") || prevVal.equals("NaN") || prevVal.equals("-NaN"))) {
                        Double dblObj = null;
                        try {
                            dblObj = Double.valueOf(prevVal);
                        }
                        catch (Exception e) {
                            dblObj = Double.valueOf("0.0d");
                        }
                        this.interpreter.set(((Calculation)this.fxElementList.get(cnt)).getCalId(), (Object)dblObj);
                    }
                    ++cnt;
                }
                if (this.crossTabMap.size() <= 0) {
                    boolean isEvelSucceeded = false;
                    String beanErrorString = null;
                    Object resObject = null;
                    try {
                        resObject = this.interpreter.eval(calObj.getExpression());
                        isEvelSucceeded = true;
                    }
                    catch (InterpreterError inte) {
                        System.out.println(" BISaxTrasformer--Interpreter Bean Exception: ==>\n" + (Object)((Object)inte));
                        inte.printStackTrace();
                        beanErrorString = inte.getMessage();
                    }
                    if (isEvelSucceeded) {
                        calObj.setResult(resObject);
                        calObj.setValid(true);
                    } else {
                        resObject = beanErrorString;
                        calObj.setResult("ERROR");
                        calObj.setValid(false);
                    }
                    if (calObj.getPlacement() == 2) {
                        this.prevFixedColVal.set(this.fxElementNameList.indexOf(calObj.getCalId()), resObject);
                        this.recordMap.put(calObj.getCalId(), resObject);
                    }
                }
                int ctn = 0;
                while (ctn < this.crossTabMap.size()) {
                    if (this.locVarNamesList != null && !isLocVarLoaded) {
                        int i = 0;
                        while (i < this.locVarNamesList.size()) {
                            isLocVarLoaded = true;
                            ++i;
                        }
                    }
                    int ctr1 = 0;
                    while (ctr1 < this.noOfValueColumns) {
                        Object curValue = this.rowDataArray[ctr1][ctn];
                        boolean bl = isColumn = this.vlElementList.get(ctr1).getClass().toString().indexOf("Column") != -1;
                        if (isColumn) {
                            if (curValue != null) {
                                if (((Column)this.vlElementList.get(ctr1)).getDataType().indexOf("String") != -1) {
                                    this.interpreter.set(((Column)this.vlElementList.get(ctr1)).getLogicalName(), (Object)curValue.toString());
                                } else {
                                    this.interpreter.set(((Column)this.vlElementList.get(ctr1)).getLogicalName(), (Object)Double.valueOf(curValue.toString()));
                                }
                            }
                        } else if (curValue != null) {
                            this.interpreter.set(((Calculation)this.vlElementList.get(ctr1)).getCalId(), curValue);
                        }
                        ++ctr1;
                    }
                    boolean isEvelSucceeded = false;
                    String beanErrorString = null;
                    Object resObject = null;
                    try {
                        resObject = this.interpreter.eval(calObj.getExpression());
                        isEvelSucceeded = true;
                    }
                    catch (InterpreterError inte) {
                        System.out.println(" BISaxTrasformer--Interpreter Bean Exception: ==>\n" + (Object)((Object)inte));
                        inte.printStackTrace();
                        beanErrorString = inte.getMessage();
                    }
                    if (isEvelSucceeded) {
                        calObj.setResult(resObject);
                        calObj.setValid(true);
                    } else {
                        resObject = beanErrorString;
                        calObj.setResult("ERROR");
                        calObj.setValid(false);
                    }
                    if (calObj.getPlacement() == 2) {
                        this.curFixedColVal.set(this.fxElementNameList.indexOf(calObj.getCalId()), resObject);
                        this.recordMap.put(calObj.getCalId(), resObject);
                    } else if (calObj.getPlacement() == 4) {
                        this.recordMap.put(calObj.getCalId(), resObject);
                        this.rowDataArray[this.vlElementNameList.indexOf((Object)calObj.getCalId())][ctn] = resObject;
                    }
                    ++ctn;
                }
            }
            ++ctr;
        }
    }

    private void compareData() throws Exception {
        boolean isChange = false;
        boolean isFirstRecord = false;
        if (this.rowDataArray != null) {
            this.rowDataArrayCopy = this.rowDataArray.clone();
        }
        if (this.prevFixedColVal == null) {
            this.prevFixedColVal = new ArrayList(this.curFixedColVal);
            if (this.isTotalPresent) {
                this.totalManager.evaluateAggregateTotals(this.prevFixedColVal, this.groupColVal, this.rowDataArrayCopy, this.recordMap);
            }
            isFirstRecord = true;
        }
        int ctr = 0;
        while (ctr < this.curFixedColVal.size()) {
            if (this.fxElementList.get(ctr).getClass().toString().indexOf("Column") != -1 && !((Column)this.fxElementList.get(ctr)).getExpression().equalsIgnoreCase("G")) {
                if (!this.getSuppressDuplicateRow() || this.getSuppressDuplicateRow() && ((Column)this.fxElementList.get(ctr)).isVisible()) {
                    ArrayList totList;
                    if (!((this.getSuppressDuplicateRow() || isFirstRecord || this.crossTabMap != null && this.crossTabMap.size() != 0) && this.curFixedColVal.get(ctr).toString().equalsIgnoreCase(this.prevFixedColVal.get(ctr).toString()) || this.curFixedColVal.get(ctr).toString().equalsIgnoreCase(this.prevFixedColVal.get(ctr).toString()))) {
                        isChange = true;
                        this.fixedColumnChanged(ctr);
                        ++this.noOfRows;
                        if (this.isTotalPresent) {
                            totList = this.totalManager.getTotals(this.fxElementNameList.get(ctr).toString(), this.noOfRows);
                            ArrayList titleList = this.totalManager.getTitleList();
                            this.writeTotals(totList, titleList, this.totalManager.getTitlePos());
                        }
                        this.prevFixedColVal = new ArrayList(this.curFixedColVal);
                        break;
                    }
                    if (!(isFirstRecord || this.getSuppressDuplicateRow() || isChange || ctr != this.curFixedColVal.size() - 2)) {
                        isChange = true;
                        this.fixedColumnChanged(ctr);
                        ++this.noOfRows;
                        if (this.isTotalPresent) {
                            totList = this.totalManager.getTotals(this.fxElementNameList.get(ctr).toString(), this.noOfRows);
                            ArrayList titleList = this.totalManager.getTitleList();
                            this.writeTotals(totList, titleList, this.totalManager.getTitlePos());
                        }
                        this.prevFixedColVal = new ArrayList(this.curFixedColVal);
                        break;
                    }
                }
            } else if (!isFirstRecord && this.fxElementTypeList.get(ctr).equals("NUMBER")) {
                String currVal;
                String prevVal;
                String defaultFunction = "SUM()";
                if (this.fxElementList.get(ctr).getClass().toString().indexOf("Column") != -1 && ((Column)this.fxElementList.get(ctr)).isVisible() && this.fxElementList.get(ctr).getClass().toString().indexOf("Column") != -1) {
                    defaultFunction = ((Column)this.fxElementList.get(ctr)).getDefaultFunction();
                }
                double accData = 0.0;
                double prevData = 0.0;
                double currData = 0.0;
                if (!(this.prevFixedColVal.get(ctr) == null || (prevVal = this.prevFixedColVal.get(ctr).toString()) == null || prevVal.length() <= 0 || prevVal.equals("Infinity") || prevVal.equals("-Infinity") || prevVal.equals("NaN") || prevVal.equals("-NaN"))) {
                    prevData = new Double(prevVal);
                }
                if (!(this.curFixedColVal.get(ctr) == null || (currVal = this.curFixedColVal.get(ctr).toString()) == null || currVal.length() <= 0 || currVal.equals("Infinity") || currVal.equals("-Infinity") || currVal.equals("NaN") || currVal.equals("-NaN"))) {
                    currData = new Double(currVal);
                }
                if (defaultFunction.indexOf("SUM") != -1 || defaultFunction.indexOf("AVG") != -1) {
                    accData = prevData + currData;
                } else if (defaultFunction.indexOf("COUNT") == -1) {
                    if (defaultFunction.indexOf("MIN") != -1) {
                        accData = prevData < currData ? prevData : currData;
                    } else if (defaultFunction.indexOf("MAX") != -1) {
                        accData = prevData > currData ? prevData : currData;
                    }
                }
                this.prevFixedColVal.set(ctr, new Double(accData).toString());
            }
            ++ctr;
        }
        this.updateData();
        if (this.isTotalPresent && !isFirstRecord) {
            this.totalManager.evaluateAggregateTotals(this.prevFixedColVal, this.groupColVal, this.rowDataArrayCopy, this.recordMap);
        }
        if (isChange) {
            int i = 0;
            while (i < this.noOfValueColumns) {
                this.curValueColVal.set(i, "0");
                ++i;
            }
        }
    }

    private String applyFormat(String dataStr, Object object) throws Exception {
        DateBean dtbean = new DateBean();
        Column colObj = null;
        Calculation calObj = null;
        Total totObj = null;
        String dataType = null;
        String units = null;
        String pattern = null;
        String dbPattern = null;
        double data = 0.0;
        double resultData = 0.0;
        boolean isRound = false;
        if (object.getClass().toString().indexOf("Column") != -1) {
            colObj = (Column)object;
            dataType = colObj.getDataType().toUpperCase();
            units = colObj.getUnits().toUpperCase();
            pattern = colObj.getDisplayPattern();
            dbPattern = colObj.getDBPattern();
            isRound = colObj.getRound();
        } else if (object.getClass().toString().indexOf("Calculation") != -1) {
            calObj = (Calculation)object;
            dataType = calObj.getResultType().toUpperCase();
            units = calObj.getUnits().toUpperCase();
            pattern = calObj.getPattern();
        } else if (object.getClass().toString().indexOf("Total") != -1) {
            totObj = (Total)object;
            dataType = totObj.getDataType().toUpperCase();
            units = totObj.getUnits().toUpperCase();
            pattern = totObj.getPattern();
        }
        if (dataType.indexOf("NUMBER") != -1 || dataType.indexOf("INTEGER") != -1 || dataType.indexOf("FLOAT") != -1 || dataType.indexOf("DOUBLE") != -1 || dataType.indexOf("DECIMAL") != -1) {
            DecimalFormat df = new DecimalFormat();
            if (dbPattern != null && !dbPattern.equalsIgnoreCase("null")) {
                if (dataStr.length() > 0) {
                    dataStr = dtbean.convertPattern(dbPattern, pattern, dataStr);
                }
                return dataStr;
            }
            if (dataStr.length() > 0) {
                if (!(dataStr.equalsIgnoreCase("Infinity") || dataStr.equalsIgnoreCase("-Infinity") || dataStr.equalsIgnoreCase("NaN") || dataStr.equalsIgnoreCase("-NaN"))) {
                    try {
                        data = Double.parseDouble(dataStr);
                    }
                    catch (Exception e) {
                        data = 0.0;
                    }
                }
            } else {
                data = 0.0;
            }
            if (pattern == null || pattern.equalsIgnoreCase("null")) {
                pattern = dataType.indexOf("INTEGER") != -1 ? "#,##0" : "#,##0.00";
            }
            df.applyPattern(pattern);
            resultData = this.applyUnits(units, data);
            if (isRound) {
                resultData = new Long(Math.round(resultData)).doubleValue();
            }
            return df.format(resultData);
        }
        if (dataType.indexOf("DATE") != -1 || dataType.indexOf("TIME") != -1) {
            SimpleDateFormat sdf = new SimpleDateFormat();
            String rtstr = "";
            if (dataStr.length() > 0) {
                if (dbPattern != null && !dbPattern.equalsIgnoreCase("null")) {
                    if (dataStr.length() > 0) {
                        dataStr = dtbean.convertPattern(dbPattern, pattern, dataStr);
                    }
                    return dataStr;
                }
                if (pattern == null || pattern.equalsIgnoreCase("null")) {
                    pattern = "dd-MM-yy";
                }
                sdf.applyPattern(pattern);
                if (dataType.indexOf("DATE") != -1) {
                    if (dataStr.contains(" ")) {
                        dataStr = dataStr.substring(0, dataStr.indexOf(" "));
                    }
                    rtstr = sdf.format(Date.valueOf(dataStr));
                } else {
                    rtstr = sdf.format(Timestamp.valueOf(dataStr));
                }
            } else {
                rtstr = dataStr;
            }
            return rtstr;
        }
        if ("UPPERCASE".equalsIgnoreCase(pattern)) {
            dataStr = dataStr.toUpperCase();
        } else if ("lowercase".equalsIgnoreCase(pattern)) {
            dataStr = dataStr.toLowerCase();
        } else if ("Title Case".equalsIgnoreCase(pattern)) {
            dataStr = this.initCap(dataStr, " ");
        } else if ("Paragraph".equalsIgnoreCase(pattern)) {
            dataStr = this.initCap(dataStr, ".");
        }
        return dataStr;
    }

    private double applyUnits(String units, double data) throws Exception {
        String[] numFormatArr = new String[]{"DEFAULT", "MYH", "MYT", "MYL", "MYM", "MYC", "RTF"};
        int index = -1;
        double resultData = 0.0;
        int i = 0;
        while (i < numFormatArr.length) {
            if (numFormatArr[i].equals(units)) {
                index = i;
                break;
            }
            ++i;
        }
        switch (index) {
            case 0: {
                resultData = data / 1.0;
                break;
            }
            case 1: {
                resultData = data / 100.0;
                break;
            }
            case 2: {
                resultData = data / 1000.0;
                break;
            }
            case 3: {
                resultData = data / 100000.0;
                break;
            }
            case 4: {
                resultData = data / 1000000.0;
                break;
            }
            case 5: {
                resultData = data / 1.0E7;
                break;
            }
            case 6: {
                break;
            }
            default: {
                resultData = data;
            }
        }
        return resultData;
    }

    private void fixedColumnChanged(int index) throws Exception {
        boolean isColumn = false;
        boolean isNumeric = false;
        if (this.prevFixedColVal != null) {
            this.doAggCalculations();
            ++this.rowCount;
            this.dataWriter.write("<row>");
            String formatedData = "";
            ArrayList<String> rowDataList = new ArrayList<String>();
            int ctr = 0;
            while (ctr < this.noOfFixedColumns) {
                boolean bl = isColumn = this.fxElementList.get(ctr).getClass().toString().indexOf("Column") != -1;
                if (isColumn && ((Column)this.fxElementList.get(ctr)).isVisible()) {
                    if (ctr >= this.changedFixedColCtr) {
                        formatedData = this.applyFormat(this.prevFixedColVal.get(ctr).toString(), this.fxElementList.get(ctr));
                        this.dataWriter.write("<value hide='0'><![CDATA[" + formatedData + "]]></value>");
                        rowDataList.add(formatedData);
                    } else {
                        int suppressVal = Boolean.valueOf(this.genProp.getSuppress()) != false ? 1 : 0;
                        formatedData = this.applyFormat(this.prevFixedColVal.get(ctr).toString(), this.fxElementList.get(ctr));
                        this.dataWriter.write("<value hide='" + suppressVal + "'><![CDATA[" + formatedData + "]]></value>");
                        if (suppressVal == 0) {
                            rowDataList.add(ctr, formatedData);
                        } else {
                            rowDataList.add("");
                        }
                    }
                } else if (!isColumn && ((Calculation)this.fxElementList.get(ctr)).isVisible() && ((Calculation)this.fxElementList.get(ctr)).isValid()) {
                    formatedData = this.applyFormat(this.prevFixedColVal.get(ctr).toString(), this.fxElementList.get(ctr));
                    this.dataWriter.write("<value><![CDATA[" + formatedData + "]]></value>");
                    rowDataList.add(formatedData);
                }
                ++ctr;
            }
            this.changedFixedColCtr = index;
            if (this.rowDataArray != null) {
                this.rowDataArrayCopy = this.rowDataArray.clone();
            }
            if (this.isTotalPresent) {
                this.totalManager.evaluateAggregateTotals(this.prevFixedColVal, this.groupColVal, this.rowDataArrayCopy, null);
                if (this.crossTabMap != null && this.crossTabMap.size() > 0) {
                    this.ctTotList = this.totalManager.getCtTotals();
                }
            }
            if (this.crossTabMap != null && this.crossTabMap.size() > 0) {
                ctr = 0;
                while (ctr < this.crossTabMap.size()) {
                    if (((String)this.crossTabMap.get(ctr)).indexOf(":") == -1) {
                        int ctr1 = 0;
                        while (ctr1 < this.noOfValueColumns) {
                            isColumn = this.vlElementList.get(ctr1).getClass().toString().indexOf("Column") != -1;
                            isNumeric = ((String)this.vlElementTypeList.get(ctr1)).indexOf("NUMBER") != -1;
                            Object curValue = this.rowDataArray[ctr1][ctr];
                            if (isColumn) {
                                if (!isNumeric) {
                                    if (((Column)this.vlElementList.get(ctr1)).isVisible()) {
                                        curValue = curValue == null ? new String("") : curValue;
                                        formatedData = this.applyFormat(curValue.toString(), this.vlElementList.get(ctr1));
                                        this.dataWriter.write("<value><![CDATA[" + formatedData + "]]></value>");
                                        rowDataList.add(formatedData);
                                        this.rowDataArray[ctr1][ctr] = new String("");
                                    } else {
                                        this.rowDataArray[ctr1][ctr] = new String("");
                                    }
                                } else if (((Column)this.vlElementList.get(ctr1)).isVisible()) {
                                    curValue = curValue == null ? new Double("0") : curValue;
                                    formatedData = this.applyFormat(((Double)curValue).toString(), this.vlElementList.get(ctr1));
                                    this.dataWriter.write("<value><![CDATA[" + formatedData + "]]></value>");
                                    rowDataList.add(formatedData);
                                    this.rowDataArray[ctr1][ctr] = new Double("0");
                                } else {
                                    this.rowDataArray[ctr1][ctr] = new Double("0");
                                }
                            } else if (!isColumn && ((Calculation)this.vlElementList.get(ctr1)).isValid()) {
                                if (!isNumeric) {
                                    if (((Calculation)this.vlElementList.get(ctr1)).isVisible()) {
                                        curValue = curValue == null ? new String("") : curValue;
                                        formatedData = this.applyFormat(curValue.toString(), this.vlElementList.get(ctr1));
                                        this.dataWriter.write("<value><![CDATA[" + formatedData + "]]></value>");
                                        rowDataList.add(formatedData);
                                        this.rowDataArray[ctr1][ctr] = new String("");
                                    } else {
                                        this.rowDataArray[ctr1][ctr] = new String("");
                                    }
                                } else if (((Calculation)this.vlElementList.get(ctr1)).isVisible()) {
                                    curValue = curValue == null ? new Double("0") : curValue;
                                    formatedData = this.applyFormat(((Double)curValue).toString(), this.vlElementList.get(ctr1));
                                    this.dataWriter.write("<value><![CDATA[" + formatedData + "]]></value>");
                                    rowDataList.add(formatedData);
                                    this.rowDataArray[ctr1][ctr] = new Double("0");
                                } else {
                                    this.rowDataArray[ctr1][ctr] = new Double("0");
                                }
                            }
                            ++ctr1;
                        }
                    } else if (this.ctTotList.size() > 0 && this.ctTotList.get(ctr).toString().trim().length() > 0) {
                        formatedData = this.ctTotList.get(ctr).toString();
                        this.dataWriter.write("<value><![CDATA[" + formatedData + "]]></value>");
                        rowDataList.add(formatedData);
                    }
                    ++ctr;
                }
            }
            this.dataWriter.write("</row>\n");
            if (this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") || this.genProp.getOutputType().equalsIgnoreCase("HTML") || this.genProp.getOutputType().equalsIgnoreCase("Excel") || this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth")) {
                this.contentManager.addDataRow(rowDataList);
            }
        }
    }

    private int calnoOfValueTags() throws Exception {
        int ctMapSize = this.crossTabMap.size();
        int noOfTotals = this.totalObjList.size();
        boolean vlTagSize = false;
        int noOfCtTotals = 0;
        int i = 0;
        while (i < ctMapSize) {
            int j = 0;
            while (j < noOfTotals) {
                if (this.crossTabMap.get(i).toString().indexOf(((Total)this.totalObjList.get(j)).getTotalId()) != -1) {
                    ++noOfCtTotals;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return this.noOfVisibleFixedColumns + (this.crossTabMap.size() - noOfCtTotals) * this.noOfVisibleValueColumns + noOfCtTotals;
    }

    private void writeTotals(ArrayList totList, ArrayList titleList, ArrayList titlePos) throws Exception {
        ArrayList<String> totalValuesList = new ArrayList<String>();
        int cnt = 0;
        int valueTagSize = this.calnoOfValueTags();
        int i = 0;
        while (i < totList.size()) {
            totalValuesList.clear();
            ++this.rowCount;
            this.dataWriter.write("<row>");
            ArrayList<String> rowDataList = new ArrayList<String>();
            int ctr = 0;
            while (ctr < valueTagSize) {
                totalValuesList.add("<value><![CDATA[]]></value>");
                rowDataList.add("");
                ++ctr;
            }
            HashMap rowMap = (HashMap)totList.get(i);
            Set keys = rowMap.keySet();
            Iterator iterator = keys.iterator();
            boolean isFirst = false;
            while (iterator.hasNext()) {
                String currCrossTabValue;
                isFirst = true;
                int index = 0;
                ArrayList colPosList = (ArrayList)iterator.next();
                ArrayList valueList = (ArrayList)rowMap.get(colPosList);
                String title = (String)titleList.get(cnt);
                int pos = Integer.parseInt((String)titlePos.get(cnt));
                totalValuesList.set(pos, "<value><![CDATA[" + title + "]]></value>");
                rowDataList.set(pos, title);
                if (valueList.size() == 1) {
                    String value = valueList.get(0).toString();
                    totalValuesList.set((Integer)colPosList.get(0), "<value><![CDATA[" + value + "]]></value>");
                    rowDataList.set((Integer)colPosList.get(0), value);
                    continue;
                }
                int writePos = -1;
                String value = null;
                String filter = "~";
                int k = 0;
                while (k < valueList.size()) {
                    value = valueList.get(k).toString();
                    if (value.length() > 0 && !value.equals("0.0d")) {
                        currCrossTabValue = (String)this.crossTabMap.get(k);
                        if (currCrossTabValue.indexOf("~") != -1) {
                            filter = "~";
                            break;
                        }
                        if (currCrossTabValue.indexOf("$") != -1) {
                            filter = currCrossTabValue.substring(0, currCrossTabValue.indexOf(":"));
                            break;
                        }
                    }
                    ++k;
                }
                k = 0;
                while (k < valueList.size()) {
                    value = valueList.get(k).toString();
                    currCrossTabValue = (String)this.crossTabMap.get(k);
                    if (currCrossTabValue.indexOf("~") != -1) {
                        currCrossTabValue = "~";
                    }
                    if (currCrossTabValue.indexOf("$") != -1) {
                        currCrossTabValue = currCrossTabValue.substring(0, currCrossTabValue.indexOf(":"));
                    }
                    if (currCrossTabValue.equals(filter) && !value.equals("0.0d")) {
                        if (value.length() == 0) {
                            value = "0.00";
                        }
                        writePos = (Integer)colPosList.get(index);
                        totalValuesList.set(writePos, "<value><![CDATA[" + value + "]]></value>");
                        rowDataList.set(writePos, value);
                        ++index;
                    }
                    ++k;
                }
            }
            int ctr2 = 0;
            while (ctr2 < totalValuesList.size()) {
                this.dataWriter.write((String)totalValuesList.get(ctr2));
                ++ctr2;
            }
            this.dataWriter.write("</row>\n");
            if (this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") || this.genProp.getOutputType().equalsIgnoreCase("HTML") || this.genProp.getOutputType().equalsIgnoreCase("Excel") || this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth")) {
                this.contentManager.addDataRow(rowDataList);
            }
            ++cnt;
            ++i;
        }
    }

    private void updateData() throws Exception {
        Object newValue = null;
        String curDataType = "";
        int ctr = 0;
        while (ctr < this.curValueColVal.size()) {
            boolean isNumeric;
            newValue = this.curValueColVal.get(ctr);
            newValue = newValue == null ? "" : newValue;
            boolean bl = isNumeric = ((String)this.vlElementTypeList.get(ctr)).indexOf("NUMBER") != -1;
            newValue = !isNumeric ? (newValue.toString().length() <= 0 ? "" : newValue) : (newValue.toString().length() <= 0 || newValue.toString().equalsIgnoreCase("NaN") || newValue.toString().equalsIgnoreCase("Infinity") || newValue.toString().equalsIgnoreCase("-Infinity") ? new Double("0") : newValue);
            int posOfValue = 0;
            posOfValue = this.crossTabMap.size() == 0 ? 0 : this.crossTabMap.indexOf(this.crossTabValue);
            Double dbValue = null;
            String strValue = "";
            if (this.rowDataArray[ctr][posOfValue] == null) {
                if (!isNumeric) {
                    strValue = newValue.toString();
                    this.rowDataArray[ctr][posOfValue] = strValue;
                } else {
                    dbValue = new Double(newValue.toString());
                    this.rowDataArray[ctr][posOfValue] = dbValue;
                }
            } else if (!isNumeric) {
                strValue = !this.rowDataArray[ctr][posOfValue].toString().equals("") ? String.valueOf(strValue) + ((String)this.rowDataArray[ctr][posOfValue]).toString() + "," + newValue.toString() : String.valueOf(strValue) + newValue.toString();
                this.rowDataArray[ctr][posOfValue] = strValue;
            } else {
                dbValue = new Double((Double)this.rowDataArray[ctr][posOfValue] + Double.parseDouble(newValue.toString()));
                this.rowDataArray[ctr][posOfValue] = dbValue;
            }
            ++ctr;
        }
    }

    private void buildColDefPart() throws Exception {
        this.fWriter.write("<coldef>\n");
        int noOfColumnElements = this.fxElementList.size();
        boolean isColumn = false;
        this.colDefList = new ArrayList();
        int ctr = 0;
        while (ctr < noOfColumnElements) {
            if (this.fxElementList.get(ctr) != null) {
                Column newColObj;
                boolean bl = isColumn = this.fxElementList.get(ctr).getClass().toString().indexOf("Column") != -1;
                if (isColumn && ((Column)this.fxElementList.get(ctr)).isVisible()) {
                    Column curColObj = (Column)this.fxElementList.get(ctr);
                    newColObj = (Column)curColObj.clone();
                    this.fWriter.write("<column>\n");
                    this.fWriter.write("<heading><![CDATA[" + curColObj.getDisplayName() + "]]></heading>\n");
                    String typeString = curColObj.getDataType();
                    typeString = typeString.substring(typeString.lastIndexOf(".") + 1);
                    this.fWriter.write("<type>" + typeString + "</type>\n");
                    newColObj.setDataType(curColObj.getDataType());
                    if (!curColObj.getUnits().equalsIgnoreCase("default") && !curColObj.getUnits().equalsIgnoreCase(this.genProp.getUnits())) {
                        this.fWriter.write("<format>" + curColObj.getUnits() + "</format>\n");
                    } else {
                        this.fWriter.write("<format>" + this.genProp.getUnits() + "</format>\n");
                        newColObj.setUnits(this.genProp.getUnits());
                    }
                    if (curColObj.getRound() || this.genProp.getRound()) {
                        this.fWriter.write("<round>true</round>\n");
                        newColObj.setRound(true);
                    } else {
                        this.fWriter.write("<round>false</round>\n");
                        newColObj.setRound(false);
                    }
                    this.fWriter.write("<fontfamily>" + curColObj.getFont() + "</fontfamily>\n");
                    this.fWriter.write("<fontsize>" + curColObj.getFontSize() + "</fontsize>\n");
                    this.fWriter.write("<width>" + curColObj.getWidth() + "</width>\n");
                    this.fWriter.write("<bold>" + curColObj.getBold() + "</bold>\n");
                    this.fWriter.write("<italic>" + curColObj.getItalic() + "</italic>\n");
                    this.fWriter.write("<underline>" + curColObj.getUnderline() + "</underline>\n");
                    this.fWriter.write("<align>" + curColObj.getAlignment() + "</align>\n");
                    this.fWriter.write("<fgcolor>" + curColObj.getFGColor() + "</fgcolor>\n");
                    this.fWriter.write("<bgcolor>" + curColObj.getBGColor() + "</bgcolor>\n");
                    this.fWriter.write("<logicalname>" + curColObj.getLogicalName() + "</logicalname>\n");
                    this.fWriter.write("<capitalize>" + curColObj.isCaps() + "</capitalize>\n");
                    this.fWriter.write("<placement>" + curColObj.getPlacement() + "</placement>\n");
                    this.fWriter.write("<position>" + curColObj.getPosition() + "</position>\n");
                    this.fWriter.write("</column>\n");
                    this.colDefList.add(newColObj);
                } else if (!isColumn && ((Calculation)this.fxElementList.get(ctr)).isVisible() && ((Calculation)this.fxElementList.get(ctr)).isValid()) {
                    Calculation curCalObj = (Calculation)this.fxElementList.get(ctr);
                    newColObj = new Column();
                    this.fWriter.write("<column>\n");
                    this.fWriter.write("<heading><![CDATA[" + curCalObj.getTitle() + "]]></heading>\n");
                    newColObj.setDisplayName(curCalObj.getTitle());
                    this.fWriter.write("<type>" + curCalObj.getResultType() + "</type>\n");
                    newColObj.setDataType(curCalObj.getResultType());
                    this.fWriter.write("<format>" + this.genProp.getUnits() + "</format>\n");
                    newColObj.setUnits(this.genProp.getUnits());
                    this.fWriter.write("<round>" + this.genProp.getRound() + "</round>\n");
                    newColObj.setRound(this.genProp.getRound());
                    this.fWriter.write("<fontfamily>" + curCalObj.getFont() + "</fontfamily>\n");
                    newColObj.setFont(curCalObj.getFont());
                    this.fWriter.write("<fontsize>" + curCalObj.getFontSize() + "</fontsize>\n");
                    newColObj.setFontSize(curCalObj.getFontSize());
                    this.fWriter.write("<width>" + curCalObj.getWidth() + "</width>\n");
                    newColObj.setWidth(curCalObj.getWidth());
                    this.fWriter.write("<bold>" + curCalObj.getBold() + "</bold>\n");
                    newColObj.setBold(curCalObj.getBold());
                    this.fWriter.write("<italic>" + curCalObj.getItalic() + "</italic>\n");
                    newColObj.setItalic(curCalObj.getItalic());
                    this.fWriter.write("<underline>" + curCalObj.getUnderline() + "</underline>\n");
                    newColObj.setUnderline(curCalObj.getUnderline());
                    this.fWriter.write("<align>" + curCalObj.getAlignment() + "</align>\n");
                    newColObj.setAlignment(curCalObj.getAlignment());
                    this.fWriter.write("<fgcolor>" + curCalObj.getFGColor() + "</fgcolor>\n");
                    newColObj.setFGColor(curCalObj.getFGColor());
                    this.fWriter.write("<bgcolor>" + curCalObj.getBGColor() + "</bgcolor>\n");
                    newColObj.setBGColor(curCalObj.getBGColor());
                    this.fWriter.write("<logicalname>" + curCalObj.getCalId() + "</logicalname>\n");
                    newColObj.setLogicalName(curCalObj.getCalId());
                    this.fWriter.write("<capitalize>" + curCalObj.isCaps() + "</capitalize>\n");
                    newColObj.setCaps(curCalObj.isCaps());
                    this.fWriter.write("<placement>" + curCalObj.getPlacement() + "</placement>\n");
                    newColObj.setPlacement(curCalObj.getPlacement());
                    this.fWriter.write("<position>" + curCalObj.getPosition() + "</position>\n");
                    newColObj.setPosition(curCalObj.getPosition());
                    this.fWriter.write("</column>\n");
                    newColObj.setDisplayPattern(curCalObj.getPattern());
                    this.colDefList.add(newColObj);
                }
            }
            ++ctr;
        }
        int sizeOfCrossTabMap = this.crossTabMap.size();
        int ctr2 = 0;
        while (ctr2 < sizeOfCrossTabMap) {
            String curKey = (String)this.crossTabMap.get(ctr2);
            if (curKey.indexOf(":") == -1) {
                int ctr1 = 0;
                while (ctr1 < this.noOfValueColumns) {
                    if (this.vlElementList.get(ctr1) != null) {
                        Column newColObj;
                        boolean bl = isColumn = this.vlElementList.get(ctr1).getClass().toString().indexOf("Column") != -1;
                        if (isColumn && ((Column)this.vlElementList.get(ctr1)).isVisible()) {
                            Column curColObj = (Column)this.vlElementList.get(ctr1);
                            newColObj = (Column)curColObj.clone();
                            this.fWriter.write("<column>\n");
                            this.fWriter.write("<heading><![CDATA[" + curKey + curColObj.getDisplayName() + "]]></heading>\n");
                            newColObj.setDisplayName(String.valueOf(curKey) + curColObj.getDisplayName());
                            String typeString = curColObj.getDataType();
                            typeString = typeString.substring(typeString.lastIndexOf(".") + 1);
                            this.fWriter.write("<type>" + typeString + "</type>\n");
                            newColObj.setDataType(typeString);
                            if (!curColObj.getUnits().equalsIgnoreCase("default") && !curColObj.getUnits().equalsIgnoreCase(this.genProp.getUnits())) {
                                this.fWriter.write("<format>" + curColObj.getUnits() + "</format>\n");
                            } else {
                                this.fWriter.write("<format>" + this.genProp.getUnits() + "</format>\n");
                                newColObj.setUnits(this.genProp.getUnits());
                            }
                            if (curColObj.getRound() || this.genProp.getRound()) {
                                this.fWriter.write("<round>true</round>\n");
                                newColObj.setRound(true);
                            } else {
                                this.fWriter.write("<round>false</round>\n");
                                newColObj.setRound(false);
                            }
                            this.fWriter.write("<fontfamily>" + curColObj.getFont() + "</fontfamily>\n");
                            this.fWriter.write("<fontsize>" + curColObj.getFontSize() + "</fontsize>\n");
                            this.fWriter.write("<width>" + curColObj.getWidth() + "</width>\n");
                            this.fWriter.write("<bold>" + curColObj.getBold() + "</bold>\n");
                            this.fWriter.write("<italic>" + curColObj.getItalic() + "</italic>\n");
                            this.fWriter.write("<underline>" + curColObj.getUnderline() + "</underline>\n");
                            this.fWriter.write("<align>" + curColObj.getAlignment() + "</align>\n");
                            this.fWriter.write("<fgcolor>" + curColObj.getFGColor() + "</fgcolor>\n");
                            this.fWriter.write("<bgcolor>" + curColObj.getBGColor() + "</bgcolor>\n");
                            this.fWriter.write("<logicalname>" + curColObj.getLogicalName() + "</logicalname>\n");
                            this.fWriter.write("<capitalize>" + curColObj.isCaps() + "</capitalize>\n");
                            this.fWriter.write("<placement>" + curColObj.getPlacement() + "</placement>\n");
                            this.fWriter.write("<position>" + curColObj.getPosition() + "</position>\n");
                            this.fWriter.write("</column>\n");
                            this.colDefList.add(newColObj);
                        } else if (!isColumn && ((Calculation)this.vlElementList.get(ctr1)).isVisible() && ((Calculation)this.vlElementList.get(ctr1)).isValid()) {
                            Calculation curCalObj = (Calculation)this.vlElementList.get(ctr1);
                            newColObj = new Column();
                            this.fWriter.write("<column>\n");
                            this.fWriter.write("<heading><![CDATA[" + curKey + curCalObj.getTitle() + "]]></heading>\n");
                            newColObj.setDisplayName(String.valueOf(curKey) + curCalObj.getTitle());
                            this.fWriter.write("<type>" + curCalObj.getResultType() + "</type>\n");
                            newColObj.setDataType(curCalObj.getResultType());
                            this.fWriter.write("<format>" + this.genProp.getUnits() + "</format>\n");
                            newColObj.setUnits(this.genProp.getUnits());
                            this.fWriter.write("<round>" + this.genProp.getRound() + "</round>\n");
                            newColObj.setRound(this.genProp.getRound());
                            this.fWriter.write("<fontfamily>" + curCalObj.getFont() + "</fontfamily>\n");
                            newColObj.setFont(curCalObj.getFont());
                            this.fWriter.write("<fontsize>" + curCalObj.getFontSize() + "</fontsize>\n");
                            newColObj.setFontSize(curCalObj.getFontSize());
                            this.fWriter.write("<width>" + curCalObj.getWidth() + "</width>\n");
                            newColObj.setWidth(curCalObj.getWidth());
                            this.fWriter.write("<bold>" + curCalObj.getBold() + "</bold>\n");
                            newColObj.setBold(curCalObj.getBold());
                            this.fWriter.write("<italic>" + curCalObj.getItalic() + "</italic>\n");
                            newColObj.setItalic(curCalObj.getItalic());
                            this.fWriter.write("<underline>" + curCalObj.getUnderline() + "</underline>\n");
                            newColObj.setUnderline(curCalObj.getUnderline());
                            this.fWriter.write("<align>" + curCalObj.getAlignment() + "</align>\n");
                            newColObj.setAlignment(curCalObj.getAlignment());
                            this.fWriter.write("<fgcolor>" + curCalObj.getFGColor() + "</fgcolor>\n");
                            newColObj.setFGColor(curCalObj.getFGColor());
                            this.fWriter.write("<bgcolor>" + curCalObj.getBGColor() + "</bgcolor>\n");
                            newColObj.setBGColor(curCalObj.getBGColor());
                            this.fWriter.write("<logicalname>" + curCalObj.getCalId() + "</logicalname>\n");
                            newColObj.setLogicalName(curCalObj.getCalId());
                            this.fWriter.write("<capitalize>" + curCalObj.isCaps() + "</capitalize>\n");
                            newColObj.setCaps(curCalObj.isCaps());
                            this.fWriter.write("<placement>" + curCalObj.getPlacement() + "</placement>\n");
                            newColObj.setPlacement(curCalObj.getPlacement());
                            this.fWriter.write("<position>" + curCalObj.getPosition() + "</position>\n");
                            newColObj.setPosition(curCalObj.getPosition());
                            this.fWriter.write("</column>\n");
                            newColObj.setDisplayPattern(curCalObj.getPattern());
                            this.colDefList.add(newColObj);
                        }
                    }
                    ++ctr1;
                }
            } else {
                String sep = "";
                boolean isCtTotal = false;
                int i = 0;
                while (i < this.noOfCrossTabColumns) {
                    sep = String.valueOf(sep) + ": ";
                    ++i;
                }
                i = 0;
                while (i < this.noOfTotals) {
                    Total totObj = (Total)this.totalObjList.get(i);
                    if (totObj.isVisible()) {
                        int placement = totObj.getPlacement();
                        ArrayList groupedList = totObj.getGroupedOnList();
                        int cnt = 0;
                        while (cnt < groupedList.size()) {
                            if (this.ctElementNameList.contains(groupedList.get(cnt).toString())) {
                                isCtTotal = true;
                                break;
                            }
                            ++cnt;
                        }
                        if (placement == 3 || this.isCrossTabTotal || isCtTotal) {
                            String id = totObj.getTotalId();
                            String ctId = this.crossTabMap.get(ctr2).toString();
                            String formatedCt = this.getFormatedCt(ctId, ctr2);
                            if (id.equals(ctId = ctId.substring(0, ctId.indexOf(":")))) {
                                Column newColObj = new Column();
                                this.fWriter.write("<column>\n");
                                this.fWriter.write("<heading><![CDATA[" + formatedCt + totObj.getTitle() + sep + "]]></heading>\n");
                                newColObj.setDisplayName(String.valueOf(formatedCt) + totObj.getTitle());
                                this.fWriter.write("<type>NUMBER</type>\n");
                                newColObj.setDataType("NUMBER");
                                this.fWriter.write("<format>TotalColumn</format>\n");
                                newColObj.setUnits("TotalColumn");
                                this.fWriter.write("<fontfamily>" + totObj.getFont() + "</fontfamily>\n");
                                newColObj.setFont(totObj.getFont());
                                this.fWriter.write("<fontsize>" + totObj.getFontSize() + "</fontsize>\n");
                                newColObj.setFontSize(totObj.getFontSize());
                                this.fWriter.write("<width>" + totObj.getWidth() + "</width>\n");
                                newColObj.setWidth(totObj.getWidth());
                                this.fWriter.write("<bold>" + totObj.getBold() + "</bold>\n");
                                newColObj.setBold(totObj.getBold());
                                this.fWriter.write("<italic>" + totObj.getItalic() + "</italic>\n");
                                newColObj.setItalic(totObj.getItalic());
                                this.fWriter.write("<underline>" + totObj.getUnderline() + "</underline>\n");
                                newColObj.setUnderline(totObj.getUnderline());
                                this.fWriter.write("<align>" + totObj.getAlignment() + "</align>\n");
                                newColObj.setAlignment(totObj.getAlignment());
                                this.fWriter.write("<fgcolor>" + totObj.getFGColor() + "</fgcolor>\n");
                                newColObj.setFGColor(totObj.getFGColor());
                                this.fWriter.write("<bgcolor>" + totObj.getBGColor() + "</bgcolor>\n");
                                newColObj.setBGColor(totObj.getBGColor());
                                this.fWriter.write("<logicalname>" + totObj.getTotalId() + "</logicalname>\n");
                                newColObj.setLogicalName(totObj.getTotalId());
                                this.fWriter.write("<capitalize>" + totObj.isCaps() + "</capitalize>\n");
                                this.fWriter.write("<placement>3</placement>\n");
                                newColObj.setPlacement(3);
                                this.fWriter.write("<position>0</position>\n");
                                newColObj.setPosition(0);
                                this.fWriter.write("</column>\n");
                                newColObj.setDisplayPattern(totObj.getPattern());
                                this.colDefList.add(newColObj);
                            }
                        }
                    }
                    ++i;
                }
            }
            ++ctr2;
        }
        this.fWriter.write("</coldef>\n");
    }

    private String getFormatedCt(String ctId, int ctIndex) throws Exception {
        StringBuffer formatedCtStringBuff = new StringBuffer();
        String grpCountStr = ctId.substring(ctId.lastIndexOf(":") + 1).trim();
        int grpCount = Integer.parseInt(grpCountStr);
        int tempCtr = ctIndex;
        String tempPrevCtId = "";
        while ((tempPrevCtId = this.crossTabMap.get(--tempCtr).toString()).indexOf("~") == -1) {
        }
        int gCnt = 0;
        while (gCnt <= grpCount) {
            formatedCtStringBuff.append(tempPrevCtId.substring(0, tempPrevCtId.indexOf("~") + 1));
            tempPrevCtId = tempPrevCtId.substring(tempPrevCtId.indexOf("~") + 1);
            ++gCnt;
        }
        gCnt = grpCount;
        while (gCnt < this.noOfCrossTabColumns - 1) {
            formatedCtStringBuff.append("All~");
            ++gCnt;
        }
        return formatedCtStringBuff.toString();
    }

    private String getCrossTabString() throws Exception {
        StringBuffer crossStringBuff = new StringBuffer();
        ArrayList<String> crossTabDisplayNames = new ArrayList<String>();
        ArrayList<String> crossTabLogicalNames = new ArrayList<String>();
        int ctr = 0;
        while (ctr < this.ctElementList.size()) {
            crossTabDisplayNames.add(((Column)this.ctElementList.get(ctr)).getDisplayName());
            crossTabLogicalNames.add(((Column)this.ctElementList.get(ctr)).getLogicalName());
            ++ctr;
        }
        String st = "";
        String st1 = "";
        int i = 0;
        while (i < this.ctElementList.size()) {
            st = String.valueOf(st) + (String)crossTabDisplayNames.get(i);
            st1 = String.valueOf(st1) + (String)crossTabLogicalNames.get(i);
            if (i != this.ctElementNameList.size() - 1) {
                st = String.valueOf(st) + ",";
                st1 = String.valueOf(st1) + ",";
            }
            ++i;
        }
        crossStringBuff.append("<crossTabTitles><![CDATA[" + st + "]]></crossTabTitles>\n");
        crossStringBuff.append("<crossTabLogicalName><![CDATA[" + st1 + "]]></crossTabLogicalName>\n");
        return crossStringBuff.toString();
    }

    private void setSortInfo(ArrayList allFieldSeqTypeList) throws Exception {
        StringBuffer sortInfoBuffer = new StringBuffer();
        String[] paramNames = new String[]{"colno", "type", "sorttype"};
        int noOfField = ((ArrayList)allFieldSeqTypeList.get(0)).size();
        int sizeOfParams = allFieldSeqTypeList.size();
        int oCtr = 0;
        while (oCtr < noOfField) {
            StringBuffer eachSortBuffer = new StringBuffer();
            int iCtr = 0;
            while (iCtr < sizeOfParams) {
                eachSortBuffer.append("<" + paramNames[iCtr] + ">");
                eachSortBuffer.append(((ArrayList)allFieldSeqTypeList.get(oCtr)).get(iCtr));
                eachSortBuffer.append("</" + paramNames[iCtr] + ">");
                ++iCtr;
            }
            sortInfoBuffer.append("<sort id=\"" + (oCtr + 1) + "\">").append(eachSortBuffer.toString()).append("</sort>");
            ++oCtr;
        }
        if (sortInfoBuffer.length() > 0) {
            this.sortInfoString = sortInfoBuffer.toString();
        }
    }

    private String getSortInfoString() throws Exception {
        if (this.sortInfoString == null) {
            this.sortInfoString = "";
        }
        return this.sortInfoString;
    }

    private String getDrillString() throws Exception {
        ArrayList child;
        StringBuffer drillStringBuff = new StringBuffer();
        DrillParser drillParser = new DrillParser(this.baName);
        ArrayList drillItems = new ArrayList();
        ArrayList drillLogicalItems = new ArrayList();
        drillItems = drillParser.getDisplayNames();
        drillLogicalItems = drillParser.getTagNames();
        int h = 0;
        while (h < drillItems.size()) {
            drillStringBuff.append("<hierarchie>\n");
            child = (ArrayList)drillItems.get(h);
            ArrayList childLogical = (ArrayList)drillLogicalItems.get(h);
            drillStringBuff.append("<drillid>" + child.get(0) + "</drillid>\n");
            int x = 1;
            while (x < child.size()) {
                String drillCol = (String)child.get(x);
                int pos = 0;
                while (pos < this.columns.length) {
                    if (this.columns[pos].getLogicalName().equalsIgnoreCase((String)childLogical.get(x))) {
                        drillCol = this.columns[pos].getDisplayName();
                        break;
                    }
                    ++pos;
                }
                drillStringBuff.append("<drillcolumn>" + drillCol + "</drillcolumn>");
                ++x;
            }
            drillStringBuff.append("</hierarchie>");
            ++h;
        }
        h = 0;
        while (h < drillLogicalItems.size()) {
            drillStringBuff.append("<loghierarchie>");
            child = (ArrayList)drillLogicalItems.get(h);
            drillStringBuff.append("<drillid>" + child.get(0) + "</drillid>\n");
            int x = 1;
            while (x < child.size()) {
                drillStringBuff.append("<drillcolumn>" + child.get(x) + "</drillcolumn>");
                ++x;
            }
            drillStringBuff.append("</loghierarchie>");
            ++h;
        }
        return drillStringBuff.toString();
    }

    public void setDrillAcrossString(String drillAcrossString) throws Exception {
        try {
            this.drillAcrossString = drillAcrossString;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private String getDrillAcrossString() throws Exception {
        return this.drillAcrossString;
    }

    private String getBIProperties() throws Exception {
        int i;
        StringBuffer propStringBuff = new StringBuffer();
        int noOfVisibleGroupCols = 0;
        int noOfVisibleFixedCols = 0;
        int noOfVisibleCrossTabCols = 0;
        int noOfVisibleValueCols = 0;
        int i2 = 0;
        while (i2 < this.columns.length) {
            if (this.columns[i2].getPlacement() == 1 && this.columns[i2].isExists() && this.columns[i2].isVisible()) {
                ++noOfVisibleGroupCols;
            } else if (this.columns[i2].getPlacement() == 2 && this.columns[i2].isExists() && this.columns[i2].isVisible()) {
                ++noOfVisibleFixedCols;
            } else if (this.columns[i2].getPlacement() == 3 && this.columns[i2].isExists() && this.columns[i2].isVisible()) {
                ++noOfVisibleCrossTabCols;
            }
            if (this.columns[i2].getPlacement() == 4 && this.columns[i2].isExists() && this.columns[i2].isVisible()) {
                ++noOfVisibleValueCols;
            }
            ++i2;
        }
        if (this.calObjList != null) {
            int ctr = 0;
            while (ctr < this.calObjList.size()) {
                if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 1 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleGroupCols;
                } else if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 2 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleFixedCols;
                } else if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 3 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleCrossTabCols;
                }
                if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 4 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleValueCols;
                }
                ++ctr;
            }
        }
        boolean visible = true;
        if (this.whereCondition != null) {
            Iterator itr = this.whereCondition.keySet().iterator();
            int size = this.whereCondition.size();
            String[] condiNameArray = new String[size];
            String[] condiValueArray = new String[size];
            int j = 0;
            String imagePath = "/ibase/FCKEditor/editor/dialog/images/button.about.gif";
            String rOpervalue = null;
            while (itr.hasNext()) {
                String label = (String)itr.next();
                String labelValue = (String)this.whereCondition.get(label);
                if (labelValue.indexOf("&&") != -1) {
                    StringTokenizer st = new StringTokenizer(labelValue = labelValue.substring(labelValue.indexOf("&&"), labelValue.lastIndexOf("&&") + 2), "&&");
                    rOpervalue = st.nextToken();
                    if (rOpervalue.indexOf(".") != -1) {
                        rOpervalue = rOpervalue.substring(0, rOpervalue.indexOf("."));
                    }
                    ArrayList argValueList = null;
                    String argValue = null;
                    int i3 = 0;
                    while (i3 < this.argumentList.size()) {
                        Argument argObj = (Argument)this.argumentList.get(i3);
                        if (argObj.getArgOrder().equals(rOpervalue)) {
                            argValueList = argObj.getArgValue();
                            StringBuffer argValueBuff = new StringBuffer();
                            int argValueCount = 0;
                            while (argValueCount < argValueList.size()) {
                                String tempArgValue = (String)argValueList.get(argValueCount);
                                argValueBuff.append(String.valueOf(tempArgValue) + ",");
                                ++argValueCount;
                            }
                            labelValue = argValue = argValueBuff.deleteCharAt(argValueBuff.length() - 1).toString();
                            if (st.countTokens() <= 1) break;
                            Argument argObjAnd = (Argument)this.argumentList.get(i3 + 1);
                            argValueList = argObjAnd.getArgValue();
                            argValueBuff = new StringBuffer();
                            int argValueCount2 = 0;
                            while (argValueCount2 < argValueList.size()) {
                                String tempArgValue = (String)argValueList.get(argValueCount2);
                                argValueBuff.append(String.valueOf(tempArgValue) + ",");
                                ++argValueCount2;
                            }
                            argValue = argValueBuff.deleteCharAt(argValueBuff.length() - 1).toString();
                            labelValue = String.valueOf(labelValue) + " And " + argValue;
                            break;
                        }
                        ++i3;
                    }
                }
                condiNameArray[j] = "~<img alt=\"" + label + "\" src=\"" + imagePath + "\"/>~";
                if (labelValue.equals("%")) {
                    labelValue = "All";
                }
                condiValueArray[j] = labelValue;
                ++j;
            }
            String tempTitle = this.genProp.getTitle();
            int k = 0;
            while (k < condiNameArray.length) {
                String bufferTitle = "";
                int index = tempTitle.indexOf(condiNameArray[k]);
                if (index != -1) {
                    String subStr = tempTitle.substring(index + condiNameArray[k].length(), tempTitle.length());
                    int tildIndex = subStr.indexOf("~~");
                    bufferTitle = String.valueOf(tempTitle.substring(0, index)) + condiNameArray[k] + condiValueArray[k] + tempTitle.substring(index + tildIndex + condiNameArray[k].length());
                    tempTitle = new String(bufferTitle);
                }
                ++k;
            }
            tempTitle = tempTitle.replace('\u00c2', ' ');
            BaseLogger.log("3", null, null, "tempTitle[[[[" + tempTitle);
            this.genProp.setTitle(tempTitle);
        }
        if (this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") || this.genProp.getOutputType().equalsIgnoreCase("HTML")) {
            if (this.genProp.getTitle() != null && this.genProp.getTitle().length() > 0) {
                this.contentManager.setReportHeader(this.genProp.getTitle());
                this.contentManager.setPageHeader("");
            }
        } else if (this.genProp.getOutputType().equalsIgnoreCase("Excel")) {
            if (this.genProp.getTitle() != null && this.genProp.getTitle().length() > 0) {
                this.contentManager.setReportHeader("");
                this.contentManager.setPageHeader(this.genProp.getTitle());
            } else {
                this.contentManager.setPageHeader(this.genProp.getTitle());
            }
        } else if (this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth")) {
            if (this.genProp.getTitle() != null && this.genProp.getTitle().length() > 0) {
                this.contentManager.setReportHeader("");
                this.contentManager.setPageHeader(this.genProp.getTitle());
            } else {
                this.contentManager.setPageHeader(this.genProp.getTitle());
            }
        }
        propStringBuff.append("<properties><![CDATA[" + this.genProp.toString() + "]]></properties>\n");
        String str = "";
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                if (this.columns[i].isExists() && !this.columns[i].isVisible()) {
                    visible = false;
                    str = String.valueOf(str) + "'" + this.columns[i].getDisplayName() + "',";
                }
                ++i;
            }
        }
        if (this.calObjList != null) {
            i = 0;
            while (i < this.calObjList.size()) {
                Calculation calObj = (Calculation)this.calObjList.get(i);
                if (!calObj.isVisible()) {
                    visible = false;
                    str = String.valueOf(str) + "'" + calObj.getTitle() + "',";
                }
                ++i;
            }
        }
        if (this.totalObjList != null) {
            i = 0;
            while (i < this.totalObjList.size()) {
                Total totObj = (Total)this.totalObjList.get(i);
                if (!totObj.isVisible()) {
                    visible = false;
                    str = String.valueOf(str) + "'" + totObj.getTitle() + "',";
                }
                ++i;
            }
        }
        if (!visible) {
            str = str.substring(0, str.length() - 1);
            propStringBuff.append("<colNames><![CDATA[" + str + "]]></colNames>\n");
        }
        propStringBuff.append("<baname>" + this.baName + "</baname>\n");
        propStringBuff.append("<baid>" + this.baID + "</baid>\n");
        propStringBuff.append("<NO_OF_ROWS>" + this.rowCount + "</NO_OF_ROWS>");
        propStringBuff.append("<displayoptions>" + this.genProp.getDisplayOpt() + "</displayoptions>\n");
        propStringBuff.append("<numericformat>" + this.genProp.getUnits() + "</numericformat>\n");
        propStringBuff.append("<anumericformat>" + this.genProp.getANumericFormat() + "</anumericformat>\n");
        propStringBuff.append("<round>" + this.genProp.getRound() + "</round>\n");
        propStringBuff.append("<dateformat>" + this.genProp.getDateFormat() + "</dateformat>\n");
        propStringBuff.append("<frozencolumns>" + noOfVisibleFixedCols + "</frozencolumns>\n");
        propStringBuff.append("<outputrows>" + this.genProp.getOutputRows() + "</outputrows>\n");
        propStringBuff.append("<outputwidth>" + this.genProp.getOutputWidth() + "</outputwidth>\n");
        propStringBuff.append("<graphLeftPostion>" + this.genProp.getGraphLeftPosition() + "</graphLeftPostion>\n");
        propStringBuff.append("<graphTopPostion>" + this.genProp.getGraphTopPosition() + "</graphTopPostion>\n");
        propStringBuff.append("<datatableLeftPostion>" + this.genProp.getDatatableLeftPosition() + "</datatableLeftPostion>\n");
        propStringBuff.append("<datatableTopPostion>" + this.genProp.getDatatableTopPosition() + "</datatableTopPostion>\n");
        propStringBuff.append("<whereStmt><![CDATA[" + this.whereStmt + "]]></whereStmt>");
        propStringBuff.append("<formatPosition>" + this.genProp.getFormatMode() + "</formatPosition>\n");
        return propStringBuff.toString();
    }

    public void setWhereStmt(String whereStmt) throws Exception {
        try {
            this.whereStmt = whereStmt;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setWhereCondition(HashMap whereCondition) throws Exception {
        try {
            this.whereCondition = whereCondition;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setArgumentList(ArrayList argumentList) throws Exception {
        try {
            this.argumentList = argumentList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setApplicationList(ArrayList applicationList) throws Exception {
        try {
            this.applicationList = applicationList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void writeToFile() throws Exception {
        this.fWriter.write(this.getDrillString());
        this.fWriter.write(this.getDrillAcrossString());
        this.fWriter.write(this.getCrossTabString());
        this.fWriter.write(this.getApplicationsString());
        if (!(this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") && this.genProp.getOutputType().equalsIgnoreCase("HTML") && this.genProp.getOutputType().equalsIgnoreCase("Excel") && this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth"))) {
            this.fWriter.write(this.getBIProperties());
        }
        this.fWriter.write(this.getSortInfoString());
        if (!this.exception.equals(null) && !this.exception.equals("")) {
            this.fWriter.write(this.exception);
        }
        if (!this.exceptionStyle.equals(null) && !this.exceptionStyle.equals("")) {
            this.fWriter.write(this.exceptionStyle);
        }
        if (this.xmlHeadingStr.length() > 0) {
            this.fWriter.write(this.xmlHeadingStr);
        }
        this.fWriter.write("</rows>");
        this.fWriter.flush();
        this.fWriter.close();
        this.fWriter = null;
        if (this.genProp.getOutputType().equalsIgnoreCase("ITM BI")) {
            this.dataWriter.write("</rows>");
            this.dataWriter.flush();
            this.dataWriter.close();
        }
    }

    private String getApplicationsString() throws Exception {
        StringBuffer applnStrBuff = new StringBuffer();
        if (this.applicationList != null) {
            StringBuffer applnIdStrBuf = new StringBuffer("<APPLICATION_IDS>");
            StringBuffer applnNameStrBuf = new StringBuffer("<APPLICATION_NAMES>");
            int cnt = 0;
            while (cnt < this.applicationList.size()) {
                Application appObj = (Application)this.applicationList.get(cnt);
                if (appObj != null) {
                    applnIdStrBuf.append("'" + appObj.getApplnId() + "',");
                    applnNameStrBuf.append("'" + appObj.getApplnName() + "',");
                }
                ++cnt;
            }
            if (this.applicationList.size() > 0) {
                applnIdStrBuf = applnIdStrBuf.deleteCharAt(applnIdStrBuf.length() - 1);
                applnNameStrBuf = applnNameStrBuf.deleteCharAt(applnNameStrBuf.length() - 1);
            }
            applnIdStrBuf.append("</APPLICATION_IDS>");
            applnNameStrBuf.append("</APPLICATION_NAMES>");
            applnStrBuff.append(applnIdStrBuf);
            applnStrBuff.append(applnNameStrBuf);
            BaseLogger.log("3", null, null, "Selected Application List [" + applnStrBuff + "]");
        }
        return applnStrBuff.toString();
    }

    private String getColumnInfo() throws Exception {
        int noOfVisibleGroupCols = 0;
        int noOfVisibleFixedCols = 0;
        int noOfVisibleCrossTabCols = 0;
        int noOfVisibleValueCols = 0;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].getPlacement() == 1 && this.columns[i].isExists() && this.columns[i].isVisible()) {
                ++noOfVisibleGroupCols;
            } else if (this.columns[i].getPlacement() == 2 && this.columns[i].isExists() && this.columns[i].isVisible()) {
                ++noOfVisibleFixedCols;
            } else if (this.columns[i].getPlacement() == 3 && this.columns[i].isExists() && this.columns[i].isVisible()) {
                ++noOfVisibleCrossTabCols;
            }
            if (this.columns[i].getPlacement() == 4 && this.columns[i].isExists() && this.columns[i].isVisible()) {
                ++noOfVisibleValueCols;
            }
            ++i;
        }
        if (this.calObjList != null) {
            int ctr = 0;
            while (ctr < this.calObjList.size()) {
                if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 1 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleGroupCols;
                } else if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 2 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleFixedCols;
                } else if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 3 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleCrossTabCols;
                }
                if (((Calculation)this.calObjList.get(ctr)).getPlacement() == 4 && ((Calculation)this.calObjList.get(ctr)).isVisible() && ((Calculation)this.calObjList.get(ctr)).isValid()) {
                    ++noOfVisibleValueCols;
                }
                ++ctr;
            }
        }
        StringBuffer columnInfoBuff = new StringBuffer();
        if (this.grElementList.size() > 0) {
            StringBuffer displayNames = new StringBuffer();
            StringBuffer logicalNames = new StringBuffer();
            int i2 = 0;
            while (i2 < this.grElementList.size()) {
                Column column = (Column)this.grElementList.get(i2);
                displayNames.append(String.valueOf(column.getDisplayName()) + "~");
                logicalNames.append(String.valueOf(column.getLogicalName()) + "~");
                ++i2;
            }
            logicalNames = logicalNames.deleteCharAt(logicalNames.length() - 1);
            displayNames = displayNames.deleteCharAt(displayNames.length() - 1);
            columnInfoBuff.append("<LOGICALNAMES>" + logicalNames.toString() + "</LOGICALNAMES>\n");
            columnInfoBuff.append("<DISPLAYNAMES>" + displayNames.toString() + "</DISPLAYNAMES>\n");
        }
        columnInfoBuff.append("<NO_OF_GROUP_COLUMNS>" + noOfVisibleGroupCols + "</NO_OF_GROUP_COLUMNS>\n");
        columnInfoBuff.append("<NO_OF_FIXED_COLUMNS>" + noOfVisibleFixedCols + "</NO_OF_FIXED_COLUMNS>\n");
        columnInfoBuff.append("<NO_OF_CROSSTAB_COLUMNS>" + noOfVisibleCrossTabCols + "</NO_OF_CROSSTAB_COLUMNS>\n");
        columnInfoBuff.append("<NO_OF_VALUE_COLUMNS>" + noOfVisibleValueCols + "</NO_OF_VALUE_COLUMNS>\n");
        if (this.genProp.getOutputType().equalsIgnoreCase("Acrobat PDF") || this.genProp.getOutputType().equalsIgnoreCase("HTML") || this.genProp.getOutputType().equalsIgnoreCase("Excel") || this.genProp.getOutputType().equalsIgnoreCase("ExcelFitWidth")) {
            this.contentManager.setNoOfFixedCols(noOfVisibleFixedCols);
            this.contentManager.setNoOfCrossTabCols(noOfVisibleCrossTabCols);
        }
        return columnInfoBuff.toString();
    }

    private Object getAggregateCalculation(Calculation calObj, ArrayList fixedColumnValueList) throws Exception {
        Object resObject = null;
        ArrayList elementTypeList = null;
        ArrayList elementNameList = null;
        String tagName = "";
        String data = "";
        if (((String)elementTypeList.get(elementNameList.indexOf(tagName))).indexOf("NUMBER") == -1) {
            data = data.length() <= 0 ? "" : data;
            int ctr = 0;
            while (ctr < this.noOfCalculations) {
                this.interpreter.set(tagName, (Object)data);
                ++ctr;
            }
        } else {
            data = data.length() <= 0 ? "0" : data;
            int ctr = 0;
            while (ctr < this.noOfCalculations) {
                this.interpreter.set(tagName, (Object)Double.valueOf(data));
                ++ctr;
            }
        }
        return resObject;
    }

    public void setUserHeading(String xmlHeadingStr) throws Exception {
        try {
            this.xmlHeadingStr = xmlHeadingStr;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setSuppressDuplicateRow(boolean suppressDuplicateRow) {
        this.suppressDuplicateRow = suppressDuplicateRow;
    }

    public boolean getSuppressDuplicateRow() {
        return this.suppressDuplicateRow;
    }

    public String initCap(String dataString, String wordSeparator) throws BaseException {
        BaseLogger.log("2", null, null, "dataString [" + dataString + "]");
        try {
            int index = 0;
            do {
                StringBuffer dataStringBuffer = new StringBuffer(dataString);
                dataStringBuffer.replace(index, index + 1, dataString.substring(index, index + 1).toUpperCase());
                dataString = dataStringBuffer.toString();
                index = dataString.indexOf(wordSeparator, index + 1);
            } while (++index != 0);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :initCap :==>\n" + e);
        }
        BaseLogger.log("2", null, null, "GenericUtility : initCap : returning : dataString " + dataString);
        return dataString;
    }
}

