/*
 * Decompiled with CFR 0.152.
 */
package ibase.ai.entityid;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import oracle.sql.CLOB;
import org.json.JSONObject;

public class DocumentProcessTrail {
    String docId = "";
    String processId = "";
    String responseData = "";
    String requestParams = "";
    String errorInfo = "";
    UserInfoBean userInfo = null;

    public void configureProcTrail(String docId, String procMethod, String processId, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("3", userInfo, null, " Inside DocumentProcessTrail configureProcTrail docId [" + docId + "] processId [" + processId + "]");
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        try {
            try {
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                String getSql = "SELECT RESPONSE_DATA, REQUEST_PARAM, ERROR_INFO FROM DOC_PROCESS_TRAIL WHERE DOC_ID=? AND PROCESS_ID=? AND PROC_MTD=?";
                pstmt = conn.prepareStatement(getSql);
                pstmt.setString(1, docId);
                pstmt.setString(2, processId);
                pstmt.setString(3, procMethod);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Clob clob = rs.getClob("RESPONSE_DATA");
                    String responseData = clob.getSubString(1L, (int)clob.length());
                    this.setResponseData(responseData);
                    this.setRequestParams(rs.getString("REQUEST_PARAM"));
                    this.setErrorInfo(rs.getString("ERROR_INFO"));
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocumentProcessTrail.configureProcTrail()", "Exception in configureProcTrail[catch] : " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocumentProcessTrail.configureProcTrail()", "Exception in configureProcTrail[finally] : " + e);
            }
        }
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getResponseData() {
        return this.responseData;
    }

    public void setResponseData(String responseData) {
        this.responseData = responseData;
    }

    public String getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(String requestParams) {
        this.requestParams = requestParams;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public int insertIntoDocProcTrail(String docId, String procMethod, String processId, String responseData, String requestParams, String errorInfo, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("3", userInfo, null, " Inside DocumentProcessTrail insertIntoDocProcTrail [" + docId + "] processId [" + processId + "]");
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        int count = 0;
        int result = 0;
        try {
            try {
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                String cntSql = "SELECT COUNT(*) AS COUNT FROM DOC_PROCESS_TRAIL WHERE DOC_ID=? AND PROCESS_ID=? AND PROC_MTD=?";
                pstmt = conn.prepareStatement(cntSql);
                pstmt.setString(1, docId);
                pstmt.setString(2, processId);
                pstmt.setString(3, procMethod);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt("COUNT");
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                BaseLogger.log("3", userInfo, null, "count:::" + count);
                if (count > 0) {
                    String updateSQL = "UPDATE DOC_PROCESS_TRAIL SET RESPONSE_DATA=?, REQUEST_PARAM=?, ERROR_INFO=? WHERE DOC_ID=? AND PROCESS_ID=? AND PROC_MTD=?";
                    pstmt = conn.prepareStatement(updateSQL);
                    CLOB clob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    BaseLogger.log("3", userInfo, null, "responseData:::" + responseData);
                    clob.putString(1L, responseData);
                    pstmt.setClob(1, (Clob)clob);
                    pstmt.setString(2, requestParams.length() >= 1000 ? requestParams.substring(0, 999) : requestParams);
                    pstmt.setString(3, errorInfo.length() >= 1000 ? errorInfo.substring(0, 999) : errorInfo);
                    pstmt.setString(4, docId);
                    pstmt.setString(5, processId);
                    pstmt.setString(6, procMethod);
                    result = pstmt.executeUpdate();
                    if (result > 0) {
                        conn.commit();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                } else {
                    String insertSQL = "INSERT INTO DOC_PROCESS_TRAIL(DOC_ID, PROCESS_ID, PROC_MTD, RESPONSE_DATA, REQUEST_PARAM, ERROR_INFO) VALUES(?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(insertSQL);
                    pstmt.setString(1, docId);
                    pstmt.setString(2, processId);
                    pstmt.setString(3, procMethod);
                    CLOB clob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    BaseLogger.log("3", userInfo, null, "responseData:::" + responseData);
                    clob.putString(1L, responseData);
                    BaseLogger.log("3", userInfo, null, "clob:::" + clob);
                    pstmt.setClob(4, (Clob)clob);
                    BaseLogger.log("3", userInfo, null, "requestParams:::" + requestParams);
                    pstmt.setString(5, requestParams.length() >= 1000 ? requestParams.substring(0, 999) : requestParams);
                    BaseLogger.log("3", userInfo, null, "errorInfo1:::" + errorInfo);
                    pstmt.setString(6, errorInfo.length() >= 1000 ? errorInfo.substring(0, 999) : errorInfo);
                    result = pstmt.executeUpdate();
                    if (result > 0) {
                        conn.commit();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocumentProcessTrail.insertIntoDocProcTrail()", "Exception in insertIntoDocProcTrail[catch] : " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocumentProcessTrail.insertIntoDocProcTrail()", "Exception in insertIntoDocProcTrail[finally] : " + e);
            }
        }
        return result;
    }

    public JSONObject setProcTrailJSON(String procMethod, String responseData, String requestParam, String errorInfo) {
        JSONObject tempJSON = new JSONObject();
        try {
            tempJSON.put("PROC_MTD", (Object)procMethod);
            tempJSON.put("RESPONSE_DATA", (Object)responseData);
            tempJSON.put("REQUEST_PARAM", (Object)requestParam);
            tempJSON.put("ERROR_INFO", (Object)errorInfo);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, "DocumentProcessTrail.getProcTrailJSON()", "Exception in getProcTrailJSON[catch] : " + e);
        }
        return tempJSON;
    }
}

