
package ibase.webitm.ejb.wsfa.transactions;

import ibase.planner.servlet.E12CalendarExportToExcelServlet;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import org.w3c.dom.Document;


public class SprsSamplePlanConf extends ActionHandlerEJB
{
	public String confirm( String tranId, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{
		System.out.println("SprsSamplePlanConf Called........["+tranId+"]");

		boolean isError = false;
		

		String applDB = "",enterprises="";
		String sql = "";
		String requestID = "";

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		String errString = "";
		String schemaName = "";
		String enterpriseSQL="";
		ITMDBAccessEJB itmdbAccessLocal = null ;
		boolean isThisObject=false;
		try
		{

			itmdbAccessLocal = new ITMDBAccessEJB();

			GenericUtility genericUtility = GenericUtility.getInstance();
			conn = getConnection();
			conn.setAutoCommit(false);
			String userId  = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
			String chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));
			String currDate = "";
			String serieScCode="";
			String serieScName="";
			String pspScCode="";
			ArrayList<String> scCodeList=new ArrayList<String>();
			LinkedHashMap<String, String> scCodeMap=new LinkedHashMap<>();
			ArrayList<String> scCodeNotInsertList=new ArrayList<String>();
			
			//Added by Hariom S for data not inserted validation -- 26-Sep-2022 [Start]
			String pspDataSql="SELECT distinct (SC_CODE) AS SC_CODE FROM SPRS_SAMP_PLAN_DET WHERE TRAN_ID = ? ";
			pstmt =  conn.prepareStatement(pspDataSql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while( rs.next())
			{
				pspScCode=checkNull(rs.getString("SC_CODE"));
				scCodeList.add(pspScCode);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("scCodeList ==== "+scCodeList);

			String AllCustSql="SELECT A.SC_CODE AS SC_CODE,A.LOCALITY AS LOCALITY,A.CUST_NAME AS CUST_NAME,A.SPECIALITY AS SPECIALITY,A.CATEGORY AS CATEGORY, A.pan_no as pan_no FROM " + 
					"(SELECT SS.SC_CODE AS SC_CODE,LOC.DESCR AS LOCALITY, SS.ROUTE_ID,(SC.FIRST_NAME ||' '||SC.MIDDLE_NAME ||' '||SC.LAST_NAME) AS CUST_NAME , "+
					"SPL.DESCR AS SPECIALITY,SS.CATEGORY AS CATEGORY,ROW_NUMBER() OVER(PARTITION BY SS.SC_CODE ORDER BY SS.ROUTE_ID) AS ROWNO,SC.pan_no as pan_no "+
					"FROM STRG_SERIES SS,STRG_CUSTOMER SC ,LOCALITY LOC,SPECIALITY SPL,SPRS_ROUTE SR WHERE SS.SC_CODE = SC.SC_CODE AND " + 
					"LOC.LOCALITY_CODE = SR.LOCALITY_CODE AND SPL.SPL_CODE = SS.SPL_CODE " + 
					"AND SS.SALES_PERS = ? AND SS.STATUS = ? AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SALES_PERS = SR.SPRS_CODE ORDER BY SC_CODE,LOCALITY,SPECIALITY,CUST_NAME) A " +
					"WHERE A.ROWNO=1 ORDER BY A.SC_CODE,A.LOCALITY,A.SPECIALITY,A.CUST_NAME";
			pstmt =  conn.prepareStatement(AllCustSql);
			pstmt.setString(1, userId);
			pstmt.setString(2, "Y");

			rs = pstmt.executeQuery();
			while( rs.next())
			{								
				serieScCode=checkNull(rs.getString("SC_CODE"));
				serieScName=checkNull(rs.getString("CUST_NAME"));
				if(! scCodeList.contains(serieScCode))
				{
					scCodeMap.put(serieScCode, serieScName);
					scCodeNotInsertList.add(pspScCode);
				}						
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}					
			System.out.println("scCodeMap =="+scCodeMap);
			boolean validate=false;
			StringBuffer strBuffHQ = new StringBuffer("<p>Please select quantity for below Customer \n\n</p>");
			strBuffHQ.append("<table class = 'alertContentTable' ><tr class = 'alertContentTr'><td class = 'alertContentTd'>Sc Code</td><td class = 'alertContentTd'>Doctor Name</td></tr>");

			Set entrySet = scCodeMap.entrySet();				  
			Iterator it = entrySet.iterator();
			while (it.hasNext())
			{
				Map.Entry en = (Map.Entry) it.next();
				String scCode1 = (String) en.getKey();
				String pspScName1 = (String) en.getValue();

				strBuffHQ.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+scCode1+"</td><td class = 'alertContentTd'>" + pspScName1 + "</td></tr>");
				validate = true;
			}								
			if(validate)
			{
				//errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DRNOTSELCT\" type=\"E\" column_name=\"\"><message>Doctor not selected</message><description><![CDATA[" + strBuffHQ.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
				System.out.println("errString is "+ errString);
				//return errString;
			}
			//Added by Hariom S for data not inserted validation -- 26-Sep-2022 [Start]
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			String pDate = genericUtility.getValidDateTimeString( currDate , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());
			System.out.println("pDate....."+pDate);

			String updateStrgBrandAct = "UPDATE SPRS_SAMP_PLAN SET CONFIRMED = ?,CHG_DATE=?,CHG_USER=?,CHG_TERM=? WHERE TRAN_ID=? ";
			PreparedStatement updatePstmt = conn.prepareStatement(updateStrgBrandAct);
			updatePstmt.setString(1,"Y");
			updatePstmt.setTimestamp(2,java.sql.Timestamp.valueOf(pDate));
			updatePstmt.setString(3,userId);
			updatePstmt.setString(4,chgTerm);
			updatePstmt.setString(5,tranId);

			int updateStrgBrandActCnt = updatePstmt.executeUpdate();
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if ( updatePstmt != null )
			{
				updatePstmt.close();
				updatePstmt = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			System.out.println("update SprsSamplePlanConf.......++."+updateStrgBrandActCnt);
			if(updateStrgBrandActCnt>0)
			{
				System.out.println("SprsSamplePlanConf is greater than 000........."+updateStrgBrandActCnt);

				InvokeWorkflowForPSP(userId,tranId,conn );
				errString = itmdbAccessLocal.getErrorString("confirmed", "VTCONFIRM", "","",conn);
				System.out.println("errString is "+ errString);
			}

		}
		catch(Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Commiting and Closing Connection..........");
				if ( !(isError) )
				{
					System.out.println( "inside finally if" );
					conn.commit();
					//errString = itmdbAccessLocal.getErrorString("","TEMCONFIRM",loginEmpCode);
					//errString = itmdbAccessLocal.getErrorString("confirmed", "TEMCONFIRM", "","",con);
				}
				else
				{
					System.out.println( "inside finally rollback else" );
					conn.rollback();
				}
				if( pstmt != null )
				{
					System.out.println( "inside finally if pstmt " );

					pstmt.close();
					pstmt = null;
				}
				if( conn != null && !conn.isClosed() )
				{
					System.out.println( "inside finally if con " );
					conn.close();
					conn = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("errString is +++:"+errString);
		return errString;
	}

	
	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}
	
	public void InvokeWorkflowForPSP(String SalesPersonCode,String tranID , Connection connectionObject )throws Exception
	{
		System.out.println("Inside InvokeWorkflowForPSP confirmed parentdomid::::::::::");

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		
		ResultSet rs1 = null;
		PreparedStatement pstmt1 = null;

		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		PreparedStatement planPstmt = null;
		ResultSet planRs = null;
		GenericWorkflowClass genWorkflow= new GenericWorkflowClass();
		String retString="";
		float currHorTot = 0;
		float prevHorTot = 0;
		float tempHorCnt = 0;
		float tempTotCnt = 0;
		String targetNo = "";
		ResultSet rsSeries=null;
		ResultSet brandRs=null;
		PreparedStatement pstmtSeries=null;
		PreparedStatement brandPstmt=null;
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
 
			DARCommonBean dARCommonBean=new DARCommonBean();
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			String hoUser = dARCommonBean.getSfaParmValueCommon(SalesPersonCode,"SAMP_PLAN_ADM_APRVR",connectionObject);

			StringBuffer valueXmlStringBuf = new StringBuffer();
			valueXmlStringBuf.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><description>Header0 members</description>\r\n");
			


			
				String salesPers="";
				String getTranId = "SELECT SSP.TRAN_ID,SSP.TRAN_DATE,SSP.SALES_PERS,SSP.ACCT_PRD,SSP.PRD_QTR,SSP.WORKFLOW_STATUS,SSP.REMARKS,SP.SP_NAME,I.DESCR AS ITEM_SER_DESCR,ST.DESCR AS STATION_DESCR FROM  SPRS_SAMP_PLAN SSP,SALES_PERS SP,ITEMSER I,EMPLOYEE EMP,STATION ST WHERE SSP.TRAN_ID=? AND SSP.SALES_PERS=SP.SALES_PERS AND SP.ITEM_SER=I.ITEM_SER AND EMP.EMP_CODE=SP.SALES_PERS AND EMP.STAN_CODE__HQ=ST.STAN_CODE ";
				pstmt = connectionObject.prepareStatement(getTranId);
				pstmt.setString( 1, tranID);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					salesPers=checkNull(rs.getString("SALES_PERS"));
					String spName=checkNull(rs.getString("SP_NAME"));

					String emailIdOff="";
					String emailSql="SELECT EMAIL_ID_OFF FROM EMPLOYEE WHERE EMP_CODE=? ";
					pstmt1 = connectionObject.prepareStatement(emailSql);
					pstmt1.setString( 1, salesPers);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						emailIdOff=checkNull(rs1.getString("EMAIL_ID_OFF"));
					}

					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					
					
					valueXmlStringBuf.append("<Detail1 dbID ='"+tranID+"' domID='1' objName='sprs_samp_plan' objContext='1' >\r\n" );
					valueXmlStringBuf.append("<attribute pkNames='tran_id' status='N' updateFlag='A' selected='Y' />\r\n");
					valueXmlStringBuf.append("<tran_id><![CDATA[" ).append(tranID).append( "]]></tran_id>\r\n" );
					valueXmlStringBuf.append("<tran_date><![CDATA[" ).append(checkNull(rs.getString("TRAN_DATE"))).append( "]]></tran_date>\r\n" );
					valueXmlStringBuf.append("<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
					valueXmlStringBuf.append("<acct_prd><![CDATA[" ).append(checkNull(rs.getString("ACCT_PRD"))).append( "]]></acct_prd>\r\n" );
					valueXmlStringBuf.append("<prd_qtr><![CDATA[" ).append(checkNull(rs.getString("PRD_QTR"))).append( "]]></prd_qtr>\r\n" );
					valueXmlStringBuf.append("<workflow_status><![CDATA[" ).append(checkNull(rs.getString("WORKFLOW_STATUS"))).append( "]]></workflow_status>\r\n" );
					valueXmlStringBuf.append("<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );
					valueXmlStringBuf.append("<ho_emp_code><![CDATA[" ).append(hoUser).append( "]]></ho_emp_code>\r\n" );
					valueXmlStringBuf.append("<sales_pers_name><![CDATA[" ).append(spName).append( "]]></sales_pers_name>\r\n" );
					valueXmlStringBuf.append("<confirmed><![CDATA[" ).append("Y").append( "]]></confirmed>\r\n" );
					valueXmlStringBuf.append("<item_ser_descr><![CDATA[" ).append(checkNull(rs.getString("ITEM_SER_DESCR"))).append( "]]></item_ser_descr>\r\n" );
					valueXmlStringBuf.append("<station_descr><![CDATA[" ).append(checkNull(rs.getString("STATION_DESCR"))).append( "]]></station_descr>\r\n" );
					valueXmlStringBuf.append("<sp_email_id><![CDATA[" ).append(emailIdOff).append( "]]></sp_email_id>\r\n" );
					valueXmlStringBuf.append("</Detail1>\r\n");

				}

				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				
				String priceList=dARCommonBean.getSfaParmValueCommon(SalesPersonCode,"SAMPLE_PRICELIST",connectionObject);
/*				String preicelistSql = "SELECT ST.PRICE_LIST AS PRICE_LIST FROM STATE ST LEFT OUTER JOIN SALES_PERS SP ON SP.STATE_CODE = ST.STATE_CODE WHERE SP.SALES_PERS=? ";
				pstmt = connectionObject.prepareStatement(preicelistSql);
				pstmt.setString( 1, salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					priceList=checkNull(rs.getString("PRICE_LIST"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}*/

				String empSiteCode="",siteFinEntity="";
				String sqlSite = " SELECT EMP.EMP_SITE AS EMP_SITE, S.FIN_ENTITY AS FIN_ENTITY FROM EMPLOYEE EMP, SITE S  WHERE EMP.EMP_SITE=S.SITE_CODE AND EMP.EMP_CODE = ? ";
	            PreparedStatement sitePstmt = connectionObject.prepareStatement(sqlSite);
	            sitePstmt.setString(1, salesPers);
	            ResultSet siteRs = sitePstmt.executeQuery();
	            if (siteRs.next()) {
	                empSiteCode = this.checkNull(siteRs.getString("EMP_SITE"));
	                siteFinEntity = this.checkNull(siteRs.getString("FIN_ENTITY"));
	            }
	            if (siteRs != null) {
	                siteRs.close();
	                siteRs = null;
	            }
	            if (sitePstmt != null) {
	                sitePstmt.close();
	                sitePstmt = null;
	            }
				
				if(tranID != null && !tranID.isEmpty())
				{
					String itemUSage="";
					String itemSer = getItemSer(salesPers, connectionObject);

					String parmItemUsage = dARCommonBean.getSfaParmValueCommon(salesPers,"SAMP_PLAN_ITEMUSAGE",connectionObject);
					if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
					{
						itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
					}
					else
					{
						itemUSage="'G','S'";
					}
					String baseLocVal = getBaseLocVal(itemSer, connectionObject);
					int lineNo=1;
					HashMap<String, Double>rateMap=getItemWiserate(priceList,currDate,salesPers,itemUSage,itemSer,connectionObject);
					System.out.println("rateMap is :::::["+rateMap+"]");
					String currentForm="2";
					String sqlEdit = " SELECT B.SC_CODE AS SC_CODE,B.LOCALITY AS LOCALITY,B.CUST_NAME AS CUST_NAME,B.SPECIALITY AS SPECIALITY,B.CATEGORY AS CATEGORY, B.pan_no as pan_no FROM" +
							  " (select distinct SS.SC_CODE as SC_CODE, LOC.DESCR AS LOCALITY,SS.ROUTE_ID,(SC.FIRST_NAME ||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME) AS CUST_NAME," +
							  " SPL.DESCR as SPECIALITY,SS.category AS category, SC.pan_no as pan_no,ROW_NUMBER() OVER(PARTITION BY SS.SC_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM STRG_CUSTOMER SC," +
							  " LOCALITY LOC, SPECIALITY SPL,STRG_SERIES SS LEFT OUTER JOIN SPRS_SAMP_PLAN_DET SBAT ON SS.SC_CODE = SBAT.SC_CODE,SPRS_ROUTE SR "+
							  " WHERE SS.SC_CODE = SC.SC_CODE  AND LOC.LOCALITY_CODE = SR.LOCALITY_CODE AND SPL.SPL_CODE = SS.SPL_CODE AND SS.SALES_PERS = ? and SS.STATUS= ?"+
							  " AND SBAT.TRAN_ID = ? AND SS.ROUTE_ID = SR.ROUTE_ID and SS.SALES_PERS = SR.SPRS_CODE  ORDER BY SC_CODE,LOCALITY, SPECIALITY,CUST_NAME)B "+
							  " where B.ROWNO=1 " +
							 // " ORDER BY SC_CODE,LOCALITY,SPECIALITY,CUST_NAME";
							  " ORDER BY CUST_NAME";
					
							 
					 String itemSql = "SELECT TRAN_ID,LINE_NO,SC_CODE,ITEM_CODE,ITEM_DESCR,SH_DESCR,PAN_NO ,CNT , QUANTITY, FIN_ENTITY " + 
					 		" FROM " + 
					 		" (SELECT DISTINCT SSPT.ITEM_CODE AS ITEM_CODE,I.DESCR AS ITEM_DESCR, I.SH_DESCR AS SH_DESCR, " + 
					 		" SSPT.TRAN_ID AS TRAN_ID, " + 
					 		" SSPT. LINE_NO AS LINE_NO,SSPT.SC_CODE  AS SC_CODE,SSPT.PAN_NO  AS PAN_NO , SSPT.QUANTITY as QUANTITY , SSPT.FIN_ENTITY AS FIN_ENTITY , 0 AS CNT " + 
					 		" FROM SPRS_SAMP_PLAN_DET SSPT INNER JOIN ITEM I ON TRIM(I.ITEM_CODE) = TRIM(SSPT.ITEM_CODE) " + 
					 		" INNER JOIN SALES_PERS SP ON TRIM(SP.ITEM_SER) = TRIM(I.ITEM_SER) " + 
					 		" WHERE SSPT.SC_CODE = ? AND SSPT.TRAN_ID   = ? AND SP.SALES_PERS  = ?  AND I.ACTIVE='Y'" + 
					 		" UNION  " + 
					 		" SELECT I.ITEM_CODE AS ITEM_CODE,I.DESCR AS ITEM_DESCR,I.SH_DESCR AS SH_DESCR,? AS TRAN_ID,NULL AS LINE_NO,? AS SC_CODE, ? AS PAN_NO,0 as QUANTITY, I.PHY_ATTRIB_9 AS FIN_ENTITY ,0 AS CNT FROM ITEM I " + 
					 		" WHERE I.ITEM_SER = ? AND I.ACTIVE='Y' AND I.ITEM_USAGE IN ("+itemUSage+")" + 
					 		" AND I.ITEM_CODE NOT IN (SELECT ITEM_CODE FROM SPRS_SAMP_PLAN_DET WHERE TRAN_ID= ?  AND SC_CODE = ? " + 
					 		" AND TRIM(ITEM_CODE) = TRIM(I.ITEM_CODE))) A  " +
					 		" ORDER BY SH_DESCR"; 
					 
					 
					brandPstmt = connectionObject.prepareStatement(itemSql);

					pstmtSeries =  connectionObject.prepareStatement( sqlEdit );

					pstmtSeries.setString(1, salesPers);
					pstmtSeries.setString(2, "Y");
					pstmtSeries.setString(3, tranID);

					rsSeries = pstmtSeries.executeQuery();
					while(rsSeries.next())
					{
						String panNo=checkNull(rsSeries.getString("pan_no"));
						String scCode=checkNull(rsSeries.getString("SC_CODE"));
						String dbId=tranID+":"+scCode;
						valueXmlStringBuf.append("<Detail2 dbID ='"+tranID+"' domID='"+dbId+"' parentFormdomID='"+lineNo+"' objName='sprs_samp_plan' objContext='2'>\r\n" );
						valueXmlStringBuf.append( "<line_no><![CDATA[" ).append(lineNo).append( "]]></line_no>\r\n" );
						valueXmlStringBuf.append( "<sc_code><![CDATA[" ).append(checkNull(rsSeries.getString("SC_CODE"))).append( "]]></sc_code>\r\n" );
						valueXmlStringBuf.append( "<pan_no><![CDATA[" ).append(checkNull(rsSeries.getString("pan_no"))).append( "]]></pan_no>\r\n" );

						valueXmlStringBuf.append( "<doctor_name><![CDATA[" ).append(checkNull(rsSeries.getString("CUST_NAME"))).append( "]]></doctor_name>\r\n" );
						valueXmlStringBuf.append( "<locality><![CDATA[" ).append(checkNull(rsSeries.getString("LOCALITY"))).append( "]]></locality>\r\n" );
						valueXmlStringBuf.append( "<speciality><![CDATA[" ).append(checkNull(rsSeries.getString("SPECIALITY"))).append( "]]></speciality>\r\n" );
						valueXmlStringBuf.append( "<category><![CDATA[" ).append(checkNull(rsSeries.getString("CATEGORY"))).append( "]]></category>\r\n" );

						brandPstmt.setString(1,rsSeries.getString("SC_CODE"));
						brandPstmt.setString(2,tranID);
						brandPstmt.setString(3,salesPers);
						brandPstmt.setString(4,tranID);
						brandPstmt.setString(5,rsSeries.getString("SC_CODE"));
						brandPstmt.setString(6,panNo);
						brandPstmt.setString(7,itemSer);
						brandPstmt.setString(8,tranID);
						brandPstmt.setString(9,rsSeries.getString("SC_CODE"));
						//brandPstmt.setString(8,salesPers);
						brandRs = brandPstmt.executeQuery();
						targetNo = "";
						tempHorCnt = 0;
						prevHorTot = 0;
						currHorTot = 0;
						String prevTargetNo="";
						float prevTempHorCnt=0;
						int brandLineNo=1;	

						
						valueXmlStringBuf.append( "<base_value_tot_ver><![CDATA[" ).append("").append( "]]></base_value_tot_ver>\r\n" );
						valueXmlStringBuf.append( "<curr_vert_total><![CDATA[" ).append("0").append( "]]></curr_vert_total>\r\n" );

						if(prevHorTot == 0)
						{
							valueXmlStringBuf.append( "<base_value_horz_tot><![CDATA[" ).append("0").append( "]]></base_value_horz_tot>\r\n" );
						}
						else
						{
							DecimalFormat format = new DecimalFormat("0.####");
							System.out.println("currvalHorTot====="+format.format(prevHorTot));
							valueXmlStringBuf.append( "<base_value_horz_tot><![CDATA[" ).append(format.format(prevHorTot)).append( "]]></base_value_horz_tot>\r\n" );//Changes by hariom for after decimal zero not show -15-july-2020
						}
						if(currHorTot == 0)
						{
							valueXmlStringBuf.append( "<curr_horz_total><![CDATA[" ).append("0").append( "]]></curr_horz_total>\r\n" );
						}
						else
						{
							DecimalFormat format = new DecimalFormat("0.####");	 
							valueXmlStringBuf.append( "<curr_horz_total><![CDATA[" ).append(format.format(currHorTot)).append( "]]></curr_horz_total>\r\n" );//Changes by hariom for after decimal zero not show -15-july-2020
						}
						valueXmlStringBuf.append( "<brand_base_loc_val><![CDATA[" ).append(baseLocVal).append( "]]></brand_base_loc_val>\r\n" );
						valueXmlStringBuf.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );

						brandPstmt.clearParameters();

						

						valueXmlStringBuf.append( "</Detail2>\r\n" );
						
						while(brandRs.next())
						{
							String itemCode=checkNull(brandRs.getString("ITEM_CODE"));
							String custCode=checkNull(brandRs.getString("SC_CODE"));
							double rate=0.0;
							String brandDbId=tranID+scCode+brandLineNo;
							if(!rateMap.isEmpty() && rateMap.containsKey(itemCode)) 
							{
								rate=rateMap.get(itemCode);

							}
							if(rate == -1)
							{
								rate=0;
							}
								
							valueXmlStringBuf.append( "<Detail3 dbID ='"+brandDbId+"' parentDomID='"+ dbId +"' domID='"+ brandDbId +"' childFormdomID='"+lineNo+"' selected = 'Y' objContext='3'>\r\n" );
							valueXmlStringBuf.append( "<line_no><![CDATA[" ).append(brandLineNo).append( "]]></line_no>\r\n" );
							valueXmlStringBuf.append( "<sc_code><![CDATA[" ).append(custCode).append( "]]></sc_code>\r\n" );
							valueXmlStringBuf.append( "<quantity><![CDATA[" ).append(brandRs.getString("QUANTITY")).append( "]]></quantity>\r\n" );
							valueXmlStringBuf.append( "<item_code><![CDATA[" ).append(itemCode).append( "]]></item_code>\r\n" );
							valueXmlStringBuf.append( "<rate><![CDATA[" ).append(rate).append( "]]></rate>\r\n" );

							valueXmlStringBuf.append( "<item_descr><![CDATA[" ).append(brandRs.getString("ITEM_DESCR")).append( "]]></item_descr>\r\n" );
							valueXmlStringBuf.append( "<sh_descr><![CDATA[" ).append(brandRs.getString("SH_DESCR")).append( "]]></sh_descr>\r\n" );
							valueXmlStringBuf.append( "<site_code><![CDATA[" ).append(empSiteCode).append( "]]></site_code>\r\n" );
							valueXmlStringBuf.append( "<fin_entity><![CDATA[" ).append(brandRs.getString("FIN_ENTITY")).append( "]]></fin_entity>\r\n" );
							valueXmlStringBuf.append( "<aprv_qty><![CDATA[" ).append(brandRs.getString("QUANTITY")).append( "]]></aprv_qty>\r\n" );
							valueXmlStringBuf.append( "<totals><![CDATA[" ).append("").append( "]]></totals>\r\n" );
							valueXmlStringBuf.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );

							targetNo = checkNull(brandRs.getString("QUANTITY"));
							if(targetNo.trim().length()>0)
							{
								tempHorCnt =Float.parseFloat(targetNo);
								//System.out.println("tDFGempHorCnDFGt:::["+tempHorCnt+"]prevHorTot::DFG:["+currHorTot+"]");
								currHorTot = currHorTot + tempHorCnt;
							}

							/*for(Map.Entry<String, HashMap<String, String>> m:baseValuesHM.entrySet())
							{
								//System.out.println("inside on getting base values and brand");
								String keyScode =(String)m.getKey();
								HashMap<String, String> valueMap = m.getValue();
								String scCodExits = checkNull(brandRs.getString("SC_CODE"));
								if(keyScode.equalsIgnoreCase(scCodExits))
								{
									String brandBaseVal="";
									String brndCd=checkNull(brandRs.getString("BRAND_CODE"));
									//System.out.println("stausMap:gf:"+brndCd);
									if(brndCd.trim().length()> 0 )
									{
										brandBaseVal = valueMap.get(brndCd);
									}
									//System.out.println("brandBaseVal:dfg:"+brandBaseVal);
									if( brandBaseVal == "null" || brandBaseVal == null || brandBaseVal == "" )
									{
										valueXmlStringBuf.append( "<base_values><![CDATA[" ).append("0").append( "]]></base_values>\r\n" );
									}
									else
									{
										valueXmlStringBuf.append( "<base_values><![CDATA[" ).append(brandBaseVal).append( "]]></base_values>\r\n" );
									}
									//baseValuesHM.remove(scCodExits);
									if(brandBaseVal != null && brandBaseVal !="" )
									{
										prevTempHorCnt =Float.parseFloat(brandBaseVal);
										//System.out.println("prevTempHorCnt:::["+prevTempHorCnt+"]prevHorTot:::["+prevHorTot+"]");
										prevHorTot = prevHorTot + prevTempHorCnt;
									}
									break;
								}

							}*/

							valueXmlStringBuf.append( "</Detail3>\r\n" );
							brandLineNo++;
						}
						
						lineNo++;
					}
					if (rsSeries!= null)
					{
						rsSeries.close();
						rsSeries = null;
					}
					if(pstmtSeries!=null)
					{
						pstmtSeries.close();
						pstmtSeries = null;
					}
				
					
					
				}
				
				
				valueXmlStringBuf.append("</Header0>\r\n");
				valueXmlStringBuf.append("</group0>\r\n");
				valueXmlStringBuf.append("</DocumentRoot>\r\n");
				System.out.println( "\n****valueXmlStringBuf INVOKE:::::::::::" + valueXmlStringBuf.toString() + ":********" );

				String xmlString = valueXmlStringBuf.toString();
				retString = genWorkflow.invokeWorkflow(connectionObject, tranID, "", "sprs_samp_plan", xmlString, SalesPersonCode);
			
		}	
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 
		}
		finally {

			try
			{
				if (rsSeries!= null)
				{
					rsSeries.close();
					rsSeries = null;
				}
				if(pstmtSeries!=null)
				{
					pstmtSeries.close();
					pstmtSeries = null;
				}
				if (brandRs!= null)
				{
					brandRs.close();
					brandRs = null;
				}
				if(brandPstmt!=null)
				{
					brandPstmt.close();
					brandPstmt = null;
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}*/
			}
			catch(Exception e)
			{

			}

		}
	
	}
	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}
	public String getItemSer(String salesPers,Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String itemSer="";
		try
		{
			String sql="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return itemSer;
	}
	
	public String getBaseLocVal(String itemSer,Connection conn) throws ITMException
	{
		System.out.println("In side getDivisionHO............");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String selected = "";
		int ctr4 = 0;
		int noOfChilds4 = 0;
		int currentFormNo = 0;
		String brandLocVal="";

		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();	

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			System.out.println("itemSer:::["+itemSer+"]");
			String sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT = ?  "+
					" AND ACTIVE = 'Y'  "+
					" AND PARM_NAME='BRAND_BASE_VAL_LOCK' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "X"+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				brandLocVal  = checkNull(rs.getString(1));
			}
			System.out.println("brandLocVal:::["+brandLocVal+"]");
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
		}
		if(brandLocVal.trim().length() == 0 || brandLocVal.equalsIgnoreCase(""))
		{
			brandLocVal="N";
		}
		System.out.println("brandLocVal..:::=["+brandLocVal+"]");
		return brandLocVal;
	}
	
	public HashMap<String, Double> getItemWiserate(String priceList,String currDate,String SalesPers,String itemUSage,String itemSer,Connection conn) throws ITMException
	{
		System.out.println("In side getDivisionHO............");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String selected = "";
		int ctr4 = 0;
		int noOfChilds4 = 0;
		int currentFormNo = 0;
		HashMap<String, Double> hm=new HashMap<String, Double>();
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();	
			DARCommonBean dARCommonBean=new DARCommonBean();

			
			 String itemSql = " SELECT I.ITEM_CODE AS ITEM_CODE FROM ITEM I " + 
				 		" WHERE I.ITEM_SER = ? AND I.ACTIVE='Y' AND I.ITEM_USAGE IN ("+itemUSage+")";
				pstmt = conn.prepareStatement(itemSql);
				pstmt.setString( 1, itemSer);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String itemCode=checkNull(rs.getString("ITEM_CODE"));
					double rate = dARCommonBean.getLandingRate( "", itemCode, currDate, SalesPers, priceList, conn);
					hm.put(itemCode, rate);
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			

			

		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			

		}

		return hm;
	}

}
