/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import ibase.system.config.ConnParams;
import ibase.system.config.jca.ConnDriverJCA;
import ibase.system.config.resource.ConnDriverResource;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import oracle.jdbc.OracleConnection;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnDriver {
    protected boolean database;
    protected boolean isPool;
    protected boolean dataSourceName;
    protected boolean drvName;
    protected boolean drvURL;
    protected boolean logId;
    protected boolean logPassWord;
    protected boolean autocommit;
    protected String data_source_name = "";
    protected String driver_name = "";
    protected String driver_url = "";
    protected String database_username = "";
    protected String database_password = "";
    protected String database_autocommit = "";
    protected String dataSourceFileName = null;
    protected boolean data_pstmtSupported;
    protected static boolean IS_JDK_6 = false;
    Connection connection = null;
    OracleConnection oracleConnection = null;
    private String DBName = "";

    public String getDBName() {
        return this.DBName;
    }

    public void setDBName(String DBName) {
        this.DBName = DBName;
    }

    public static void getJavaVersion() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        BaseLogger.log("2", null, null, "Java Specification Version[" + javaSpecVersion + "]");
        double javaVersion = Double.valueOf(javaSpecVersion);
        BaseLogger.log("2", null, null, "javaVersion[" + javaVersion + "]");
        if (javaVersion < 1.8) {
            IS_JDK_6 = true;
        }
    }

    public Connection getConnectDB() throws Exception {
        if (IS_JDK_6) {
            ConnDriverResource connDriverGA = new ConnDriverResource();
            this.connection = connDriverGA.getConnectDB();
        } else {
            ConnDriverJCA connDriverWF = new ConnDriverJCA();
            this.connection = connDriverWF.getConnectDB();
        }
        this.setDBName(this.connection);
        return this.connection;
    }

    public Connection getConnectDB(String dataPropFileName) throws Exception {
        UserInfoBean userInfoBean = new UserInfoBean();
        userInfoBean.setTransDB(dataPropFileName);
        if (IS_JDK_6) {
            ConnDriverResource connDriverGA = new ConnDriverResource();
            this.connection = connDriverGA.getConnectDB(userInfoBean);
        } else {
            ConnDriverJCA connDriverWF = new ConnDriverJCA();
            this.connection = connDriverWF.getConnectDB(userInfoBean);
        }
        this.setDBName(this.connection);
        return this.connection;
    }

    public Connection getConnectDB(String dataPropFileName, int logLevel) throws Exception {
        if (IS_JDK_6) {
            ConnDriverResource connDriverGA = new ConnDriverResource();
            this.connection = connDriverGA.getConnectDB(dataPropFileName, logLevel);
        } else {
            ConnDriverJCA connDriverWF = new ConnDriverJCA();
            this.connection = connDriverWF.getConnectDB(dataPropFileName, logLevel);
        }
        this.setDBName(this.connection);
        return this.connection;
    }

    public Connection getConnectDB(String dataPropFileName, boolean isInMemory) throws Exception {
        if (IS_JDK_6) {
            ConnDriverResource connDriverGA = new ConnDriverResource();
            this.connection = connDriverGA.getConnectDB(dataPropFileName, isInMemory);
        } else {
            ConnDriverJCA connDriverWF = new ConnDriverJCA();
            this.connection = connDriverWF.getConnectDB(dataPropFileName, isInMemory);
        }
        this.setDBName(this.connection);
        return this.connection;
    }

    public Connection getConnectDB(String dbPropFileName, String xlsFileName) throws Exception {
        if (IS_JDK_6) {
            ConnDriverResource connDriverGA = new ConnDriverResource();
            this.connection = connDriverGA.getConnectDB(dbPropFileName, xlsFileName);
        } else {
            ConnDriverJCA connDriverWF = new ConnDriverJCA();
            this.connection = connDriverWF.getConnectDB(dbPropFileName, xlsFileName);
        }
        this.setDBName(this.connection);
        return this.connection;
    }

    public OracleConnection getOracleConnection(String dataPropFileName) throws Exception {
        if (IS_JDK_6) {
            ConnDriverResource connDriverGA = new ConnDriverResource();
            this.oracleConnection = connDriverGA.getOracleConnection(dataPropFileName);
        } else {
            ConnDriverJCA connDriverWF = new ConnDriverJCA();
            this.oracleConnection = connDriverWF.getOracleConnection(dataPropFileName);
        }
        return this.oracleConnection;
    }

    protected static String readPasswordFromFile(String ipwFile) {
        String pass = "";
        try {
            String fileName = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + ipwFile + ".ipw";
            BaseLogger.log("3", null, null, "readPasswordFromFile : fileName [" + fileName + "]");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream isr = new FileInputStream(fileName);
            StringBuffer passStrBuff = new StringBuffer();
            int i = -1;
            while ((i = isr.read()) != -1) {
                baos.write(i);
            }
            pass = baos.toString(CommonConstants.ENCODING);
            baos.close();
            isr.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: ConnDriver: readPasswordFromFile(String):==>\n" + e.getMessage());
        }
        return pass;
    }

    protected static String decrypt(String as_passwd) {
        String ls_return = "";
        try {
            int li_len = as_passwd.length();
            int li_seedcount = 1;
            int li_count = 0;
            while (li_count < li_len) {
                int li_Seed = as_passwd.charAt(li_count + 1) - li_seedcount;
                int li_passAsc = as_passwd.charAt(li_count) - li_seedcount;
                ls_return = String.valueOf(ls_return) + (char)(li_passAsc -= li_Seed);
                ++li_seedcount;
                li_count += 2;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: ConnDriver: decrypt(String):==>\n" + e.getMessage());
        }
        return ls_return;
    }

    public static void setConnParams() {
        String dirPath = "";
        if (CommonConstants.APPLICATION_CONTEXT != null) {
            dirPath = CommonConstants.APPLICATION_CONTEXT;
            if (!dirPath.endsWith(File.separator)) {
                dirPath = String.valueOf(dirPath) + File.separator;
            }
            dirPath = String.valueOf(dirPath) + "setting";
        } else {
            dirPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "setting";
        }
        String[] extensions = new String[]{"xml"};
        try {
            File settingDir = new File(dirPath);
            BaseLogger.log("3", null, null, "Setting Connection Params .............settingDir[" + settingDir + "]");
            if (settingDir != null) {
                Iterator iterator = FileUtils.iterateFiles((File)settingDir, (String[])extensions, (boolean)false);
                while (iterator.hasNext()) {
                    File xmlFile;
                    String fileName;
                    Object fileObj = iterator.next();
                    if (!(fileObj instanceof File) || (fileName = (xmlFile = (File)fileObj).getName()) == null || !fileName.startsWith("Driver")) continue;
                    fileName = fileName.substring(0, fileName.indexOf("."));
                    BaseLogger.log("3", null, null, "File name : " + fileName);
                    if (E12GenericUtility.checkNull(fileName).length() <= 0) continue;
                    String connXmlString = FileUtils.readFileToString((File)xmlFile);
                    ConnParams connParams = ConnDriver.createConnParams(connXmlString);
                    BaseLogger.log("3", null, null, " setConnParams fileName  :" + fileName + " \n connParams " + connParams);
                    CommonConstants.connParamsMap.put(fileName, connParams);
                }
            }
            BaseLogger.log("3", null, null, " connParamsMap :\n" + CommonConstants.connParamsMap.size());
        }
        catch (Throwable e) {
            BaseLogger.log("0", null, null, "Exception in CommonConstants.setConnParams [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    protected static ConnParams createConnParams(String connXmlString) {
        ConnParams connParams = new ConnParams();
        try {
            Document dbDoc = new E12GenericUtility().parseString(connXmlString);
            NodeList dbNodes = dbDoc.getElementsByTagName("DATABASE");
            Node dbNode = dbNodes.item(0);
            if (dbNode != null) {
                Node isPoolNode;
                if (dbNode.hasChildNodes()) {
                    NodeList dbChildNodes = dbNode.getChildNodes();
                    int len = dbChildNodes.getLength();
                    int cntr = 0;
                    while (cntr < len) {
                        Node childNode = dbChildNodes.item(cntr);
                        if (childNode != null) {
                            String nodeName = childNode.getNodeName();
                            String nodeValue = "";
                            nodeValue = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : childNode.getNodeValue();
                            if ("DATASOURCENAME".equalsIgnoreCase(nodeName)) {
                                connParams.setDataSourceName(nodeValue);
                            } else if ("DRIVERNAME".equalsIgnoreCase(nodeName)) {
                                connParams.setDriverName(nodeValue);
                            } else if ("DRIVERURL".equalsIgnoreCase(nodeName)) {
                                connParams.setDriverUrl(nodeValue);
                            } else if ("LOGID".equalsIgnoreCase(nodeName)) {
                                connParams.setDatabaseUsername(nodeValue);
                            } else if ("LOGPASSWORD".equalsIgnoreCase(nodeName)) {
                                connParams.setDatabasePassword(nodeValue);
                            } else if ("AUTOCOMMIT".equalsIgnoreCase(nodeName)) {
                                connParams.setAutoCommit(Boolean.valueOf(nodeValue));
                            } else if ("PREPAREDSTMT_SUPP".equalsIgnoreCase(nodeName)) {
                                connParams.setPreparedStmtSupported(Boolean.valueOf(nodeValue));
                            }
                        }
                        ++cntr;
                    }
                }
                if (dbNode.hasAttributes() && (isPoolNode = dbNode.getAttributes().getNamedItem("isPool")) != null) {
                    String attribValue = isPoolNode.getNodeValue();
                    connParams.setPool(Boolean.valueOf(attribValue));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in CommonConstants.createConnParams :\n" + e.getMessage());
        }
        return connParams;
    }

    public void setDatabaseVariable(String xmlFile) throws Exception {
        try {
            this.dataSourceFileName = xmlFile;
            ConnParams connParams = CommonConstants.connParamsMap.get(xmlFile);
            if (connParams != null) {
                this.data_source_name = connParams.getDataSourceName();
                this.driver_name = connParams.getDriverName();
                this.driver_url = connParams.getDriverUrl();
                this.database_username = connParams.getDatabaseUsername();
                this.database_password = connParams.getDatabasePassword();
                this.database_autocommit = String.valueOf(connParams.isAutoCommit());
                this.isPool = connParams.isPool();
                this.data_pstmtSupported = connParams.isPreparedStmtSupported();
            } else {
                this.setConnParams(xmlFile);
                connParams = CommonConstants.connParamsMap.get(xmlFile);
                if (connParams != null) {
                    this.data_source_name = connParams.getDataSourceName();
                    this.driver_name = connParams.getDriverName();
                    this.driver_url = connParams.getDriverUrl();
                    this.database_username = connParams.getDatabaseUsername();
                    this.database_password = connParams.getDatabasePassword();
                    this.database_autocommit = String.valueOf(connParams.isAutoCommit());
                    this.isPool = connParams.isPool();
                    this.data_pstmtSupported = connParams.isPreparedStmtSupported();
                } else {
                    BaseLogger.log("3", null, null, "No Connection Params found as well as no Connection file found.............for [" + xmlFile + "]");
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: ConnDriver: setDatabaseVariable(String): ==>Generic Exception\n" + e);
            e.printStackTrace();
            throw e;
        }
    }

    private void setConnParams(String xmlFileName) {
        BaseLogger.log("2", null, null, "Setting Connection Params with xmlfile .............");
        String dirPath = "";
        dirPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" : String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "setting";
        BaseLogger.log("2", null, null, "Setting Connection Params with xmlfile .............[" + dirPath + "]");
        try {
            File xmlFile = new File(String.valueOf(dirPath) + File.separator + xmlFileName + ".xml");
            if (xmlFile != null) {
                BaseLogger.log("3", null, null, "File name : " + xmlFileName);
                String connXmlString = FileUtils.readFileToString((File)xmlFile);
                ConnParams connParams = ConnDriver.createConnParams(connXmlString);
                CommonConstants.connParamsMap.put(xmlFileName, connParams);
            }
            BaseLogger.log("3", null, null, " connParamsMap :\n" + CommonConstants.connParamsMap.size());
        }
        catch (Throwable e) {
            BaseLogger.log("0", null, null, "Exception in CommonConstants.setConnParams with xmlfile [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public Connection getConnectDB(UserInfoBean userInfoBean) throws Exception {
        if (IS_JDK_6) {
            ConnDriverResource connDriverGA = new ConnDriverResource();
            this.connection = connDriverGA.getConnectDB(userInfoBean);
        } else {
            ConnDriverJCA connDriverWF = new ConnDriverJCA();
            this.connection = connDriverWF.getConnectDB(userInfoBean);
        }
        this.setDBName(this.connection);
        return this.connection;
    }

    public void setDBName(Connection connection) throws ITMException {
        try {
            String connectionURL = E12GenericUtility.checkNull(connection.getMetaData().getURL()).toLowerCase();
            if (connectionURL.indexOf("oracle") != -1) {
                this.setDBName("ORACLE");
            } else if (connectionURL.indexOf("mysql") != -1) {
                this.setDBName("MYSQL");
            } else if (connectionURL.indexOf("mssql") != -1) {
                this.setDBName("MSSQL");
            } else if (connectionURL.indexOf("db2") != -1) {
                this.setDBName("DB2");
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "ConnDriver.setDBName()  SQLException : [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
    }

    public String getDBName(Connection connection) throws ITMException {
        String dbName = "";
        try {
            String connectionURL = E12GenericUtility.checkNull(connection.getMetaData().getURL()).toLowerCase();
            if (connectionURL.indexOf("oracle") != -1) {
                dbName = "ORACLE";
            } else if (connectionURL.indexOf("mysql") != -1) {
                dbName = "MYSQL";
            } else if (connectionURL.indexOf("mssql") != -1) {
                dbName = "MSSQL";
            } else if (connectionURL.indexOf("db2") != -1) {
                dbName = "DB2";
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "ConnDriver.getDBName()  SQLException : [" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
        return dbName;
    }
}

