
package ibase.webitm.utility.wsfa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import javax.servlet.SingleThreadModel;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;

/**
  * Class DBOperations - <br>
  * This class consists of all the database-related operations
  * like - insert, update, delete, select.
  *
  * @author Avinash Deshmukh, Bijal Shah
  * @version 1.0
  * @since Dec 13, 2001
  */
public final class DBOperations extends Schema implements SingleThreadModel
{
	private ResultSetMetaData rsmd;

	private String updatedBy = new String();
	private String myExMessage = new String();
	//Changed by Monif on 18/11/09. Only oracle is used for SUN.
	//private String dbName = new String();
	private String dbName = "oracle";
	//Changed by nazia on 28-Apr-2009[Commented WS89SUN094]
	//private Statement stmt = null; // by parag shah
	/**
	  *	Store the count of the number of columns to be retrieved
	  */
	private int columnCount = 0;
	
	//Changed by nazia on 05-Jun-2009[ Commented the variable as DBConnection object is newly create in each function to avoid more copnnection created. WS89SUN094]
	//private DBConnection dbCon;
	
	//Changed by nazia on 28-Apr-2009[Commented WS89SUN094]
	public Connection con;

	/**
	  *	@method Constructor, sets the connection object.
	  *	@param DBConnection
	  * @exception Exception
	  */
	 
	  
	/* Changed by nazia on 04-Jun-2009[Created new constructor where DBConnection object is not passed. WS89SUN094]
	public DBOperations(DBConnection dbCon) throws Exception
	{
		//Changed by nazia on 28-Apr-2009[WS89SUN094]
		this.dbCon = dbCon;
		//this.con = dbCon.getConnection();
		dbName = dbCon.getDatabaseName();
	}*/
	public DBOperations( UserInfoBean userInfo ) throws Exception
	{
		if ( con == null )
		{
			//DBConnection dbCon = new DBConnection();
			//con = dbCon.getConnection();
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB( userInfo.getTransDB() );
		}
	}


/*	//Changed by nazia on 28-Apr-2009[WS89SUN094]
	public void finalize ()throws Exception
	{
		try
		{
			if (con!=null)
			{
				con.close();con = null;
			}
		}
		catch()
	}*/

	public DBOperations( Connection connect )
	{
		try
		{
			con = connect;
		}
		catch( Exception ex )
		{
			ex.printStackTrace();
		}
	}

	/**
	  *	@method Insert into table by creating the query at runtime.
	  *	@param String, HashMap table into which data in HashMap to be inserted
	  * @return int Integer indicating whether insertion was successful
	  * @exception Exception
	  */
	public int insert(String table, HashMap hm) throws Exception
	{
		//MLogger.writeDBLog("Table name: " + table, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "insert(table)");
		HashMap formatedVals = formatData(table, hm);
		String query = new String();
		String fields = new String();
		String values = new String();
		int iResult = 0;

		Set set = formatedVals.entrySet();
		Iterator it = set.iterator();
		for(int i = 0; it.hasNext(); i++)
		{
			Map.Entry me = (Map.Entry)it.next();
			if(i == 0)
			{
				fields = (String)me.getKey();
				values = (String)me.getValue();
			}
			else
			{
				fields = fields + "," + (String)me.getKey();
				values = values + ","+ (String)me.getValue();
				
				//Changed by Nazia on 02-Sep-2008[changes done to track why time inserted as hr:mm]start
				if ("DR_DOCTOR_VISIT".equals(table))
				{					
					if ("DOCTOR_VISIT_TIME".equals((String)me.getKey()))
					{					
						if ( ((String)me.getValue()).indexOf("h")!=-1)
						{
							//LogFile.writeToLog("DBOperations : insert() visitTime :: "+(String)me.getValue()+" From function insert()");
						}
					}
				}
				//Changed by Nazia on 02-Sep-2008[changes done to track why time inserted as hr:mm]end	
			}
		}
		query = "INSERT INTO " + table + "(" + fields + ") VALUES (" + values + ")";
		System.out.println("insert query--"+query);
			ArrayList arr = new ArrayList(hm.keySet());
			ArrayList arr1 = new ArrayList(hm.values());
			for(int k=0; k<arr.size();k++)
			{
				//System.out.println("DBOperations ArrayList1["+arr.get(k)+"]DBOperations ArrayList1["+arr1.get(k)+"]");
			}
		//MLogger.writeDBLog("Query: " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "insert(table)");
		
		iResult = insUpdDel(query);
		/*if(iResult < 0)
			Logger.writeDBLog("Data not inserted", Logger.LOG_LEVEL_NOTICE, "DBOperations.java", "insert(table)");
		else
			Logger.writeDBLog("Insertion successful ! no of rows inserted = " + iResult, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "insert(table)");
*/		//System.out.println(" insert query result iResult ["+iResult+"]");
		return iResult;
	}

	/**
	  *	@method Update table by creating the query at runtime.
	  *	@param String, HashMap, HashMap table into which data (HashMap) is to be updated for
	  * which data row (HashMap).
	  *	@param String Query to be updated
	  * @return int Integer indicating whether updation was successful
	  * @exception Exception
	  */
	public int update(String table, HashMap hmSet, HashMap hmWhere) throws Exception
	{
		HashMap formatedSetVals = formatData(table, hmSet);
		HashMap formatedWhereVals = formatData(table, hmWhere);
		String query = new String();
		String setClause = new String();
		String whereClause = new String();
		int iResult = 0;

		/**
		  * Format the set clause & get the iterator
		  */
		Set set = formatedSetVals.entrySet();
		Iterator it = set.iterator();

		for(int i = 0; it.hasNext(); i++)
		{
			Map.Entry me = (Map.Entry)it.next();
			if(i == 0)
				setClause = (String)me.getKey() + "=" + (String)me.getValue();
			else
				setClause = setClause + "," + (String)me.getKey() + "=" + (String)me.getValue();
		}
		/**
		  * Format the where clause & get the iterator
		  */
		set = formatedWhereVals.entrySet();
		it = set.iterator();

		for(int i = 0; it.hasNext(); i++)
		{
			Map.Entry me = (Map.Entry)it.next();
			if(i == 0)
				whereClause = (String)me.getKey() + " = " + (String)me.getValue();
			else
				whereClause = whereClause + " AND " + (String)me.getKey() + " = " + (String)me.getValue();
		}

		query = "UPDATE " + table + " SET " + setClause + " WHERE " + whereClause;

		System.out.println("DBOperations :: Update Query ["+query+"]");


		//MLogger.writeDBLog("query: " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "update(table)");
		iResult = insUpdDel(query);

		/*if(iResult < 0)
		{
			Logger.writeDBLog("Data not updated", Logger.LOG_LEVEL_NOTICE, "DBOperations.java", "update(table)");
		}
		else
		{
			Logger.writeDBLog("Updation successful", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "update(table)");
		}*/
		return iResult;

	}

	/**
	  *	@method Delete from table by creating the query at runtime.
	  *	@param String, HashMap table from which data (HashMap) is to be deleted
	  * @return int Integer indicating whether deletion was successful
	  * @exception Exception
	  */
	public int delete(String table, HashMap hmWhere) throws Exception
	{

		HashMap formatedVals = formatData(table, hmWhere);
		String query = new String();
		String whereClause = new String();
		int iResult = 0;

		Set set = formatedVals.entrySet();
		Iterator it = set.iterator();

		for(int i = 0; it.hasNext(); i++)
		{
			Map.Entry me = (Map.Entry)it.next();
			if(i == 0)
				whereClause = (String)me.getKey() + " = " + (String)me.getValue();
			else
				whereClause = whereClause + " AND " + (String)me.getKey() + " = " + (String)me.getValue();
		}

		query = "DELETE FROM " + table + " WHERE " + whereClause;
		//System.out.println("DBOperations.java,>>>>>>>>>>>>>delete(table)"+query); 
		//MLogger.writeDBLog("query: " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "delete(table)");

		iResult = insUpdDel(query);

		/*if(iResult < 0)
			Logger.writeDBLog("Data not deleted", Logger.LOG_LEVEL_NOTICE, "DBOperations.java", "delete(table)");
		else
			Logger.writeDBLog("Deletion successful", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "delete(table)");*/
		////System.out.println("iResult :"+iResult);
		return iResult;
	}
	/**
	* @method This Method will Close statment Object.
    * Parag Shah
	* 12/4/02
	**/
	//Changed by nazia on 28-Apr-2009[]
	/*public void stmtClose() throws Exception
	{	
		try
		{
			if(stmt != null)
			{
				stmt.close();
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}*/
	/**
	  * @method This method will execute the query that is been passed as the parameter and will
	  * return the result set to the class that is calling specially for select statement
	  *	@param String Query passed to retrieve results
	  * @return ResultSet A resultset which can be iterated.
	  * @exception Exception
	  */
	public ResultSet selectResultSet(String query) throws Exception
	{
		System.out.println(" in selectResultSet ");
		//Connection con = null;
		ResultSet rs = null;
		//Changed by nazia on 28-Apr-2009[WS90SUN094]
		Statement stmt = null;
		//MLogger.writeDBLog("select statement " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "selectResultSet");
		try
		{	
			stmt = con.createStatement();
			rs = stmt.executeQuery(query);
			con.commit();
			
			//Changed by nazia on 28-Apr-2009[]						
			System.out.println("select Query executed successfully");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			/*if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
			if (con!=null)
			{
				con.close();con = null;
			}*/
		}

		//MLogger.writeDBLog("select Query executed successfully", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "selectResultSet");
		return rs;
	}
	/**
	  *	@method Method to return a Vector of Vector given a ResultSet.
	  *	@param String query to be executed
	  * @return Vector This Vector consists of a Vector(each row of ResultSet).
	  * @exception Exception
	  */
	public Vector selectVector(String query) throws Exception
	{
		System.out.println(" selectVector query ["+query+"]");
		Vector vectorRS = new Vector();
		//MLogger.writeDBLog("", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "getResultVector");
		//Connection con = null;
		ResultSet rs = null;
		//Changed by nazia on 28-Apr-2009[WS90SUN094]
		Statement stmt = null;
		try
		{	
			//Changed by nazia on 29-04-09[WS89SUN094]Start
			//ResultSet rs = selectResultSet(query);
			System.out.println(" in selectResultSet ");			
			//MLogger.writeDBLog("select statement " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "selectResultSet");			
						
			stmt = con.createStatement();
			rs = stmt.executeQuery(query);					
			System.out.println("select Query executed successfully");			
			//Changed by nazia on 29-04-09[WS89SUN094]End						
			columnCount = getColumnCount(rs);
			int fieldIndex = 1;

			/**
			  *	Vector to store the data in form of vector of vectors.
			  */
			while(rs.next())
			{
				fieldIndex = 1;

				/**
				  *	rowVector stores the values obtained in the resultset as a vector.
				  */
				Vector rowVector = new Vector();

				/**
				  *	Retrieve each value in a particular ResultSet and store it in a Vector, rowVector
				  */
				while(fieldIndex <= columnCount)
				{
					String sTemp = rs.getString(fieldIndex);

					fieldIndex++;
					
					if(sTemp == null)
						sTemp = "";

					rowVector.addElement(sTemp);
				}// while

				/**
				  *	Each rowVector needs to be added in another Vector, vectorRS
				  */
				vectorRS.addElement(rowVector);
			}// while rs.next()
			if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
			//informing no of rows selected
			//MLogger.writeDBLog("The no of rows selected = "+vectorRS.size(), Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "getResultVector");
			
		}

		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			if (rs!=null)
			{
				rs.close();
			}
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		return vectorRS;
	}

	/**
	  *	@method Method to return a comma-separated String given a ResultSet.
	  * This is required when a given result is to be passed to
	  * another query.
	  *	@param String query to be executed
	  * @return String This String consists of comma-separated values of
	  * each row of ResultSet.
	  * @exception Exception
	  */
	public String selectString(String query) throws Exception
	{
		//MLogger.writeDBLog("", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "selectString");
		Vector v = selectVector(query);
		String s = new String();
		if(v.size() == 0)
			s = "";
		else
			s = convertVectToStr(v);
		return s;
	}

	/**
	  *	@method This query is called by insert, update or delete to execute query.
	  *	@param String Query to be inserted or updated or deleted
	  * @return int Integer indicating whether insertion or updation
	  * or deletion was successful.
	  * @exception Exception
	  */
	private int insUpdDel(String query) throws Exception
	{
		//MLogger.writeDBLog("execute query", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "insUpdDel");
		int iResult = 0;		
		//Connection con = null;		
		//Changed by nazia on 28-Apr-2009[WS90SUN094]
		Statement stmt = null;
		try
		{
			stmt = con.createStatement();
			iResult = stmt.executeUpdate(query);
			System.out.println(" inside insUpdDel query ["+query+"] iResult ["+iResult+"]");
			con.commit();
			stmt.close();			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.out.println("exception :"+e);
		}
		finally
		{			
			if (stmt!=null)
			{
				stmt.close();
			}
		}
		return iResult;
	}

	/**
	  *	@method Insert using query.
	  *	@param String Query to be inserted
	  * @return int Integer indicating whether insertion was successful
	  * @exception Exception
	  */
	private int insert(String query) throws Exception
	{
		//MLogger.writeDBLog("Query: " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "insert(query)");
		int iResult = 0;
		iResult = insUpdDel(query);
		/*if(iResult < 0)
			Logger.writeDBLog("Data not inserted", Logger.LOG_LEVEL_NOTICE, "DBOperations.java", "insert(query)");
		else
			Logger.writeDBLog("Insertion successful! No of rows inserted = "+iResult, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "insert(query)");*/
		return iResult;
	}

	/**
	  *	@method Update using query.
	  *	@param String Query to be updated
	  * @return int Integer indicating whether updation was successful
	  * @exception Exception
	  */
	private int update(String query) throws Exception
	{
		//MLogger.writeDBLog("Query: " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "update(query)");
		int iResult = 0;
		iResult = insUpdDel(query);
		/*if(iResult < 0)
			Logger.writeDBLog("Data not updated", Logger.LOG_LEVEL_NOTICE, "DBOperations.java", "update(query)");
		else
			Logger.writeDBLog("Updation successful", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "update(query)");*/
		return iResult;
	}

	/**
	  *	@method Delete using query.
	  *	@param String Query to be deleted
	  * @return int Integer indicating whether deletion was successful
	  * @exception Exception
  */
	private int delete(String query) throws Exception
	{
		//Logger.writeDBLog("Query: " + query, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "delete(query)");
		int iResult = 0;
		iResult = insUpdDel(query);
		/*if(iResult < 0)
			Logger.writeDBLog("Data not deleted", Logger.LOG_LEVEL_NOTICE, "DBOperations.java", "delete(query)");
		else
			Logger.writeDBLog("Deletion successful", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "delete(query)");*/
		return iResult;
	}

	/**
	  * @method This method is used to format data according to
	  * dataType before insert/update.
	  * @param String, HashMap String consists of table name &
	  * HashMap consists of formatted values
	  * @return HashMap formatted values
	  */
	private HashMap formatData(String table, HashMap vals) throws Exception
	{
//		Logger.writeDBLog("format data", Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "formatData");

		HashMap tableInfo = getTableInfo(table);

		HashMap retVal = new HashMap();
		String sDType = new String();


		/**
		  * Get the iterator for the set
		  */
		Set set = vals.entrySet();
		Iterator i = set.iterator();

		while(i.hasNext())
		{
			Map.Entry me= (Map.Entry)i.next();

			/**
			  * Get the field name
			  */
			String sFldName= (String)me.getKey();
			String dtValue= (String)me.getValue();			
//			Logger.writeDBLog("Field name: " + sFldName + " value before format: " + dtValue, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "formatData");
			sDType = (String)tableInfo.get(sFldName);

			System.out.println("sFldName name: [" +sFldName+ "] dtValue: [" +dtValue+"] sDType ["+sDType+"]..............");

			//MLogger.writeDBLog("Field type: " + sDType, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "formatData");
			dtValue = getValue(sDType, dtValue);
			
	//		Logger.writeDBLog("Value after format: " + dtValue, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "formatData");
			retVal.put(sFldName, dtValue);
		}
		return retVal;
	}

	/**
	  * @method This method is used to format the data according to dataType before insert/update
	  * @param String, String this consists of the type and the value of the columns respectively
	  * @return String formted value
	  */
	private String getValue(String sType, String sValue) throws Exception
	{
		String[] numberFields ={"SMALLINT","INTEGER","REAL","DOUBLE","INT","BIGINT","FLOAT",
								"MEDIUMINT","DECIMAL","ENUM","SET","TINYINT"} ;
		String[] textFields = {"VARCHAR","LONGCHAR","CHAR","TIMESTAMP","TINYTEXT","TEXT",
								"MEDIUMTEXT","LONGTEXT"};
		String[] dateFields = {"DATETIME","DATE","TIME","YEAR"};
//		Logger.writeDBLog("Type: " + sType + " Value: " + sValue, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "getValue");
		String sReturn = new String();

		//if(sType.equalsIgnoreCase("NUMBER"))
		if(sType.equalsIgnoreCase("SMALLINT") || sType.equalsIgnoreCase("INTEGER") ||
		sType.equalsIgnoreCase("REAL") || sType.equalsIgnoreCase("DOUBLE") ||
		sType.equalsIgnoreCase("INT") || sType.equalsIgnoreCase("BIGINT") || 
		sType.equalsIgnoreCase("FLOAT") || sType.equalsIgnoreCase("MEDIUMINT") ||
		sType.equalsIgnoreCase("DECIMAL") || sType.equalsIgnoreCase("ENUM") || 
		sType.equalsIgnoreCase("SET") || sType.equalsIgnoreCase("TINYINT") ||  sType.equalsIgnoreCase("NUMBER"))
			sReturn = sValue;

		//if(sType.equalsIgnoreCase("TEXT"))
		if(sType.equalsIgnoreCase("VARCHAR") || sType.equalsIgnoreCase("LONGCHAR")
		|| sType.equalsIgnoreCase("CHAR") || sType.equalsIgnoreCase("TIMESTAMP")
		|| sType.equalsIgnoreCase("TINYTEXT") || sType.equalsIgnoreCase("TEXT") 
		|| sType.equalsIgnoreCase("MEDIUMTEXT") || sType.equalsIgnoreCase("LONGTEXT")
		|| sType.equalsIgnoreCase("VARCHAR2"))
			sReturn = "'" + sValue + "'";

		if(sType.equalsIgnoreCase("DATETIME") || sType.equalsIgnoreCase("DATE") 
		|| sType.equalsIgnoreCase("TIME") || sType.equalsIgnoreCase("YEAR"))
		{
			System.out.println(" DBOperation:: getValue() dbName ["+dbName+"]");

			if(dbName.equalsIgnoreCase("Access"))
				sReturn = "#" + sValue + "#";
			else if (dbName.equalsIgnoreCase("oracle"))
			{
					System.out.println(" DBOperation:: getValue() sValue  ["+sValue+"]");
					if (sValue.indexOf("TO_") != -1)
					{
						sReturn = sValue ;
					}
					else
					{
						sReturn = "'" + sValue + "'";
					}

					System.out.println(" DBOperation:: getValue() sReturn["+sReturn+"]");
				
			}
			else
			sReturn = "'" + sValue + "'";
		}
//		Logger.writeDBLog("Return value: " + sReturn, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "getValue");
		//System.out.println("sReturn "+sReturn);
		return sReturn;
	}

	/**
	  *	@method Get the column count of the columns retrieved during select
	  * @param ResultSet
	  * @return int The no. of columns of each row in ResultSet
	  * @exception Exception
	  */
	private int getColumnCount(ResultSet rs) throws Exception
	{
		int colCount = 0;
		try
		{
			rsmd = rs.getMetaData();
			colCount = rsmd.getColumnCount();
//			Logger.writeDBLog("Column count is " + columnCount, Logger.LOG_LEVEL_DEBUG, "DBOperations.java", "getColumnCount");
		}
		catch (Exception e)
		{
			throw e;
		}
		columnCount = colCount;
		return colCount;
	}

	/**
	  *	@method Method to convert a Vector to comma-separated String.
	  *	@param Vector This Vector consists of a Vector(each row of ResultSet).
	  * @return String This String consists of comma-separated values of
	  * each row of ResultSet.
	  * @exception Exception
	  */
	private String convertVectToStr(Vector v) throws Exception
	{
		//MLogger.writeDBLog("", Logger.LOG_LEVEL_DEBUG, "Utilities.java", "convertVectToStr");
		int i = 0;
		String s = new String();
		Vector v2 = new Vector();
		for(i = 0; i < v.size() - 1; i++)
		{
			v2 = (Vector)v.elementAt(i);
			s += v2.elementAt(0);
			s += ",";
		}
		v2 = (Vector)v.elementAt(i);
		s += v2.elementAt(0);
		return s;
	}

	/**
	  *	@method This is a Utility method for the time-being to display contents of
	  * Vector.
	  *	@param Vector This Vector consists of a Vector(each row of ResultSet).
	  * @return void
	  * @exception Exception
	  */
	public void showVector(Vector v) throws Exception
	{
		int i = 0;
		try
		{
			i = v.size();
			int k = 0;
			while(k < i)
			{
				Vector vt = (Vector)v.elementAt(k);
				int l = 0;
				while(true)
				{
					try
					{
						//MLogger.writeDBLog(l + " = " + vt.elementAt(l), Logger.LOG_LEVEL_DEBUG, "Utilities.java", "showVector");
						
					}
					catch(ArrayIndexOutOfBoundsException e)
					{
						System.out.print(vt.lastElement());
						break;
					}
					l++;
				}
				
				k++;
			}
		}
		catch (NullPointerException e)
		{
			//System.out.println("Loan: show(Vector) :"+i+"--"+e);
		}
	}
	
	public void removeCon() throws Exception
	{
		try
		{
			if ( con != null )
			{
				con.close();
				con = null;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
	}
	/*public static void main(String args[]) throws Exception
	{
		DBConnection con = new DBConnection();
		//Changed by nazia on 04-Jun-2009[Created new constructor where DBConnection object is not passed. WS89SUN094]
		DBOperations dbOpr = new DBOperations();

		String query = "SELECT * FROM USERS";
		Vector v = dbOpr.selectVector(query);
		
		con.conClose();
	}*/
}
