package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;

import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wsfa.WSFACommon;

//@Stateless
public class CusSeriesUploadEJB extends ValidatorEJB
{
E12GenericUtility genericUtility = new E12GenericUtility();
protected static String database = CommonConstants.DB_NAME;
private static final String ABC = "abcdefghijklmnopqrstuvwxyz";
private static Map<String, Integer> dictionary = new HashMap<>();

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams,Connection conn) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString" + xmlString);
		System.out.println("xmlString1" + xmlString1);
		System.out.println("xmlString2" + xmlString2);
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams,conn);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: StrgCustomer: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from StrgCustomer wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams,Connection connectionObject) throws RemoteException, ITMException
	{
		System.out.println("entr in qwfvalDAta in for quali ");
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String scCode = "";
		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int cntCS=0;
		int cntSP=0;
		boolean isLocalConn=false;

		int currentFormNo = 0;
		String practicingSince = "";
		String totalBusiness = "";
		String businessToUs = "";
		String visitNo = "";
		String status1="";
		String routeStatus="";
		String custType="";
		ArrayList<String> sprsRoutTypeList =new ArrayList<String>();
		ArrayList<String> locWiseDrDataArray = new ArrayList<String>();
		// Map<String, Integer> dictionary = new HashMap<>();
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		try
		{

			SimpleDateFormat dob = new SimpleDateFormat(getApplDateFormat());
			//ConnDriver connDriver = null;
			//connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			if(connectionObject==null)
			{
				connectionObject = getConnection();
				isLocalConn=true;
			}
			//Added by vinayak on [08/07/2016] to get connection.
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			//added bys sachin satre on [31-may-17]for validating the locality non actvie [start]
			String objName=getObjNameFromDom(dom,"objName",currentFormNo);
			System.out.println("objNameobjName::::in new dr creation:["+objName+"]");
			//added bys sachin satre on [31-may-17]for validating the locality non actvie [end]

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
				case 1:

					//if (childNodeName.equalsIgnoreCase("locality_descr"))//Commeneted by vinayak on [20/06/2016] to remove validation for locality descr
					if (childNodeName.equalsIgnoreCase("locality_code"))// Added by vinayak on [20/06/2016] to check validation for locality code
					{
						String	locCode= checkNull(genericUtility.getColumnValue("locality_code",dom));
						String confirmByMKT=checkNull(genericUtility.getColumnValue("confirmed_by_mkt",dom));

						if(childNode.getFirstChild() == null)
						{

							errString =  itmDBAccess.getErrorString("locality_code","NULLOCCODE",userId);
						}
						else
						{	String sales_perss= checkNull(genericUtility.getColumnValue("sales_pers",dom));
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							if( columnValue != null )
							{
								if(columnValue.length()==0)
								{
									String errCode = "NULLOCCODE";
									errString =  itmDBAccess.getErrorString("locality_code",errCode,userId);
									break ;

								}
								else
								{
									String sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE LOCALITY_CODE = ?";
							//		String sql1 = "SELECT LOCALITY_CODE FROM customer_series_upload WHERE LOCALITY_CODE = ? AND SALES_PERS = ?";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, locCode);
									rs = pstmt.executeQuery();
									if ( !rs.next() )
									{
										errString =  itmDBAccess.getErrorString("locality_code","LOCNOTEXT",userId);
									}
									if(rs != null)
									{
										rs.close();
										rs=null;
									}
									if(pstmt != null)
									{
										pstmt.close();
									}

									//added by sachin satre on [31-may-17] for validating the locality is active or noT [start]

									String sql1 = "SELECT LOCALITY_CODE,STATUS FROM LOCALITY WHERE LOCALITY_CODE = ?";
									pstmt = connectionObject.prepareStatement(sql1);
									pstmt.setString(1, locCode);
									System.out.println("sql1:::>>>DSFDSF>["+sql1+"]");
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										status1 = checkNull(rs.getString("STATUS"));
										System.out.println("STATUS IN LOCALITY MASTER::["+status1+"]");
									}
									if(rs != null)
									{
										rs.close();
										rs=null;
									}
									if(pstmt != null)
									{
										pstmt.close();
									}

									String sql2 = "SELECT STATUS FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ? ";
									pstmt = connectionObject.prepareStatement(sql2);
									pstmt.setString(1, sales_perss);
									pstmt.setString(2, locCode);
									System.out.println("sql2:::>>>DSFDSF>["+sql2+"]");
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										routeStatus = checkNull(rs.getString("STATUS"));
										System.out.println("STATUS OF LOCALITY IN ROUTE MASTER::["+routeStatus+"]");
									}
									if(rs != null)
									{
										rs.close();
										rs=null;
									}
									if(pstmt != null)
									{
										pstmt.close();
									}

									System.out.println("confirmByMKT>>>:::>>>>["+confirmByMKT+"]");
									System.out.println("objNameobjName:::::>>>["+objName+"]");
									System.out.println("routeStatus OF SPRS_ROUTE MASTER::>>>["+routeStatus+"]");
									System.out.println("status1 OF LOCALITY MASTER::>>>["+status1+"]");
									System.out.println("sales_perss>>>:::>>>>["+sales_perss+"]");

									if(objName!=null && "custseries_upload".equalsIgnoreCase(objName))
									{
										System.out.println("INSIDE custseries_upload OBJ NAME :::");
										if(status1!=null && "N".equalsIgnoreCase(status1))
										{
											errString =  itmDBAccess.getErrorString("locality_code","LOCDDEACTV",userId);
										}

										else if(routeStatus!=null && "N".equalsIgnoreCase(routeStatus))
										{
											errString =  itmDBAccess.getErrorString("locality_code","LONTACTVRT",userId);
										}
									}
									if(objName!=null && "custseries_upld_aprv_rk".equalsIgnoreCase(objName))
									{
										System.out.println("INSIDE custseries_upld_aprv_rk OBJ NAME DFSGFGF::");
										if(status1!=null && "N".equalsIgnoreCase(status1) && confirmByMKT!=null && "A".equalsIgnoreCase(confirmByMKT))
										{
											errString =  itmDBAccess.getErrorString("locality_code","LOCDDEACTV",userId);
										}
										else if(routeStatus!=null && "N".equalsIgnoreCase(routeStatus) && confirmByMKT!=null && "A".equalsIgnoreCase(confirmByMKT))
										{
											errString =  itmDBAccess.getErrorString("locality_code","LONTACTVRT",userId);
										}
									}
									//added by sachin satre on [31-may-17] for validating the locality is active or noT [end]

									//added by sachin satre on [11-jul-17] for validating the locality type is if M or T then validate it[start]
									String sql3 = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE LOCALITY_CODE = ?  AND SPRS_CODE = ? AND STATUS = 'Y' AND ROUTE_TYPE IN  ('M','T') ";
									pstmt = connectionObject.prepareStatement(sql3);
									pstmt.setString(1, locCode);
									pstmt.setString(2, sales_perss);
									System.out.println("sql3:::>>>sql3>["+sql3+"]");
									rs = pstmt.executeQuery();
									int routeTypeCnt =0;
									if(rs.next())
									{
										routeTypeCnt = rs.getInt("COUNT");
										System.out.println("COUNT IN SPRS ROUTE  routeTypeCnt::["+routeTypeCnt+"]");
									}
									if(rs != null)
									{
										rs.close();
										rs=null;
									}
									if(pstmt != null)
									{
										pstmt.close();
									}
									if(routeTypeCnt > 0 )
									{
										System.out.println("invalid route type .route type should be (H,O,X) locality");
										errString =  itmDBAccess.getErrorString("locality_code","IVROUTTYPE",userId);
									}
									//added by sachin satre on [11-jul-17] for validating the locality type is if M or T then validate it[end]

								}
							}
						}
					}
					else if("first_name".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() == null)
						{

							errString =  itmDBAccess.getErrorString("first_name","VTCSFNMENL",userId);
						}
						else
						{
						String fName="";
						fName= checkNull(genericUtility.getColumnValue("first_name",dom));
						if(fName.length()==0)
						{
							String errCode = "VTCSFNMENL";
							errString =  itmDBAccess.getErrorString("first_name",errCode,userId);
							break ;

						}
						else{
							Pattern p = Pattern.compile("[^A-Za-z0-9\\s]");
							Matcher m = p.matcher(fName);
							boolean b = m.find();
							if(b==true){
							String errCode = "VTCSUSPLCH";
							errString =  itmDBAccess.getErrorString("first_name",errCode,userId);
							break ;
						}
							}
						}
					}
					else if("middle_name".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() != null)
						{
						String mName="";
						mName= checkNull(genericUtility.getColumnValue("middle_name",dom));
						if(mName.length()==0)
						{
							String errCode = "VTCSMNMENL";
							errString =  itmDBAccess.getErrorString("middle_name",errCode,userId);
							break ;

						}
						else{
							Pattern p = Pattern.compile("[^A-Za-z0-9\\s]");
							Matcher m = p.matcher(mName);
							boolean b = m.find();
							if(b==true){
							String errCode = "VTCSUSPLCH";
							errString =  itmDBAccess.getErrorString("middle_name",errCode,userId);
							break ;
						}
							}
						}
					}
					else if("last_name".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() == null)
						{

							errString =  itmDBAccess.getErrorString("last_name","VTCSLNMENL",userId);
						}
						else
						{
						String lName="";
						lName= checkNull(genericUtility.getColumnValue("last_name",dom));
						if(lName.length()==0)
						{
							String errCode = "VTCSLNMENL";
							errString =  itmDBAccess.getErrorString("last_name",errCode,userId);
							break ;

						}
						else{
							Pattern p = Pattern.compile("[^A-Za-z0-9\\s]");
							Matcher m = p.matcher(lName);
							boolean b = m.find();
							if(b==true){
							String errCode = "VTCSUSPLCH";
							errString =  itmDBAccess.getErrorString("last_name",errCode,userId);
							break ;
						}
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("address_as"))
					{

						if(childNode.getFirstChild() == null)
						{

							errString =  itmDBAccess.getErrorString("address_as","VTCSADRNUL",userId);
						}
						else
						{
						String address_as="";
						address_as= checkNull(genericUtility.getColumnValue("address_as",dom));
						if(address_as.length()==0)
						{
							String errCode = "VTCSADRNUL";
							errString =  itmDBAccess.getErrorString("address_as",errCode,userId);
							break ;

						}
						else{
							Pattern p = Pattern.compile("[^A-Za-z0-9\\s]");
							Matcher m = p.matcher(address_as);
							boolean b = m.find();
							if(b==true){
							String errCode = "VTCSADRSPL";
							errString =  itmDBAccess.getErrorString("address_as",errCode,userId);
							break ;
						}
							}
						}

					}
					// Commented  by sachin satre 0n [26/02/2016] To validate qualification request id W15KSUN018 [start]
					//Uncommented by vinayak to check validation for qualification on [04/07/2016] [start]
					else if (childNodeName.equalsIgnoreCase("qualification"))
					{
						String qualif="";
						qualif= checkNull(genericUtility.getColumnValue("qualification",dom));
						String fellow="";
						fellow= checkNull(genericUtility.getColumnValue("fellowship",dom));
						if(qualif.trim().equals("") && fellow.trim().equals(""))
						{
							errString =  itmDBAccess.getErrorString("qualification","VTCSUQUNL",userId);
							break;
						}
						else if(!qualif.trim().equals(""))
						{
							String sql = "SELECT descr,sh_descr as qualification FROM qualification where qlf_code=?";
							pstmt = connectionObject.prepareStatement(sql);

							pstmt.setString(1, qualif);

							rs = pstmt.executeQuery();
							if ( !rs.next() )
							{
								errString =  itmDBAccess.getErrorString("qualification","VTCUSQLIFY",userId);
							}
							rs.close();
							if(pstmt != null)
							{
								pstmt.close();
							}
						}
					}
					//Uncommented by vinayak to check validation for qualification on [04/07/2016] [end]
					// commented by sachin satre 0n [26/02/2016] To validate qualification request id W15KSUN018 [start]
					else if (childNodeName.equalsIgnoreCase("addr1"))
					{
						if(childNode.getFirstChild() == null)
						{

							errString =  itmDBAccess.getErrorString("addr1","VTCSAD1NUL",userId);
						}
						else
						{
						String addr1="";
						addr1= checkNull(genericUtility.getColumnValue("addr1",dom));
						if(addr1.length()==0)
						{
							String errCode = "VTCSAD1NUL";
							errString =  itmDBAccess.getErrorString("addr1",errCode,userId);
							break ;

						}
						else
						{
							Pattern p = Pattern.compile("[^A-Za-z0-9,.\\s]");
							Matcher m = p.matcher(addr1);
							boolean b = m.find();
							if(b==true)
							{
							String errCode = "VTCSADRSPL";
							errString =  itmDBAccess.getErrorString("addr1",errCode,userId);
							break ;
							}
						}
//						else{
//							Pattern p = Pattern.compile("[^A-Za-z0-9]");
//							Matcher m = p.matcher(addr1);
//							boolean b = m.find();
//							if(b==true){
//							String errCode = "VTCSUSPLCH";
//							errString =  getErrorString("addr1",errCode,userId);
//							break ;
//						}
//							}
						}

					}

			// modified by sachin satre on [18/02/2106] [start]	mandotory validation of addr2 or road name or building name

					/*	else if (childNodeName.equalsIgnoreCase("addr2"))
					{
						if(childNode.getFirstChild() != null)
						{
						String addr2="";
						addr2= checkNull(genericUtility.getColumnValue("addr2",dom));
						if(addr2.length()==0)
						{
							String errCode = "VTCSAD2NUL";
							errString =  getErrorString("middle_name",errCode,userId);
							break ;

						}
//						else{
//							Pattern p = Pattern.compile("[^A-Za-z0-9]");
//							Matcher m = p.matcher(addr2);
//							boolean b = m.find();
//							if(b==true){
//							String errCode = "VTCSUSPLCH";
//							errString =  getErrorString("middle_name",errCode,userId);
//							break ;
//						}
//							}
						}
					}*/

					else if (childNodeName.equalsIgnoreCase("addr2"))
					{
						System.out.println("validation of road name or biulding name");
						if(childNode.getFirstChild() == null)
						{
							System.out.println("validation of road name or biulding name111111");
							errString =  itmDBAccess.getErrorString("addr2","VTBRD2NUL",userId);
						}
						else
						{
						String addr2="";
						addr2= checkNull(genericUtility.getColumnValue("addr2",dom));
						System.out.println("validation of road name or biulding name2222222");
						if(addr2.length()==0)
						{
							System.out.println("validation of road name or biulding name3333");
							String errCode = "VTBRD2NUL";
							errString =  itmDBAccess.getErrorString("addr2",errCode,userId);
							break ;

						}
						else
						{
							System.out.println("validation of road name or biulding name44444");
							Pattern p = Pattern.compile("[^A-Za-z0-9,.\\s]");
							Matcher m = p.matcher(addr2);
							boolean b = m.find();
							if(b==true)
							{
							System.out.println("validation of road name or biulding name5555");
							String errCode = "VTCSADRSPL";
							errString =  itmDBAccess.getErrorString("addr2",errCode,userId);
							break ;
							}
						}
//						else{
//							Pattern p = Pattern.compile("[^A-Za-z0-9]");
//							Matcher m = p.matcher(addr1);
//							boolean b = m.find();
//							if(b==true){
//							String errCode = "VTCSUSPLCH";
//							errString =  itmDBAccess.getErrorString("addr1",errCode,userId);
//							break ;
//						}
//							}
						}

					}
					// modified by sachin satre on [18/02/2106] [end]
					else if (childNodeName.equalsIgnoreCase("addr3"))
					{
						if(childNode.getFirstChild() != null)
						{
						String addr3="";
						addr3= checkNull(genericUtility.getColumnValue("addr3",dom));
						if(addr3.length()==0)
						{
							String errCode = "VTCSAD3NUL";
							errString =  itmDBAccess.getErrorString("addr3",errCode,userId);
							break ;

						}
//						else{
//							Pattern p = Pattern.compile("[^A-Za-z0-9]");
//							Matcher m = p.matcher(addr3);
//							boolean b = m.find();
//							if(b==true){
//							String errCode = "VTCSUSPLCH";
//							errString =  itmDBAccess.getErrorString("middle_name",errCode,userId);
//							break ;
//						}
//							}
						}
					}
					else if("stan_code".equalsIgnoreCase(childNodeName))
					{
					/*	if(childNode.getFirstChild() == null)
						{
							errString = itmDBAccess.getErrorString( "stan_code", "NULSTNCODE", userId );
							break;
						}
						else
						{
							String stan_code="";
							stan_code= checkNull(genericUtility.getColumnValue("stan_code",dom));
							if(stan_code.length()==0)
							{
								String errCode = "NULSTNCODE";
								errString =  itmDBAccess.getErrorString("stan_code",errCode,userId);
								break ;

							}
							else
							{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							if( columnValue != null )
							{
								String sql = "SELECT STAN_CODE FROM STATION WHERE STAN_CODE = ?";
								pstmt = connectionObject.prepareStatement(sql);

								pstmt.setString(1, columnValue);

								rs = pstmt.executeQuery();
								if ( !rs.next() )
								{
									errString =  itmDBAccess.getErrorString("stan_code","VMSTANCDX",userId);
								}
								rs.close();
								if(pstmt != null)
								{
									pstmt.close();
								}
							}

							break;}
						}*/
					}
					else if("state_code".equalsIgnoreCase(childNodeName))
					{
						/*if(childNode.getFirstChild() == null)
						{
							errString = itmDBAccess.getErrorString( "state_code", "NLSTATCODE", userId );
							break;
						}
						else
						{
							String state_code="";
							state_code= checkNull(genericUtility.getColumnValue("state_code",dom));
							if(state_code.length()==0)
							{
								String errCode = "NLSTATCODE";
								errString =  itmDBAccess.getErrorString("state_code",errCode,userId);
								break ;

							}
							else
							{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							if( columnValue != null )
							{
								String sql = "SELECT STATE_CODE FROM STATION WHERE STATE_CODE = ?";
								pstmt = connectionObject.prepareStatement(sql);

								pstmt.setString(1, columnValue);

								rs = pstmt.executeQuery();
								if ( !rs.next() )
								{
									errString =  itmDBAccess.getErrorString("state_code","UV_STATE",userId);
								}
								rs.close();
								if(pstmt != null)
								{
									pstmt.close();
								}
							}
							break;
							}
						}*/
					}
					else if (childNodeName.equalsIgnoreCase("pin"))
					{
						String pin="";
						pin= checkNull(genericUtility.getColumnValue("pin",dom));

						if(childNode.getFirstChild() == null)
						{
							errString =  itmDBAccess.getErrorString("pin","VTCSPINNUL",userId);
							break;
						}
						else
						{
							if(pin.length()==0)
							{
								String errCode = "VTCSPINNUL";
								errString =  itmDBAccess.getErrorString("state_code",errCode,userId);
								break ;

							}
							else
							{

							if(pin.matches("\\d+"))
							{
								//int num=Integer.parseInt(pin.trim());
								double num=Double.parseDouble(pin.trim());
								if(num <= 0)
								{
									errString =  itmDBAccess.getErrorString("pin","VTCSNULCDE",userId);
									break ;
								}
								else if(num<=100000  && num<=999999 )
								{
									errString =  itmDBAccess.getErrorString("pin","VTCSVALCDE",userId);
									break ;
								}
							}
							else
							{
								errString =  itmDBAccess.getErrorString("pin","VTCSVALCDE",userId);
								break ;
							}
							}
						}

					}
					else if("count_code".equalsIgnoreCase(childNodeName))
					{
					/*	if(childNode.getFirstChild() == null)
						{
							errString = itmDBAccess.getErrorString( "count_code", "NLCOUNTCOD", userId );
						}
						else
						{
							String count_code="";
							count_code= checkNull(genericUtility.getColumnValue("count_code",dom));
							if(count_code.length()==0)
							{
								String errCode = "NLCOUNTCOD";
								errString =  itmDBAccess.getErrorString("state_code",errCode,userId);
								break ;

							}
							else
							{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							if( columnValue != null )
							{
								String sql = "SELECT COUNT_CODE FROM COUNTRY WHERE COUNT_CODE = ?";
								pstmt = connectionObject.prepareStatement(sql);

								pstmt.setString(1, columnValue);

								rs = pstmt.executeQuery();
								if ( !rs.next() )
								{
									errString =  itmDBAccess.getErrorString("count_code","UV_COUNTRY",userId);
								}
								rs.close();
								if(pstmt != null)
								{
									pstmt.close();
								}
							}
							break;
							}
						}
						*/
					}

					else if(childNodeName.equalsIgnoreCase("email_addr"))
                    {
                        System.out.println(" Validaion   for field "+childNodeName);
                        if(childNode.getFirstChild() != null)
                        {
                            String emailId = childNode.getFirstChild().getNodeValue().trim();
    						if(emailId.length()==0)
    						{
    							String errCode = "INVEMAIL";
    							errString =  itmDBAccess.getErrorString("email_addr",errCode,userId);
    							break ;

    						}
    						else{
                            String emailregex = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";
                            Boolean b = emailId.matches(emailregex);
                            if (b == false)
                            {
                             String   errCode = "INVEMAIL";
                                errString =  itmDBAccess.getErrorString("email_addr",errCode,userId);
                                break ;
                            }
    						}
                        }

                    }

					/*else if (childNodeName.equalsIgnoreCase("mobile_no"))
					{
						String mobileNo = genericUtility.getColumnValue("mobile_no", dom);
						if(mobileNo!= null && mobileNo.trim().length() > 0)
                        {
                            if(mobileNo.matches("\\d+"))
                            {
                                long num=Long.parseLong(mobileNo);
                                if(num <= 0)
                                {
                          String errCode = "VTENTCTELM";
                                    errString =  itmDBAccess.getErrorString("mobile_no",errCode,userId);
                                    break ;
                                }
                            }
                            else
                            {
                          String  errCode = "VTENTCTELM";
                                errString =  itmDBAccess.getErrorString("mobile_no",errCode,userId);
                                break ;
                            }
                        }
					}*/
					//as per reqquirement chnages to make field mandtory [24-mar-2020] start
					else if (childNodeName.equalsIgnoreCase("mobile_no"))
					{
						boolean isErr = false;
						String mobileNo = genericUtility.getColumnValue("mobile_no", dom);
						//added by shraddha M sapce should not allow in mobile no [19/06/20] start
						if ( (mobileNo.contains(" "))  || mobileNo.isEmpty())
                        {
							errString =  itmDBAccess.getErrorString("mobile_no__o","INVMOBNUM",userId);
                        }
						//added by shraddha M sapce should not allow in mobile no [19/06/20] end
						if(childNode.getFirstChild() != null)				
						{
							if(mobileNo!= null && mobileNo.trim().length() > 0)
	                        {
								if(mobileNo.matches("\\d+"))
								{
									long num=Long.parseLong(mobileNo);
	                                char chg =mobileNo.charAt(0);
	                                System.out.println("MobileNum value::["+num+"]::chg["+chg+"]");
	                                if(num <= 0 || mobileNo.trim().length() <= 9)
	                                {
	                                	System.out.println(" insdide modbile number less than 10 num::["+num+"]::chg["+chg+"]["+mobileNo+"]");
	                                   errString =  getErrorString("mobile_no","VTENTCTELM",userId);
	                                    isErr = true; 
	                                    break ;
	                                }
	                                if(chg=='0' || mobileNo.startsWith("0"))
	                                {
	                                	System.out.println(" insdide modbile number start wit zero::["+num+"]::chg["+chg+"]["+mobileNo+"]");
	                                    errString =  getErrorString("mobile_no","INVMOBNUM",userId);
	                                    isErr = true;
	                                    break ;
	                                }
	                               
	                             }
								 else
								  {
									errString =  getErrorString("mobile_no","INVMOBNUM",userId);
								  }
							}
						}
						else
						{
							errString =  getErrorString("mobile_no","NULLMOBNO",userId);
						}
					}
					//as per reqquirement chnages to make field mandtory [24-mar-2020]  end	
				else if (childNodeName.equalsIgnoreCase("telephone1"))
					{
					String tele1="";
					tele1= checkNull(genericUtility.getColumnValue("telephone1",dom));
					String std1="";
					std1= checkNull(genericUtility.getColumnValue("std1",dom));
						if(!tele1.equals("") && std1.equals(""))
						{
							errString =  itmDBAccess.getErrorString("std1","VTCUSTDNL1",userId);
							break;
						}
						else
						{
						if(!tele1.equals("") && tele1.length() > 0)
                        {
                            if(tele1.matches("\\d+"))
                            {
                                long num=Long.parseLong(tele1);
                                if(num <= 0)
                                {
                                	String errCode = "VTCUSTEINV";
                                    errString =  itmDBAccess.getErrorString("telephone1",errCode,userId);
                                    break ;
                                }
                            }
                            else
                            {
                            	String  errCode = "VTCUSTEINV";
                                errString =  itmDBAccess.getErrorString("telephone1",errCode,userId);
                                break ;
                            }
                        }
						}
					}
					else if (childNodeName.equalsIgnoreCase("telephone2"))
					{
						String tele2="";
						tele2= checkNull(genericUtility.getColumnValue("telephone2",dom));
						String std2="";
						std2= checkNull(genericUtility.getColumnValue("std2",dom));
							if(!tele2.equals("") && std2.equals(""))
							{
								errString =  itmDBAccess.getErrorString("std2","VTCUSTDNL2",userId);
								break;
							}
							else
							{
							if(!tele2.equals("") && tele2.length() > 0)
	                        {
                            if(tele2.matches("\\d+"))
                            {
                                long num=Long.parseLong(tele2);
                                if(num <= 0)
                                {
                                	String errCode = "VTCUSTEIN2";
                                    errString =  itmDBAccess.getErrorString("telephone2",errCode,userId);
                                    break ;
                                }
                            }
                            else
                            {
                            	String  errCode = "VTCUSTEIN2";
                                errString =  itmDBAccess.getErrorString("telephone2",errCode,userId);
                                break ;
                            }
	                        }
							}
					}
					else if (childNodeName.equalsIgnoreCase("telephone3"))
					{
						String tele3="";
						tele3= checkNull(genericUtility.getColumnValue("telephone3",dom));
						String std3="";
						std3= checkNull(genericUtility.getColumnValue("std3",dom));
							if(!tele3.equals("") && std3.equals(""))
							{
								errString =  itmDBAccess.getErrorString("std3","VTCUSTDNL3",userId);
								break;
							}
							else
							{
							if(!tele3.equals("") && tele3.length() > 0)
	                        {
                            if(tele3.matches("\\d+"))
                            {
                                long num=Long.parseLong(tele3);
                                if(num <= 0)
                                {
                                	String errCode = "VTCUSTEIN3";
                                    errString =  itmDBAccess.getErrorString("telephone3",errCode,userId);
                                    break ;
                                }
                            }
                            else
                            {
                            	String  errCode = "VTCUSTEIN3";
                                errString =  itmDBAccess.getErrorString("telephone3",errCode,userId);
                                break ;
                            }
	                        }
							}
					}
					else if (childNodeName.equalsIgnoreCase("std1"))
					{
						String std1 = checkNull(genericUtility.getColumnValue("std1", dom));
						String tele1="";
						tele1= checkNull(genericUtility.getColumnValue("telephone1",dom));
						if(!std1.equals("") && tele1.equals(""))
						{
							errString =  itmDBAccess.getErrorString("telephone1","VTCUTELNL1",userId);
							break;
						}
						else
						{
						if(!std1.equals("") && std1.length() > 0)
                        {
                            if(std1.matches("\\d+"))
                            {
                                long num=Long.parseLong(std1);
                                if(num <= 0)
                                {
                                	String errCode = "VTCUSSTDV";
                                    errString =  itmDBAccess.getErrorString("std1",errCode,userId);
                                    break ;
                                }
                            }
                            else
                            {
                            	String  errCode = "VTCUSSTDV";
                                errString =  itmDBAccess.getErrorString("std1",errCode,userId);
                                break ;
                            }
                        }
						}
					}
					else if (childNodeName.equalsIgnoreCase("std2"))
					{
						String std2 = checkNull(genericUtility.getColumnValue("std2", dom));
						String tele2="";
						tele2= checkNull(genericUtility.getColumnValue("telephone2",dom));
						if(!std2.equals("") && tele2.equals(""))
						{
							errString =  itmDBAccess.getErrorString("telephone2","VTCUTELNL2",userId);
							break;
						}
						else
						{
						if(!std2.equals("") && std2.length() > 0)
                        {
                            if(std2.matches("\\d+"))
                            {
                                long num=Long.parseLong(std2);
                                if(num <= 0)
                                {
                                	String errCode = "VTCUSTSTD1";
                                    errString =  itmDBAccess.getErrorString("std2",errCode,userId);
                                    break ;
                                }
                            }
                            else
                            {
                            	String  errCode = "VTCUSTSTD2";
                                errString =  itmDBAccess.getErrorString("std2",errCode,userId);
                                break ;
                            }
                        }
						}
					}
					else if (childNodeName.equalsIgnoreCase("std3"))
					{
						String std3 = checkNull(genericUtility.getColumnValue("std3", dom));
						String tele3="";
						tele3= checkNull(genericUtility.getColumnValue("telephone3",dom));
						if(!std3.equals("") && tele3.equals(""))
						{
							errString =  itmDBAccess.getErrorString("telephone3","VTCUTELNL3",userId);
							break;
						}
						else
						{
						if(!std3.equals("") && std3.length() > 0)
                        {
                            if(std3.matches("\\d+"))
                            {
                                long num=Long.parseLong(std3);
                                if(num <= 0)
                                {
                                	String errCode = "VTCUSTSTD3";
                                    errString =  itmDBAccess.getErrorString("std3",errCode,userId);
                                    break ;
                                }
                            }
                            else
                            {
                            	String  errCode = "VTCUSTSTD3";
                                errString =  itmDBAccess.getErrorString("std3",errCode,userId);
                                break ;
                            }
                        }
						}
					}

					else if ("sex".equalsIgnoreCase(childNodeName))
					{
						String sex = genericUtility.getColumnValue("sex",dom);
						if(childNode.getFirstChild() == null)
						{

							errString =  itmDBAccess.getErrorString("sex","NULSEXSEL",userId);
							break;
						}
						else if(!("M".equals(sex) || "F".equals(sex)) )
						{
							errString = itmDBAccess.getErrorString( "sex", "INVALIDSEX", userId );
							break;
						}

					}

					else if(childNodeName.equalsIgnoreCase("item_ser"))
					{
						if(childNode.getFirstChild() == null)
						{
							errString = itmDBAccess.getErrorString( "item_ser", "NULITMSER", userId );
						}
						else
						{
								String item_ser="";
								item_ser= checkNull(genericUtility.getColumnValue("item_ser",dom));
								if(item_ser.length()==0)
								{
									String errCode = "NULITMSER";
									errString =  itmDBAccess.getErrorString("item_ser",errCode,userId);
									break ;

								}
								else
								{
									String	sql = "SELECT * FROM ITEMSER WHERE ITEM_SER = ?";
									columnValue = childNode.getFirstChild().getNodeValue().trim();
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rs = pstmt.executeQuery();
									if ( !rs.next() )
									{
										errString = itmDBAccess.getErrorString( "item_ser", "ITMNOTEXT", userId );
									}
									rs.close();
									rs = null;
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
								}
						}
					}
					else if(childNodeName.equalsIgnoreCase("confirmed"))
					{

						columnValue = checkNull(childNode.getFirstChild().getNodeValue());
						String remarks_aprv1= checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
						String remark_aprv= checkNull(genericUtility.getColumnValue("remark_aprv",dom));
						String exist_sc_code= checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
						if(!columnValue.equals(""))
						{
						if(columnValue.equalsIgnoreCase("R"))
						{
							//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[start]
							/*if(remarks_aprv1.equals("I"))
							{
								if((remark_aprv.trim()).length() == 0)
								{
									errString = itmDBAccess.getErrorString( "remark_aprv", "VTCSURMKNL", userId );
									break;
								}
							}
							else if(remarks_aprv1.equals("D"))
							{
								if(exist_sc_code.equals(""))
								{
									errString = itmDBAccess.getErrorString( "exist_sc_code", "VTCSUESCNL", userId );
									break;
								}
							}*/

						   if(remarks_aprv1.equals("D"))
							{
								if(exist_sc_code.equals(""))
								{
									errString = itmDBAccess.getErrorString( "exist_sc_code", "VTCSUESCNL", userId );
									break;
								}
								if((remark_aprv.trim()).length() == 0)
								{
									errString = itmDBAccess.getErrorString( "remark_aprv", "DUPDCTRRMK", userId );
									break;
								}
							}
						   else if(remarks_aprv1.equals("S"))
						   {
							   if((remark_aprv.trim()).length() == 0)
								{
									errString = itmDBAccess.getErrorString( "remark_aprv", "INCDCTRRMK", userId );
									break;
								}

						   }

						   else if(remarks_aprv1.equals("Q"))
						   {
							   if((remark_aprv.trim()).length() == 0)
								{
									errString = itmDBAccess.getErrorString( "remark_aprv", "INAQUALRMK", userId );
									break;
								}

						   }

						   else if(remarks_aprv1.equals("E"))
						   {
							   if((remark_aprv.trim()).length() == 0)
								{
									errString = itmDBAccess.getErrorString( "remark_aprv", "INCADDRRMK", userId );
									break;
								}

						   }
						   else if(remarks_aprv1.equals("P"))
						   {
							   if((remark_aprv.trim()).length() == 0)
								{
									errString = itmDBAccess.getErrorString( "remark_aprv", "DFRNTIDRMK", userId );
									break;
								}

						   }
							//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[end]
						}
						}
						else
						{
							errString = itmDBAccess.getErrorString( "confirmed", "VTCSUESLAP", userId );
							break;
						}

					}
					else if(childNodeName.equalsIgnoreCase("confirmed_by_mkt"))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						String remarks_aprv2= checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));
						String remark_mkt= checkNull(genericUtility.getColumnValue("remarks_by_mkt",dom));
						String exist_sc_codes= checkNull(genericUtility.getColumnValue("exist_sc_code",dom));

						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[start]
						/*if(remarks_aprv2.equals("I"))
						{
							if((remark_mkt.trim()).length()==0)
							{
								errString = itmDBAccess.getErrorString( "remarks_by_mkt", "VTCSURMKNL", userId );
								break;
							}
						}
						else if(remarks_aprv2.equals("D"))
						{
							if(exist_sc_codes.equals(""))
							{
								errString = itmDBAccess.getErrorString( "exist_sc_code", "VTCSUESCNL", userId );
								break;
							}
						}*/
						if(columnValue.equalsIgnoreCase("R"))
						{
						if(remarks_aprv2.equals("D"))
						{
							if(exist_sc_codes.equals(""))
							{
								errString = itmDBAccess.getErrorString( "exist_sc_code", "VTCSUESCNL", userId );
								break;
							}
							if((remark_mkt.trim()).length() == 0)
							{
								errString = itmDBAccess.getErrorString( "remarks_by_mkt", "DUPDCTRRMK", userId );
								break;
							}

						}
						else if(remarks_aprv2.equals("S"))
						{
							if((remark_mkt.trim()).length()==0)
							{
								errString = itmDBAccess.getErrorString( "remarks_by_mkt", "INCDCTRRMK", userId );
								break;
							}
						}
						else if(remarks_aprv2.equals("Q"))
						{
							if((remark_mkt.trim()).length()==0)
							{
								errString = itmDBAccess.getErrorString( "remarks_by_mkt", "INAQUALRMK", userId );
								break;
							}
						}
						if(remarks_aprv2.equals("E"))
						{
							if((remark_mkt.trim()).length()==0)
							{
								errString = itmDBAccess.getErrorString( "remarks_by_mkt", "INCADDRRMK", userId );
								break;
							}
						}
						if(remarks_aprv2.equals("P"))
						{
							if((remark_mkt.trim()).length()==0)
							{
								errString = itmDBAccess.getErrorString( "remarks_by_mkt", "DFRNTIDRMK", userId );
								break;
							}
						}

						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[end]
					}
				}

					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if(childNode.getFirstChild()== null)
						{
							errString = itmDBAccess.getErrorString( "sales_pers", "NULSLSPER", userId );
						}
						else
						{
									String sales_pers="";
									sales_pers= checkNull(genericUtility.getColumnValue("sales_pers",dom));
									if(sales_pers.length()==0)
									{
										String errCode = "NULSLSPER";
										errString =  itmDBAccess.getErrorString("sales_pers",errCode,userId);
										break ;

									}
									else
									{
											String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode").trim();
											String	validateSalesPersSql = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ? AND SALES_PERS IN ( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO )";
											columnValue = childNode.getFirstChild().getNodeValue().trim();
											pstmt = connectionObject.prepareStatement(validateSalesPersSql);
											pstmt.setString(1, columnValue);
											pstmt.setString(2, columnValue);

											rs = pstmt.executeQuery();
											if ( !rs.next() )
											{
												errString = itmDBAccess.getErrorString( "sales_pers", "SLPNOTVAL", userId );
											}
											rs.close();
											rs = null;
											if(pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
									}
						}
					}
					else if(childNodeName.equalsIgnoreCase("speciality_descr"))
					{
						String splCode = checkNull(genericUtility.getColumnValue("spl_code",dom));
						int count = 0;
						if(childNode.getFirstChild() == null)
						{
							errString = itmDBAccess.getErrorString( "speciality_descr", "NULLSPLCOD", userId );
						}
						else
						{
							String	sql = "SELECT count(*)Cnt  FROM SPECIALITY WHERE SPL_CODE = ? AND ACTIVE_YN='Y' ";
							columnValue = childNode.getFirstChild().getNodeValue().trim();

							String itemSer = checkNull(genericUtility.getColumnValue("item_ser",dom));
							System.out.println("................value of itemSer is::........."+itemSer);
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, splCode);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								cntSP  = rs.getInt("Cnt");
							}
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							System.out.println("................value of cntSP is::........."+cntSP);
							if(cntSP == 0)
							{
								errString =  itmDBAccess.getErrorString("spl_code","SPLNOTEXT",userId);
								break ;
							}
							else if(cntSP > 0)
							{
								sql = " SELECT COUNT(*) AS COUNT FROM SPECIALITY_SERIES S, SPECIALITY SP " +
								" where  s.spl_code=sP.spl_code AND sp.active_yn = s.active_yn AND s.SPL_CODE = ?  and s.item_ser = ? AND SP.ACTIVE_YN='Y' ";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, splCode);
								pstmt.setString(2, itemSer);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("................value of count is::........."+count);

								if(count == 0)
								{
									errString =  itmDBAccess.getErrorString("item_ser","VMVLDSPTY1",userId);
									break ;
								}
							}

						}
					}
					//else if(childNodeName.equalsIgnoreCase("strg_ser_class_descr"))
					else if(childNodeName.equalsIgnoreCase("class_descr"))
					{
						System.out.println("INSIDE CLASS_DESCR FIELD OF VALIDATION");
						String classCode = checkNull(genericUtility.getColumnValue("class_code",dom));
						String classDescr = checkNull(genericUtility.getColumnValue("class_descr",dom));
						System.out.println("INSIDE CLASS_DESCR FIELD OF VALIDATION["+classDescr+"]");

						if( classDescr.equals(""))
						{
							System.out.println("INSIDE CLASS_DESCR FIELD OF VALIDATION IF NULL");
							errString = itmDBAccess.getErrorString( "class_code", "NULCLSCODE", userId );
						}
						else
						{
							int count = 0;
							System.out.println("INSIDE CLASS_DESCR FIELD OF VALIDATION IF NOT NULL");
							String	sql = "SELECT count(*)Cnt  FROM STRG_CLASS WHERE class_code = ? and ACTIVE_YN='Y' ";
							String itemSer = checkNull(genericUtility.getColumnValue("item_ser",dom));
							System.out.println("................value of itemSer is::........."+itemSer);
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, classCode);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								cntCS  = rs.getInt("Cnt");
							}
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							System.out.println("................value of cntSP is::........."+cntSP);
							if(cntCS == 0)
							{
								errString =  itmDBAccess.getErrorString("spl_code","CLSNOTEXT",userId);
								break ;
							}
							else if(cntCS > 0)
							{
								sql = " SELECT COUNT(*) AS COUNT FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
								" where  c.class_code= cs.class_code and c.class_code = ? AND CS.ITEM_SER = ? AND CS.ACTIVE='Y'  ";// changes by Hariom for Active class show for division wise :: 29-04-2020
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, classCode);
								pstmt.setString(2, itemSer);
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("................value of count is::........."+count);

								if(count == 0)
								{
									errString =  itmDBAccess.getErrorString("item_ser","INVCLSCODE",userId);
									break ;
								}
							}
						}

					}



					//Added by ShravanKumar on [06/10/2015].start
					else if(childNodeName.equalsIgnoreCase("no_visit"))
					{

						String noVisit = checkNull(genericUtility.getColumnValue("no_visit",dom));
						String itemSer = checkNull(genericUtility.getColumnValue("item_ser",dom));
						String classCode = checkNull(genericUtility.getColumnValue("class_code",dom));
						String salesPers= checkNull(genericUtility.getColumnValue("sales_pers",dom));
						scCode = checkNull(genericUtility.getColumnValue("sc_code",dom));
						System.out.println("value of item ser is::"+itemSer);
						System.out.println("value of no visit::"+noVisit);
						SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
						java.util.Date date = Calendar.getInstance().getTime();
						String currDate = sdf.format( date );
						System.out.println(" updateWEndDate :: currDate :: ["+currDate+"]"+"date::>>"+date);

						if(noVisit == null || noVisit.trim().length()==0)
						{
							errString = itmDBAccess.getErrorString( "no_visit", "VTNULNOVIS", userId );
						}
						else if(Integer.parseInt(noVisit) <= 0)
						{
							errString = itmDBAccess.getErrorString( "no_visit", "VTNTVNOVIS", userId );
						}
						else
						{

							int maxVst=0;
							int minVst=0;

							String sql = " SELECT NVL(MAX_VISITS,0) MAX_VISITS,NVL(MIN_VISITS,0) MIN_VISITS "+
							" FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
							" where  c.class_code= cs.class_code and c.class_code = ? AND CS.ITEM_SER = ?   ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, classCode);
							pstmt.setString(2, itemSer);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								maxVst  = rs.getInt(1);
								minVst  = rs.getInt(2);
							}
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}

							System.out.println("value of maxVst is::........."+maxVst);
							System.out.println("value of minVst is::........."+minVst);
							System.out.println("value of noVisit is::........."+noVisit);

							if( Integer.parseInt(noVisit) > maxVst || Integer.parseInt(noVisit) < minVst )
							{
								errString = itmDBAccess.getErrorString( "no_visit", "VTEXCNOVIS", userId );
								break;
							}

							//ADDED BY SACHIN SATRE ON [30-NOV-17 ] FOR REQUEST ID :W17ISUN002  [START]
							//commented and wsfacommon class by mrunalini sinkar on 27-05-2019
							//SFACommon sfaCommon = new SFACommon();
							WSFACommon sfaCommon = new WSFACommon();
							HashMap<String,String> docVisitCntHM=  new HashMap<String, String>();

							docVisitCntHM = sfaCommon.getVisitData(salesPers, itemSer, connectionObject);

							String gradeLevelNo = "";
							ResultSet  rsGetData = null;
							PreparedStatement pstmtGetData = null;
							ResultSet  rsVisit = null;
							PreparedStatement pstmtVisit = null;
							ResultSet  rsCustomer = null;
							PreparedStatement pstmtCustomer = null;
							ResultSet  rsGetDetail = null;
							PreparedStatement pstmtGetDetail = null;
							String sql1 ="";
							int serCnt = 0;
							String empSite= "";
							String minStrgVisit ="";
							String maxStrgVisit ="";
							String minStrgCustomr ="";
							String maxStrgCustomr ="";
							String applVisit ="";
							boolean  isRecExists = false ;


							System.out.println("docVisitCntHM:fdg:>>:["+docVisitCntHM+"]");
							if(!docVisitCntHM.isEmpty())
							//if(isRecExists == true )
							{
								sql1=" SELECT SUM(NO_VISIT) AS NO_VISIT FROM STRG_SERIES WHERE SALES_PERS = ? AND ITEM_SER = ? AND STATUS = 'Y' " ;
								if(scCode != null && scCode.trim().length() > 0 )
								{
									sql1 = sql1 + "AND SC_CODE <> '"+scCode+"'";
								}

								pstmtVisit = connectionObject.prepareStatement(sql1);
								pstmtVisit.setString(1, salesPers );
								pstmtVisit.setString(2,itemSer);
								//pstmtVisit.setString(3,scCode);
								rsVisit = pstmtVisit.executeQuery();
								System.out.println("After calling  calculating all data is getting");
								int totVstExist = 0 ;
								if( rsVisit.next() )
								{
									totVstExist  = rsVisit.getInt(1);
								}
								if(rsVisit != null)
								{
									rsVisit.close();
									rsVisit = null;
								}
								if(pstmtVisit != null)
								{
									pstmtVisit.close();
									pstmtVisit = null;
								}
								sql1="SELECT COUNT(*) AS CUSTOMER_COUNT FROM STRG_SERIES WHERE SALES_PERS = ? AND ITEM_SER = ? AND STATUS = 'Y' ";
								if(scCode != null && scCode.trim().length() > 0 )
								{
									sql1 = sql1 + "AND SC_CODE <> '"+scCode+"'";
								}

								pstmtCustomer = connectionObject.prepareStatement(sql1);
								pstmtCustomer.setString(1, salesPers );
								pstmtCustomer.setString(2,itemSer);
								//pstmtCustomer.setString(3,scCode);
								rsCustomer = pstmtCustomer.executeQuery();
								System.out.println(" then sachin After calling  calculating all data is getting");
								int customerCnt = 0 ;
								if( rsCustomer.next() )
								{
									customerCnt  = rsCustomer.getInt(1);
								}
								if(rsCustomer != null)
								{
									rsCustomer.close();
									rsCustomer = null;
								}
								if(pstmtCustomer != null)
								{
									pstmtCustomer.close();
									pstmtCustomer = null;
								}
								int noVis = 0 ;
								if(noVisit != null && noVisit.trim().length() > 0)
								{
									noVis= Integer.parseInt(noVisit);
								}
								int totalVisit = totVstExist + noVis ;

								customerCnt = customerCnt + 1;
								int maxStrgVisitCnt = 0 ;
								int maxStrgCustomerCnt = 0 ;
								for(Map.Entry<String, String> m:docVisitCntHM.entrySet())
								{
									System.out.println("sdfsdf");
									maxStrgCustomr =(String)m.getKey();
									maxStrgVisit =(String)m.getValue();
									System.out.println("keysdfkeydkdj::key::"+maxStrgCustomr+"::valueMaxVisits:::"+maxStrgVisit);
								}
								if(maxStrgVisit != null && maxStrgVisit.trim().length() > 0)
								{
									maxStrgVisitCnt = Integer.parseInt(maxStrgVisit);
								}
								if(maxStrgCustomr != null && maxStrgCustomr.trim().length() > 0)
								{
									maxStrgCustomerCnt = Integer.parseInt(maxStrgCustomr);
								}
								System.out.println("value of customerCnt is::.........."+customerCnt);
								System.out.println("value of noVisit is::.............."+noVisit);
								System.out.println("value of  totVstExist is::........."+totVstExist);
								System.out.println("value of minStrgVisit is::........."+minStrgVisit);
								System.out.println("value of maxStrgVisit is::........."+maxStrgVisit);
								System.out.println("value of minStrgCustomr is::......."+minStrgCustomr);
								System.out.println("value of maxStrgCustomr is::......."+maxStrgCustomr);
								System.out.println("value of totalVisit is::..........."+totalVisit);
								System.out.println("value of customerCnt is::..........."+customerCnt);

								if( (customerCnt > maxStrgCustomerCnt)  )
								{
									System.out.println("total doctor is greater validation");
									errString = itmDBAccess.getErrorString( "no_visit", "DCVISTEXCD", userId );
									break;
								}
								else if( (totalVisit > maxStrgVisitCnt)  )
								{
									System.out.println("totalVisit is greater validation");
									errString = itmDBAccess.getErrorString( "no_visit", "NOVISTEXCD", userId );
									break;
								}

							}
							//System.out.println("value of totVst is::........."+totVst);

							//ADDED BY SACHIN SATRE ON [30-NOV-17 ] FOR REQUEST ID : W17ISUN002 [end]

						}

					}
					//Added by ShravanKumar on [06/10/2015].end
					/* Commented by shravankumar on [06/10/2015]. Start
					else if(childNodeName.equalsIgnoreCase("no_visit"))
					{

						String noVisit = checkNull(genericUtility.getColumnValue("no_visit",dom));
						String itemSer = checkNull(genericUtility.getColumnValue("item_ser",dom));
						System.out.println("value of item ser is::"+itemSer);
						System.out.println("value of no visit::"+noVisit);
						if(noVisit == null || noVisit.trim().length()==0)
						{
							errString = itmDBAccess.getErrorString( "no_visit", "VTNULNOVIS", userId );
						}
						else if(Integer.parseInt(noVisit) <= 0)
						{
							errString = itmDBAccess.getErrorString( "no_visit", "VTNTVNOVIS", userId );
						}
						else
						{
							Boolean itemSerFound = false;
							if (itemSer == null || itemSer.trim().length() == 0)
							{
								itemSer = "ALL";
							}
							String sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'DOCTOR_MAXVISIT_INMONTH' AND ITEM_SER = ?";
							int propValue = 0;
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, itemSer);
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								propValue = rs.getInt("PROP_VALUE");
								itemSerFound = true;
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if (!itemSerFound)
							{
								sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'DOCTOR_MAXVISIT_INMONTH' AND ITEM_SER = 'ALL'";
								pstmt =  connectionObject.prepareStatement( sql );
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									propValue = rs.getInt("PROP_VALUE");
								}

								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
							System.out.println("vale from properties ::"+propValue);
							if(Integer.parseInt(noVisit) > propValue)
							{
								errString = itmDBAccess.getErrorString( "no_visit", "VTEXCNOVIS", userId );
							}
						}
					}
							// Commented by shravankumar on [06/10/2015]. End*/

					else if(childNodeName.equalsIgnoreCase("total_business"))
					{
						totalBusiness = checkNull(genericUtility.getColumnValue("total_business",dom)) == ""?"0":genericUtility.getColumnValue("total_business",dom);
						System.out.println("totalBusiness value:"+totalBusiness);
						if(totalBusiness != null && totalBusiness.trim().length() != 0)
						{ //chnages by shraddha M 
							if(( totalBusiness.trim().length() > 7 ) ||( totalBusiness.trim().indexOf('.') != -1 ))
							{
								errString = itmDBAccess.getErrorString( "total_business", "INVTOTBSNS", userId );
								break;
							}
							else if(Double.parseDouble(totalBusiness) < 0)
							{
								errString = itmDBAccess.getErrorString( "total_business", "IVTOTLBSNS", userId );
							}
						}//Added by shraddha M to make field mandatory as per requirement [24-mar-2020] start(W19LSUN003)
						else
						{
							errString = itmDBAccess.getErrorString( "total_business", "NULTOTLBSN", userId );
						}
						//Added by shraddha M to make field mandatory as per requirement [24-mar-2020] end(W19LSUN003)
					}

					else if(childNodeName.equalsIgnoreCase("business_to_us"))
					{
						String businessToDiv = checkNull(genericUtility.getColumnValue("business_to_us",dom)) == ""?"0":genericUtility.getColumnValue("business_to_us",dom);
						if(businessToDiv != null && businessToDiv.trim().length() != 0)
						{ //changes by  shraddha M
						  if(( businessToDiv.trim().length() > 7 ) || ( businessToDiv.trim().indexOf('.') != -1 ))
						   {
							  errString = itmDBAccess.getErrorString( "business_to_us", "INVBSNSDIV", userId );
							  break;
						   }

						  else if(Double.parseDouble(businessToDiv) < 0)
						  {
							  errString = itmDBAccess.getErrorString( "business_to_us", "IVBSNSSDIV", userId );
						  }
						}
						//Added by shraddha M to make field mandatory as per requirement [24-mar-2020] start(W19LSUN003)
						else
						{
							errString = itmDBAccess.getErrorString( "business_to_us", "NULBSNSDIV", userId );
						}
						//Added by shraddha M to make field mandatory as per requirement [24-mar-2020] end(W19LSUN003)
					}

					/*else if(childNodeName.equalsIgnoreCase("route_id"))
					{
						String [] propValueArr = null;
						String propValues = "";
						Vector vector = new Vector();
						String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
						String routeID = checkNull(genericUtility.getColumnValVTCSADRNULue("route_id",dom));
						String routeTypeSql = "";
						String routeType = "";
						routeTypeSql = "SELECT ROUTE_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
						pstmt = connectionObject.prepareStatement(routeTypeSql);
						pstmt.setString(1, salesPers);
						pstmt.setString(2, routeID);
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							routeType = checkNull(rs.getString("ROUTE_TYPE"));
						}
						if(!("X".equalsIgnoreCase(routeType) || "O".equalsIgnoreCase(routeType) || "H".equalsIgnoreCase(routeType) ))
						{
							errString = itmDBAccess.getErrorString( "route_id", "IVROUTTYPE", userId );
							break;
						}
						pstmt.clearParameters();
						if ( rs != null )
						{
							rs.close();
							rs = null;
						}
						if ( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
						propValues = getAllowedRouteType( salesPers, connectionObject );
						if (propValues.trim().length() > 0)
						{
							if(propValues.indexOf(',') > 0)
							{
								propValueArr = propValues.split(",");
							}
							else
							{
								propValueArr = new String[1];
								propValueArr[0] = propValues;
							}
							for(int k=0 ; k<propValueArr.length ; k++)
							{
								vector.add(propValueArr[k]);
							}
							if (vector.contains(routeType))
							{
								errString = itmDBAccess.getErrorString( "route_id", "VPDTROUTE3", userId );
								break;
							}
						}
					}*/
					else if(childNodeName.equalsIgnoreCase("route_type"))
					{
						int cout = 0;
						String route_type= checkNull(genericUtility.getColumnValue("route_type",dom));
						String sales_pers="";
						sales_pers= checkNull(genericUtility.getColumnValue("sales_pers",dom));
						String	locCode= checkNull(genericUtility.getColumnValue("locality_code",dom));
						String routeId= checkNull(genericUtility.getColumnValue("route_id",dom));
						String sqls="select count(route_id) as cntRoute from sprs_route where route_id=? and sprs_code=? and locality_code=?";
						pstmt = connectionObject.prepareStatement(sqls);
						pstmt.setString(1, routeId);
						pstmt.setString(2, sales_pers);
						pstmt.setString(3, locCode);
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							cout = rs.getInt("cntRoute");
						}
						if(cout==0)
						{
							int count1=0;
							String sql2="select count(route_id) as cntRoute from customer_series_upload where route_id=? and sales_pers=? and locality_code=?";
							pstmt1 = connectionObject.prepareStatement(sqls);
							pstmt1.setString(1, routeId);
							pstmt1.setString(2, sales_pers);
							pstmt1.setString(3, locCode);
							rs1 = pstmt1.executeQuery();
							if ( rs1.next() )
							{
								count1 = rs1.getInt("cntRoute");
							}
							//route_type= checkNull(genericUtility.getColumnValue("route_type",dom));
							if(count1==0)
							{
								Pattern p = Pattern.compile("[^A-Za-z0-9]");
								Matcher m = p.matcher(route_type);
								boolean b = m.find();
								if(childNode.getFirstChild() == null)
								{
									errString = itmDBAccess.getErrorString( "route_type", "VTCUSRTID", userId );
								}
								else if(childNode.getFirstChild() != null)
								{
									//String routeSh=getStanType(locCode, route_type, connectionObject);
									String routeSh=getStanType(sales_pers ,locCode, route_type, connectionObject);
									System.out.println("routeSh::::["+routeSh+"]");
									if(routeSh.equals(""))
									{
										errString = itmDBAccess.getErrorString( "route_type", "VTCUSLOCSB", userId );
									}
									//added by bhagyashri T For adding station_type validatio start[W20JSUN015]
									/*else
									{
										if(routeSh !=null && routeSh.trim().length()>0)
										{
											System.out.println("routeSh In else::::["+routeSh+"]");
											ArrayList<String> getstationType= new ArrayList<String>();
											getstationType = getstationType();
											System.out.println("::Station type for test staion type:::["+getstationType+"]");
											if(getstationType != null && getstationType.size() > 0)
											{
												if(!getstationType.contains(routeSh) )
												{
													errString = getErrorString( "station_type", "INVSTANTY", userId );
													break;
												}
										    }
										}
									}*/
									//added by bhagyashri to add station_type validation end[W20JSUN015]
								}
								else if(b==true)
								{
									String errCode = "VTCUSRTSP";
									errString =  itmDBAccess.getErrorString("route_type",errCode,userId);
									break ;
								}
							}
							rs1.close();
							rs1 = null;
							if( pstmt1 != null)
							{
								pstmt1.close();
								pstmt1 = null;
							}
						}
						rs.close();
						rs = null;
						if( pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						//added by sachin satre on [11-jul-17] for validating the locality type is if M or T then validate it[start]
						sprsRoutTypeList.add("M");
						sprsRoutTypeList.add("T");
						System.out.println("sprsRoutTypeList:::>>>::["+sprsRoutTypeList+"]::["+route_type+"]");
						if(sprsRoutTypeList.contains(route_type))
						{
							System.out.println("invalid route type .route type should be (H,O,X) route type");
							errString =  itmDBAccess.getErrorString("locality_code","IVROUTTYPE",userId);
						}
					   //added by sachin satre on [11-jul-17] for validating the locality type is if M or T then validate it[end]
					}
					else if(childNodeName.equalsIgnoreCase("no_patient_day"))
					{
						//chnages by shraddha to make field mandatory as per requirement [24-mar-2020] start(W19LSUN003)
						String noPatientDay = checkNull(genericUtility.getColumnValue("no_patient_day",dom)) == ""?"0":genericUtility.getColumnValue("no_patient_day",dom);
						if(noPatientDay != null)
						{
						
							if(( noPatientDay.trim().length() > 3 ) || ( noPatientDay.trim().indexOf('.') != -1 ))
							{
								errString = itmDBAccess.getErrorString( "no_patient_day", "INVPATNO", userId );
								break;
							}
							else if(Double.parseDouble(noPatientDay) < 0)
							{
								errString = itmDBAccess.getErrorString( "no_patient_day", "IVNOPSNTDY", userId );
							}
						}
						else
						{
							errString = itmDBAccess.getErrorString( "no_patient_day", "NULPSNTPDY", userId );
						}
						//chnages by shraddha to make field mandatory as per requirement [24-mar-2020] end(W19LSUN003)
					}
					else if(childNodeName.equalsIgnoreCase("birth_date"))
					{
						int cout = 0;
						String birthDate = checkNull(genericUtility.getColumnValue("birth_date",dom));
						if(birthDate.trim() != "" && birthDate.trim() != null)
						{
							java.sql.Date birthDateConvert = new java.sql.Date(dob.parse(birthDate).getTime());
							String sql = "SELECT count(*) as cont FROM dual WHERE SYSDATE > ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setDate(1, birthDateConvert);
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								cout = rs.getInt("cont");
							}
							if ( cout == 0 )
							{
								errString = itmDBAccess.getErrorString( "birth_date", "INVBRTHDAY", userId );
								break;
							}
							rs.close();
							rs = null;
							if( pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						
						// min age validation same as StrgCutomer added by shweta 22-02-21 started
						    int minAge = 0;
							String ageSql = "SELECT MIN_AGE FROM STRG_CUST_TYPE WHERE TYPE ='D'";
							pstmt = connectionObject.prepareStatement(ageSql);
							//pstmt.setString(1,custType);
							rs= pstmt.executeQuery();
							if(rs.next())
							{
								minAge = rs.getInt("MIN_AGE");
							}
							System.out.println("minAge :"+minAge);
							rs.close();rs=null;
							pstmt.close();pstmt=null;

							if(minAge != 0 )
							{
								Calendar dobDate = Calendar.getInstance();
								DateFormat sdfCal = new SimpleDateFormat(getApplDateFormat());
								Date wrkDt =sdfCal.parse(birthDate);
								dobDate.setTime(wrkDt);
								//System.out.println("dobDate :["+dobDate+"]");

								Calendar today = Calendar.getInstance();
								//System.out.println("today :["+today+"]");

								int curYear = today.get(Calendar.YEAR);
								System.out.println("today curYear :["+curYear+"]");
								int curMonth = today.get(Calendar.MONTH);
								int curDay = today.get(Calendar.DAY_OF_MONTH);

								int year1 = dobDate.get(Calendar.YEAR);
								System.out.println("dobDate year1 :["+year1+"]");
								int month1 = dobDate.get(Calendar.MONTH);
								int day1 = dobDate.get(Calendar.DAY_OF_MONTH);

								int age = curYear - year1;
								System.out.println("age ::["+age+"]");
								if (curMonth < month1 || (month1 == curMonth && curDay < day1))
								{
									age--;
								}
								System.out.println("age :::["+age+"]");

								//if(age > minAge )
								if(age < minAge )
								{
									System.out.println("age limit cross....");
									errString = itmDBAccess.getErrorString("birth_date","INVDRCBRDT",userId);
									break;
								}
								else
								{
									System.out.println("age limit  Not cross....");
								}
							}

							// min age validation same as StrgCutomer added by shweta 22-02-21 end
						}
					}
					else if ("status".equalsIgnoreCase(childNodeName))
					{
						String status = genericUtility.getColumnValue("status",dom);
						String sc_codes = genericUtility.getColumnValue("sc_code",dom);
						if(childNode.getFirstChild() == null)
						{
							errString =  itmDBAccess.getErrorString("status","VTCUSTNLST",userId);
						}
					}
					else if(childNodeName.equalsIgnoreCase("category"))
					{
						//changes by shraddha M to make field mandatory as per requirement [24-mar-2020]start(W19LSUN003)
						if(childNode.getFirstChild() != null)
						{
							int count = 0;
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							String sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE FLD_VALUE = ? "+
							"AND UPPER(MOD_NAME) = 'W_WSFA_STRG_SERIES' AND UPPER(FLD_NAME) = 'CATEGORY' ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							if ( count == 0 )
							{
								errString = itmDBAccess.getErrorString( "category", "INVCATGORY", userId );
								break;
							}
							rs.close();
							rs = null;
							if( pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						else
						{
							errString = itmDBAccess.getErrorString( "category", "INVDCATGRY", userId );
							break;
						}
						//changes by shraddha M to make field mandatory as per requirement [24-mar-2020]end(W19LSUN003)
					}
					// Added by vishakha [16/02/2016] To validate Pan card no [Start]
					else if ("pan_no".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() != null)
						{
							int count = 0;
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							String sql = " SELECT COUNT(*) Cnt FROM "+
								 		 " (SELECT ? AS PN FROM DUAL "+
								 		 " ) A "+
								 		 " WHERE (( LENGTH(A.PN) = 10 "+
								 		 " AND SUBSTR(A.PN,1,1) BETWEEN 'A' AND 'Z' "+
								 		 " AND SUBSTR(A.PN,2,1) BETWEEN 'A' AND 'Z' "+
								 		 " AND SUBSTR(A.PN,3,1) BETWEEN 'A' AND 'Z' "+
								 		 " AND SUBSTR(A.PN,4,1) IN ('P','F','C','T','N','H') "+
								 		 " AND SUBSTR(A.PN,5,1) BETWEEN 'A' AND 'Z' "+
								 		 " AND SUBSTR(A.PN,6,1) BETWEEN '0' AND '9' "+
								 		 " AND SUBSTR(A.PN,7,1) BETWEEN '0' AND '9' "+
								 		 " AND SUBSTR(A.PN,8,1) BETWEEN '0' AND '9' "+
								 		 " AND SUBSTR(A.PN,9,1) BETWEEN '0' AND '9' "+
								 		 " AND SUBSTR(A.PN,10,1) BETWEEN 'A' AND 'Z' ) "+
								 		 " OR A.PN = 'PANAPPLIED' "+
								 		 " OR A.PN = 'PANNOTAVBL') ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								count = rs.getInt("Cnt");
							}
							if ( count == 0 )
							{
								errString = itmDBAccess.getErrorString( "pan_no", "UV_PANNO", userId );
								break;
							}
							rs.close();
							rs = null;
							if( pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					// Added by vishakha [16/02/2016] To validate Pan card no [End]
					//added by shraddha M as per requirement [18-mar-2020] start(W19LSUN003)
					else if(childNodeName.equalsIgnoreCase("rx_mode"))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccess.getErrorString( "rx_mode", "INVRXMODE", userId );
						}
					}
					
					else if(childNodeName.equalsIgnoreCase("age_bracket"))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString = getErrorString( "age_bracket", "INVAGEBRKT", userId );
						}
					}
					//added by shraddha M as per requirement [18-mar-2020] end
					
					// Added by Sainath T [03/11/2019] To validate minimum attchments [Start]
					else if ("attach_ids".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getFirstChild() != null)
						{
							int count = 0;
							int minAttchCnt = 0;
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							if(columnValue.indexOf("-") == -1)
							{
								String sql = "SELECT COUNT(*) AS COUNT FROM DOC_TRANSACTION_LINK WHERE REF_ID = ? " +
								"AND TRIM(REF_SER) IN (SELECT TRIM(REF_SER) FROM TRANSETUP WHERE TRAN_WINDOW = 'w_"+objName+"') AND DELETE_FLAG IS NULL";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}

								if ( count == 0 )
								{
									errString = itmDBAccess.getErrorString( "attach_ids", "NULLATTACH", userId );
									break;
								}
								rs.close();
								rs = null;

								if( pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								String minCntSql = "select ATTACH_COUNT_MIN from TRANSETUP where TRAN_WINDOW = ? ";

								pstmt1 = connectionObject.prepareStatement(minCntSql);
								pstmt1.setString(1, "w_"+objName);
								rs1 = pstmt1.executeQuery();
								if ( rs1.next() )
								{
									minAttchCnt = rs1.getInt("ATTACH_COUNT_MIN");
								}
								if ( count < minAttchCnt )
								{
									errString = itmDBAccess.getErrorString( "attach_ids", "MINATREQ", userId );
									break;
								}


								rs1.close();
								rs1 = null;
								if( pstmt1 != null)
								{
									pstmt1.close();
									pstmt1 = null;
								}
							}
						}
						

						String DICTIONARY_VALUES = "";
						boolean isErr = false ;
						int count1=0;
						String fromDataScCode="";
						String fromDataName="";
						String fromDataLocality="";
						String fromDataPin="";
						String fromDataMobile="";
						String fromDataAddr="";
						String fromDataAddr2="";
						String fromDataAddr3="";
						String fromDataEmail="";
						boolean validate = false;
						
					
						//Added by hariom s for duplicate doctor check on --16-Feb-2021 [Start]
						
							String firstName = checkNull(genericUtility.getColumnValue("first_name",dom));
							String lastName = checkNull(genericUtility.getColumnValue("last_name",dom));
							String localityCode = checkNull(genericUtility.getColumnValue("locality_code",dom));
							String mobileNo = checkNull(genericUtility.getColumnValue("mobile_no",dom));
							String localityDescr =checkNull( genericUtility.getColumnValue("locality_descr",dom));	
							
							String fName=firstName.trim().substring(0,1);
							String lName=lastName.trim().substring(0,1);
							String doctorName= firstName+""+lastName;
							
							//Added & Commented by Bhagyashri T forchange msg descr as per client Requirement[01/06/21][Start][W21CSUN029]
							//StringBuffer strBuff2 = new StringBuffer("<p> Doctors with similar name already exist in database which are displayed on screen, before Save/Submit transaction have a look on doctors details to avoid duplication.  \n\n</p>");
							StringBuffer strBuff2 = new StringBuffer("<p> Doctors with same Mobile number already exist in database which are displayed on screen, either update correct mobile number or click on Ok and add this doctor through Doctor /POW/STP Updation module.  \n\n</p>");
							//Added & Commented by Bhagyashri T forchange msg descr as per client Requirement[01/06/21][End][W21CSUN029]
							strBuff2.append("<table style=\" border-collapse:collapse;\" border='1' class = 'alertContentTable' ><tr class = 'alertContentTr'><td class = 'alertContentTd'>Dr. Name   </td><td class = 'alertContentTd'>Sc Code   </td><td class = 'alertContentTd'>Locality   </td><td class = 'alertContentTd'>Pin   </td><td class = 'alertContentTd'>Mobile No.   </td><td class = 'alertContentTd'>Email   </td><td class = 'alertContentTd'>Address   </td></tr>");
							
							
							
							StringBuffer strBuff = new StringBuffer("<p> Cancel : To cancel transaction click on Cancel. \n\n<br> Ok : To save transaction click on Ok. \n\n<br></br>  Doctors with similar name already exist in database which are displayed on screen, before Save/Submit transaction have a look on doctors details to avoid duplication.  \n\n</p>");
							strBuff.append("<table style=\" border-collapse:collapse;\" border='1' class = 'alertContentTable' ><tr class = 'alertContentTr'><td class = 'alertContentTd'>Dr. Name   </td><td class = 'alertContentTd'>Sc Code   </td><td class = 'alertContentTd'>Locality   </td><td class = 'alertContentTd'>Pin   </td><td class = 'alertContentTd'>Mobile No.   </td><td class = 'alertContentTd'>Email   </td><td class = 'alertContentTd'>Address   </td></tr>");
							
							String sql="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
									+ " FROM STRG_CUSTOMER WHERE MOBILE_NO= ? ";

							pstmt = connectionObject.prepareStatement(sql);
							//System.out.println("sql ===="+sql);
							pstmt.setString(1, mobileNo.trim());


							rs = pstmt.executeQuery();					
							while( rs.next() )
							{
								System.out.println("Inside While Mobile");
								fromDataScCode=checkNull(rs.getString("SC_CODE"));
								fromDataName=checkNull(rs.getString("dr_name"));
								fromDataLocality=checkNull(rs.getString("locality_code"));
								fromDataMobile=checkNull(rs.getString("mobile_no"));
								fromDataPin=checkNull(rs.getString("pin"));
								fromDataEmail=checkNull(rs.getString("email_addr"));
								fromDataAddr=checkNull(rs.getString("addr1"));
								fromDataAddr2=checkNull(rs.getString("addr2"));
								fromDataAddr3=checkNull(rs.getString("addr3"));
								count1++;	
								if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
								{
									fromDataAddr=fromDataAddr+", "+fromDataAddr2;
									if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
									{
										fromDataAddr=fromDataAddr+", "+fromDataAddr3;
									}
								}
								System.out.println("Inside strBuff2 Mobile is count:"+count1);
								strBuff2.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
								validate = true;															
							}
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(count1 >0)
							{
								System.out.println("above validate Mobile");								
								if(validate)
								{
									System.out.println("Inside validate Mobile");
									errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPSNT\" type=\"E\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff2.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
								}
							}
							else
							{
								count1=0;
								String sql2="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
										+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME)= UPPER(?) AND UPPER(LAST_NAME)= UPPER(?) AND CUST_TYPE='D' ";

								pstmt = connectionObject.prepareStatement(sql2);
								//System.out.println("sql2 ===="+sql2);
								pstmt.setString(1, localityCode.trim());
								pstmt.setString(2, firstName.trim());
								pstmt.setString(3, lastName.trim());

								rs = pstmt.executeQuery();					
								while( rs.next() )
								{
									fromDataScCode=checkNull(rs.getString("SC_CODE"));
									fromDataName=checkNull(rs.getString("dr_name"));
									fromDataLocality=checkNull(rs.getString("locality_code"));
									fromDataMobile=checkNull(rs.getString("mobile_no"));
									fromDataPin=checkNull(rs.getString("pin"));
									fromDataEmail=checkNull(rs.getString("email_addr"));
									fromDataAddr=checkNull(rs.getString("addr1"));
									fromDataAddr2=checkNull(rs.getString("addr2"));
									fromDataAddr3=checkNull(rs.getString("addr3"));
									count1++;	
									if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
									{
										fromDataAddr=fromDataAddr+", "+fromDataAddr2;
										if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
										{
											fromDataAddr=fromDataAddr+", "+fromDataAddr3;
										}
									}
									
									strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
									validate = true;
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count1 > 0)
								{
									if(validate)
									{
										errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
									}
									
								}
								else
								{
									count1=0;
									String sql3="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
											+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME)= UPPER(?) AND UPPER(LAST_NAME)= UPPER(?) AND CUST_TYPE='D' ";

									pstmt = connectionObject.prepareStatement(sql3);
									//System.out.println("sql3 ===="+sql3);
									pstmt.setString(1, localityCode.trim());
									pstmt.setString(2, lastName.trim());
									pstmt.setString(3, firstName.trim());

									rs = pstmt.executeQuery();					
									while( rs.next() )
									{
										fromDataScCode=checkNull(rs.getString("SC_CODE"));
										fromDataName=checkNull(rs.getString("dr_name"));
										fromDataLocality=checkNull(rs.getString("locality_code"));
										fromDataMobile=checkNull(rs.getString("mobile_no"));
										fromDataPin=checkNull(rs.getString("pin"));
										fromDataEmail=checkNull(rs.getString("email_addr"));
										fromDataAddr=checkNull(rs.getString("addr1"));
										fromDataAddr2=checkNull(rs.getString("addr2"));
										fromDataAddr3=checkNull(rs.getString("addr3"));
										count1++;	
										if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
										{
											fromDataAddr=fromDataAddr+", "+fromDataAddr2;
											if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
											{
												fromDataAddr=fromDataAddr+", "+fromDataAddr3;
											}
										}
										
										strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
										validate = true;
									}
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									if(count1 > 0)
									{
										if(validate)
										{
											errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
										}
										
									}
									else
									{
										count1=0;
										String sql4="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
												+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME) in  UPPER(?) AND UPPER(LAST_NAME)= UPPER(?) AND CUST_TYPE='D' ";

										pstmt = connectionObject.prepareStatement(sql4);
										//System.out.println("sql4 ===="+sql4);
										pstmt.setString(1, localityCode.trim());
										pstmt.setString(2, firstName.trim());
										pstmt.setString(3, lName);

										rs = pstmt.executeQuery();					
										while( rs.next() )
										{
											fromDataScCode=checkNull(rs.getString("SC_CODE"));
											fromDataName=checkNull(rs.getString("dr_name"));
											fromDataLocality=checkNull(rs.getString("locality_code"));
											fromDataMobile=checkNull(rs.getString("mobile_no"));
											fromDataPin=checkNull(rs.getString("pin"));
											fromDataEmail=checkNull(rs.getString("email_addr"));
											fromDataAddr=checkNull(rs.getString("addr1"));
											fromDataAddr2=checkNull(rs.getString("addr2"));
											fromDataAddr3=checkNull(rs.getString("addr3"));
											count1++;	
											if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
											{
												fromDataAddr=fromDataAddr+", "+fromDataAddr2;
												if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
												{
													fromDataAddr=fromDataAddr+", "+fromDataAddr3;
												}
											}
											
											strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
											validate = true;
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count1 > 0)
										{
											if(validate)
											{
												errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
											}
											
										}
										else
										{
											count1=0;
											String sql5="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
													+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME)= UPPER(?) AND UPPER(LAST_NAME)= UPPER(?) AND CUST_TYPE='D' ";

											pstmt = connectionObject.prepareStatement(sql5);
											//System.out.println("sql5 ===="+sql5);
											pstmt.setString(1, localityCode.trim());
											pstmt.setString(2, fName);
											pstmt.setString(3, lastName.trim());

											rs = pstmt.executeQuery();					
											while( rs.next() )
											{
												fromDataScCode=checkNull(rs.getString("SC_CODE"));
												fromDataName=checkNull(rs.getString("dr_name"));
												fromDataLocality=checkNull(rs.getString("locality_code"));
												fromDataMobile=checkNull(rs.getString("mobile_no"));
												fromDataPin=checkNull(rs.getString("pin"));
												fromDataEmail=checkNull(rs.getString("email_addr"));
												fromDataAddr=checkNull(rs.getString("addr1"));
												fromDataAddr2=checkNull(rs.getString("addr2"));
												fromDataAddr3=checkNull(rs.getString("addr3"));
												count1++;	
												if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
												{
													fromDataAddr=fromDataAddr+", "+fromDataAddr2;
													if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
													{
														fromDataAddr=fromDataAddr+", "+fromDataAddr3;
													}
												}
												
												strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
												validate = true;
											}
											if ( rs != null )
											{
												rs.close();
												rs = null;
											}
											if ( pstmt != null )
											{
												pstmt.close();
												pstmt = null;
											}
											if(count1 > 0)
											{
												if(validate)
												{
													errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
												}
												
											}
											else
											{
												count1=0;
												String sql6="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
														+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME) like UPPER(?) AND UPPER(LAST_NAME)= UPPER(?) AND CUST_TYPE='D' ";

												pstmt = connectionObject.prepareStatement(sql6);
												//System.out.println("sql6 ===="+sql6);
												pstmt.setString(1, localityCode.trim());
												pstmt.setString(2, firstName.trim()+"%");
												pstmt.setString(3, lastName.trim());

												rs = pstmt.executeQuery();					
												while( rs.next() )
												{
													fromDataScCode=checkNull(rs.getString("SC_CODE"));
													fromDataName=checkNull(rs.getString("dr_name"));
													fromDataLocality=checkNull(rs.getString("locality_code"));
													fromDataMobile=checkNull(rs.getString("mobile_no"));
													fromDataPin=checkNull(rs.getString("pin"));
													fromDataEmail=checkNull(rs.getString("email_addr"));
													fromDataAddr=checkNull(rs.getString("addr1"));
													fromDataAddr2=checkNull(rs.getString("addr2"));
													fromDataAddr3=checkNull(rs.getString("addr3"));
													count1++;	
													if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
													{
														fromDataAddr=fromDataAddr+", "+fromDataAddr2;
														if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
														{
															fromDataAddr=fromDataAddr+", "+fromDataAddr3;
														}
													}
													
													strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
													validate = true;
												}
												if ( rs != null )
												{
													rs.close();
													rs = null;
												}
												if ( pstmt != null )
												{
													pstmt.close();
													pstmt = null;
												}
												if(count1 > 0)
												{
													if(validate)
													{
														errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
													}
													
												}
												else
												{
													count1=0;
													String sql7="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
															+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME) = UPPER(?) AND UPPER(LAST_NAME) like UPPER(?) AND CUST_TYPE='D' ";

													pstmt = connectionObject.prepareStatement(sql7);
													//System.out.println("sql7 ===="+sql7);
													pstmt.setString(1, localityCode.trim());
													pstmt.setString(2, firstName.trim());
													pstmt.setString(3, lastName.trim()+"%");

													rs = pstmt.executeQuery();					
													while( rs.next() )
													{
														fromDataScCode=checkNull(rs.getString("SC_CODE"));
														fromDataName=checkNull(rs.getString("dr_name"));
														fromDataLocality=checkNull(rs.getString("locality_code"));
														fromDataMobile=checkNull(rs.getString("mobile_no"));
														fromDataPin=checkNull(rs.getString("pin"));
														fromDataEmail=checkNull(rs.getString("email_addr"));
														fromDataAddr=checkNull(rs.getString("addr1"));
														fromDataAddr2=checkNull(rs.getString("addr2"));
														fromDataAddr3=checkNull(rs.getString("addr3"));
														count1++;	
														if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
														{
															fromDataAddr=fromDataAddr+", "+fromDataAddr2;
															if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
															{
																fromDataAddr=fromDataAddr+", "+fromDataAddr3;
															}
														}
														
														strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
														validate = true;
													}
													if ( rs != null )
													{
														rs.close();
														rs = null;
													}
													if ( pstmt != null )
													{
														pstmt.close();
														pstmt = null;
													}
													if(count1 > 0)
													{
														if(validate)
														{
															errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
														}
														
													}
													else
													{
														count1=0;
														String sql8="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
																+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME) = UPPER(?) AND UPPER(LAST_NAME) like UPPER(?) AND CUST_TYPE='D' ";

														pstmt = connectionObject.prepareStatement(sql8);
														//System.out.println("sql8 ===="+sql8);
														pstmt.setString(1, localityCode.trim());
														pstmt.setString(2, lastName.trim()+"%");
														pstmt.setString(3, firstName.trim());

														rs = pstmt.executeQuery();					
														while( rs.next() )
														{
															fromDataScCode=checkNull(rs.getString("SC_CODE"));
															fromDataName=checkNull(rs.getString("dr_name"));
															fromDataLocality=checkNull(rs.getString("locality_code"));
															fromDataMobile=checkNull(rs.getString("mobile_no"));
															fromDataPin=checkNull(rs.getString("pin"));
															fromDataEmail=checkNull(rs.getString("email_addr"));
															fromDataAddr=checkNull(rs.getString("addr1"));
															fromDataAddr2=checkNull(rs.getString("addr2"));
															fromDataAddr3=checkNull(rs.getString("addr3"));
															count1++;	
															if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
															{
																fromDataAddr=fromDataAddr+", "+fromDataAddr2;
																if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
																{
																	fromDataAddr=fromDataAddr+", "+fromDataAddr3;
																}
															}
															
															strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
															validate = true;
														}
														if ( rs != null )
														{
															rs.close();
															rs = null;
														}
														if ( pstmt != null )
														{
															pstmt.close();
															pstmt = null;
														}
														if(count1 > 0)
														{
															if(validate)
															{
																errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
															}
															
														}
														else
														{
															count1=0;
															String sql9="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
																	+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME) = UPPER(?) AND UPPER(LAST_NAME) like UPPER(?) AND CUST_TYPE='D'";

															pstmt = connectionObject.prepareStatement(sql9);
															//System.out.println("sql9 ===="+sql9);
															pstmt.setString(1, localityCode.trim());
															pstmt.setString(2, lastName.trim());
															pstmt.setString(3, firstName.trim()+"%");

															rs = pstmt.executeQuery();					
															while( rs.next() )
															{
																fromDataScCode=checkNull(rs.getString("SC_CODE"));
																fromDataName=checkNull(rs.getString("dr_name"));
																fromDataLocality=checkNull(rs.getString("locality_code"));
																fromDataMobile=checkNull(rs.getString("mobile_no"));
																fromDataPin=checkNull(rs.getString("pin"));
																fromDataEmail=checkNull(rs.getString("email_addr"));
																fromDataAddr=checkNull(rs.getString("addr1"));
																fromDataAddr2=checkNull(rs.getString("addr2"));
																fromDataAddr3=checkNull(rs.getString("addr3"));
																count1++;	
																if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
																{
																	fromDataAddr=fromDataAddr+", "+fromDataAddr2;
																	if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
																	{
																		fromDataAddr=fromDataAddr+", "+fromDataAddr3;
																	}
																}
																
																strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
																validate = true;
															}
															if ( rs != null )
															{
																rs.close();
																rs = null;
															}
															if ( pstmt != null )
															{
																pstmt.close();
																pstmt = null;
															}
															if(count1 > 0)
															{
																if(validate)
																{
																	errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
																}
																
															}
															else
															{
																count1=0;
																String sql10="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
																		+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME) = UPPER(?) AND UPPER(LAST_NAME) like UPPER(?) AND CUST_TYPE='D' ";

																pstmt = connectionObject.prepareStatement(sql10);
																//System.out.println("sql10 ===="+sql10);
																pstmt.setString(1, localityCode.trim());
																pstmt.setString(2, fName.trim());
																pstmt.setString(3, lastName.trim());

																rs = pstmt.executeQuery();					
																while( rs.next() )
																{
																	fromDataScCode=checkNull(rs.getString("SC_CODE"));
																	fromDataName=checkNull(rs.getString("dr_name"));
																	fromDataLocality=checkNull(rs.getString("locality_code"));
																	fromDataMobile=checkNull(rs.getString("mobile_no"));
																	fromDataPin=checkNull(rs.getString("pin"));
																	fromDataEmail=checkNull(rs.getString("email_addr"));
																	fromDataAddr=checkNull(rs.getString("addr1"));
																	fromDataAddr2=checkNull(rs.getString("addr2"));
																	fromDataAddr3=checkNull(rs.getString("addr3"));
																	count1++;	
																	if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
																	{
																		fromDataAddr=fromDataAddr+", "+fromDataAddr2;
																		if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
																		{
																			fromDataAddr=fromDataAddr+", "+fromDataAddr3;
																		}
																	}
																	
																	strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
																	validate = true;
																}
																if ( rs != null )
																{
																	rs.close();
																	rs = null;
																}
																if ( pstmt != null )
																{
																	pstmt.close();
																	pstmt = null;
																}
																if(count1 > 0)
																{
																	if(validate)
																	{
																		errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
																	}
																	
																}
																else
																{
																	count1=0;
																	String sql11="SELECT  SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin, email_addr, addr1 ,addr2 ,addr3 "
																			+ " FROM STRG_CUSTOMER WHERE LOCALITY_CODE= ?  AND UPPER(FIRST_NAME) = UPPER(?) AND UPPER(LAST_NAME) like UPPER(?) and CUST_TYPE='D' ";

																	pstmt = connectionObject.prepareStatement(sql11);
																	//System.out.println("sql11 ===="+sql11);
																	pstmt.setString(1, localityCode.trim());
																	pstmt.setString(2, firstName.trim());
																	pstmt.setString(3, lName.trim());

																	rs = pstmt.executeQuery();					
																	while( rs.next() )
																	{
																		fromDataScCode=checkNull(rs.getString("SC_CODE"));
																		fromDataName=checkNull(rs.getString("dr_name"));
																		fromDataLocality=checkNull(rs.getString("locality_code"));
																		fromDataMobile=checkNull(rs.getString("mobile_no"));
																		fromDataPin=checkNull(rs.getString("pin"));
																		fromDataEmail=checkNull(rs.getString("email_addr"));
																		fromDataAddr=checkNull(rs.getString("addr1"));
																		fromDataAddr2=checkNull(rs.getString("addr2"));
																		fromDataAddr3=checkNull(rs.getString("addr3"));
																		count1++;	
																		if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
																		{
																			fromDataAddr=fromDataAddr+", "+fromDataAddr2;
																			if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
																			{
																				fromDataAddr=fromDataAddr+", "+fromDataAddr3;
																			}
																		}
																		
																		strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+fromDataName+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
																		validate = true;
																	}
																	if ( rs != null )
																	{
																		rs.close();
																		rs = null;
																	}
																	if ( pstmt != null )
																	{
																		pstmt.close();
																		pstmt = null;
																	}
																	if(count1 > 0)
																	{
																		if(validate)
																		{
																			errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT2\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";																		
																		}
																		
																	}
																}
															}
														}
													}
												}
											}
											
										}
									}
								}
							}

							if(count1 ==0)
							{
								String sql1="SELECT SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin , email_addr, addr1 ,addr2 ,addr3 FROM STRG_CUSTOMER " + 
										" WHERE LOCALITY_CODE= ?  and CUST_TYPE='D' and UTL_MATCH.JARO_WINKLER_SIMILARITY(UPPER(FIRST_NAME ||''|| LAST_NAME ),UPPER(?))>=95 ";
								
							//	String sql1="SELECT SC_CODE ,(FIRST_NAME || ' ' ||LAST_NAME ) as dr_name , locality_code, mobile_no, pin , email_addr, addr1 ,addr2 ,addr3 FROM STRG_CUSTOMER WHERE  " + 
							//			"locality_code =? AND ((  UPPER(first_name) like UPPER(?) OR UPPER(last_name) like UPPER(?)) AND (  UPPER(last_name) like UPPER(?) OR UPPER(first_name) like UPPER(?)) ) ";
								pstmt = connectionObject.prepareStatement(sql1);
								//System.out.println("sql1 :::===="+sql1);
								pstmt.setString(1, localityCode);
								pstmt.setString(2, doctorName);
								//pstmt.setString(3, lName+"%");
								//pstmt.setString(4, lName+"%");
								//pstmt.setString(5, fName+"%");


								rs = pstmt.executeQuery();
								count1=0;
								String compareData="";
								while( rs.next() )
								{
									fromDataScCode=checkNull(rs.getString("SC_CODE"));
									DICTIONARY_VALUES=checkNull(rs.getString("dr_name"));
									locWiseDrDataArray.add(DICTIONARY_VALUES);
									//fromDataName=checkNull(rs.getString("dr_name"));
									fromDataLocality=checkNull(rs.getString("locality_code"));
									fromDataMobile=checkNull(rs.getString("mobile_no"));
									fromDataPin=checkNull(rs.getString("pin"));
									fromDataEmail=checkNull(rs.getString("email_addr"));
									fromDataAddr=checkNull(rs.getString("addr1"));
									fromDataAddr2=checkNull(rs.getString("addr2"));
									fromDataAddr3=checkNull(rs.getString("addr3"));
									count1++;	
									/*if(fromDataAddr2.trim().length()>0 && fromDataAddr2!=null)
									{
										fromDataAddr=fromDataAddr+", "+fromDataAddr2;
										if(fromDataAddr3.trim().length()>0 && fromDataAddr3!=null)
										{
											fromDataAddr=fromDataAddr+", "+fromDataAddr3;
										}
									}
									//System.out.println("DICTIONARY_VALUES==="+DICTIONARY_VALUES);
									Stream.of(DICTIONARY_VALUES.toLowerCase()).forEach((word) -> {

										dictionary.compute(word.trim(), (a, z) -> z == null ? 1 : z + 1);
									});

								    compareData=	correct(doctorName.trim().toLowerCase());
									System.out.println("doctorName ===["+doctorName+"]");
									System.out.println("compareData ===["+compareData+"]");
									if(count1>0)
									{
										if(!(compareData.equalsIgnoreCase(doctorName)) && DICTIONARY_VALUES.equalsIgnoreCase(compareData))
										{
											strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+compareData.toUpperCase()+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
											validate = true;
										}
									}*/
									if(count1>0)
									{										
										strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+compareData.toUpperCase()+"   "+"  </td><td class = 'alertContentTd'> " + fromDataScCode +"   "+ "  </td><td class = 'alertContentTd'> " + localityDescr+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataPin+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataMobile+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataEmail+"   "+ "  </td><td class = 'alertContentTd'> " + fromDataAddr+"   "+ "  </td></tr>");
										validate = true;							
									}

								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}

								if(validate)
								{
									errString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DUPDOCPNT3\" type=\"W\" column_name=\"\"><message>Duplicate Doctor</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
								}
							}									
					}
					//Added by hariom s for duplicate doctor check on --16-Feb-2021 [End]	
					// Added by Sainath T [03/11/2019] To validate minimum attchments [End]

					//Commented by vinayak on [04/07/2016] as per validation will be performed on qualification [end]
					// Added by sachin satre 0n [26/02/2016] To validate qualification request id W15KSUN018 [start]
					/*else if(childNodeName.equalsIgnoreCase("qualification_descr"))
					{
						System.out.println("entr in qualifaiction descr ");
						String qualif="";
						qualif= checkNull(genericUtility.getColumnValue("qualification_descr",dom));
						String fellow="";
						fellow= checkNull(genericUtility.getColumnValue("fellowship",dom));
						System.out.println("Qualification descr null---==="+qualif);
						if(qualif.equals("") && fellow.equals(""))
						{
							errString =  itmDBAccess.getErrorString("qualification_descr","VTCSUQUNL",userId);
							break;
						}
						else if(!qualif.equals(""))
						{
							String sql = "SELECT sh_descr,descr as qualification FROM qualification where descr=?";
							pstmt = connectionObject.prepareStatement(sql);

							pstmt.setString(1, qualif);

							rs = pstmt.executeQuery();
							if ( !rs.next() )
							{
								errString =  itmDBAccess.getErrorString("qualification_descr","VTCUSQLIFY",userId);
							}
							rs.close();
							if(pstmt != null)
							{
								pstmt.close();
							}
						}
					}*/
					// Added by sachin satre 0n [26/02/2016] To validate qualification request id W15KSUN018 [start]
					//Commented by vinayak on [04/07/2016] as per validation will be performed on qualification [end]

				//Added by nilesh for validation on report to 17-11-2017
				//As per the new functionality when report to is NSM then Approval Goes to HO Start :: 20-09-19
				/*String aprvType="";
				String reportTo = getEmpReportTo( userId, connectionObject );
				System.out.println("reportTo::"+reportTo);
				if(objName!=null && "custseries_upload".equalsIgnoreCase(objName))
				{
					if(reportTo!=null && reportTo.length()>0)
					{
						String aprvLevel = getEmpGradeLevel( reportTo, connectionObject );
						System.out.println("aprvLevel::"+aprvLevel);

						if ( aprvLevel!=null && aprvLevel.length()>0)
						{
							if ( aprvLevel != null && aprvLevel.equals("1") )
							{
								aprvType = "TLM";
							}
							else if ( aprvLevel != null && aprvLevel.equals("2") )
							{
								aprvType = "SLM";
							}
							else if ( aprvLevel != null && aprvLevel.equals("3") )
							{
								aprvType = "FLM";
							}
							else if ( aprvLevel != null && aprvLevel.equals("4") )
							{
								aprvType = "SO";
							}
							else if ( aprvLevel != null && aprvLevel.equals("231") )
							{
								aprvType = "NSM";
							}
							else
							{
								aprvType = "SBU";
							}

						}

						if(aprvType.equalsIgnoreCase("NSM"))
						{
							System.out.println("aprvtype is nsm::No fieldlevel approval found ");
							errString = itmDBAccess.getErrorString( "aprvType", "NSMRETTO", userId );
							break;


						}

					}
				}	*/
				//As per the new functionality when report to is NSM then Approval Goes to HO End :: 20-09-19
				//Added by nilesh for validation on report to 17-11-2017
					
					break;
				}
				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(SQLException se)
		{
			System.out.println("Exception: StrgCustomer: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: StrgCustomer: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(isLocalConn &&  connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			System.out.println ("xmlString xmlString :" + xmlString);
			System.out.println ("xmlString1 xmlString1:" + xmlString1);
			System.out.println ("xmlString2 xmlString2:" + xmlString2);

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :StrgCustomer :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from StrgCustomer itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("STRG CUSTOMER EJB ITEMCHANGE["+editFlag+"]");
		String columnValue = "";

		String localityDescr ="";
		String stanCode = "";
		String stateCode = "";
		String city = "";
		String countCode = "";
		String pin = "";
		String district = "";

		String firstName = "";
		String middleName = "";
		String lastName = "";
		String chqName = "";
		String logInEmpCode = "";
		String loginName =  "";

		String chgDate = "";
		String chgUser = "";
		String chgTerm = "";
		boolean isError=false;
		String logInCode="";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			////Commented by vinayak on [08/07/2016] [start]
			//ConnDriver connDriver = null;
			//connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			//Commented by vinayak on [08/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [08/07/2016] to get connection.
			//columnValue = genericUtility.getColumnValue(currentColumn,dom);
			logInEmpCode = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			System.out.println("logInEmpCode["+logInEmpCode+"]");
			logInCode = getValueFromXTRA_PARAMS(xtraParams, "loginCode"); // added by mrunalini sinkar to condition in hocheck sql

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			chgDate = sdf.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentFormNo ["+currentFormNo+"] currentColumn ["+currentColumn+"]");
			String scCode = genericUtility.getColumnValue("sc_code",dom1);
			switch (currentFormNo)
			{
			case 1:
				String mgrHo=getHOEmployee(logInEmpCode,logInCode,connectionObject);
				valueXmlString.append("<Detail1 domId =\"1\">\r\n");
				if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{

					String sql = "";

					if(mgrHo.trim().length() >0 )
					{

						System.out.println("Entered in manager loop"+mgrHo);
						valueXmlString.append("<sales_pers protect='0'><![CDATA[").append("]]></sales_pers>\r\n");
					}
					else if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
					{

						valueXmlString.append("<sales_pers protect='1'><![CDATA[").append(logInEmpCode).append("]]></sales_pers>\r\n");

						sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
						" FROM EMPLOYEE WHERE EMP_CODE = ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, logInEmpCode);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");
						}
						rs.close();
						rs = null;
						pstmt.close();


					String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String salesPersFarg = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"SALES_PERS_FARG"));
					String entityCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"));

					java.util.Calendar dateCreated = java.util.Calendar.getInstance();
					java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
					String sysDate = df.format(dateCreated.getTime());

					valueXmlString.append("<tran_date><![CDATA[").append(sysDate).append("]]></tran_date>\r\n");
					valueXmlString.append("<status><![CDATA[").append(("O")).append("]]></status>\r\n");
					if ( salesPers.trim().length() == 0 )
					{
						salesPers = ( salesPersFarg.trim().length() == 0 ) ? entityCode: salesPersFarg;
					}
					String getSalesPerData = "SELECT SALES_PERS.SALES_PERS,SALES_PERS.SP_NAME,SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER,SALES_PERS  WHERE ( ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER(+) )AND  SALES_PERS.SALES_PERS = ?";

					pstmt = connectionObject.prepareStatement(getSalesPerData);
					pstmt.setString(1, salesPers);

					rs = pstmt.executeQuery();
					if( rs.next())
					{

						System.out.println("dividion is["+rs.getString("DESCR")+"]");
						valueXmlString.append("<sp_name><![CDATA[").append(checkNull(rs.getString("SP_NAME"))).append("]]></sp_name>\r\n");
						valueXmlString.append("<item_ser protect='1'><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>\r\n");
						valueXmlString.append("<itemser_descr><![CDATA[").append(checkNull(rs.getString("DESCR"))).append("]]></itemser_descr>\r\n");


					}
					else
					{

						valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
						valueXmlString.append("<item_ser protect='1'><![CDATA[").append("").append("]]></item_ser>\r\n");
						valueXmlString.append("<itemser_descr><![CDATA[").append("").append("]]></itemser_descr>\r\n");

					}
					rs.close();
					rs = null;
					if(pstmt != null)
					{
						pstmt.clearParameters();
						pstmt.close();
						pstmt = null;
					}
					}
					String rmkV= checkNull(genericUtility.getColumnValue("remark_aprv",dom));
					String escd= checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String cnfopt= checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String  mktopt= checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));

					//Added by nilesh for so set remark_aprv2 Start 26-10-17 W17ASUN005
					String rmkV2= checkNull(genericUtility.getColumnValue("remark_aprv2",dom));
					//Added by nilesh for so set remark_aprv2 Start 26-10-17 W17ASUN005

					java.util.Calendar dateCreatedS = java.util.Calendar.getInstance();
					java.text.DateFormat dfS = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
					String sysDateS = dfS.format(dateCreatedS.getTime());
					valueXmlString.append("<tran_date><![CDATA[").append(sysDateS).append("]]></tran_date>\r\n");
					valueXmlString.append("<status><![CDATA[").append(("O")).append("]]></status>\r\n");
					valueXmlString.append("<class_code><![CDATA[").append("").append("]]></class_code>");
					valueXmlString.append("<prefix protect='1'><![CDATA[").append("Dr").append("]]></prefix>");
					valueXmlString.append("<sex><![CDATA[").append("M").append("]]></sex>\r\n");
					valueXmlString.append("<confirmed><![CDATA[").append("U").append("]]></confirmed>\r\n");
					valueXmlString.append("<confirmed_by_mkt><![CDATA[").append("U").append("]]></confirmed_by_mkt>\r\n");
					/*valueXmlString.append("<total_business><![CDATA[").append("0").append("]]></total_business>\r\n");
					valueXmlString.append("<business_to_us><![CDATA[").append("0").append("]]></business_to_us>\r\n");*/ //commented by shraddha M to set default blank value as per requirement 16-mar-2020(W19LSUN003)
					valueXmlString.append("<visit_no><![CDATA[").append("0").append("]]></visit_no>\r\n");
					valueXmlString.append("<chg_date protect=\"1\"><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
					valueXmlString.append("<chg_user protect=\"1\"><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
					valueXmlString.append("<chg_term protect=\"1\"><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
					valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(rmkV).append("]]></remark_aprv>\r\n");
					valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(escd).append("]]></exist_sc_code>\r\n");



					//Added by nilesh for so set conform_aprv2 u Start 26-10-17 W17ASUN005
					valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(rmkV2).append("]]></remark_aprv2>\r\n");
					valueXmlString.append("<confirmed_aprv2><![CDATA[").append("U").append("]]></confirmed_aprv2>\r\n");

					//Added by nilesh for so set conform_aprv2 u End 26-10-17 W17ASUN005

/*					valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append(cnfopt).append("]]></remarks_aprv1_opt>\r\n");
					valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append(mktopt).append("]]></remarks_mkt_opt>\r\n");*/

					if(editFlag.equalsIgnoreCase("E"))
					{
						String loc = checkNull(genericUtility.getColumnValue("locality_descr",dom));
						String locCode = checkNull(genericUtility.getColumnValue("locality_code",dom));
						String routeTypes = checkNull(genericUtility.getColumnValue("route_type",dom));
						valueXmlString.append("<locality_descr protect='1'><![CDATA[").append(loc).append("]]></locality_descr>");
						valueXmlString.append("<locality_code protect='1'><![CDATA[").append(locCode).append("]]></locality_code>");
						int cont=0;
						String sqls = "";
						String mgrHos=getHOEmployee(logInEmpCode,logInCode,connectionObject);
						String salesPerss = checkNull(genericUtility.getColumnValue("sales_pers",dom));
						String route_types = checkNull(genericUtility.getColumnValue("route_type",dom));
						valueXmlString.append("<route_type protect='1'><![CDATA[").append(route_types).append("]]></route_type>");

						String remarks_aprv1_pt= checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
						String fsmCNFRmk= checkNull(genericUtility.getColumnValue("confirmed",dom));
						String fsmRmk= checkNull(genericUtility.getColumnValue("remark_aprv",dom));
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(escd).append("]]></exist_sc_code>\r\n");

						valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append(cnfopt).append("]]></remarks_aprv1_opt>\r\n");
						valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append(mktopt).append("]]></remarks_mkt_opt>\r\n");
					}


/*					String confirmedAprv = checkNull(genericUtility.getColumnValue("confirmed",dom));
					String confirmedAprvmkt = checkNull(genericUtility.getColumnValue("confirmed_by_mkt",dom));
					String remarks1_optss = checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String remarks2_optss = checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));
					String remark_aprvs = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
					String exisSC = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String exist_sc_codes = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					if(confirmedAprv.equalsIgnoreCase("U"))
					{
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append("").append("]]></remark_aprv>\r\n");
						valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append(remarks1_optss).append("]]></remarks_aprv1_opt>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exisSC).append("]]></exist_sc_code>\r\n");

					}
					else if(confirmedAprvmkt.equalsIgnoreCase("U"))
					{

						valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append(remarks2_optss).append("]]></remarks_mkt_opt>\r\n");
						valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append("").append("]]></remarks_by_mkt>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exist_sc_codes).append("]]></exist_sc_code>\r\n");
					}	*/
					//Added by Prasad R. on 03-NOV-2019 -Start
					String objName = getObjNameFromDom(dom,"objName",currentFormNo);
					valueXmlString.append("<attach_ids><![CDATA[").append( (objName + "_" +generateRandomNo()) ).append("]]></attach_ids>\r\n");
					//Added by Prasad R. on 03-NOV-2019 -End
					
					valueXmlString.append("<rx_mode><![CDATA[").append("").append("]]></rx_mode>\r\n");
					valueXmlString.append("<rx_mode_descr protect='1'> <![CDATA[").append("").append("]]></rx_mode_descr>");
					valueXmlString.append("<age_bracket><![CDATA[").append("").append("]]></age_bracket>");
					valueXmlString.append("<age_bracket_descr protect='1'><![CDATA[").append("").append("]]></age_bracket_descr>");
					
				}
				else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
                    System.out.println("intered in edit mode hhho.." +mgrHo);
					String sex = "";
					sex = genericUtility.getColumnValue("sex",dom);
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code",dom));
					String rmkAp = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
					String esccode = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String routeTp = checkNull(genericUtility.getColumnValue("route_type",dom));
					String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String spName = checkNull(genericUtility.getColumnValue("sp_name",dom));
					String escd= checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String cnfopt= checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String  mktopt= checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));

					//added by nilesh Start :: 26-10-17 W17ASUN005

					String slmopt= checkNull(genericUtility.getColumnValue("remarks_aprv2_opt",dom));
					
					//added by nilesh End:: 26-10-17 W17ASUN005
					//valueXmlString.append("<locality_code protect='1'><![CDATA[").append(localityCode).append("]]></locality_code>\r\n");//commented by sachin satre on [01/mar/2016] for ho user edit mode

					String confirmed_by_mkts=checkNull(genericUtility.getColumnValue("confirmed_by_mkt",dom));
					String confirmed_by_mgr=checkNull(genericUtility.getColumnValue("confirmed",dom));

					//Added by nilesh Start :: 27-10-2017 W17ASUN005

					String confirmed_by_mgrsslm=checkNull(genericUtility.getColumnValue("confirmed_aprv2",dom));

					//added by nilesh End :: 27-10-2017

					if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
					{
						String sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
						" FROM EMPLOYEE WHERE EMP_CODE = ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, logInEmpCode);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");
						}
						rs.close();
						rs = null;
						pstmt.close();
						valueXmlString.append("<sales_pers protect='1'><![CDATA[").append(salesPers).append("]]></sales_pers>\r\n");
						valueXmlString.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\r\n");
						//valueXmlString.append("<sex protect='0'><![CDATA[").append(sex).append("]]></sex>\r\n"); // commended by hariom on 11/02/2020
						valueXmlString.append("<sex><![CDATA[").append(sex).append("]]></sex>\r\n"); //Changed by hariom as per metis live on 11/02/2020

						System.out.println("Confirmbymkt : "+confirmed_by_mkts);
						if(confirmed_by_mkts.equals(""))
						{
						valueXmlString.append("<confirmed_by_mkt><![CDATA[").append("U").append("]]></confirmed_by_mkt>\r\n");
						}
						else
						{
							valueXmlString.append("<confirmed_by_mkt><![CDATA[").append(confirmed_by_mkts).append("]]></confirmed_by_mkt>\r\n");
						}

						//Added by nilesh Start :: 27-10-2017 W17ASUN005 W17ASUN005
						if(confirmed_by_mgrsslm.equals(""))
						{
							valueXmlString.append("<confirmed_aprv2><![CDATA[").append("U").append("]]></confirmed_aprv2>\r\n");
						}
						else
						{
							valueXmlString.append("<confirmed_aprv2><![CDATA[").append(confirmed_by_mgrsslm).append("]]></confirmed_aprv2>\r\n");

						}


						String objName=getObjNameFromDom(dom,"objName",currentFormNo);
						System.out.println("objNameobjName::::in new dr creation:["+objName+"]");

						// for setting value in emp code
						if(objName.equalsIgnoreCase("custseries_upld_aprv_rk"))
						{
							valueXmlString.append("<emp_code_ho><![CDATA[").append(logInEmpCode).append("]]></emp_code_ho>\r\n");

							valueXmlString.append("<emp_name_ho><![CDATA[").append(loginName).append("]]></emp_name_ho>\r\n");

						}
						if(objName.equalsIgnoreCase("custseries_upload_aprv"))
						{
							valueXmlString.append("<emp_code__aprv><![CDATA[").append(logInEmpCode).append("]]></emp_code__aprv>\r\n");

							valueXmlString.append("<emp_code__aprv_name><![CDATA[").append(loginName).append("]]></emp_code__aprv_name>\r\n");

						}

						if(objName.equalsIgnoreCase("custseries_upload_aprv2"))
						{
							valueXmlString.append("<emp_code__aprv2><![CDATA[").append(logInEmpCode).append("]]></emp_code__aprv2>\r\n");

							valueXmlString.append("<emp_code__aprv_name2><![CDATA[").append(loginName).append("]]></emp_code__aprv_name2>\r\n");

						}

						//Added by nilesh End :: 27-10-2017 W17ASUN005

						valueXmlString.append("<route_type protect='1'><![CDATA[").append(routeTp).append("]]></route_type>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(escd).append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append(cnfopt).append("]]></remarks_aprv1_opt>\r\n");
						valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append(mktopt).append("]]></remarks_mkt_opt>\r\n");
						//added by sachin satre on [1/mar/2016] for ho user eddit locality [start]  request id :
						if(mgrHo.trim().length() >0 )
						{
							System.out.println("Entered in manager loop +==="+mgrHo);
							valueXmlString.append("<locality_code protect='0'><![CDATA[").append(localityCode).append("]]></locality_code>\r\n"); 

						}
						else
						{
							System.out.println("Enterd on else for ho usersssss-===.."+mgrHo);
							//valueXmlString.append("<locality_code protect='1'><![CDATA[").append(localityCode).append("]]></locality_code>\r\n"); // commended by hariom on 11/02/2020
							valueXmlString.append("<locality_code><![CDATA[").append(localityCode).append("]]></locality_code>\r\n"); //Changed by hariom as per metis live on 11/02/2020
						}
						//added by sachin satre on [1/mar/2016] for ho user eddit locality [end]  request id :

					}
					if(editFlag.equalsIgnoreCase("E"))
					{
						System.out.println("Entered in U of Itmdefualt EditFlag");
						String rmkAps = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
						String esccodes= checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
						String routeTps = checkNull(genericUtility.getColumnValue("route_type",dom));
						String loc = checkNull(genericUtility.getColumnValue("locality_descr",dom));
						String locCode = checkNull(genericUtility.getColumnValue("locality_code",dom));//addeded by vinayak
					  //valueXmlString.append("<locality_descr protect='1'><![CDATA[").append(loc).append("]]></locality_descr>");//commented by sachin satre on [01/mar/2016] for ho user edit mode
						valueXmlString.append("<route_type protect='1'><![CDATA[").append(routeTps).append("]]></route_type>");
						String remarks_aprv1_pt= checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
						String fsmCNFRmk= checkNull(genericUtility.getColumnValue("confirmed",dom));
						String fsmRmk= checkNull(genericUtility.getColumnValue("remark_aprv",dom));

						//Added By Nilesh for Slm approver Start  25:10:17


						String remark_aprv2= checkNull(genericUtility.getColumnValue("remark_aprv2",dom));
						System.out.println("remark_aprv2::"+remark_aprv2);

						valueXmlString.append("<remarks_aprv2_opt protect='1'><![CDATA[").append(slmopt).append("]]></remarks_aprv2_opt>\r\n");
						if(remark_aprv2.equals(""))
						{
						valueXmlString.append("<remark_aprv2 protect='1'><![CDATA[").append("").append("]]></remark_aprv2>\r\n");
						}
						else
						{
							valueXmlString.append("<remark_aprv2 protect='1'><![CDATA[").append(remark_aprv2).append("]]></remark_aprv2>\r\n");

						}
						//Added By Nilesh for Slm approver End  25:10:17 W17ASUN005


						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(escd).append("]]></exist_sc_code>\r\n");

						valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append(cnfopt).append("]]></remarks_aprv1_opt>\r\n");
						valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append(mktopt).append("]]></remarks_mkt_opt>\r\n");

						//added by sachin satre on [1/mar/2016] for ho user eddit locality [start]  request id :
						if(mgrHo.trim().length() >0 )
						{
							System.out.println("Entered in manager ho loop descr +==="+mgrHo);
							valueXmlString.append("<locality_code protect='0'><![CDATA[").append(locCode).append("]]></locality_code>");//added by vinayak to make locality_code editable for HO user
							valueXmlString.append("<locality_descr protect='1'><![CDATA[").append(loc).append("]]></locality_descr>");
						}
						else
						{
							System.out.println("Enterd on else for ho usersssss descrss-===.."+mgrHo);
							//valueXmlString.append("<locality_code protect='1'><![CDATA[").append(locCode).append("]]></locality_code>"); // commended by hariom on 11/02/2020
							valueXmlString.append("<locality_code><![CDATA[").append(locCode).append("]]></locality_code>");  //Changed by hariom as per metis live on 11/02/2020
							valueXmlString.append("<locality_descr protect='1'><![CDATA[").append(loc).append("]]></locality_descr>");
						}
						//added by sachin satre on [1/mar/2016] for ho user eddit locality [end]  request id :

					}
	                valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(escd).append("]]></exist_sc_code>\r\n");
	                valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append(cnfopt).append("]]></remarks_aprv1_opt>\r\n");
	                valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append(mktopt).append("]]></remarks_mkt_opt>\r\n");
/*					String confirmedAprv = checkNull(genericUtility.getColumnValue("confirmed",dom));
					String confirmedAprvmkt = checkNull(genericUtility.getColumnValue("confirmed_by_mkt",dom));
					String remarks1_optss = checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String remarks2_optss = checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));
					String remark_aprvs = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
					String exisSC = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String exist_sc_codes = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					if(confirmedAprv.equalsIgnoreCase("U"))
					{
						System.out.println("Entered in U of Itmdefualt Edit");
						System.out.println("remarks_aprv1_opt " +remarks1_optss);
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append("").append("]]></remark_aprv>\r\n");
						valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append(remarks1_optss).append("]]></remarks_aprv1_opt>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exisSC).append("]]></exist_sc_code>\r\n");

					}
					else if(confirmedAprvmkt.equalsIgnoreCase("U"))
					{

						valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append(remarks2_optss).append("]]></remarks_mkt_opt>\r\n");
						valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append("").append("]]></remarks_by_mkt>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exist_sc_codes).append("]]></exist_sc_code>\r\n");
					}*/
	                //as per requirement added by shraddha m (24-mar-2020) start(W19LSUN003)
	                String rxModeVal = checkNull(genericUtility.getColumnValue("rx_mode",dom));
	                String age= checkNull(genericUtility.getColumnValue("age_bracket",dom));
	                valueXmlString.append("<rx_mode><![CDATA[").append(rxModeVal).append("]]></rx_mode>");
	                valueXmlString.append("<age_bracket><![CDATA[").append(age).append("]]></age_bracket>");
	                String descSql="";
	                String rxDescr="";
	                descSql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'RX_MODE' AND MOD_NAME = 'W_STRG_SERIES' AND FLD_VALUE = ?";
					pstmt = connectionObject.prepareStatement(descSql);
					pstmt.setString(1, rxModeVal);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						rxDescr = rs.getString("DESCR");
						valueXmlString.append("<rx_mode_descr protect='1'><![CDATA[").append(rxDescr).append("]]></rx_mode_descr>\r\n");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					descSql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'AGE_BRACKET' AND MOD_NAME = 'W_STRG_SERIES' AND FLD_VALUE = ?";
					String ageDescr="";
					pstmt = connectionObject.prepareStatement(descSql);
					pstmt.setString(1, age);
					rs = pstmt.executeQuery();
					if( rs.next())
					{	
						ageDescr = rs.getString("DESCR");
						valueXmlString.append("<age_bracket_descr protect='1'><![CDATA[").append(ageDescr).append("]]></age_bracket_descr>\r\n");							
					}	
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					 //as per requirement added by shraddha m (24-mar-2020) end(W19LSUN003)
					
					
				}
				//Commented by vinayak on 20/06/2016 to set itemchenge on locality code [start]
				/*else if(currentColumn.trim().equalsIgnoreCase("locality_descr"))
				{
					String stanCodeDescr = "";
					String stateCodeDescr = "";
					String countCodeDescr = "";
					String sprsCode = "";
					String routeIds="";
					columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));
					sprsCode = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String selLocSql = "SELECT LOCALITY_CODE,STAN_CODE,STATE_CODE,CITY,DISTRICT,COUNT_CODE,PIN FROM LOCALITY WHERE DESCR = ?";
					pstmt = connectionObject.prepareStatement(selLocSql);

					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						localityDescr = checkNull(rs.getString("LOCALITY_CODE"));
						stanCode = checkNull(rs.getString("STAN_CODE"));
						stateCode = checkNull(rs.getString("STATE_CODE"));
						city = checkNull(rs.getString("CITY"));
						district = checkNull(rs.getString("DISTRICT"));
						countCode = checkNull(rs.getString("COUNT_CODE"));
						pin = checkNull(rs.getString("PIN"));

						stanCodeDescr = getDescrFromMaster(connectionObject,"STATION","STAN_CODE",stanCode);
						stateCodeDescr = getDescrFromMaster(connectionObject,"STATE","STATE_CODE",stateCode);
						countCodeDescr = getDescrFromMaster(connectionObject,"COUNTRY","COUNT_CODE",countCode);

						valueXmlString.append("<locality_code><![CDATA[").append(localityDescr).append("]]></locality_code>\r\n");
						valueXmlString.append("<district><![CDATA[").append(district).append("]]></district>\r\n");
						valueXmlString.append("<stan_code><![CDATA[").append(stanCode).append("]]></stan_code>\r\n");
						valueXmlString.append("<station_descr><![CDATA[").append(stanCodeDescr).append("]]></station_descr>\r\n");
						valueXmlString.append("<state_code><![CDATA[").append(stateCode).append("]]></state_code>\r\n");
						valueXmlString.append("<state_descr><![CDATA[").append(stateCodeDescr).append("]]></state_descr>\r\n");
						valueXmlString.append("<count_code><![CDATA[").append(countCode).append("]]></count_code>\r\n");
						valueXmlString.append("<country_descr><![CDATA[").append(countCodeDescr).append("]]></country_descr>\r\n");
						valueXmlString.append("<city><![CDATA[").append(city).append("]]></city>\r\n");
						valueXmlString.append("<pin><![CDATA[").append(pin).append("]]></pin>\r\n");

					}
					else
					{

						valueXmlString.append("<locality_code><![CDATA[").append("").append("]]></locality_code>\r\n");
						valueXmlString.append("<district_off><![CDATA[").append("").append("]]></district_off>\r\n");
						valueXmlString.append("<stan_code><![CDATA[").append("").append("]]></stan_code>\r\n");
						valueXmlString.append("<station_descr><![CDATA[").append("").append("]]></station_descr>\r\n");
						valueXmlString.append("<state_code><![CDATA[").append("").append("]]></state_code>\r\n");
						valueXmlString.append("<state_descr><![CDATA[").append("").append("]]></state_descr>\r\n");
						valueXmlString.append("<count_code><![CDATA[").append("").append("]]></count_code>\r\n");
						valueXmlString.append("<country_descr><![CDATA[").append("").append("]]></country_descr>\r\n");
						valueXmlString.append("<city><![CDATA[").append("").append("]]></city>\r\n");
						valueXmlString.append("<pin><![CDATA[").append("").append("]]></pin>\r\n");

					}
					if(rs != null)
					{
						rs.close();
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

					String sql = "";
					//String mgrHo=getHOEmployee(logInEmpCode,connectionObject);
					String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String localityCodeS = checkNull(genericUtility.getColumnValue("locality_code",dom));

					System.out.println("LOcality descr  "+localityDescr);

					System.out.println("LOcality cosesx  "+localityCodeS);
					if(!salesPers.equals(""))
					{
						sql = "SELECT ROUTE_ID,ROUTE_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?"; //MODIFIED BY SHRAVAN OM 07-04-2016
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, salesPers);
						pstmt.setString(2, localityDescr);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							valueXmlString.append("<route_id protect='1'>").append(checkNull( rs.getString("ROUTE_ID") )).append("</route_id>\r\n");
							valueXmlString.append("<route_type protect='1'>").append(checkNull( rs.getString("ROUTE_TYPE") )).append("</route_type>\r\n"); //MODIFIED BY SHRAVAN OM 07-04-2016

						}
						else
						{
							int csuRouteId=0;
							String routeTypeCsu="";
							//String localityCd = checkNull(rs.getString("LOCALITY_CODE"));
							String sql1 = "SELECT route_id,ROUTE_TYPE FROM customer_series_upload WHERE LOCALITY_CODE = ? AND SALES_PERS = ?";
							pstmt1 = connectionObject.prepareStatement(sql1);
							pstmt1.setString(1, localityDescr);
							pstmt1.setString(2, salesPers);
							rs1 = pstmt1.executeQuery();
							if (rs1.next() )
							{
								csuRouteId=rs1.getInt("route_id");
								routeTypeCsu=rs1.getString("ROUTE_TYPE");
								valueXmlString.append("<route_id protect='1'>").append(csuRouteId).append("</route_id>\r\n");
								valueXmlString.append("<route_type protect='1'><![CDATA[").append(routeTypeCsu).append("]]></route_type>\r\n");

							}
							else
							{

								String routeIdNew="";
								routeIdNew = checkNull(getRouteID(sprsCode, connectionObject));
								routeIds = routeIdNew;
								valueXmlString.append("<route_id protect='1'>").append(routeIds).append("</route_id>\r\n");
								String stanCodeHq     = checkNull(getValueFromRefTable("EMPLOYEE","EMP_CODE",salesPers,"stan_code__hq",connectionObject));
								if(stanCode.equalsIgnoreCase(stanCodeHq))
								{
									valueXmlString.append("<route_type protect='1'><![CDATA[").append("H").append("]]></route_type>\r\n");
								}
								else
								{
									valueXmlString.append("<route_type protect='0'><![CDATA[").append("").append("]]></route_type>\r\n");
								}
							}
							rs1.close();
							rs1 = null;
							if(pstmt1 != null)
							{
								pstmt1.close();
								pstmt1 = null;
							}
						}
					}
					rs.close();
					rs = null;
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}*/
				//Commented by vinayak on 20/06/2016 to set itemchenge on locality code [END]
				//Added and Modified by vinayak on [20/06/2016] [start]
				else if(currentColumn.trim().equalsIgnoreCase("locality_code"))
				{
					String stanCodeDescr = "";
					String stateCodeDescr = "";
					String countCodeDescr = "";
					String sprsCode = "";
					String routeIds="";
					columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));
					sprsCode = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String selLocSql = "SELECT DESCR,STAN_CODE,STATE_CODE,CITY,DISTRICT,COUNT_CODE,PIN FROM LOCALITY WHERE LOCALITY_CODE = ?";
					pstmt = connectionObject.prepareStatement(selLocSql);

					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						localityDescr = checkNull(rs.getString("DESCR"));
						stanCode = checkNull(rs.getString("STAN_CODE"));
						stateCode = checkNull(rs.getString("STATE_CODE"));
						city = checkNull(rs.getString("CITY"));
						district = checkNull(rs.getString("DISTRICT"));
						countCode = checkNull(rs.getString("COUNT_CODE"));
						pin = checkNull(rs.getString("PIN"));

						stanCodeDescr = getDescrFromMaster(connectionObject,"STATION","STAN_CODE",stanCode);
						stateCodeDescr = getDescrFromMaster(connectionObject,"STATE","STATE_CODE",stateCode);
						countCodeDescr = getDescrFromMaster(connectionObject,"COUNTRY","COUNT_CODE",countCode);

						valueXmlString.append("<locality_descr><![CDATA[").append(localityDescr).append("]]></locality_descr>\r\n");
						valueXmlString.append("<district><![CDATA[").append(district).append("]]></district>\r\n");
						valueXmlString.append("<stan_code><![CDATA[").append(stanCode).append("]]></stan_code>\r\n");
						valueXmlString.append("<station_descr><![CDATA[").append(stanCodeDescr).append("]]></station_descr>\r\n");
						valueXmlString.append("<state_code><![CDATA[").append(stateCode).append("]]></state_code>\r\n");
						valueXmlString.append("<state_descr><![CDATA[").append(stateCodeDescr).append("]]></state_descr>\r\n");
						valueXmlString.append("<count_code><![CDATA[").append(countCode).append("]]></count_code>\r\n");
						valueXmlString.append("<country_descr><![CDATA[").append(countCodeDescr).append("]]></country_descr>\r\n");
						valueXmlString.append("<city><![CDATA[").append(city).append("]]></city>\r\n");
						valueXmlString.append("<pin><![CDATA[").append(pin).append("]]></pin>\r\n");

					}
					else
					{

						valueXmlString.append("<locality_descr><![CDATA[").append("").append("]]></locality_descr>\r\n");
						valueXmlString.append("<district_off><![CDATA[").append("").append("]]></district_off>\r\n");
						valueXmlString.append("<stan_code><![CDATA[").append("").append("]]></stan_code>\r\n");
						valueXmlString.append("<station_descr><![CDATA[").append("").append("]]></station_descr>\r\n");
						valueXmlString.append("<state_code><![CDATA[").append("").append("]]></state_code>\r\n");
						valueXmlString.append("<state_descr><![CDATA[").append("").append("]]></state_descr>\r\n");
						valueXmlString.append("<count_code><![CDATA[").append("").append("]]></count_code>\r\n");
						valueXmlString.append("<country_descr><![CDATA[").append("").append("]]></country_descr>\r\n");
						valueXmlString.append("<city><![CDATA[").append("").append("]]></city>\r\n");
						valueXmlString.append("<pin><![CDATA[").append("").append("]]></pin>\r\n");

					}
					if(rs != null)
					{
						rs.close();
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

					String sql = "";
					//String mgrHo=getHOEmployee(logInEmpCode,connectionObject);
					String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String localityCodeS = checkNull(genericUtility.getColumnValue("locality_code",dom));

					System.out.println("LOcality descr  "+localityDescr);

					System.out.println("LOcality cosesx  "+localityCodeS);
					if(!salesPers.equals(""))
					{
						sql = "SELECT ROUTE_ID,ROUTE_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?"; //MODIFIED BY SHRAVAN OM 07-04-2016
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, salesPers);
						pstmt.setString(2, localityCodeS);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							valueXmlString.append("<route_id protect='1'>").append(checkNull( rs.getString("ROUTE_ID") )).append("</route_id>\r\n");
							valueXmlString.append("<route_type protect='1'>").append(checkNull( rs.getString("ROUTE_TYPE") )).append("</route_type>\r\n"); //MODIFIED BY SHRAVAN OM 07-04-2016

						}
						else
						{
							int csuRouteId=0;
							String routeTypeCsu="";
							//String localityCd = checkNull(rs.getString("LOCALITY_CODE"));
							String sql1 = "SELECT route_id,ROUTE_TYPE FROM customer_series_upload WHERE LOCALITY_CODE = ? AND SALES_PERS = ?";
							pstmt1 = connectionObject.prepareStatement(sql1);
							pstmt1.setString(1, localityCodeS);
							pstmt1.setString(2, salesPers);
							rs1 = pstmt1.executeQuery();
							if (rs1.next() )
							{
								csuRouteId=rs1.getInt("route_id");
								routeTypeCsu=rs1.getString("ROUTE_TYPE");
								valueXmlString.append("<route_id protect='1'>").append(csuRouteId).append("</route_id>\r\n");
								valueXmlString.append("<route_type protect='1'><![CDATA[").append(routeTypeCsu).append("]]></route_type>\r\n");

							}
							else
							{

								String routeIdNew="";
								routeIdNew = checkNull(getRouteID(sprsCode, connectionObject));
								routeIds = routeIdNew;
								valueXmlString.append("<route_id protect='1'>").append(routeIds).append("</route_id>\r\n");
								String stanCodeHq     = checkNull(getValueFromRefTable("EMPLOYEE","EMP_CODE",salesPers,"stan_code__hq",connectionObject));
								if(stanCode.equalsIgnoreCase(stanCodeHq))
								{
									valueXmlString.append("<route_type protect='1'><![CDATA[").append("H").append("]]></route_type>\r\n");
								}
								else
								{
									valueXmlString.append("<route_type protect='0'><![CDATA[").append("").append("]]></route_type>\r\n");
								}
							}
							rs1.close();
							rs1 = null;
							if(pstmt1 != null)
							{
								pstmt1.close();
								pstmt1 = null;
							}
						}
					}
					rs.close();
					rs = null;
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				//Added and Modified by vinayak on [20/06/2016] [end]
				/*String rtId="";
				selLocSql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
				pstmt = connectionObject.prepareStatement(selLocSql);
				pstmt.setString(1, sprsCode);
				pstmt.setString(2, localityDescr);
				rs = pstmt.executeQuery();
				if( rs.next())
				{
					rtId=rs.getString("ROUTE_ID");
					valueXmlString.append("<route_id protect='1'>").append(checkNull( rs.getString("ROUTE_ID") )).append("</route_id>\r\n");
				}
				else
				{
					valueXmlString.append("<route_id protect='1'>").append(checkNull("0")).append("</route_id>\r\n");
					String stanCodeHq     = checkNull(getValueFromRefTable("EMPLOYEE","EMP_CODE",sprsCode,"stan_code__hq",connectionObject));
					if(stanCode.equalsIgnoreCase(stanCodeHq))
					{
						valueXmlString.append("<route_type protect='1'><![CDATA[").append("H").append("]]></route_type>\r\n");
					}
					else
					{
						valueXmlString.append("<route_type protect='0'><![CDATA[").append("").append("]]></route_type>\r\n");
					}
				}
				if(rs != null)
				{
					rs.close();
				}
				if(pstmt != null)
				{
					pstmt.close();
				}*/

				else if ( currentColumn.trim().equalsIgnoreCase("first_name") ||  currentColumn.trim().equalsIgnoreCase("middle_name") ||  currentColumn.trim().equalsIgnoreCase("last_name") )
				{
					firstName	= genericUtility.getColumnValue("first_name",dom);
					middleName	= genericUtility.getColumnValue("middle_name",dom);
					lastName		= genericUtility.getColumnValue("last_name",dom);
					chqName = (firstName == null ? "":firstName+" ") + (middleName == null ? "":middleName+" ") + (lastName == null ? "":lastName);
					System.out.println("chqName :"+chqName);

					valueXmlString.append("<chq_name><![CDATA[").append(( chqName == null ? "":chqName.trim() )).append("]]></chq_name>\r\n");
				}

				else if (currentColumn.trim().equalsIgnoreCase("sex"))
				{
					String sex = checkNull(genericUtility.getColumnValue(currentColumn,dom));
					System.out.println("value of sex from dom :::"+sex);
					String sexDescr = "";
					if(sex !=null && sex.length() > 0)
					{
						String sql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'SEX' AND MOD_NAME = 'W_WSFA_STRG_CUSTOMER' AND FLD_VALUE = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, sex);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							sexDescr = checkNull(rs.getString("DESCR"));
						}
						if ( rs != null )
						{
							rs.close();
							rs = null;
						}
						if ( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
						System.out.println("value of sex Description :::"+sexDescr);
						valueXmlString.append("<sex_descr><![CDATA[").append(sexDescr).append("]]></sex_descr>\r\n");
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("telephone1"))
				{
					String std1 = checkNull(genericUtility.getColumnValue("std1",dom));

					if(std1.length()<6)
					{
						std1+="-";
					}
					String tele1 = checkNull(genericUtility.getColumnValue("telephone1",dom));
					String telephone1=std1+tele1;
					if(!tele1.equals("") && !std1.equals(""))
					{
					valueXmlString.append("<tele1><![CDATA[").append(telephone1).append("]]></tele1>\r\n");
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("std1"))
				{
					String std1 = checkNull(genericUtility.getColumnValue("std1",dom));

					if(std1.length()<6)
					{
						std1+="-";
					}
					String tele1 = checkNull(genericUtility.getColumnValue("telephone1",dom));
					String telephone1=std1+tele1;
					if(!tele1.equals("") && !std1.equals(""))
					{
					valueXmlString.append("<tele1><![CDATA[").append(telephone1).append("]]></tele1>\r\n");
					}
				}

				else if (currentColumn.trim().equalsIgnoreCase("telephone2"))
				{
					String std2 = checkNull(genericUtility.getColumnValue("std2",dom));
					if(std2.length()<6)
					{
						std2+="-";
					}
					String tele2 = checkNull(genericUtility.getColumnValue("telephone2",dom));
					String telephone2=std2+tele2;
					if(!tele2.equals("") && !std2.equals(""))
					{
					valueXmlString.append("<tele2><![CDATA[").append(telephone2).append("]]></tele2>\r\n");
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("std2"))
				{
					String std2 = checkNull(genericUtility.getColumnValue("std2",dom));
					if(std2.length()<6)
					{
						std2+="-";
					}
					String tele2 = checkNull(genericUtility.getColumnValue("telephone2",dom));
					String telephone2=std2+tele2;
					if(!tele2.equals("") && !std2.equals(""))
					{
					valueXmlString.append("<tele2><![CDATA[").append(telephone2).append("]]></tele2>\r\n");
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("telephone3"))
				{
					String std3 = checkNull(genericUtility.getColumnValue("std3",dom));
					if(std3.length()<6)
					{
						std3+="-";
					}
					String tele3 = checkNull(genericUtility.getColumnValue("telephone3",dom));
					String telephone3=std3+tele3;
					if(!tele3.equals("") && !std3.equals(""))
					{
					valueXmlString.append("<tele3><![CDATA[").append(telephone3).append("]]></tele3>\r\n");
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("std3"))
				{
					String std3 = checkNull(genericUtility.getColumnValue("std3",dom));
					if(std3.length()<6)
					{
						std3+="-";
					}
					String tele3 = checkNull(genericUtility.getColumnValue("telephone3",dom));
					String telephone3=std3+tele3;
					if(!tele3.equals("") && !std3.equals(""))
					{
					valueXmlString.append("<tele3><![CDATA[").append(telephone3).append("]]></tele3>\r\n");
					}
				}
				else if(currentColumn.equalsIgnoreCase("remarks_aprv1_opt"))
				{
					String cnfirmR = checkNull(genericUtility.getColumnValue("confirmed",dom));
					String remarks1_opt = checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String remark_aprvs = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
					String exisSC = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String duplicateMSG="Duplicate Doctor";//added  by sachin satre on 4/mar/2016 request id:W15KSUN012
					String insufficient="Insufficient Information";//added  by sachin satre on 4/mar/2016 request id:W15KSUN012

					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[Start]
					String msgDrNameIncomplete="Incomplete / Inaccurate Dr Name";
					String msgQuliInaccurate="Inaccurate Qualification";
					String msgAddresIncomplete="Incomplete / Inaccurate Address";
					String msgProofUnreadable="Unreadable / Different Attached Proof";
					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[end]

					if(cnfirmR.equalsIgnoreCase("R"))
					{
				//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[Start]
					/*if(remarks1_opt.equals("I"))
					{
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exisSC).append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(insufficient).append("]]></i_or_d>\r\n");//added  by sachin satre on 4/mar/2016 request id:W15KSUN012
					}
					if(remarks1_opt.equals("D"))
					{
						valueXmlString.append("<remark_aprv protect='1'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exisSC).append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(duplicate).append("]]></i_or_d>\r\n");
					}
					*/
					if(remarks1_opt.equals("D"))
					{

						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exisSC).append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(duplicateMSG).append("]]></i_or_d>\r\n");
					}
					else if(remarks1_opt.equals("S"))
					{
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgDrNameIncomplete).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
					else if(remarks1_opt.equals("Q"))
					{
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgQuliInaccurate).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
					else if(remarks1_opt.equals("E"))
					{
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgAddresIncomplete).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
					else if(remarks1_opt.equals("P"))
					{
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgProofUnreadable).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
					//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[end]
					}
					else
					{
						valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
				}
				//Added By Nilesh for slm opt itemchange value Start :: 26-10-17 W17ASUN005

				else if(currentColumn.equalsIgnoreCase("remarks_aprv2_opt"))
				{
					String cnfirmR = checkNull(genericUtility.getColumnValue("confirmed_aprv2",dom));
					String remarks1_opt = checkNull(genericUtility.getColumnValue("remarks_aprv2_opt",dom));
					String remark_aprvs = checkNull(genericUtility.getColumnValue("remark_aprv2",dom));
					String exisSC = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String duplicateMSG="Duplicate Doctor";
					String insufficient="Insufficient Information";


					String msgDrNameIncomplete="Incomplete / Inaccurate Dr Name";
					String msgQuliInaccurate="Inaccurate Qualification";
					String msgAddresIncomplete="Incomplete / Inaccurate Address";
					String msgProofUnreadable="Unreadable / Different Attached Proof";


					if(cnfirmR.equalsIgnoreCase("R"))
					{

					if(remarks1_opt.equals("D"))
					{

						valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv2>\r\n");
						valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exisSC).append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(duplicateMSG).append("]]></i_or_d>\r\n");
					}
					else if(remarks1_opt.equals("S"))
					{
						valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv2>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgDrNameIncomplete).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
					else if(remarks1_opt.equals("Q"))
					{
						valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv2>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgQuliInaccurate).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
					else if(remarks1_opt.equals("E"))
					{
						valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv2>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgAddresIncomplete).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
					else if(remarks1_opt.equals("P"))
					{
						valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv2>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<i_or_d ><![CDATA[").append(msgProofUnreadable).append("]]></i_or_d>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}

					}
					else
					{
						valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv2>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
				}
				//Added By Nilesh for slm opt itemchange value End :: 26-10-17 W17ASUN005

				else if(currentColumn.equalsIgnoreCase("remarks_mkt_opt"))
				{
					String cnfirmR = checkNull(genericUtility.getColumnValue("confirmed_by_mkt",dom));
					String cnfRemMKt = checkNull(genericUtility.getColumnValue("remarks_by_mkt",dom));
					String exist_sc_codes = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String remarks1_opt = checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));
					String remark_aprvs = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
					String exisSC = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					String duplicateMSG="Duplicate Doctor";//added  by sachin satre on 4/mar/2016 request id:W15KSUN012
					String insufficient="Insufficient Information";//added  by sachin satre on 4/mar/2016 request id:W15KSUN012

					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[Start]
					String msgDrNameIncomplete="Incomplete / Inaccurate Dr Name";
					String msgQuliInaccurate="Inaccurate Qualification";
					String msgAddresIncomplete="Incomplete / Inaccurate Address";
					String msgProofUnreadable="Unreadable / Different Attached Proof";
					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[end]
					if(cnfirmR.equalsIgnoreCase("R"))
					{
						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[Start]
						/*if(remarks1_opt.equals("I"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exist_sc_codes).append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(insufficient).append("]]></i_or_d>\r\n");//added  by sachin satre on 4/mar/2016 request id:W15KSUN012
						}
						else if(remarks1_opt.equals("D"))
						{
							//valueXmlString.append("<remarks_by_mkt protect='1'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n"); //Modified by sachin satre on [14/03/2016] request id : W15LSUN013
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n"); //Modified by sachin satre on [14/03/2016] request id : W15LSUN013
							valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exist_sc_codes).append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(duplicateMSG).append("]]></i_or_d>\r\n");//added  by sachin satre on 4/mar/2016 request id:W15KSUN012
						}*/
						if(remarks1_opt.equals("D"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exist_sc_codes).append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(duplicateMSG).append("]]></i_or_d>\r\n");
						}
						else if(remarks1_opt.equals("S"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgDrNameIncomplete).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opt.equals("Q"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgQuliInaccurate).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opt.equals("E"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgAddresIncomplete).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opt.equals("P"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgProofUnreadable).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[end]

						/*else
						{
							valueXmlString.append("<remarks_by_mkt protect='1'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exist_sc_codes).append("]]></exist_sc_code>\r\n");
						}*/
					}
					else
					{
						valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
					}
				}
				else if(currentColumn.equalsIgnoreCase("confirmed"))
				{
					//String item_Ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String confirmedAprv = checkNull(genericUtility.getColumnValue("confirmed",dom));
					String remarks1_opt = checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String remarks2_opts = checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));
					String remarks1_opts = checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String remark_aprvs = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
					String exisSC = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[Start]
					String duplicateMSG="Duplicate Doctor";//added  by sachin satre on 4/mar/2016 request id:W15KSUN012
					String msgDrNameIncomplete="Incomplete / Inaccurate Dr Name";
					String msgQuliInaccurate="Inaccurate Qualification";
					String msgAddresIncomplete="Incomplete / Inaccurate Address";
					String msgProofUnreadable="Unreadable / Different Attached Proof";
					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[end]

					if(!confirmedAprv.equalsIgnoreCase("R"))
					{
						if(confirmedAprv.equalsIgnoreCase("A"))
						{
							valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append("").append("]]></remark_aprv>\r\n");
							valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append("").append("]]></remarks_aprv1_opt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else
						{
							valueXmlString.append("<remarks_aprv1_opt protect='1'><![CDATA[").append("").append("]]></remarks_aprv1_opt>\r\n");
							valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvs).append("]]></remark_aprv>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}

					}
					else
					{
						valueXmlString.append("<remarks_aprv1_opt protect='0'><![CDATA[").append(remarks1_opts).append("]]></remarks_aprv1_opt>\r\n");
						String remark_aprvsS = checkNull(genericUtility.getColumnValue("remark_aprv",dom));
						String exisSCS = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[start]
						/*if(remarks1_opt.equals("I"))
						{
							valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exisSCS).append("]]></exist_sc_code>\r\n");
						}
						else
						{
							valueXmlString.append("<remark_aprv protect='1'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv>\r\n");
							valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exisSCS).append("]]></exist_sc_code>\r\n");
						}*/
						if(remarks1_opt.equals("D"))
						{
							valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv>\r\n");
							valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exisSCS).append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(duplicateMSG).append("]]></i_or_d>\r\n");
						}
						else if(remarks1_opt.equals("S"))
						{
								valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgDrNameIncomplete).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opt.equals("Q"))
						{
								valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgQuliInaccurate).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opt.equals("E"))
						{
								valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgAddresIncomplete).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opt.equals("P"))
						{
								valueXmlString.append("<remark_aprv protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgProofUnreadable).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}

						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[end]
					}


				}
//Added By Nilesh Start :: 26:10-2017 for slm itemchange W17ASUN005

				else if(currentColumn.equalsIgnoreCase("confirmed_aprv2"))
				{

					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String confirmedAprv = checkNull(genericUtility.getColumnValue("confirmed_aprv2",dom));
					String remarks2_opt = checkNull(genericUtility.getColumnValue("remarks_aprv2_opt",dom));
					String remarks3_opts = checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));
					String remarks1_opts2 = checkNull(genericUtility.getColumnValue("remarks_aprv2_opt",dom));
					String remark_aprvs2 = checkNull(genericUtility.getColumnValue("remark_aprv2",dom));
					String exisSC = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));

					String duplicateMSG="Duplicate Doctor";
					String msgDrNameIncomplete="Incomplete / Inaccurate Dr Name";
					String msgQuliInaccurate="Inaccurate Qualification";
					String msgAddresIncomplete="Incomplete / Inaccurate Address";
					String msgProofUnreadable="Unreadable / Different Attached Proof";
					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[end]

					if(!confirmedAprv.equalsIgnoreCase("R"))
					{
						if(confirmedAprv.equalsIgnoreCase("A"))
						{
							valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append("").append("]]></remark_aprv2>\r\n");
							valueXmlString.append("<remarks_aprv2_opt protect='1'><![CDATA[").append("").append("]]></remarks_aprv2_opt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else
						{
							valueXmlString.append("<remarks_aprv2_opt protect='1'><![CDATA[").append("").append("]]></remarks_aprv2_opt>\r\n");
							valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvs2).append("]]></remark_aprv2>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}

					}
					else
					{
						valueXmlString.append("<remarks_aprv2_opt protect='0'><![CDATA[").append(remarks1_opts2).append("]]></remarks_aprv2_opt>\r\n");
						String remark_aprvsS = checkNull(genericUtility.getColumnValue("remark_aprv2",dom));
						String exisSCS = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));

						if(remarks1_opts2.equals("D"))
						{
							valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv2>\r\n");
							valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exisSCS).append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(duplicateMSG).append("]]></i_or_d>\r\n");
						}
						else if(remarks1_opts2.equals("S"))
						{
								valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv2>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgDrNameIncomplete).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opts2.equals("Q"))
						{
								valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv2>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgQuliInaccurate).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opts2.equals("E"))
						{
								valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv2>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgAddresIncomplete).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks1_opts2.equals("P"))
						{
								valueXmlString.append("<remark_aprv2 protect='0'><![CDATA[").append(remark_aprvsS).append("]]></remark_aprv2>\r\n");
								valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
								valueXmlString.append("<i_or_d ><![CDATA[").append(msgProofUnreadable).append("]]></i_or_d>\r\n");
								valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
								valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
								valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
								valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}

						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[end]
					}


				}

				//Added By Nilesh End :: 26-10-2017 W17ASUN005
				else if(currentColumn.equalsIgnoreCase("confirmed_by_mkt"))
				{
					//String item_Ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String confirmedAprv = checkNull(genericUtility.getColumnValue("confirmed_by_mkt",dom));
					String remarks2_opt = checkNull(genericUtility.getColumnValue("remarks_mkt_opt",dom));
					String remarks1_opt = checkNull(genericUtility.getColumnValue("remarks_aprv1_opt",dom));
					String cnfRemMKt = checkNull(genericUtility.getColumnValue("remarks_by_mkt",dom));
					String exist_sc_codes = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[Start]
					String duplicateMSG="Duplicate Doctor";//added  by sachin satre on 4/mar/2016 request id:W15KSUN012
					String msgDrNameIncomplete="Incomplete / Inaccurate Dr Name";
					String msgQuliInaccurate="Inaccurate Qualification";
					String msgAddresIncomplete="Incomplete / Inaccurate Address";
					String msgProofUnreadable="Unreadable / Different Attached Proof";
					//Added by sachin satre on [14/03/2016] request id : W15LSUN013	[end]

					if(!confirmedAprv.equalsIgnoreCase("R"))
					{
						if(confirmedAprv.equalsIgnoreCase("A"))
						{
							valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append("").append("]]></remarks_mkt_opt>\r\n");
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append("").append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else
						{
						valueXmlString.append("<remarks_mkt_opt protect='1'><![CDATA[").append("").append("]]></remarks_mkt_opt>\r\n");
						valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKt).append("]]></remarks_by_mkt>\r\n");
						valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
						valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
						valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
						valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
						valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
					}
					else
					{
						valueXmlString.append("<remarks_mkt_opt protect='0'><![CDATA[").append(remarks2_opt).append("]]></remarks_mkt_opt>\r\n");
						String cnfRemMKtS = checkNull(genericUtility.getColumnValue("remarks_by_mkt",dom));
						String exist_sc_codesS = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[start]
						/*if(remarks2_opt.equals("I"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKtS).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append(exist_sc_codesS).append("]]></exist_sc_code>\r\n");
						}
						else
						{
							valueXmlString.append("<remarks_by_mkt protect='1'><![CDATA[").append(cnfRemMKtS).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exist_sc_codesS).append("]]></exist_sc_code>\r\n");
						}*/
						if(remarks2_opt.equals("D"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKtS).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='0'><![CDATA[").append(exist_sc_codesS).append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(duplicateMSG).append("]]></i_or_d>\r\n");
						}
						else if(remarks2_opt.equals("S"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKtS).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgDrNameIncomplete).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks2_opt.equals("Q"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKtS).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgQuliInaccurate).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks2_opt.equals("E"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKtS).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgAddresIncomplete).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");
						}
						else if(remarks2_opt.equals("P"))
						{
							valueXmlString.append("<remarks_by_mkt protect='0'><![CDATA[").append(cnfRemMKtS).append("]]></remarks_by_mkt>\r\n");
							valueXmlString.append("<exist_sc_code protect='1'><![CDATA[").append("").append("]]></exist_sc_code>\r\n");
							valueXmlString.append("<i_or_d ><![CDATA[").append(msgProofUnreadable).append("]]></i_or_d>\r\n");
							valueXmlString.append("<doctorname><![CDATA[").append("").append("]]></doctorname>\r\n");
							valueXmlString.append("<city2><![CDATA[").append("").append("]]></city2>\r\n");
							valueXmlString.append("<speciality2><![CDATA[").append("").append("]]></speciality2>\r\n");
							valueXmlString.append("<qualification2><![CDATA[").append("").append("]]></qualification2>\r\n");

						}
						//Modified by sachin satre on [14/03/2016] request id : W15LSUN013	[end]
					}
				}
				else if(currentColumn.equalsIgnoreCase("exist_sc_code"))
				{
					String doctorName="";
					String speciality2="";
					String city2="";
					String qualification2="";
					String salesPe = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String sqls="select first_name||' '||middle_name||' '||last_name as Fname,city,qualification,(select descr from speciality,strg_series where speciality.spl_code=strg_series.spl_code and strg_series.sc_code=? AND strg_series.sales_pers=? and rownum = '1') AS speciality_descr from strg_customer where sc_code=?";
					String existScCode = checkNull(genericUtility.getColumnValue("exist_sc_code",dom));
					pstmt = connectionObject.prepareStatement(sqls);
					pstmt.setString(1, existScCode);
					pstmt.setString(2, salesPe);
					pstmt.setString(3, existScCode);
					rs = pstmt.executeQuery();
					if(rs.next()){
						doctorName=rs.getString("Fname");
						city2=rs.getString("city");
						qualification2=rs.getString("qualification");
						speciality2=rs.getString("speciality_descr");

					}
					valueXmlString.append("<doctorname><![CDATA[").append(doctorName).append("]]></doctorname>\r\n");
					valueXmlString.append("<city2><![CDATA[").append(city2).append("]]></city2>\r\n");
					valueXmlString.append("<speciality2><![CDATA[").append(speciality2).append("]]></speciality2>\r\n");
					valueXmlString.append("<qualification2><![CDATA[").append(qualification2).append("]]></qualification2>\r\n");
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt=null;
					}
				}
				else if (currentColumn.equalsIgnoreCase("sales_pers"))
				{
					String routeIds="";
					String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code",dom));
					String salesPersFarg = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"SALES_PERS_FARG"));
					String entityCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"));

				//String mgrHo=getHOEmployee(logInEmpCode,connectionObject);
					if(mgrHo.trim().length() >0 ){

						System.out.println("Entered in manager loop"+mgrHo);
						//	valueXmlString.append("<sales_pers protect='0'><![CDATA[").append("]]></sales_pers>\r\n");
					}
					else
					{
						if(logInEmpCode != null && logInEmpCode.trim().length()>0 && !"null".equalsIgnoreCase(logInEmpCode))
						{
							valueXmlString.append("<sales_pers protect = '1'><![CDATA[").append(logInEmpCode).append("]]></sales_pers>\r\n");


							String sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
							" FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, logInEmpCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");
							}

							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}


						}
					}
					if ( salesPers.length() == 0 )
					{
						salesPers = ( salesPersFarg.length() == 0 ) ? entityCode: salesPersFarg;
					}
					String getSalesPerData = "SELECT SALES_PERS.SALES_PERS,SALES_PERS.SP_NAME,SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER,SALES_PERS  WHERE ( ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER(+) )AND  SALES_PERS.SALES_PERS = ?";

					pstmt = connectionObject.prepareStatement(getSalesPerData);
					pstmt.setString(1, salesPers);

					rs = pstmt.executeQuery();
					if( rs.next())
					{

						valueXmlString.append("<sp_name><![CDATA[").append(checkNull(rs.getString("SP_NAME"))).append("]]></sp_name>\r\n");
						valueXmlString.append("<item_ser protect='1'><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>\r\n");
						valueXmlString.append("<itemser_descr><![CDATA[").append(checkNull(rs.getString("DESCR"))).append("]]></itemser_descr>\r\n");


					}
					else
					{

						valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
						valueXmlString.append("<item_ser protect='1'><![CDATA[").append("").append("]]></item_ser>\r\n");
						valueXmlString.append("<itemser_descr><![CDATA[").append("").append("]]></itemser_descr>\r\n");

					}
					rs.close();
					if(pstmt != null)
					{
						pstmt.clearParameters();
						pstmt.close();
						pstmt = null;
					}



					String sql = "";
					String mgrHos=getHOEmployee(logInEmpCode,logInCode,connectionObject);
					String salesPerss = checkNull(genericUtility.getColumnValue("sales_pers",dom));
					String localityCodeS = checkNull(genericUtility.getColumnValue("locality_code",dom));
					System.out.println(" dfsdfadf "+localityCodeS);
					if(!localityCodeS.equals(""))
					{
					sql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					pstmt.setString(2, localityCodeS);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						valueXmlString.append("<route_id protect='1'>").append(checkNull( rs.getString("ROUTE_ID") )).append("</route_id>\r\n");
						valueXmlString.append("<route_type protect='1'><![CDATA[").append("]]></route_type>\r\n");
					}
					else
					{
						int csuRouteId=0;
						String routeTypeItem="";
						//String localityCd = checkNull(rs.getString("LOCALITY_CODE"));
						String sql1 = "SELECT route_id,route_type FROM customer_series_upload WHERE LOCALITY_CODE = ? AND SALES_PERS = ?";
						pstmt1 = connectionObject.prepareStatement(sql1);
						pstmt1.setString(1, localityCodeS);
						pstmt1.setString(2, salesPers);
						rs1 = pstmt1.executeQuery();
						if (rs1.next() )
						{
							csuRouteId=rs1.getInt("route_id");
							routeTypeItem=rs1.getString("route_type");
							valueXmlString.append("<route_id protect='1'>").append(csuRouteId).append("</route_id>\r\n");
							valueXmlString.append("<route_type protect='1'><![CDATA[").append(routeTypeItem).append("]]></route_type>\r\n");

						}
						else
						{
							String routeIdNew="";
							routeIdNew = checkNull(getRouteID(salesPerss, connectionObject));
							routeIds = routeIdNew;
							valueXmlString.append("<route_id protect='1'>").append(routeIds).append("</route_id>\r\n");
							String stanCodeHq     = checkNull(getValueFromRefTable("EMPLOYEE","EMP_CODE",salesPers,"stan_code__hq",connectionObject));
							if(stanCode.equalsIgnoreCase(stanCodeHq))
							{
								valueXmlString.append("<route_type protect='1'><![CDATA[").append("H").append("]]></route_type>\r\n");
							}
							else
							{
								valueXmlString.append("<route_type protect='0'><![CDATA[").append("").append("]]></route_type>\r\n");
							}
						}
						rs1.close();
						rs1 = null;
						if(pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null;
						}

					}
					}
					rs.close();
					rs = null;
					if(pstmt != null)
					{
						pstmt.clearParameters();
						pstmt.close();
						pstmt = null;
					}
				}
				else if(currentColumn.equalsIgnoreCase("speciality_descr"))
				{
					//String item_Ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String item_Ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
					System.out.println(" ITEMCHANGED ITEM_SER....."+item_Ser);
					String selSlpSql = "select spl_code from speciality where descr=?";// QUERY CHANGES by Vishakha[23.04.2015]
					String spCode = "";

					pstmt = connectionObject.prepareStatement(selSlpSql);
					pstmt.setString(1, columnValue);

					rs = pstmt.executeQuery();
					if( rs.next())
					{
						spCode = rs.getString(1);
						valueXmlString.append("<spl_code><![CDATA[").append(spCode).append("]]></spl_code>\r\n");

					}
					else
					{
						valueXmlString.append("<spl_code><![CDATA[").append("").append("]]></spl_code>\r\n");

					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

				}


				else if(currentColumn.equalsIgnoreCase("class_descr"))
				{

					System.out.println(" ITEMCHANGED class_descr.class_descr...."+currentColumn);

					columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));
					System.out.println(" ITEMCHANGED class_descr.columnValue...."+columnValue);

					String item_Ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
					String selSlpSql = "SELECT CS.DESCR,C.CLASS_CODE FROM STRG_CLASS C ,STRG_SER_CLASS CS WHERE c.class_code= cs.class_code AND CS.ITEM_SER = ? AND c.active_yn='Y' AND CS.DESCR=?";
					String clDescr = "";

					pstmt = connectionObject.prepareStatement(selSlpSql);
					pstmt.setString(1, item_Ser);
					pstmt.setString(2, columnValue);

					rs = pstmt.executeQuery();
					if( rs.next())
					{
						clDescr = rs.getString("CLASS_CODE");
						valueXmlString.append("<class_code><![CDATA[").append(clDescr).append("]]></class_code>\r\n");

					}
					else
					{
						valueXmlString.append("<class_code><![CDATA[").append("").append("]]></class_code>\r\n");

					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

				}
				//Commented by vinayak on [03/07/2016] to perform item change on qualification [start]
				// Added by sachin satre on 26/02/2016   request  id : W15KSUN018 [start]
				/*else if(currentColumn.equalsIgnoreCase("qualification_descr"))
				{
					//String item_Ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
					columnValue = genericUtility.getColumnValue(currentColumn,dom);
					String item_Ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
					System.out.println(" ITEMCHANGED ITEM_SER....."+item_Ser);
					String qualiSql = "Select Sh_Descr From Qualification where Descr=?";
					String qualiDescr = "";

					pstmt = connectionObject.prepareStatement(qualiSql);
					pstmt.setString(1, columnValue);

					rs = pstmt.executeQuery();
					if( rs.next())
					{
						qualiDescr = rs.getString(1);
						valueXmlString.append("<qualification><![CDATA[").append(qualiDescr).append("]]></qualification>\r\n");

					}
					else
					{
						valueXmlString.append("<qualification><![CDATA[").append("").append("]]></qualification>\r\n");

					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

				}*/
				// Added by sachin satre on 26/02/2016   request  id : W15KSUN018 [end]
				//Commented by vinayak on [03/07/2016] to perform item change on qualification [end]
				//Added by vinayak on [04/07/2016] to perform item change on qualification [start]
				else if(currentColumn.equalsIgnoreCase("qualification"))
				{
					columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));
					System.out.println("Qualification field value is:- "+columnValue);
					String qualiSql = "Select Descr From Qualification where qlf_code=?";
					String qualiDescr = "";

					pstmt = connectionObject.prepareStatement(qualiSql);
					pstmt.setString(1, columnValue);

					rs = pstmt.executeQuery();
					if( rs.next())
					{
						qualiDescr = checkNull(rs.getString(1));
						valueXmlString.append("<qualification_descr><![CDATA[").append(qualiDescr.trim()).append("]]></qualification_descr>\r\n");

					}
					else
					{
						valueXmlString.append("<qualification_descr><![CDATA[").append("").append("]]></qualification_descr>\r\n");

					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
					}

				}
				//Added by vinayak on [04/07/2016] to perform item change on qualification [end]
				//added by shraddha M as per requirement [24-mar-2020]start(W19LSUN003)
				else if(currentColumn.equalsIgnoreCase("rx_mode"))
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);	
					
					System.out.println("columnValue in rx_mode :[" +columnValue +"]");
					String descrSql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'RX_MODE' AND MOD_NAME = 'W_STRG_SERIES' AND FLD_VALUE = ?";
					String rxDescr="";
					pstmt = connectionObject.prepareStatement(descrSql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					//System.out.println("Rx descr:"+rxDescr);
					if(rs.next())
					{
						rxDescr = rs.getString("DESCR");
						valueXmlString.append("<rx_mode_descr protect='1'><![CDATA[").append(rxDescr).append("]]></rx_mode_descr>\r\n");
					}
					else
					{
						valueXmlString.append("<rx_mode_descr protect='1'><![CDATA[").append("").append("]]></rx_mode_descr>\r\n");
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();								
					}
				}
				else if ( currentColumn.equalsIgnoreCase("age_bracket") )
				{
					columnValue = genericUtility.getColumnValue(currentColumn,dom);	
					System.out.println("columnValue in age_bracket :[" +columnValue +"]");
					String descrSql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'AGE_BRACKET' AND MOD_NAME = 'W_STRG_SERIES' AND FLD_VALUE = ?";
					String ageDescr="";
					pstmt = connectionObject.prepareStatement(descrSql);
					pstmt.setString(1, columnValue);
					rs = pstmt.executeQuery();
					if( rs.next())
					{	
						ageDescr = rs.getString("DESCR");
						valueXmlString.append("<age_bracket_descr protect='1'><![CDATA[").append(ageDescr).append("]]></age_bracket_descr>\r\n");							
					}	
					else
					{
						valueXmlString.append("<age_bracket_descr protect='1'><![CDATA[").append("").append("]]></age_bracket_descr>\r\n");
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();								
					}
				}
				//added by shraddha M as per requirement [24-mar-2020]start(W19LSUN003)
				valueXmlString.append("</Detail1>\r\n");
				break;


			}

		}
		catch(SQLException se)
		{
			System.out.println("Exception: StrgCustomer: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
			isError=true;
		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgCustomer :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			isError=true;
		}
		finally
		{
			try
			{
				System.out.println("boolean before commit"+isError);
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(!isError)
				{
					System.out.println("boolean after commit"+isError);
					connectionObject.commit();
				}
				else
				{
					System.out.println("boolean 11 rollback"+isError);
					connectionObject.rollback();
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");

		return valueXmlString.toString();
	}

	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input.trim();
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[StrgCustomer] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[StrgCustomer] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
	private String getAllowedRouteType( String loginEmpCode, Connection conn ) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String propValue = "";
		String propSql = "";
		Statement stmt1 = null;
		ResultSet rs1 = null;
		String propSql1 = "";
		Boolean isPropFound = false;
		try
		{
			propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER = (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+loginEmpCode+"') "  ;
			stmt = conn.createStatement();
			rs = stmt.executeQuery(propSql);
			System.out.println("[StrgSeries][getAllowedRouteType()][QUERY] " +propSql + ":");
			if(rs.next())
			{
				propValue = checkNull(rs.getString("PROP_VALUE"));
				isPropFound = true;
			}
			System.out.println("[StrgSeries][getAllowedRouteType()][propValue] " +propValue + ":");
			if(isPropFound == false)
			{
				propSql1 = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER ='ALL' "  ;
				stmt1 = conn.createStatement();
				rs1 = stmt1.executeQuery(propSql1);
				if(rs1.next())
				{
					propValue = checkNull(rs1.getString("PROP_VALUE"));
				}
				System.out.println("[StrgSeriesPsrCopy] [getAllowedRouteType()][propValue@IF:::] " +propValue);
			}

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
			if (rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if ( stmt1 != null )
			{
				stmt1.close();
				stmt1 = null;
			}
			if (propValue == null)
			{
				propValue = "";
			}

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if ( stmt1 != null )
				{
					stmt1.close();
					stmt1 = null;
				}

			}
			catch(Exception e1){}
		}
		return propValue;
	}
	private String getDescrFromMaster(Connection conn,String tableName,String colName,String columnValue)
	{
		String sql = "";
		String descr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		sql = "select DESCR from "+tableName+" where "+colName+" = '" + columnValue + "' ";
		try
		{
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
			if(rs.next())
			{
				descr = rs.getString("DESCR");
			}
			rs.close();
			pstmt.close();
			System.out.println("descr--------------"+descr);
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			System.out.println("Exception ::" + exception.getMessage());
		}
		return descr;

	}

	public String getHOEmployee( String empCode,String loginCode,Connection con) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " +
			"WHERE A.EMP_CODE = ? AND A.CODE=?" +
			"AND A.PROFILE_ID = B.PROFILE_ID " +
			"AND B.APPLICATION = 'MRO' " +
			"AND B.MENU_ROW = 1 " +
			"AND B.MENU_COL = 1 " +
			"AND B.MENU_SUBCOL = 1 " +
			"AND B.LEVEL_4 = 1 " +
			"AND B.LEVEL_5 = 1 " +
			"AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = con.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			pstmt.setString( 2, loginCode );

			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return empCodeHO;
	}
	private String getValueFromRefTable(String tableName,String fieldName,String fieldValue,String reqdField,Connection conn)
	{
		Statement stmt = null;
		ResultSet rs = null;
		String returnValue ="";
		try
		{
			if (fieldValue ==null )
				fieldValue ="";
			stmt = conn.createStatement();
			String sql = "SELECT "+reqdField+" FROM "+tableName+" WHERE "+fieldName+" = '"+fieldValue+"'" ;
			System.out.println("*****getValueFromRefTable******* DESCR QUERY IS  "+sql);
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				returnValue = rs.getString(1);
				System.out.println("************* VALUE IN  "+tableName+" *IS*******"+returnValue );
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Inside getValueFromRefTable Exception *******"+e.getMessage());

		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [PostMarketingStudyEJBPos]"+e.getMessage());
				e.printStackTrace();
			}
		}
		if (returnValue == null)
			returnValue="";
		return returnValue;
	}
	   public String getRouteID(String sales_pers,Connection conn)throws RemoteException, ITMException
		{

			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String route_id="";
			try
			{
				//String sql = " SELECT NVL(MAX(TO_NUMBER(NVL(ROUTE_ID,0))),0)+1 FROM SPRS_ROUTE WHERE SPRS_CODE = ?";
				String sql = "SELECT GREATEST( ( SELECT NVL(MAX(TO_NUMBER(NVL(ROUTE_ID,0))),0) FROM SPRS_ROUTE WHERE SPRS_CODE = ? ),( SELECT NVL(MAX(TO_NUMBER(NVL(ROUTE_ID,0))),0) FROM CHG_COVER_ROUTE CR , CHG_COVERAGE CC WHERE CC.TRAN_ID=CR.TRAN_ID AND CC.SALES_PERS = ?), ( SELECT NVL(MAX(TO_NUMBER(NVL(ROUTE_ID,0))),0) FROM CUSTOMER_SERIES_UPLOAD WHERE SALES_PERS = ?) )+1 MAX_ROUTE_ID FROM DUAL";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sales_pers);
				pstmt.setString(2, sales_pers);
				pstmt.setString(3, sales_pers);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					route_id=checkNull(rs.getString(1));
				}
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;

				if(route_id.equals(""))
				{
					route_id="1";
				}

			}
			catch(SQLException se)
			{
				System.out.println("Exception: getRouteID(String sales_pers,Connection conn): " + se.getMessage() + ":");
			}
			return route_id.trim();
		}
	    public String getRouteCount(String salesPrs,String localityCde,Connection conn)
	    {
	    	PreparedStatement pstmt = null;
			ResultSet rs = null;
			String cntRoute="0";
			try
			{
				String sql = "select route_id from sprs_route where sprs_code=? and locality_code=?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,salesPrs);
				pstmt.setString(2, localityCde);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cntRoute=checkNull(rs.getString("route_id"));
				}
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;

			}
			catch(SQLException se)
			{
				System.out.println("Exception: getRouteID(String salesPrs, String localityCdeConnection conn): " + se.getMessage() + ":");
			}
	    	return cntRoute;
	    }
	    public  String getStanType(String sprs_code ,String loc_code,String route_type, Connection conn) throws ITMException
	    {
	    	System.out.println("INSIDE GET STAN TYPE ");

	        Statement pstmt = null;
	        //PreparedStatement pstmt = null;
	        ResultSet rs = null;
	        String locSubType="";
	        String locType="";
	        String stanType = "";

	        try
	        {
	            java.util.HashMap stanMapData = new java.util.HashMap();
	            stanMapData.put("MAH","METHQ");
	            stanMapData.put("MHH","METHQ");
	            stanMapData.put("MOH","METHQ");
	            stanMapData.put("MAX","METEX");
	            stanMapData.put("MOX","METEX");
	            stanMapData.put("MHX","METHX");
	            stanMapData.put("MHO","METHO");
	            stanMapData.put("MOO","METOT");
	            stanMapData.put("MAO","METAO");
	            stanMapData.put("MAM","METMA");
	            stanMapData.put("MHM","METMA");
	            stanMapData.put("MOM","METMA");
	            stanMapData.put("MAT","METNA");
	            stanMapData.put("MHT","METNA");
	            stanMapData.put("MOT","METNA");

	            stanMapData.put("NAH","NMTHQ");
	            stanMapData.put("NHH","NMTHQ");
	            stanMapData.put("NOH","NMTHQ");
	            stanMapData.put("NAX","NMTEX");
	            stanMapData.put("NOX","NMTEX");
	            stanMapData.put("NHX","NMTHX");
	            stanMapData.put("NHO","NMTHO");
	            stanMapData.put("NOO","NMTOT");
	            stanMapData.put("NAO","NMTAO");
	            stanMapData.put("NAM","NMTMA");
	            stanMapData.put("NHM","NMTMA");
	            stanMapData.put("NOM","NMTMA");
	            stanMapData.put("NAT","NMTNA");
	            stanMapData.put("NHT","NMTNA");
	            stanMapData.put("NOT","NMTNA");


	           /* String locSql = "SELECT LOCALITY_SUBTYPE, LOCALITY_TYPE FROM LOCALITY WHERE LOCALITY_CODE='"+loc_code+ "'";
	            System.out.println("locality SQL"+locSql);
	            pstmt = conn.createStatement();
	            rs = pstmt.executeQuery(locSql);
	            if( rs.next())
	            {
	                locSubType = checkNull( rs.getString("LOCALITY_SUBTYPE") );
	                locType = checkNull( rs.getString("LOCALITY_TYPE") );
	                System.out.println("locality SUBTYPE"+locSubType);
	                System.out.println("locality TYPE"+locType);

	            }
	            if(rs!= null)
	            {
	                rs.close();
	                rs=null;
	            }*/

	            // Modified by Vishakha [09/02/2016] to get STAN_CODE__HQ from Employee & ccordingly LOCALITY_TYPE [Start]
		        String emp_stan_hq = checkNull(getFieldValue("STAN_CODE__HQ", "EMPLOYEE", "EMP_CODE", sprs_code, conn));
		        System.out.println("emp_stan_hq -----"+emp_stan_hq);
		        locType = checkNull(getFieldValue("LOCALITY_TYPE", "LOCALITY", "STAN_CODE", emp_stan_hq, conn));
		        System.out.println("locality TYPE-----"+locType);
		     // Modified by Vishakha [09/02/2016] to get STAN_CODE__HQ from Employee & ccordingly LOCALITY_TYPE [End]

		        String locSql = "SELECT LOCALITY_SUBTYPE, LOCALITY_TYPE FROM LOCALITY WHERE LOCALITY_CODE='"+loc_code+ "'";
				System.out.println("locality SQL"+locSql);
				pstmt = conn.createStatement();
				rs = pstmt.executeQuery(locSql);
				if( rs.next())
				{
					locSubType = checkNull( rs.getString("LOCALITY_SUBTYPE") );
					//locType = checkNull( rs.getString("LOCALITY_TYPE") );	// Commented & Modified by Vishakha [09/02/2016] to get avoid LOCALITY_TYPE [End]
					System.out.println("locality SUBTYPE"+locSubType);
					//System.out.println("locality TYPE"+locType);

				}
				if(rs!= null)
				{
					rs.close();
					rs=null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

	          //Added by sachin satre on [31-May-18] for request id : W18BSUN008 as per requirement new station master define and get value from new master if condition as matched. [start]
				String siteCode ="";
				String gradeCode ="";
				String enterPrise ="";
				PreparedStatement pstmt1 = null;

				enterPrise = getEmpSiteAndGrade(sprs_code, conn);
				//gradeCode = getEmpGrade(sprs_code, conn);
				//enterPrise =siteCode.trim()+gradeCode.trim();
				System.out.println("::enterPrise::ff:["+enterPrise+"]");

				String stanMSTSql = "SELECT STAN_TYPE FROM STAN_TYPE_MST WHERE ENTERPRISE = ? AND LOCALITY_TYPE = ? "
						            + " AND LOCALITY_SUB_TYPE = ?  AND ROUTE_TYPE = ?  AND ACTIVE_YN = 'Y' ";

				System.out.println("stanMSTSql SQL"+stanMSTSql);
				pstmt1 = conn.prepareStatement(stanMSTSql);
				pstmt1.setString( 1, enterPrise );
				pstmt1.setString( 2, locType.trim() );
				pstmt1.setString( 3, locSubType.trim() );
				pstmt1.setString( 4, route_type.trim() );
				rs = pstmt1.executeQuery();
				if( rs.next() )
				{
					stanType = checkNull(rs.getString("STAN_TYPE"));
					System.out.println("stanType stanType in master ::["+stanType+"]");
				}
				else
				{
					StringBuffer sb = new StringBuffer();
			        System.out.println("sb "+route_type.trim());
			        sb.append(locType.trim()).append(locSubType.trim()).append(route_type.trim());
			        String code = sb.toString();
			        System.out.println("code"+code);
			        stanType = checkNull((String)stanMapData.get(code));
			        System.out.println("stanType: in stringbuffer:::["+ stanType+"]");
				}
				if(rs!= null)
				{
					rs.close();
					rs=null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//Added by sachin satre on [31-May-18] for request id : W18BSUN008 as per requirement new station master define and get value from new master if condition as matched. [end]

		        System.out.println("return stan type value::["+ stanType+"]");

	            /*StringBuffer sb = new StringBuffer();
	            sb.append(locType.trim()).append(locSubType.trim()).append(route_type.trim());
	            String code = sb.toString();
	            stanType = checkNull((String)stanMapData.get(code));
	            System.out.println("stan type value"+ stanType);*/
	        }
	        catch ( Exception e )
	        {
	            throw new ITMException(e);
	        }
	        finally
	        {
	            try
	            {
	                if (rs != null)
	                {
	                    rs.close();
	                    rs = null;
	                }
	                if ( pstmt != null )
	                {
	                    pstmt.close();
	                    pstmt = null;
	                }
	            }
	            catch(Exception e1){}
	        }

	        return stanType;
	    }
	    //added by sachin satre on [ 31-may-17]for getting the obj_name for validating the locality is active or not [start]
	    public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	    {
		    String objName = "";
		    try
		    {
			    NodeList detailList = null;
			    Node currDetail = null,reqDetail = null;
			    int	detailListLength = 0;
			    detailList = dom.getElementsByTagName("Detail" + currFormNo);
			    detailListLength = detailList.getLength();
			    for (int ctr = 0;ctr < detailListLength;ctr++)
			    {
				    currDetail = detailList.item(ctr);
				    objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				    System.out.println("objNameobjName>>>::asjhdg::["+objName+"]");
				    break;
			    }
			    if(objName == null || objName.trim().length() == 0)
			    {
				    NodeList objNameList = dom.getElementsByTagName("objName");
				    if(objNameList != null && objNameList.getLength() > 0)
				    {
					    Node objNameNode = objNameList.item(0);
					    if(objNameNode != null && objNameNode.getFirstChild() != null)
					    {
					    	objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					    	System.out.println("objNameobjName>>> in anothere if null ::asjhdg::["+objName+"]");
					    }
				    }
			    }
		    }
		    catch(Exception e)
		    {
		    e.printStackTrace();
		    }
		    return objName;
	   }
	  //added by sachin satre on [ 31-may-17]for getting the obj_name for validating the locality is active or not [end]

	//added by nilesh for getting level of salesperson
    public String getEmpGradeLevel( String empCode, Connection conn ) throws Exception
	{
		String selectSql = "";
		String gradeLev = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			selectSql = "SELECT GRADE.LEVEL_NO AS APRV_LEVEL FROM GRADE GRADE, EMPLOYEE EMP WHERE EMP.GRADE = GRADE.GRADE_CODE AND EMP.EMP_CODE = ? AND RELIEVE_DATE IS NULL  ";
			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				gradeLev = checkNull(rs.getString("APRV_LEVEL"));
			}
		}
		catch ( Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}catch(Exception e){}
		}
		System.out.println("gradeLev[getEmpGradeLevel] =["+gradeLev+"]");
		return gradeLev;
	}

    public String getEmpReportTo( String empCode, Connection conn ) throws Exception
	{
		String selectSql = "";
		String reportTo = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			selectSql = "SELECT REPORT_TO FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				reportTo = checkNull(rs.getString("REPORT_TO"));
			}
		}
		catch ( Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}catch(Exception e){}
		}
		System.out.println("gradeLev[getEmpGradeLevel] =["+reportTo+"]");
		return reportTo;
	}
    //added by nilesh for getting level of salesperson
   //Added by sachin satre on [31-May-18] for request id : W18BSUN008 as per requirement new station master define and get value from new master if condition as matched. [start]
   private String getFieldValue(String column,String tableName, String columnName, String columnValue,Connection conn)
   {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String value = null;
		String sql = null;

		sql = " select "+column+" from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
		try
		{
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
			if(rs.next())
			{
				value = rs.getString(1) != null ? rs.getString(1) : " ";
			}
			else
			{
				value = " ";
			}
			rs.close();
			pstmt.close();
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			System.out.println("Exception ::" + exception.getMessage());
		}
		return value;
	}
   //Added by sachin satre on [31-May-18] for request id : W18BSUN008 as per requirement new station master define and get value from new master if condition as matched. [end]
   //Added by sachin satre on [31-May-18] for request id : W18BSUN008 as per requirement new station master define and get value from new master if condition as matched. [start]
  	private String getEmpSiteAndGrade( String empCode, Connection conn ) throws ITMException
  	{
  		System.out.println("inside getEmpSite:::");
  		PreparedStatement pstmt = null;
  		ResultSet rs = null;
  		String empSiteCode = "";
  		String selectSql = "";
  		String empGradeCode = "";
  		String enterPrise ="";
  		try
  		{
  			/*selectSql = "SELECT A.SITE_CODE__DEF AS SITE_CODE FROM USERS A, SITE B " +
  				  "WHERE A.CODE = ? " +
  				  "AND A.SITE_CODE__DEF = B.SITE_CODE " ; */
  			selectSql ="SELECT U.SITE_CODE__DEF AS SITE_CODE , E.GRADE AS GRADE_CODE FROM USERS U, SITE S, EMPLOYEE E , GRADE GD "
  					+ "WHERE U.CODE = E.EMP_CODE AND U.SITE_CODE__DEF = S.SITE_CODE "
  					+ "AND E.GRADE = GD.GRADE_CODE AND E.EMP_CODE = ? ";

  			pstmt = conn.prepareStatement(selectSql);
  			pstmt.setString( 1, empCode );
  			rs = pstmt.executeQuery();
  			if(rs.next())
  			{
  				empSiteCode = checkNull(rs.getString("SITE_CODE"));
  				empGradeCode = checkNull(rs.getString("GRADE_CODE"));
  				enterPrise = empSiteCode+empGradeCode;
  			}
  			System.out.println("empSiteCode:::["+empSiteCode+"]:::empGradeCode::["+empGradeCode+"]::enterPrise:::["+enterPrise+"]");
  			if (rs != null)
  			{
  				rs.close();
  				rs = null;
  			}
  			if ( pstmt != null )
  			{
  				pstmt.close();
  				pstmt = null;
  			}
  		}
  		catch ( Exception e )
  		{
  			throw new ITMException(e);
  		}
  		finally
  		{
  			try
  			{
  				if (rs != null)
  				{
  					rs.close();
  					rs = null;
  				}
  				if ( pstmt != null )
  				{
  					pstmt.close();
  					pstmt = null;
  				}
  			}
  			catch(Exception e1){}
  		}
  		System.out.println("enterPrise:>>>:sas["+enterPrise+"]");
  		return enterPrise;
  	}
  	
  	//added by bhagyashri to list of active station type[12-01-21][start][W20JSUN015]
  /*	private ArrayList getstationType() throws ITMException
  	{
  		ArrayList<String> stationTypelist=new ArrayList<String>();    
		stationTypelist.add("METEX");    
		stationTypelist.add("METFA");    
		stationTypelist.add("METHO");    
		stationTypelist.add("METHQ"); 
		stationTypelist.add("METHX");    
		stationTypelist.add("METMA");    
		stationTypelist.add("METNA");    
		stationTypelist.add("METOT");  
		stationTypelist.add("METTR"); 
		stationTypelist.add("METAO");
		stationTypelist.add("NMTEX");    
		stationTypelist.add("NMTFA");    
		stationTypelist.add("NMTHO");  
		stationTypelist.add("NMTHQ");    
		stationTypelist.add("NMTHX");    
		stationTypelist.add("NMTNA");    
		stationTypelist.add("NMTMA");  
		stationTypelist.add("NMTOT");    
		stationTypelist.add("NMTTR");    
		stationTypelist.add("NMTAO");     
        System.out.println("Station Type list is ::::["+stationTypelist+"]"); 
        return stationTypelist;
  	}*/
  	//added by bhagyashri to list of active station type[12-01-21][end][W20JSUN015]
  	//Added by sachin satre on [31-May-18] for request id : W18BSUN008 as per requirement new station master define and get value from new master if condition as matched. [end]
	//Added by Prasad R. on 03-NOV-2019 -Start
  	private int generateRandomNo()
	{
		return ((int)( Math.random() * 1000000000 ) + 1);
	}
	//Added by Prasad R. on 03-NOV-2019 -End

	// Added by Hariom for duplicate doctor -- 17-Feb-2021 [Start]
	private static Stream<String> getStringStream(String word) {

		Stream<String> deletes = IntStream.range(0, word.length()).mapToObj((i) -> word.substring(0, i) + word.substring(i + 1));
	//System.out.println("word ===="+word);

		Stream<String> replaces = IntStream.range(0, word.length()).boxed().flatMap((i) -> ABC.chars().mapToObj((c) -> word.substring(0, i) + (char) c + word.substring(i + 1)));

		Stream<String> inserts = IntStream.range(0, word.length() + 1).boxed().flatMap((i) -> ABC.chars().mapToObj((c) -> word.substring(0, i) + (char) c + word.substring(i)));

		Stream<String> transposes = IntStream.range(0, word.length() - 1).mapToObj((i) -> word.substring(0, i) + word.substring(i + 1, i + 2) + word.charAt(i) + word.substring(i + 2));

		return Stream.of(deletes, replaces, inserts, transposes).flatMap((x) -> x);

	}


	private static Stream<String> edits1(final String word) {

		return getStringStream(word);

	}


	private static String correct(String word) {

		Optional<String> e1 = known(edits1(word)).max(Comparator.comparingInt(a -> dictionary.get(a)));

		if (e1.isPresent()) return dictionary.containsKey(word) ? word : e1.get();

		Optional<String> e2 = known(edits1(word).map(CusSeriesUploadEJB::edits1).flatMap((x) -> x)).max(Comparator.comparingInt(a -> dictionary.get(a)));

		return (e2.orElse(word));

	}


	private static Stream<String> known(Stream<String> words) {

		return words.filter((word) -> dictionary.containsKey(word));

	}
	// Added by Hariom for duplicate doctor -- 17-Feb-2021 [End]
}

