/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.AuditTrailExtEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ObjTagLocal;
import ibase.webitm.ejb.ObjTagRemote;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ObjTagEJB
implements ObjTagLocal,
ObjTagRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();

    protected InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "\n\nITMException : ObjTagEJB : getInitialContext :==>" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "\n\nException : ObjTagEJB : getInitialContext :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return ctx;
    }

    @Override
    public String getTaggingDtl(String userId, String transDB) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String returnString = "";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                connDriver = null;
                HashMap<String, String> userWiseTagDtlMap = new HashMap<String, String>();
                String sql = "SELECT TAG_ID, TAG_LABEL FROM USER_TAG_SETTING WHERE USER_ID = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String tagId = E12GenericUtility.checkNull(rs.getString(1));
                    String tagDescr = E12GenericUtility.checkNull(rs.getString(2));
                    if (tagId.length() <= 0) continue;
                    userWiseTagDtlMap.put(tagId, tagDescr);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                String filename = "/IBASEHOME" + File.separator + "ibase.xml";
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(filename);
                NodeList parentNodeList = document.getElementsByTagName("TAG_ID");
                Node parentNode = null;
                NodeList childNodeList = null;
                Node childNode = null;
                if (parentNodeList != null && parentNodeList.getLength() > 0) {
                    int i = 0;
                    while (i < parentNodeList.getLength()) {
                        parentNode = parentNodeList.item(i);
                        String tagId = "";
                        if (parentNode.getAttributes().getNamedItem("id") != null) {
                            tagId = parentNode.getAttributes().getNamedItem("id").getNodeValue();
                        }
                        childNodeList = parentNodeList.item(i).getChildNodes();
                        int j = 0;
                        while (j < childNodeList.getLength()) {
                            childNode = childNodeList.item(j);
                            if ("DESCR".equalsIgnoreCase(childNode.getNodeName()) && userWiseTagDtlMap != null && !userWiseTagDtlMap.isEmpty() && userWiseTagDtlMap.containsKey(tagId)) {
                                childNode.getChildNodes().item(0).setNodeValue((String)userWiseTagDtlMap.get(tagId));
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                document.normalize();
                NodeList tagsList = document.getElementsByTagName("TAGS");
                returnString = tagsList != null && tagsList.getLength() > 0 ? new E12GenericUtility().serializeDom(document.getElementsByTagName("TAGS").item(0)) : "";
            }
            catch (Exception e) {
                returnString = e.getMessage();
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "ObjTagEJB : Exception :" + e.getMessage());
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "returnString - [" + returnString + "]");
        return returnString;
    }

    @Override
    public String updateTagTrans(String objName, String refId, String tagOptNValue, String feedData, String userId, String termId, UserInfoBean userInfo, String xmlData) throws ITMException {
        ResultSet rs = null;
        Statement pStamt = null;
        Connection conn = null;
        String returnStr = "";
        try {
            try {
                BaseLogger.log("3", userInfo, null, "In insertTagTrans - objName = [" + objName + "] refId = [" + refId + "] tagOptNValue = [" + tagOptNValue + "]");
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB(userInfo.getTransDB());
                mConnDriver = null;
                String refSer = "";
                if (E12GenericUtility.checkNull(objName).length() > 0 && E12GenericUtility.checkNull(tagOptNValue).length() > 0) {
                    DBAccessEJB dbAccess = new DBAccessEJB();
                    refSer = dbAccess.getRefSer(conn, objName);
                    BaseLogger.log("3", userInfo, null, "refSer = [" + refSer + "]");
                    int updateCnt = 0;
                    String tagId = "";
                    String tagValue = "";
                    String[] tagOptions = tagOptNValue.split(",");
                    int j = 0;
                    while (j < tagOptions.length) {
                        String[] tagOpts = tagOptions[j].trim().split("-");
                        int i = 0;
                        while (i < tagOpts.length) {
                            if (i == 0) {
                                tagId = tagOpts[i];
                            } else {
                                tagValue = tagOpts[i];
                            }
                            ++i;
                        }
                        BaseLogger.log("3", userInfo, null, "tagId = [" + tagId + "] tagValue = [" + tagValue + "]");
                        String[] refIds = refId.split(",");
                        String[] feedDataArr = feedData.split("~~SEP~~");
                        int i2 = 0;
                        while (i2 < refIds.length) {
                            String pkFileldValue = refIds[i2];
                            String feedDataValue = "";
                            if (refIds.length == feedDataArr.length) {
                                feedDataValue = feedDataArr[i2];
                            }
                            BaseLogger.log("3", userInfo, null, "pkFileldValue = [" + pkFileldValue + "]");
                            if (E12GenericUtility.checkNull(tagValue).equalsIgnoreCase("true")) {
                                int chkCnt = 0;
                                String selectTagTrans = "SELECT COUNT(*) FROM TAG_TRANS WHERE REF_SER = ? AND REF_ID = ? AND TAG_ID = ? AND USER_ID = ?";
                                pStamt = conn.prepareStatement(selectTagTrans);
                                pStamt.setString(1, refSer);
                                pStamt.setString(2, pkFileldValue);
                                pStamt.setString(3, tagId);
                                pStamt.setString(4, userId);
                                rs = pStamt.executeQuery();
                                while (rs.next()) {
                                    chkCnt = rs.getInt(1);
                                }
                                if (pStamt != null) {
                                    pStamt.close();
                                    pStamt = null;
                                }
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                                if (chkCnt == 0) {
                                    byte[] tagXmlArray = xmlData != null ? xmlData.getBytes() : null;
                                    ByteArrayInputStream tagXMLStringByteArray = tagXmlArray != null ? new ByteArrayInputStream(tagXmlArray) : null;
                                    String insertTagTrans = "INSERT INTO TAG_TRANS (REF_SER, REF_ID, TAG_ID, USER_ID, FEED_DATA, CHG_DATE, CHG_USER, CHG_TERM, OBJ_NAME,FEED_XML_DATA) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
                                    pStamt = conn.prepareStatement(insertTagTrans);
                                    pStamt.setString(1, refSer);
                                    pStamt.setString(2, pkFileldValue);
                                    pStamt.setString(3, tagId);
                                    pStamt.setString(4, userId);
                                    pStamt.setString(5, feedDataValue);
                                    pStamt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                                    pStamt.setString(7, userId);
                                    pStamt.setString(8, userId);
                                    pStamt.setString(9, objName);
                                    if (tagXMLStringByteArray != null) {
                                        pStamt.setBinaryStream(10, tagXMLStringByteArray, tagXMLStringByteArray.available());
                                    } else {
                                        pStamt.setBinaryStream(10, null, 0);
                                    }
                                    updateCnt += pStamt.executeUpdate();
                                    if (pStamt != null) {
                                        pStamt.close();
                                        pStamt = null;
                                    }
                                    AuditTrailExtEJB auditTrailExt = new AuditTrailExtEJB();
                                    String string = auditTrailExt.saveActionPerformedInAudit(objName, pkFileldValue, "ADD_TAG", "ADD_TAG", userId, termId, userInfo);
                                }
                            } else if (E12GenericUtility.checkNull(tagValue).equalsIgnoreCase("false")) {
                                String deleteTagTrans = "DELETE FROM TAG_TRANS WHERE REF_SER = ? AND REF_ID = ? AND TAG_ID = ? AND USER_ID = ?";
                                pStamt = conn.prepareStatement(deleteTagTrans);
                                pStamt.setString(1, refSer);
                                pStamt.setString(2, pkFileldValue);
                                pStamt.setString(3, tagId);
                                pStamt.setString(4, userId);
                                updateCnt += pStamt.executeUpdate();
                                if (pStamt != null) {
                                    pStamt.close();
                                    pStamt = null;
                                }
                                AuditTrailExtEJB auditTrailExt = new AuditTrailExtEJB();
                                String auditResult = auditTrailExt.saveActionPerformedInAudit(objName, pkFileldValue, "DELETE_TAG", "DELETE_TAG", userId, termId, userInfo);
                                BaseLogger.log("3", userInfo, null, "auditResult - [" + auditResult + "]");
                            }
                            ++i2;
                        }
                        ++j;
                    }
                    BaseLogger.log("3", userInfo, null, "updateCnt - [" + updateCnt + "]");
                    if (updateCnt > 0) {
                        returnStr = "Success";
                        conn.commit();
                    }
                    dbAccess = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : ObjTagEJB : updateTagTrans :" + e.getMessage());
                returnStr = e.getMessage();
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStamt != null) {
                    pStamt.close();
                    pStamt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "ObjTagEJB : Exception :" + e.getMessage());
                e.printStackTrace();
            }
        }
        return returnStr;
    }

    @Override
    public String updateUsrTagSetting(String userId, String tagDtl, String termId, String transDB) throws ITMException {
        Statement pStamt = null;
        ResultSet rs = null;
        Connection conn = null;
        String returnStr = "";
        try {
            try {
                BaseLogger.log("3", null, null, "In insertUsrTagSetting - userId = [" + userId + "] tagId = [" + tagDtl + "]");
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB(transDB);
                mConnDriver = null;
                if (E12GenericUtility.checkNull(tagDtl).length() > 0) {
                    String[] tagDtls = tagDtl.split(",");
                    int i = 0;
                    while (i < tagDtls.length) {
                        String tagId = "";
                        String tagLabel = "";
                        String[] tagIdNLbl = tagDtls[i].split(":");
                        if (tagIdNLbl.length > 1) {
                            tagId = tagIdNLbl[0];
                            tagLabel = tagIdNLbl[1];
                        }
                        String chkUserTagExist = "SELECT COUNT(*) AS COUNT FROM USER_TAG_SETTING WHERE USER_ID = ? AND TAG_ID = ?";
                        pStamt = conn.prepareStatement(chkUserTagExist);
                        pStamt.setString(1, userId);
                        pStamt.setString(2, tagId);
                        rs = pStamt.executeQuery();
                        int chkExistCnt = 0;
                        while (rs.next()) {
                            chkExistCnt = rs.getInt(1);
                        }
                        rs.close();
                        rs = null;
                        pStamt.close();
                        pStamt = null;
                        int updateCnt = 0;
                        if (chkExistCnt == 0) {
                            String insertUserTagSet = "INSERT INTO USER_TAG_SETTING (USER_ID, TAG_ID, TAG_LABEL, CHG_DATE, CHG_USER, CHG_TERM)  VALUES (?, ?, ?, ?, ?, ?)";
                            pStamt = conn.prepareStatement(insertUserTagSet);
                            pStamt.setString(1, userId);
                            pStamt.setString(2, tagId);
                            pStamt.setString(3, tagLabel);
                            pStamt.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                            pStamt.setString(5, userId);
                            pStamt.setString(6, termId);
                            updateCnt = pStamt.executeUpdate();
                        } else {
                            String updateUserTagSet = "UPDATE USER_TAG_SETTING SET TAG_LABEL = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?  WHERE USER_ID = ? AND TAG_ID = ?";
                            pStamt = conn.prepareStatement(updateUserTagSet);
                            pStamt.setString(1, tagLabel);
                            pStamt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                            pStamt.setString(3, userId);
                            pStamt.setString(4, termId);
                            pStamt.setString(5, userId);
                            pStamt.setString(6, tagId);
                            updateCnt = pStamt.executeUpdate();
                        }
                        if (updateCnt > 0) {
                            returnStr = "<Root><Detail>Success</Detail></Root>";
                            conn.commit();
                            returnStr = this.getTaggingDtl(userId, transDB);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : ObjTagEJB : updateUsrTagSetting :" + e.getMessage());
                returnStr = "<Root><Detail>" + e.getMessage() + "</Detail></Root>";
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStamt != null) {
                    pStamt.close();
                    pStamt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "ObjTagEJB : Exception :" + e.getMessage());
                e.printStackTrace();
            }
        }
        return returnStr;
    }

    private String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

