/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserTasksServiceUtility {
    private UserInfoBean userInfo = null;

    public String getUserTasksService(String refser, String refId, String tokenIDfromHeader) throws Exception {
        JSONArray jsonArray;
        block35: {
            BaseLogger.log("3", null, null, "Inside the getUserTasksService():");
            Statement pstmt = null;
            ResultSet resultSet = null;
            Connection connection = null;
            jsonArray = new JSONArray();
            if (this.userInfo == null) {
                APIUtility apiUtility = new APIUtility();
                this.userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
                String transDB = this.userInfo.getTransDB();
                String tableName = "USER_TASKS";
                BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + this.userInfo + "]");
                String query = "SELECT * FROM " + tableName + " WHERE REF_SER = ? AND REF_ID = ?";
                try {
                    try {
                        ConnDriver connDriver = new ConnDriver();
                        connection = connDriver.getConnectDB(transDB);
                        pstmt = connection.prepareStatement(query);
                        pstmt.setString(1, refser);
                        pstmt.setString(2, refId);
                        resultSet = pstmt.executeQuery();
                        ResultSetMetaData metaData = resultSet.getMetaData();
                        int columnCount = metaData.getColumnCount();
                        while (resultSet.next()) {
                            JSONObject jsonObject = new JSONObject();
                            int i = 1;
                            while (i <= columnCount) {
                                String columnName = metaData.getColumnLabel(i);
                                jsonObject.put(columnName, (Object)resultSet.getString(columnName));
                                ++i;
                            }
                            jsonArray.put((Object)jsonObject);
                        }
                    }
                    catch (SQLException e) {
                        BaseLogger.log("3", null, null, "Error occurred while retrieving user tasks: " + e.getMessage());
                        e.printStackTrace();
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (SQLException e3) {
                                e3.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e4) {
                                e4.printStackTrace();
                            }
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        BaseLogger.log("3", null, null, "jsonArray: [" + jsonArray.toString() + "]");
        return jsonArray.toString();
    }

    public String addUserTask(String refId, String refser, String taskDesc, String userIdAssigned, String tokenIDfromHeader) throws ITMException {
        BaseLogger.log("3", null, null, "addUserTask() method is Called ...");
        String userCode = "";
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        UserInfoBean userInfo = null;
        if (userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
        }
        String tranID = commonDBAccessEJB.generateSeq("USER_TASKS_SEQ", 10, userInfo.getTransDB());
        BaseLogger.log("3", null, null, " generated tranID :: " + tranID);
        userCode = userInfo.getLoginCode();
        LocalDate tranDate = LocalDate.now();
        String taskType = "";
        String taskDomain = "";
        String taskCode = "";
        LocalDate expComplDate = LocalDate.now();
        String currStatus = "";
        LocalDate statusDate = LocalDate.now();
        String complRemarks = "";
        LocalDate addDate = LocalDate.now();
        String addUser = "";
        String addTerm = "";
        String chgTerm = "";
        String chgUser = "";
        this.addUserTask(tranID, tranDate, userCode, refId, refser, taskDesc, userIdAssigned, tokenIDfromHeader, taskType, taskDomain, taskCode, expComplDate, currStatus, statusDate, complRemarks, addDate, addUser, addTerm, chgTerm, chgUser);
        return "Success";
    }

    public String addUserTask(String tranID, LocalDate tranDate, String userCode, String refId, String refser, String taskDesc, String userIdAssigned, String tokenIDfromHeader, String taskType, String taskDomain, String taskCode, LocalDate expComplDate, String currStatus, LocalDate statusDate, String complRemarks, LocalDate addDate, String addUser, String addTerm, String chgTerm, String chgUser) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        BaseLogger.log("3", null, null, "addUserTask Called ::");
        ConnDriver connDriver = new ConnDriver();
        try {
            try {
                UserInfoBean userInfo = null;
                if (userInfo == null) {
                    APIUtility apiUtility = new APIUtility();
                    userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
                    BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
                }
                BaseLogger.log("3", null, null, " userCode : [" + userCode + "]");
                String sqlQuery = "INSERT INTO USER_TASKS (TRAN_ID, TRAN_DATE, USER_ID, TASK_DESCR, TASK_TYPE, TASK_DOMAIN, TASK_CODE, USER_ID__ASSIGNED, EXP_COMPL_DATE, CURR_STATUS, STATUS_DATE, COMPL_REMARKS, ADD_DATE, ADD_USER, ADD_TERM, CHG_DATE, CHG_USER, CHG_TERM, REF_SER, REF_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                conn = connDriver.getConnectDB(userInfo);
                pstmt = conn.prepareStatement(sqlQuery);
                pstmt.setString(1, tranID);
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, userCode);
                pstmt.setString(4, taskDesc);
                pstmt.setString(5, taskType);
                pstmt.setString(6, taskDomain);
                pstmt.setString(7, taskCode);
                pstmt.setString(8, userIdAssigned);
                pstmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(10, currStatus);
                pstmt.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(12, complRemarks);
                pstmt.setTimestamp(13, Timestamp.valueOf(LocalDateTime.now()));
                pstmt.setString(14, addUser);
                pstmt.setString(15, addTerm);
                pstmt.setTimestamp(16, Timestamp.valueOf(LocalDateTime.now()));
                pstmt.setString(17, chgUser);
                pstmt.setString(18, chgTerm);
                pstmt.setString(19, refser);
                pstmt.setString(20, refId);
                int insCnt = pstmt.executeUpdate();
                if (insCnt > 0) {
                    conn.commit();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "user_task.writeApiCallLog() Exception message.........:" + E12GenericUtility.getStackTrace(e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "UserTask finally Exception message.........:" + E12GenericUtility.getStackTrace(e));
            }
        }
        return "Insert into USER_TASKS Is Successfull";
    }
}

