/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.SocialEntEJB;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CollabGetGroupsServlet
extends HttpServlet {
    private static final long serialVersionUID = -7447101421551950483L;
    private SocialEntEJB socialEntEJB = null;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String action = request.getParameter("ACTION");
            String userId = "";
            String responseStr = "";
            UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            if (userInfo != null) {
                userId = userInfo.getLoginCode();
                this.socialEntEJB = new SocialEntEJB();
                if ("GET_GROUP_MEMBERS".equalsIgnoreCase(action)) {
                    String groupId = request.getParameter("GROUP_ID");
                    responseStr = this.socialEntEJB.getColabGroupMembers(groupId, userInfo);
                    BaseLogger.log("3", userInfo, null, "\n Response from CollabGetGroupsServlet GET_GROUP_MEMBERS [" + responseStr + "]");
                } else {
                    responseStr = this.socialEntEJB.getColabGroupInfo(userId, userInfo);
                    BaseLogger.log("3", userInfo, null, "\n Response from CollabGetGroupsServlet GET_GROUP_INFO[" + responseStr + "]");
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                    response.setHeader("Cache-Control", "no-cache");
                }
            } else {
                BaseLogger.log("3", userInfo, null, "responseStr in collabGetgroup-[" + responseStr + "]");
                request.getSession().invalidate();
                throw new BaseException(new Exception("SESSION_EXPIRED"));
            }
            response.getWriter().write(responseStr);
        }
        catch (Exception t) {
            BaseLogger.log("0", null, null, "Throwable in doPost:==>" + t.getMessage());
            try {
                t.printStackTrace();
                E12GenericUtility genericUtility = new E12GenericUtility();
                PrintWriter writer = response.getWriter();
                String errMsg = "";
                if (request.getSession().getAttribute("ERR_MSG") == null) {
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                    errMsg = genericUtility.createErrorString(t);
                } else {
                    String sessMsg = (String)request.getSession().getAttribute("ERR_MSG");
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    errMsg = "ERR_MSG :" + sessMsg;
                }
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

