/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.XML2CSVMapping;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSVWriter {
    String objName = null;
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String convert(String xmlDataFile, String metaDataXML, ServletOutputStream outputStream) throws Exception {
        return this.writeXML2CSV(xmlDataFile, metaDataXML, outputStream);
    }

    private String writeXML2CSV(String xmlDataFile, String metaDataXML, ServletOutputStream outputStream) throws Exception {
        Document dom = null;
        Object dom2 = null;
        String errString = "";
        XML2CSVMapping fldMap = new XML2CSVMapping();
        Object errStr = null;
        String xmlData = null;
        FileInputStream inStream = null;
        inStream = new FileInputStream(metaDataXML);
        fldMap = new XML2CSVMapping();
        fldMap.readXML(inStream);
        ArrayList detailList = fldMap.getDetailList();
        try {
            xmlData = xmlDataFile;
            BaseLogger.log("3", null, null, "xmlData = " + xmlData);
            if (xmlData != null && xmlData.trim().length() > 0) {
                dom = this.genericUtility.parseString(xmlData);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        int noOfDetails = 0;
        noOfDetails = detailList.size();
        StringBuffer csvData = new StringBuffer("");
        String str = null;
        int index = 0;
        while (index < noOfDetails) {
            XML2CSVMapping.Detail csvDetail = null;
            csvDetail = (XML2CSVMapping.Detail)detailList.get(index);
            str = this.writeCsv(dom, csvDetail, outputStream);
            csvData.append(str);
            ++index;
        }
        str = csvData.toString();
        BaseLogger.log("2", null, null, "str =  " + str);
        return str;
    }

    private String writeCsv(Document dom, XML2CSVMapping.Detail csvDetail, ServletOutputStream outputStream) throws Exception {
        Object errStr = null;
        StringBuffer csvDataBuf = new StringBuffer("");
        ArrayList mappingList = null;
        String objContext = null;
        Object DetailName = null;
        Object vOffset = null;
        Object hOffset = null;
        Object fldSrc = null;
        Object destLocation = null;
        Object destLabel = null;
        mappingList = csvDetail.mappingList;
        objContext = csvDetail.objCtx;
        HashMap dataMap = new HashMap();
        int mappingListLen = mappingList.size();
        XML2CSVMapping.MappingRec rec = null;
        String prefix = null;
        String recordseperator = null;
        String fldName = null;
        String fldValue = null;
        String numberFormat = null;
        String dateFormat = null;
        String constVal = null;
        NodeList nLst = dom.getElementsByTagName("Detail" + objContext);
        Node node = null;
        BaseLogger.log("2", null, null, "csvDetail.prefix :: " + csvDetail.prefix);
        prefix = csvDetail.prefix;
        recordseperator = csvDetail.recordseperator;
        BaseLogger.log("2", null, null, "csvDetail.recordseperator :: " + csvDetail.recordseperator);
        int nodeListLen = nLst.getLength();
        BaseLogger.log("2", null, null, "nodeListLen :: " + nodeListLen);
        int index = 0;
        while (index < nodeListLen) {
            if (prefix != null && prefix.trim().length() > 0) {
                csvDataBuf.append(prefix);
                csvDataBuf.append(",");
            }
            node = nLst.item(index);
            int mapIndex = 0;
            while (mapIndex < mappingListLen) {
                rec = (XML2CSVMapping.MappingRec)mappingList.get(mapIndex);
                fldName = rec.fldSrc;
                numberFormat = rec.numberFormat;
                dateFormat = rec.dateFormat;
                constVal = rec.constVal;
                if (fldName != null && fldName.trim().length() > 0) {
                    fldValue = this.genericUtility.getColumnValueFromNode(fldName, node);
                }
                if (fldValue != null && fldValue.trim().length() > 0 && !fldValue.trim().equalsIgnoreCase("blank")) {
                    if (numberFormat != null && numberFormat.trim().length() > 0) {
                        fldValue = this.getNumInCustomFormat(Double.parseDouble(fldValue), numberFormat);
                    }
                    if (dateFormat != null && dateFormat.trim().length() > 0) {
                        fldValue = this.getDateInFormat(fldValue, dateFormat);
                    }
                }
                if (constVal != null && constVal.trim().length() > 0) {
                    fldValue = constVal.equalsIgnoreCase("blank") ? "" : constVal;
                }
                BaseLogger.log("3", null, null, "( fldName, fldValue ) :: ( " + fldName + ", " + fldValue + " )");
                csvDataBuf.append(fldValue != null && fldValue.trim().length() > 0 ? fldValue.trim() : "");
                csvDataBuf.append(",");
                ++mapIndex;
            }
            csvDataBuf.deleteCharAt(csvDataBuf.length() - 1);
            if (recordseperator != null && recordseperator.trim().length() > 0) {
                csvDataBuf.append(recordseperator.trim());
            }
            csvDataBuf.append(index < nodeListLen ? "\n" : "");
            ++index;
        }
        return csvDataBuf.toString();
    }

    private String getDateInFormat(String date, String format) {
        String currDate = null;
        Date dt = null;
        SimpleDateFormat sdf = null;
        String srcformat = "yyyy-MM-dd";
        try {
            sdf = new SimpleDateFormat(srcformat);
            dt = sdf.parse(date);
            sdf = new SimpleDateFormat(format);
            currDate = sdf.format(dt);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception in getCurrdateWoTimeInDBFormat :::" + e.getMessage());
        }
        return currDate;
    }

    private String getNumInCustomFormat(double num, String format) {
        return new DecimalFormat(format).format(num);
    }
}

