/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility.wiz;

import ibase.utility.BaseLogger;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wiz.Column;
import ibase.webitm.utility.wiz.GroupBox;
import ibase.webitm.utility.wiz.TextObject;
import ibase.webitm.utility.wiz.TransactionCoreModelImplSax;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TransactionSaxTransformer
extends DefaultHandler {
    HashMap tagValueMap = null;
    HashMap attribValueMap = null;
    HashMap colNameObjMap = null;
    ArrayList toReadObjList = null;
    String parentTag = "";
    String curTagName = "";
    String curTagValue = "";
    String formNo = "";
    int colId;
    int itemCnt;
    boolean isFont = false;
    TransactionCoreModelImplSax tranCoreImplObj = null;

    public TransactionSaxTransformer(TransactionCoreModelImplSax tranCoreImplObj) {
        this.tranCoreImplObj = tranCoreImplObj;
    }

    public void parse(File metaDataFileName) throws SAXException {
        try {
            BaseLogger.log("3", null, null, "Parsing started for :" + metaDataFileName);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(metaDataFileName, (DefaultHandler)this);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.tagValueMap = null;
            this.attribValueMap = null;
            this.parentTag = "";
            this.curTagName = "";
            this.curTagValue = "";
            this.colId = 0;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String tagName, Attributes atts) throws SAXException {
        if (tagName.equalsIgnoreCase("table_column") || tagName.equalsIgnoreCase("GroupBox") || tagName.equalsIgnoreCase("ColumnObject") || tagName.equalsIgnoreCase("TextObject")) {
            this.tagValueMap = new HashMap();
            this.attribValueMap = new HashMap();
            this.parentTag = tagName;
        } else if (tagName.equalsIgnoreCase("type")) {
            if (atts.getLength() > 0) {
                this.attribValueMap = new HashMap();
                this.attribValueMap.put(atts.getQName(0), atts.getValue(0));
            }
        } else if (tagName.equalsIgnoreCase("font")) {
            this.isFont = true;
        } else if (tagName.equalsIgnoreCase("values")) {
            this.itemCnt = 0;
        } else if (tagName.equalsIgnoreCase("item")) {
            if (atts.getLength() > 0) {
                if (this.attribValueMap == null) {
                    this.attribValueMap = new HashMap();
                }
                ++this.itemCnt;
                int attCnt = 0;
                while (attCnt < atts.getLength()) {
                    this.attribValueMap.put(String.valueOf(atts.getQName(attCnt)) + this.itemCnt, atts.getValue(attCnt));
                    ++attCnt;
                }
            }
        } else if (tagName.equalsIgnoreCase("EditStyle")) {
            this.attribValueMap.put("style", atts.getValue("style"));
        } else if (tagName.equalsIgnoreCase("grid.lines")) {
            this.tranCoreImplObj.setGridStructure(true);
        } else if (tagName.equalsIgnoreCase("protect") && atts.getLength() > 0) {
            if (this.attribValueMap == null) {
                this.attribValueMap = new HashMap();
            }
            this.attribValueMap.put(atts.getQName(0), atts.getValue(0));
        }
        this.curTagName = tagName;
        this.curTagValue = new String();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String tagContent = new String(ch, start, length);
            this.curTagValue = String.valueOf(this.curTagValue) + tagContent;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String tagName) throws SAXException {
        try {
            if (this.parentTag.equals("table_column") || this.parentTag.equals("GroupBox") || this.parentTag.equalsIgnoreCase("ColumnObject") || this.parentTag.equalsIgnoreCase("TextObject")) {
                if (this.isFont) {
                    this.tagValueMap.put("Font" + this.curTagName, this.curTagValue);
                } else {
                    this.tagValueMap.put(this.curTagName, this.curTagValue);
                }
            }
            if (tagName.equals("table_column") && this.toReadObjList.contains("table_column")) {
                ++this.colId;
                this.createColObjForTableColumn(this.tagValueMap, this.attribValueMap);
            } else if (tagName.equals("GroupBox") && this.toReadObjList.contains("GroupBox")) {
                this.createGroupBox(this.tagValueMap, this.attribValueMap);
            } else if (tagName.equals("TextObject") && this.toReadObjList.contains("TextObject")) {
                this.createTextObject(this.tagValueMap, this.attribValueMap, false);
            } else if (tagName.equals("ColumnObject") && this.toReadObjList.contains("ColumnObject")) {
                this.createColObjForColumnObject(this.tagValueMap, this.attribValueMap);
            } else if (tagName.equalsIgnoreCase("font")) {
                this.isFont = false;
            }
            if (tagName.equals("TextObject") && this.toReadObjList.contains("BrowInfo")) {
                this.createTextObject(this.tagValueMap, this.attribValueMap, true);
            }
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    public void setColNameObjMap(HashMap colNameObjMap) {
        this.colNameObjMap = colNameObjMap;
    }

    public void setToReadObjList(ArrayList toReadObjList) {
        this.toReadObjList = toReadObjList;
    }

    private boolean createColObjForTableColumn(HashMap tagValueMap, HashMap attribValueMap) throws ITMException {
        boolean colObjCreated = false;
        try {
            Column colObj = new Column();
            Object attribObj = null;
            colObj.setColID(this.colId);
            if (tagValueMap.get("type") != null) {
                colObj.setColType(tagValueMap.get("type").toString().trim());
            }
            if (this.attribValueMap != null) {
                if (this.attribValueMap.get("size") != null) {
                    colObj.setSize(Integer.parseInt(this.attribValueMap.get("size").toString().trim()));
                }
                if (this.itemCnt > 0) {
                    HashMap<String, String> valuesMap = new HashMap<String, String>();
                    int i = 1;
                    while (i <= this.itemCnt) {
                        String display = this.attribValueMap.get("display" + i).toString().trim();
                        String data = this.attribValueMap.get("data" + i).toString().trim();
                        valuesMap.put(display, data);
                        ++i;
                    }
                    colObj.setCompType('C');
                    colObj.setValuesMap(valuesMap);
                    this.itemCnt = 0;
                }
            }
            if (tagValueMap.get("dbname") != null) {
                colObj.setPhysicalName(tagValueMap.get("dbname").toString().trim());
            }
            if (tagValueMap.get("updatewhereclause") != null) {
                colObj.setUpdateWhereClause(tagValueMap.get("updatewhereclause").toString().trim().equals("yes"));
            }
            if (tagValueMap.get("update") != null) {
                colObj.setUpdate(tagValueMap.get("update").toString().trim());
            }
            if (tagValueMap.get("key") != null) {
                colObj.setKey(tagValueMap.get("key").toString().trim().equals("yes"));
            }
            if (tagValueMap.get("name") != null) {
                Column otherColPropObj;
                String colLogicalName = tagValueMap.get("name").toString();
                colObj.setLogicalName(colLogicalName);
                colObj.setBrowName(colLogicalName);
                colObj.setDisplayName(colLogicalName);
                colObj.setType("Column");
                if (this.colNameObjMap != null && (otherColPropObj = (Column)this.colNameObjMap.get(colLogicalName)) != null) {
                    colObj.setPopUpExists(otherColPropObj.getPopUpExists());
                    colObj.setPopUpParam(otherColPropObj.getPopUpParam());
                    colObj.setPopUpSource(otherColPropObj.getPopUpSource());
                    colObj.setPopUpObjName(otherColPropObj.getPopUpObjName());
                    colObj.setPopUpColNames(otherColPropObj.getPopUpColNames());
                    colObj.setFilterString(otherColPropObj.getFilterString());
                    colObj.setSrvCallOnChange(otherColPropObj.getSrvCallOnChange());
                    colObj.setMultiOptionPopUp(otherColPropObj.getMultiOptionPopUp());
                    colObj.setHelpOption(otherColPropObj.getHelpOption());
                }
            }
            if (colObj.getSQLPos() == -1) {
                colObj.setSQLPos(this.colId - 1);
            }
            this.tranCoreImplObj.addColumn(this.formNo, colObj.getLogicalName(), colObj);
            colObjCreated = true;
        }
        catch (Exception e) {
            colObjCreated = false;
            throw new ITMException(e);
        }
        return colObjCreated;
    }

    private boolean createColObjForColumnObject(HashMap tagValueMap, HashMap attribValueMap) throws ITMException {
        boolean colObjCreated = false;
        try {
            Column colObj = null;
            if (tagValueMap.get("name") != null) {
                String colLogicalName = tagValueMap.get("name").toString();
                colObj = this.tranCoreImplObj.getColumn(this.formNo, colLogicalName);
            }
            if (colObj != null) {
                int x = -1;
                int y = -1;
                if (tagValueMap.get("band") != null) {
                    colObj.setBand(tagValueMap.get("band").toString().trim());
                }
                if (tagValueMap.get("format") != null) {
                    colObj.setFormat(tagValueMap.get("format").toString().trim());
                }
                if (tagValueMap.get("alignment") != null) {
                    colObj.setAlignment(Integer.parseInt(tagValueMap.get("alignment").toString().trim()));
                }
                if (tagValueMap.get("tabsequence") != null) {
                    colObj.setTabSequence(Integer.parseInt(tagValueMap.get("tabsequence").toString().trim()));
                    if (colObj.getTabSequence() == 32766) {
                        colObj.setProtectedType(1);
                    } else {
                        colObj.setProtectedType(0);
                    }
                }
                if (tagValueMap.get("protect") != null) {
                    String protectStr = attribValueMap.get("expression").toString().trim();
                    try {
                        colObj.setProtectedType(Integer.parseInt(protectStr));
                    }
                    catch (NumberFormatException numEx) {
                        BaseLogger.log("3", null, null, "TransactionSaxTransformer Captured because expr in protect currently not supported ");
                    }
                }
                if (tagValueMap.get("color") != null) {
                    colObj.setColor(Integer.parseInt(tagValueMap.get("color").toString().trim()));
                }
                if (tagValueMap.get("x") != null) {
                    x = Integer.parseInt(tagValueMap.get("x").toString().trim());
                    colObj.setX(x);
                }
                if (tagValueMap.get("y") != null) {
                    y = Integer.parseInt(tagValueMap.get("y").toString().trim());
                    colObj.setY(y);
                }
                if ("yes".equals(tagValueMap.get("autovscroll"))) {
                    colObj.setScrollProperty("VSCROLL");
                }
                if (tagValueMap.get("height") != null) {
                    colObj.setHeight(Integer.parseInt(tagValueMap.get("height").toString().trim()));
                }
                if (tagValueMap.get("width") != null) {
                    colObj.setWidth(Integer.parseInt(tagValueMap.get("width").toString().trim()));
                }
                if (tagValueMap.get("visible") != null) {
                    colObj.setVisible(Integer.parseInt(tagValueMap.get("visible").toString().trim()));
                }
                if (tagValueMap.get("limit") != null) {
                    colObj.setLimit(Integer.parseInt(tagValueMap.get("limit").toString().trim()));
                }
                if (tagValueMap.get("case") != null) {
                    colObj.setEditCase((char)(tagValueMap.get("case").toString().trim().equalsIgnoreCase("upper") ? 85 : (tagValueMap.get("case").toString().trim().equalsIgnoreCase("lower") ? 76 : 65)));
                }
                if (tagValueMap.get("required") != null) {
                    colObj.setIsRequired(tagValueMap.get("required").toString().trim().equalsIgnoreCase("yes"));
                }
                if (tagValueMap.get("text") != null) {
                    colObj.setText(tagValueMap.get("text").toString());
                }
                if (attribValueMap.get("style") != null) {
                    colObj.setCompType((char)(attribValueMap.get("style").equals("ddlb") ? 67 : (attribValueMap.get("style").equals("checkbox") ? 66 : 84)));
                }
                if (tagValueMap.get("mask") != null && colObj != null && colObj.getColType().equalsIgnoreCase("dateTime")) {
                    if (((String)tagValueMap.get("mask")).toLowerCase().indexOf("hh:mm") != -1) {
                        colObj.setColType("dateTime");
                    } else {
                        colObj.setColType("date");
                    }
                }
                if (x >= 0 && y >= 0) {
                    colObj.setGrpName(this.tranCoreImplObj.getGroupNameForPos(this.formNo, x, y));
                }
            }
            colObjCreated = true;
        }
        catch (Exception e) {
            colObjCreated = false;
            throw new ITMException(e);
        }
        return colObjCreated;
    }

    private boolean createTextObject(HashMap tagValueMap, HashMap attribValueMap, boolean setBrowInfo) throws ITMException {
        boolean textObjCreated = false;
        try {
            String textName = null;
            if (!setBrowInfo) {
                TextObject textObj = new TextObject();
                int x = -1;
                int y = -1;
                if (tagValueMap.get("band") != null) {
                    textObj.setBand(tagValueMap.get("band").toString().trim());
                }
                if (tagValueMap.get("name") != null) {
                    textName = tagValueMap.get("name").toString().trim();
                    textObj.setName(textName);
                    textObj.setType("TextObject");
                }
                if (tagValueMap.get("text") != null) {
                    Column colObj;
                    textObj.setText(tagValueMap.get("text").toString());
                    if (textName.indexOf("_t") != -1 && (colObj = this.tranCoreImplObj.getColumn(this.formNo, textName.substring(0, textName.indexOf("_t")))) != null) {
                        colObj.setDisplayName(textObj.getText());
                    }
                }
                if (tagValueMap.get("face") != null) {
                    textObj.setFontFace(tagValueMap.get("face").toString().trim());
                }
                if (tagValueMap.get("Fontheight") != null) {
                    textObj.setFontHeight(Integer.parseInt(tagValueMap.get("Fontheight").toString().trim()));
                }
                if (tagValueMap.get("Fontweight") != null) {
                    textObj.setFontWeight(Integer.parseInt(tagValueMap.get("Fontweight").toString().trim()));
                }
                if (tagValueMap.get("Fontfamily") != null) {
                    textObj.setFontFamily(Integer.parseInt(tagValueMap.get("Fontfamily").toString().trim()));
                }
                if (tagValueMap.get("Fontpitch") != null) {
                    textObj.setFontPitch(Integer.parseInt(tagValueMap.get("Fontpitch").toString().trim()));
                }
                if (tagValueMap.get("Fontcharset") != null) {
                    textObj.setFontCharset(Integer.parseInt(tagValueMap.get("Fontcharset").toString().trim()));
                }
                if (tagValueMap.get("border") != null) {
                    textObj.setBorder(Integer.parseInt(tagValueMap.get("border").toString().trim()));
                }
                if (tagValueMap.get("x") != null) {
                    x = Integer.parseInt(tagValueMap.get("x").toString().trim());
                    textObj.setX(x);
                }
                if (tagValueMap.get("y") != null) {
                    y = Integer.parseInt(tagValueMap.get("y").toString().trim());
                    textObj.setY(y);
                }
                if (tagValueMap.get("height") != null) {
                    textObj.setHeight(Integer.parseInt(tagValueMap.get("height").toString().trim()));
                }
                if (tagValueMap.get("width") != null) {
                    textObj.setWidth(Integer.parseInt(tagValueMap.get("width").toString().trim()));
                }
                if (tagValueMap.get("visible") != null) {
                    textObj.setVisible(Integer.parseInt(tagValueMap.get("visible").toString().trim()));
                }
                if (tagValueMap.get("alignment") != null) {
                    textObj.setAlignment(Integer.parseInt(tagValueMap.get("alignment").toString().trim()));
                }
                if (tagValueMap.get("color") != null) {
                    textObj.setColor(Long.parseLong(tagValueMap.get("color").toString().trim()));
                }
                if (tagValueMap.get("mode") != null) {
                    textObj.setColor(Integer.parseInt(tagValueMap.get("mode").toString().trim()));
                }
                if (tagValueMap.get("color") != null) {
                    textObj.setColor(Long.parseLong(tagValueMap.get("color").toString().trim()));
                }
                if (tagValueMap.get("valueishtml") != null) {
                    textObj.setColor(Integer.parseInt(tagValueMap.get("valueishtml").toString().trim()));
                }
                if (x >= 0 && y >= 0) {
                    textObj.setGrpName(this.tranCoreImplObj.getGroupNameForPos(this.formNo, x, y));
                }
                textObjCreated = this.tranCoreImplObj.addTextObject(this.formNo, textObj.getName(), textObj);
            } else {
                Column colObj = null;
                if (tagValueMap.get("name") != null && (textName = tagValueMap.get("name").toString().trim()).endsWith("_t")) {
                    colObj = this.tranCoreImplObj.getColumn(this.formNo, textName.substring(0, textName.lastIndexOf("_t")));
                }
                if (colObj != null) {
                    if (tagValueMap.get("text") != null) {
                        colObj.setDisplayName(tagValueMap.get("text").toString());
                        colObj.setBrowName(tagValueMap.get("text").toString());
                    }
                    if (tagValueMap.get("x") != null) {
                        colObj.setBrowPos(Integer.parseInt(tagValueMap.get("x").toString().trim()));
                    }
                }
            }
            textObjCreated = true;
        }
        catch (Exception e) {
            textObjCreated = false;
            e.printStackTrace();
            throw new ITMException(e);
        }
        return textObjCreated;
    }

    private boolean createGroupBox(HashMap tagValueMap, HashMap attribValueMap) throws ITMException {
        boolean groupBoxCreated = false;
        try {
            GroupBox grpBoxObj = new GroupBox();
            if (tagValueMap.get("band") != null) {
                grpBoxObj.setBand(tagValueMap.get("band").toString().trim());
            }
            if (tagValueMap.get("text") != null) {
                grpBoxObj.setText(tagValueMap.get("text").toString().trim());
            }
            if (tagValueMap.get("name") != null) {
                grpBoxObj.setName(tagValueMap.get("name").toString().trim());
            }
            if (tagValueMap.get("face") != null) {
                grpBoxObj.setFontFace(tagValueMap.get("face").toString().trim());
            }
            if (tagValueMap.get("Fontheight") != null) {
                grpBoxObj.setFontHeight(Integer.parseInt(tagValueMap.get("Fontheight").toString().trim()));
            }
            if (tagValueMap.get("Fontweight") != null) {
                grpBoxObj.setFontWeight(Integer.parseInt(tagValueMap.get("Fontweight").toString().trim()));
            }
            if (tagValueMap.get("Fontfamily") != null) {
                grpBoxObj.setFontFamily(Integer.parseInt(tagValueMap.get("Fontfamily").toString().trim()));
            }
            if (tagValueMap.get("Fontpitch") != null) {
                grpBoxObj.setFontPitch(Integer.parseInt(tagValueMap.get("Fontpitch").toString().trim()));
            }
            if (tagValueMap.get("Fontcharset") != null) {
                grpBoxObj.setFontCharset(Integer.parseInt(tagValueMap.get("Fontcharset").toString().trim()));
            }
            if (tagValueMap.get("border") != null) {
                grpBoxObj.setBorder(Integer.parseInt(tagValueMap.get("border").toString().trim()));
            }
            if (tagValueMap.get("x") != null) {
                grpBoxObj.setX(Integer.parseInt(tagValueMap.get("x").toString().trim()));
            }
            if (tagValueMap.get("y") != null) {
                grpBoxObj.setY(Integer.parseInt(tagValueMap.get("y").toString().trim()));
            }
            if (tagValueMap.get("height") != null) {
                grpBoxObj.setHeight(Integer.parseInt(tagValueMap.get("height").toString().trim()));
            }
            if (tagValueMap.get("width") != null) {
                grpBoxObj.setWidth(Integer.parseInt(tagValueMap.get("width").toString().trim()));
            }
            if (tagValueMap.get("visible") != null) {
                grpBoxObj.setVisible(Integer.parseInt(tagValueMap.get("visible").toString().trim()));
            }
            if (tagValueMap.get("color") != null) {
                grpBoxObj.setColor(Long.parseLong(tagValueMap.get("color").toString().trim()));
            }
            if (tagValueMap.get("mode") != null) {
                grpBoxObj.setColor(Integer.parseInt(tagValueMap.get("mode").toString().trim()));
            }
            if (tagValueMap.get("color") != null) {
                grpBoxObj.setColor(Long.parseLong(tagValueMap.get("color").toString().trim()));
            }
            groupBoxCreated = this.tranCoreImplObj.addGroupBox(this.formNo, grpBoxObj.getName(), grpBoxObj);
            groupBoxCreated = true;
        }
        catch (Exception e) {
            groupBoxCreated = false;
            throw new ITMException(e);
        }
        return groupBoxCreated;
    }
}

