/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.ejb.UserEventLogEJB;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMTransactionCoreModel;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ITMItemChangeServlet
extends ITMAuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    InitialContext ctx = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Object outputStream = null;
        String responseStr = "";
        UserEventLogEJB userEventLogEJB = new UserEventLogEJB();
        UserInfoBean userInfo = null;
        String objName = "";
        String tempEditorId = "";
        String actionMode = "";
        String tranId = "";
        HashMap<String, String> pgContexAndObj = null;
        Date startTime = new Date();
        try {
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                HttpSession session = request.getSession();
                BaseLogger.log("3", null, null, "sess.getId :[" + session.getId() + "]");
                ITMTransactionCoreModel itmTransCoreMdl = null;
                String coreModelID = request.getParameter("CORE_MDL_ID");
                if ("null".equalsIgnoreCase(coreModelID) || "".equals(coreModelID) || coreModelID == null) {
                    responseStr = "Invalid Session Context";
                } else {
                    itmTransCoreMdl = (ITMTransactionCoreModel)session.getAttribute(coreModelID);
                }
                objName = request.getParameter("OBJ_NAME");
                if ("null".equalsIgnoreCase(objName) || "".equals(objName) || objName == null) {
                    objName = itmTransCoreMdl.getObjName();
                }
                itmTransCoreMdl.masterStateful.setEditorId(coreModelID);
                String chgXMLStr = request.getParameter("XML_STR");
                String objContext = E12GenericUtility.checkNull(request.getParameter("OBJ_CONTEXT"));
                String focusedCol = E12GenericUtility.checkNull(request.getParameter("FOCUSED_COL"));
                if (this.ctx == null) {
                    AppConnectParm appConnect = new AppConnectParm();
                    this.ctx = new InitialContext(appConnect.getProperty());
                }
                userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
                DBAccessEJB dbAccess = new DBAccessEJB();
                ArrayList itemChangeList = null;
                tranId = itmTransCoreMdl.masterStateful.getTranId();
                String editFlag = itmTransCoreMdl.editFlag;
                String editorId = itmTransCoreMdl.masterStateful.getEditorId();
                if (userEventLogEJB != null && userInfo != null) {
                    tempEditorId = editorId;
                    if (editorId != null && editorId.indexOf(userInfo.getLoginCode()) != -1) {
                        tempEditorId = editorId.substring(0, editorId.indexOf(userInfo.getLoginCode()));
                    }
                    pgContexAndObj = this.getObjCtxAndPgCtx(chgXMLStr);
                    actionMode = "VIEW";
                    if (editFlag.equals("A")) {
                        actionMode = "ADD";
                    } else if (editFlag.equals("E")) {
                        actionMode = "EDIT";
                    }
                    userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode, "item change", startTime, null, "pageContext:[" + pgContexAndObj.get("pageContext") + "], objContext:[" + pgContexAndObj.get("objContext") + "]", tranId, "Pending", "SA", "");
                    pgContexAndObj = null;
                }
                if (dbAccess != null && (itemChangeList = dbAccess.getItemChangeElementList(objName, objContext, userInfo)) != null && itemChangeList.contains(focusedCol)) {
                    itmTransCoreMdl.masterStateful.setUserInfo(userInfo);
                    responseStr = this.getItemChange(objName, chgXMLStr, itmTransCoreMdl);
                }
                if (userEventLogEJB != null && userInfo != null) {
                    tempEditorId = editorId;
                    if (editorId != null && editorId.indexOf(userInfo.getLoginCode()) != -1) {
                        tempEditorId = editorId.substring(0, editorId.indexOf(userInfo.getLoginCode()));
                    }
                    pgContexAndObj = this.getObjCtxAndPgCtx(chgXMLStr);
                    actionMode = "VIEW";
                    if (editFlag.equals("A")) {
                        actionMode = "ADD";
                    } else if (editFlag.equals("E")) {
                        actionMode = "EDIT";
                    }
                    userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode, "item change", startTime, new Date(), "pageContext:[" + pgContexAndObj.get("pageContext") + "], objContext:[" + pgContexAndObj.get("objContext") + "]", tranId, "Success", "SA", "");
                    pgContexAndObj = null;
                } else {
                    BaseLogger.log("3", userInfo, editorId, " ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
                }
                response.setBufferSize(1024);
                response.setContentType("text/html;charset=" + CommonConstants.ENCODING);
                ServletOutputStream outStream = response.getOutputStream();
                outStream.write(responseStr.getBytes());
                outStream.flush();
                outStream.close();
                dbAccess = null;
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            try {
                userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode, "item change", startTime, new Date(), "pageContext:[" + (String)pgContexAndObj.get("pageContext") + "], objContext:[" + (String)pgContexAndObj.get("objContext") + "]", tranId, "Exception", "SA", itme.getMessage());
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                itme.printStackTrace(new PrintStream(baos));
                response.setContentLength(baos.toString().length());
                writer.println(baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ITMException ie = new ITMException(e);
                userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode, "item change", startTime, new Date(), "pageContext:[" + (String)pgContexAndObj.get("pageContext") + "], objContext:[" + (String)pgContexAndObj.get("objContext") + "]", tranId, "Exception", "SA", ie.getMessage());
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                String errMsg = "";
                response.setContentLength(baos.toString().length());
                writer.println("ERR_MSG :" + errMsg + "\n" + baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getItemChange(String objName, String xmlStr, ITMTransactionCoreModel itmTransCoreMdl) throws Exception, ITMException {
        String retVal = "";
        try {
            retVal = itmTransCoreMdl.masterStateful.validateAndPerformAction(xmlStr, "ITEM_CHANGE");
        }
        catch (ITMException itme) {
            retVal = itme.getMessage();
        }
        catch (Exception e) {
            retVal = e.getMessage();
        }
        return retVal;
    }

    private HashMap<String, String> getObjCtxAndPgCtx(String chgXMLStr) {
        HashMap<String, String> objPgCtx = new HashMap<String, String>();
        try {
            Document document = new E12GenericUtility().parseString(chgXMLStr);
            NodeList nodes = document.getElementsByTagName("header");
            int index = 0;
            while (index < nodes.getLength()) {
                Element element = (Element)nodes.item(index);
                NodeList nodeList = element.getElementsByTagName("pageContext");
                Element line = (Element)nodeList.item(0);
                objPgCtx.put("pageContext", this.getCharacterDataFromElement(line));
                NodeList title = element.getElementsByTagName("objContext");
                line = (Element)title.item(0);
                objPgCtx.put("objContext", this.getCharacterDataFromElement(line));
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objPgCtx;
    }

    private String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }
}

