package ibase.webitm.utility.wsfa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import javax.naming.InitialContext;

import ibase.webitm.utility.E12ExternalAPICall;
import org.json.JSONArray;
import org.json.JSONObject;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.fieldsales.ProductionSFAToSAPService;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetDCRWizard;
import ibase.webitm.ejb.fieldsales.ProductionSFAToSAPAPICalling;
import ibase.webitm.utility.ITMException;
import sun.security.krb5.internal.APOptions;

public class ApiReinitializ extends ActionHandlerEJB
{
    private E12GenericUtility e12GenericUtility = new E12GenericUtility();

    public String reinitalizeAPICall(String actionTranID,String xtraParam,String forcedFlag) throws ITMException
	{
		System.out.println("inside SalesSFAToSAPService callTheJsonCaseWise");
		PreparedStatement pstmt=null;
		PreparedStatement pstmt1=null;
		OrgStructure orgStructure=new OrgStructure();
		ResultSet rs1=null;
		ResultSet rs=null;
        UserInfoBean userInfo = null;
        String enterprise="";
		//JSONObject obj = new JSONObject();
		String returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
		Connection conn = null;
		boolean isError = false;
		boolean isLocalConn = false;

		try
		{
			SalesSFAToSAPService salesSFAToSAPService = new SalesSFAToSAPService();
			
			String userId = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginCode");
			String aproverEmpCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginEmpCode");
			if(aproverEmpCode==null || aproverEmpCode.trim().length()==0)
			{
				aproverEmpCode=getEmpCode(userId,conn);
			}
			if ( getUserInfo() == null )
			{
				CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
				setUserInfo( commonDBAccessEJB.createUserInfo( userId ) );
			}
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
				conn.setAutoCommit( false );
			}
            userInfo = getUserInfo();
            if(userInfo!=null)
            {
            	enterprise=userInfo.getEnterprise();
            }
            
            
            String resultType="",refID="",objName="";
			String sql="SELECT RESULT_TYPE,REF_ID,OBJ_NAME FROM FOLLOW_UP_ACTIONS_LOGS WHERE TRAN_ID=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, actionTranID);

			rs = pstmt.executeQuery();
			if(rs.next())
			{
				resultType=checkNull(rs.getString("RESULT_TYPE"));
				refID=checkNull(rs.getString("REF_ID"));
				objName=checkNull(rs.getString("OBJ_NAME"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			String loadNo = getLoadNo(refID, conn);
			
			if("strg_meet_dcr_wiz".equalsIgnoreCase(objName))
			{
				HashMap<String,String> transactioApiName = new HashMap<String,String>();
				HashMap<String,String> refWiseApiName = new HashMap<String,String>();
	
				int totalAPICallCnt = 0;
				int apiFailedCnt=0;
				
				String apiCallCntSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=?  ";
				pstmt = conn.prepareStatement(apiCallCntSql);
				pstmt.setString(1, refID);
				pstmt.setString(2, enterprise);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totalAPICallCnt=rs.getInt("COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				if( (resultType != null && !"S".equalsIgnoreCase(resultType)) && totalAPICallCnt == 0 )
				{
					
					returnValue = salesSFAToSAPService.callTheJsonCaseWise (refID, xtraParam, conn);
					return returnValue;
				}
				
				String apiCntSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS<>'S' AND API_NAME NOT IN( 'VanToWarehouseTransfer','CLOSE_LOAD') ";
				pstmt = conn.prepareStatement(apiCntSql);
				pstmt.setString(1, refID);
				pstmt.setString(2, enterprise);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					apiFailedCnt=rs.getInt("COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("listItem reintialize::::::::["+apiFailedCnt+"]");
				
				E12ExternalAPICall e12ExternalAPICall = new E12ExternalAPICall("SAP",userInfo);
				if(apiFailedCnt > 0)
				{
					String apiSql="SELECT API_NAME,TRAN_ID,REQUEST_DATA,RESPONSE_INFO FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS<>'S' ";
					pstmt = conn.prepareStatement(apiSql);
					pstmt.setString(1, refID);
					pstmt.setString(2, enterprise);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						String apiName=checkNull(rs.getString("API_NAME"));
						String apiTranID=checkNull(rs.getString("TRAN_ID"));
						String requestData=checkNull(rs.getString("REQUEST_DATA"));
						JSONObject object = new JSONObject(requestData);
						

						String mapValue=apiName+"@"+apiTranID;
						if(apiName.equalsIgnoreCase("Invoices") || apiName.equalsIgnoreCase("DeliveryNotes") || apiName.equalsIgnoreCase(("IncomingPayments")))
						{
							String transactionID = checkNull(object.getString("U_MTID"));
							String transactionInvoiceId = checkNull(object.getString("U_MIN"));
							String mapKey=transactionID+"@"+transactionInvoiceId;
							if(transactioApiName.containsKey(transactionID))
							{
								String mapContainValue=transactioApiName.get(mapKey);
								String mapValues=mapContainValue+","+mapValue;
								transactioApiName.put(mapKey, mapValues);
							}
							else
							{
								transactioApiName.put(mapKey, mapValue);

							}
						}
						else
						{
							if(!apiName.equalsIgnoreCase("VanToWarehouseTransfer"))
							{
								refWiseApiName.put(refID, mapValue);
							}
							
							
						}
						
					}
					if( rs !=null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt !=null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("refWiseApiName ::" + refWiseApiName);
					if(!refWiseApiName.isEmpty())
					{
						System.out.println("actionTranId inside refWiseApi" + actionTranID);
						for(Map.Entry<String, String> mapElement: refWiseApiName.entrySet())
						{
							String tranID=mapElement.getKey();
							String valueAginstTranId=mapElement.getValue();
							System.out.println("tranID is["+tranID +"]valueAginstTranId["+valueAginstTranId+"]");
							String singleElement[]=valueAginstTranId.split(",");
							HashMap<String,String> apiNameWiseData=new HashMap<String, String>();
							ArrayList<String> tranIdList=getStockTransferTranIDFormat(refID,conn);
							for(int i = 0 ;i < singleElement.length;i++)
							{

								String dataElement=singleElement[i];

								String apiName=dataElement.split("@")[0];
								String apiTranID=dataElement.split("@")[1];
								apiNameWiseData.put(apiName, apiTranID);
							}
							if(apiNameWiseData.containsKey("SplitBundle"))
							{
								String apiMaptranID=apiNameWiseData.get("SplitBundle");
								JSONObject salesInvSplitJSONobj = new JSONObject();
								salesInvSplitJSONobj = getSplitInvoiceDetails(refID,refID,conn, loadNo);
								System.out.println("Posting Of Split Bundle API ...........");
								if(salesInvSplitJSONobj != null)
								{
									String splitInvoiceUrl = "https://lbcp.rpminfotech.com/api/SplitBundle";
									String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("SplitBundle", splitInvoiceUrl, "A", "E", refID, "F-DCR", "POST", salesInvSplitJSONobj, userInfo,apiMaptranID) ;
									if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
									{
										apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
									}
	
									if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseJsonStr);
										
										String errorCode=obj.getString("errorCode");
										if("000".equalsIgnoreCase(errorCode))
										{
											returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
										}
										else
										{
											String errorMessage=obj.getString("errorMessage");
											returnValue=getErrorString(errorMessage);
										}
	
	
									}
									else if(apiCallResponseJsonStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseJsonStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value=message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
										returnValue=getErrorString(value);
	
									}
									JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
								}
								apiNameWiseData.remove("SplitBundle");
							}
							else if(apiNameWiseData.containsKey("VanToVanTransfer"))
							{
								String apiMaptranID=apiNameWiseData.get("VanToVanTransfer");
								JSONObject salesVanJSONobj = new JSONObject();
								String tranIDInForm=orgStructure.getFormattedList(tranIdList);
								if(tranIDInForm==null || tranIDInForm.trim().length()==0)
								{
									tranIDInForm="'X'";
								}
								if(!(tranIdList.isEmpty()))
								{
									salesVanJSONobj = getVanStockDetails(tranIdList,tranIDInForm,conn,loadNo);
									System.out.println("Posting Of Van Stock API ...........");
									String vanStockUrl = "https://lbcp.rpminfotech.com/api/VanToVanTransfer";
									String apiCallResponseVanJsonStr = e12ExternalAPICall.apiCallToPostData("VanToVanTransfer", vanStockUrl, "A", "E", refID, "F-DCR", "POST", salesVanJSONobj, userInfo,apiMaptranID);
									if(apiCallResponseVanJsonStr.indexOf("[")==0 && apiCallResponseVanJsonStr.lastIndexOf("]")==apiCallResponseVanJsonStr.length()-1)
									{
										apiCallResponseVanJsonStr=apiCallResponseVanJsonStr.substring(1, apiCallResponseVanJsonStr.length()-1);
									}
									
									if(apiCallResponseVanJsonStr.indexOf("errorCode")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
										
										String errorCode=obj.getString("errorCode");
										if("000".equalsIgnoreCase(errorCode))
										{
											returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
										}
										else
										{
											String errorMessage=obj.getString("errorMessage");
											returnValue=getErrorString(errorMessage);
										}
	
	
									}
									else if(apiCallResponseVanJsonStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value=message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
										returnValue=getErrorString(value);
	
									}
									JSONObject apiCallResponseVanJSON = new JSONObject(apiCallResponseVanJsonStr);
								}
								apiNameWiseData.remove("VanToVanTransfer");
							}
							
						}
					}
					System.out.println("transactioApiName ::"+transactioApiName);
					if(!transactioApiName.isEmpty())
					{

						for(Map.Entry<String, String> mapElement: transactioApiName.entrySet())
						{
							String mapKey=mapElement.getKey();
							String tranID=mapKey.split("@")[0];
							String tranInvoicID=mapKey.split("@")[1];
							String valueAginstTranId=mapElement.getValue();
							System.out.println("tranID is["+tranID +"]valueAginstTranId["+valueAginstTranId+"]");
							String singleElement[]=valueAginstTranId.split(",");
							HashMap<String,String> apiNameWiseData=new HashMap<String, String>();
							for(int i = 0 ;i < singleElement.length;i++)
							{
								String dataElement=singleElement[i];

								String apiName=dataElement.split("@")[0];
								String apiTranID=dataElement.split("@")[1];
								apiNameWiseData.put(apiName, apiTranID);
							}

							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
							/*String headerSql="SELECT SC.GST_NO,SM.STRG_CODE,SM.EVENT_DATE,SM.REMARKS,SM.SALES_PERS,SMC.PAY_MODE,SMC.REF_NO,SC.STATE_CODE ,E.EMP_SITE,SP.STATE_CODE AS SP_STATE_CODE,L.LOC_GROUP,L.LOC_PHY_AREA,SM.AMOUNT AS TOTALAMOUNT " + 
									"FROM STRG_MEET SM,STRG_MEET_COLLECT SMC ,STRG_CUSTOMER SC,SALES_PERS SP ,LOCATION L,EMPLOYEE E " + 
									"WHERE SM.TRAN_ID=? AND SM.TRAN_ID=SMC.TRAN_ID AND SM.STRG_CODE=SC.SC_CODE AND " + 
									"E.EMP_CODE=SM.SALES_PERS AND SM.SALES_PERS=SP.SALES_PERS AND SP.SALES_PERS=E.EMP_CODE AND E.EMP_CODE=L.LOC_CODE ";*/
							String headerSql="SELECT SC.GST_NO,SM.STRG_CODE,SM.EVENT_DATE,SM.REMARKS,SM.SALES_PERS,SMC.PAY_MODE,SMC.REF_NO,SC.STATE_CODE ,E.EMP_SITE,SP.STATE_CODE AS SP_STATE_CODE,L.LOC_GROUP,L.LOC_PHY_AREA,SM.AMOUNT AS TOTALAMOUNT, SMC.REF_BANK, SM.SALES_TYPE " + 
									"FROM STRG_MEET SM,STRG_MEET_COLLECT SMC ,STRG_CUSTOMER SC,SALES_PERS SP ,LOCATION L,EMPLOYEE E " + 
									"WHERE SM.TRAN_ID=? AND SM.TRAN_ID=SMC.TRAN_ID AND SM.STRG_CODE=SC.SC_CODE AND " + 
									"E.EMP_CODE=SM.SALES_PERS AND SM.SALES_PERS=SP.SALES_PERS AND SP.SALES_PERS=E.EMP_CODE AND E.EMP_CODE=L.LOC_CODE ";
							//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]

							System.out.println("inside headerSql ::"+headerSql);
							pstmt1 = conn.prepareStatement(headerSql);
							pstmt1.setString(1, tranID);
							rs1 = pstmt1.executeQuery();
							if(rs1.next())
							{

								String empSite = checkNull(rs1.getString("EMP_SITE"));
								String stateCode = checkNull(rs1.getString("SP_STATE_CODE"));
								String locGroup = checkNull(rs1.getString("LOC_GROUP"));
								String BinAbsEntry = checkNull(rs1.getString("LOC_PHY_AREA"));
								String strgCode=checkNull(rs1.getString("STRG_CODE"));
								//String tranDate=checkNull(rs.getString("EVENT_DATE"));
								String tranDate= (rs1.getDate("EVENT_DATE")).toString();
								String remarks=checkNull(rs1.getString("REMARKS"));
								String salesPers=checkNull(rs1.getString("SALES_PERS"));
								String custStateCode=checkNull(rs1.getString("STATE_CODE"));
								String payMode=checkNull(rs1.getString("PAY_MODE"));
								String totalAmount=checkNull(rs1.getString("TOTALAMOUNT"));
								String gstNo=checkNull(rs1.getString("GST_NO"));
								String chequeNo=checkNull(rs1.getString("REF_NO"));
								String refBank=checkNull(rs1.getString("REF_BANK"));
								String salesType=checkNull(rs1.getString("SALES_TYPE"));

								if("URD".equalsIgnoreCase(gstNo))
								{
									gstNo="";
								}
								JSONObject salesInvJSONobj = new JSONObject();
								JSONObject invJPaymentSONobj = new JSONObject();

								System.out.println("gstNo =["+gstNo+"]");
								System.out.println("tranDate =["+tranDate+"]");
								if(apiNameWiseData.containsKey("Invoices"))
								{
									String apiMaptranID=apiNameWiseData.get("Invoices");
									//changed by Gulzar on 22-Feb-2024 
									//if((gstNo == null || gstNo.trim().length()== 0 || "C".equalsIgnoreCase(salesType)) && ("C".equalsIgnoreCase(payMode) || "R".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode) || "U".equalsIgnoreCase(payMode) ))
									if(!(gstNo != null && gstNo.length() > 0 && "I".equalsIgnoreCase(salesType)) )
									{
										String docEntry = "";
										String cardCode = "";
										String salesInvoiceApiURL = "https://lbcp.rpminfotech.com/api/Invoices";
										System.out.println("salesInvoiceApiURL =["+salesInvoiceApiURL+"]");
										//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
										//salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranID,payMode,gstNo,tranInvoicID,chequeNo,"Invoices",conn, loadNo);
										salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranID,payMode,gstNo,tranInvoicID,chequeNo,"Invoices",conn, loadNo,refBank);
										//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]

										String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("Invoices", salesInvoiceApiURL, "A", "E", refID, "F-DCR", "POST", salesInvJSONobj,userInfo,apiMaptranID) ;
										if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
										{
											apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
										}
										if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
										{
											
											JSONObject obj = new JSONObject(apiCallResponseJsonStr);
											String errorCode=obj.getString("errorCode");
											if("000".equalsIgnoreCase(errorCode))
											{
												returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";

											}
											else
											{
												String errorMessage=obj.getString("errorMessage");
												returnValue=getErrorString(errorMessage);
											}

										}
										else if(apiCallResponseJsonStr.indexOf("error")!=-1)
										{
											JSONObject obj = new JSONObject(apiCallResponseJsonStr);
											JSONObject error = obj.getJSONObject("error");
											JSONObject message = error.getJSONObject("message");
											String value=message.getString("value");
											//System.out.println("apiCallResponseJsonStr value in case of cheque =["+value+"]");

											returnValue=getErrorString(value);

										}
										if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.trim().length() > 0 )
										{
											JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
											docEntry = apiCallResponseJSON.getInt("DocEntry")+"";
											cardCode = apiCallResponseJSON.getString("CardCode")+"";
										}
										System.out.println("docEntry =["+docEntry+"], cardCode=["+cardCode+"]");
										if (docEntry != null && docEntry.trim().length() > 0)
										{
											//Commented and added chequeNo by Sanket
											//invJPaymentSONobj = getIncomingPayment(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,refID,payMode,totalAmount,docEntry,tranInvoicID,conn);
											invJPaymentSONobj = getIncomingPayment(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranID,payMode,totalAmount,docEntry,tranInvoicID,conn, chequeNo, cardCode);

											System.out.println("invJPaymentSONobj =["+invJPaymentSONobj.toString()+"]");

											String paymentApiURL = "https://20.219.186.30:50000/b1s/v1/IncomingPayments";
											String paymentApiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("IncomingPayments", paymentApiURL, "A", "E", refID, "F-DCR", "POST", invJPaymentSONobj, userInfo,"") ;
											if(paymentApiCallResponseJsonStr.indexOf("error")!=-1)
											{
												JSONObject obj = new JSONObject(paymentApiCallResponseJsonStr);
												JSONObject error = obj.getJSONObject("error");
												JSONObject message = error.getJSONObject("message");
												String value=message.getString("value");
												returnValue=getErrorString(value);
											}
										}
									}
									apiNameWiseData.remove("Invoices");
									
								}//end invoice API Reintialize
								else if(apiNameWiseData.containsKey("IncomingPayments"))
								{
									String apiCallResponseJsonStr="";
									String docEntry = "";
									String cardCode = "";
									String apiMaptranID=apiNameWiseData.get("IncomingPayments");

									String resPSql="SELECT RESPONSE_INFO FROM API_CALL_LOG WHERE API_NAME='Invoices' AND REF_ID=? AND REQUEST_DATA LIKE '%"+tranInvoicID+"%'  ";
									pstmt = conn.prepareStatement(resPSql);
									pstmt.setString(1, refID);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										apiCallResponseJsonStr=checkNull(rs.getString("RESPONSE_INFO"));
									}
									if( pstmt !=null )
									{
										pstmt.close();
										pstmt = null;
									}
									if( rs !=null )
									{
										rs.close();
										rs = null;
									}
									if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
									{
										apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
									}
									//System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
									if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.trim().length() > 0 )
									{
										JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
										docEntry = apiCallResponseJSON.getInt("DocEntry")+"";
										cardCode = apiCallResponseJSON.getString("CardCode")+"";
									}
									System.out.println("docEntry =["+docEntry+"]");
									if (docEntry != null && docEntry.trim().length() > 0)
									{
										//Commented and added chequeNo by Sanket
										//invJPaymentSONobj = getIncomingPayment(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,refID,payMode,totalAmount,docEntry,tranInvoicID,conn);
										invJPaymentSONobj = getIncomingPayment(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranID,payMode,totalAmount,docEntry,tranInvoicID,conn, chequeNo, cardCode);

										System.out.println("invJPaymentSONobj =["+invJPaymentSONobj.toString()+"]");

										String paymentApiURL = "https://20.219.186.30:50000/b1s/v1/IncomingPayments";
										String paymentApiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("IncomingPayments", paymentApiURL, "A", "E", refID, "F-DCR", "POST", invJPaymentSONobj, userInfo,apiMaptranID) ;
										System.out.println("paymentApiCallResponseJsonStr =["+paymentApiCallResponseJsonStr+"]");
										if(paymentApiCallResponseJsonStr.indexOf("error")!=-1)
										{
											JSONObject obj = new JSONObject(paymentApiCallResponseJsonStr);
											JSONObject error = obj.getJSONObject("error");
											JSONObject message = error.getJSONObject("message");
											String value=message.getString("value");
											System.out.println("paymentApiCallResponseJsonStr value in case of cash =["+value+"]");

											returnValue=getErrorString(value);
										}
									}
									apiNameWiseData.remove("IncomingPayments");

								}
								else if(apiNameWiseData.containsKey("DeliveryNotes"))
								{
									String apiMaptranID=apiNameWiseData.get("DeliveryNotes");

									System.out.println("Posting Of Delivery Note ...........");
									//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON[Start]
									//salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranID,payMode,gstNo,tranInvoicID,chequeNo,"DeliveryNotes",conn, loadNo);
									salesInvJSONobj = getARInvoiceDetails(empSite,stateCode,locGroup,BinAbsEntry,strgCode,tranDate,remarks,salesPers,custStateCode,tranID,payMode,gstNo,tranInvoicID,chequeNo,"DeliveryNotes",conn, loadNo,refBank);
									//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON[End]

									//String deliverNoteApiURL = "https://lbcp.rpminfotech.com/api/Invoices";
									String deliverNoteApiURL = "https://lbcp.rpminfotech.com/api/DeliveryNotes";
									String apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("DeliveryNotes", deliverNoteApiURL, "A", "E", refID, "F-DCR", "POST", salesInvJSONobj, userInfo,apiMaptranID) ;
									if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
									{
										apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
									}
									
									System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
									if(apiCallResponseJsonStr.indexOf("errorCode")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseJsonStr);
										
										String errorCode=obj.getString("errorCode");
										if("000".equalsIgnoreCase(errorCode))
										{
											returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";

										}
										else
										{
											String errorMessage=obj.getString("errorMessage");
											returnValue=getErrorString(errorMessage);
										}


									}
									else if(apiCallResponseJsonStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseJsonStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value=message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of cheque =["+value+"]");
										returnValue=getErrorString(value);

									}
									JSONObject apiCallResponseJSON = new JSONObject(apiCallResponseJsonStr);
									apiNameWiseData.remove("DeliveryNotes");

								}

							
							}
							if( pstmt1 !=null )
							{
								pstmt1.close();
								pstmt1 = null;
							}
							if( rs1 !=null )
							{
								rs1.close();
								rs1 = null;
							}
						}
					}//
				}
				int totalApiCnt=0;
				String Sql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND API_NAME <> 'VanToWarehouseTransfer' ";
				pstmt = conn.prepareStatement(Sql);
				pstmt.setString(1, refID);
				pstmt.setString(2, enterprise);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totalApiCnt=rs.getInt("COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("totalApiCnt =["+totalApiCnt+"]");
				int totalApiSucessCnt=0;
				String apiSSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS='S' AND API_NAME NOT IN( 'VanToWarehouseTransfer','CLOSE_LOAD') ";
				pstmt = conn.prepareStatement(apiSSql);
				pstmt.setString(1, refID);
				pstmt.setString(2, enterprise);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totalApiSucessCnt=rs.getInt("COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("totalApiSucessCnt =["+totalApiSucessCnt+"]");
				System.out.println("totalApiCnt = ["+totalApiCnt+"], totalApiSucessCnt=["+totalApiSucessCnt+"]");
				String locCode= salesSFAToSAPService.getLocCode(refID, conn);
				if(totalApiSucessCnt==totalApiCnt)
				{
					int stockCnt = 0;
					
					String stockSql="SELECT COUNT(1) AS COUNT FROM STOCK S ,ITEM I,LOCATION L , SALES_PERS SL "
							+ "WHERE S.ITEM_CODE=I.ITEM_CODE AND S.LOC_CODE=L.LOC_CODE "
							+ "AND SL.ITEM_SER = I.ITEM_SER "
							+ "AND SL.SALES_PERS = S.LOC_CODE "
							+ "AND S.LOC_CODE= ? "
							+ "AND S.SITE_CODE=(SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE= ?) AND S.QUANTITY > 0";
					pstmt =  conn.prepareStatement(stockSql);
					pstmt.setString(1, locCode);
					pstmt.setString(2, locCode);
					
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stockCnt = rs.getInt("COUNT");
					}
					System.out.println("stockCnt = ["+stockCnt+"]");
					if(stockCnt > 0)
					{
						int vanTowarCnt=0;
						String apiCntSql1="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND API_NAME='VanToWarehouseTransfer'";
						pstmt = conn.prepareStatement(apiCntSql1);
						pstmt.setString(1, refID);
						pstmt.setString(2, enterprise);
						
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							vanTowarCnt=rs.getInt("COUNT");
						}
						if( rs !=null )
						{
							rs.close();
							rs = null;
						}
						if( pstmt !=null )
						{
							pstmt.close();
							pstmt = null;
						}
						System.out.println("vanTowarCnt =["+vanTowarCnt+"]");
						String callStatus="",stockTransactionID="",tranID="";
						boolean closeLoad = true;
						if(vanTowarCnt==0)
						{
							e12ExternalAPICall = new E12ExternalAPICall("SAP",userInfo);
							returnValue=getVanWareHouseDetails(refID,e12ExternalAPICall,aproverEmpCode,userId, userInfo,loadNo, "", conn);
							
							if(returnValue != null && returnValue.indexOf("Success") != -1)
							{
								//closeLoad = true;
								returnValue = salesSFAToSAPService.closeLoad(locCode, loadNo, e12ExternalAPICall, userInfo, refID, conn);
							}
							else
							{
								closeLoad = false;
							}
						}
						else
						{
							String apiCntSql2="SELECT CALL_STATUS,REQUEST_DATA,TRAN_ID FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND API_NAME='VanToWarehouseTransfer'";
							pstmt = conn.prepareStatement(apiCntSql2);
							pstmt.setString(1, refID);
							pstmt.setString(2, enterprise);
	
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								callStatus=checkNull(rs.getString("CALL_STATUS"));
								String requestData=checkNull(rs.getString("REQUEST_DATA"));
								tranID=checkNull(rs.getString("TRAN_ID"));
	
								JSONObject object = new JSONObject(requestData);
								stockTransactionID = checkNull(object.getString("U_MTID"));
	
							}
							if( rs !=null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt !=null )
							{
								pstmt.close();
								pstmt = null;
							}
							String apiCallResponseVanJsonStr="";
							if(!"S".equalsIgnoreCase(callStatus))
							{
								StockTransactionCreation StockTransactionCreation=new StockTransactionCreation();
								JSONObject vanToWareHouseJson = new JSONObject();
								vanToWareHouseJson=StockTransactionCreation.getvantowarhouseJson(stockTransactionID,conn, loadNo);
								
								if(vanToWareHouseJson != null)
								{
									String vanStockUrl = "https://lbcp.rpminfotech.com/api/VanToWarehouseTransfer";
									apiCallResponseVanJsonStr = e12ExternalAPICall.apiCallToPostData("VanToWarehouseTransfer", vanStockUrl, "A", "E", refID, "F-DCR", "POST", vanToWareHouseJson, userInfo,tranID);
									
									if(apiCallResponseVanJsonStr.indexOf("[")==0 && apiCallResponseVanJsonStr.lastIndexOf("]")==apiCallResponseVanJsonStr.length()-1)
									{
										apiCallResponseVanJsonStr=apiCallResponseVanJsonStr.substring(1, apiCallResponseVanJsonStr.length()-1);
									}
									
									if(apiCallResponseVanJsonStr.indexOf("errorCode")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
										
										String errorCode=obj.getString("errorCode");
										if("000".equalsIgnoreCase(errorCode))
										{
											returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
										}
										else
										{
											String errorMessage=obj.getString("errorMessage");
											returnValue=getErrorString(errorMessage);
										}
	
	
									}
									else if(apiCallResponseVanJsonStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value=message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
										returnValue=getErrorString(value);
	
									}
									int vanSucessCnt=0;
									String sql3="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS='S' AND API_NAME='VanToWarehouseTransfer' " ; 
									pstmt = conn.prepareStatement(sql3);
									pstmt.setString(1, refID);
									pstmt.setString(2, userInfo.getEnterprise());
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										vanSucessCnt=rs.getInt("COUNT");
									}
									if( rs !=null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt !=null )
									{
										pstmt.close();
										pstmt = null;
									}	
									if(vanSucessCnt>0)
									{
										AppConnectParm appConnect = new AppConnectParm();
										InitialContext initialContext = new InitialContext(appConnect.getProperty());
										
										java.util.Date date = Calendar.getInstance().getTime();
										DateFormat dtFormat = new SimpleDateFormat(e12GenericUtility.getApplDateFormat());
										String currentDate = dtFormat.format( date );
	
										
										System.out.println("stockTransactionID::::::::::::::::::["+stockTransactionID+"]");
										if(stockTransactionID!=null && stockTransactionID.trim().length()>0)
										{
											StringBuffer processDynXmlString=new StringBuffer();
											processDynXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
											processDynXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>");
											processDynXmlString.append("<objName><![CDATA[stock_transfer]]></objName>");
											processDynXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
											processDynXmlString.append("<objContext><![CDATA[1]]></objContext>");
											processDynXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
											processDynXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
											processDynXmlString.append("<action><![CDATA[SAVE]]></action>");
											processDynXmlString.append("<elementName><![CDATA[]]></elementName>");
											processDynXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
											processDynXmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
											processDynXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
											processDynXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
											processDynXmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
											
											String siteCode="";
											String stockTrasferSql="SELECT  * FROM STOCK_TRANSFER WHERE  TRAN_ID=? ";
											pstmt = conn.prepareStatement(stockTrasferSql);
											pstmt.setString(1, stockTransactionID);
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												String objContext="1";
												siteCode=checkNull(rs.getString("SITE_CODE"));
												System.out.println("for detail1");
	
												processDynXmlString.append("<Detail1 dbID='' domID='1'  objContext='"+objContext+"'  objName='stock_transfer'>");
												processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
												processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
												processDynXmlString.append("<tran_date><![CDATA[").append( currentDate ).append("]]></tran_date>");
												processDynXmlString.append("<site_code><![CDATA[").append( checkNull(rs.getString("SITE_CODE")) ).append("]]></site_code>");
												processDynXmlString.append("<ref_ser__for><![CDATA[").append("XFRX").append("]]></ref_ser__for>");
												processDynXmlString.append("<ref_id__for><![CDATA[").append( checkNull(rs.getString("REF_ID__FOR")) ).append("]]></ref_id__for>");
												processDynXmlString.append("<reas_code><![CDATA[").append( checkNull(rs.getString("REAS_CODE"))  ).append("]]></reas_code>");
												processDynXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>");
												processDynXmlString.append("<confirmed><![CDATA[").append( "N" ).append("]]></confirmed>");
												processDynXmlString.append("<conf_date><![CDATA[]]></conf_date>");
												processDynXmlString.append("<emp_code__aprv><![CDATA[").append(aproverEmpCode).append("]]></emp_code__aprv>");
												processDynXmlString.append("<chg_date><![CDATA[").append(currentDate).append("]]></chg_date>");
												processDynXmlString.append("<chg_term><![CDATA[").append("SYSTEM").append("]]></chg_term>");
												processDynXmlString.append("<chg_user><![CDATA[").append(userId).append("]]></chg_user>");
												processDynXmlString.append("<full_name><![CDATA[").append("").append("]]></full_name>");
												processDynXmlString.append("<tran_type><![CDATA[").append("I").append("]]></tran_type>");
												processDynXmlString.append("<truck_no><![CDATA[").append(checkNull(rs.getString("TRUCK_NO"))).append("]]></truck_no>");
												processDynXmlString.append("<ref_date><![CDATA[").append(currentDate).append("]]></ref_date>");
												processDynXmlString.append("</Detail1>");
											}
											if( rs !=null )
											{
												rs.close();
												rs = null;
											}
											if( pstmt !=null )
											{
												pstmt.close();
												pstmt = null;
											}
											String locationCodeFrom="",locationCodeFromDescr="";
	
											
											String locCodeToSql="SELECT LOC_CODE,DESCR FROM LOCATION WHERE SITE_CODE=? AND LOC_TYPE='DP'";
											pstmt =  conn.prepareStatement(locCodeToSql);
											pstmt.setString(1, siteCode);
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												locationCodeFrom = checkNull(rs.getString("LOC_CODE"));
												locationCodeFromDescr = checkNull(rs.getString("DESCR"));
	
											}
											if (rs!= null)
											{
												rs.close();
												rs = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}
											
											int lineNo=1;
											String stockTrasferDetSql="SELECT  * FROM STOCK_TRANSFER_DET WHERE  TRAN_ID=? ";
											pstmt = conn.prepareStatement(stockTrasferDetSql);
											pstmt.setString(1, stockTransactionID);
											rs = pstmt.executeQuery();
											int noart=2;
	
											while(rs.next())
											{
												String objContext="2";
												System.out.println("for detail2");
	
												processDynXmlString.append("<Detail2 dbID='' domID='"+lineNo+"'  objContext='"+objContext+"'  objName='stock_transfer'>");
												processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
												processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
												processDynXmlString.append("<line_no><![CDATA[").append( lineNo ).append("]]></line_no>");
												processDynXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>");
												processDynXmlString.append("<quantity><![CDATA[").append(checkNull(rs.getString("QUANTITY"))).append("]]></quantity>");
												processDynXmlString.append("<loc_code__fr><![CDATA[").append(locationCodeFrom).append("]]></loc_code__fr>");
												processDynXmlString.append("<loc_code__to><![CDATA[").append( "DMYLOC" ).append("]]></loc_code__to>");
												processDynXmlString.append("<lot_no__fr><![CDATA[").append(checkNull(rs.getString("LOT_NO__FR"))).append("]]></lot_no__fr>");
												processDynXmlString.append("<lot_no__to><![CDATA[").append(checkNull(rs.getString("LOT_NO__TO"))).append("]]></lot_no__to>");
												processDynXmlString.append("<lot_sl__fr><![CDATA[").append(checkNull(rs.getString("LOT_SL__FR"))).append("]]></lot_sl__fr>");
												processDynXmlString.append("<lot_sl__to><![CDATA[").append(checkNull(rs.getString("LOT_SL__TO"))).append("]]></lot_sl__to>");
												processDynXmlString.append("<remarks><![CDATA[]]></remarks>");
												processDynXmlString.append("<acct_code__cr><![CDATA[").append(checkNull(rs.getString("ACCT_CODE__CR"))).append("]]></acct_code__cr>");
												processDynXmlString.append("<acct_code__dr><![CDATA[").append(checkNull(rs.getString("ACCT_CODE__DR"))).append("]]></acct_code__dr>");
												processDynXmlString.append("<cctr_code__dr><![CDATA[").append(checkNull(rs.getString("CCTR_CODE__DR"))).append("]]></cctr_code__dr>");
												processDynXmlString.append("<cctr_code__cr><![CDATA[").append(checkNull(rs.getString("CCTR_CODE__CR"))).append("]]></cctr_code__cr>");
												processDynXmlString.append("<location_descr__fr><![CDATA[").append(locationCodeFromDescr).append("]]></location_descr__fr>");
												processDynXmlString.append("<no_art><![CDATA[").append(noart).append("]]></no_art>");			
												processDynXmlString.append("</Detail2>");								
												lineNo++;
											}
											if( rs !=null )
											{
												rs.close();
												rs = null;
											}
											if( pstmt !=null )
											{
												pstmt.close();
												pstmt = null;
											}
											
											processDynXmlString.append("</Header0></group0></DocumentRoot>");
											String XmlString = processDynXmlString.toString();
											System.out.println("returnString:::::FOR XmlString 111 :: "+XmlString);
	
											MasterStatefulLocal masterStateful = (MasterStatefulLocal)initialContext.lookup("ibase/MasterStatefulEJB/local");
											String reString = masterStateful.processRequest( getUserInfo(), XmlString, false, conn);
											System.out.println("returnString:::::FOR DUMY 111 ::"+reString);
										}
									}
									JSONObject apiCallResponseVanJSON = new JSONObject(apiCallResponseVanJsonStr);
								}//if(vanToWareHouseJson != null)
							}//if(!"S".equalsIgnoreCase(callStatus))
							
							if((apiCallResponseVanJsonStr == null || apiCallResponseVanJsonStr.trim().length() == 0 ))
							{
								//closeLoad = true;
								returnValue = salesSFAToSAPService.closeLoad(locCode, loadNo, e12ExternalAPICall, userInfo, refID, conn);
							}
							else if( apiCallResponseVanJsonStr.indexOf("errorCode")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
								
								String errorCode=obj.getString("errorCode");
								if("000".equalsIgnoreCase(errorCode))
								{
									returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";
	
								}
								else
								{
									closeLoad = false;
									String errorMessage=obj.getString("errorMessage");
									returnValue=getErrorString(errorMessage);
								}
							}
							else if(apiCallResponseVanJsonStr.indexOf("error")!=-1)
							{
								closeLoad = false;
								JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
								returnValue=getErrorString(value);
	
							}
													
						}//else if(vanTowarCnt==0)
						/*---
						System.out.println("closeLoad =["+closeLoad+"]");
						if(closeLoad)
						{
							String salesPers = "";
							String apiCallResponseVanJsonStr = "";
							JSONObject closeLoadJSON = new JSONObject();
							closeLoadJSON.put("U_LDCL", "CL");
							
							String loadNoSql = "SELECT A.LOAD_NO,A.SALES_PERS FROM SPRS_DAY_SUMM A, SPRS_ACT_TRAN B WHERE A.SALES_PERS = B.SALES_PERS AND A.EVENT_DATE = B.EVENT_DATE AND B.DCR_ID = ?";
							
							pstmt = conn.prepareStatement(loadNoSql);
							pstmt.setString(1, refID);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								loadNo = checkNull(rs.getString("LOAD_NO"));
								salesPers = checkNull(rs.getString("SALES_PERS"));
							}
							String closeLoadUrl = "https://20.219.186.30:50000/b1s/v1/StockTransfers("+loadNo+")";
							String apiCallResponseStr = e12ExternalAPICall.apiCallToPostData("CLOSE_LOAD", closeLoadUrl, "A", "E", refID, "F-DCR", "PATCH", closeLoadJSON, userInfo,tranID);
							if(apiCallResponseStr.indexOf("[")==0 && apiCallResponseStr.lastIndexOf("]")==apiCallResponseStr.length()-1)
							{
								apiCallResponseVanJsonStr=apiCallResponseStr.substring(1, apiCallResponseStr.length()-1);
							}
							
							if(apiCallResponseStr.indexOf("error")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
								returnValue=getErrorString(value);
	
							}
							else
							{
								String updLoadStatSql = "UPDATE SPRS_DAY_SUMM SET LOAD_STATUS = 'Y' WHERE SALES_PERS = ? AND LOAD_NO = ?";
								pstmt = conn.prepareStatement(updLoadStatSql);
								pstmt.setString(1, salesPers);
								pstmt.setString(2, loadNo);
								int updCnt = pstmt.executeUpdate();
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("SPRS_DAY_SUMM LOAD_STATUS updCnt =["+updCnt+"]");
							}
	
						}//if(closeLoad)
						*/
					}//if(stockCnt > 0)
					else
					{
						returnValue = salesSFAToSAPService.closeLoad(locCode, loadNo, e12ExternalAPICall, userInfo, refID, conn);
					}

				}//if(totalApiSucessCnt==totalApiCnt)
				else
				{
					int closeLoadApicnt=0;
					String closeLoadApiSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS !='S' AND API_NAME = 'CLOSE_LOAD' ";
					pstmt = conn.prepareStatement(closeLoadApiSql);
					pstmt.setString(1, refID);
					pstmt.setString(2, enterprise);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						closeLoadApicnt=rs.getInt("COUNT");
					}
					if( rs !=null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt !=null )
					{
						pstmt.close();
						pstmt = null;
					}
					if(closeLoadApicnt > 0)
					{
						returnValue = salesSFAToSAPService.closeLoad(locCode, loadNo, e12ExternalAPICall, userInfo, refID, conn);
					}
				}

			}
			/*
			 * else if("rcpt_backflush".equalsIgnoreCase(objName)) { int apiFailedCnt=0;
			 * String
			 * apiCntSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS<>'S'"
			 * ; pstmt = conn.prepareStatement(apiCntSql); pstmt.setString(1, refID);
			 * pstmt.setString(2, enterprise); rs = pstmt.executeQuery(); if(rs.next()) {
			 * apiFailedCnt=rs.getInt("COUNT"); } if( rs !=null ) { rs.close(); rs = null; }
			 * if( pstmt !=null ) { pstmt.close(); pstmt = null; }
			 * System.out.println("listItem reintialize::::::::["+apiFailedCnt+"]");
			 * 
			 * if(apiFailedCnt>0) { E12ExternalAPICall e12ExternalAPICall = new
			 * E12ExternalAPICall("SAP",userInfo); ProductionSFAToSAPService
			 * productionSFAToSAPService = new ProductionSFAToSAPService();
			 * 
			 * String
			 * apiSql="SELECT API_NAME,TRAN_ID,REQUEST_DATA,RESPONSE_INFO FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS<>'S' "
			 * ; pstmt1 = conn.prepareStatement(apiSql); pstmt1.setString(1, refID);
			 * pstmt1.setString(2, enterprise); rs1 = pstmt1.executeQuery();
			 * while(rs1.next()) { String apiName=checkNull(rs1.getString("API_NAME"));
			 * String apiTranID=checkNull(rs1.getString("TRAN_ID")); //String
			 * requestData=checkNull(rs.getString("REQUEST_DATA")); //JSONObject object =
			 * new JSONObject(requestData); if("ProductionOrders".equalsIgnoreCase(apiName))
			 * { JSONObject prodOrdSpecialJSON =
			 * productionSFAToSAPService.getProductionOrderSpecial1(refID, conn);
			 * 
			 * String apiCallResponseJsonStr =""; String absoluteEntry = ""; String
			 * prodOrdSpecialApiURL = "https://20.219.186.30:50000/b1s/v1/ProductionOrders";
			 * //apiCallResponseJsonStr =
			 * e12ExternalAPICall.apiCallToPostData(prodOrdSpecialJSON,
			 * prodOrdSpecialApiURL, "POST"); apiCallResponseJsonStr =
			 * e12ExternalAPICall.apiCallToPostData("ProductionOrders",
			 * prodOrdSpecialApiURL, "A", "E", refID, "F-DCR", "POST",
			 * prodOrdSpecialJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
			 * if(apiCallResponseJsonStr.indexOf("error")!=-1) { JSONObject obj = new
			 * JSONObject(apiCallResponseJsonStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if(apiCallResponseJsonStr != null &&
			 * apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1) { JSONObject
			 * prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
			 * //absoluteEntry = prodOrdSpecialDocEntryJSON.getString("AbsoluteEntry");
			 * absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+"";
			 * 
			 * }
			 * 
			 * System.out.println("absoluteEntry =["+absoluteEntry+"]");
			 * 
			 * if(absoluteEntry != null && absoluteEntry.trim().length() > 0 ) { String
			 * prodOrderStatApiCallResStr = ""; JSONObject prodOrdStatusJSON =
			 * productionSFAToSAPService.getProductionOrderStatusChg2(refID, conn);
			 * 
			 * System.out.println("prodOrdStatusJSON : " + prodOrdStatusJSON.toString());
			 * 
			 * String prodOrdStatusApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
			 * System.out.println("\nprodOrdStatusApiURL :\n " + prodOrdStatusApiURL);
			 * 
			 * //prodOrderStatApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(prodOrdStatusJSON, prodOrdStatusApiURL,
			 * "PATCH"); prodOrderStatApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("ProductionOrdersAb",
			 * prodOrdStatusApiURL, "A", "E", refID, "F-DCR", "PATCH",
			 * prodOrdStatusJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nprodOrderStatApiCallResStr:: \n"
			 * +prodOrderStatApiCallResStr);
			 * if(prodOrderStatApiCallResStr.indexOf("error")!=-1) { JSONObject obj = new
			 * JSONObject(prodOrderStatApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((prodOrderStatApiCallResStr == null
			 * || prodOrderStatApiCallResStr.trim().length() == 0 ) ||
			 * (prodOrderStatApiCallResStr != null &&
			 * prodOrderStatApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String issForProdApiCallResStr = ""; JSONObject issueForProdJSON =
			 * productionSFAToSAPService.getMobileAPIStructure3(refID, absoluteEntry, conn);
			 * 
			 * String issueForProdApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/InventoryGenExits";
			 * System.out.println("\nissueForProdApiURL :\n " + issueForProdApiURL);
			 * 
			 * //issForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(issueForProdJSON, issueForProdApiURL,
			 * "POST"); issForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("InventoryGenExits", issueForProdApiURL,
			 * "A", "E", refID, "F-DCR", "POST", issueForProdJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nissForProdApiCallResStr :\n " +
			 * issForProdApiCallResStr); if(issForProdApiCallResStr.indexOf("error")!=-1) {
			 * JSONObject obj = new JSONObject(issForProdApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((issForProdApiCallResStr == null ||
			 * issForProdApiCallResStr.trim().length() == 0 ) || (issForProdApiCallResStr !=
			 * null && issForProdApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String receiptForProdApiCallResStr = ""; JSONObject receiptForProdJSON =
			 * productionSFAToSAPService.getReceiptBackflushService4(refID, absoluteEntry,
			 * conn);
			 * 
			 * String receiptForProdApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
			 * System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);
			 * 
			 * //receiptForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(receiptForProdJSON,
			 * receiptForProdApiURL, "POST"); receiptForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("InventoryGenEntries",
			 * receiptForProdApiURL, "A", "E", refID, "F-DCR", "POST",
			 * receiptForProdJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nreceiptForProdApiCallResStr :\n " +
			 * receiptForProdApiCallResStr);
			 * if(receiptForProdApiCallResStr.indexOf("error")!=-1) { JSONObject obj = new
			 * JSONObject(receiptForProdApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((receiptForProdApiCallResStr == null
			 * || receiptForProdApiCallResStr.trim().length() == 0 ) ||
			 * (receiptForProdApiCallResStr != null &&
			 * receiptForProdApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String prodOrderCloseApiCallResStr = ""; JSONObject prodOrderCloseJSON =
			 * productionSFAToSAPService.getProductionOrderStatusChg5(refID, absoluteEntry,
			 * conn);
			 * 
			 * String prodOrderCloseApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
			 * 
			 * System.out.println("\nprodOrderCloseApiURL :\n " + prodOrderCloseApiURL);
			 * 
			 * //prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(prodOrderCloseJSON,
			 * prodOrderCloseApiURL, "PATCH"); prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("ProductionOrdersAb",
			 * prodOrderCloseApiURL, "A", "E", refID, "F-DCR", "PATCH",
			 * prodOrderCloseJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nprodOrderCloseApiCallResStr :\n " +
			 * prodOrderCloseApiCallResStr); } } } }
			 * 
			 * } if("ProductionOrdersAb".equalsIgnoreCase(apiName)) { String
			 * apiCallResponseJsonStr=""; String absoluteEntry = ""; String
			 * ProductionOrderStatus="";
			 * 
			 * String
			 * resPSql="SELECT RESPONSE_INFO,REQUEST_DATA FROM API_CALL_LOG WHERE API_NAME='ProductionOrders' AND REF_ID=?  "
			 * ; pstmt = conn.prepareStatement(resPSql); pstmt.setString(1, refID); rs =
			 * pstmt.executeQuery(); if(rs.next()) {
			 * apiCallResponseJsonStr=checkNull(rs.getString("RESPONSE_INFO")); String
			 * requestData=checkNull(rs.getString("REQUEST_DATA")); JSONObject object = new
			 * JSONObject(requestData); ProductionOrderStatus =
			 * checkNull(object.getString("ProductionOrderStatus"));
			 * 
			 * } if( pstmt !=null ) { pstmt.close(); pstmt = null; } if( rs !=null ) {
			 * rs.close(); rs = null; } if("R".equalsIgnoreCase(ProductionOrderStatus)) {
			 * 
			 * if(apiCallResponseJsonStr.indexOf("[")==0 &&
			 * apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1) {
			 * apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1,
			 * apiCallResponseJsonStr.length()-1); }
			 * //System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
			 * if(apiCallResponseJsonStr != null &&
			 * apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1) { JSONObject
			 * prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
			 * //absoluteEntry = prodOrdSpecialDocEntryJSON.getString("AbsoluteEntry");
			 * absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+""; }
			 * System.out.println("absoluteEntry =["+absoluteEntry+"]"); if (absoluteEntry
			 * != null && absoluteEntry.trim().length() > 0) {
			 * 
			 * String prodOrderStatApiCallResStr = ""; JSONObject prodOrdStatusJSON =
			 * productionSFAToSAPService.getProductionOrderStatusChg2(refID, conn);
			 * 
			 * System.out.println("\nprodOrdStatusJSON :\n " +
			 * prodOrdStatusJSON.toString());
			 * 
			 * String prodOrdStatusApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
			 * System.out.println("\nprodOrdStatusApiURL :\n " + prodOrdStatusApiURL);
			 * 
			 * //prodOrderStatApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(prodOrdStatusJSON, prodOrdStatusApiURL,
			 * "PATCH"); prodOrderStatApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("ProductionOrdersAb",
			 * prodOrdStatusApiURL, "A", "E", refID, "F-DCR", "PATCH",
			 * prodOrdStatusJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nprodOrderStatApiCallResStr:: \n"
			 * +prodOrderStatApiCallResStr);
			 * if(prodOrderStatApiCallResStr.indexOf("error")!=-1) { JSONObject obj = new
			 * JSONObject(prodOrderStatApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((prodOrderStatApiCallResStr == null
			 * || prodOrderStatApiCallResStr.trim().length() == 0 ) ||
			 * (prodOrderStatApiCallResStr != null &&
			 * prodOrderStatApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String issForProdApiCallResStr = ""; JSONObject issueForProdJSON =
			 * productionSFAToSAPService.getMobileAPIStructure3(refID, absoluteEntry, conn);
			 * 
			 * String issueForProdApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/InventoryGenExits";
			 * System.out.println("\nissueForProdApiURL :\n " + issueForProdApiURL);
			 * 
			 * //issForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(issueForProdJSON, issueForProdApiURL,
			 * "POST"); issForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("InventoryGenExits", issueForProdApiURL,
			 * "A", "E", refID, "F-DCR", "POST", issueForProdJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nissForProdApiCallResStr :\n " +
			 * issForProdApiCallResStr); if(issForProdApiCallResStr.indexOf("error")!=-1) {
			 * JSONObject obj = new JSONObject(issForProdApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((issForProdApiCallResStr == null ||
			 * issForProdApiCallResStr.trim().length() == 0 ) || (issForProdApiCallResStr !=
			 * null && issForProdApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String receiptForProdApiCallResStr = ""; JSONObject receiptForProdJSON =
			 * productionSFAToSAPService.getReceiptBackflushService4(refID, absoluteEntry,
			 * conn);
			 * 
			 * String receiptForProdApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
			 * System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);
			 * 
			 * //receiptForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(receiptForProdJSON,
			 * receiptForProdApiURL, "POST"); receiptForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("InventoryGenEntries",
			 * receiptForProdApiURL, "A", "E", refID, "F-DCR", "POST",
			 * receiptForProdJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nreceiptForProdApiCallResStr :\n " +
			 * receiptForProdApiCallResStr);
			 * if(receiptForProdApiCallResStr.indexOf("error")!=-1) { JSONObject obj = new
			 * JSONObject(receiptForProdApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((receiptForProdApiCallResStr == null
			 * || receiptForProdApiCallResStr.trim().length() == 0 ) ||
			 * (receiptForProdApiCallResStr != null &&
			 * receiptForProdApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String prodOrderCloseApiCallResStr = ""; JSONObject prodOrderCloseJSON =
			 * productionSFAToSAPService.getProductionOrderStatusChg5(refID, absoluteEntry,
			 * conn);
			 * 
			 * String prodOrderCloseApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
			 * 
			 * System.out.println("\nprodOrderCloseApiURL :\n " + prodOrderCloseApiURL);
			 * 
			 * //prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(prodOrderCloseJSON,
			 * prodOrderCloseApiURL, "PATCH"); prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("ProductionOrdersAb",
			 * prodOrderCloseApiURL, "A", "E", refID, "F-DCR", "PATCH",
			 * prodOrderCloseJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nprodOrderCloseApiCallResStr :\n " +
			 * prodOrderCloseApiCallResStr); } } }
			 * 
			 * } } if("L".equalsIgnoreCase(ProductionOrderStatus)) { String
			 * prodOrderCloseApiCallResStr = ""; JSONObject prodOrderCloseJSON =
			 * productionSFAToSAPService.getProductionOrderStatusChg5(refID, absoluteEntry,
			 * conn); String prodOrderCloseApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
			 * System.out.println("\nprodOrderCloseApiURL :\n " + prodOrderCloseApiURL);
			 * //prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(prodOrderCloseJSON,
			 * prodOrderCloseApiURL, "PATCH"); prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("ProductionOrdersAb",
			 * prodOrderCloseApiURL, "A", "E", refID, "F-DCR", "PATCH",
			 * prodOrderCloseJSON,userInfo,apiTranID) ;
			 * System.out.println("\nprodOrderCloseApiCallResStr :\n " +
			 * prodOrderCloseApiCallResStr); } }
			 * if("InventoryGenExits".equalsIgnoreCase(apiName)) { String
			 * apiCallResponseJsonStr=""; String absoluteEntry = "";
			 * 
			 * String issForProdApiCallResStr = "";
			 * 
			 * String
			 * resPSql="SELECT RESPONSE_INFO FROM API_CALL_LOG WHERE API_NAME='ProductionOrders' AND REF_ID=?  "
			 * ; pstmt = conn.prepareStatement(resPSql); pstmt.setString(1, refID); rs =
			 * pstmt.executeQuery(); if(rs.next()) {
			 * apiCallResponseJsonStr=checkNull(rs.getString("RESPONSE_INFO")); } if( pstmt
			 * !=null ) { pstmt.close(); pstmt = null; } if( rs !=null ) { rs.close(); rs =
			 * null; } if(apiCallResponseJsonStr.indexOf("[")==0 &&
			 * apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1) {
			 * apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1,
			 * apiCallResponseJsonStr.length()-1); }
			 * //System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
			 * if(apiCallResponseJsonStr != null &&
			 * apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1) { JSONObject
			 * prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
			 * //absoluteEntry = prodOrdSpecialDocEntryJSON.getString("AbsoluteEntry");
			 * absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+""; }
			 * JSONObject issueForProdJSON =
			 * productionSFAToSAPService.getMobileAPIStructure3(refID, absoluteEntry, conn);
			 * 
			 * String issueForProdApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/InventoryGenExits";
			 * System.out.println("\nissueForProdApiURL :\n " + issueForProdApiURL);
			 * 
			 * //issForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(issueForProdJSON, issueForProdApiURL,
			 * "POST"); issForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("InventoryGenExits", issueForProdApiURL,
			 * "A", "E", refID, "F-DCR", "POST", issueForProdJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nissForProdApiCallResStr :\n " +
			 * issForProdApiCallResStr); if(issForProdApiCallResStr.indexOf("error")!=-1) {
			 * JSONObject obj = new JSONObject(issForProdApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((issForProdApiCallResStr == null ||
			 * issForProdApiCallResStr.trim().length() == 0 ) || (issForProdApiCallResStr !=
			 * null && issForProdApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String receiptForProdApiCallResStr = ""; JSONObject receiptForProdJSON =
			 * productionSFAToSAPService.getReceiptBackflushService4(refID, absoluteEntry,
			 * conn);
			 * 
			 * String receiptForProdApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
			 * System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);
			 * 
			 * //receiptForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(receiptForProdJSON,
			 * receiptForProdApiURL, "POST"); receiptForProdApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("InventoryGenEntries",
			 * receiptForProdApiURL, "A", "E", refID, "F-DCR", "POST",
			 * receiptForProdJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nreceiptForProdApiCallResStr :\n " +
			 * receiptForProdApiCallResStr);
			 * if(receiptForProdApiCallResStr.indexOf("error")!=-1) { JSONObject obj = new
			 * JSONObject(receiptForProdApiCallResStr); JSONObject error =
			 * obj.getJSONObject("error"); JSONObject message =
			 * error.getJSONObject("message"); String value=message.getString("value");
			 * System.out.println("apiCallResponseJsonStr value in case of cash =["+value+
			 * "]");
			 * 
			 * returnValue=getErrorString(value); } if((receiptForProdApiCallResStr == null
			 * || receiptForProdApiCallResStr.trim().length() == 0 ) ||
			 * (receiptForProdApiCallResStr != null &&
			 * receiptForProdApiCallResStr.indexOf("error") == -1 )) {
			 * 
			 * String prodOrderCloseApiCallResStr = ""; JSONObject prodOrderCloseJSON =
			 * productionSFAToSAPService.getProductionOrderStatusChg5(refID, absoluteEntry,
			 * conn);
			 * 
			 * String prodOrderCloseApiURL =
			 * "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
			 * 
			 * System.out.println("\nprodOrderCloseApiURL :\n " + prodOrderCloseApiURL);
			 * 
			 * //prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData(prodOrderCloseJSON,
			 * prodOrderCloseApiURL, "PATCH"); prodOrderCloseApiCallResStr =
			 * e12ExternalAPICall.apiCallToPostData("ProductionOrdersAb",
			 * prodOrderCloseApiURL, "A", "E", refID, "F-DCR", "PATCH",
			 * prodOrderCloseJSON,userInfo,apiTranID) ;
			 * 
			 * System.out.println("\nprodOrderCloseApiCallResStr :\n " +
			 * prodOrderCloseApiCallResStr); } }
			 * 
			 * } } if( rs1 !=null ) { rs1.close(); rs1 = null; } if( pstmt1 !=null ) {
			 * pstmt1.close(); pstmt1 = null; } } }
			 */
			else if("rcpt_backflush".equalsIgnoreCase(objName))
			{
				int apiFailedCnt=0;
				int apiTotalCnt=0;
				//String apiCntSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='R-BFS' AND ENTERPRISE=? AND CALL_STATUS<>'S'";
				String apiCntSql="SELECT A.FAILED_COUNT, B.TOTAL_COUNT FROM "
						+ "(SELECT COUNT(*) AS FAILED_COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='R-BFS' AND ENTERPRISE=? AND CALL_STATUS <> 'S') A,"
						+ "(SELECT COUNT(*) AS TOTAL_COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='R-BFS' AND ENTERPRISE=?) B ";
				pstmt = conn.prepareStatement(apiCntSql);
				pstmt.setString(1, refID);
				pstmt.setString(2, enterprise);
				pstmt.setString(3, refID);
				pstmt.setString(4, enterprise);

				rs = pstmt.executeQuery();
				if(rs.next())
				{
					apiFailedCnt=rs.getInt("FAILED_COUNT");
					apiTotalCnt=rs.getInt("TOTAL_COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("listItem reintialize: apiFailedCnt["+apiFailedCnt+"], apiTotalCnt=["+apiTotalCnt+"]");

				if(apiFailedCnt > 0)
				{
					E12ExternalAPICall e12ExternalAPICall = new E12ExternalAPICall("SAP_PROD",userInfo);
					ProductionSFAToSAPService productionSFAToSAPService = new ProductionSFAToSAPService();
	
					String apiSql="SELECT API_NAME,TRAN_ID,REQUEST_DATA,RESPONSE_INFO FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='R-BFS' AND ENTERPRISE=? AND CALL_STATUS<>'S' ";
					pstmt1 = conn.prepareStatement(apiSql);
					pstmt1.setString(1, refID);
					pstmt1.setString(2, enterprise);
					rs1 = pstmt1.executeQuery();
					while(rs1.next())
					{
						String apiName=checkNull(rs1.getString("API_NAME"));
						String apiTranID=checkNull(rs1.getString("TRAN_ID"));
						String apiCallResponseJsonStr = "";
						
						JSONObject prodOrdPlanJSON = null;
						/*--- Not Required as the Stock Transfer Part API is called separately 
						JSONObject prodOrdPlanJSON = productionSFAToSAPService.getProductionOrderPlan(refID, conn);
						if(prodOrdPlanJSON != null)
						{
							String absoluteEntry = "";
							String prodOrdSpecialApiURL = "https://20.219.186.30:50000/b1s/v1/ProductionOrders";
							//apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(prodOrdSpecialJSON, prodOrdSpecialApiURL, "POST");
							apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("ProductionOrderPlan", prodOrdSpecialApiURL, "A", "E", refID, "R-BFS", "POST", prodOrdPlanJSON, userInfo,"") ;

							System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("error")!=-1)
							{
								JSONObject obj = new JSONObject(apiCallResponseJsonStr);
								JSONObject error = obj.getJSONObject("error");
								JSONObject message = error.getJSONObject("message");
								String value=message.getString("value");
								System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");

								returnValue = getErrorString(value);
							}
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1)
							{
								JSONObject prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
								//absoluteEntry = prodOrdSpecialDocEntryJSON.getString("AbsoluteEntry");
								absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+"";

							}

							System.out.println("absoluteEntry =["+absoluteEntry+"]");

							if(absoluteEntry != null && absoluteEntry.trim().length() > 0 )
							{
								String prodOrderStatApiCallResStr = "";
								JSONObject prodOrdReleasedJSON = productionSFAToSAPService.getProductionOrderRelease(refID, conn);

								System.out.println("\nprodOrdReleasedJSON :\n " + prodOrdReleasedJSON.toString());

								String prodOrdStatusApiURL = "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
								System.out.println("\nprodOrdStatusApiURL :\n " + prodOrdStatusApiURL);

								//prodOrderStatApiCallResStr = e12ExternalAPICall.apiCallToPostData(prodOrdStatusJSON, prodOrdStatusApiURL, "PATCH");
								prodOrderStatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ProductionOrderRelease", prodOrdStatusApiURL, "A", "E", refID, "R-BFS", "PATCH", prodOrdReleasedJSON,userInfo,"") ;

								System.out.println("\nprodOrderStatApiCallResStr:: \n"+prodOrderStatApiCallResStr);
								if(prodOrderStatApiCallResStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(prodOrderStatApiCallResStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value = message.getString("value");
									System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");

									returnValue = getErrorString(value);
								}
								if((prodOrderStatApiCallResStr == null || prodOrderStatApiCallResStr.trim().length() == 0 ) || (prodOrderStatApiCallResStr != null && prodOrderStatApiCallResStr.indexOf("error") == -1 ))
								{

									String issForProdApiCallResStr = "";
									JSONObject issueForProdJSON = productionSFAToSAPService.inventoryGenExits(refID, absoluteEntry, conn);

									String issueForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenExits";
									System.out.println("\nissueForProdApiURL :\n " + issueForProdApiURL);

									//issForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(issueForProdJSON, issueForProdApiURL, "POST");
									issForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenExits", issueForProdApiURL, "A", "E", refID, "R-BFS", "POST", issueForProdJSON,userInfo,"") ;

									System.out.println("\nissForProdApiCallResStr :\n " + issForProdApiCallResStr);
									if(issForProdApiCallResStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(issForProdApiCallResStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value = message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");

										returnValue = getErrorString(value);
									}
									if((issForProdApiCallResStr == null || issForProdApiCallResStr.trim().length() == 0 ) || (issForProdApiCallResStr != null && issForProdApiCallResStr.indexOf("error") == -1 ))
									{

										String receiptForProdApiCallResStr = "";
										JSONObject receiptForProdJSON = productionSFAToSAPService.getReceiptBackflushEntries(refID, absoluteEntry, conn);

										String receiptForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
										System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);

										//receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(receiptForProdJSON, receiptForProdApiURL, "POST");
										receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenEntries", receiptForProdApiURL, "A", "E", refID, "R-BFS", "POST", receiptForProdJSON,userInfo,"") ;

										System.out.println("\nreceiptForProdApiCallResStr :\n " + receiptForProdApiCallResStr);
										if(receiptForProdApiCallResStr.indexOf("error")!=-1)
										{
											JSONObject obj = new JSONObject(receiptForProdApiCallResStr);
											JSONObject error = obj.getJSONObject("error");
											JSONObject message = error.getJSONObject("message");
											String value = message.getString("value");
											System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");

											returnValue = getErrorString(value);
										}
										if((receiptForProdApiCallResStr == null || receiptForProdApiCallResStr.trim().length() == 0 ) || (receiptForProdApiCallResStr != null && receiptForProdApiCallResStr.indexOf("error") == -1 ))
										{

											String extraVadhChaatURL = "https://lbcp.rpminfotech.com/api/ExtraWaadh";
											String extraVadhChaatApiCallResStr = "";
											JSONObject extraVadhChaatJSON = productionSFAToSAPService.getProductionWadhAndChaat(refID, absoluteEntry, conn);

											System.out.println("\nextraVadhChaatURL :\n " + extraVadhChaatURL);

											extraVadhChaatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ExtraWadhChaat", extraVadhChaatURL, "A", "E", refID, "R-BFS", "POST", extraVadhChaatJSON,userInfo,"") ;
											
											System.out.println("extraVadhChaatApiCallResStr :"+extraVadhChaatApiCallResStr);

											if(extraVadhChaatApiCallResStr.indexOf("errorCode") != -1 )
											{
												String error = "";
												String message = "";
												JSONObject obj = new JSONObject(extraVadhChaatApiCallResStr);
												if(extraVadhChaatApiCallResStr.indexOf("errorCode") !=-1 )
												{
													error = obj.getString("errorCode");
													message = obj.getString("errorMessage");
												}
												
												String value = message;
												System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");

												returnValue = getErrorString(value);
											}

										}
									}
								}
							}//end of absoluteEntry

						}//end of prodOrdPlanJSON
						*/
						if("ProductionOrderPlan".equalsIgnoreCase(apiName))
						{
							apiCallResponseJsonStr = "";
	
							prodOrdPlanJSON = productionSFAToSAPService.getProductionOrderPlan(refID, conn);
							if(prodOrdPlanJSON != null)
							{
	
								String absoluteEntry = "";
								String prodOrdSpecialApiURL = "https://20.219.186.30:50000/b1s/v1/ProductionOrders";
								//apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData(prodOrdSpecialJSON, prodOrdSpecialApiURL, "POST");
								apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("ProductionOrderPlan", prodOrdSpecialApiURL, "A", "E", refID, "R-BFS", "POST", prodOrdPlanJSON, userInfo,apiTranID) ;
	
								System.out.println("apiCallResponseJsonStr =["+apiCallResponseJsonStr+"]");
								if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(apiCallResponseJsonStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value=message.getString("value");
									System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue = getErrorString(value);
								}
								if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1)
								{
									JSONObject prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
									//absoluteEntry = prodOrdSpecialDocEntryJSON.getString("AbsoluteEntry");
									absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+"";
	
								}
	
								System.out.println("absoluteEntry =["+absoluteEntry+"]");
	
								if(absoluteEntry != null && absoluteEntry.trim().length() > 0 )
								{
									String prodOrderStatApiCallResStr = "";
									JSONObject prodOrdReleasedJSON = productionSFAToSAPService.getProductionOrderRelease(refID, conn);
	
									System.out.println("\nprodOrdReleasedJSON :\n " + prodOrdReleasedJSON.toString());
	
									String prodOrdStatusApiURL = "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
									System.out.println("\nprodOrdStatusApiURL :\n " + prodOrdStatusApiURL);
	
									//prodOrderStatApiCallResStr = e12ExternalAPICall.apiCallToPostData(prodOrdStatusJSON, prodOrdStatusApiURL, "PATCH");
									prodOrderStatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ProductionOrderRelease", prodOrdStatusApiURL, "A", "E", refID, "R-BFS", "PATCH", prodOrdReleasedJSON,userInfo,"") ;
	
									System.out.println("\nprodOrderStatApiCallResStr:: \n"+prodOrderStatApiCallResStr);
									if(prodOrderStatApiCallResStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(prodOrderStatApiCallResStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value = message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
										returnValue = getErrorString(value);
									}
									if((prodOrderStatApiCallResStr == null || prodOrderStatApiCallResStr.trim().length() == 0 ) || (prodOrderStatApiCallResStr != null && prodOrderStatApiCallResStr.indexOf("error") == -1 ))
									{
	
										String issForProdApiCallResStr = "";
										JSONObject issueForProdJSON = productionSFAToSAPService.inventoryGenExits(refID, absoluteEntry, conn);
	
										String issueForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenExits";
										System.out.println("\nissueForProdApiURL :\n " + issueForProdApiURL);
	
										//issForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(issueForProdJSON, issueForProdApiURL, "POST");
										issForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenExits", issueForProdApiURL, "A", "E", refID, "R-BFS", "POST", issueForProdJSON,userInfo,"") ;
	
										System.out.println("\nissForProdApiCallResStr :\n " + issForProdApiCallResStr);
										if(issForProdApiCallResStr.indexOf("error")!=-1)
										{
											JSONObject obj = new JSONObject(issForProdApiCallResStr);
											JSONObject error = obj.getJSONObject("error");
											JSONObject message = error.getJSONObject("message");
											String value = message.getString("value");
											System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
											returnValue = getErrorString(value);
										}
										if((issForProdApiCallResStr == null || issForProdApiCallResStr.trim().length() == 0 ) || (issForProdApiCallResStr != null && issForProdApiCallResStr.indexOf("error") == -1 ))
										{
	
											String receiptForProdApiCallResStr = "";
											JSONObject receiptForProdJSON = productionSFAToSAPService.getReceiptBackflushEntries(refID, absoluteEntry, conn);
	
											String receiptForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
											System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);
	
											//receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(receiptForProdJSON, receiptForProdApiURL, "POST");
											receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenEntries", receiptForProdApiURL, "A", "E", refID, "R-BFS", "POST", receiptForProdJSON,userInfo,"") ;
	
											System.out.println("\nreceiptForProdApiCallResStr :\n " + receiptForProdApiCallResStr);
											if(receiptForProdApiCallResStr.indexOf("error")!=-1)
											{
												JSONObject obj = new JSONObject(receiptForProdApiCallResStr);
												JSONObject error = obj.getJSONObject("error");
												JSONObject message = error.getJSONObject("message");
												String value = message.getString("value");
												System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
												returnValue = getErrorString(value);
											}
											if((receiptForProdApiCallResStr == null || receiptForProdApiCallResStr.trim().length() == 0 ) || (receiptForProdApiCallResStr != null && receiptForProdApiCallResStr.indexOf("error") == -1 ))
											{
												
												String extraVadhChaatURL = "https://lbcp.rpminfotech.com/api/ExtraWaadh";
												String extraVadhChaatApiCallResStr = "";
												JSONObject extraVadhChaatJSON = productionSFAToSAPService.getProductionWadhAndChaat(refID, absoluteEntry, conn);
	
												System.out.println("\nextraVadhChaatURL :\n " + extraVadhChaatURL);
												
												extraVadhChaatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ExtraWadhChaat", extraVadhChaatURL, "A", "E", refID, "R-BFS", "POST", extraVadhChaatJSON,userInfo,"") ;
												
												if(extraVadhChaatApiCallResStr.indexOf("errorCode") != -1 )
												{
													String error = "";
													String message = "";
													JSONObject obj = new JSONObject(extraVadhChaatApiCallResStr);
													if(extraVadhChaatApiCallResStr.indexOf("errorCode") !=-1 )
													{
														error = obj.getString("errorCode");
														message = obj.getString("errorMessage");
													}
													
													String value = message;
													System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
													returnValue = getErrorString(value);
												}
	
											}
										}
									}
								}//end of absoluteEntry
							}
						}
						if("ProductionOrderRelease".equalsIgnoreCase(apiName))
						{
							//String apiCallResponseJsonStr="";
							String absoluteEntry = "";
	
	
							String resPSql="SELECT RESPONSE_INFO FROM API_CALL_LOG WHERE API_NAME='ProductionOrderPlan' AND REF_ID=?  ";
							pstmt = conn.prepareStatement(resPSql);
							pstmt.setString(1, refID);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								apiCallResponseJsonStr=checkNull(rs.getString("RESPONSE_INFO"));
							}
							if( pstmt !=null )
							{
								pstmt.close();
								pstmt = null;
							}
							if( rs !=null )
							{
								rs.close();
								rs = null;
							}
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1)
							{
								JSONObject prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
								absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+"";
							}
							if(absoluteEntry != null && absoluteEntry.trim().length() > 0 )
							{
								String prodOrderStatApiCallResStr = "";
								JSONObject prodOrdReleasedJSON = productionSFAToSAPService.getProductionOrderRelease(refID, conn);
	
								System.out.println("\nprodOrdReleasedJSON :\n " + prodOrdReleasedJSON.toString());
	
								String prodOrdStatusApiURL = "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
								System.out.println("\nprodOrdStatusApiURL :\n " + prodOrdStatusApiURL);
	
								prodOrderStatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ProductionOrderRelease", prodOrdStatusApiURL, "A", "E", refID, "R-BFS", "PATCH", prodOrdReleasedJSON,userInfo,apiTranID) ;
	
								System.out.println("\nprodOrderStatApiCallResStr:: \n"+prodOrderStatApiCallResStr);
								if(prodOrderStatApiCallResStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(prodOrderStatApiCallResStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value = message.getString("value");
									System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue = getErrorString(value);
								}
								if((prodOrderStatApiCallResStr == null || prodOrderStatApiCallResStr.trim().length() == 0 ) || (prodOrderStatApiCallResStr != null && prodOrderStatApiCallResStr.indexOf("error") == -1 ))
								{
	
									String issForProdApiCallResStr = "";
									JSONObject issueForProdJSON = productionSFAToSAPService.inventoryGenExits(refID, absoluteEntry, conn);
	
									String issueForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenExits";
									System.out.println("\nissueForProdApiURL :\n " + issueForProdApiURL);
	
									issForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenExits", issueForProdApiURL, "A", "E", refID, "R-BFS", "POST", issueForProdJSON,userInfo,"") ;
	
									System.out.println("\nissForProdApiCallResStr :\n " + issForProdApiCallResStr);
									if(issForProdApiCallResStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(issForProdApiCallResStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value = message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
										returnValue = getErrorString(value);
									}
									if((issForProdApiCallResStr == null || issForProdApiCallResStr.trim().length() == 0 ) || (issForProdApiCallResStr != null && issForProdApiCallResStr.indexOf("error") == -1 ))
									{
	
										String receiptForProdApiCallResStr = "";
										JSONObject receiptForProdJSON = productionSFAToSAPService.getReceiptBackflushEntries(refID, absoluteEntry, conn);
	
										String receiptForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
										System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);
	
										//receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(receiptForProdJSON, receiptForProdApiURL, "POST");
										receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenEntries", receiptForProdApiURL, "A", "E", refID, "R-BFS", "POST", receiptForProdJSON,userInfo,"") ;
	
										System.out.println("\nreceiptForProdApiCallResStr :\n " + receiptForProdApiCallResStr);
										if(receiptForProdApiCallResStr.indexOf("error")!=-1)
										{
											JSONObject obj = new JSONObject(receiptForProdApiCallResStr);
											JSONObject error = obj.getJSONObject("error");
											JSONObject message = error.getJSONObject("message");
											String value = message.getString("value");
											System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
											returnValue = getErrorString(value);
										}
										if((receiptForProdApiCallResStr == null || receiptForProdApiCallResStr.trim().length() == 0 ) || (receiptForProdApiCallResStr != null && receiptForProdApiCallResStr.indexOf("error") == -1 ))
										{
										
											
											String extraVadhChaatURL = "https://lbcp.rpminfotech.com/api/ExtraWaadh";
											String extraVadhChaatApiCallResStr = "";
											JSONObject extraVadhChaatJSON = productionSFAToSAPService.getProductionWadhAndChaat(refID, absoluteEntry, conn);
	
											System.out.println("\nextraVadhChaatURL :\n " + extraVadhChaatURL);
											
											extraVadhChaatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ExtraWadhChaat", extraVadhChaatURL, "A", "E", refID, "R-BFS", "POST", extraVadhChaatJSON,userInfo,"") ;
											
											if(extraVadhChaatApiCallResStr.indexOf("errorCode") != -1 )
											{
												String error = "";
												String message = "";
												JSONObject obj = new JSONObject(extraVadhChaatApiCallResStr);
												if(extraVadhChaatApiCallResStr.indexOf("errorCode") !=-1 )
												{
													error = obj.getString("errorCode");
													message = obj.getString("errorMessage");
												}
												
												String value = message;
												System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
												returnValue = getErrorString(value);
											}
	
										}
									}
								}
							}
						}
						if("InventoryGenExits".equalsIgnoreCase(apiName))
						{
							//String apiCallResponseJsonStr="";
							String absoluteEntry = "";
	
	
							String resPSql="SELECT RESPONSE_INFO FROM API_CALL_LOG WHERE API_NAME='ProductionOrderPlan' AND REF_ID=?  ";
							pstmt = conn.prepareStatement(resPSql);
							pstmt.setString(1, refID);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								apiCallResponseJsonStr=checkNull(rs.getString("RESPONSE_INFO"));
							}
							if( pstmt !=null )
							{
								pstmt.close();
								pstmt = null;
							}
							if( rs !=null )
							{
								rs.close();
								rs = null;
							}
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1)
							{
								JSONObject prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
								absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+"";
							}
							if(absoluteEntry != null && absoluteEntry.trim().length() > 0 )
							{
								JSONObject issueForProdJSON = productionSFAToSAPService.inventoryGenExits(refID, absoluteEntry, conn);
	
	
								String issueForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenExits";
								System.out.println("\nissueForProdApiURL :\n " + issueForProdApiURL);
	
								//issForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(issueForProdJSON, issueForProdApiURL, "POST");
								String issForProdApiCallResStr = "";
								issForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenExits", issueForProdApiURL, "A", "E", refID, "R-BFS", "POST", issueForProdJSON,userInfo,apiTranID) ;
	
								System.out.println("\nissForProdApiCallResStr :\n " + issForProdApiCallResStr);
								if(issForProdApiCallResStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(issForProdApiCallResStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value = message.getString("value");
									System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue = getErrorString(value);
								}
								if((issForProdApiCallResStr == null || issForProdApiCallResStr.trim().length() == 0 ) || (issForProdApiCallResStr != null && issForProdApiCallResStr.indexOf("error") == -1 ))
								{
	
									String receiptForProdApiCallResStr = "";
									JSONObject receiptForProdJSON = productionSFAToSAPService.getReceiptBackflushEntries(refID, absoluteEntry, conn);
	
									String receiptForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
									System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);
	
									//receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(receiptForProdJSON, receiptForProdApiURL, "POST");
									receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenEntries", receiptForProdApiURL, "A", "E", refID, "R-BFS", "POST", receiptForProdJSON,userInfo,"") ;
	
									System.out.println("\nreceiptForProdApiCallResStr :\n " + receiptForProdApiCallResStr);
									if(receiptForProdApiCallResStr.indexOf("error")!=-1)
									{
										JSONObject obj = new JSONObject(receiptForProdApiCallResStr);
										JSONObject error = obj.getJSONObject("error");
										JSONObject message = error.getJSONObject("message");
										String value = message.getString("value");
										System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
										returnValue = getErrorString(value);
									}
									if((receiptForProdApiCallResStr == null || receiptForProdApiCallResStr.trim().length() == 0 ) || (receiptForProdApiCallResStr != null && receiptForProdApiCallResStr.indexOf("error") == -1 ))
									{
	
										
										String extraVadhChaatURL = "https://lbcp.rpminfotech.com/api/ExtraWaadh";
										String extraVadhChaatApiCallResStr = "";
										JSONObject extraVadhChaatJSON = productionSFAToSAPService.getProductionWadhAndChaat(refID, absoluteEntry, conn);
	
										System.out.println("\nextraVadhChaatURL :\n " + extraVadhChaatURL);
										
										extraVadhChaatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ExtraWadhChaat", extraVadhChaatURL, "A", "E", refID, "R-BFS", "POST", extraVadhChaatJSON,userInfo,"") ;
										
										if(extraVadhChaatApiCallResStr.indexOf("errorCode") != -1 )
										{
											String error = "";
											String message = "";
											JSONObject obj = new JSONObject(extraVadhChaatApiCallResStr);
											if(extraVadhChaatApiCallResStr.indexOf("errorCode") !=-1 )
											{
												error = obj.getString("errorCode");
												message = obj.getString("errorMessage");
											}
											
											String value = message;
											System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
											returnValue = getErrorString(value);
										}
	
									}
								}
							}
						}
						if("InventoryGenEntries".equalsIgnoreCase(apiName))
						{
							//String apiCallResponseJsonStr="";
							String absoluteEntry = "";
	
	
							String resPSql="SELECT RESPONSE_INFO FROM API_CALL_LOG WHERE API_NAME='ProductionOrderPlan' AND REF_ID=?  ";
							pstmt = conn.prepareStatement(resPSql);
							pstmt.setString(1, refID);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								apiCallResponseJsonStr=checkNull(rs.getString("RESPONSE_INFO"));
							}
							if( pstmt !=null )
							{
								pstmt.close();
								pstmt = null;
							}
							if( rs !=null )
							{
								rs.close();
								rs = null;
							}
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1)
							{
								JSONObject prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
								absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+"";
							}
							if(absoluteEntry != null && absoluteEntry.trim().length() > 0 )
							{
	
								String receiptForProdApiCallResStr = "";
								JSONObject receiptForProdJSON = productionSFAToSAPService.getReceiptBackflushEntries(refID, absoluteEntry, conn);
	
								String receiptForProdApiURL = "https://20.219.186.30:50000/b1s/v1/InventoryGenEntries";
								System.out.println("\nreceiptForProdApiURL :\n " + receiptForProdApiURL);
	
								//receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData(receiptForProdJSON, receiptForProdApiURL, "POST");
								receiptForProdApiCallResStr = e12ExternalAPICall.apiCallToPostData("InventoryGenEntries", receiptForProdApiURL, "A", "E", refID, "R-BFS", "POST", receiptForProdJSON,userInfo,apiTranID) ;
	
								System.out.println("\nreceiptForProdApiCallResStr :\n " + receiptForProdApiCallResStr);
								if(receiptForProdApiCallResStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(receiptForProdApiCallResStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value = message.getString("value");
									System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue = getErrorString(value);
								}
								if((receiptForProdApiCallResStr == null || receiptForProdApiCallResStr.trim().length() == 0 ) || (receiptForProdApiCallResStr != null && receiptForProdApiCallResStr.indexOf("error") == -1 ))
								{
									/*--This code is commented as per requrest from RPM. Production order will not be closed in any case
									String prodOrderCloseApiCallResStr = "";
									JSONObject prodOrderCloseJSON = productionSFAToSAPService.getProductionOrderClose(tranId, absoluteEntry, conn);
	
									String prodOrderCloseApiURL = "https://20.219.186.30:50000/b1s/v1/ProductionOrders("+absoluteEntry+")";
	
									System.out.println("\nprodOrderCloseApiURL :\n " + prodOrderCloseApiURL);
									
									if(prodOrderCloseJSON != null && prodOrderCloseJSON.toString().length() > 0)
									{
										//prodOrderCloseApiCallResStr = e12ExternalAPICall.apiCallToPostData(prodOrderCloseJSON, prodOrderCloseApiURL, "PATCH");
										prodOrderCloseApiCallResStr = e12ExternalAPICall.apiCallToPostData("ProductionOrderClose", prodOrderCloseApiURL, "A", "E", tranId, "F-DCR", "PATCH", prodOrderCloseJSON,userInfo,"") ;
		
										System.out.println("\nprodOrderCloseApiCallResStr :\n " + prodOrderCloseApiCallResStr);
									}
									*/
									
									String extraVadhChaatURL = "https://lbcp.rpminfotech.com/api/ExtraWaadh";
									String extraVadhChaatApiCallResStr = "";
									JSONObject extraVadhChaatJSON = productionSFAToSAPService.getProductionWadhAndChaat(refID, absoluteEntry, conn);
	
									System.out.println("\nextraVadhChaatURL :\n " + extraVadhChaatURL);
									
									extraVadhChaatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ExtraWadhChaat", extraVadhChaatURL, "A", "E", refID, "R-BFS", "POST", extraVadhChaatJSON,userInfo,"") ;
									
									if(extraVadhChaatApiCallResStr.indexOf("errorCode") != -1 )
									{
										String error = "";
										String message = "";
										JSONObject obj = new JSONObject(extraVadhChaatApiCallResStr);
										if(extraVadhChaatApiCallResStr.indexOf("errorCode") !=-1 )
										{
											error = obj.getString("errorCode");
											message = obj.getString("errorMessage");
										}
										
										String value = message;
										System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
										returnValue = getErrorString(value);
									}
	
								}
							}
						}
						if("ExtraWadhChaat".equalsIgnoreCase(apiName))
						{
							//String apiCallResponseJsonStr="";
							String absoluteEntry = "";
	
							String resPSql="SELECT RESPONSE_INFO FROM API_CALL_LOG WHERE API_NAME='ProductionOrderPlan' AND REF_ID=?  ";
							pstmt = conn.prepareStatement(resPSql);
							pstmt.setString(1, refID);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								apiCallResponseJsonStr=checkNull(rs.getString("RESPONSE_INFO"));
							}
							if( pstmt !=null )
							{
								pstmt.close();
								pstmt = null;
							}
							if( rs !=null )
							{
								rs.close();
								rs = null;
							}
							if(apiCallResponseJsonStr.indexOf("[")==0 && apiCallResponseJsonStr.lastIndexOf("]")==apiCallResponseJsonStr.length()-1)
							{
								apiCallResponseJsonStr=apiCallResponseJsonStr.substring(1, apiCallResponseJsonStr.length()-1);
							}
							if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("AbsoluteEntry") != -1)
							{
								JSONObject prodOrdSpecialDocEntryJSON = new JSONObject(apiCallResponseJsonStr);
								absoluteEntry = prodOrdSpecialDocEntryJSON.getInt("AbsoluteEntry")+"";
							}
							if(absoluteEntry != null && absoluteEntry.trim().length() > 0 )
							{
								
								String extraVadhChaatURL = "https://lbcp.rpminfotech.com/api/ExtraWaadh";
								String extraVadhChaatApiCallResStr = "";
								JSONObject extraVadhChaatJSON = productionSFAToSAPService.getProductionWadhAndChaat(refID, absoluteEntry, conn);
	
								System.out.println("\nextraVadhChaatURL :\n " + extraVadhChaatURL);
								
								extraVadhChaatApiCallResStr = e12ExternalAPICall.apiCallToPostData("ExtraWadhChaat", extraVadhChaatURL, "A", "E", refID, "R-BFS", "POST", extraVadhChaatJSON,userInfo,apiTranID) ;
								
								if(extraVadhChaatApiCallResStr.indexOf("errorCode") != -1 )
								{
									String error = "";
									String message = "";
									JSONObject obj = new JSONObject(extraVadhChaatApiCallResStr);
									if(extraVadhChaatApiCallResStr.indexOf("errorCode") !=-1 )
									{
										error = obj.getString("errorCode");
										message = obj.getString("errorMessage");
									}
									
									String value = message;
									System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue = getErrorString(value);
								}
							}
						
						}
					}
					if( rs1 !=null )
					{
						rs1.close();
						rs1 = null;
					}
					if( pstmt1 !=null )
					{
						pstmt1.close();
						pstmt1 = null;
					}
				}
				else if(apiTotalCnt == 0)
				{
					ProductionSFAToSAPAPICalling prodAPICompCall = new ProductionSFAToSAPAPICalling();
					returnValue = prodAPICompCall.callTheJsonCaseWiseProduction(refID, xtraParam, conn);
					return returnValue;
					
				}
			}//recp_backflush
			else if("issue_transfer_wiz".equalsIgnoreCase(objName))
			{
				int apiFailedCnt=0;
				int apiTotalCnt=0;
				//String apiCntSql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='XFRX' AND ENTERPRISE=? AND CALL_STATUS <> 'S'";
				String apiCntSql="SELECT A.FAILED_COUNT, B.TOTAL_COUNT FROM "
						+ "(SELECT COUNT(*) AS FAILED_COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='XFRX' AND ENTERPRISE=? AND CALL_STATUS <> 'S') A,"
						+ "(SELECT COUNT(*) AS TOTAL_COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='XFRX' AND ENTERPRISE=?) B ";
				pstmt = conn.prepareStatement(apiCntSql);
				pstmt.setString(1, refID);
				pstmt.setString(2, enterprise);
				pstmt.setString(3, refID);
				pstmt.setString(4, enterprise);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					apiFailedCnt = rs.getInt("FAILED_COUNT");
					apiTotalCnt = rs.getInt("TOTAL_COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("listItem reintialize: apiFailedCnt["+apiFailedCnt+"], apiTotalCnt=["+apiTotalCnt+"]");
				
				if(apiFailedCnt > 0)
				{
					E12ExternalAPICall e12ExternalAPICall = new E12ExternalAPICall("SAP_PROD",userInfo);
					ProductionSFAToSAPService productionSFAToSAPService = new ProductionSFAToSAPService();
	
					String apiSql="SELECT API_NAME,TRAN_ID,REQUEST_DATA,RESPONSE_INFO FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='XFRX' AND ENTERPRISE=? AND CALL_STATUS <> 'S' ";
					pstmt1 = conn.prepareStatement(apiSql);
					pstmt1.setString(1, refID);
					pstmt1.setString(2, enterprise);
					rs1 = pstmt1.executeQuery();
					while(rs1.next())
					{
						String apiName=checkNull(rs1.getString("API_NAME"));
						String apiTranID=checkNull(rs1.getString("TRAN_ID"));
						//String requestData=checkNull(rs.getString("REQUEST_DATA"));
						//JSONObject object = new JSONObject(requestData);
						if("StocktransferWHSToWorker".equalsIgnoreCase(apiName))
						{
							JSONObject invTrfWHSToWorkerJSON = productionSFAToSAPService.getInvTransferOfWHSToWorker(refID, conn);
							if(invTrfWHSToWorkerJSON != null)
							{
								String apiCallResponseJsonStr = "";
								String invTrfApiURL = "https://20.219.186.30:50000/b1s/v1/StockTransfers";
								apiCallResponseJsonStr = e12ExternalAPICall.apiCallToPostData("StocktransferWHSToWorker", invTrfApiURL, "A", "E", refID, "XFRX", "POST", invTrfWHSToWorkerJSON, userInfo,apiTranID) ;
	
								if(apiCallResponseJsonStr != null && apiCallResponseJsonStr.indexOf("error")!=-1)
								{
									JSONObject obj = new JSONObject(apiCallResponseJsonStr);
									JSONObject error = obj.getJSONObject("error");
									JSONObject message = error.getJSONObject("message");
									String value = message.getString("value");
									System.out.println("apiCallResponseJsonStr value in case of cash =["+value+"]");
	
									returnValue = getErrorString(value);
								}
							}
						}
					}
					if( rs1 !=null )
					{
						rs1.close();
						rs1 = null;
					}
					if( pstmt1 !=null )
					{
						pstmt1.close();
						pstmt1 = null;
					}
				}
				else if(apiTotalCnt == 0)
				{
					ProductionSFAToSAPAPICalling prodAPICompCall = new ProductionSFAToSAPAPICalling();
					returnValue = prodAPICompCall.postStockTransferDataToSAP(refID, xtraParam, conn);
					return returnValue;
				}
			}//issue_transfer_wiz
			int Cnt=0;
			String Sql="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=?  AND ENTERPRISE=? AND CALL_STATUS<>'S'";
			pstmt = conn.prepareStatement(Sql);
			pstmt.setString(1, refID);
			pstmt.setString(2, enterprise);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				Cnt=rs.getInt("COUNT");
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}	
			
			if(Cnt==0)
			{
				ITMDBAccessEJB itmdbAccessLocal = new ITMDBAccessEJB();
				returnValue = itmdbAccessLocal.getErrorString("confirmed", "REISUCESS", "","",conn);
			}
			else
			{
				ITMDBAccessEJB itmdbAccessLocal = new ITMDBAccessEJB();
				returnValue = itmdbAccessLocal.getErrorString("confirmed", "REESUCESS", "","",conn);
			}
		}
		catch (Exception e) 
		{
			isError = true;
			System.out.println("Exception :StrgMeetDCRWizConf :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if ( isLocalConn )
					{
						if ( ! isError )
						{
							conn.commit();
							System.out.println("StrgMeetDCRWizConf Connection commited........");
						}
						conn.close();
						conn = null;
                    }
                    
					if( rs !=null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt1 !=null )
					{
						pstmt1.close();
						pstmt1 = null;
					}
					if( rs1 !=null )
					{
						rs1.close();
						rs1 = null;
					}
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
	    }
		return returnValue;
	}

	
    //Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
    //public JSONObject getARInvoiceDetails(String empSite,String stateCode,String locGroup,String BinAbsEntry,String strgCode,String tranDate,String remarks,String salesPers,String custStateCode,String tranID,String payMode,String gstNo,String tranInvoicID,String cheqNo,String apiName,Connection conn, String loadNo) throws ITMException
	public JSONObject getARInvoiceDetails(String empSite,String stateCode,String locGroup,String BinAbsEntry,String strgCode,String tranDate,String remarks,String salesPers,String custStateCode,String tranID,String payMode,String gstNo,String tranInvoicID,String cheqNo,String apiName,Connection conn, String loadNo,String refBank) throws ITMException
	//Changed by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
	{

		JSONObject obj = new JSONObject();
		PreparedStatement pstmt=null;
		PreparedStatement pst1=null;
		ResultSet rs1=null;
		ResultSet rs=null;
		try 
		{
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String companyDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_NAME_VAL",conn);
			String userNameDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_USER_VAL",conn);
			String passwordDB = strgMeetDCRWizard.getSfaParmValue(salesPers,"API_DB_PASS_VAL",conn);
			
			System.out.print("Inside getARInvoiceDetails for json");

            E12GenericUtility genericUtility = new E12GenericUtility();
			JSONArray batchJsonArray = new JSONArray();

			//String displayDate=genericUtility.getValidDateString( tranDate, "yyyy-MM-dd", "dd/MM/yyy") ;

			int itemLine=0;
			String salesType = "";
			String invoiceStatus = "";
			//commented and changed by Gulzar on 21dec23
			/*
			String invoiceSql="SELECT SMI.LINE_NO,SMI.QUANTITY,SMI.ITEM_CODE,SMI.RATE,STOCK.LOT_NO  "
					+ "FROM STRG_MEET_INVOICE SMI,STOCK STOCK WHERE TRAN_ID= ? AND SMI.ITEM_CODE=STOCK.ITEM_CODE AND STOCK.SITE_CODE= ?  "
					+ "AND STOCK.LOC_CODE=? AND SMI.INVOICE_ID=? AND SMI.QUANTITY<>0 ";
			*/
			String invoiceSql="SELECT SMI.LINE_NO,SMI.QUANTITY,SMI.ITEM_CODE,SMI.RATE,STOCK.LOT_NO"
					+ ", (CASE WHEN SM.SALES_TYPE ='I' THEN 'B2B' WHEN SM.SALES_TYPE ='C' THEN 'Sales' ELSE SM.SALES_TYPE END ) AS SALES_TYPE "
					+ ",SMI.INVOICE_STATUS AS INVOICE_STATUS "
					+ "FROM STRG_MEET_INVOICE SMI,STOCK STOCK, STRG_MEET SM WHERE SMI.TRAN_ID = SM.TRAN_ID AND SMI.TRAN_ID= ? AND SMI.ITEM_CODE=STOCK.ITEM_CODE AND STOCK.SITE_CODE= ?  "
					+ "AND STOCK.LOC_CODE=? AND SMI.INVOICE_ID=? AND nvl(SMI.QUANTITY,0)<>0 ";

			pst1 = conn.prepareStatement(invoiceSql);
			pst1.setString(1, tranID);
			pst1.setString(2, empSite);
			pst1.setString(3, salesPers);
			pst1.setString(4, tranInvoicID);

			rs1 = pst1.executeQuery();
			
			System.out.println("before the resultset.........");
			
			while(rs1.next())
			{
				System.out.println("Inside the resultset.........");
				JSONObject batchJsonObj = new JSONObject();					

				JSONObject BatchNumbersObj = new JSONObject();
				JSONArray BatchNumbersArray = new JSONArray();
				
				JSONArray DocumentLinesBinAllocationsArray = new JSONArray();
				JSONObject DocumentLinesBinAllocationsObj = new JSONObject();


				String itemCode=checkNull(rs1.getString("ITEM_CODE"));
				String lotNo=checkNull(rs1.getString("LOT_NO"));
				double quantity=rs1.getDouble("QUANTITY");
				double rate=rs1.getDouble("RATE");
				salesType=checkNull(rs1.getString("SALES_TYPE"));
				invoiceStatus=checkNull(rs1.getString("INVOICE_STATUS"));
				
				System.out.println("itemCode =["+itemCode+"], lotNo=["+lotNo+"],quantity=["+quantity+"],rate=["+rate+"], salesType=["+salesType+"]");

				BatchNumbersObj.put("BatchNumber", lotNo);
				BatchNumbersObj.put("Quantity", quantity);
				BatchNumbersObj.put("BaseLineNumber", itemLine);
				BatchNumbersObj.put("ItemCode", itemCode);
				//BatchNumbersArray.add(BatchNumbersObj);
				BatchNumbersArray.put(BatchNumbersObj);

				DocumentLinesBinAllocationsObj.put("BinAbsEntry", BinAbsEntry);
				DocumentLinesBinAllocationsObj.put("Quantity", quantity);
				//DocumentLinesBinAllocationsObj.put("SerialAndBatchNumbersBaseLine", itemLine);
				DocumentLinesBinAllocationsObj.put("SerialAndBatchNumbersBaseLine", "0");
				DocumentLinesBinAllocationsObj.put("BaseLineNumber", itemLine);
				//DocumentLinesBinAllocationsArray.add(DocumentLinesBinAllocationsObj);
				DocumentLinesBinAllocationsArray.put(DocumentLinesBinAllocationsObj);


				batchJsonObj.put("LineNum", itemLine);
				batchJsonObj.put("ItemCode", itemCode);
				batchJsonObj.put("Quantity", quantity);
				System.out.println("Sales Person stateCode["+stateCode+"] custStateCode =["+custStateCode+"]");
				if(stateCode.trim().equalsIgnoreCase(custStateCode.trim()))
				{
					batchJsonObj.put("TaxCode", "CG+SG@28");
				}
				else
				{
					batchJsonObj.put("TaxCode", "IGST@28");
				}
				batchJsonObj.put("UnitPrice", rate);
				batchJsonObj.put("DiscountPercent", "0");
				batchJsonObj.put("WarehouseCode", locGroup);
				batchJsonObj.put("BatchNumbers", BatchNumbersArray);
				batchJsonObj.put("DocumentLinesBinAllocations", DocumentLinesBinAllocationsArray);
				//batchJsonArray.add(batchJsonObj);
				batchJsonArray.put(batchJsonObj);
				itemLine++;
			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pst1 !=null )
			{
				pst1.close();
				pst1 = null;
			}
			
			obj.put("CardCode", strgCode);
			obj.put("BPL_IDAssignedToInvoice", empSite);
			obj.put("DocDate", tranDate);
			obj.put("DocType", "I");
			obj.put("Comments", remarks);
			//obj.put("SalesPersonCode", "U_SLPRN");	// changed by Rahul P. on 01-Dec-23 
			obj.put("SalesPersonCode", salesPers);
			
			/*--Commented and changed by Gulzar on 15FEB24 
			if(gstNo==null || gstNo.trim().length()==0)
			{
				if("C".equalsIgnoreCase(payMode) || "R".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode) || "U".equalsIgnoreCase(payMode) )
				{
					obj.put("GSTTransactionType", "GA");

				}

			}*/
			obj.put("GSTTransactionType", "GA");
			//End changed by Gulzar on 15FEB24 
			
			obj.put("DiscountPercent", "0.0");
			obj.put("U_SOM", "M");
			obj.put("U_MTID",tranID);
			obj.put("U_MIN",tranInvoicID);
			if("DeliveryNotes".equalsIgnoreCase(apiName) && "Q".equalsIgnoreCase(payMode))
			{
				obj.put("U_CHKN",cheqNo);
				obj.put("U_MOPT",payMode);//Added by Gulzar on 250423 as changes requested from RPM
			}
			else //if("DeliveryNotes".equalsIgnoreCase(apiName))
			{
				obj.put("U_CHKN","");
				obj.put("U_MOPT",payMode);//Added by Gulzar on 250423 as changes requested from RPM

			}
			// Added by Rahul P. on 01-Dec-23 to add Bank name in JSON [Start]
			obj.put("U_BNKNM", refBank);
			// Added by Rahul P. on 01-Dec-23 to add Bank name in JSON [End]
			obj.put("U_MSaleType", salesType);
			obj.put("U_AINVSTAT", invoiceStatus);//Added by Guzar 25FEB24 to post invoice status
			
			obj.put("CompanyDB", companyDB);
			obj.put("Password", passwordDB);
			obj.put("UserName", userNameDB);
			obj.put("U_MLDN", loadNo);
			
			obj.put("DocumentLines",batchJsonArray);
			
			System.out.println("getCashWiseInvoiceDetails for json :: "+obj.toString());
		}
		catch(Exception e)
		{
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pst1 !=null )
				{
					pst1.close();
					pst1 = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return obj;
	}
	public JSONObject getIncomingPayment(String empSite,String stateCode,String locGroup,String BinAbsEntry,String strgCode,String tranDate,String remarks,String salesPers,String custStateCode,String tranID,String payMode,String totalAmount,String docEntry, String invoiceID,Connection conn, String chequeNo, String cardCode) throws ITMException
	{

		JSONObject customerJsonObj = new JSONObject();
		PreparedStatement pstmt=null;
		PreparedStatement pst1=null;
		ResultSet rs1=null;
		ResultSet rs=null;
		try
		{

			
            JSONArray PaymentInvoiceJsonArray = new JSONArray();
            String SumApplied="";
 
            String acctCodeTrf = "";

			String safParmSql="SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT='ALL' AND PARM_NAME ='ACCT_CODE_TRANSFER' AND ACTIVE='Y'";
					
			pst1 = conn.prepareStatement(safParmSql);
	
			rs1 = pst1.executeQuery();
			if(rs1.next())
			{
				acctCodeTrf = checkNull(rs1.getString("PARM_VALUE"));
			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pst1 !=null )
			{
				pst1.close();
				pst1 = null;
			}
            
			String invoiceSql="SELECT DISTINCT SMI.STRG_CODE, "
						+ "round((SUM(smi.quantity*smi.rate) + SUM(smi.quantity*smi.rate*DDF_TOTAL_TAX_AMOUNT( 'CGST' )/100) +SUM(smi.quantity*smi.rate*DDF_TOTAL_TAX_AMOUNT( 'SGST' )/100)),0) AS TOTAL, "
						+ "SMI.INVOICE_ID "
						+ "FROM STRG_MEET_INVOICE SMI,ITEM I  "
						+ "WHERE "
						+ "SMI.ITEM_CODE = I.ITEM_CODE AND SMI.TRAN_ID=? AND SMI.INVOICE_ID=? "
						+ "GROUP BY SMI.STRG_CODE,SMI.TRAN_ID,SMI.INVOICE_ID ";
						
			pst1 = conn.prepareStatement(invoiceSql);
			pst1.setString(1, tranID);
			pst1.setString(2, invoiceID);

			rs1 = pst1.executeQuery();
			int itemLine=0;
			if(rs1.next())
			{
				JSONObject PaymentInvoicesjsonObj = new JSONObject();
				SumApplied=checkNull(rs1.getString("TOTAL"));

				PaymentInvoicesjsonObj.put("LineNum",itemLine);
				PaymentInvoicesjsonObj.put("DocEntry", docEntry);
				PaymentInvoicesjsonObj.put("SumApplied", SumApplied);
				PaymentInvoicesjsonObj.put("InvoiceType", "it_Invoice");	
				//PaymentInvoiceJsonArray.add(PaymentInvoicesjsonObj);
				PaymentInvoiceJsonArray.put(PaymentInvoicesjsonObj);
				itemLine++;

			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pst1 !=null )
			{
				pst1.close();
				pst1 = null;
			}

			customerJsonObj.put("DocType", "rCustomer");
			customerJsonObj.put("DocDate", tranDate);
			//Commented and changed by Gulzar on 15-Feb-2024
			//customerJsonObj.put("CardCode", strgCode);
			customerJsonObj.put("CardCode", cardCode);
			//End changed by Gulzar on 15-Feb-2024
			//customerJsonObj.put("CashSum", totalAmount);
			if("O".equalsIgnoreCase(payMode) || "R".equalsIgnoreCase(payMode) || "N".equalsIgnoreCase(payMode) || "U".equalsIgnoreCase(payMode))
			{
				customerJsonObj.put("TransferAccount", acctCodeTrf);
				customerJsonObj.put("TransferSum", SumApplied);
			}
			else if("C".equalsIgnoreCase(payMode)) 
			{
				customerJsonObj.put("CashSum", SumApplied);
			}
			else if("Q".equalsIgnoreCase(payMode))
			{
				//Commented and changed by Sanket 
				// In case of Cheque Payment the CashSum and TransferSum should be 0
				//customerJsonObj.put("CashSum", SumApplied);
				customerJsonObj.put("CashSum", "0");
				customerJsonObj.put("TransferSum", "0");
			}

			customerJsonObj.put("TransferDate", tranDate);
			customerJsonObj.put("Remarks", remarks);
			customerJsonObj.put("TaxDate",tranDate);
			customerJsonObj.put("BPLID",empSite);
			customerJsonObj.put("U_SOM","M");
			customerJsonObj.put("U_MIN",invoiceID);
			customerJsonObj.put("U_MTID",tranID);

			customerJsonObj.put("PaymentInvoices",PaymentInvoiceJsonArray);
			
			//Changed by Sanket - Start
			if(payMode.equalsIgnoreCase("Q"))
			{

				JSONObject paymentChecksObj = new JSONObject();
				JSONArray paymentChecksArray = new JSONArray();

				paymentChecksObj.put("CheckNumber", chequeNo);
				paymentChecksObj.put("CheckSum", SumApplied);

				paymentChecksArray.put(paymentChecksObj);
				customerJsonObj.put("PaymentChecks",paymentChecksArray);
			}
			//Changed by Sanket - END

			System.out.println( "Inside getCustomerWiseIncomingPayment objArray["+customerJsonObj.toString()+"]" );
		}
		catch(Exception e){
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pst1 !=null )
				{
					pst1.close();
					pst1 = null;
				}
			}
			catch(Exception e) {}
		}
		return 	customerJsonObj;

	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	public String getErrorString(String message)
	{
		StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );

		try
		{
			valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
			valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
			valueXmlErrorString.append("<description><![CDATA[").append(message).append("]]></description>\r\n");
			valueXmlErrorString.append("<type>E</type>\r\n");
			valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
			valueXmlErrorString.append("<redirect>1</redirect>\r\n");
			valueXmlErrorString.append("</error>\r\n");
			valueXmlErrorString.append("</Errors>\r\n");
			valueXmlErrorString.append("</Header>\r\n");
			valueXmlErrorString.append( "</Root>\r\n" );
			System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
			

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return valueXmlErrorString.toString();
	}
	
	public JSONObject getSplitInvoiceDetails(String dcrId,String dcrIdInForm, Connection conn, String loadNo) throws ITMException 
	{
		PreparedStatement pstmt1=null;
		ResultSet rs1=null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		JSONObject obj = new JSONObject();
		JSONArray SplitBundleArray = new JSONArray();
		int counter = 1;
		try 
		{
			String salesPersSplit = "",remarksSplit="";
			java.sql.Timestamp eventDate = null;
			String Splitsql = "SELECT SALES_PERS,EVENT_DATE,REMARK FROM SPRS_ACT_TRAN WHERE DCR_ID = ?";
			System.out.println("inside transactionsql ::"+Splitsql);
			pstmt = conn.prepareStatement(Splitsql);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				salesPersSplit = checkNull(rs.getString("SALES_PERS"));
				eventDate = rs.getTimestamp("EVENT_DATE");
				remarksSplit = checkNull(rs.getString("REMARK"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String companyDB = strgMeetDCRWizard.getSfaParmValue(salesPersSplit,"API_DB_NAME_VAL",conn);
			String userNameDB = strgMeetDCRWizard.getSfaParmValue(salesPersSplit,"API_DB_USER_VAL",conn);
			String passwordDB = strgMeetDCRWizard.getSfaParmValue(salesPersSplit,"API_DB_PASS_VAL",conn);
			
			System.out.println("salespers ::["+salesPersSplit+"] eventdate ::["+eventDate+"] remarks ::["+remarksSplit+"]");
			String splitInvoiceSql =  "SELECT DISTINCT EMP.EMP_CODE,EMP.EMP_SITE,SMI.ITEM_CODE AS CHILD_ITEM,SMI.BREAK_ITEM__REF AS PARENT_ITEM,L.LOC_GROUP,L.LOC_PHY_AREA,"
					+ "FN_GET_STOCK_TRANFER_API_DATA('BREAK_ADD_QTY',SMI.ITEM_CODE,?,trunc(?)) AS BREAK_ADD_QTY,"
					+ "FN_GET_STOCK_TRANFER_API_DATA('BREAK_DEDUCT_QTY',SMI.BREAK_ITEM__REF,?,trunc(?)) AS BREAK_DEDUCT_QTY FROM STRG_MEET_INVOICE SMI,"
					+ "SPRS_ACT_TRAN SAT,EMPLOYEE EMP,LOCATION L WHERE SAT.DCR_ID IN('"+dcrIdInForm+"') AND SAT.DCR_ID=SMI.DCR_ID AND EMP.EMP_CODE=SAT.SALES_PERS AND EMP.EMP_CODE=L.LOC_CODE AND SMI.BREAK_ITEM__REF IS NOT NULL GROUP BY EMP.EMP_CODE,EMP.EMP_SITE,SMI.ITEM_CODE,SMI.BREAK_ITEM__REF,SAT.EVENT_DATE,SAT.SALES_PERS,L.LOC_GROUP,L.LOC_PHY_AREA";
			System.out.println("inside splitInvoiceSql ::"+splitInvoiceSql);
			pstmt1 = conn.prepareStatement(splitInvoiceSql);
			pstmt1.setString(1, salesPersSplit);
			pstmt1.setTimestamp(2, eventDate);
			pstmt1.setString(3,salesPersSplit);
			pstmt1.setTimestamp(4,eventDate);
			rs1 = pstmt1.executeQuery();
		
			while(rs1.next())
			{
				String empCode = checkNull(rs1.getString("EMP_CODE"));
				String empSite = checkNull(rs1.getString("EMP_SITE"));
				String itemCode = checkNull(rs1.getString("CHILD_ITEM"));
				String parentItem = checkNull(rs1.getString("PARENT_ITEM"));
				String locGroup = checkNull(rs1.getString("LOC_GROUP"));
				String BinAbsEntry = checkNull(rs1.getString("LOC_PHY_AREA"));
				int breakAddQty = rs1.getInt("BREAK_ADD_QTY");
				int breakDeductQty = rs1.getInt("BREAK_DEDUCT_QTY");
				JSONObject SplitBundleObj = new JSONObject();
				
				if(counter == 1)
				{
					/*obj.put("CompanyDB", "Z_LBCP_MOB_APP");
					obj.put("Password", "Sap@1234");
					obj.put("UserName", "manager");*/
					
					obj.put("CompanyDB", companyDB);
					obj.put("Password", passwordDB);
					obj.put("UserName", userNameDB);
					
					obj.put("BPL_IDAssignedToInvoice",empSite);
					obj.put("Comments", remarksSplit);
					obj.put("SalesPersonCode",empCode);
					obj.put("U_SOM", "M");
					obj.put("U_MLDN", loadNo);
				}
				SplitBundleObj.put("O_ItemCode", parentItem);
				SplitBundleObj.put("O_Quantity",breakDeductQty);
				SplitBundleObj.put("O_WarehouseCode",locGroup);
				SplitBundleObj.put("O_BinAbsEntry", BinAbsEntry);
				SplitBundleObj.put("C_ItemCode",itemCode);
				SplitBundleObj.put("C_Quantity",breakAddQty);
				SplitBundleObj.put("C_WarehouseCode",locGroup);
				SplitBundleObj.put("C_BinAbsEntry",BinAbsEntry);
				
				SplitBundleArray.put(SplitBundleObj);
				obj.put("ApplicationJson_SplitBundle_RequestList", SplitBundleArray);
				counter++;
			}
			if( rs1 !=null )
			{
				rs1.close();
				rs1 = null;
			}
			if( pstmt1 !=null )
			{
				pstmt1.close();
				pstmt1 = null;
			}
		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("splitinvoice json :: "+obj.toString());
		if(obj.toString().equalsIgnoreCase("{}"))
		{
			return null;
		}
		else
		{
			return obj;
		}
	}
	
	public ArrayList<String> getStockTransferTranIDFormat(String dcrID,Connection conn)
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		ArrayList<String> tranIDList =new ArrayList<String>();
	
		try
		{
			String eventDate="";
			String salesPers="";
			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE,SALES_PERS AS SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
				salesPers=checkNull(rs.getString("SALES_PERS"));
		
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		
			/*--Commented and Changes by Gulzar on 16DEC2023
			String maxDaySummDate="";
			String minDaySummDate="";
		
			String daySummMaxSQL="SELECT MAX(EVENT_DATE)AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
			pstmt =  conn.prepareStatement(daySummMaxSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			String daySummMinSQL="SELECT MIN(EVENT_DATE) AS MIN_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE >? ";
			pstmt =  conn.prepareStatement(daySummMinSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				minDaySummDate=checkNull(rs.getString("MIN_DAY_SUMM_DATE"));
		
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		
			String minCon="";
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0)
			{
		
				minCon=" AND ST.TRAN_DATE< ? ";
		
			}
			String getTranId = "SELECT ST.TRAN_ID AS TRAN_ID FROM  STOCK_TRANSFER ST,STOCK_TRANSFER_DET STD WHERE ST.TRAN_DATE >= ?" +minCon+"AND STD.LOC_CODE__FR =? AND ST.TRAN_ID=STD.TRAN_ID AND STD.LOC_CODE__TO NOT IN(SELECT LOC_CODE FROM LOCATION WHERE SITE_CODE= (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE=?) AND LOC_TYPE='DP') order by ST.TRAN_DATE";
			System.out.println("getTranId Sql["+getTranId+"minEveDate["+minDaySummDate+"]");
		
			pstmt = conn.prepareStatement(getTranId);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(maxDaySummDate));
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0)
			{
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(minDaySummDate));
				pstmt.setString( 3, salesPers);
				pstmt.setString( 4, salesPers);
			}
			else
			{
				pstmt.setString( 2, salesPers);
				pstmt.setString( 3, salesPers);
			}
			*/
			//End Changes by Gulzar on 16DEC2023
			String getTranId = "SELECT ST.TRAN_ID AS TRAN_ID FROM  STOCK_TRANSFER ST,STOCK_TRANSFER_DET STD "
					+ " WHERE TRUNC(ST.TRAN_DATE) = (SELECT TRUNC(EVENT_DATE) FROM SPRS_DAY_SUMM WHERE LOAD_NO =(SELECT LOAD_NO FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND DCR_ID =?) ) AND STD.LOC_CODE__FR =? AND ST.TRAN_ID=STD.TRAN_ID "
					+ " AND STD.LOC_CODE__TO NOT IN(SELECT LOC_CODE FROM LOCATION "
					+ " WHERE SITE_CODE= (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE=?) AND LOC_TYPE='DP') order by ST.TRAN_DATE ";
			pstmt = conn.prepareStatement(getTranId);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, dcrID);
			pstmt.setString(3, salesPers);
			pstmt.setString(4, salesPers);
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String tranID = checkNull(rs.getString("TRAN_ID"));
				if(tranID != null && tranID.trim().length()>0)
				{
					if(!tranIDList.contains(tranID))
					{
						tranIDList.add(tranID);
					}
		
				}
			}
		
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("tranIDList["+tranIDList+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1)
			{
				// TODO: handle exception
			}
	
		}
	
		return tranIDList;
	}

	public JSONObject getVanStockDetails(ArrayList<String> tranidList, String tranIdIn, Connection conn, String loadNo) throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		JSONObject obj = new JSONObject();
		JSONArray VanStockArray = new JSONArray();
		int counter = 1;
		try 
		{
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String companyDB = strgMeetDCRWizard.getSfaParmValue("","API_DB_NAME_VAL",conn);
			String userNameDB = strgMeetDCRWizard.getSfaParmValue("","API_DB_USER_VAL",conn);
			String passwordDB = strgMeetDCRWizard.getSfaParmValue("","API_DB_PASS_VAL",conn);
			
			System.out.println("tranidList["+tranidList+"]");
			String allTranId = "";
			for(int i = 0; i<tranidList.size(); i++)
			{
				String tranId = tranidList.get(i);
				if(allTranId!= null && allTranId.trim().length() > 0)
				{
					allTranId = allTranId + "," + tranId;
				}
				else
				{
					allTranId = tranId;
				}
			}
			System.out.println("alltranId["+allTranId+"]");

			int itemLine=0;
			String vanSql = "SELECT ST.TRAN_DATE,LOC_FROM.LOC_GROUP AS FROM_WARE_HOUSE,LOC_TO.LOC_GROUP AS TO_WARE_HOUSE,ST.TRAN_ID," + 
					"STD.ITEM_CODE,ITEM.DESCR AS ITEM_DESCR,STD.LOT_NO__FR AS BATCH,STD.QUANTITY,LOC_FROM.LOC_PHY_AREA AS FR_BIN," + 
					"2 AS FR_BIN_ACTION,LOC_TO.LOC_PHY_AREA AS TO_BIN,1 AS TO_BIN_ACTION FROM stock_transfer ST,STOCK_TRANSFER_DET STD," + 
					"LOCATION LOC_FROM,LOCATION LOC_TO,ITEM ITEM WHERE ST.TRAN_ID=STD.TRAN_ID AND ST.TRAN_ID IN("+tranIdIn+") AND ITEM.ITEM_CODE=STD.ITEM_CODE AND LOC_FROM.LOC_CODE=STD.LOC_CODE__FR AND LOC_TO.LOC_CODE=LOC_CODE__TO";
			System.out.println("inside vanstocksql ::"+vanSql);
			pstmt = conn.prepareStatement(vanSql);
			rs = pstmt.executeQuery();
			while(rs.next()) 
			{
				String tranDate= (rs.getDate("TRAN_DATE")).toString();
				String locGroupFrom = rs.getString("FROM_WARE_HOUSE");
				String locGroupTo = rs.getString("TO_WARE_HOUSE");
				//String tranID = rs.getString("TRAN_ID");
				String itemCode = rs.getString("ITEM_CODE");
				String itemDescr = rs.getString("ITEM_DESCR");
				String batch = rs.getString("BATCH");
				double quantity = rs.getDouble("QUANTITY");
				String binAbsEntryFrom = rs.getString("FR_BIN");
				int frBinAction = rs.getInt("FR_BIN_ACTION");
				String binAbsEntryTo = rs.getString("TO_BIN");
				int toBinAction = rs.getInt("TO_BIN_ACTION");
				
				JSONObject BinAllocationObj = new JSONObject();
				JSONObject BatchNumbersObj = new JSONObject();
				JSONObject VanStockObj = new JSONObject();
				
				JSONArray BinAllocationArray = new JSONArray();
				JSONArray BatchNumbersArray = new JSONArray();
				if(counter == 1)
				{
					/*obj.put("CompanyDB", "Z_LBCP_MOB_APP");
					obj.put("Password", "Sap@1234");
					obj.put("UserName", "manager");*/
					
					obj.put("CompanyDB", companyDB);
					obj.put("Password", passwordDB);
					obj.put("UserName", userNameDB);
					
					obj.put("DocDate",tranDate);
					obj.put("FromWarehouse", locGroupFrom);
					obj.put("ToWarehouse",locGroupTo);
					obj.put("U_SOM", "M");
					obj.put("U_MTID", allTranId);
					obj.put("U_MLDN", loadNo);
				}
				
				VanStockObj.put("LineNum", itemLine);
				VanStockObj.put("ItemCode", itemCode);
				VanStockObj.put("ItemDescription", itemDescr);
				VanStockObj.put("Quantity", quantity);
				
				BatchNumbersObj.put("BatchNumber", batch);
				BatchNumbersObj.put("Quantity", quantity);
				BatchNumbersObj.put("BaseLineNumber", itemLine);
				BatchNumbersObj.put("ItemCode",itemCode);
				
				BatchNumbersArray.put(BatchNumbersObj);
				VanStockObj.put("BatchNumbers",BatchNumbersArray);
				
				BinAllocationObj.put("BinAbsEntry",binAbsEntryFrom);
				BinAllocationObj.put("Quantity", quantity);
				BinAllocationObj.put("SerialAndBatchNumbersBaseLine", itemLine);
				BinAllocationObj.put("BinActionType", frBinAction);
				BinAllocationObj.put("BaseLineNumber",itemLine);
				
				BinAllocationArray.put(BinAllocationObj);
				
				BinAllocationObj = new JSONObject();
				
				BinAllocationObj.put("BinAbsEntry",binAbsEntryTo);
				BinAllocationObj.put("Quantity", quantity);
				BinAllocationObj.put("SerialAndBatchNumbersBaseLine", itemLine);
				BinAllocationObj.put("BinActionType", toBinAction);
				BinAllocationObj.put("BaseLineNumber",itemLine);
				
				BinAllocationArray.put(BinAllocationObj);
								
				VanStockObj.put("StockTransferLinesBinAllocations", BinAllocationArray);
				VanStockArray.put(VanStockObj);
				obj.put("StockTransferLines", VanStockArray);
				counter++;
				itemLine++;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("vanstock json :: "+obj.toString());
		return obj;
	}
	
	public String getVanWareHouseDetails(String refID,E12ExternalAPICall e12ExternalAPICall,String aproverEmpCode,String userId,UserInfoBean userInfo, String loadNo, String vehNo, Connection conn) throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		String returnValue="";
		try 
		{
			

			SalesSFAToSAPService sfs=new SalesSFAToSAPService();
			String locCode= sfs.getLocCode(refID, conn);
			JSONObject vanToWareHouseJson = new JSONObject();
			String empSite="";
			String siteSql="SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE=?";
			pstmt = conn.prepareStatement(siteSql);
			pstmt.setString(1, locCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empSite=checkNull(rs.getString("EMP_SITE"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}			
					
			String vehNoSql="SELECT VEH_NO FROM SPRS_DAY_SUMM WHERE LOAD_NO=?";
			pstmt = conn.prepareStatement(vehNoSql);
			pstmt.setString(1, loadNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				vehNo=checkNull(rs.getString("VEH_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}	
					
					
			StockTransactionCreation StockTransactionCreation=new StockTransactionCreation();
			vanToWareHouseJson=StockTransactionCreation.transactionCreation(locCode, aproverEmpCode,userId, empSite, refID, loadNo, vehNo, conn);
			if(vanToWareHouseJson != null)
			{
				String vanStockUrl = "https://lbcp.rpminfotech.com/api/VanToWarehouseTransfer";
				String apiCallResponseVanJsonStr="";
				apiCallResponseVanJsonStr = e12ExternalAPICall.apiCallToPostData("VanToWarehouseTransfer", vanStockUrl, "A", "E", refID, "F-DCR", "POST", vanToWareHouseJson, userInfo,"");
				
				if(apiCallResponseVanJsonStr.indexOf("[")==0 && apiCallResponseVanJsonStr.lastIndexOf("]")==apiCallResponseVanJsonStr.length()-1)
				{
					apiCallResponseVanJsonStr=apiCallResponseVanJsonStr.substring(1, apiCallResponseVanJsonStr.length()-1);
				}
				
				if(apiCallResponseVanJsonStr.indexOf("errorCode")!=-1)
				{
					JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
					
					String errorCode=obj.getString("errorCode");
					if("000".equalsIgnoreCase(errorCode))
					{
						returnValue="<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[ SUCCESS ]]></RESULT></ROOT>";

					}
					else
					{
						String errorMessage=obj.getString("errorMessage");
						returnValue=getErrorString(errorMessage);
					}


				}
				else if(apiCallResponseVanJsonStr.indexOf("error")!=-1)
				{
					JSONObject obj = new JSONObject(apiCallResponseVanJsonStr);
					JSONObject error = obj.getJSONObject("error");
					JSONObject message = error.getJSONObject("message");
					String value=message.getString("value");
					System.out.println("apiCallResponseJsonStr value in case of split invoice =["+value+"]");
					returnValue=getErrorString(value);

				}
				int vanSucessCnt=0;
				String sql3="SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS='S' AND API_NAME='VanToWarehouseTransfer' " ; 
				pstmt = conn.prepareStatement(sql3);
				pstmt.setString(1, refID);
				pstmt.setString(2, userInfo.getEnterprise());
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					vanSucessCnt=rs.getInt("COUNT");
				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}	
				if(vanSucessCnt>0)
				{
					AppConnectParm appConnect = new AppConnectParm();
					InitialContext initialContext = new InitialContext(appConnect.getProperty());
					
					java.util.Date date = Calendar.getInstance().getTime();
					DateFormat dtFormat = new SimpleDateFormat(e12GenericUtility.getApplDateFormat());
					String currentDate = dtFormat.format( date );

					String transactionID="";
					String sql1="SELECT REQUEST_DATA FROM API_CALL_LOG WHERE REF_ID=? AND REF_SER='F-DCR' AND ENTERPRISE=? AND CALL_STATUS='S' AND API_NAME='VanToWarehouseTransfer' " ;
					pstmt = conn.prepareStatement(sql1);
					pstmt.setString(1, refID);
					pstmt.setString(2, userInfo.getEnterprise());
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						String requestData=checkNull(rs.getString("REQUEST_DATA"));
						JSONObject object = new JSONObject(requestData);
						transactionID = checkNull(object.getString("U_MTID"));
					}
					if( rs !=null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt !=null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("transactionID::::::::::::::::::["+transactionID+"]");
					if(transactionID!=null && transactionID.trim().length()>0)
					{
						StringBuffer processDynXmlString=new StringBuffer();
						processDynXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
						processDynXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>");
						processDynXmlString.append("<objName><![CDATA[stock_transfer]]></objName>");
						processDynXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
						processDynXmlString.append("<objContext><![CDATA[1]]></objContext>");
						processDynXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
						processDynXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
						processDynXmlString.append("<action><![CDATA[SAVE]]></action>");
						processDynXmlString.append("<elementName><![CDATA[]]></elementName>");
						processDynXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
						processDynXmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
						processDynXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
						processDynXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
						processDynXmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
						
						String siteCode="";
						String stockTrasferSql="SELECT  * FROM STOCK_TRANSFER WHERE  TRAN_ID=? ";
						pstmt = conn.prepareStatement(stockTrasferSql);
						pstmt.setString(1, transactionID);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							String objContext="1";
							siteCode=checkNull(rs.getString("SITE_CODE"));
							System.out.println("for detail1");

							processDynXmlString.append("<Detail1 dbID='' domID='1'  objContext='"+objContext+"'  objName='stock_transfer'>");
							processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
							processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
							processDynXmlString.append("<tran_date><![CDATA[").append( currentDate ).append("]]></tran_date>");
							processDynXmlString.append("<site_code><![CDATA[").append( checkNull(rs.getString("SITE_CODE")) ).append("]]></site_code>");
							processDynXmlString.append("<ref_ser__for><![CDATA[").append("XFRX").append("]]></ref_ser__for>");
							processDynXmlString.append("<ref_id__for><![CDATA[").append( checkNull(rs.getString("REF_ID__FOR")) ).append("]]></ref_id__for>");
							processDynXmlString.append("<reas_code><![CDATA[").append( checkNull(rs.getString("REAS_CODE"))  ).append("]]></reas_code>");
							processDynXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("ITEM_SER"))).append("]]></item_ser>");
							processDynXmlString.append("<confirmed><![CDATA[").append( "N" ).append("]]></confirmed>");
							processDynXmlString.append("<conf_date><![CDATA[]]></conf_date>");
							processDynXmlString.append("<emp_code__aprv><![CDATA[").append(aproverEmpCode).append("]]></emp_code__aprv>");
							processDynXmlString.append("<chg_date><![CDATA[").append(currentDate).append("]]></chg_date>");
							processDynXmlString.append("<chg_term><![CDATA[").append("SYSTEM").append("]]></chg_term>");
							processDynXmlString.append("<chg_user><![CDATA[").append(userId).append("]]></chg_user>");
							processDynXmlString.append("<full_name><![CDATA[").append("").append("]]></full_name>");
							processDynXmlString.append("<tran_type><![CDATA[").append("I").append("]]></tran_type>");
							processDynXmlString.append("<truck_no><![CDATA[").append(checkNull(rs.getString("TRUCK_NO"))).append("]]></truck_no>");
							processDynXmlString.append("<ref_date><![CDATA[").append(currentDate).append("]]></ref_date>");
							processDynXmlString.append("</Detail1>");
						}
						if( rs !=null )
						{
							rs.close();
							rs = null;
						}
						if( pstmt !=null )
						{
							pstmt.close();
							pstmt = null;
						}
						String locationCodeFrom="",locationCodeFromDescr="";

						
						String locCodeToSql="SELECT LOC_CODE,DESCR FROM LOCATION WHERE SITE_CODE=? AND LOC_TYPE='DP'";
						pstmt =  conn.prepareStatement(locCodeToSql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							locationCodeFrom = checkNull(rs.getString("LOC_CODE"));
							locationCodeFromDescr = checkNull(rs.getString("DESCR"));

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						int lineNo=1;
						String stockTrasferDetSql="SELECT  * FROM STOCK_TRANSFER_DET WHERE  TRAN_ID=? ";
						pstmt = conn.prepareStatement(stockTrasferDetSql);
						pstmt.setString(1, transactionID);
						rs = pstmt.executeQuery();
						int noart=2;

						while(rs.next())
						{
							String objContext="2";
							System.out.println("for detail2");

							processDynXmlString.append("<Detail2 dbID='' domID='"+lineNo+"'  objContext='"+objContext+"'  objName='stock_transfer'>");
							processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
							processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
							processDynXmlString.append("<line_no><![CDATA[").append( lineNo ).append("]]></line_no>");
							processDynXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>");
							processDynXmlString.append("<quantity><![CDATA[").append(checkNull(rs.getString("QUANTITY"))).append("]]></quantity>");
							processDynXmlString.append("<loc_code__fr><![CDATA[").append(locationCodeFrom).append("]]></loc_code__fr>");
							processDynXmlString.append("<loc_code__to><![CDATA[").append( "DMYLOC" ).append("]]></loc_code__to>");
							processDynXmlString.append("<lot_no__fr><![CDATA[").append(checkNull(rs.getString("LOT_NO__FR"))).append("]]></lot_no__fr>");
							processDynXmlString.append("<lot_no__to><![CDATA[").append(checkNull(rs.getString("LOT_NO__TO"))).append("]]></lot_no__to>");
							processDynXmlString.append("<lot_sl__fr><![CDATA[").append(checkNull(rs.getString("LOT_SL__FR"))).append("]]></lot_sl__fr>");
							processDynXmlString.append("<lot_sl__to><![CDATA[").append(checkNull(rs.getString("LOT_SL__TO"))).append("]]></lot_sl__to>");
							processDynXmlString.append("<remarks><![CDATA[]]></remarks>");
							processDynXmlString.append("<acct_code__cr><![CDATA[").append(checkNull(rs.getString("ACCT_CODE__CR"))).append("]]></acct_code__cr>");
							processDynXmlString.append("<acct_code__dr><![CDATA[").append(checkNull(rs.getString("ACCT_CODE__DR"))).append("]]></acct_code__dr>");
							processDynXmlString.append("<cctr_code__dr><![CDATA[").append(checkNull(rs.getString("CCTR_CODE__DR"))).append("]]></cctr_code__dr>");
							processDynXmlString.append("<cctr_code__cr><![CDATA[").append(checkNull(rs.getString("CCTR_CODE__CR"))).append("]]></cctr_code__cr>");
							processDynXmlString.append("<location_descr__fr><![CDATA[").append(locationCodeFromDescr).append("]]></location_descr__fr>");
							processDynXmlString.append("<no_art><![CDATA[").append(noart).append("]]></no_art>");			
							processDynXmlString.append("</Detail2>");								
							lineNo++;
						}
						if( rs !=null )
						{
							rs.close();
							rs = null;
						}
						if( pstmt !=null )
						{
							pstmt.close();
							pstmt = null;
						}
						
						processDynXmlString.append("</Header0></group0></DocumentRoot>");
						String XmlString = processDynXmlString.toString();
						System.out.println("returnString:::::FOR XmlString 222 ::"+XmlString);

						MasterStatefulLocal masterStateful = (MasterStatefulLocal)initialContext.lookup("ibase/MasterStatefulEJB/local");
						String reString = masterStateful.processRequest( getUserInfo(), XmlString, false, conn);
						System.out.println("returnString:::::FOR DUMY 222 ::"+reString);
					}
				}
				JSONObject apiCallResponseVanJSON = new JSONObject(apiCallResponseVanJsonStr);
			}
		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		
		return returnValue;
	}
	public String getEmpCode(String userId,Connection connectionObject)throws ITMException
	{
		String empCode="";
		String entityCode="";
		boolean isLocalConn =false;
		PreparedStatement pstmtSelect = null;
		ResultSet resultSelect = null ;
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String selectMsgDescrSql = "SELECT EMP_CODE,ENTITY_CODE FROM USERS WHERE CODE= ? ";
			pstmtSelect = connectionObject.prepareStatement(selectMsgDescrSql);
			pstmtSelect.setString(1, userId);
			resultSelect = pstmtSelect.executeQuery();
			if(resultSelect.next())
			{
				empCode = checkNull(resultSelect.getString("EMP_CODE"));
				entityCode = checkNull(resultSelect.getString("ENTITY_CODE"));
			}
			if(resultSelect != null)
				{
					resultSelect.close();
					resultSelect = null;
				}
				if(pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
			if(empCode == null || empCode.trim().length() == 0)
			{
				empCode = entityCode;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSelect != null)
				{
					resultSelect.close();
					resultSelect = null;
				}
				if(pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
				if(isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return empCode;
	}
	private String getLoadNo(String dcrID, Connection conn)
	{
		String loadNo = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String eventDate = "";
		String salesPers = "";
		
		try
		{
			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE,SALES_PERS AS SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
				salesPers=checkNull(rs.getString("SALES_PERS"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			String loadNoSql="SELECT MAX(TO_NUMBER(CASE WHEN LOAD_NO IS NULL THEN '0' ELSE LOAD_NO END)) as LOAD_NO "
					+ "FROM SPRS_DAY_SUMM WHERE SALES_PERS =? AND EVENT_DATE = (SELECT MAX(EVENT_DATE) FROM SPRS_DAY_SUMM WHERE SALES_PERS= ?)";
			pstmt =  conn.prepareStatement(loadNoSql);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				loadNo = checkNull(rs.getString("LOAD_NO"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1) 
			{
				// TODO: handle exception
			}
			
		}
		return loadNo;	
	}
	
}