/*
 *	Author: Satya
 *	Date: 09/08/10
 *	Reason : Unconfirm a confirmed Report
 *	request: WS90N0V048
 */
package ibase.webitm.ejb.wsfa.transactions;

import java.lang.*;
import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.utility.*;
import ibase.system.config.*;
import ibase.utility.BaseLogger;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;



@javax.ejb.Stateless
public class UnconfirmDARIC extends ValidatorEJB implements UnconfirmDARICLocal,UnconfirmDARICREmote 
{
	E12GenericUtility genericUtility = new E12GenericUtility();//Added by vinayak on [12/07/2016] to create genericUtility instance
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];
		try
		{			
			System.out.println("xmlString ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2 ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, xtraParams);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: UnconfirmDARIC: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from UnconfirmDARIC wfValData" );
		return (errString); 
	}


	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("*****************Inside wfValData of UnconfirmDARIC*****************");

		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String columnValue = "";
		String sql = "";	
		String errString = "";
		PreparedStatement pstmtCnt = null;
		ResultSet rsCnt = null;
		try
		{	
			int currentFormNo = 0;			
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			// commentted and added by rupali on 20/06/19 for applying validation if unlisted customer workflow is pending [start]
			/*NodeList parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = parentList.item( 0 ).getChildNodes();			
			int noOfChilds = childList.getLength();
			System.out.println("noOfChilds::"+noOfChilds);
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{	
				Node childNode = childList.item( ctr );
				String childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}*/
			//NodeList parentList = null;
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = null;
			int noOfChilds = 0;
			int ctr = 0;

			NodeList parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("value ofs parentNodeListLength:sss::"+parentNodeListLength);
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				System.out.println("noOfChilds:>>>sss>:::["+noOfChilds+"]");
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					// commentted and added by rupali on 20/06/19 for applying validation if unlisted customer workflow is pending [end]
					switch ( currentFormNo )
					{
					case 1:
					{
						if ( "emp_code".equalsIgnoreCase(childNodeName) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = getErrorString("emp_code","NULLEMPCOD",userId,errString);
								break;
							}
							else
							{
								String empCode = childNode.getFirstChild().getNodeValue();
								if (empCode == null || empCode.trim().length() == 0)
								{
									errString = getErrorString("emp_code","NULLEMPCOD",userId,errString);
									break;
								}
								sql = "SELECT COUNT(*) AS EMPCNT FROM EMPLOYEE WHERE EMPLOYEE.EMP_CODE = ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();
								int empCnt = 0;
								if (rs.next())
								{
									empCnt = rs.getInt("EMPCNT");
								}
								if (empCnt == 0)
								{
									errString = getErrorString("emp_code","INVEMPCODE",userId,errString);
									break;
								}
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}					
						}
						else if ( "from_date".equalsIgnoreCase(childNodeName) )
						{
							if (childNode.getFirstChild()!= null)
							{
								String frDateStr = childNode.getFirstChild().getNodeValue();
								if (frDateStr == null || frDateStr.trim().length() == 0)
								{
									errString = getErrorString("to_date","NULFROMDT",userId,errString);
									break;
								}
							}
							else
							{
								errString = getErrorString("to_date","NULFROMDT",userId,errString);
								break;
							}

						}
						else if ( "to_date".equalsIgnoreCase(childNodeName) )
						{
							if ( childNode.getFirstChild() == null )
							{
								System.out.println("emp_code cannot be null:");
								errString = getErrorString("to_date","NULLTODATE",userId,errString);
								break;
							}
							else
							{
								String toDateStr = childNode.getFirstChild().getNodeValue();
								if (toDateStr == null || toDateStr.trim().length() ==0)
								{
									errString = getErrorString("to_date","NULLTODATE",userId,errString);
									break;
								}
								else
								{

									java.util.Date toDate = genericUtility.getDateObject(toDateStr);
									java.util.Date frDate = genericUtility.getDateObject(genericUtility.getColumnValue( "from_date" , dom ));
									if (frDate == null)
									{
										errString = getErrorString("to_date","NULFROMDT",userId,errString);
										break;
									}
									else if (toDate != null && toDate.compareTo(frDate)<0)
									{
										errString = getErrorString("to_date","INVTODATE",userId,errString);
										break;
									}
								}
							}
						}		
					}//case
					// added by rupali on 20/06/19 for applying validation if unlisted customer workflow is pending [start]
					case 2:
					{
						if ( "work_date".equalsIgnoreCase(childNodeName) )
						{
							String workDate = childNode.getFirstChild().getNodeValue();
							String empCode = checkNull( genericUtility.getColumnValueFromNode( "sales_pers" ,parentNode ) );
							String sampleAllow = getSfaParmValue(empCode,"SAMPLE_ALLOW",connectionObject);

							if(sampleAllow.equalsIgnoreCase("E") || sampleAllow.equalsIgnoreCase("C"))
							{
								sql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND  EVENT_DATE = ? AND WF_STATUS NOT IN ('A','R') AND CONFIRMED = 'Y'";
								pstmtCnt = connectionObject.prepareStatement(sql);
								
								//sql = "SELECT SALES_PERS,EVENT_DATE FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE >= ? ORDER BY EVENT_DATE";
								sql = "SELECT SALES_PERS,EVENT_DATE FROM SPRS_ACT_TRAN WHERE CONFIRMED = 'Y' AND SALES_PERS = ? AND EVENT_DATE = ? ORDER BY EVENT_DATE";

								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, empCode);
								pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
								rs = pstmt.executeQuery();
								while(rs.next())
								{
									String eventDate = rs.getString("EVENT_DATE");
									pstmtCnt.setString(1,empCode);
									pstmtCnt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
									rsCnt = pstmtCnt.executeQuery();
									int unlistCnt = 0;
									if (rsCnt.next())
									{
										unlistCnt = rsCnt.getInt("COUNT");
									}
									
									if (unlistCnt > 0)
									{
										eventDate = genericUtility.getValidDateString(eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
										errString = getErrorString("work_date","INVDATESEL",userId,errString);
										errString = getModifiedErrorString(errString, eventDate);
										break;
									}
									pstmtCnt.clearParameters();
									if(rsCnt != null)
									{
										rsCnt.close();
										rsCnt = null;
									}
									
								}
								//added by Prachi start
								if(pstmtCnt != null)
								{
									pstmtCnt.close();
									pstmtCnt = null;
								}
								//end
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
							else
							{
								sql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND  EVENT_DATE = ? AND WF_STATUS NOT IN ('A','R') AND CONFIRMED = 'Y'";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1,empCode);
								pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
								rs = pstmt.executeQuery();
								int unlistCnt = 0;
								if (rs.next())
								{
									unlistCnt = rs.getInt("COUNT");
								}
								if (unlistCnt > 0)
								{
									errString = getErrorString("work_date","INVDATESEL",userId,errString);
									errString = getModifiedErrorString(errString, workDate);
									break;
								}
								if (rs!=null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
							//Added by Sachin Satre on [27-jan-21] for the check uncofirm date expense is in draft mode then it should not be uncofirmed [Start]
							//Changes reverted as per client request [09-Mar-21] Start
							/*PreparedStatement pstmtExp = null;
							ResultSet rsetExp = null;
							int tourIdCnt = 0 ;
							String expDrftSql = "SELECT  COUNT(TD.DATE_FROM) AS COUNT "
									+ " FROM TOUR T ,TOURDET TD "
									+ " WHERE T.EMP_CODE = ? "
									+ " AND T.DATE_FROM <= ? "
									+ " AND T.date_to >= ? "
									+ " AND T.TOUR_ID = TD.TOUR_ID  "
									+ " AND TD.date_from = ? ";

							pstmtExp = connectionObject.prepareStatement( expDrftSql );
							pstmtExp.setString(1,empCode);
							pstmtExp.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )) );
							pstmtExp.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )) );
							pstmtExp.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )) );
							rsetExp = pstmtExp.executeQuery();
							if ( rsetExp.next() )
							{
								tourIdCnt = rsetExp.getInt("COUNT");
							}
							if ( rsetExp !=null )
							{
								rsetExp.close();
								rsetExp = null;
							}
							if( pstmtExp != null)
							{
								pstmtExp.close();
								pstmtExp = null;
							}
							System.out.println("tourIdCnt:Exp draft mdoe::["+tourIdCnt+"]");
							if (tourIdCnt > 0)
							{
								errString = getErrorString("work_date","EXPDARUNCO",userId,errString);
								errString = getModifiedErrorString(errString, workDate);
								break;
							}*/
							//Changes reverted as per client request [09-Mar-21] End
							//Added by Sachin Satre on [27-jan-21] for the check uncofirm date expense is in draft mode then it should not be uncofirmed [End]
						}
					}//case2
					// added by rupali on 20/06/19 for applying validation if unlisted customer workflow is pending [end]
					}// Switch ends
					if (errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}// For Loop ends
			}
		}  
		catch (Exception e)
		{
			System.out.println ( "Exception: SprsPlanEJB: wfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null  )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :SprsPlanEJB:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);
	}



	/*********************item change*********************/
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( dom, dom1, dom2, objContext, currentColumn, xtraParams ):");
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :UnconfirmDARIC :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from UnconfirmDARIC itemChanged \n["+errString+"]" );

		return errString;
	}
	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String xtraParams ) throws RemoteException,ITMException
	{
		int currentFormNo = 0;
		String userId = "" ;
		String sql = "" ;
		String retString ="";
		String columnValue = "";
		Connection conn = null;
		PreparedStatement pstmt = null;

		ResultSet rs = null ;



		StringBuffer valueXmlString = new StringBuffer();
		//GenericUtility genericUtility = GenericUtility.getInstance();//Commented by Vinayak on [13/07/2016]];
		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverValidator" );*/
			//Commented by vinayak on [11/07/2016] [end]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			columnValue = genericUtility.getColumnValue( currentColumn, dom );
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>A</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )
			{
			case 1:
			{   

				valueXmlString.append( "<Detail1 domID='1' >\r\n" );
				if (currentColumn.trim().equalsIgnoreCase( "emp_code" ))
				{
					String empCode = genericUtility.getColumnValue(currentColumn, dom);
					if (empCode != null && empCode.trim().length()>0)
					{
						sql = "SELECT (EMPLOYEE.EMP_FNAME || ' '||EMPLOYEE.EMP_MNAME ||' '|| EMPLOYEE.EMP_LNAME) AS EMP_NAME FROM EMPLOYEE WHERE EMPLOYEE.EMP_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,empCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							valueXmlString.append( "<emp_name><![CDATA[" ).append( checkNull(rs.getString("EMP_NAME") )).append( "]]></emp_name>\r\n" );
						}
						else
						{
							valueXmlString.append( "<emp_name><![CDATA[" ).append( "" ).append( "]]></emp_name>\r\n" );
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
						valueXmlString.append( "<emp_code><![CDATA[" ).append( empCode ).append( "]]></emp_code>\r\n" );
					}
					else
					{
						valueXmlString.append( "<emp_name><![CDATA[" ).append( "" ).append( "]]></emp_name>\r\n" );
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase( "from_date" ))
				{
					String fromDateStr = genericUtility.getColumnValue(currentColumn, dom);
					String toDateStr = genericUtility.getColumnValue("to_date", dom);
					if (fromDateStr != null && fromDateStr.trim().length()>0 && (toDateStr == null || toDateStr.trim().length() == 0) )
					{
						valueXmlString.append( "<to_date ><![CDATA[" ).append( fromDateStr ).append( "]]></to_date>\r\n" );
						System.out.println("from_date"+fromDateStr);
					}

				}
				else if (currentColumn.trim().equalsIgnoreCase("itm_default"))//Added BY Nilesh as per set bydefault set current Date Start ::24-04-19
				{
					DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
					java.util.Date date = Calendar.getInstance().getTime();
					String currDate = dtFormat.format( date );
					valueXmlString.append( "<from_date ><![CDATA[" ).append( currDate ).append( "]]></from_date>\r\n" );
					valueXmlString.append( "<to_date ><![CDATA[" ).append( currDate ).append( "]]></to_date>\r\n" );
				}//Added BY Nilesh as per set bydefault set current Date End ::24-04-19
				valueXmlString.append( "</Detail1>\r\n" );
			}
			}
			valueXmlString.append( "</Root>" );
			retString = valueXmlString.toString();
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		//Modified by Ganesh [09/07/2013][To close connection object][Start]
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null  )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :UnconfirmDARIC:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		//Modified by Ganesh [09/07/2013][To close connection object][End]
		System.out.println("====>from itemchage()\n---------------\n"+retString);
		return retString;

	}
	private String checkNull(String input)	
	{
		if (input == null)
		{
			input="";
		}
		return input;
	}
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		//String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				//xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}
	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(sysDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				pstmt1 = connectionObject.prepareStatement(sql);
				//pstmt1.setString(1, itemSer);
				pstmt1.setString(1, "X"+"_"+itemSer);// Changed by Sachin Satre on [23-Jan-19]
				pstmt1.setString(2, paramName);
				pstmt1.setTimestamp(3,java.sql.Timestamp.valueOf(sysDate));

				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allPstmt.setTimestamp(3,java.sql.Timestamp.valueOf(sysDate));
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull(allRs.getString(1));
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
}