package ibase.webitm.ejb.wsfa.transactions;

import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.XML2DBEJB;
import ibase.webitm.ejb.XML2DBLocal;
import ibase.webitm.utility.GenerateXmlFromDB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.Map.Entry;

import javax.naming.InitialContext;

import org.apache.xerces.dom.AttributeMap;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericWorkflowClass
{
    public String invokeWorkflow(Connection conn, String tranId, String xtraParams, String objName, String xmlString, String salesPers ) throws ITMException
    {
        E12GenericUtility genericUtility = new E12GenericUtility();
        Document xmlDom = null;
        NodeList nodeList = null;
        Node node = null;
        Element nodeElement = null;
        String sql = "";
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String retString = "";
        String wrkflwInit = "";
        String refSer = "";
        String nodeName = "";
        InitialContext ctx = null;
        String errString = "";
		try
		{
			sql = "SELECT WRKFLW_INIT,REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_" + objName + "'";
			pStmt = conn.prepareStatement(sql);
			rs = pStmt.executeQuery();
			if (rs.next())
			{
				wrkflwInit = rs.getString("WRKFLW_INIT") == null ? "" : rs.getString("WRKFLW_INIT");
				refSer = rs.getString("REF_SER") == null ? "" : rs.getString("REF_SER");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			
			xmlDom = genericUtility.parseString(xmlString);
			
			String entityCodeInit = "";
			if(salesPers == null || salesPers.trim().length() == 0)
			{
				if(xtraParams != null && xtraParams.trim().length() > 0)
				{
					entityCodeInit = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
				}
			}
			else
			{
				entityCodeInit = salesPers;
			}
            ctx = this.getInitialContext();
          //Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
          //XML2DBLocal xml2DBLocal = (XML2DBLocal)ctx.lookup("ibase/XML2DBEJB/local");
          XML2DBEJB xml2DBLocal = new XML2DBEJB();
          //Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
            errString = xml2DBLocal.invokeWorkflowExternal((Node)xmlDom, entityCodeInit, wrkflwInit, objName, refSer, tranId, conn);
            System.out.println("retString From xml2dbObj.invokeWorkflowExternal --->" + errString);
            if (errString == null || (errString.trim().length() > 0 && errString.indexOf("<Errors>") == -1))
            {
            	errString = "success";
            }
            else
            {
            	errString = "error";
            }
        }
        catch (Exception ex)
        {
            errString = genericUtility.createErrorString(ex);
            ex.printStackTrace();
            throw new ITMException(ex);
        }
        finally
        {
            try
            {
                if (rs != null)
                {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null)
                {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (SQLException sqlEx)
            {
                System.out.println("Exception in Finally " + sqlEx.getMessage());
                sqlEx.printStackTrace();
            }
        }
        return errString;
    }
    private InitialContext getInitialContext() throws ITMException
    {
        InitialContext ctx = null;
        try
        {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme)
        {
            System.out.println("ITMException :[EmpITDeclNewServlet] :getInitialContext :==>");
            throw itme;
        }
        catch (Exception e)
        {
            System.out.println("Exception :[EmpITDeclNewServlet] :getInitialContext :==>");
            throw new ITMException(e);
        }
        return ctx;
    }
}