/**
* PURPOSE : Validation and Entry for WsfaStanTypeEJB master table
* AUTHOR : Changed By Sumit On 03/11/2011 [WS1GNOV001]
*/

package ibase.webitm.ejb.wsfa.masters;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless				commented by Sagar M [22 Nov 2018].
public class WsfaStanTypeEJB extends ValidatorEJB implements WsfaStanTypeEJBRemote, WsfaStanTypeEJBLocal
{
	/**
	* The method defined with no parameter and returns nothing
	*/
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for validation of required fields which return called overloaded method
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currXmlDataStr contains the current form data in XML format
	 * @param hdrXmlDataStr contains always header form data in XML format
	 * @param allXmlDataStr contains all forms data in XML format
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/

	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			if(currXmlDataStr != null && currXmlDataStr.trim().length()!= 0)
			{
				System.out.println ( "currXmlDataStr: " + currXmlDataStr);
				currDom = genericUtility.parseString(currXmlDataStr);
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!= 0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr);
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()!= 0)
			{
				allDom = genericUtility.parseString(allXmlDataStr);
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: WsfaStanTypeEJB" + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: WsfaStanTypeEJB: wfValData(String currXmlDataStr): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from WsfaStanTypeEJB wfValData" );
		return ( errString );
	}

	/**
	 * The public overloaded method is used for validation of required fields
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data
	 * @param hdrDom contains always header form data
	 * @param allDom contains all forms data
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
    {
		String errString = "", userId = "";
		String sql = "";
		String stanType = "";

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
      	NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int count = 0;
        int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;

		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverValidator");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = currDom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				System.out.println("*************");
				switch(currentFormNo)
				{
					case 1:
						if(childNodeName.equalsIgnoreCase("stan_type"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("stan_type","NULLSTANTY",userId);
								break;
							}
							else
							{
								stanType = checkNull( genericUtility.getColumnValue("stan_type",currDom) );
								System.out.println("******* stan type "+stanType);
								System.out.println("**** edit flag "+editFlag);
								if( stanType == null || stanType.trim().length() == 0 )
								{
									 errString = getErrorString("stan_type","NULLSTANTY",userId);
									 break;
								}
								else
								{
									if("A".equalsIgnoreCase(editFlag))
									{

										System.out.println("invalide data validation ");
										sql = "SELECT COUNT(*) AS COUNT FROM STANTYPE WHERE STAN_TYPE = ?";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, stanType );
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										if( count > 0 )
										{
											errString = getErrorString("stan_type","INVSTANTYP",userId);
											break;
										}
										if(rs != null )
										{
											rs.close();
											rs = null;
										}
										if(pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
									}
								}

							}

						}

					break;
				}//switch end
			}// for end
		}// end try
		catch(Exception e)
		{
			System.out.println("Exception: WsfaStanTypeEJB: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}// End Finally
		return (errString);
    }// end Method
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
}// end class
