package ibase.webitm.ejb.wsfa.masters;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.w3c.dom.Document;

public class WsfaDndDealPos extends ValidatorEJB 
{
	protected static String database = CommonConstants.DB_NAME;
 	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
 	public String postSave(String xmlStringAll, String tranId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
 		PreparedStatement pStmt = null;
		try
		{
			if (conn == null)
			{
				conn = getConnection();
			}
			E12GenericUtility genericUtility = new E12GenericUtility();
			Document dom = genericUtility.parseString(xmlStringAll);
			
			String empCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
            boolean isEmpCodeHO = false ;
			isEmpCodeHO = checkHOEmployee(empCode ,conn ) ;
			
			String wfStatus = genericUtility.getColumnValue("wf_status", dom);
			if( isEmpCodeHO == true)
			{
				if( wfStatus != null && "S".equalsIgnoreCase(wfStatus))
				{
					DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
					java.util.Date date = Calendar.getInstance().getTime();
					String currDate = dtFormat.format( date );
					currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					
					String updStrgCustSql = "UPDATE DND_DEAL SET APRV_STAT = 'A', EMP_CODE__APRV = ?, STATUS_DATE = ? WHERE TRAN_ID = ? ";
					pStmt = conn.prepareStatement(updStrgCustSql);
					pStmt.setString(1, empCode);
					pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(currDate));
					pStmt.setString(3, tranId);
					int updCnt = pStmt.executeUpdate();
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					System.out.println("updCnt>>["+updCnt+"]");
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}


		}
		return "";
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
 	private boolean checkHOEmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		boolean isHo = false ;
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
			"WHERE A.EMP_CODE = ? " + 
			"AND A.PROFILE_ID = B.PROFILE_ID " +
			"AND B.APPLICATION = 'MRO' " +
			"AND B.MENU_ROW = 1 " +       
			"AND B.MENU_COL = 1 " +       
			"AND B.MENU_SUBCOL = 1 " +
			"AND B.LEVEL_4 = 1 " +        
			"AND B.LEVEL_5 = 1 " +        
			"AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode.trim() );
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));	
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if( empCodeHO != null && empCodeHO.trim().length() > 0 )
			{
				isHo = true ;
			}	
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return isHo;
	}
}