/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration.scheduledSFTP;

import ibase.bankIntegration.CommonMethods;
import ibase.bankIntegration.PaymentCancellation;
import ibase.bankIntegration.UpdatePaymentStatus;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import javax.json.JsonObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledSFTPDownloader
implements Schedule {
    E12GenericUtility e12GenericUtility = new E12GenericUtility();
    DBAccessEJB dbAccessEJB = new DBAccessEJB();
    boolean bankCodeBool = false;
    static boolean isUTRPresent = false;
    String bankCode = "";
    UserInfoBean userInfoGlobal = new UserInfoBean();
    NodeList argNodeList = null;

    public String schedule(HashMap arg0) throws Exception {
        return null;
    }

    public String schedule(String name) throws Exception {
        UserInfoBean userInfo;
        BaseLogger.log((String)"2", null, null, (Object)"ScheduledSFTPDownloader gsb gsb calling------------------");
        BaseLogger.log((String)"3", null, null, (Object)("name::[ " + name + " ]"));
        Document schdulerInfoDocument = this.e12GenericUtility.parseString(name);
        this.userInfoGlobal = userInfo = new UserInfoBean(this.e12GenericUtility.serializeDom(schdulerInfoDocument.getElementsByTagName("USERINFOXML").item(0).getChildNodes().item(0)));
        this.argNodeList = schdulerInfoDocument.getElementsByTagName("ACTUALPARAMETER");
        int i = 0;
        while (i < this.argNodeList.getLength()) {
            Node childNode = this.argNodeList.item(i);
            if (childNode.getNodeType() == 1 && childNode != null) {
                System.out.println("childNode gsb=[" + childNode + "]");
                this.bankCodeBool = this.isParameterPresent(childNode, "BANK_CODE");
                if (this.bankCodeBool && childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("BANK_CODE")) {
                    this.bankCode = E12GenericUtility.checkNull((String)childNode.getFirstChild().getNodeValue());
                    System.out.println("BankCode = [" + this.bankCode + "]");
                }
            }
            ++i;
        }
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + this.bankCode + "'", userInfo.getTransDB());
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]"));
        JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
        String localFolderPath = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
        localFolderPath = String.valueOf(localFolderPath) + File.separator + "From HSBC";
        BaseLogger.log((String)"3", null, null, (Object)("Inside downloadFile localFolderPathsss [" + localFolderPath + "]"));
        String acknowledgmentFolderPath = String.valueOf(localFolderPath) + File.separator + "Acknowledgement Files";
        this.processAcknowledgementFiles(acknowledgmentFolderPath);
        return null;
    }

    public String schedulePriority(String arg0) throws Exception {
        return null;
    }

    private boolean isParameterPresent(Node childNode, String attribName) throws ITMException {
        boolean attribFound = false;
        try {
            System.out.println("attribFound test= [" + childNode.getAttributes() + "]");
            if (childNode != null && childNode.getAttributes() != null) {
                System.out.println("attribFound name= [" + childNode.getAttributes().getNamedItem("name").getNodeValue() + "]");
                if (childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(attribName)) {
                    attribFound = true;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        System.out.println("attribFound = [" + attribFound + "]");
        return attribFound;
    }

    public static void moveFiles(String filePath) {
        System.out.println("Inside moveFile method: [" + filePath + "]");
        File directory = new File(filePath);
        if (!directory.isDirectory()) {
            System.out.println("Invalid directory path.");
            return;
        }
        File utrDirectory = new File(directory, "UTR");
        ScheduledSFTPDownloader.createDirectoryIfNotExists(utrDirectory);
        File ackDirectory = new File(directory, "Acknowledgement Files");
        ScheduledSFTPDownloader.createDirectoryIfNotExists(ackDirectory);
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    if (file.getName().toLowerCase().endsWith(".csv")) {
                        isUTRPresent = true;
                        ScheduledSFTPDownloader.moveFile(file, utrDirectory);
                    } else {
                        ScheduledSFTPDownloader.moveFile(file, ackDirectory);
                    }
                }
                ++n2;
            }
        }
    }

    private static void moveFile(File sourceFile, File destinationDirectory) {
        try {
            Path destinationPath = new File(destinationDirectory, sourceFile.getName()).toPath();
            Files.move(sourceFile.toPath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Moved " + sourceFile.getName() + " to " + destinationPath);
        }
        catch (FileAlreadyExistsException e) {
            System.out.println("File already exists in the destination directory: " + sourceFile.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createDirectoryIfNotExists(File directory) {
        if (!directory.exists()) {
            try {
                Files.createDirectory(directory.toPath(), new FileAttribute[0]);
                System.out.println(String.valueOf(directory.getName()) + " directory created.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void processAcknowledgementFiles(String ackDirectoryPath) throws Exception {
        System.out.println("Inside processAcknowledgementFiles [" + ackDirectoryPath + "]");
        File ackDirectory = new File(ackDirectoryPath);
        if (!ackDirectory.isDirectory()) {
            System.out.println("Invalid Acknowledgement Files directory path.");
            return;
        }
        File archiveDirectory = new File(ackDirectory, "Archive");
        ScheduledSFTPDownloader.createDirectoryIfNotExists(archiveDirectory);
        File[] files = ackDirectory.listFiles();
        if (files != null) {
            System.out.println("Inside files gsb [" + files.toString() + "]");
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                System.out.println("Inside for loop gsb [" + file.getAbsolutePath() + "]");
                if (file.isFile()) {
                    System.out.println("Inside file.isFile() gsb [" + file.getAbsolutePath() + "]");
                    this.processAcknowledgementFile(file, archiveDirectory);
                }
                ++n2;
            }
        }
    }

    private void processAcknowledgementFile(File file, File archiveDirectory) throws Exception {
        System.out.println("Inside processAcknowledgementFile file[" + file.getAbsolutePath() + "]");
        String fileName = file.getName();
        String ackType = ScheduledSFTPDownloader.getAckType(fileName);
        String paymentId = ScheduledSFTPDownloader.getPaymentId(fileName);
        if ("ACK1".equals(ackType)) {
            String idFrom1stAcknowledgement = ScheduledSFTPDownloader.getAcknowledgmentTagValue(file.getAbsolutePath(), "OrgnlMsgId", "");
            BaseLogger.log((String)"3", null, null, (Object)("idFrom1stAcknowledgement[" + idFrom1stAcknowledgement + "]"));
            String grpStsFrom1stAcknowledgement = ScheduledSFTPDownloader.getAcknowledgmentTagValue(file.getAbsolutePath(), "GrpSts", "");
            BaseLogger.log((String)"3", null, null, (Object)("grpStsFrom1stAcknowledgement[" + grpStsFrom1stAcknowledgement + "]"));
            String addlInfFrom1stAcknowledgement = "";
            String transResult = "";
            if (grpStsFrom1stAcknowledgement.equalsIgnoreCase("RJCT")) {
                try {
                    BaseLogger.log((String)"3", null, null, (Object)("Inside reject [" + grpStsFrom1stAcknowledgement + "]"));
                    addlInfFrom1stAcknowledgement = ScheduledSFTPDownloader.getAcknowledgmentTagValue(file.getAbsolutePath(), "AddtlInf", "");
                    BaseLogger.log((String)"3", null, null, (Object)("addlInfFrom1stAcknowledgement[" + addlInfFrom1stAcknowledgement + "]"));
                    PaymentCancellation paymentCancellation = new PaymentCancellation();
                    String transXMLHeader = paymentCancellation.generateTransXMLForHeader(idFrom1stAcknowledgement, this.userInfoGlobal);
                    String transXMLDetail = paymentCancellation.generateTransXMLForDetail(idFrom1stAcknowledgement, this.userInfoGlobal);
                    transResult = paymentCancellation.paymentCancellation(transXMLHeader, transXMLDetail, this.userInfoGlobal);
                    String bankEmailID = CommonMethods.getEventNotifyEmailFromBankMaster(idFrom1stAcknowledgement, this.userInfoGlobal);
                    System.out.println("bankEmailID gsb[" + bankEmailID + "]");
                    HashMap<String, Object> mailFormatDetails = new HashMap<String, Object>();
                    mailFormatDetails.put("SEND_TO", bankEmailID);
                    mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
                    mailFormatDetails.put("SUBJECT", "Payment Cancellation for Payment ID:" + idFrom1stAcknowledgement);
                    mailFormatDetails.put("BODY", "This mail is to inform that payment has been cancelled for Payment ID: " + idFrom1stAcknowledgement + "\nReason: " + addlInfFrom1stAcknowledgement);
                    EMail email = new EMail();
                    email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
                    System.out.println("getMailFrom1....::" + email.getMailFrom());
                    String mailXMLStr = this.buildMailXMLStr(mailFormatDetails, this.userInfoGlobal);
                    String emailStatus = email.sendMail(mailXMLStr, "ITM", this.userInfoGlobal);
                    System.out.println("emailStatus....::" + emailStatus);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            this.updatePaymentStatus1stAck(idFrom1stAcknowledgement, grpStsFrom1stAcknowledgement, addlInfFrom1stAcknowledgement, transResult);
        } else if ("ACK2".equals(ackType)) {
            String idFrom2ndAcknowledgement = ScheduledSFTPDownloader.getAcknowledgmentTagValue(file.getAbsolutePath(), "OrgnlMsgId", "");
            BaseLogger.log((String)"3", null, null, (Object)("idFrom2ndAcknowledgement[" + idFrom2ndAcknowledgement + "]"));
            String txstsFrom2ndAcknowledgement = ScheduledSFTPDownloader.getAcknowledgmentTagValue(file.getAbsolutePath(), "TxSts", "");
            BaseLogger.log((String)"3", null, null, (Object)("txstsFrom2ndAcknowledgement[" + txstsFrom2ndAcknowledgement + "]"));
            String addlInfFrom2ndAcknowledgement = "";
            String transResult = "";
            if (txstsFrom2ndAcknowledgement.equalsIgnoreCase("RJCT")) {
                try {
                    PaymentCancellation paymentCancellation = new PaymentCancellation();
                    String transXMLHeader = paymentCancellation.generateTransXMLForHeader(idFrom2ndAcknowledgement, this.userInfoGlobal);
                    String transXMLDetail = paymentCancellation.generateTransXMLForDetail(idFrom2ndAcknowledgement, this.userInfoGlobal);
                    transResult = paymentCancellation.paymentCancellation(transXMLHeader, transXMLDetail, this.userInfoGlobal);
                    addlInfFrom2ndAcknowledgement = ScheduledSFTPDownloader.getAcknowledgmentTagValue(file.getAbsolutePath(), "AddtlInf", "");
                    BaseLogger.log((String)"3", null, null, (Object)("addlInfFrom2ndAcknowledgement[" + addlInfFrom2ndAcknowledgement + "]"));
                    String bankEmailID = CommonMethods.getEventNotifyEmailFromBankMaster(idFrom2ndAcknowledgement, this.userInfoGlobal);
                    System.out.println("bankEmailID gsb[" + bankEmailID + "]");
                    HashMap<String, Object> mailFormatDetails = new HashMap<String, Object>();
                    mailFormatDetails.put("SEND_TO", bankEmailID);
                    mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
                    mailFormatDetails.put("SUBJECT", "Payment Cancellation for Payment ID:" + idFrom2ndAcknowledgement);
                    mailFormatDetails.put("BODY", "This mail is to inform that payment has been cancelled for Payment ID: " + idFrom2ndAcknowledgement + "\nReason: " + addlInfFrom2ndAcknowledgement);
                    EMail email = new EMail();
                    email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
                    System.out.println("getMailFrom1....::" + email.getMailFrom());
                    String mailXMLStr = this.buildMailXMLStr(mailFormatDetails, this.userInfoGlobal);
                    String emailStatus = email.sendMail(mailXMLStr, "ITM", this.userInfoGlobal);
                    System.out.println("emailStatus....::" + emailStatus);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.updatePaymentStatus2ndAck(paymentId, idFrom2ndAcknowledgement, txstsFrom2ndAcknowledgement, addlInfFrom2ndAcknowledgement, transResult);
        } else {
            System.out.println("Unsupported acknowledgement type: " + ackType);
            return;
        }
        ScheduledSFTPDownloader.moveFileToArchive(file, archiveDirectory);
    }

    private static String getAckType(String fileName) {
        String[] parts = fileName.split("\\.");
        if (parts.length > 0) {
            return parts[0].substring(0, Math.min(4, parts[0].length()));
        }
        return "";
    }

    private static String getPaymentId(String fileName) {
        System.out.println("Inside getPaymentId fileName:[" + fileName + "]");
        String[] parts = fileName.split("\\.");
        if (parts.length >= 3) {
            return parts[2];
        }
        return null;
    }

    private void updatePaymentStatus1stAck(String IDFromAck1, String stsFromAck1, String addlInfAck1, String transResult) {
        stsFromAck1 = String.valueOf(stsFromAck1) + " " + transResult;
        System.out.println("Inside updatePaymentStatus1stAck[: " + IDFromAck1 + "] stsFromAck1 [" + stsFromAck1 + "] addlInfAck2 [" + addlInfAck1 + "]");
        UpdatePaymentStatus updatePaymentStatus = new UpdatePaymentStatus();
        String refSer = "";
        try {
            refSer = this.dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", "TRAN_WINDOW  = 'w_misc_pay'", this.userInfoGlobal.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Value of refser... [" + refSer + "]"));
            String transXMLFor1stAcknowldgement = updatePaymentStatus.getTransXML(IDFromAck1, refSer, "1st Acknowledgement Received", stsFromAck1, addlInfAck1);
            updatePaymentStatus.updatePaymentStatus(transXMLFor1stAcknowldgement, this.userInfoGlobal);
        }
        catch (ITMException | RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updatePaymentStatus2ndAck(String paymentId, String IDFromAck2, String stsFromAck2, String addlInfAck2, String transResult) {
        stsFromAck2 = String.valueOf(stsFromAck2) + " " + transResult;
        System.out.println("Updating payment status for ACK2 with paymentId: " + paymentId);
        System.out.println("Inside updatePaymentStatus2ndAck IDFromAck2[: " + IDFromAck2 + "] stsFromAck2 [" + stsFromAck2 + "] addlInfAck2 [" + addlInfAck2 + "]");
        UpdatePaymentStatus updatePaymentStatus = new UpdatePaymentStatus();
        String refSer = "";
        try {
            refSer = this.dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", "TRAN_WINDOW  = 'w_misc_pay'", this.userInfoGlobal.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Value of refser... [" + refSer + "]"));
            String transXMLFor2ndAcknowldgement = updatePaymentStatus.getTransXML(IDFromAck2, refSer, "2nd Acknowledgement Received", stsFromAck2, addlInfAck2);
            updatePaymentStatus.updatePaymentStatus(transXMLFor2ndAcknowldgement, this.userInfoGlobal);
        }
        catch (ITMException | RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getAcknowledgmentTagValue(String filePath, String tagName, String parentTagName) {
        String result = "";
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method filePath [" + filePath + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("Inside checkFirstAcknowledgement method tagName [" + tagName + "]"));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(filePath));
            BaseLogger.log((String)"3", null, null, (Object)("Acknowledgement document:[" + E12GenericUtility.documentToString((Document)document) + "]"));
            if (parentTagName.equalsIgnoreCase("")) {
                result = ScheduledSFTPDownloader.getElementValueByTagName(document, tagName);
            } else {
                Element rootElement = document.getDocumentElement();
                System.out.println("Root Element gsb: " + document.getDocumentElement().getTagName());
                result = ScheduledSFTPDownloader.getElementValue(rootElement, parentTagName, tagName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log((String)"3", null, null, (Object)("result from getAcknowledgmentTagValue:[" + result + "]"));
        return result;
    }

    private static String getElementValueByTagName(Document document, String tagName) {
        NodeList nodeList = document.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            return element.getTextContent();
        }
        return null;
    }

    private static String getElementValue(Element parentElement, String parentTagName, String tagName) {
        NodeList parentNodes = parentElement.getElementsByTagName(parentTagName);
        int i = 0;
        while (i < parentNodes.getLength()) {
            int j = 0;
            Element parent = (Element)parentNodes.item(i);
            NodeList nodeList = parent.getElementsByTagName(tagName);
            if (j < nodeList.getLength()) {
                Element element = (Element)nodeList.item(j);
                return element.getTextContent();
            }
            ++i;
        }
        return null;
    }

    private static void moveFileToArchive(File sourceFile, File archiveDirectory) {
        System.out.println("Inside moveFileToArchive sourceFile [" + sourceFile.getAbsolutePath() + "]  archiveDirectory [" + archiveDirectory.getAbsolutePath() + "]");
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
            String dateFolderName = dateFormat.format(new Date());
            File dateFolder = new File(archiveDirectory, dateFolderName);
            ScheduledSFTPDownloader.createDirectoryIfNotExists(dateFolder);
            Path destinationPath = new File(dateFolder, sourceFile.getName()).toPath();
            Files.move(sourceFile.toPath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Moved " + sourceFile.getName() + " to " + destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String findUTRFileForDate(String utrFolderPath, String date) {
        System.out.println("Inside findUTRFileForDate [" + utrFolderPath + "]  Date [" + date + "]");
        File utrDirectory = new File(utrFolderPath);
        if (!utrDirectory.isDirectory()) {
            System.out.println("Invalid UTR directory path.");
            return null;
        }
        File[] files = utrDirectory.listFiles();
        if (files != null) {
            return Arrays.stream(files).filter(file -> file.isFile() && file.getName().contains(date)).max(Comparator.comparing(File::lastModified)).map(File::getName).orElse(null);
        }
        return null;
    }

    private static void moveFileToArchive(String sourceFilePath, String archiveFolderPath) {
        System.out.println("Inside moveFileToArchive [" + sourceFilePath + "]  archiveFolderPath [" + archiveFolderPath + "]");
        try {
            Path sourcePath = Paths.get(sourceFilePath, new String[0]);
            Path archivePath = Paths.get(archiveFolderPath, sourcePath.getFileName().toString());
            ScheduledSFTPDownloader.createDirectoryIfNotExists(new File(archiveFolderPath));
            Files.move(sourcePath, archivePath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Moved " + sourcePath.getFileName() + " to " + archivePath);
        }
        catch (FileAlreadyExistsException e) {
            System.out.println("File already exists in the destination directory: " + e.getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String buildMailXMLStr(HashMap<String, Object> mailFormatDetails, UserInfoBean userInfo) {
        BaseLogger.log((String)"2", null, null, (Object)"Emailscheduler buildMailXMLStr calling-----------------");
        String mailXMLStr = "";
        String emailID = mailFormatDetails.get("SEND_TO").toString();
        BaseLogger.log((String)"3", null, null, (Object)("emailID [" + emailID + "]"));
        String body = mailFormatDetails.get("BODY").toString();
        BaseLogger.log((String)"3", null, null, (Object)("body [" + body + "]"));
        String formatCode = "";
        String system = mailFormatDetails.get("SUBJECT").toString();
        BaseLogger.log((String)"3", null, null, (Object)("system [" + system + "]"));
        String objName = "";
        String workDateApp = "";
        try {
            BaseLogger.log((String)"2", null, null, (Object)"Inside try block method: buildMailXMLStr ---");
            mailXMLStr = "<ROOT><TRANS_INFO><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_SER></REF_SER><REF_ID>" + workDateApp + "</REF_ID>" + "<LINE_NO>1</LINE_NO></TRANS_INFO>" + "<EMAIL_TYPE></EMAIL_TYPE><ENTITY_CODE></ENTITY_CODE>" + "<FORMAT_CODE>" + formatCode + "</FORMAT_CODE>" + "<LINK_ADDR></LINK_ADDR>" + "<TO_ADD>" + emailID + " </TO_ADD>" + "<CC_ADD>" + mailFormatDetails.get("COPY_TO") + "</CC_ADD>" + "<BCC_ADD>" + mailFormatDetails.get("BLIND_COPY") + "</BCC_ADD>" + "<BODY_TEXT>" + body + "</BODY_TEXT>" + "<SUBJECT>" + mailFormatDetails.get("SUBJECT") + "</SUBJECT>" + "</ROOT>";
            System.out.println("mailXMLStr....::" + mailXMLStr);
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception from buildMailXMLStr [" + system + "]"));
            e.printStackTrace();
        }
        return mailXMLStr;
    }
}

