/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.JMSLogger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSSender {
    public static final String JMS_USERNAME = CommonConstants.JMS_USERNAME;
    public static final String JMS_PASSWORD = CommonConstants.JMS_PASSWORD;
    public static final String JMS_CONNECTION_FACTORY = CommonConstants.JMS_CONNECTION_FACTORY;
    public static final String JMS_QUEUE = CommonConstants.JMS_QUEUE;
    private QueueConnectionFactory qconFactory;
    private QueueConnection qcon;
    private QueueSession qsession;
    private QueueSender qsender;
    private Queue queue;
    private TextMessage message;
    private UserInfoBean userInfo;

    public JMSSender(UserInfoBean userInfo) {
        try {
            this.userInfo = userInfo;
            this.init();
            JMSLogger.log("3", userInfo, null, "JMS Ready To Send Messages");
        }
        catch (Exception e) {
            JMSLogger.log("3", userInfo, null, "In JMSSender Exception:[ " + E12GenericUtility.getStackTrace(e) + "]");
        }
    }

    public void init() throws NamingException, JMSException {
        JMSLogger.log("3", this.userInfo, null, "JMSSender.init()");
        InitialContext ctx = new InitialContext();
        this.qconFactory = (QueueConnectionFactory)ctx.lookup(JMS_CONNECTION_FACTORY);
        this.qcon = this.qconFactory.createQueueConnection(JMS_USERNAME, JMS_PASSWORD);
        this.qsession = this.qcon.createQueueSession(false, 101);
        this.queue = (Queue)ctx.lookup(JMS_QUEUE);
        this.qsender = this.qsession.createSender(this.queue);
        this.message = this.qsession.createTextMessage();
        this.qcon.start();
    }

    public void send(String jmsData) throws JMSException {
        try {
            JMSLogger.log("3", this.userInfo, null, "JMSSender.send() jmsData:[" + jmsData + "]");
            this.message.setText(jmsData);
            this.qsender.send((Message)this.message);
            this.close();
        }
        catch (Exception e) {
            JMSLogger.log("3", this.userInfo, null, "In JMSSender.send() Exception:[ " + E12GenericUtility.getStackTrace(e) + "]");
        }
    }

    public void close() throws JMSException {
        JMSLogger.log("3", this.userInfo, null, "JMSSender.close()");
        this.qsender.close();
        this.qsession.close();
        this.qcon.close();
    }

    public TextMessage getMessage() {
        return this.message;
    }

    public void setMessage(TextMessage message) {
        this.message = message;
    }

    public QueueConnection getConnection() {
        return this.qcon;
    }
}

