/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.dw.metadata.SybaseEDataWindow;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.MetaDataObject;
import ibase.webitm.utility.ResourceModifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DWObject
extends MetaDataObject {
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable jndiProperties = null;
    static InitialContext ctx = null;

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("1", null, null, "DWObject infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in DWObject static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public DWObject(String filename, UserInfoBean userInfo) throws ITMException {
        super(filename, userInfo);
    }

    public String exportToXML(String profileIdRes, String objName, String objContext, String pageContext, String formName, String transDB, String userId) throws UnmarshalException {
        String xmlSting = null;
        SybaseEDataWindow processPkg = null;
        try {
            BaseLogger.log("3", null, null, "In DWObject - profileIdRes - [" + profileIdRes + "]");
            String editor = "";
            String profileId = "";
            if (profileIdRes != null && profileIdRes.indexOf("~~SEP~~") != -1) {
                String[] profileIdResNEditor = profileIdRes.split("~~SEP~~");
                int i = 0;
                while (i < profileIdResNEditor.length) {
                    if (i == 0) {
                        profileIdRes = DWObject.checkNull(profileIdResNEditor[i]);
                    } else if (i == 1) {
                        editor = DWObject.checkNull(profileIdResNEditor[i]);
                    }
                    ++i;
                }
            }
            BaseLogger.log("3", null, null, "profileIdRes - [" + profileIdRes + "], editor - [" + editor + "]");
            processPkg = this.applyResourcePack(profileIdRes, objName, objContext, pageContext, profileId, editor, formName, transDB, userId);
            Document doc = this.getXMLMetaDataDoc(processPkg);
            BaseLogger.log("3", null, null, "Document generated");
            xmlSting = new E12GenericUtility().serializeDom(doc);
            String standardNameForXML = String.valueOf(profileIdRes) + "~~" + objName + pageContext + objContext;
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                infinispanLocalObj.putFormData(standardNameForXML, xmlSting);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnmarshalException((Throwable)e);
        }
        return xmlSting;
    }

    public String exportToXML(String profileIdRes, String objName, String objContext, String pageContext, String transDB, String userId) throws UnmarshalException {
        String xmlSting = null;
        String formName = "";
        try {
            xmlSting = this.exportToXML(profileIdRes, objName, objContext, pageContext, formName, transDB, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnmarshalException((Throwable)e);
        }
        return xmlSting;
    }

    private SybaseEDataWindow applyResourcePack(String profileIdRes, String objName, String objContext, String pageContext, String profileId, String editor, String formName, String transDB, String userId) throws UnmarshalException {
        String defaultPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator;
        String savedPath = null;
        SybaseEDataWindow processPkg = null;
        UserInfoBean userInfo = null;
        try {
            BaseLogger.log("3", userInfo, null, "applyResourcePack >> this.filename ::" + this.filename);
            processPkg = this.getMetadaLibrary();
            ResourceModifier resModifier = new ResourceModifier();
            processPkg = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? resModifier.modifyResource(processPkg, profileIdRes, objName, objContext, pageContext, profileId, editor, formName, transDB, userId) : resModifier.modifyResource(processPkg, profileIdRes, objName, objContext, pageContext, profileId, editor, transDB, userId);
            JAXBContext jc = JAXBContext.newInstance((String)"ibase.dw.metadata");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            BaseLogger.log("3", userInfo, null, "Setting JAXB_ENCODING [" + CommonConstants.JAXB_ENCODING + "]");
            m.setProperty("jaxb.encoding", (Object)CommonConstants.JAXB_ENCODING);
            savedPath = String.valueOf(defaultPath) + profileIdRes;
            File fileObj = new File(savedPath);
            if (!fileObj.exists()) {
                fileObj.mkdirs();
            }
            File newFile = new File(this.filename);
            String file = String.valueOf(savedPath) + File.separator + newFile.getName();
            FileOutputStream os = new FileOutputStream(file);
            OutputStreamWriter osWrite = new OutputStreamWriter((OutputStream)os, CommonConstants.ENCODING);
            m.marshal((Object)processPkg, (Writer)osWrite);
        }
        catch (Exception i) {
            i.printStackTrace();
            throw new UnmarshalException((Throwable)i);
        }
        return processPkg;
    }

    private SybaseEDataWindow getMetadaLibrary() throws UnmarshalException {
        SybaseEDataWindow processPkg = null;
        try {
            File fileObj = new File(this.filename);
            JAXBContext jc = JAXBContext.newInstance((String)"ibase.dw.metadata");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setValidating(true);
            processPkg = (SybaseEDataWindow)unmarshaller.unmarshal(fileObj);
        }
        catch (Exception u) {
            u.printStackTrace();
            throw new UnmarshalException((Throwable)u);
        }
        return processPkg;
    }

    private Document getXMLMetaDataDoc(SybaseEDataWindow processPkg) {
        Document doc = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"ibase.dw.metadata");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
            m.marshal((Object)processPkg, (Node)doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    private static String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    public String exportToXML(String exportFolderName, String objName, String objContext, String pageContext, String formName, ArrayList<String> profileResList, ArrayList<String> enterpriseResList, HashMap<String, String> propEditorInfoMap, String transDB) throws UnmarshalException {
        String xmlSting = null;
        SybaseEDataWindow processPkg = null;
        String newObjContext = "";
        try {
            String editor = DWObject.checkNull(propEditorInfoMap.get("EDITOR"));
            String profileIdRes = DWObject.checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
            String enterpriseIdRes = DWObject.checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
            String profileId = DWObject.checkNull(propEditorInfoMap.get("PROFILE_ID"));
            String userId = DWObject.checkNull(propEditorInfoMap.get("USER_ID"));
            BaseLogger.log("3", null, null, "exportFolderName - [" + exportFolderName + "], profileResList - [" + profileResList + "], enterprise - [" + enterpriseResList + "], editor - [" + editor + "], profileId [" + profileId + "]");
            processPkg = this.applyResourcePacks(exportFolderName, objName, objContext, pageContext, profileId, editor, formName, profileResList, enterpriseResList, transDB, userId);
            Document doc = this.getXMLMetaDataDoc(processPkg);
            BaseLogger.log("3", null, null, "Document generated");
            xmlSting = new E12GenericUtility().serializeDom(doc);
            newObjContext = formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName) ? formName : objContext;
            String cacheMetadataFileName = String.valueOf(enterpriseIdRes) + "-" + profileIdRes + "-" + userId + "~~" + objName + pageContext + newObjContext;
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                infinispanLocalObj.putFormData(cacheMetadataFileName, xmlSting);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnmarshalException((Throwable)e);
        }
        return xmlSting;
    }

    private SybaseEDataWindow applyResourcePacks(String exportFolderName, String objName, String objContext, String pageContext, String profileId, String editor, String formName, ArrayList<String> profileResList, ArrayList<String> enterpriseResList, String transDB, String userId) throws UnmarshalException {
        String defaultPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator;
        String savedPath = null;
        SybaseEDataWindow processPkg = null;
        UserInfoBean userInfo = null;
        try {
            BaseLogger.log("3", userInfo, null, "applyResourcePack >> this.filename ::" + this.filename);
            processPkg = this.getMetadaLibrary();
            ResourceModifier resModifier = new ResourceModifier();
            if (enterpriseResList != null && enterpriseResList.size() > 0) {
                processPkg = resModifier.modifyResource(processPkg, enterpriseResList, objName, objContext, pageContext, profileId, editor, formName, transDB, userId);
            }
            if (profileResList != null && profileResList.size() > 0) {
                processPkg = resModifier.modifyResource(processPkg, profileResList, objName, objContext, pageContext, profileId, editor, formName, transDB, userId);
            }
            if (!(enterpriseResList != null && enterpriseResList.size() != 0 || profileResList != null && profileResList.size() != 0)) {
                processPkg = resModifier.modifyResource(processPkg, profileResList, objName, objContext, pageContext, profileId, editor, formName, transDB, userId);
            }
            JAXBContext jc = JAXBContext.newInstance((String)"ibase.dw.metadata");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            BaseLogger.log("3", userInfo, null, "Setting JAXB_ENCODING [" + CommonConstants.JAXB_ENCODING + "]");
            m.setProperty("jaxb.encoding", (Object)CommonConstants.JAXB_ENCODING);
            savedPath = String.valueOf(defaultPath) + exportFolderName;
            File fileObj = new File(savedPath);
            if (!fileObj.exists()) {
                fileObj.mkdirs();
            }
            File newFile = new File(this.filename);
            String file = String.valueOf(savedPath) + File.separator + newFile.getName();
            FileOutputStream os = new FileOutputStream(file);
            OutputStreamWriter osWrite = new OutputStreamWriter((OutputStream)os, CommonConstants.ENCODING);
            m.marshal((Object)processPkg, (Writer)osWrite);
        }
        catch (Exception i) {
            i.printStackTrace();
            throw new UnmarshalException((Throwable)i);
        }
        return processPkg;
    }
}

