/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import com.itextpdf.text.pdf.PdfReader;
import com.reader.DocumentMetaDataReader;
import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.AuditTrailExtEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ExcelToCSV;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.InvoiceDataPreprocessor;
import ibase.webitm.utility.InvoiceReader;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform;
import org.json.JSONException;
import org.json.JSONObject;

public class DoumentHandlerUtility
extends RestAPIServiceUtility {
    private UserInfoBean userInfo = null;
    private static String dirName = null;

    public byte[] getAttachConfigData(String objName, String refser, String refId, String checkObjName, HttpServletRequest request, String tokenIDfromHeader, UserInfoBean userInfo) {
        BaseLogger.log("3", null, null, "Insidet the getAttachConfigData() :");
        String returnData = null;
        RestAPIServiceUtility utility = new RestAPIServiceUtility();
        if (userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
        }
        BaseLogger.log("3", null, null, "objName ::  : [" + objName + "]");
        try {
            if (!"".equals(utility.checkNull(objName))) {
                DocumentHandlerWrapperEJB docWrapperHandler = new DocumentHandlerWrapperEJB();
                docWrapperHandler.setUserInfo(userInfo);
                returnData = docWrapperHandler.getAttachmentsMetaData(objName, refId, userInfo, checkObjName);
                BaseLogger.log("3", null, null, "returnData ::  : [" + returnData + "]");
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("EXCEPTION", (Object)("ObjName is invalid [" + objName + "]."));
                returnData = jsonObject.toString();
            }
        }
        catch (Exception ex) {
            BaseLogger.log("3", userInfo, null, "Exception in DocumentHandlerServlet :: handleDocument() : " + ex);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("EXCEPTION", (Object)ex);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            returnData = jsonObject.toString();
        }
        return returnData.getBytes();
    }

    public String getFileConfigurationData(String objName, HttpServletRequest request, String tokenIDfromHeader, UserInfoBean userInfo) {
        String returnData = null;
        if (userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
        }
        try {
            if (!"".equals(this.checkNull(objName))) {
                DocumentHandlerWrapperEJB docWrapperHandler = new DocumentHandlerWrapperEJB();
                docWrapperHandler.setUserInfo(userInfo);
                returnData = docWrapperHandler.getFileConfigurationsMetadata(objName, userInfo.getTransDB());
            } else {
                BaseLogger.log("3", userInfo, null, "DocumentHandlerServlet :: handleDocument() : Invalid objName[" + objName + "]");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("EXCEPTION", (Object)("ObjName is invalid [" + objName + "]."));
                returnData = jsonObject.toString();
            }
        }
        catch (Exception ex) {
            BaseLogger.log("3", userInfo, null, "Exception in DocumentHandlerServlet :: handleDocument() : " + ex);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("EXCEPTION", (Object)ex.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            returnData = jsonObject.toString();
        }
        return returnData;
    }

    public String getUploadDocument(String captureImage, String imgExist, String fileName, String refSer, String refId, String objName, String documentType, String fileType, String docLinkOpt, String fileMetadata, String docMetaData, String refDescr, String expDate, String cacheOpt, HttpServletRequest request, String tokenIDfromHeader, UserInfoBean userInfo) {
        BaseLogger.log("3", userInfo, null, " Iniside getUploadDocument AMS");
        String uploadedFilePath = request.getParameter("UPLOADED_FILE_PATH");
        String croppedImg = this.checkNull(request.getParameter("CROPPED_IMAGE"));
        String croppedImgName = this.checkNull(request.getParameter("CROPPED_IMAGE_NAME"));
        int rotateAngle = this.checkNull(request.getParameter("ROTATE_ANGLE")).length() > 0 ? Integer.parseInt(request.getParameter("ROTATE_ANGLE")) : 0;
        BaseLogger.log("3", userInfo, null, " ************* croppedImg - [" + croppedImg + "] : croppedImgName - [" + croppedImgName + "]");
        String userId = "";
        DBAccessEJB dbAccess = new DBAccessEJB();
        DocumentHandlerEJB docHandler = null;
        docHandler = new DocumentHandlerEJB();
        try {
            if (imgExist == null || "".equalsIgnoreCase(imgExist) || "false".equalsIgnoreCase(imgExist)) {
                BaseLogger.log("3", userInfo, null, " ************* captureImg [" + captureImage + "]");
                if ("true".equalsIgnoreCase(captureImage)) {
                    fileName = this.loadFile(request);
                    String bmrImagesPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bmr_images";
                    File destDir = new File(bmrImagesPath);
                    if (!destDir.exists()) {
                        destDir.mkdirs();
                    }
                    File srcFile = new File(String.valueOf(dirName) + File.separator + fileName);
                    FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
                } else {
                    fileName = "true".equalsIgnoreCase(croppedImg) && croppedImgName.length() > 0 ? croppedImgName : this.loadFile(request, true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
        }
        if (fileName.length() == 0) {
            fileName = String.valueOf(userId) + ".png";
        }
        dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "dump";
        BaseLogger.log("3", userInfo, null, "***** documentHandler servlet fileName[" + fileName + "]");
        String filePath = String.valueOf(dirName) + File.separator + fileName;
        BaseLogger.log("3", userInfo, null, " New filePath is :: [" + filePath + "]");
        if (uploadedFilePath != null && uploadedFilePath.length() > 0) {
            filePath = uploadedFilePath;
        }
        if ("true".equalsIgnoreCase(croppedImg)) {
            filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "dump" + File.separator + "croppedImg" + File.separator + fileName;
        }
        BaseLogger.log("3", userInfo, null, "fileName - [" + fileName + "] : filePath - [" + filePath + "]");
        BaseLogger.log("3", userInfo, null, "CommonConstants.APPLICATION_CONTEXT value :--> [" + CommonConstants.APPLICATION_CONTEXT + "]");
        if (rotateAngle > 0 && "false".equalsIgnoreCase(croppedImg)) {
            this.rotateImage(fileName, filePath, rotateAngle);
        }
        String retStr = null;
        try {
            String chgTerm;
            String condition;
            String tranWindow;
            retStr = this.addDocument(request, filePath, refSer, docHandler, userInfo);
            if (this.checkNull(objName).length() == 0 && this.checkNull(tranWindow = dbAccess.getDBColumnValue("TRANSETUP", "TRAN_WINDOW", condition = " REF_SER = '" + refSer + "' ", userInfo.getTransDB())).length() > 0) {
                objName = tranWindow.replace("w_", "");
            }
            String auditStaus = "Error";
            if (retStr != null && retStr.indexOf("<Document>") != -1) {
                auditStaus = "Success";
                if ("true".equalsIgnoreCase(croppedImg)) {
                    try {
                        File file = new File(filePath);
                        if (file.delete()) {
                            BaseLogger.log("3", userInfo, null, String.valueOf(file.getName()) + " is deleted!");
                        } else {
                            BaseLogger.log("3", userInfo, null, "Delete operation is failed.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((chgTerm = userInfo.getRemoteHostName()) != null && chgTerm.length() > 15) {
                chgTerm = chgTerm.substring(0, 15);
            } else if (chgTerm == null || chgTerm.length() == 0) {
                chgTerm = userInfo.getRemoteHost();
            }
            AuditTrailExtEJB auditTrailExt = new AuditTrailExtEJB();
            String auditTranId = auditTrailExt.saveActionPerformedInAudit(objName, refId, "UPLOAD_ATTACHMENT", "UPLOAD_ATTACHMENT", userInfo.getLoginCode(), chgTerm, userInfo);
            auditTrailExt.updateAuditResponse(auditTranId, auditStaus, retStr, userInfo);
            byte[] byteArray = retStr.getBytes();
            this.removeTempFile(String.valueOf(dirName) + File.separator + fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retStr;
    }

    private void rotateImage(String imgName, String filePath, int rotateAngle) {
        try {
            if (rotateAngle > 0) {
                BufferedImage originalImage = ImageIO.read(new File(filePath));
                BaseLogger.log("3", null, null, "Original image dimension: " + originalImage.getWidth() + " x " + originalImage.getHeight());
                int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
                int imgWidth = originalImage.getWidth();
                int imgHeight = originalImage.getHeight();
                BufferedImage rotateImage = new BufferedImage(imgWidth, imgHeight, type);
                Graphics2D g = rotateImage.createGraphics();
                g.rotate(Math.toRadians(rotateAngle), rotateImage.getWidth() / 2, rotateImage.getHeight() / 2);
                g.drawImage(originalImage, 0, 0, imgWidth, imgHeight, null);
                g.dispose();
                BaseLogger.log("3", null, null, "Cropped image dimension: " + rotateImage.getWidth() + " x " + rotateImage.getHeight());
                if (E12GenericUtility.checkNull(imgName).length() > 0) {
                    File outputfile = new File(filePath);
                    ImageIO.write((RenderedImage)rotateImage, "jpg", outputfile);
                    BaseLogger.log("3", null, null, "Image rotated successfully: " + outputfile.getPath());
                } else {
                    BaseLogger.log("3", null, null, "Image Name is empty.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeTempFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                if (file.delete()) {
                    BaseLogger.log("3", null, null, "File deleted successfully");
                } else {
                    BaseLogger.log("3", null, null, "Failed to delete the file");
                }
            } else {
                BaseLogger.log("3", null, null, "file not exist in temp location");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception in remove temp attachment file");
        }
    }

    private String addDocument(HttpServletRequest request, String filePath, String refSer, DocumentHandlerEJB docHandler, UserInfoBean userInfo) throws Exception {
        String retString = null;
        BufferedInputStream bfr = null;
        ByteArrayOutputStream bout = null;
        try {
            try {
                String refCol;
                String objName = request.getParameter("OBJ_NAME");
                String refId = request.getParameter("REF_ID");
                if (refId.endsWith(":")) {
                    refId = refId.substring(0, refId.length() - 1);
                }
                if ((refCol = this.checkNull(request.getParameter("REF_COL"))).length() == 0) {
                    refCol = " ";
                }
                String strGrabFrame = this.checkNull(request.getParameter("GRAB_FRAME"));
                String documentType = this.checkNull(request.getParameter("DOCUMENT_TYPE"));
                if ("".equalsIgnoreCase(documentType)) {
                    documentType = this.checkNull((String)request.getAttribute("DOCUMENT_TYPE"));
                }
                String attachFileType = this.checkNull(request.getParameter("FILE_TYPE"));
                String module = this.checkNull(request.getParameter("MODULE"));
                String docMetaData = this.checkNull(request.getParameter("DOC_META_DATA"));
                File file = new File(filePath);
                String fileName = file.getName();
                String fileType = filePath.substring(filePath.lastIndexOf(".") + 1);
                int noOfPages = 0;
                if ("pdf".equalsIgnoreCase(attachFileType)) {
                    FileInputStream pdfFileStream = new FileInputStream(file);
                    noOfPages = this.getPDFNumberOfPages(pdfFileStream);
                    ((InputStream)pdfFileStream).close();
                }
                String docLinkOptn = request.getParameter("DOC_LINK_OPT");
                String extractedData = "";
                DocumentHandlerWrapperEJB documentHandlerWrapperEJB = new DocumentHandlerWrapperEJB();
                String templatePath = documentHandlerWrapperEJB.getExtractionTemplatePath(objName, documentType, userInfo);
                BaseLogger.log("3", userInfo, null, "Extracted_data :templatePath[" + templatePath + "]");
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                String extractPrc = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("OBJ_ATTACH_CONFIG", "EXTRACT_PRC", "WHERE OBJ_NAME='" + objName + "' AND DOC_TYPE='" + documentType + "'", userInfo.getTransDB()));
                String extractTempl = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("OBJ_ATTACH_CONFIG", "EXTRACT_TEMPL", "WHERE OBJ_NAME='" + objName + "' AND DOC_TYPE='" + documentType + "'", userInfo.getTransDB()));
                String procStatus = "I";
                String docProcessTrail = "";
                String docOcrData = "";
                String entityType = "";
                String docOverviewData = "";
                if (extractPrc.equals("EXCELINMEM") && !"".equals(extractTempl)) {
                    BaseLogger.log("3", userInfo, null, "Inside if condition line no 2101 extractTempl : [" + extractTempl + "]");
                    String responseString = "";
                    ExcelToCSV excelToCSV = new ExcelToCSV();
                    responseString = excelToCSV.excelToCSV(file, userInfo, extractTempl);
                    BaseLogger.log("0", null, null, "Print responseString line no 2997---- :" + responseString);
                } else if (templatePath != null && templatePath.length() > 1) {
                    InvoiceReader invoiceReader = new InvoiceReader(file);
                    DocumentHandlerWrapperEJB documentHandlerEjb = new DocumentHandlerWrapperEJB();
                    entityType = documentHandlerEjb.getEntityType(userInfo, documentType);
                    extractedData = invoiceReader.readInvoice(userInfo, templatePath, true, documentType, entityType, "", objName);
                    procStatus = invoiceReader.getProcStatus();
                    BaseLogger.log("3", userInfo, null, "Print procStatus : " + procStatus);
                    BaseLogger.log("3", userInfo, null, "Extracted_data : " + extractedData);
                    if (extractedData.length() > 1) {
                        InvoiceDataPreprocessor preProcess = new InvoiceDataPreprocessor();
                        extractedData = preProcess.processData(extractedData);
                        BaseLogger.log("0", null, null, "extracted_data after process  ---- :" + extractedData);
                        docOcrData = invoiceReader.getOcrData();
                    }
                    docProcessTrail = invoiceReader.getDocProcTrailData();
                    docOverviewData = invoiceReader.getOverViewData();
                }
                String refDescr = this.checkNull(request.getParameter("REF_DESCR"));
                String expDate = request.getParameter("EXP_DATE");
                String cacheOpt = request.getParameter("CACHE_OPT");
                String fileMetadata = this.checkNull(request.getParameter("FILE_METADATA"));
                fileMetadata = this.getFileMetaData(filePath, userInfo);
                String docId = this.checkNull(request.getParameter("DOC_ID"));
                if (docId.equalsIgnoreCase("")) {
                    docId = this.checkNull((String)request.getAttribute("DOC_ID"));
                }
                boolean isMajorVersion = false;
                try {
                    String majorVersion = this.checkNull(request.getParameter("IS_MAJOR_VERSION"));
                    if (majorVersion.length() > 0) {
                        isMajorVersion = Boolean.parseBoolean(majorVersion);
                    }
                }
                catch (Exception e) {
                    isMajorVersion = false;
                    e.printStackTrace();
                }
                String checkinComment = this.checkNull(request.getParameter("CHECKIN_COMMENT"));
                String userId = userInfo.getLoginCode();
                StringBuffer retXMLStringBuff = new StringBuffer();
                retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
                retXMLStringBuff.append("<DocumentRoot>");
                retXMLStringBuff.append("<description>Datawindow Root</description>");
                retXMLStringBuff.append("<group0>");
                retXMLStringBuff.append("<description>Group0 description</description>");
                retXMLStringBuff.append("<Header0>");
                retXMLStringBuff.append("<description>Header0 members</description>");
                retXMLStringBuff.append("<header>");
                retXMLStringBuff.append("<ref_id><![CDATA[").append(refId).append("]]></ref_id>");
                retXMLStringBuff.append("<ref_col><![CDATA[").append(refCol).append("]]></ref_col>");
                retXMLStringBuff.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>");
                retXMLStringBuff.append("<ref_ser><![CDATA[").append(refSer).append("]]></ref_ser>");
                retXMLStringBuff.append("<doc_name><![CDATA[").append(fileName).append("]]></doc_name>");
                retXMLStringBuff.append("<doc_type><![CDATA[").append(fileType).append("]]></doc_type>");
                retXMLStringBuff.append("<document_type><![CDATA[").append(documentType).append("]]></document_type>");
                retXMLStringBuff.append("<file_type><![CDATA[").append(attachFileType).append("]]></file_type>");
                retXMLStringBuff.append("<created_by><![CDATA[").append(userId).append("]]></created_by>");
                retXMLStringBuff.append("<doc_link_optn><![CDATA[" + docLinkOptn + "]]></doc_link_optn>");
                retXMLStringBuff.append("<ref_descr><![CDATA[" + refDescr + "]]></ref_descr>");
                retXMLStringBuff.append("<doc_pages><![CDATA[" + noOfPages + "]]></doc_pages>");
                retXMLStringBuff.append("<extracted_data><![CDATA[" + extractedData + "]]></extracted_data>");
                retXMLStringBuff.append("<file_metadata><![CDATA[" + fileMetadata + "]]></file_metadata>");
                retXMLStringBuff.append("<exp_date><![CDATA[" + expDate + "]]></exp_date>");
                retXMLStringBuff.append("<cache_opt><![CDATA[" + cacheOpt + "]]></cache_opt>");
                retXMLStringBuff.append("<module><![CDATA[" + module + "]]></module>");
                retXMLStringBuff.append("<doc_meta_data><![CDATA[").append(docMetaData).append("]]></doc_meta_data>");
                retXMLStringBuff.append("<doc_id><![CDATA[" + docId + "]]></doc_id>");
                retXMLStringBuff.append("<is_major_version><![CDATA[" + isMajorVersion + "]]></is_major_version>");
                retXMLStringBuff.append("<checkin_comment><![CDATA[" + checkinComment + "]]></checkin_comment>");
                retXMLStringBuff.append("<proc_status><![CDATA[" + procStatus + "]]></proc_status>");
                retXMLStringBuff.append("<doc_proc_trail><![CDATA[" + URLEncoder.encode(docProcessTrail, "UTF-8") + "]]></doc_proc_trail>");
                retXMLStringBuff.append("<ocr_data><![CDATA[" + URLEncoder.encode(docOcrData, "UTF-8") + "]]></ocr_data>");
                retXMLStringBuff.append("<overview_data><![CDATA[" + docOverviewData + "]]></overview_data>");
                retXMLStringBuff.append("</header>");
                retXMLStringBuff.append("</Header0>");
                retXMLStringBuff.append("</group0>");
                retXMLStringBuff.append("</DocumentRoot>");
                BaseLogger.log("3", userInfo, null, "getAttachmentDetailStr [" + retXMLStringBuff + "]");
                FileInputStream input = new FileInputStream(file);
                bfr = new BufferedInputStream(input);
                bout = new ByteArrayOutputStream();
                int i = -1;
                while ((i = bfr.read()) != -1) {
                    bout.write(i);
                }
                byte[] byteArray = bout.toByteArray();
                byte[] previewImage = new byte[]{};
                if ("pdf".equalsIgnoreCase(fileType)) {
                    previewImage = this.getPdfPreviewImage(filePath);
                } else if ("zip".equalsIgnoreCase(fileType)) {
                    String htmlPreviewCaptureService = E12GenericUtility.getPythonServiceURL("HTML_CAPTURE");
                    if (htmlPreviewCaptureService != null) {
                        try {
                            File zipFile = new File(filePath);
                            previewImage = E12GenericUtility.makeMultipartRequest(htmlPreviewCaptureService, zipFile);
                        }
                        catch (Exception ex) {
                            BaseLogger.log("3", null, "DocumentHandlerWrapperEJB", "Exception while getting ZIP file preview : " + ex);
                        }
                    }
                } else {
                    previewImage = "txt".equalsIgnoreCase(fileType) ? this.getTextToImage(filePath) : ("csv".equalsIgnoreCase(fileType) ? this.getCsvToImage(filePath) : ("docx".equalsIgnoreCase(fileType) ? this.getDocxToImage(filePath) : this.getVideoPreviewImage(strGrabFrame, filePath, userInfo)));
                }
                retString = docHandler.addDocument(retXMLStringBuff.toString(), byteArray, previewImage, userInfo);
            }
            catch (ITMException itme) {
                throw itme;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
                if (bout != null) {
                    bout.close();
                    bout = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in releasing file resource :");
                e.printStackTrace();
            }
        }
        return retString;
    }

    private int getPDFNumberOfPages(InputStream pdfFileStream) {
        int noOfPages = 0;
        try {
            PdfReader pdfReader = new PdfReader(pdfFileStream);
            noOfPages = pdfReader.getNumberOfPages();
        }
        catch (IOException ex) {
            BaseLogger.log("0", null, null, "IOException in DocumentHandlerServlet :: getPDFNumberOfPages() : " + ex);
        }
        catch (Throwable throwable) {
            BaseLogger.log("0", null, null, "Exception or Error in DocumentHandlerServlet :: getPDFNumberOfPages() : " + throwable);
            BaseLogger.log("0", null, null, "The PDF file may be password protected or locked from copying, printing and modifying etc.\nFor error detailing, refer below stack trace");
            String stackTrace = this.buildStackTrace(throwable);
            BaseLogger.log("0", null, null, stackTrace);
        }
        BaseLogger.log("2", null, null, "DocumentHandlerServlet :: getPDFPageCount() : noOfPages [" + noOfPages + "]");
        return noOfPages;
    }

    private String getFileMetaData(String filePath, UserInfoBean userInfo) throws JSONException, ParseException {
        JSONObject fileMetadataJsonObj = new JSONObject();
        String fileMetadata = "";
        DocumentMetaDataReader dataReader = new DocumentMetaDataReader();
        HashMap metadataMap = dataReader.getDocumentMetaData(filePath);
        BaseLogger.log("3", userInfo, null, " metadataMap : [" + metadataMap + "]");
        if (metadataMap.containsKey("Date/Time") || metadataMap.containsKey("Date/Time Original")) {
            String dateStr = "";
            if (metadataMap.containsKey("Date/Time Original")) {
                dateStr = (String)metadataMap.get("Date/Time Original");
                BaseLogger.log("3", userInfo, null, "Date/Time Original : [" + dateStr + "]");
            } else {
                dateStr = (String)metadataMap.get("Date/Time");
                BaseLogger.log("3", userInfo, null, "Date/Time  : [" + dateStr + "]");
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date dateDt = dateFormat.parse(dateStr);
            fileMetadata = String.valueOf(dateDt.getTime());
            BaseLogger.log("3", userInfo, null, "fileMetadata : [" + fileMetadata + "]");
            fileMetadataJsonObj.put("lastModifiedDate", (Object)fileMetadata);
            fileMetadata = fileMetadataJsonObj.toString();
            BaseLogger.log("3", userInfo, null, " JSONObject fileMetadata : [" + fileMetadata + "]");
        }
        if (metadataMap.containsKey("Duration")) {
            String duration = (String)metadataMap.get("Duration");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = sdf.parse("1970-01-01 " + duration);
            BaseLogger.log("3", null, null, "in milliseconds: " + date.getTime());
            duration = String.valueOf(date.getTime());
            fileMetadataJsonObj.put("duration", (Object)duration);
            fileMetadata = fileMetadataJsonObj.toString();
            BaseLogger.log("3", userInfo, null, " JSONObject fileMetadata : [" + fileMetadata + "]");
        }
        return fileMetadata;
    }

    private String buildStackTrace(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.format("%s : %s\n", ex.getClass().getSimpleName(), ex.getMessage()));
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append(String.format("\tat %s\n", element.toString()));
            ++n2;
        }
        return sb.toString();
    }

    private byte[] getPdfPreviewImage(String filepath) {
        byte[] bytes = new byte[1];
        File file = new File(filepath);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (PDDocument document = PDDocument.load((File)file);){
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(0, 50.0f, ImageType.RGB);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                bytes = outputStream.toByteArray();
                document.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            BaseLogger.log("0", null, "DocumentHandlerWrapperEJB", "IOException while trying to create pdf document - " + ex);
            return bytes;
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, "DocumentHandlerWrapperEJB", "Other exception while trying to create pdf document - " + ex);
            return bytes;
        }
        return bytes;
    }

    private byte[] getTextToImage(String filepath) {
        byte[] bytes = new byte[1];
        File file = new File(filepath);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            bytes = this.convert(sb.toString(), String.valueOf(filepath) + "_img");
        }
        catch (IOException ex) {
            BaseLogger.log("0", null, "DocumentHandlerWrapperEJB", "IOException while trying to create txt document - " + ex);
            return bytes;
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, "DocumentHandlerWrapperEJB", "Other exception while trying to create txt document - " + ex);
            return bytes;
        }
        return bytes;
    }

    private byte[] convert(String text, String img_name) {
        String[] text_array = text.split("[\n]");
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        Font font = new Font("Consolas", 1, 12);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int width = fm.stringWidth(DoumentHandlerUtility.getLongestLine(text_array));
        int lines = DoumentHandlerUtility.getLineCount(text);
        int height = fm.getHeight() * (lines + 4);
        g2d.dispose();
        img = new BufferedImage(width, height, 2);
        g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setFont(font);
        fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        int i = 1;
        while (i <= lines) {
            g2d.drawString(text_array[i - 1], 0, fm.getAscent() * i);
            ++i;
        }
        g2d.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", outputStream);
            BaseLogger.log("0", null, null, "Print inside convert outputStream::::::: " + outputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    public static int getLineCount(String text) {
        return text.split("[\n]").length;
    }

    private static String getLongestLine(String[] arr) {
        String max = arr[0];
        int i = 1;
        while (i < arr.length) {
            if (max.length() < arr[i].length()) {
                max = arr[i];
            }
            ++i;
        }
        return max;
    }

    private byte[] getCsvToImage(String filepath) {
        byte[] bytes = new byte[1];
        File file = new File(filepath);
        StringBuffer data = new StringBuffer();
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] tempArr;
                String[] stringArray = tempArr = line.split(",");
                int n = tempArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    data.append(String.valueOf(str) + " ");
                    ++n2;
                }
                data.append("\n");
            }
            bytes = this.convert(data.toString(), String.valueOf(filepath) + "_img");
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, "DocumentHandlerWrapperEJB", "Other exception while trying to create csv document - " + ex);
            return bytes;
        }
        return bytes;
    }

    private byte[] getDocxToImage(String filepath) {
        byte[] bytes = new byte[1];
        try {
            FileInputStream fis = new FileInputStream(filepath);
            XWPFDocument doc = new XWPFDocument((InputStream)fis);
            StringBuilder strBuild = new StringBuilder();
            List paragraphs = doc.getParagraphs();
            for (XWPFParagraph para : paragraphs) {
                strBuild.append(para.getText()).append("\n");
            }
            bytes = this.convert(strBuild.toString(), String.valueOf(filepath) + "_img");
            fis.close();
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, "DocumentHandlerWrapperEJB", "Other exception while trying to create docx document - " + ex);
            return bytes;
        }
        return bytes;
    }

    private byte[] getVideoPreviewImage(String strGrabFrame, String filePath, UserInfoBean userInfo) {
        byte[] videoFrameByteArray;
        block11: {
            videoFrameByteArray = new byte[1];
            try {
                boolean grabFrame = new Boolean(strGrabFrame);
                if (!grabFrame) break block11;
                File videoFile = new File(filePath);
                if (videoFile.exists()) {
                    BaseLogger.log("3", userInfo, null, "@@@@@ DocumentHandlerServlet :: addDocument() : Video file found at [" + videoFile.toString() + "]");
                    try {
                        int totalFrames = 0;
                        int frameNumber = 10;
                        try {
                            FileChannelWrapper ch = NIOUtils.readableFileChannel((File)videoFile);
                            MP4Demuxer demuxer = new MP4Demuxer((SeekableByteChannel)ch);
                            AbstractMP4DemuxerTrack video_track = demuxer.getVideoTrack();
                            totalFrames = video_track.getMeta().getTotalFrames();
                            frameNumber = totalFrames * 10 / 100;
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", userInfo, null, "Exception in DocumentHandlerServlet :: getVideoPreviewImage() : " + e);
                        }
                        Picture picFrame = FrameGrab.getNativeFrame((File)videoFile, (int)frameNumber);
                        int height = picFrame.getHeight();
                        int width = picFrame.getWidth();
                        ColorSpace picColorSpace = picFrame.getColor();
                        if (picColorSpace != ColorSpace.RGB) {
                            Transform transform = ColorUtil.getTransform((ColorSpace)picFrame.getColor(), (ColorSpace)ColorSpace.RGB);
                            Picture newPic = Picture.create((int)width, (int)height, (ColorSpace)ColorSpace.RGB);
                            transform.transform(picFrame, newPic);
                            picFrame = newPic;
                        }
                        BufferedImage bufferedImage = new BufferedImage(width, height, 5);
                        byte[] bufferedImageData = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                        int[] picData = picFrame.getPlaneData(0);
                        int i = 0;
                        int len = bufferedImageData.length;
                        while (i < len) {
                            bufferedImageData[i] = (byte)picData[i];
                            ++i;
                        }
                        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)bufferedImage, "png", arrayOutputStream);
                        videoFrameByteArray = arrayOutputStream.toByteArray();
                    }
                    catch (IOException ex) {
                        BaseLogger.log("0", userInfo, null, "Exception in DocumentHandlerServlet :: addDocument() : " + ex);
                    }
                    catch (JCodecException ex) {
                        BaseLogger.log("0", userInfo, null, "Exception in DocumentHandlerServlet :: addDocument() : " + (Object)((Object)ex));
                    }
                    catch (Exception ex) {
                        BaseLogger.log("0", userInfo, null, "Exception in DocumentHandlerServlet :: addDocument() : " + ex);
                    }
                    break block11;
                }
                BaseLogger.log("3", userInfo, null, "@@@@@ DocumentHandlerServlet :: addDocument() : Video file NOT found at [" + videoFile.toString() + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return videoFrameByteArray;
    }

    private String loadFile(HttpServletRequest request) throws Exception {
        return this.loadFile(request, true);
    }

    private String loadFile(HttpServletRequest request, boolean isSaved) throws Exception {
        int MEMORY_THRESHOLD = 0x300000;
        int MAX_FILE_SIZE = 734003200;
        int MAX_REQUEST_SIZE = 744488960;
        String userFileName = "";
        String userFileType = "";
        String newFileName = "";
        String saveAsFileName = "";
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            BaseLogger.log("3", null, null, "Error: Form must has enctype=multipart/form-data.");
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(MEMORY_THRESHOLD);
        factory.setRepository(new File(System.getProperty("java.io.tmpdir")));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setFileSizeMax((long)MAX_FILE_SIZE);
        upload.setSizeMax((long)MAX_REQUEST_SIZE);
        File DUMP_DIR = null;
        if (isSaved) {
            DUMP_DIR = new File(dirName);
        } else {
            String editorId = request.getParameter("EDITOR_ID");
            String tmpdirName = String.valueOf(dirName) + File.separator + editorId;
            DUMP_DIR = new File(tmpdirName);
        }
        if (!DUMP_DIR.exists()) {
            DUMP_DIR.mkdirs();
        }
        try {
            List formItems = upload.parseRequest(request);
            if (formItems != null && formItems.size() > 0) {
                for (FileItem item : formItems) {
                    String fileName;
                    String fieldName = item.getFieldName();
                    BaseLogger.log("3", null, null, "fieldName : [" + fieldName + "]");
                    if (item.isFormField()) {
                        String fieldValue = item.getString();
                        BaseLogger.log("3", null, null, "fieldValue : [" + fieldValue + "]");
                        if ("userFileName".equalsIgnoreCase(fieldName)) {
                            userFileName = fieldValue;
                            continue;
                        }
                        if ("userFileType".equalsIgnoreCase(fieldName)) {
                            userFileType = fieldValue;
                            continue;
                        }
                        if (!"saveAsFileName".equalsIgnoreCase(fieldName)) continue;
                        saveAsFileName = fieldValue;
                        continue;
                    }
                    if (item.isFormField()) continue;
                    newFileName = fileName = new File(item.getName()).getName();
                    if (saveAsFileName != null && saveAsFileName.length() > 0) {
                        newFileName = saveAsFileName;
                    } else if (userFileName != null && userFileName.length() > 0) {
                        newFileName = String.valueOf(userFileName) + "." + userFileType;
                    }
                    BaseLogger.log("3", null, null, "newFileName**********[" + newFileName + "] DUMP_DIR [" + DUMP_DIR + "] fileName [" + fileName + "]");
                    String filePath = DUMP_DIR + File.separator + newFileName;
                    File storeFile = new File(filePath);
                    item.write(storeFile);
                }
            }
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception : loadFile : [" + ex.getMessage() + "]");
            ex.printStackTrace();
        }
        return newFileName;
    }
}

