package ibase.webitm.bean.wsfa;

import ibase.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
//import ibase.webitm.ejb.wsfa.transactions.SprsPlanBifurGWTIC;
import ibase.webitm.utility.*;

import javax.servlet.http.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import java.io.*;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.HashMap;
public class PlanbifurPrsBean 
{

	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public PlanbifurPrsBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	public PlanbifurPrsBean( String objName) throws ITMException
	{
		try
		{
			this.objName = objName;
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public PlanbifurPrsBean() throws ITMException
	{
	}
	
	public String getMeetingType( String salesPers, String selectedItem, String dbID) throws ITMException
	{
		String MeetingType = "";
		try
		{
			MeetingType = getMeetingDetails( salesPers, selectedItem,dbID);
			String xslFileName = getXSLFileName( "sprs_plan_bifur_meetingtype_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			System.out.println("xslFileName......"+xslFileName);
			MeetingType = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, MeetingType, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			
		}
		return MeetingType;
	}

	public String getMeetingDetails( String sprsCode, String selectedFldValue,String dbID) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverITM");
			
			sql = "SELECT FLD_VALUE,DESCR FROM GENCODES WHERE MOD_NAME ='W_SPRS_PLAN_BIFUR_GWT' AND FLD_NAME ='MEETING_TYPE'";
			
			System.out.println(" selectteam sql [" + sql + "]");
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int num = 1;
			while (rs.next()) 
			{
				String fldVlaue = rs.getString("FLD_VALUE");
				String fldVlaueDescr = rs.getString("DESCR");
				selectedFldValue = (selectedFldValue != null) ? selectedFldValue.trim() : selectedFldValue;
				fldVlaue = (fldVlaue != null) ? fldVlaue.trim() : fldVlaue;
				System.out.println("selectedFldValue===["+selectedFldValue+"] fldVlaue===["+fldVlaue+"]" );
				if (selectedFldValue.equals(fldVlaue)) 
				{
					valueXmlString.append("<MEETINGTYPE domID='" + num	+ "' selected = 'Y'>\r\n");
				} 
				else 
				{
					valueXmlString.append("<MEETINGTYPE domID='" + num	+ "' selected = 'N'>\r\n");
				}
				valueXmlString.append("<FLD_VALUE><![CDATA[").append(fldVlaue).append("]]></FLD_VALUE>\r\n");
				valueXmlString.append("<FLD_DESCR><![CDATA[").append(fldVlaueDescr).append("]]></FLD_DESCR>\r\n");
				valueXmlString.append("<FLD_NUM><![CDATA[").append(dbID).append("]]></FLD_NUM>\r\n");
				valueXmlString.append("</MEETINGTYPE>\r\n");
				num++;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :StrgBrandActBean :getPeriod(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (connectionObject != null && !connectionObject.isClosed()) 
				{					
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :StrgBrandActBean :getPeriod(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		return valueXmlString.toString();
	}
	//commented by sachin  satre on [7-feb-17] becouse no use for this method [start]
	/*public String getPriorVisits( String sprsCode, String strgCode, String eventDate ) throws ITMException
	{
		String visitData = "";
		try
		{
			
			visitData = new SprsPlanBifurGWTIC().getPriorVisitsValues(sprsCode, strgCode, eventDate);
			String xslFileName = getXSLFileName( "wsfa_sales_pers_prior_visit_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			visitData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, visitData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		System.out.println("visitData:::"+visitData);
		return visitData;
	}*/
	//commented by sachin  satre on [7-feb-17] becouse no use for this method [end]
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

	private String getErrorMsg(String xmlErrString) 
			throws ITMException,Exception
		{
			DocumentBuilderFactory docBuilderFactory = null;
			DocumentBuilder docBuilder = null;
			Document dom = null;
			NodeList parentNodeList = null;
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = "";

			String message = "";
			String description = "";
			String type = "";
			String errString = "";
			InputStream inputStream = null ;
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			ibase.webitm.utility.GenericUtility genericUtility = null;
			//ibase.utility.E12GenericUtility genericUtility = null;
			try
			{
					docBuilderFactory = DocumentBuilderFactory.newInstance();
					docBuilder = docBuilderFactory.newDocumentBuilder();
					System.out.println("ConfirmDARBean :[getErrorMsg] :: xmlErrString :: "+xmlErrString);
					//Commented and Changes done by Gaurav Singh on 03-Sep-14
					genericUtility = ibase.webitm.utility.GenericUtility.getInstance();
					//genericUtility = new ibase.utility.E12GenericUtility();
					dom = genericUtility.parseString(xmlErrString);
					System.out.println("ConfirmDARBean :[getErrorMsg] :: xmlErrString after parsing :: "+dom.toString());
					
					System.out.println("Dom prepared...");
					parentNodeList = dom.getElementsByTagName("error");
					int parentListLength = parentNodeList.getLength();
					for(int prntNo = 0; prntNo < parentListLength ; prntNo++)
					{
						parentNode = parentNodeList.item(prntNo);
						if (parentNode!=null )
						{
							childNodeList = parentNode.getChildNodes();
							if (childNodeList != null && childNodeList.getLength() > 0 )
							{
								int childNodeListLength = childNodeList.getLength();
								for(int ctr = 0; ctr < childNodeListLength; ctr++)
								{
									childNode = childNodeList.item(ctr);
									childNodeName = childNode.getNodeName();
									if (childNode != null && childNode.getFirstChild() != null )
									{
										if (childNodeName.trim().equalsIgnoreCase("message"))
										{
											message = childNode.getFirstChild().getNodeValue();
										}
										if	(childNodeName.trim().equalsIgnoreCase("description")) 
										{
											description = childNode.getFirstChild().getNodeValue();
										}
										if	(childNodeName.trim().equalsIgnoreCase("type")) 
										{
											type = childNode.getFirstChild().getNodeValue();
										}
										errString = "<table border = '0'><tr><td> "+message+"</td></tr><tr><td>Descr :"+description;
										if (type!=null && type.trim().equalsIgnoreCase("E"))
										{
											errString = errString + "</td></tr><tr><td>type : Error</td></tr>" ;
										}
										else if (type!=null && type.trim().equalsIgnoreCase("W"))
										{
											errString = errString + "</td></tr><tr>type : warning</td></tr>";
										}
										errString = errString+"</table>" ;
									}
									
								}
							}					
						}
						
					}
				
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
				throw ex;
			}
			System.out.println("returning errorMsg from getErrorMsg(String xmlErrString): "+errString);
			return errString ;
		}
	
		public String checkNull(String input)
		{
			if (input == null || "null".equalsIgnoreCase(input))
			{
				input= "";
			}
			return input.trim();
		}
	
	
}