/********************************************************
	      Title : DrchemistUpload
	      Date  : 02/JULY/12
	      Developer:Neelam Salunkhe
 ********************************************************/
package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.ejb.ValidatorEJB;
import ibase.system.config.ConnDriver;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

///@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgCustUpload extends ValidatorEJB implements StrgCustUploadLocal,StrgCustUploadRemote{
	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("xmlString::::"+xmlString);
			System.out.println("xmlString1::::"+xmlString1);
			System.out.println("xmlString2::::"+xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String sql="";
		boolean isNumber = true;
		String salesPers="";
		String errCode="";
		String scCode="";
		String effDate="";
		String valUpToDate="";
		String errorType = "";
		String errString = "";
		String custTypeDom="";
		String noVisit="";
		String stateCode="";
		String gender="";
		String shortId="";
		String localityCode="";
		String classCode="";
		String speciality="";
		String specialStrg="";
		int ctr=0;
		String qualification="";
		String custType="";
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		String qualStrg;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by kailash on 29-nov-18.
			conn = getConnection(); //Added by kailash on 29-nov-18.
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			String objName = checkNullAndTrim(getObjNameFromDom(dom, "objName",objContext));
			System.out.println("objName =["+objName+"] and editFlag =["+editFlag+"]");
			if ( "strgcust_doctor".equalsIgnoreCase(objName))
			{
				custType = "D";
			}
			else if ( "strgcust_chemist".equalsIgnoreCase(objName))
			{
				custType = "C";
			}

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("objName childNodeName is =["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULSLSPER ";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							salesPers = genericUtility.getColumnValue("sales_pers", dom);
							sql = "select count(1) from sales_pers where sales_pers = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,salesPers);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}

							if(cnt == 0)
							{
								errCode = "SLPNOTEXT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}

					else if(childNodeName.equalsIgnoreCase("cust_type"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "VCUSTTYPE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							System.out.println("print custypedom====>["+custTypeDom+"]");

							if( !("D".equalsIgnoreCase(custTypeDom) || "C".equalsIgnoreCase(custTypeDom) ))
							{
								errCode = "INVCUSTYPE";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							if ( editFlag != null && "E".equalsIgnoreCase(editFlag) && !custType.equalsIgnoreCase(custTypeDom) )
							{
								errCode = "INVCUSTYPE";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}

					}
					else if("D".equalsIgnoreCase(custType) && childNodeName.equalsIgnoreCase("short_id"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSHRID";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}

					}
					else if(childNodeName.equalsIgnoreCase("sc_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSCODE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							scCode = checkNull(genericUtility.getColumnValue("sc_code", dom));
							shortId = checkNull(genericUtility.getColumnValue("short_id", dom));
							sql = "select count(1) from strg_customer where sc_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,scCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt >= 1)
							{
								errCode = "VSTRGCODE1";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							if("D".equalsIgnoreCase(custTypeDom))
							{
								sql = "select count(1) from strg_series where sales_pers = ? and short_id=? and status='Y'";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,salesPers);
								pstmt.setString(2,shortId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if(cnt >= 1)
								{
									errCode = "VSTRGCODE2";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("first_name"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLFNAME";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						//Added by kailash on 04-12-18 [start]
						else
						{
							if( editFlag.equalsIgnoreCase("A") )//added by shraddha for duplicate entries validation on add mode[05-09-19]
							{
								String locCode =genericUtility.getColumnValue("locality_code",dom);
								String firstName =genericUtility.getColumnValue("first_name",dom);
								String middleName =genericUtility.getColumnValue("middle_name",dom);
								String lastName =genericUtility.getColumnValue("last_name",dom);
								String mobileNo =genericUtility.getColumnValue("mobile_no",dom);
								String regNo =genericUtility.getColumnValue("reg_no",dom);
								String sccCode =genericUtility.getColumnValue("sc_code",dom);
								String custmrType =genericUtility.getColumnValue("cust_type",dom);
								System.out.println("custmrType["+custmrType+"]locCode["+locCode+"]regNo["+regNo+"]");

								sql = "SELECT FN_CHK_DUP_STRGCUST(?,?,?,?,?,?,?,?) AS DUP_RECORD FROM DUAL";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString(1, locCode );
								pstmt.setString(2, firstName );
								pstmt.setString(3, middleName );
								pstmt.setString(4, lastName );
								pstmt.setString(5, mobileNo );
								pstmt.setString(6, regNo );
								pstmt.setString(7, sccCode );
								pstmt.setString(8, custmrType );

								rs = pstmt.executeQuery();
								if(rs.next())
								{
									if(rs.getInt("DUP_RECORD") > 0)
									{
										errCode = "DUPRECFOND";
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

						}
						//Added by kailash on 04-12-18 [end]
					}
					/* else if(childNodeName.equalsIgnoreCase("middle_name"))
				      {
					      if( childNode.getFirstChild() == null )
					      {
						      errCode = "NULLMNAME";//need to create error message
						      break;
					      }
				      }
				      else if(childNodeName.equalsIgnoreCase("last_name"))
				      {
					      if( childNode.getFirstChild() == null )
					      {
						      errCode = "NULLLNAME";//need to create error message
						      break;
					      }
				      }*/
					//Commented by kailash on 13-12-18 as per mesmer requirement it is not mandatory[start]
					/*else if(childNodeName.equalsIgnoreCase("addr1"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLADDR1";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}
					else if(childNodeName.equalsIgnoreCase("addr2"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLADDR2";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}
					else if(childNodeName.equalsIgnoreCase("addr3"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLADDR3";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}*/
					//Commented by kailash on 13-12-18 as per mesmer requirement it is not mandatory[end]
					else if(childNodeName.equalsIgnoreCase("address_as"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLADDAS";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}
					else if (childNodeName.equalsIgnoreCase("eff_from"))
					{
						effDate = genericUtility.getColumnValue("eff_from",dom);

						Timestamp timestamp = new Timestamp(System.currentTimeMillis());
						if ( effDate == null || effDate.trim().length() == 0 )
						{
							errCode = "NULLEFFDT";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							/*
							java.util.Date sDate = simpleDateFormat.parse(effDate);
							java.util.Date currDate = simpleDateFormat.parse(simpleDateFormat.format(timestamp).toString());
							if(  sDate.before(currDate) && editFlag != null && "A".equalsIgnoreCase(editFlag))
							{
								errCode = "INVEFDATE";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							if( editFlag != null && "E".equalsIgnoreCase(editFlag))
							{
								String tranDateStr = genericUtility.getColumnValue("tran_date",dom);
								if(tranDateStr != null && tranDateStr.trim().length() > 0 )
								{
									java.util.Date tranDate = simpleDateFormat.parse(tranDateStr);
									if (sDate.before(tranDate) )
									{
										errCode = "INVEFDATE";
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
									}
								}

							}
							*/
						}
					}
					/*
					else if(childNodeName.equalsIgnoreCase("status"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSTAT";
							break;
						}
					}
					*/
					else if("D".equalsIgnoreCase(custType) && childNodeName.equalsIgnoreCase("qualification"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLQUAL";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							qualification = genericUtility.getColumnValue("qualification",dom);

							String qualMulti[] = qualification.split(",");

							for(int i = 0; i < qualMulti.length; i++)
							{
								qualStrg = qualMulti[i].trim().toLowerCase();
								sql = "select count(1) from qualification where lower(trim(qlf_code))=?";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,qualStrg);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if(cnt == 0)
								{
									errCode = "INVQUALCD";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					}
					else if("D".equalsIgnoreCase(custType) && childNodeName.equalsIgnoreCase("speciality_descr"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "VSPLDESC";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							speciality = checkNull(genericUtility.getColumnValue("speciality_descr",dom));

							String splMulti[]= speciality.split(",");

							for(int i =0; i < splMulti.length ; i++)
							{
								specialStrg= splMulti[i].trim().toLowerCase();
								sql = "select count(1) from speciality where lower(trim(descr))=?";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,specialStrg);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if(cnt == 0)
								{
									errCode = "INVSPEDES";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("class_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULCLSCODE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							classCode = checkNull(genericUtility.getColumnValue("class_code", dom));
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							sql = "select count(1) from strg_cust_class where class_code = ? and cust_type=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,classCode);
							pstmt.setString(2,custTypeDom);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVCLASSCD";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					else if("D".equalsIgnoreCase(custType) && childNodeName.equalsIgnoreCase("no_visit"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLVISIT";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							noVisit = checkNull(genericUtility.getColumnValue("no_visit", dom));
							isNumber = checkNumeric( noVisit );
							System.out.println("isNumber =["+isNumber+"]");
							if ( !isNumber )
							{
								errCode = "INVAVISIT";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}

					else if(childNodeName.equalsIgnoreCase("sex"))
					{
						gender = checkNull(genericUtility.getColumnValue("sex", dom));

						if( gender.trim().length() > 0 && !("M".equalsIgnoreCase(gender) || "F".equalsIgnoreCase(gender)) )
						{
							errCode = "INVGENDER";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}
					else if(childNodeName.equalsIgnoreCase("locality_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLOCCODE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom));
							sql = "select count(1) from locality where locality_code = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,localityCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "LOCNOTEXTS";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					/*
					else if(childNodeName.equalsIgnoreCase("state_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSTATE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							stateCode = checkNull(genericUtility.getColumnValue("state_code", dom));
							sql = "select count(*) from state where state_code= ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,stateCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVSTATE";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}*/
					else if(childNodeName.equalsIgnoreCase("stan_type"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSTNTYP";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							String stanType = checkNull(genericUtility.getColumnValue("stan_type", dom));
							stanType = stanType.trim().toLowerCase();
							sql = "select count(1) from stantype where lower(trim(stan_type)) = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,stanType);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVSTANTYP";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					//Commented by kailash on 13-12-18 as per mesmer requirement[start]
					/*else if(childNodeName.equalsIgnoreCase("pin"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLPIN";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}*/
					//Commented by kailash on 13-12-18 as per mesmer requirement[end]
					/*
					else if(childNodeName.equalsIgnoreCase("city"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLCITY";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}*/
					//Added by kailash on 05-12-18 [start]
					else if(childNodeName.equalsIgnoreCase("reg_no"))
					{
						String regNo = checkNull(genericUtility.getColumnValue("reg_no", dom));
						String transactioId = checkNull(genericUtility.getColumnValue("tran_id", dom));
						System.out.println("regNo659::["+regNo+"]transactioId["+transactioId+"]");
						if( childNode.getFirstChild() != null )
						{
							sql = "select count(1) from strg_customer where reg_no = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,regNo);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								System.out.println("cnt612["+cnt+"]");
							}
							if (cnt == 0)
							{
								sql = "select count(1) from strgcust_upload where reg_no = ? and tran_id <> ?";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,regNo);
								pstmt.setString(2,transactioId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									System.out.println("cnt>>>>["+cnt+"]");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
							}

							if(cnt > 0)
							{
								errCode = "DUPPREGNO";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
							else if(cnt==0 && regNo.length() > 5) 							//added by mrunalini sinkar on 11-feb-2019 for reg_no validation(start)
							{

								System.out.println("inside the condtion");
								String councilNo= regNo.substring(0, 5);
								int count =0;
								sql="SELECT COUNT(*) AS COUNT FROM GENCODES WHERE FLD_NAME='REG_NO' AND MOD_NAME='W_WSFA_STRG_CUSTOMER' AND FLD_VALUE =? ";
								
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,councilNo);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count =  rs.getInt("COUNT");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(count == 0)
								{
									errCode = "INVREGNO";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									
								}
							}
							//added by mrunalini sinkar on 11-feb-2019 for reg_no validation(end)

							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close(); 
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("age"))
					{
						String age = checkNull(genericUtility.getColumnValue("age", dom));
						System.out.println("Age is ch do::["+age+"]");
						System.out.println("childNode.getFirstChild()::["+childNode.getFirstChild()+"]");
						if( childNode.getFirstChild() != null && age.trim().length()>3)
						{
							System.out.println("Inside age is not null in ch do");
							errCode = "INVSCAGE";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}//if childnode not null
					}//age val
					//Added by kailash on 05-12-18 [end]
				}
				break;
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);

					errString = getErrorString(errFldName, errCode, userId);

					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));

						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			System.out.println("xmlString::"+xmlString);
			System.out.println("xmlString1::"+xmlString1);
			System.out.println("xmlString2::"+xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [DrchemistUpload][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String stateCode="";
		String sql = "";
		String salesPers="";
		String spName= "";
		String localityDes="";
		String stateName="";
		String localityCode="";
		String custTypeDes="";
		String custType="";
		String classCode="";
		String classCodeDes="";
		int currentFormNo = 0;
		SimpleDateFormat simpleDateFormat = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		ConnDriver connDriver = new ConnDriver();


		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by kailash on 29-nov-18.
			conn = getConnection(); //Added by kailash on 29-nov-18.
			conn.setAutoCommit(false);
			connDriver = null;

			String userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><Header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></Header>");
			valueXmlString.append("<Detail1>");
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			String currDate = simpleDateFormat.format(timestamp);

			System.out.println("currentColumn =["+currentColumn+"]");

			if(currentColumn.trim().equalsIgnoreCase("itm_default"))
			{
				valueXmlString.append("<tran_date>").append("<![CDATA[" + currDate +"]]>").append("</tran_date>");
				valueXmlString.append("<load_status>").append("N").append("</load_status>");
				valueXmlString.append("<loaded_by>").append("<![CDATA[" + userId +"]]>").append("</loaded_by>");
				valueXmlString.append("<loaded_on>").append("<![CDATA[" + currDate +"]]>").append("</loaded_on>");
			}
			else if(currentColumn.trim().equalsIgnoreCase("sales_pers"))
			{
				salesPers = genericUtility.getColumnValue("sales_pers", dom);
				sql = "select sp_name from sales_pers where sales_pers = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					spName = checkNull(rs.getString("sp_name"));
				}
				valueXmlString.append("<sp_name>").append("<![CDATA[" + spName +"]]>").append("</sp_name>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			/*
			else if(currentColumn.trim().equalsIgnoreCase("cust_type_descr"))
			{
				custTypeDes = checkNullAndTrim(genericUtility.getColumnValue("cust_type_descr", dom));
				if( custTypeDes.equalsIgnoreCase("CHEMIST"))
				{
					valueXmlString.append("<cust_type>").append("C").append("</cust_type>");

				}
				else if( custTypeDes.equalsIgnoreCase("DOCTOR"))
				{
					valueXmlString.append("<cust_type>").append("D").append("</cust_type>");
				}
				else
				{
					valueXmlString.append("<cust_type>").append("").append("</cust_type>");
				}

			}*/
			else if(currentColumn.trim().equalsIgnoreCase("class_code_descr"))
			{
				custType = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
				classCodeDes = checkNullAndTrim(genericUtility.getColumnValue("class_code_descr", dom));

				if ( classCodeDes.length() > 0 )
				{
					classCodeDes = classCodeDes.toLowerCase();
				}
				if(custType.length() == 0 )
				{
					custTypeDes = checkNullAndTrim(genericUtility.getColumnValue("cust_type_descr", dom));
					if( custTypeDes.equalsIgnoreCase("CHEMIST"))
					{
						custType = "C";
					}
					else if( custTypeDes.equalsIgnoreCase("DOCTOR"))
					{
						custType = "D";
					}
				}

				sql = "select class_code from strg_cust_class where lower(trim(class_code_descr)) = ? and cust_type = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,classCodeDes);
				pstmt.setString(2,custType);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					classCode = checkNull(rs.getString("class_code"));
				}
				System.out.println("class_code["+classCode+"]custType["+custType+"]");
				valueXmlString.append("<class_code>").append("<![CDATA["+classCode+"]]>").append("</class_code>");
				valueXmlString.append("<cust_type>").append("<![CDATA["+custType+"]]>").append("</cust_type>");//Added by kailash on 03-12-18 for solivng cust type issue.
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

			}
			else if(currentColumn.trim().equalsIgnoreCase("locality_descr"))
			{
				localityDes = checkNullAndTrim(genericUtility.getColumnValue("locality_descr", dom));
				if ( localityDes.length() > 0 )
				{
					localityDes = localityDes.toLowerCase();
				}

				sql = "select locality_code from locality where lower(trim(descr)) = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,localityDes);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCode = checkNull(rs.getString("locality_code"));
				}
				valueXmlString.append("<locality_code>").append("<![CDATA["+localityCode+"]]>").append("</locality_code>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

			}
			/*
			else if(currentColumn.trim().equalsIgnoreCase("state_name"))
			{
				stateName = checkNullAndTrim(genericUtility.getColumnValue("state_name", dom));
				if ( stateName.length() > 0 )
				{
					stateName = stateName.toLowerCase();
				}

				sql = "select state_code from state where lower(trim(descr)) = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,stateName);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					stateCode = checkNull(rs.getString("state_code"));
				}
				valueXmlString.append("<state_code>").append("<![CDATA[STATECODE]]>").append("</state_code>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

			}
			*/


			valueXmlString.append("</Detail1>");
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null)
				{
					if(rs != null)
						rs.close();
					if(pstmt != null)
						pstmt.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		System.out.println("valueXmlString ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}

	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}
	private String checkNullAndTrim(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value.trim();
	}
	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++)
		{
			if( !Character.isDigit(cArray[i]) )
			{
				isNumber = false;
			}
		}
		return isNumber;
	}
}