package com.a3spl.omnifin.leadSales.repository;

import com.a3spl.omnifin.model.BranchDtl;
import com.a3spl.omnifin.model.BranchDtlLead;
import com.a3spl.omnifin.model.ComIndustryM;
import com.a3spl.omnifin.model.CrLeadDtl;
import com.a3spl.omnifin.model.LoanPurposeDtl;
import com.a3spl.omnifin.model.SourceDtl;
import com.a3spl.omnifin.model.UserDtl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface LeadCapturingRepository extends JpaRepository<CrLeadDtl, Integer> {
	@Query(value = "SELECT LD.LEAD_ID,BR.BRANCH_DESC,DATE_FORMAT(LEAD_GENERATION_DATE,'%d-%m-%Y'),PRD.PRODUCT_DESC,CUSTOMER_NAME,SCM.SCHEME_DESC,GM.DESCRIPTION, (SELECT USER_NAME FROM SEC_USER_M WHERE USER_ID= :loginUserId) USER_NAME,LD.SALES_LEAD_ID,S.STATE_DESC,LD.EXISTING_CUSTOMER FROM CR_LEAD_DTL LD INNER JOIN COM_BRANCH_M BR ON LD.NEAREST_BRANCH=BR.BRANCH_ID INNER JOIN CR_SCHEME_M SCM ON SCM.SCHEME_ID=LD.SCHEME INNER JOIN CR_PRODUCT_M PRD ON PRD.PRODUCT_ID=LD.PRODUCT LEFT JOIN COM_STATE_M S ON S.STATE_ID = BR.STATE_ID INNER JOIN GENERIC_MASTER GM ON GM.VALUE = LD.SOURCE AND GM.GENERIC_KEY='SOURCE_TYPE' AND GM.REC_STATUS='A' WHERE LD.REC_STATUS='P' AND LD.MAKER_ID= :loginUserId ORDER BY LD.LEAD_ID DESC,LD.REC_STATUS", nativeQuery = true)
	List<Object[]> getLeadCapturingList(@Param("loginUserId") String paramString);

	@Query(value = "SELECT LD.BRANCH_ID,LD.SOURCE_CODE,LD.SOURCE_EXECUTIVE_PHONE,LD.LEAD_GENERATION_CITY,LD.ALLOCATED_BRANCH,LD.NEAREST_BRANCH_DISTANCE,LD.SOURCE_TYPE,LD.SOURCE,LD.SOURCE_DESCRIPTION_ID,LD.SOURCE_DESCRIPTION,LD.PRODUCT,LD.SCHEME,LD.LOAN_TYPE,LD.AMOUNT_REQUIRED,LD.LOAN_TENURE FROM CR_LEAD_DTL LD WHERE LD.LEAD_ID= :leadId", nativeQuery = true)
	List<Object[]> getLeadLoanList(@Param("leadId") Integer paramInteger);

	@Query(" SELECT DISTINCT new com.a3spl.omnifin.model.UserDtl(USR.userId,USR.userName,SUB.branchId) FROM SecUserAccessM SUA JOIN SecRoleAccessM SRA ON INSTR(CONCAT(char(39),SUA.roleId,char(39)),CONCAT(char(39),SRA.roleId,char(39)))>0 AND SRA.functionId= :functionId JOIN SecUserM USR ON(USR.userId=SUA.userId AND USR.recStatus='A') JOIN SecUserBranchDtl SUB ON(SUB.userId=USR.userId AND USR.recStatus='A') WHERE SUA.recStatus='A' AND SRA.recStatus='A'")
	List<UserDtl> getUser(@Param("functionId") Integer paramInteger);

	@Query(" SELECT DISTINCT new com.a3spl.omnifin.model.UserDtl(USR.userId,USR.userName,SUB.branchId) FROM SecUserAccessM SUA JOIN SecRoleAccessM SRA ON INSTR(CONCAT(char(39),SUA.roleId,char(39)),CONCAT(char(39),SRA.roleId,char(39)))>0 AND SRA.functionId= :functionId JOIN SecUserM USR ON(USR.userId=SUA.userId AND USR.recStatus='A') JOIN SecUserBranchDtl SUB ON(SUB.userId=USR.userId AND USR.recStatus='A') WHERE SUA.recStatus='A' AND SRA.recStatus='A' AND SUB.branchId= :branchId  ")
	List<UserDtl> getBranchUser(@Param("functionId") Integer paramInteger1, @Param("branchId") Integer paramInteger2);

	@Query("select userDefBranch from SecUserM where userId= :userId")
	Integer getDefaultBranch(@Param("userId") String paramString);

	@Query("select userPhone1 from SecUserM where userId= :userId")
	String getDefaultContactNo(@Param("userId") String paramString);

//	@Query("SELECT new com.a3spl.omnifin.model.BranchDtl(a.branchId,b.branchDesc) FROM SecUserBranchDtl a JOIN ComBranchM b on(b.branchId=a.branchId and b.recStatus='A' and a.recStatus='A') WHERE a.userId= :userId ")
//	List<BranchDtl> getBranchList(@Param("userId") String paramString);
//
//	@Query("SELECT new com.a3spl.omnifin.model.BranchDtlLead(a.branchId,b.branchDesc) FROM SecUserBranchDtl a JOIN ComBranchM b on(b.branchId=a.branchId and b.recStatus='A' and a.recStatus='A') WHERE a.userId= :userId ")
//	List<BranchDtlLead> getBranchListLead(@Param("userId") String paramString);
	//Added by  amol s on 03-dec 24 , to add validation of branchStatus --strt
	// Added by Amol S to add-- for  getBranchList
	@Query("SELECT new com.a3spl.omnifin.model.BranchDtl(a.branchId, b.branchDesc) FROM SecUserBranchDtl a JOIN ComBranchM b ON (b.branchId = a.branchId AND b.recStatus = 'A' AND a.recStatus = 'A' AND (b.branchStatus = 'A' OR b.branchStatus IS NULL) ) WHERE a.userId = :userId")
	List<BranchDtl> getBranchList(@Param("userId") String paramString);

	// added by amol s --for getBranchListLead
	@Query("SELECT new com.a3spl.omnifin.model.BranchDtlLead(a.branchId, b.branchDesc) FROM SecUserBranchDtl a JOIN ComBranchM b ON (b.branchId = a.branchId AND b.recStatus = 'A' AND a.recStatus = 'A' AND (b.branchStatus = 'A' OR b.branchStatus IS NULL)) WHERE a.userId = :userId")
	List<BranchDtlLead> getBranchListLead(@Param("userId") String paramString);
	//Added by  amol s on 03-dec 24 , to add validation of branchStatus --end



	@Query(value = "SELECT GM.VALUE,GM.DESCRIPTION FROM SEC_USER_M USR JOIN GENERIC_MASTER GM ON INSTR(CONCAT(CHAR(124),USR.MAPPED_LEVEL,CHAR(124)),CONCAT(CHAR(124),GM.VALUE,CHAR(124)))>0 AND GM.GENERIC_KEY='LEVELS' AND GM.REC_STATUS='A' WHERE USR.USER_ID=:userId", nativeQuery = true)
	List<Object[]> getRole(@Param("userId") String paramString);

	@Query(value = "SELECT USR.USER_ID,USR.USER_NAME FROM SEC_USER_M USR JOIN SEC_USER_BRANCH_DTL USR_BR ON(USR.USER_ID=USR_BR.USER_ID AND USR_BR.REC_STATUS='A') WHERE USR.REC_STATUS='A' AND INSTR(CONCAT(CHAR(124),USR.MAPPED_LEVEL,CHAR(124)),:code)>0 AND USR_BR.BRANCH_ID=:branchId UNION SELECT USRM.USER_ID,USRM.USER_NAME FROM SEC_USER_M USR JOIN SEC_USER_M USRM ON USR.USER_REPORTING_TO=USRM.USER_ID WHERE USR.USER_ID=:userId", nativeQuery = true)
	List<Object[]> getLeadRM(@Param("branchId") String paramString1, @Param("userId") String paramString2,
			@Param("code") String paramString3);

	@Query(value = "SELECT USRM.USER_ID,USRM.USER_NAME FROM SEC_USER_M USR JOIN SEC_USER_M USRM ON USR.USER_REPORTING_TO=USRM.USER_ID WHERE USR.USER_ID=:userId", nativeQuery = true)
	List<Object[]> getUserIo(@Param("userId") String paramString);

	@Query(" SELECT new com.a3spl.omnifin.model.SourceDtl(concat(bpId,''),bpName) FROM CrBpDtl WHERE bpType='BUL' AND recStatus='A' ")
	List<SourceDtl> getBuilder();

	@Query(" SELECT new com.a3spl.omnifin.model.SourceDtl(A.userId,A.userName)  FROM SecUserM A  JOIN SecUserLevelDtl B ON A.userId=B.userId  WHERE B.levelId='BRANCH' AND A.recStatus='A' ")
	List<SourceDtl> getTelecaller();

	@Query(" SELECT new com.a3spl.omnifin.model.SourceDtl(concat(A.customerId,''),A.customerName)  FROM GcdCustomerM A ")
	List<SourceDtl> getExistingCustomer();

	@Query("SELECT new com.a3spl.omnifin.model.SourceDtl(concat(cdm.dealerId,''),cdm.dealerDesc,concat(cdm.dealerDesc,'-','(', cdm.dealerId, ')' ))  FROM CrDsaDealerM cdm  JOIN CrDsaDealerBranchM cdbm on cdbm.dealerId=cdm.dealerId and cdbm.branchId=:branchId  WHERE cdm.bpType='SU' AND cdm.recStatus='A' ")
	List<SourceDtl> getDealer(@Param("branchId") String paramString);

	@Query(" SELECT new com.a3spl.omnifin.model.SourceDtl(userId,userName)  FROM SecUserM  WHERE recStatus='A' ")
	List<SourceDtl> getDirect();

	@Query("SELECT new com.a3spl.omnifin.model.SourceDtl(concat(cdm.dealerId,''),cdm.dealerDesc,concat(cdm.dealerDesc,'-','(', cdm.dealerId, ')' ))  FROM CrDsaDealerM cdm  JOIN CrDsaDealerBranchM cdbm on cdbm.dealerId=cdm.dealerId and cdbm.branchId=:branchId  WHERE cdm.bpType='DS' AND cdm.recStatus='A' ")
	List<SourceDtl> getDSA(@Param("branchId") String paramString);

	@Query("SELECT new com.a3spl.omnifin.model.SourceDtl(concat(cdm.dealerId,''),cdm.dealerDesc,concat(cdm.dealerDesc,'-','(', cdm.dealerId, ')' ))  FROM CrDsaDealerM cdm  JOIN CrDsaDealerBranchM cdbm on cdbm.dealerId=cdm.dealerId and cdbm.branchId=:branchId  WHERE cdm.bpType='CO' AND cdm.recStatus='A' ")
	List<SourceDtl> getConnector(@Param("branchId") String paramString);

	@Query("select new com.a3spl.omnifin.model.LoanPurposeDtl(g.code,g.description,g.parentValue) from GenericMaster g where g.genericKey='LOAN_PURPOSE' AND g.recStatus= 'A'")
	List<LoanPurposeDtl> getLoanPurpose();

	@Query(value = " select L.LEAD_ID,L.EXISTING_CUSTOMER,L.RELATIONSHIP_SINCE,L.CUSTOMER_TYPE,L.CONSTITUTION,L.CUSTOMER_NAME,L.FIRST_NAME,L.MIDDLE_NAME, L.LAST_NAME, DATE_FORMAT(L.CUSTOMER_DOB,'%Y-%m-%d')CUSTOMER_DOB,L.FATHER_HUSBAND_NAME,L.PASSPORT_NUMBER,L.DRIVING_LICENSE,L.VOTER_ID,L.PAN,L.AADHAR_NO,L.EDU_DETAIL, L.GROUP_ID,L.GROUP_TYPE, L.BUSINESS_SEGMENT,L.INDUSTRY_ID,L.SUB_INDUSTRY_ID,L.REGISTRATION_NO,L.TURNOVER,L.GROUP_DESC FROM CR_LEAD_DTL L WHERE L.LEAD_ID= :leadId", nativeQuery = true)
	List<Object[]> getCustomerList(@Param("leadId") Integer paramInteger);

	@Modifying
	@Query(value = "UPDATE CR_LEAD_DTL SET EXISTING_CUSTOMER=:existingCustomer,RELATIONSHIP_SINCE=:relationshipSince, CUSTOMER_TYPE=:customerType, CONSTITUTION=:constitution, CUSTOMER_NAME=:customerName, FIRST_NAME=:firstName, MIDDLE_NAME=:middleName,LAST_NAME=:lastName,CUSTOMER_DOB=:customerDob,FATHER_HUSBAND_NAME=:fatherHusbandName, PASSPORT_NUMBER=:passportNumber, DRIVING_LICENSE=:drivingLicense,VOTER_ID=:voterId, PAN=:pan, AADHAR_NO=:aadharNo, EDU_DETAIL=:eduDetail,GROUP_ID=:groupId,GROUP_TYPE=:groupType,BUSINESS_SEGMENT=:businessSegment, INDUSTRY_ID=:industryId,  SUB_INDUSTRY_ID=:subIndustryId,REGISTRATION_NO=:registrationNo, TURNOVER=:turnover, GROUP_DESC=:groupDesc where LEAD_ID=:leadId", nativeQuery = true)
	int saveCustomerDetail(@Param("existingCustomer") String existingCustomer, @Param("relationshipSince") Integer relationshipSince, @Param("customerType") String customerType, @Param("constitution") String constitution,
			@Param("customerName") String customerName, @Param("firstName") String firstName, @Param("middleName") String middleName, @Param("lastName") String lastName, @Param("customerDob") String customerDob,
			@Param("fatherHusbandName") String fatherHusbandName, @Param("passportNumber") String passportNumber, @Param("drivingLicense") String drivingLicense, @Param("voterId") String voterId, @Param("pan") String pan,
			@Param("aadharNo") String aadharNo, @Param("eduDetail") String eduDetail, @Param("groupId") Integer groupId, @Param("groupType") String groupType,
			@Param("businessSegment") String businessSegment, @Param("industryId") Integer industryId, @Param("subIndustryId") Integer subIndustryId, @Param("registrationNo") String registrationNo,
			@Param("turnover") BigDecimal turnover, @Param("groupDesc") String groupDesc, @Param("leadId") Integer leadId);

	@Query(value = "SELECT INDUSTRY_ID,INDUSTRY_DESC FROM COM_INDUSTRY_M WHERE REC_STATUS='A' ", nativeQuery = true)
	List<ComIndustryM> getIndustryName();

	@Query(value = "select a.lead_Id,a.address_Line1,a.address_Line2,a.address_Line3,a.pincode,a.tahsil, a.district,a.country,a.state, a.primary_Phone,a.landmark,a.no_Of_Years, a.no_Of_Months,a.plot_No,a.town_Desc,a.taluka_Desc, a.alternate_Phone,a.email_Id, a.alternate_Mail_Id,a.floor_No,a.ownership,a.area_Code, e.DESCRIPTION,d.district_Desc, s.state_Desc,c.country_Desc,a.address_Type, (select description from Generic_Master g where g.generic_Key='ADDRESS_TYPE' and g.value= a.address_Type ) as ADDRESS_TYPE_DESC from Cr_Lead_Dtl a JOIN Com_Tehsil_M e ON e.ID=a.tahsil and e.status='A' JOIN com_district_M d ON d.district_Id=a.district and d.rec_Status='A' JOIN Com_State_M s ON s.state_Id=a.state and s.rec_Status='A' JOIN Com_Country_M c ON c.country_Id=a.country and c.rec_Status='A' where a.lead_Id=:leadId ", nativeQuery = true)
	List<Object[]> fetchLeadAddress(@Param("leadId") Integer leadId);

	@Modifying
	@Query(value = "update Cr_Lead_Dtl set address_Type=:addressType,address_Line1=:addressLine1, address_Line2=:addressLine2,address_Line3=:addressLine3,pincode=:pinCode, tahsil=:tehsil,district=:district,country=:country,state=:state,primary_Phone=:primaryPhone, landmark=:landmark,no_Of_Years=:noOfYears, no_Of_Months=:noOfMonths,plot_No=:plotNo, town_Desc=:townDesc,taluka_Desc=:talukaDesc,alternate_Phone=:alternatePhone, email_Id=:emailId,alternate_Mail_Id=:alternateMailId,floor_No=:floorNo,ownership=:ownership, area_Code=:areaCode where lead_Id=:leadId ", nativeQuery = true)
	int saveLeadAddress(@Param("addressType") String addressType, @Param("addressLine1") String addressLine1, @Param("addressLine2") String addressLine2, @Param("addressLine3") String addressLine3,
			@Param("pinCode") String pinCode, @Param("tehsil") String tehsil, @Param("district") Integer district, @Param("country") Integer country,
			@Param("state") Integer state, @Param("primaryPhone") String primaryPhone, @Param("landmark") String landmark, @Param("noOfYears") Integer noOfYears,
			@Param("noOfMonths") Integer noOfMonths, @Param("plotNo") String plotNo, @Param("townDesc") String townDesc, @Param("talukaDesc") String talukaDesc,
			@Param("alternatePhone") String alternatePhone, @Param("emailId") String emailId, @Param("alternateMailId") String alternateMailId, @Param("floorNo") String floorNo,
			@Param("ownership") String ownership, @Param("areaCode") String areaCode, @Param("leadId") Integer leadId);

	CrLeadDtl findByLeadId(@Param("leadId") Integer paramInteger);

	@Modifying
	@Query(value = " UPDATE CR_LEAD_DTL CLD SET CLD.ALLOCATED_BRANCH= :branchId,CLD.REC_STATUS= :recStatus,CLD.LEAD_SERVICING_RM= :userId  WHERE LEAD_ID=:leadId", nativeQuery = true)
	int updateLeadForward(@Param("branchId") Integer branchId, @Param("recStatus") String recStatus, @Param("userId") String userId, @Param("leadId") Integer leadId);

	@Query(value = "SELECT RO_ID,NEAREST_BRANCH,SOURCE_CODE,SOURCE_TYPE,MAKER_ID FROM CR_LEAD_DTL WHERE LEAD_ID=:leadId", nativeQuery = true)
	Object getLeadDtl(@Param("leadId") Integer paramInteger);

	@Modifying
	@Query("delete from StageAddressDtl where id= :addressId ")
	void deleteAddress(@Param("addressId") Integer paramInteger);
	
	//Commented and changed by Gulzar on 22OCT24 to make it inline with the LeadCapturingServiceImpl class
	/*
	@Query(value = "select b.address_Id,a.customer_Id,a.customer_Name,a.FATHER_HUSBAND_NAME,a.customer_Type,case a.customer_Type when 'I' then 'Individual' else 'Corporate' end as customerTypeDesc,d.deal_no  from cr_deal_dtl d  join Cr_Deal_Customer_Role c on (c.deal_id=d.deal_id) join Gcd_Customer_M a on c.deal_Customer_Id=a.customer_Id left join Com_Address_M b on b.bpId=a.customer_Id and b.COMMUNICATION_ADDRESS='Y'\t and a.customer_Name LIKE %:customerName%  AND a.CUSTOMER_FNAME LIKE %:firstName% AND \t a.CUSTOMER_MNAME LIKE %:middleName% AND a.CUSTOMER_LNAME LIKE %:lastName% AND \t a.CUSTMER_PAN LIKE %:pan% AND  a.PASSPORT_NUMBER LIKE %:passportNumber% AND  a.CUSTOMER_DOB LIKE %:customerDobSearch% AND  a.UID_NO LIKE %:aadharNoSearch% AND \ta.VOTER_ID LIKE %:voterSearch% AND  a.DRIVING_LICENSE LIKE %:drivingLicenceSearch% AND \t b.PRIMARY_PHONE=:mobileNo ", nativeQuery = true)
	List<Object[]> getExistingCustomerList(@Param("customerName") String paramString1,
			@Param("firstName") String paramString2, @Param("middleName") String paramString3,
			@Param("lastName") String paramString4, @Param("pan") String paramString5,
			@Param("passportNumber") String paramString6, @Param("customerDobSearch") String paramString7,
			@Param("aadharNoSearch") String paramString8, @Param("voterSearch") String paramString9,
			@Param("drivingLicenceSearch") String paramString10, @Param("mobileNo") String paramString11);
	*/
	@Query(value = "select b.address_Id,a.customer_Id,a.customer_Name,a.FATHER_HUSBAND_NAME,a.customer_Type,case a.customer_Type when 'I' then 'Individual' else 'Corporate' end as customerTypeDesc,d.deal_no  from cr_deal_dtl d  join Cr_Deal_Customer_Role c on (c.deal_id=d.deal_id) join Gcd_Customer_M a on c.deal_Customer_Id=a.customer_Id left join Com_Address_M b on b.bpId=a.customer_Id and b.COMMUNICATION_ADDRESS='Y'\t and a.customer_Name LIKE %:customerName%  AND a.CUSTOMER_FNAME LIKE %:firstName% AND \t a.CUSTOMER_MNAME LIKE %:middleName% AND a.CUSTOMER_LNAME LIKE %:lastName% AND \t a.CUSTMER_PAN LIKE %:pan% AND  a.PASSPORT_NUMBER LIKE %:passportNumber% AND  a.CUSTOMER_DOB LIKE %:customerDobSearch% AND  a.UID_NO LIKE %:aadharNoSearch% AND \ta.VOTER_ID LIKE %:voterSearch% AND  a.DRIVING_LICENSE LIKE %:drivingLicenceSearch% AND \t b.PRIMARY_PHONE=:mobileNo ", nativeQuery = true)
	List<Object[]> getExistingCustomerList();
	//Gulzar on 22OCT24 - END
	
	@Query(value = "select count(*)  from cr_deal_dtl d  join Cr_Deal_Customer_Role c on (c.deal_id=d.deal_id) join Gcd_Customer_M a on c.deal_Customer_Id=a.customer_Id join Com_Address_M b on b.bpId=a.customer_Id  where b.COMMUNICATION_ADDRESS='Y' and a.customer_Name LIKE %:customerName% AND b.PRIMARY_PHONE=:mobileNo ", nativeQuery = true)
	Integer getExistingCustomerCount(@Param("customerName") String paramString1,
			@Param("mobileNo") String paramString2);

	@Query(value = "select count(*)  from cr_deal_dtl d  join Cr_Deal_Customer_Role c on (c.deal_id=d.deal_id) join Gcd_Customer_M a on c.deal_Customer_Id=a.customer_Id and a.customer_Name LIKE %:customerName% AND a.PRIMARY_CONTACT=:mobileNo ", nativeQuery = true)
	Integer getExistingCustomerCountDtl(@Param("customerName") String paramString1,
			@Param("mobileNo") String paramString2);

	@Query(value = "select b.address_id,a.customer_Id,a.customer_Name,a.FATHER_HUSBAND_NAME,a.customer_Type,case a.customer_Type when 'I' then 'Individual' else 'Corporate' end as customerTypeDesc  from Gcd_Customer_M a  left join Com_Address_M b on b.bpId=a.customer_Id  where b.COMMUNICATION_ADDRESS='Y' and a.customer_Name LIKE %:customerName% AND a.PRIMARY_CONTACT=:mobileNo ", nativeQuery = true)
	List<Object[]> getExistingCustomerDealDtlList(@Param("customerName") String paramString1,
			@Param("mobileNo") String paramString2);

	@Query(value = "select b.address_id,a.customer_Id,a.customer_Name,a.FATHER_HUSBAND_NAME,a.customer_Type,case a.customer_Type when 'I' then 'Individual' else 'Corporate' end as customerTypeDesc  from Gcd_Customer_M a  join Com_Address_M b on b.bpId=a.customer_Id  where b.COMMUNICATION_ADDRESS='Y'\t and a.customer_Name LIKE %:customerName%  AND a.CUSTOMER_FNAME LIKE %:firstName% AND \t a.CUSTOMER_MNAME LIKE %:middleName% AND a.CUSTOMER_LNAME LIKE %:lastName% AND \t a.CUSTMER_PAN LIKE %:pan% AND  a.PASSPORT_NUMBER LIKE %:passportNumber% AND  a.CUSTOMER_DOB LIKE %:customerDobSearch% AND  a.UID_NO LIKE %:aadharNoSearch% AND \ta.VOTER_ID LIKE %:voterSearch% AND  a.DRIVING_LICENSE LIKE %:drivingLicenceSearch% AND \t b.PRIMARY_PHONE=:mobileNo", nativeQuery = true)
	List<Object[]> getExistingCustomerDealList(@Param("customerName") String paramString1,
			@Param("firstName") String paramString2, @Param("middleName") String paramString3,
			@Param("lastName") String paramString4, @Param("pan") String paramString5,
			@Param("passportNumber") String paramString6, @Param("customerDobSearch") String paramString7,
			@Param("aadharNoSearch") String paramString8, @Param("voterSearch") String paramString9,
			@Param("drivingLicenceSearch") String paramString10, @Param("mobileNo") String paramString11);

	@Query("select ''as relationshipSince,a.customerType,a.customerConstitution,a.salutation,a.customerFName,a.customerMname,a.customerLname,a.fatherHusbandName,a.motherName,a.customerDOB,a.maritalStatus,a.gender,a.passportNumber,a.drivingLicense,a.voterId,a.customerPAN,a.uidNo,a.casteCategory,a.eduDetail,a.primaryContact,a.customerEmail,a.alternateEmail1,a.customerName,a.customerGroupType,a.customerGroupId,a.customerRegistrationNo,a.cusotomerBusinessSegment,a.cusotmerIndustry,a.cusomterSubIndustry,b.addressType,b.addressLine1,b.plotNo,b.addressLine2,b.addressLine3,b.floorNo,b.landmark,b.pinCode,b.tehsil,teh.tehsilDecription,b.district,dist.districtDesc,b.state,st.stateDesc,b.country,cnt.countryDesc,b.noOfYears,b.noOfMonths,b.communicationAddress,b.addressDetail,a.customerStatus,a.customerId from GcdCustomerM a join ComAddressM b on b.bpId=a.customerId left join CrDealCustomerRole c on c.dealCustomerId=a.customerId join ComTehsilM teh on teh.tehsilCode=b.tehsil join ComDistrictM dist on dist.districtId=b.district join ComStateM st on st.stateId=b.state join ComCountryM cnt on cnt.countryId=b.country left join CrLeadDtl ld on ld.customerId=a.customerId and ifnull(ld.contactPerson,'')<>'' where a.customerId= :customerId and b.addressId= :addressId")
	List<Object[]> getExistingCustomerDtl(@Param("customerId") Integer paramInteger1,
			@Param("addressId") Integer paramInteger2);

	@Query("select ''as relationshipSince,a.customerType,a.customerConstitution,a.salutation,a.customerFName,a.customerMname,a.customerLname,a.fatherHusbandName,a.motherName,a.customerDOB,a.maritalStatus,a.gender,a.passportNumber,a.drivingLicense,a.voterId,a.customerPAN,a.uidNo,a.casteCategory,a.eduDetail,a.primaryContact,a.customerEmail,a.alternateEmail1,a.customerName,a.customerGroupType,a.customerGroupId,a.customerRegistrationNo,a.cusotomerBusinessSegment,a.cusotmerIndustry,a.cusomterSubIndustry,b.addressType,b.addressLine1,b.plotNo,b.addressLine2,b.addressLine3,b.floorNo,b.landmark,b.pinCode,b.tehsil,teh.tehsilDecription,b.district,dist.districtDesc,b.state,st.stateDesc,b.country,cnt.countryDesc,b.noOfYears,b.noOfMonths,b.communicationAddress,b.addressDetail,a.customerStatus,a.customerId from GcdCustomerM a left join ComAddressM b on b.bpId=a.customerId left join CrDealCustomerRole c on c.dealCustomerId=a.customerId left join ComTehsilM teh on teh.tehsilCode=b.tehsil left join ComDistrictM dist on dist.districtId=b.district left join ComStateM st on st.stateId=b.state left join ComCountryM cnt on cnt.countryId=b.country left join CrLeadDtl ld on ld.customerId=a.customerId and ifnull(ld.contactPerson,'')<>'' where a.customerId= :customerId")
	List<Object[]> getExistingDealCustomerDtl(@Param("customerId") Integer paramInteger);

	@Modifying
	@Query("update CrLeadDtl set branchId=:branchId,roId=:roId,primaryPhone=:contactNo,leadGenerationCity=:leadGenerationCity, allocatedBranch=:nearestBranch,nearestBranch=:nearestBranch,nearestBranchDistance=:nearestBranchDistance,sourceType=:generatedBy, source=:dealSourceType,sourceId=:dealSourceId,sourceDescriptionId=:dealSourceId,sourceDescription=:dealSourceId, product=:product,scheme=:scheme,loanPurposeId=:loanPurpose,loanType=:loanType,amountRequired=:amountRequired, dealFinalRate=:finalRate,loanTenure=:tenure,tenureInDays= :tenureInDays,monthlyIncome=:monthlyIncome,obligation=:obligation,applicationForm=:applicationForm,turnover=:turnover,groupId=:groupId, assetDescription=:assetDescription  where leadId=:leadId ")
	int UpdateLeadDetail(@Param("branchId") Integer paramInteger1, @Param("roId") String paramString1,
			@Param("contactNo") String paramString2, @Param("leadGenerationCity") String paramString3,
			@Param("nearestBranch") Integer paramInteger2, @Param("nearestBranchDistance") String paramString4,
			@Param("generatedBy") String paramString5, @Param("dealSourceType") String paramString6,
			@Param("dealSourceId") String paramString7, @Param("product") String paramString8,
			@Param("scheme") Integer paramInteger3, @Param("loanPurpose") String paramString9,
			@Param("loanType") String paramString10, @Param("amountRequired") BigDecimal paramBigDecimal1,
			@Param("finalRate") BigDecimal paramBigDecimal2, @Param("tenure") Integer paramInteger4,
			@Param("tenureInDays") Integer paramInteger5, @Param("monthlyIncome") BigDecimal paramBigDecimal3,
			@Param("obligation") BigDecimal paramBigDecimal4, @Param("applicationForm") String paramString11,
			@Param("turnover") BigDecimal paramBigDecimal5, @Param("groupId") Integer paramInteger6,
			@Param("leadId") Integer paramInteger7, @Param("assetDescription") String paramString12);

	@Query(value = "SELECT D.LEVEL_ID,U.USER_ID,USER_NAME,USER_PHONE1,USER_DEF_BRANCH,B.BRANCH_DESC  FROM SEC_USER_M U LEFT OUTER JOIN COM_BRANCH_M B ON B.BRANCH_ID=U.USER_DEF_BRANCH  LEFT OUTER JOIN SEC_USER_LEVEL_DTL  D ON  U.USER_ID=D.USER_ID  WHERE U.USER_ID=:userId AND D.LEVEL_ID = 'RM' ", nativeQuery = true)
	List<Object[]> getRmDtl(@Param("userId") String paramString);

	@Query(value = "SELECT D.LEVEL_ID,U.USER_REPORTING_TO,V.USER_NAME,V.USER_PHONE1,V.USER_DEF_BRANCH,B.BRANCH_DESC  FROM SEC_USER_M U  LEFT JOIN SEC_USER_M V ON V.USER_ID=U.USER_REPORTING_TO  LEFT OUTER JOIN COM_BRANCH_M B ON B.BRANCH_ID=U.USER_DEF_BRANCH  LEFT OUTER JOIN SEC_USER_LEVEL_DTL  D ON  U.USER_ID=D.USER_ID  WHERE U.USER_ID=:userId AND D.LEVEL_ID = 'RO' ", nativeQuery = true)
	List<Object[]> getRoDtl(@Param("userId") String paramString);

	@Query(value = "SELECT U.USER_REPORTING_TO  FROM SEC_USER_M U  LEFT JOIN SEC_USER_M V ON V.USER_ID=U.USER_REPORTING_TO  LEFT OUTER JOIN COM_BRANCH_M B ON B.BRANCH_ID=U.USER_DEF_BRANCH  LEFT OUTER JOIN SEC_USER_LEVEL_DTL  D ON  U.USER_ID=D.USER_ID  WHERE U.USER_ID=:userId AND D.LEVEL_ID = 'RO' ", nativeQuery = true)
	String getRoDtlRepostingUSer(@Param("userId") String paramString);

	@Query(value = "SELECT 'VENDOR' AS LEVEL_ID,CDDM.DEALER_ID,CDDM.DEALER_DESC,SU.USER_NAME FROM CR_DSA_DEALER_M CDDM  LEFT OUTER JOIN CR_DSA_DEALER_USER_M DDUM ON DDUM.DEALER_ID=CDDM.DEALER_ID  LEFT JOIN SEC_USER_M SU ON DDUM.USER_ID=SU.USER_ID  WHERE BP_TYPE='SU' AND CDDM.REC_STATUS<>'X' AND DDUM.USER_ID=:userId ", nativeQuery = true)
	List<Object[]> getVendorDtl(@Param("userId") String paramString);

	@Query(value = "SELECT IF(D.LEVEL_ID,'BRANCH','TELLECALLER')AS LEVEL_ID,U.USER_DEF_BRANCH,B.BRANCH_DESC,U.USER_ID,USER_NAME,USER_PHONE1   FROM SEC_USER_M U LEFT OUTER JOIN COM_BRANCH_M B ON B.BRANCH_ID=U.USER_DEF_BRANCH  LEFT OUTER JOIN SEC_USER_LEVEL_DTL  D ON  U.USER_ID=D.USER_ID  WHERE U.USER_ID=:userId AND D.LEVEL_ID='BRANCH' ", nativeQuery = true)
	List<Object[]> getTelleCallerDtl(@Param("userId") String paramString);

	@Query(value = "SELECT 'OTHER' AS LEVEL_ID,U.USER_DEF_BRANCH,B.BRANCH_DESC,U.USER_ID,U.USER_PHONE1,TH.USER_NAME  FROM SEC_USER_M U LEFT OUTER JOIN COM_BRANCH_M B ON B.BRANCH_ID=U.USER_DEF_BRANCH   LEFT OUTER JOIN SEC_USER_M TH on TH.USER_ID=U.USER_REPORTING_TO WHERE U.USER_ID=:userId ", nativeQuery = true)
	List<Object[]> getOtherDtl(@Param("userId") String paramString);

	@Query(value = "SELECT PARAMETER_VALUE  FROM PARAMETER_MST WHERE PARAMETER_KEY='BUSINESS_DATE' ", nativeQuery = true)
	String getBusinessDate();

	@Modifying
	@Query(value = "UPDATE CR_LEAD_DTL SET ALLOCATED_BRANCH = :branchId,LEAD_SERVICING_RM= :userId,  REC_STATUS =:recStatus ,ALLOCATION_DATE= :businessDate  where LEAD_ID= :leadId  ", nativeQuery = true)
	int saveLeadAllocationForRm(@Param("branchId") Integer branchId, @Param("userId") String userId, @Param("businessDate") String businessDate, @Param("leadId") Integer leadId,
			@Param("recStatus") String recStatus);

	@Modifying
	@Query(value = "UPDATE CR_LEAD_DTL SET ALLOCATED_BRANCH = :branchId,LEAD_SERVICING_RM= :userId,LEAD_GENERATED_RM = :rmUserId,  REC_STATUS =:recStatus  where LEAD_ID= :leadId  ", nativeQuery = true)
	int saveLeadAllocationForRo(@Param("branchId") Integer branchId, @Param("userId") String userId, @Param("rmUserId") String rmUserId, @Param("leadId") Integer leadId,
			@Param("recStatus") String recStatus);

	@Query(value = " SELECT USER_REPORTING_TO FROM SEC_USER_M U WHERE U.USER_ID=:userId AND U.REC_STATUS='A' LIMIT 1 ", nativeQuery = true)
	String getReportingTo(@Param("userId") String paramString);

	@Query(value = " SELECT BRANCH_DESC FROM COM_BRANCH_M U WHERE U.BRANCH_ID=:branchId AND U.REC_STATUS='A' LIMIT 1 ", nativeQuery = true)
	String getBranchName(@Param("branchId") Integer paramInteger);

	@Query(value = "select period_diff(date_format(STR_TO_DATE((select DATE_FORMAT(parameter_value,'%d-%m-%Y') from parameter_mst where parameter_key='BUSINESS_DATE'),'%d-%m-%Y'), '%Y%m'), date_format(MAKER_DATE, '%Y%m')) AS relatipShipMonth  from cr_deal_customer_m where customer_id=:customerId ", nativeQuery = true)
	Integer getRelationShipMonth(@Param("customerId") Integer paramInteger);

	@Query(value = " SELECT USER_NAME FROM SEC_USER_M  WHERE USER_ID=:userId and rec_status='A' ", nativeQuery = true)
	String getUsername(@Param("userId") String paramString);

	@Query(value = " SELECT TH.USER_ID   FROM SEC_USER_M U LEFT OUTER JOIN COM_BRANCH_M B ON B.BRANCH_ID=U.USER_DEF_BRANCH  LEFT OUTER JOIN SEC_USER_M TH on TH.USER_ID=U.USER_REPORTING_TO  WHERE U.USER_ID=:userId", nativeQuery = true)
	String getOtherUserId(@Param("userId") String paramString);
}
